<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Discount extends Model
{
    protected $casts = [
        'starts_at' => 'datetime',
        'ends_at' => 'datetime',
    ];

    /**
     * The attributes that aren't mass assignable.
     *
     * @var array
     */
    protected $guarded = ['id'];

    public function variations()
    {
        return $this->belongsToMany(\App\Variation::class, 'discount_variations', 'discount_id', 'variation_id');
    }



        /**
     * Return list of customer group for a business
     *
     * @param $business_id int
     * @param $prepend_none = true (boolean)
     * @param $prepend_all = false (boolean)
     * @return array
     */
    public static function forDropdown($business_id, $prepend_none = true, $prepend_all = false)
    {
        $all_discount = Discount::where('business_id', $business_id);
        $all_discount = $all_discount->pluck('name', 'id');

        //Prepend none
        if ($prepend_none) {
            $all_discount = $all_discount->prepend(__('lang_v1.none'), '');
        }

        //Prepend none
        if ($prepend_all) {
            $all_discount = $all_discount->prepend(__('report.all'), '');
        }

        return $all_discount;
    }

}
