<?php

namespace App\Http\Controllers;

use App\Account;
use App\BusinessLocation;
use App\Contact;
use App\Product;
use App\PurchaseLine;
use App\SerialNumber;
use App\ServiceWarranty;
use App\Transaction;
use App\TransactionPayment;
use App\TransactionSellLine;
use App\Warranty;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Yajra\DataTables\Facades\DataTables;
use App\Utils\TransactionUtil;
use App\Utils\BusinessUtil;
use App\Utils\ModuleUtil;





class WarrantyController extends Controller {

    protected $cashRegisterUtil;
    protected $moduleUtil;
    protected $businessUtil;
    protected $transactionUtil;

    public function __construct(BusinessUtil $businessUtil, TransactionUtil $transactionUtil, ModuleUtil $moduleUtil) {

        $this->transactionUtil = $transactionUtil;
        $this->moduleUtil = $moduleUtil;
        $this->businessUtil = $businessUtil;

    }






    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $business_id = request()->session()->get('user.business_id');

        if (request()->ajax()) {
            $warranties = Warranty::where('business_id', $business_id)
                         ->select(['id', 'name', 'description', 'duration', 'duration_type']);

            return Datatables::of($warranties)
                ->addColumn(
                    'action',
                    '<button data-href="{{action(\'App\Http\Controllers\WarrantyController@edit\', [$id])}}" class="tw-dw-btn tw-dw-btn-xs tw-dw-btn-outline tw-dw-btn-primary btn-modal" data-container=".view_modal"><i class="glyphicon glyphicon-edit"></i> @lang("messages.edit")</button>'
                 )
                 ->removeColumn('id')
                 ->editColumn('duration', function ($row) {
                     return $row->duration.' '.__('lang_v1.'.$row->duration_type);
                 })
                 ->rawColumns(['action'])
                 ->make(true);
        }

        return view('warranties.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('warranties.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $business_id = request()->session()->get('user.business_id');

        try {
            $input = $request->only(['name', 'description', 'duration', 'duration_type']);
            $input['business_id'] = $business_id;

            $status = Warranty::create($input);

            $output = ['success' => true,
                'msg' => __('lang_v1.added_success'),
            ];
        } catch (\Exception $e) {
            \Log::emergency('File:'.$e->getFile().'Line:'.$e->getLine().'Message:'.$e->getMessage());

            $output = ['success' => false,
                'msg' => __('messages.something_went_wrong'),
            ];
        }

        return $output;
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Warranty  $warranty
     * @return \Illuminate\Http\Response
     */
    public function show(Warranty $warranty)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Warranty  $warranty
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $business_id = request()->session()->get('user.business_id');

        if (request()->ajax()) {
            $warranty = Warranty::where('business_id', $business_id)->find($id);

            return view('warranties.edit')
                ->with(compact('warranty'));
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Warranty  $warranty
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $business_id = request()->session()->get('user.business_id');

        if (request()->ajax()) {
            try {
                $input = $request->only(['name', 'description', 'duration', 'duration_type']);

                $warranty = Warranty::where('business_id', $business_id)->findOrFail($id);

                $warranty->update($input);

                $output = ['success' => true,
                    'msg' => __('lang_v1.updated_success'),
                ];
            } catch (\Exception $e) {
                \Log::emergency('File:'.$e->getFile().'Line:'.$e->getLine().'Message:'.$e->getMessage());

                $output = ['success' => false,
                    'msg' => __('messages.something_went_wrong'),
                ];
            }

            return $output;
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Warranty  $warranty
     * @return \Illuminate\Http\Response
     */
    public function destroy(Warranty $warranty)
    {
        //
    }




















    public function AddwarrantyService(){
        return view('warranties.add_warranty_service');
    }
    // serial_id
    public function ListWarrantyService(){
        $serviceWarranties = DB::table('service_warranties')
                                ->join('serial_numbers', 'service_warranties.serial_id', '=', 'serial_numbers.id')
                                ->join('products', 'service_warranties.product_id', '=', 'products.id')
                                ->join('transactions', 'service_warranties.service_transaction_id', '=', 'transactions.id')
                                ->join('transaction_sell_lines', 'serial_numbers.transaction_id', '=', 'transaction_sell_lines.transaction_id')
                                ->join('sell_line_warranties', 'transaction_sell_lines.id', '=', 'sell_line_warranties.sell_line_id')
                                ->join('warranties', 'sell_line_warranties.warranty_id', '=', 'warranties.id')
                                ->join('contacts', 'transactions.contact_id', '=', 'contacts.id')
                                ->leftJoin('transaction_payments', 'transactions.id', '=', 'transaction_payments.transaction_id')
                                ->select(
                                    'service_warranties.id',
                                    'service_warranties.serial_id',
                                    'service_warranties.service_fee', 
                                    'service_warranties.status as service_status',

                                    'serial_numbers.serial_number',
                                    'serial_numbers.serial_purchase_code',
                                    'serial_numbers.is_return',

                                    'products.name as product_name', 
                                    'products.business_id',

                                    'transactions.id as service_transaction_id',
                                    'transactions.status as service_transaction_status',
                                    'transactions.payment_status as service_transaction_payment_status',
                                    'transactions.contact_id',
                                    'transactions.transaction_date',
                                    'transactions.final_total',
                                    'transactions.created_by',
                                    
                                    'transaction_sell_lines.transaction_id as sell_transaction_id',
                                    'transaction_sell_lines.quantity as sell_quantity',
                                    'transaction_sell_lines.id as sell_id',
                                    
                                    'sell_line_warranties.warranty_id',
                                    
                                    'warranties.name as warranty_name', 
                                    'warranties.description', 
                                    'warranties.duration', 
                                    'warranties.duration_type',

                                    'contacts.type as contact_type',
                                    'contacts.name as contact_name',
                                    'contacts.contact_status',

                                    'transaction_payments.id as payment_id',
                                    'transaction_payments.payment_for',
                                    'transaction_payments.account_id',
                                    'transaction_payments.amount as paid_amount',
                                    )
                                ->get();
        return view('warranties.list_warranty_service')->with(compact('serviceWarranties'));
    }
        
    public function GetWarranty(Request $request){

        $serial_number = $request->serial_number;
        $check_serialhash = SerialNumber::where('serial_number', $serial_number)->first();
        
        if (!empty($check_serialhash)) {
            
            $product_info = Product::where('id', $check_serialhash->product_id)->first();
            $purchase_info = PurchaseLine::where('serial_purchase_code', $check_serialhash->serial_purchase_code)->first();
            
            if($check_serialhash->transaction_id){
                $sell_info = TransactionSellLine::where('transaction_id', $check_serialhash->transaction_id)->first();
                $sell_transaction_info = Transaction::where('id', $check_serialhash->transaction_id)->first();
                $customer_info = Contact::where('id', $sell_transaction_info->contact_id)->first();

                $warranti_check = DB::table('sell_line_warranties')->where('sell_line_id', $sell_info->id)->exists();
          
                
                if($warranti_check){
                    $sell_warranti = DB::table('sell_line_warranties')->where('sell_line_id', $sell_info->id)->first();

                    $check_warranty_info = Warranty::where('id', $sell_warranti->warranty_id)->exists();
             

                    if($check_warranty_info){
                        $warranty_info = Warranty::where('id', $sell_warranti->warranty_id)->first();

                        $warranti_service_check = ServiceWarranty::where('serial_id', $check_serialhash->id)->exists();
                        if($warranti_service_check){
                            $warranti_service_info = ServiceWarranty::where('serial_id', $check_serialhash->id)->first();
                        }else{
                            $warranti_service_info = "";
                        }
                    
                    }

                }else{
                    $sell_warranti = "";
                    $warranty_info = "";
                    $warranti_service_info = "";
                }

            }else{
                $sell_info = "";
                $customer_info = "";
                $sell_transaction_info = "";
                $warranty_info = "";
                $warranti_service_info = "";
            }
                    
            $purcesh_transaction_info = Transaction::where('id', $purchase_info->transaction_id)->first();
            $suplier_info = Contact::where('id', $purcesh_transaction_info->contact_id)->first();
            $business_id = request()->session()->get('user.business_id');
            $business_details = $this->businessUtil->getDetails($business_id);
            $pos_settings = empty($business_details->pos_settings) ? $this->businessUtil->defaultPosSettings() : json_decode($business_details->pos_settings, true);
            //Accounts
            $accounts = [];
           
            if ($this->moduleUtil->isModuleEnabled('account')) {
                $accounts = Account::forDropdown($business_id, true, false);
            }

            $change_return = ['method' => '', 'amount' => 0, 'note' => '', 'card_transaction_number' => '', 'card_number' => '', 'card_type' => '', 'card_holder_name' => '', 'card_month' => '', 'card_year' => '', 'card_security' => '', 'cheque_number' => '', 'bank_account_number' => '',
            'is_return' => 0, 'transaction_no' => ''];
            $payment_line =['method' => '', 'amount' => 0, 'note' => '', 'card_transaction_number' => '', 'card_number' => '', 'card_type' => '', 'card_holder_name' => '', 'card_month' => '', 'card_year' => '', 'card_security' => '', 'cheque_number' => '', 'bank_account_number' => '',
            'is_return' => 0, 'transaction_no' => ''];
            $payment_types = array(
                'cash' => 'Cash'
            );
            $status = request()->get('status', '');

            return view('warranties.partials.warranty_row')->with(compact(
                'status',
                'change_return',
                'payment_types',
                'check_serialhash',
                'product_info',
                'purchase_info',
                'purcesh_transaction_info',
                'suplier_info',
                'sell_info',
                'sell_transaction_info',
                'customer_info',
                'warranty_info',
                'warranti_service_info',
                'accounts',
                'payment_line',
                'pos_settings',
                'serial_number'
            ));

        }else{
            return view('warranties.partials.no_result');
        }

    }

    
    public function AddwarrantyServicePost(Request $request) {


        try {

            $business_id = request()->session()->get('user.business_id');
            $user_id = request()->session()->get('user.id');
            
            $location = BusinessLocation::where('business_id', $business_id)->first();

            $input = $request->except('_token');
      
            $input['location_id'] = $location->id;
            $input['transaction_date'] = Carbon::now();
            $input['final_total'] = $request->total_amount;
            $input['recived_amount'] = $request->recived_amount;
            $input['service_custom_field_1'] = $request->service_custom_field_1;
            
            $invoice_total = array (
                'total_before_tax' => $request->total_amount,
                'tax' => 0,
                'discount' => 0.0,
                'final_total' => $request->total_amount,
            );

            if($request->service_type_radio == "replacement"){
                $input['sub_type'] = "Replace";
                $input['status'] = 'delivered';
                $input['received_time'] = Carbon::now();
                $input['delivery_time'] = Carbon::now();

                $no_status = "final";
                $service_recived_no = $this->transactionUtil->getInvoiceNumber($business_id, $no_status, $location->id);
                $service_delivery_no = $this->transactionUtil->getInvoiceNumber($business_id, $no_status, $location->id);

                
            }else{
                $input['sub_type'] = "Service";
                $input['status'] = 'received';
                $input['received_time'] = Carbon::now();
                $input['delivery_time'] = null;
                $no_status = "final";
                $service_recived_no = $this->transactionUtil->getInvoiceNumber($business_id, $no_status, $location->id);
                $service_delivery_no = null;

            }
            
            DB::beginTransaction();
            
 
            $transaction = $this->transactionUtil->createTransaction($business_id, $input, $invoice_total, $user_id);


            if(!empty($request->recived_amount)){
                $prefix_type = "sell_payment";
                $ref_count = $this->transactionUtil->setAndGetReferenceCount($prefix_type);
                //Generate reference number
                $payment_ref_no = $this->transactionUtil->generateReferenceNumber($prefix_type, $ref_count);
                TransactionPayment::insert([
                    'transaction_id' => $transaction->id,
                    'business_id' => $business_id,
                    'is_return' => 0,
                    'amount' => $request->recived_amount,
                    'method' => "cash",
                    'payment_type' => "credit",
                    'card_type' => "credit",
                    'paid_on' => Carbon::now(),
                    'created_by' => auth()->user()->id,
                    'paid_through_link' => 0,
                    'is_advance' => "0",
                    'payment_for' =>  $transaction->contact_id,
                    'payment_ref_no' => $payment_ref_no,
                    'created_at' => Carbon::now(),
                ]);
                    
            }


        
            //Update payment status
            $payment_status = $this->transactionUtil->updatePaymentStatus($transaction->id, $transaction->final_total);

            $transaction->payment_status = $payment_status;

            // For Replace ===========================================================================****
            $business_id = request()->session()->get('user.business_id');
            $user_id = request()->session()->get('user.id');
            
            $location = BusinessLocation::where('business_id', $business_id)->first();
 
            $serial = $request->old_serial; 
            
        
            $new_serial_info = SerialNumber::where('serial_number', $serial)->first();

         
            $receipt_details = $this->receiptContent($business_id, $location->id, $transaction->id);


            $service_warranty_id = ServiceWarranty::insertGetId([
                'product_id' => $request->product_id,
                'serial_id' => $new_serial_info->id,
                'old_serial' => $request->old_serial,
                'new_serial' => $request->new_serial,
                'service_fee' => $request->total_amount,
                'service_transaction_id' => $transaction->id,
                'status' => $input['status'],
                'received_time' => $input['received_time'],
                'delivery_time' => $input['delivery_time'],
                'service_recived_no' => "CR-".$service_recived_no,
                'service_delivery_no' => "CD-".$service_delivery_no,
                'created_at' => Carbon::now(),
            ]);
           
            if($request->service_type_radio == "replacement"){

                $check_new_serial = SerialNumber::where('serial_number', $request->new_serial)->where('stock_status', 'available')->exists();
                if(!empty($request->new_serial)){
                    if($check_new_serial){
                        SerialNumber::where('serial_number', $request->old_serial)->update([
                            'stock_status' => "available",
                            'transaction_id' => null,
                        ]);
                        SerialNumber::where('serial_number', $request->new_serial)->update([
                            'stock_status' => "out",
                            'transaction_id' => $request->sell_transaction_id,
                        ]);       
                    }else{
                        $output = ['success' => false,
                            'msg' => __("There is no available Serial, You want to Replace")
                        ];
                    }
        
                    $new_serial_info = SerialNumber::where('serial_number', $request->new_serial)->first();
                    ServiceWarranty::where('id', $service_warranty_id)->update([
                        'serial_id' => $new_serial_info->id,
                    ]);
        
                }


            }


            DB::commit();


          

            $trans_payment = TransactionPayment::where('transaction_id', $transaction->id)->exists();
            if($trans_payment){
                $trans_payment = TransactionPayment::where('transaction_id', $transaction->id)->first();
            }else{
                $trans_payment = "";
            }

            $warranty_service = ServiceWarranty::find($service_warranty_id);
            $product = Product::find($request->product_id);
     
    
            if($request->service_type_radio == "replacement"){
                $output['html_content'] = view('warranties.receipts.delevary-invoice', compact(
                    'receipt_details',
                    'warranty_service',
                    'product',
                    'transaction',
                    'trans_payment',
                ))->render();
            }else{
                $output['html_content'] = view('warranties.receipts.recived-invoice', compact(
                    'receipt_details',
                    'warranty_service',
                    'product',
                    'transaction',
                    'trans_payment',
                ))->render();
            }
         

        } catch (\Exception $e) {
            \Log::emergency("File:" . $e->getFile(). "Line:" . $e->getLine(). "Message:" . $e->getMessage());
        
            $output = ['success' => false,
                        'msg' => __("messages.something_went_wrong")
                    ];
        }


        return $output;

    }


    public function DeliverywarrantyService(){
        return view('warranties.devevary');
    }


    public function GetDelevaryWarranty(Request $request){
        $serial_number = $request->serial_number;
        $check_serialhash = SerialNumber::where('serial_number', $serial_number)->first();
        
        if (!empty($check_serialhash)){
            $servoce_waranty = ServiceWarranty::where('serial_id', $check_serialhash->id)->first();

            if(!empty($servoce_waranty)){
                $product_info = Product::where('id', $check_serialhash->product_id)->first();
                $purchase_info = PurchaseLine::where('serial_purchase_code', $check_serialhash->serial_purchase_code)->first();
                
                if($check_serialhash->transaction_id){
                    $sell_info = TransactionSellLine::where('transaction_id', $check_serialhash->transaction_id)->first();
                    $sell_transaction_info = Transaction::where('id', $check_serialhash->transaction_id)->first();
                    $customer_info = Contact::where('id', $sell_transaction_info->contact_id)->first();
    
                    $warranti_check = DB::table('sell_line_warranties')->where('sell_line_id', $sell_info->id)->exists();
              
                    
                    if($warranti_check){
                        $sell_warranti = DB::table('sell_line_warranties')->where('sell_line_id', $sell_info->id)->first();
    
                        $check_warranty_info = Warranty::where('id', $sell_warranti->warranty_id)->exists();
                 
    
                        if($check_warranty_info){
                            $warranty_info = Warranty::where('id', $sell_warranti->warranty_id)->first();
    
                            $warranti_service_check = ServiceWarranty::where('serial_id', $check_serialhash->id)->exists();
                            if($warranti_service_check){
                                $warranti_service_info = ServiceWarranty::where('serial_id', $check_serialhash->id)->first();
                            }else{
                                $warranti_service_info = "";
                            }
                        
                        }
    
                    }else{
                        $sell_warranti = "";
                        $warranty_info = "";
                        $warranti_service_info = "";
                    }
    
                }else{
                    $sell_info = "";
                    $customer_info = "";
                    $sell_transaction_info = "";
                    $warranty_info = "";
                    $warranti_service_info = "";
                }
                        
                
                $purcesh_transaction_info = Transaction::where('id', $purchase_info->transaction_id)->first();
                $suplier_info = Contact::where('id', $purcesh_transaction_info->contact_id)->first();
                $business_id = request()->session()->get('user.business_id');
                $business_details = $this->businessUtil->getDetails($business_id);
                $pos_settings = empty($business_details->pos_settings) ? $this->businessUtil->defaultPosSettings() : json_decode($business_details->pos_settings, true);
                //Accounts
                $accounts = [];
               
                if ($this->moduleUtil->isModuleEnabled('account')) {
                    $accounts = Account::forDropdown($business_id, true, false);
                }
    
                $change_return = ['method' => '', 'amount' => 0, 'note' => '', 'card_transaction_number' => '', 'card_number' => '', 'card_type' => '', 'card_holder_name' => '', 'card_month' => '', 'card_year' => '', 'card_security' => '', 'cheque_number' => '', 'bank_account_number' => '',
                'is_return' => 0, 'transaction_no' => ''];
                $payment_line = ['method' => '', 'amount' => 0, 'note' => '', 'card_transaction_number' => '', 'card_number' => '', 'card_type' => '', 'card_holder_name' => '', 'card_month' => '', 'card_year' => '', 'card_security' => '', 'cheque_number' => '', 'bank_account_number' => '',
                'is_return' => 0, 'transaction_no' => ''];
                $payment_types = array(
                    'cash' => 'Cash'
                );
                $status = request()->get('status', '');
    
                $service_transaction = Transaction::where('id', $warranti_service_info->service_transaction_id)->first();
                $trans_payment = TransactionPayment::where('transaction_id', $service_transaction->id)->exists();
                if($trans_payment){
                    $trans_payment = TransactionPayment::where('transaction_id', $service_transaction->id)->first();
                }else{
                    $trans_payment = "";
                }
        
                return view('warranties.partials.warranty_delevary_row')->with(compact(
                    'status',
                    'service_transaction',
                    'trans_payment',
                    'change_return',
                    'payment_types',
                    'check_serialhash',
                    'product_info',
                    'purchase_info',
                    'purcesh_transaction_info',
                    'suplier_info',
                    'sell_info',
                    'sell_transaction_info',
                    'customer_info',
                    'warranty_info',
                    'warranti_service_info',
                    'accounts',
                    'payment_line',
                    'pos_settings',
                    'serial_number'
                ));
            }else{
                return view('warranties.partials.no_result');
            }
        }else{
            return view('warranties.partials.no_result');
        }

    }


    public function DeliverywarrantyServicePost(Request $request){
       

        $business_id = request()->session()->get('user.business_id');
        $user_id = request()->session()->get('user.id');
        $location = BusinessLocation::where('business_id', $business_id)->first();

        DB::beginTransaction();
        $transaction = Transaction::where('id', $request->service_transaction_id)->first();
        Transaction::where('id', $request->service_transaction_id)->update([
            'final_total' => $request->total_amount,
            'service_custom_field_1' => $request->service_custom_field_1,
        ]);

        
        $trans_payment = TransactionPayment::where('transaction_id', $transaction->id)->exists();
        if($trans_payment){
            TransactionPayment::where('transaction_id', $transaction->id)->update([
                'amount' => $request->recived_amount,
                'updated_at' => Carbon::now(),
            ]);


        }else{
            $prefix_type = "sell_payment";
                $ref_count = $this->transactionUtil->setAndGetReferenceCount($prefix_type);
                //Generate reference number
                $payment_ref_no = $this->transactionUtil->generateReferenceNumber($prefix_type, $ref_count);
                TransactionPayment::insert([
                    'transaction_id' => $transaction->id,
                    'business_id' => $business_id,
                    'is_return' => 0,
                    'amount' => $request->recived_amount,
                    'method' => "cash",
                    'payment_type' => "credit",
                    'card_type' => "credit",
                    'paid_on' => Carbon::now(),
                    'created_by' => auth()->user()->id,
                    'paid_through_link' => 0,
                    'is_advance' => "0",
                    'payment_for' =>  $transaction->contact_id,
                    'payment_ref_no' => $payment_ref_no,
                    'created_at' => Carbon::now(),
                ]);
        }



      
      
        //Update payment status
        $payment_status = $this->transactionUtil->updatePaymentStatus($transaction->id, $transaction->final_total);

        $transaction->payment_status = $payment_status;



        $status = "final";
        $service_delivery_no = $this->transactionUtil->getInvoiceNumber($business_id, $status, $location->id);
        ServiceWarranty::where('id', $request->service_warranty_id)->update([
            'status' => "delivered",
            'service_delivery_no' => "CD-".$service_delivery_no,
        ]);

        $receipt_details = $this->receiptContent($business_id, $location->id, $transaction->id);


        $warranty_service = ServiceWarranty::find($request->service_warranty_id);
        $product = Product::find($request->product_id);

        DB::commit();

        $trans_payment = TransactionPayment::where('transaction_id', $transaction->id)->first();

        $serial = $request->serial;

        $output['html_content'] = view('warranties.receipts.delevary-invoice', compact(
            'receipt_details',
            'warranty_service',
            'product',
            'transaction',
            'trans_payment',
        ))->render();

        return $output;
    }


    function getRecivedInvoice($id) {

        $business_id = request()->session()->get('user.business_id');
        $user_id = request()->session()->get('user.id');
        $location = BusinessLocation::where('business_id', $business_id)->first();

        $warranty_service = ServiceWarranty::find($id);
        $transaction = Transaction::where('id', $warranty_service->service_transaction_id)->first();
        $product = Product::find($warranty_service->product_id);



        $trans_payment = TransactionPayment::where('transaction_id', $transaction->id)->exists();
        if($trans_payment){
            $trans_payment = TransactionPayment::where('transaction_id', $transaction->id)->first();
        }else{
            $trans_payment = "";
        }

        $output = ['success' => 1, 'receipt' => [], 'print_title' => $transaction->ref_no];
        $receipt_details = $this->receiptContent($business_id, $location->id, $warranty_service->service_transaction_id);
        $output['receipt']['html_content'] = view('warranties.receipts.recived-invoice', compact(
            'receipt_details',
            'warranty_service',
            'product',
            'transaction',
            'trans_payment',
        ))->render();

        return $output;
    }
    function getDelevaryInvoice($id) {

        $business_id = request()->session()->get('user.business_id');
        $user_id = request()->session()->get('user.id');
        $location = BusinessLocation::where('business_id', $business_id)->first();

        $warranty_service = ServiceWarranty::find($id);
        $transaction = Transaction::where('id', $warranty_service->service_transaction_id)->first();
        $product = Product::find($warranty_service->product_id);



        $trans_payment = TransactionPayment::where('transaction_id', $transaction->id)->exists();
        if($trans_payment){
            $trans_payment = TransactionPayment::where('transaction_id', $transaction->id)->first();
        }else{
            $trans_payment = "";
        }
        $output = ['success' => 1, 'receipt' => [], 'print_title' => $transaction->ref_no];
        $receipt_details = $this->receiptContent($business_id, $location->id, $warranty_service->service_transaction_id);
        $output['receipt']['html_content'] = view('warranties.receipts.delevary-invoice', compact(
            'receipt_details',
            'warranty_service',
            'product',
            'transaction',
            'trans_payment',
        ))->render();

        return $output;
    }


    private function receiptContent(
        $business_id,
        $location_id,
        $transaction_id,
    ){
        $output = ['is_enabled' => false,
            'print_type' => 'browser',
            'html_content' => null,
            'printer_config' => [],
            'data' => [],
        ];

        $business_details = $this->businessUtil->getDetails($business_id);

        $location_details = BusinessLocation::find($location_id);
        //Check if printing of invoice is enabled or not.
        //If enabled, get print type.
        $output['is_enabled'] = true;
        $invoice_layout_id = $location_details->invoice_layout_id;
        $invoice_layout = $this->businessUtil->invoiceLayout($business_id, $invoice_layout_id);
        //Check if printer setting is provided.
        $receipt_printer_type =  $location_details->receipt_printer_type;
        $receipt_details = $this->transactionUtil->getReceiptDetails($transaction_id, $location_id, $invoice_layout, $business_details, $location_details, $receipt_printer_type);
   
     
        $currency_details = [
            'symbol' => $business_details->currency_symbol,
            'thousand_separator' => $business_details->thousand_separator,
            'decimal_separator' => $business_details->decimal_separator,
        ];
        $receipt_details->currency = $currency_details;
 
        return $receipt_details;
    }

    function WarrantyDelete($id){

        if (request()->ajax()) {
            try {

                DB::beginTransaction();

                $warranty_service = ServiceWarranty::find($id);
                $transaction = Transaction::where('id', $warranty_service->service_transaction_id)->first();
                $trans_payment = TransactionPayment::where('transaction_id', $transaction->id)->first();
                
                if ($trans_payment) {
                    $trans_payment->delete();
                }
                $transaction->delete();
                $warranty_service->delete();

                DB::commit();

                $output = ['success' => true,
                    'msg' => __('Warranty Delete Successfuly'),
                ];
            } catch (\Exception $e) {
                DB::rollBack();

                Log::emergency('File:'.$e->getFile().'Line:'.$e->getLine().'Message:'.$e->getMessage());

                $output = ['success' => false,
                    'msg' => __('messages.something_went_wrong'),
                ];
            }
            return $output;
        }

    }



    function WarrantyEdit($id){

        $warranti_service_info = ServiceWarranty::where('id', $id)->first();

        if(!empty($warranti_service_info->new_serial)){
            $serial_number = $warranti_service_info->new_serial;
        }else{
            $serial_number = $warranti_service_info->old_serial;
        }
        $product_info = Product::where('id', $warranti_service_info->product_id)->first();

        $check_serialhash = SerialNumber::where('serial_number', $serial_number)->first();
        
        $purchase_info = PurchaseLine::where('serial_purchase_code', $check_serialhash->serial_purchase_code)->first();
        
        $sell_info = TransactionSellLine::where('transaction_id', $check_serialhash->transaction_id)->first();
        
        $sell_warranti = DB::table('sell_line_warranties')->where('sell_line_id', $sell_info->id)->first();
        
        $warranty_info = Warranty::where('id', $sell_warranti->warranty_id)->first();
        
        
        $sell_transaction_info = Transaction::where('id', $check_serialhash->transaction_id)->first();
        $service_transaction_info = Transaction::where('id', $warranti_service_info->service_transaction_id)->first();
        $purcesh_transaction_info = Transaction::where('id', $purchase_info->transaction_id)->first();
        
        $customer_info = Contact::where('id', $sell_transaction_info->contact_id)->first();
        $suplier_info = Contact::where('id', $purcesh_transaction_info->contact_id)->first();
        
        
        $business_id = request()->session()->get('user.business_id');
        $business_details = $this->businessUtil->getDetails($business_id);
        $pos_settings = empty($business_details->pos_settings) ? $this->businessUtil->defaultPosSettings() : json_decode($business_details->pos_settings, true);
        
        // return $pos_settings; 
        $trans_payment = TransactionPayment::where('transaction_id', $service_transaction_info->id)->exists();
        if($trans_payment){
            $trans_payment = TransactionPayment::where('transaction_id', $service_transaction_info->id)->first();
        }else{
            $trans_payment = "";
        }
        return view('warranties.warranty_service_edit')->with(compact(
            'check_serialhash',
            'product_info',
            'purchase_info',
            'purcesh_transaction_info',
            'suplier_info',
            'sell_info',
            'sell_transaction_info',
            'customer_info',
            'warranty_info',
            'warranti_service_info',
            'pos_settings',
            'service_transaction_info',
            'trans_payment',
            'serial_number'
        ));

    }
    
    
    function WarrantyEditPost(Request $request){
        
        try {

            DB::beginTransaction();
            
            $business_id = request()->session()->get('user.business_id');
            $user_id = request()->session()->get('user.id');
            $location = BusinessLocation::where('business_id', $business_id)->first();

            $old_serial_info = SerialNumber::where('serial_number', $request->serial_number)->first();
            $warranti_service_info = ServiceWarranty::where('serial_id', $old_serial_info->id)->first();
            
            if($request->service_type_radio == "replacement"){
                
                $status = "final";
                $service_delivery_no = $this->transactionUtil->getInvoiceNumber($business_id, $status, $location->id);


                $check_new_serial = SerialNumber::where('serial_number', $request->new_serial)->where('stock_status', 'available')->exists();
                if($check_new_serial){

                    $new_serial_info = SerialNumber::where('serial_number', $request->new_serial)->first();

                    ServiceWarranty::where('id', $warranti_service_info->id)->update([
                        'serial_id' => $new_serial_info->id,
                        'new_serial' => $request->new_serial,
                        'service_delivery_no' => "CD-".$service_delivery_no,
                    ]);

                    $if_update =  SerialNumber::where('serial_number', $request->new_serial)->update([
                        'stock_status' => "out",
                        'transaction_id' => $old_serial_info->transaction_id,
                    ]);   

                    if($if_update){
                        SerialNumber::where('serial_number', $request->old_serial)->update([
                            'stock_status' => "available",
                            'transaction_id' => null,
                        ]);
                    }

                    $output = ['success' => true,
                        'msg' => __("Replace Update successfully")
                    ];
                    
                }else{
                    $output = ['success' => false,
                        'msg' => __("There is no available Serial, You want to Replace")
                    ];
                }
            
                Transaction::where('id', $warranti_service_info->service_transaction_id)->update([
                    'service_custom_field_1' => $request->service_custom_field_1,
                ]);

            }else{

                $service_transaction = Transaction::where('id', $warranti_service_info->service_transaction_id)->first();
        
                Transaction::where('id', $service_transaction->id)->update([
                    'final_total' => $request->total_amount,
                    'service_custom_field_1' => $request->service_custom_field_1,
                ]);
                $trans_payment = TransactionPayment::where('transaction_id', $service_transaction->id)->exists();

                if($trans_payment){
                    TransactionPayment::where('transaction_id', $service_transaction->id)->update([
                        'amount' => $request->recived_amount,
                        'updated_at' => Carbon::now(),
                    ]);
                }else{
                    $prefix_type = "sell_payment";
                    $ref_count = $this->transactionUtil->setAndGetReferenceCount($prefix_type);
                    //Generate reference number
                    $payment_ref_no = $this->transactionUtil->generateReferenceNumber($prefix_type, $ref_count);
                    TransactionPayment::insert([
                        'transaction_id' => $service_transaction->id,
                        'business_id' => $business_id,
                        'is_return' => 0,
                        'amount' => $request->recived_amount,
                        'method' => "cash",
                        'payment_type' => "credit",
                        'card_type' => "credit",
                        'paid_on' => Carbon::now(),
                        'created_by' => auth()->user()->id,
                        'paid_through_link' => 0,
                        'is_advance' => "0",
                        'payment_for' =>  $service_transaction->contact_id,
                        'payment_ref_no' => $payment_ref_no,
                        'created_at' => Carbon::now(),
                    ]);
                }
                

                //Update payment status
                $payment_status = $this->transactionUtil->updatePaymentStatus($service_transaction->id, $service_transaction->final_total);
                $service_transaction->payment_status = $payment_status;
                ServiceWarranty::where('id', $warranti_service_info->id)->update([
                    'service_fee' => $request->total_amount,
                    'status' => "received",
                ]);


                $output = [
                    'success' => true,
                    'msg' => __("Service Recived Update successfully")
                ];

            }

            DB::commit();

        } catch (\Exception $e) {
            DB::rollBack();

            Log::emergency('File:'.$e->getFile().'Line:'.$e->getLine().'Message:'.$e->getMessage());

            $output = ['success' => false,
                'msg' => __('messages.something_went_wrong'),
            ];
        }
        return $output;
        
    }


















    // HHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHH
    public function CheckSerial(Request $request){

        $business_id = request()->session()->get('user.business_id');

        if (!empty($request->serial_number)) {
            $check_serial_numberhave = SerialNumber::where('location_id', $request->location_id)
                                                    ->where('business_id', $business_id)
                                                    ->where('serial_number', $request->serial_number)
                                                    ->where('product_id', $request->product_id)
                                                    ->where('variation_id', $request->variation_id)
                                                    ->first();
            if (!empty($check_serial_numberhave)) {
                $result = 1;
            }else{
                $result = 0;
            }
        }
        else{
            $result = 0;
        }
        return $result;
    }
    // HHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHH

















}
