<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(){
        
        Schema::table('products', function (Blueprint $table) {
            //
            $table->boolean('use_multi_unit')->default(0)->after('weight');
            $table->integer('first_conversion_unit_id')->after('use_multi_unit')->unsigned()->nullable();
            $table->decimal('first_conversion_unit_rate', 20, 4)->after('first_conversion_unit_id')->nullable();
            $table->integer('second_conversion_unit_id')->after('first_conversion_unit_rate')->unsigned()->nullable();
            $table->decimal('second_conversion_unit_rate', 20, 4)->after('second_conversion_unit_id')->nullable();

        });

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('products', function (Blueprint $table) {
            if (Schema::hasColumn('products', 'use_unit')) {
                $table->dropColumn('use_unit');
            }
            if (Schema::hasColumn('products', 'first_conversion_unit_id')) {
                $table->dropColumn('first_conversion_unit_id');
            }
            if (Schema::hasColumn('products', 'first_conversion_unit_rate')) {
                $table->dropColumn('first_conversion_unit_rate');
            }
            if (Schema::hasColumn('products', 'second_conversion_unit_id')) {
                $table->dropColumn('second_conversion_unit_id');
            }
            if (Schema::hasColumn('products', 'second_conversion_unit_rate')) {
                $table->dropColumn('second_conversion_unit_rate');
            }
        });
    }
};
