<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('invoice_layouts', function (Blueprint $table) {
            $table->boolean('show_serial_number')->default(0)->after('show_cat_code');
            $table->boolean('show_multi_unit_details')->default(0)->after('show_cat_code');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('invoice_layouts', function (Blueprint $table) {
            if (Schema::hasColumn('invoice_layouts', 'show_serial_number')) {
                $table->dropColumn('show_serial_number');
            }
            if (Schema::hasColumn('invoice_layouts', 'show_multi_unit_details')) {
                $table->dropColumn('show_multi_unit_details');
            }

        });
    }
};
