$(document).ready(function () {
    "use strict";
    // Interval to refresh customer display page every 1 second
    setInterval(function () {
        fetchCartData();
    }, 2000);
    /**
     * Full Screen
     */
    function toggleFullscreen(elem) {

        elem = elem || document.documentElement;
        if (
            !document.fullscreenElement &&
            !document.mozFullScreenElement &&
            !document.webkitFullscreenElement &&
            !document.msFullscreenElement
        ) {
            if (elem.requestFullscreen) {
                elem.requestFullscreen();
            } else if (elem.msRequestFullscreen) {
                elem.msRequestFullscreen();
            } else if (elem.mozRequestFullScreen) {
                elem.mozRequestFullScreen();
            } else if (elem.webkitRequestFullscreen) {
                elem.webkitRequestFullscreen(Element.ALLOW_KEYBOARD_INPUT);
            }

        } else {
            if (document.exitFullscreen) {
                document.exitFullscreen();
            } else if (document.msExitFullscreen) {
                document.msExitFullscreen();
            } else if (document.mozCancelFullScreen) {
                document.mozCancelFullScreen();
            } else if (document.webkitExitFullscreen) {
                document.webkitExitFullscreen();
            }


        }
    }
    $(document).on("click", "#fullscreen", function (e) {
       console.log("Fullscreen button clicked");
        toggleFullscreen();
    });


    var businessDetails = {
        currencySymbol: "DH", // Currency symbol (example: "DH")
        thousandSeparator: null, // Thousand separator (example: ",")
        decimalSeparator: ".", // Decimal separator (example: ".")
        currencySymbolPlacement: "after" // Currency symbol placement ("before" or "after")
    };


    // Fetch and render cart data
    function fetchCartData() {
        $.ajax({
            url: `/customer-display/get-cart-data`,
            method: 'GET',
            success: function (response) {
                if (response.status) {
                    const cartData = response.data;
                    renderCartItems(cartData.items);
                    $('#total-items').text(cartData.total_items_in_cart);
                    $('#total-payable').text(cartData.total_payable);
                    $('#discount_amount').text(cartData.discount_amount);
                    $('#tax_calculation_amount').text(cartData.tax_calculation_amount);
                    $('#shipping_charges').text(cartData.shipping_charges);
                } else {
                    console.warn('No cart data available');
                    $('#cart-items').html('<p>No cart items found.</p>');
                    $('#total-items').text(0);
                    $('#total-payable').text(0);
                    $('#discount_amount').text(0);
                    $('#tax_calculation_amount').text(0);
                    $('#shipping_charges').text(0);
                }
            },
            error: function () {
                // clear table html inner
                $('#cart-items').html('');
                $('#total-items').text(0);
                $('#total-payable').text(0);
                $('#discount_amount').text(0);
                $('#tax_calculation_amount').text(0);
                $('#shipping_charges').text(0);


                console.error('Failed to fetch cart data');
                $('#cart-items').html('<p>Error loading cart data.</p>');
            }
        });
    }


    // Render cart items in the display
    function renderCartItems(items) {
        const cartItemsContainer = $('#cart-items');
        cartItemsContainer.empty();  // Clear any previous content

        if (items.length === 0) {
            cartItemsContainer.html('<p>Your cart is empty.</p>');
            return;
        }

        // Create the table structure for cart items
        const tableHtml = `
            <table class="table table-bordered">
    <thead>
                    <tr>
                        <th>Item</th>
                        <th>Price</th>
                        <th>Quantity</th>
                        <th>Discount</th>
                        <th>Subtotal</th>
                    </tr>
                </thead>
                <tbody>
        `;

        // Loop through items and generate table rows
        const rowsHtml = items.map(item => {
            return `
                <tr>
                    <td><strong>${item.item_name}</strong></td>
                    <td style="text-align: right;">${formatCurrency(item.item_unit_price, businessDetails)}</td>
                    <td  style="text-align: center;">${item.item_quantity}</td>
                    <td style="text-align: right;">${formatCurrency(item.item_line_discount, businessDetails)}</td>
                    <td style="text-align: right;">${formatCurrency(item.item_total_price_table, businessDetails)}</td>
                </tr>
            `;
        }).join('');  // Join the rows as a single string to append later

        // Complete the table structure and append it to the container
        const fullTableHtml = tableHtml + rowsHtml + '</tbody></table>';
        cartItemsContainer.html(fullTableHtml);
    }


    // Format currency
// Modify the formatCurrency function to handle business details
function formatCurrency(value, businessDetails) {
    // Default values if businessDetails are undefined or missing
    const currencySymbol = businessDetails.currencySymbol || "$";
    const thousandSeparator = businessDetails.thousandSeparator || ",";
    const decimalSeparator = businessDetails.decimalSeparator || ".";
    const currencySymbolPlacement = businessDetails.currencySymbolPlacement || "before";

    // Format the value to include thousand separator and decimal separator
    let formattedValue = parseFloat(value).toFixed(2).toString();

    // Split the value into integer and decimal parts
    let [integer, decimal] = formattedValue.split(".");

    // Add thousand separators to the integer part
    integer = integer.replace(/\B(?=(\d{3})+(?!\d))/g, thousandSeparator);

    // Reassemble the value with the decimal part
    formattedValue = integer + decimalSeparator + decimal;

    // Add currency symbol placement (before or after)
    // if (currencySymbolPlacement === "before") {
    //     return `${currencySymbol} ${formattedValue}`;
    // } else {
    //     return `${formattedValue} ${currencySymbol}`;
    // }
    return `${formattedValue}`;
}



    // Initial data fetch
    fetchCartData();


});
