$(document).ready(function() {



    
    $('table#product_table tbody').find('.label-date-picker').each( function(){
        $(this).datepicker({
            autoclose: true
        });
    });
    //Add products
    if ($('#search_product_for_label').length > 0) {
        $('#search_product_for_label')
            .autocomplete({
                source: '/purchases/get_products?check_enable_stock=false',
                minLength: 2,
                response: function(event, ui) {
                    if (ui.content.length == 1) {
                        ui.item = ui.content[0];
                        $(this)
                            .data('ui-autocomplete')
                            ._trigger('select', 'autocompleteselect', ui);
                        $(this).autocomplete('close');
                    } else if (ui.content.length == 0) {
                        swal(LANG.no_products_found);
                    }
                },
                select: function(event, ui) {
                    $(this).val(null);
                    get_label_product_row(ui.item.product_id, ui.item.variation_id);
                },
            })
            .autocomplete('instance')._renderItem = function(ul, item) {
            return $('<li>')
                .append('<div>' + item.text + '</div>')
                .appendTo(ul);
        };
    }

    $('input#is_show_price').change(function() {
        if ($(this).is(':checked')) {
            $('div#price_type_div').show();
        } else {
            $('div#price_type_div').hide();
        }
    });
    $('input#is_show_price').change(function() {
        if ($(this).is(':checked')) {
            const formData = $('#preview_setting_form').serialize();
            // Log form data to verify correct parameters
            console.log('Price checkbox is checked. Sending data:', formData);
            
            fetchPreview();
        } else {
            // Potentially remove or set price-related data to null before sending
            $('input[name="print[price]"]').val('');  // Clear if unchecked
            fetchPreview();
        }
    });

    $('button#labels_preview').click(function() {
        if ($('form#preview_setting_form table#product_table tbody tr').length > 0) {
            var url = base_path + '/labels/show_label_preview?' + $('form#preview_setting_form').serialize();

           // window.open(url, 'newwindow');

            $.ajax({
                method: 'get',
                url: url,
                dataType: 'json',
                data: $('form#preview_setting_form').serialize(),
                success: function(result) {
                    if (result.success) {
                        $('div.display_label_div').removeClass('hide');
                        $('#preview_box').html(result.html);
                        __currency_convert_recursively($('#preview_box'));
                    } else {
                        toastr.error(result.msg);
                    }
                },
            });
        } else {
            swal(LANG.label_no_product_error).then(value => {
                $('#search_product_for_label').focus();
            });
        }
    });

    // $(document).on('click', 'button#print_label', function() {
    //     if ($('#preview_box').html().trim().length > 0) {

    //         window.print();
    //     } else {
    //         toastr.error("No label preview available to print.");
    //     }
    // });
    
});
$('button#print_label').click(function() {
    var printContents = $('#preview_box').html();
    paper_width = 1.1811;
    paper_height = 0.5906;
    margin_top = 0;
    margin_left = 0;
    if (printContents.trim().length > 0) {
        // Open a new window to print the content
        var printWindow = window.open('', '_blank', 'width=1000,height=700');
        printWindow.document.open();
        printWindow.document.write(`
            <html>
                <head>
                    <title>Print Preview</title>
                    <style>
    @media print {
        @page {
            size: {{ $paper_width }}in {{ $paper_height }}in;
            margin: {{ $margin_top }}in {{ $margin_left }}in;
        }

        #label-preview {
            transform: scale(0.8);
            transform-origin: top left;
            width: 125%;
        }

        body, #label-preview, #label-preview * {
            margin: 0 !important;
            padding: 0 !important;
            page-break-inside: avoid;
        }
    }
</style>



                </head>
                <body>
                    <div id="preview_box">${printContents}</div>
                </body>
            </html>
        `);
        printWindow.document.close();

        // Delay the print to ensure the content is fully loaded
        printWindow.onload = function() {
            printWindow.print();
            printWindow.close();
        };
    } else {
        toastr.error("No label preview available to print.");
    }
});
$('button#labels_preview_qr').click(function() {
    if ($('form#preview_setting_form table#product_table tbody tr').length > 0) {
        var url = base_path + '/labels/preview/qr?' + $('form#preview_setting_form').serialize();
        window.open(url, 'newwindow');
    } else {
        swal(LANG.label_no_product_error).then(value => {
            $('#search_product_for_label').focus();
        });
    }
});

function get_label_product_row(product_id, variation_id) {
    if (product_id) {
        var row_count = $('table#product_table tbody tr').length;
        $.ajax({
            method: 'GET',
            url: '/labels/add-product-row',
            dataType: 'html',
            data: { product_id: product_id, row_count: row_count, variation_id: variation_id },
            success: function(result) {
                // Append the new row to the table
                $('table#product_table tbody').append(result);

                // Initialize date pickers for any new date input fields
                $('table#product_table tbody').find('.label-date-picker').each(function() {
                    $(this).datepicker({
                        autoclose: true
                    });
                });

                // Call fetchPreview to update the preview after the row is added
                fetchPreview();
            },
            error: function(xhr, status, error) {
                console.error('Error adding product row:', error);
            }
        });
    }
}
