@if(!session('business.enable_price_tax')) 
  @php
    $default = 0;
    $class = 'hide';
  @endphp
@else
  @php
    $default = null;
    $class = '';
  @endphp
@endif
@php
    $common_settings = session()->get('business.common_settings');
@endphp

<div class="col-sm-12"><br>
    <div class="table-responsive">
    <table class="table table-bordered add-product-price-table table-condensed {{$class}}">
        <tr>
          <th>@lang('product.default_purchase_price')</th>
          <th>@lang('product.profit_percent') @show_tooltip(__('tooltip.profit_percent'))</th>
          <th>@lang('product.default_selling_price')</th>
          <th>@lang('lang_v1.product_image')</th>
        </tr>
        @foreach($product_deatails->variations as $variation )
            @php
                $is_image_required = !empty($common_settings['is_product_image_required']) && count($variation->media) == 0;
            @endphp
            @if($loop->first)

                <tr class="main_v">
                    <td>
                        <input type="hidden" name="single_variation_id" value="{{$variation->id}}">

                        <div class="col-sm-6">
                          {!! Form::label('single_dpp', trans('product.exc_of_tax') . ':*') !!}

                          {!! Form::text('single_dpp', @num_format($variation->default_purchase_price), ['class' => 'form-control input-sm dpp input_number', 'placeholder' => __('product.exc_of_tax'), 'required']); !!}
                        </div>

                        <div class="col-sm-6">
                          {!! Form::label('single_dpp_inc_tax', trans('product.inc_of_tax') . ':*') !!}
                        
                          {!! Form::text('single_dpp_inc_tax', @num_format($variation->dpp_inc_tax), ['class' => 'form-control input-sm dpp_inc_tax input_number', 'placeholder' => __('product.inc_of_tax'), 'required']); !!}
                        </div>
                    </td>

                    <td>
                        <br/>
                        {!! Form::text('profit_percent', @num_format($variation->profit_percent), ['class' => 'form-control input-sm input_number', 'id' => 'profit_percent', 'required']); !!}
                    </td>

                    <td>
                        <label><span class="dsp_label"></span></label>
                        {!! Form::text('single_dsp', @num_format($variation->default_sell_price), ['class' => 'form-control input-sm dsp input_number', 'placeholder' => __('product.exc_of_tax'), 'id' => 'single_dsp', 'required']); !!}

                        {!! Form::text('single_dsp_inc_tax', @num_format($variation->sell_price_inc_tax), ['class' => 'form-control input-sm hide input_number', 'placeholder' => __('product.inc_of_tax'), 'id' => 'single_dsp_inc_tax', 'required']); !!}
                    </td>
                    <td>
                        @php 
                            $action = !empty($action) ? $action : '';
                        @endphp
                        @if($action !== 'duplicate')
                            @foreach($variation->media as $media)
                                <div class="img-thumbnail">
                                    <span class="badge bg-red delete-media" data-href="{{ action([\App\Http\Controllers\ProductController::class, 'deleteMedia'], ['media_id' => $media->id])}}"><i class="fas fa-times"></i></span>
                                    {!! $media->thumbnail() !!}
                                </div>
                            @endforeach
                        @endif
                        <div class="form-group">
                            {!! Form::label('variation_images', __('lang_v1.product_image') . ':') !!}
                            {!! Form::file('variation_images[]', ['class' => 'variation_images', 
                                'accept' => 'image/*', 'multiple', 'required' => $is_image_required]); !!}
                            <small><p class="help-block">@lang('purchase.max_file_size', ['size' => (config('constants.document_size_limit') / 1000000)]) <br> @lang('lang_v1.aspect_ratio_should_be_1_1')</p></small>
                        </div>
                    </td>
                </tr>



                <tr class="multi_unit fu_variation_value_row @if($product->use_multi_unit != 1 || $first_conversion_unit_id == 0) hide @endif single_variation">
                    <td>
                      <div class="col-sm-6">
                        {!! Form::label('fu_single_dpp', trans('product.exc_of_tax') . ':*') !!}
                        {!! Form::text('fu_single_dpp', @num_format($variation->fu_default_purchase_price), ['class' => 'form-control input-sm fu_dpp input_number', 'placeholder' => __('product.exc_of_tax'), 'required']); !!}
                      </div>
          
                      <div class="col-sm-6">
                        {!! Form::label('fu_single_dpp_inc_tax', trans('product.inc_of_tax') . ':*') !!}
                        {!! Form::text('fu_single_dpp_inc_tax', @num_format($variation->fu_dpp_inc_tax), ['class' => 'form-control input-sm fu_dpp_inc_tax input_number', 'placeholder' => __('product.inc_of_tax'), 'required']); !!}
                      </div>
                    </td>
          
                    <td>
                      <br/>
                      {!! Form::text('fu_profit_percent', @num_format($variation->fu_profit_percent), ['class' => 'form-control input-sm input_number', 'id' => 'fu_profit_percent', 'required']); !!}
                    </td>
          
                    <td>
                      <label>
                        <span class="dsp_label">
                          @lang('product.exc_of_tax')
                        </span>
                      </label>
                      {!! Form::text('fu_single_dsp', @num_format($variation->fu_default_sell_price), ['class' => 'form-control input-sm fu_dsp input_number', 'placeholder' => __('product.exc_of_tax'), 'id' => 'fu_single_dsp', 'required']); !!}
                      {!! Form::text('fu_single_dsp_inc_tax', @num_format($variation->fu_sell_price_inc_tax), ['class' => 'form-control input-sm hide input_number', 'placeholder' => __('product.inc_of_tax'), 'id' => 'fu_single_dsp_inc_tax', 'required']); !!}
                    </td>
                    <td>
                      SKU For First Unit
                      {!! Form::text('fu_sub_sku', $variation->first_unit_sku, ['class' => 'form-control input-sm', 'id' => 'fu_sub_sku', 'placeholder' => __('sku')]); !!}
                    </td>
                </tr>
  
                <tr class="multi_unit su_variation_value_row @if($product->use_multi_unit != 1 || $second_conversion_unit_id == 0) hide @endif single_variation">
                    <td>
                        <div class="col-sm-6">
                        {!! Form::label('su_single_dpp', trans('product.exc_of_tax') . ':*') !!}
                        {!! Form::text('su_single_dpp', @num_format($variation->su_default_purchase_price), ['class' => 'form-control input-sm su_dpp input_number', 'placeholder' => __('product.exc_of_tax'), 'required']); !!}
                        </div>
            
                        <div class="col-sm-6">
                        {!! Form::label('su_single_dpp_inc_tax', trans('product.inc_of_tax') . ':*') !!}
                        {!! Form::text('su_single_dpp_inc_tax', @num_format($variation->su_dpp_inc_tax), ['class' => 'form-control input-sm su_dpp_inc_tax input_number', 'placeholder' => __('product.inc_of_tax'), 'required']); !!}
                        </div>
                    </td>
            
                    <td>
                        <br/>
                        {!! Form::text('su_profit_percent', @num_format($variation->su_profit_percent), ['class' => 'form-control input-sm input_number', 'id' => 'su_profit_percent', 'required']); !!}
                    </td>
            
                    <td>
                        <label>
                        <span class="dsp_label">
                            @lang('product.su_exc_of_tax')
                        </span>
                        </label>
                        {!! Form::text('su_single_dsp', @num_format($variation->su_default_sell_price), ['class' => 'form-control input-sm su_dsp input_number', 'placeholder' => __('product.exc_of_tax'), 'id' => 'su_single_dsp', 'required']); !!}
                        {!! Form::text('su_single_dsp_inc_tax', @num_format($variation->su_sell_price_inc_tax), ['class' => 'form-control input-sm hide input_number', 'placeholder' => __('product.su_inc_of_tax'), 'id' => 'su_single_dsp_inc_tax', 'required']); !!}
                    </td>
                    <td>
                        SKU For Second Unit
                        {!! Form::text('su_sub_sku', $variation->second_unit_sku, ['class' => 'form-control input-sm', 'id' => 'su_sub_sku','placeholder' => __('sku')]); !!}
                    </td>
                </tr>

            @endif
        @endforeach
    </table>
    </div>
</div>