<div class="row">
	<div class="col-md-12">
		<div class="table-responsive">
			<table class="table table-condensed bg-gray">
				<thead>
					<tr class="bg-green">
						<th>SKU</th>
		                <th>@lang('business.product')</th>
		                <th>@lang('business.location')</th>
		                <th>@lang('sale.unit_price')</th>
		                <th>@lang('report.current_stock')</th>
		                <th>@lang('lang_v1.total_stock_price')</th>
		                <th>@lang('report.total_unit_sold')</th>
		                <th>@lang('lang_v1.total_unit_transfered')</th>
		                <th>@lang('lang_v1.total_unit_adjusted')</th>
		            </tr>
	            </thead>
	            <tbody>

	            	@foreach($product_stock_details as $product)

	            		<tr>
	            			<td>
								@if (!empty($product->first_conversion_unit_id))
									{{$product->unit}} - {{$product->sku }}<br>
									@php
										$first_unit = App\Unit::where('id', $product->first_conversion_unit_id)->first();
									@endphp
									{{ $first_unit->actual_name }}({{ $first_unit->short_name }}) - {{$product->first_unit_sku }}<br>

									@if (!empty($product->second_conversion_unit_id))
										@php
											$second_unit = App\Unit::where('id', $product->second_conversion_unit_id)->first();
										@endphp
										{{ $second_unit->actual_name }}({{ $second_unit->short_name }}) - {{ $product->second_unit_sku }}<br>
									@endif
								@else
									{{$product->sku }}<br>
								@endif
							</td>

	            			<td>
	            				@php
									$name = $product->product;
									if ($product->type == 'variable') {
										$name .= ' - ' . $product->product_variation . '-' . $product->variation_name;
									}
			                    @endphp
			                    {{$name}}
	            			</td>

	            			<td>{{$product->location_name}}</td>

	            			<td>
                        		<span class="display_currency" data-currency_symbol=true >
									{{$product->unit_price ?? 0}}
								</span>
                        	</td>

	            			<td>
                        		<span data-is_quantity="true" class="display_currency" data-currency_symbol=false >
									{{$product->stock ?? 0}}
								</span>
								{{$product->unit}}


								@if (!empty($product->first_conversion_unit_id))
									<br>
									@php
										$first_quantity = $product->stock ?? 0;
									@endphp
										@if ($product->first_conversion_unit_rate>0)
											@php
												$first_quantity = $first_quantity / $product->first_conversion_unit_rate;
											@endphp
										@endif
								
									{{ $first_quantity }} {{ $first_unit->actual_name }}({{ $first_unit->short_name }})
									<br>
								@endif
									
								@if (!empty($product->second_conversion_unit_id))
									@php
										$second_quantity = $product->stock ?? 0;
									@endphp
										@if ($product->first_conversion_unit_rate>0 && $product->second_conversion_unit_rate>0)
											@php
												$second_quantity = $second_quantity / ($product->first_conversion_unit_rate * $product->second_conversion_unit_rate);
											@endphp
										@endif
								
									{{ $second_quantity }} {{ $second_unit->actual_name }}({{ $second_unit->short_name }})
									<br>
								@endif

                        	</td>

                        	<td>
                        		<span class="display_currency" data-currency_symbol=true >
									{{$product->unit_price * $product->stock}}
								</span>
                        	</td>

                        	<td>
                        		<span data-is_quantity="true" class="display_currency" data-currency_symbol=false >
									{{$product->total_sold ?? 0}}
								</span>
								{{$product->unit}}






								@if (!empty($product->first_conversion_unit_id))
									<br>
									@php
										$sold_first_quantity = $product->total_sold ?? 0;
									@endphp
										@if ($product->first_conversion_unit_rate>0)
											@php
												$sold_first_quantity = $sold_first_quantity / $product->first_conversion_unit_rate;
											@endphp
										@endif
									@php
										$first_unit = App\Unit::where('id', $product->first_conversion_unit_id)->first();
									@endphp
									{{ $sold_first_quantity }} {{ $first_unit->actual_name }}({{ $first_unit->short_name }})
									<br>
								@endif
									
								@if (!empty($product->second_conversion_unit_id))
									@php
										$sold_second_quantity = $product->total_sold ?? 0;
									@endphp
										@if ($product->first_conversion_unit_rate>0 && $product->second_conversion_unit_rate>0)
											@php
												$sold_second_quantity = $sold_second_quantity / ($product->first_conversion_unit_rate * $product->second_conversion_unit_rate);
											@endphp
										@endif
									@php
										$second_unit = App\Unit::where('id', $product->second_conversion_unit_id)->first();
									@endphp
									{{ $sold_second_quantity }} {{ $second_unit->actual_name }}({{ $second_unit->short_name }})
									<br>
								@endif







                        	</td>

                        	<td>
                        		<span data-is_quantity="true" class="display_currency" data-currency_symbol=false >
									{{$product->total_transfered ?? 0}}
								</span>
								{{$product->unit}}




								@if (!empty($product->first_conversion_unit_id))
									<br>
									@php
										$transfered_first_quantity = $product->total_transfered ?? 0;
									@endphp
										@if ($product->first_conversion_unit_rate>0)
											@php
												$transfered_first_quantity = $transfered_first_quantity / $product->first_conversion_unit_rate;
											@endphp
										@endif
									@php
										$first_unit = App\Unit::where('id', $product->first_conversion_unit_id)->first();
									@endphp
									{{ $transfered_first_quantity }} {{ $first_unit->actual_name }}({{ $first_unit->short_name }})
									<br>
								@endif
									
								@if (!empty($product->second_conversion_unit_id))
									@php
										$transfered_second_quantity = $product->total_transfered ?? 0;
									@endphp
										@if ($product->first_conversion_unit_rate>0 && $product->second_conversion_unit_rate>0)
											@php
												$transfered_second_quantity = $transfered_second_quantity / ($product->first_conversion_unit_rate * $product->second_conversion_unit_rate);
											@endphp
										@endif
									@php
										$second_unit = App\Unit::where('id', $product->second_conversion_unit_id)->first();
									@endphp
									{{ $transfered_second_quantity }} {{ $second_unit->actual_name }}({{ $second_unit->short_name }})
									<br>
								@endif


                        	</td>

                        	<td>
                        		<span data-is_quantity="true" class="display_currency" data-currency_symbol=false >
									{{$product->total_adjusted ?? 0}}
								</span>
								{{$product->unit}}





								@if (!empty($product->first_conversion_unit_id))
									<br>
									@php
										$adjusted_first_quantity = $product->total_adjusted ?? 0;
									@endphp
										@if ($product->first_conversion_unit_rate>0)
											@php
												$adjusted_first_quantity = $adjusted_first_quantity / $product->first_conversion_unit_rate;
											@endphp
										@endif
									@php
										$first_unit = App\Unit::where('id', $product->first_conversion_unit_id)->first();
									@endphp
									{{ $adjusted_first_quantity }} {{ $first_unit->actual_name }}({{ $first_unit->short_name }})
									<br>
								@endif
									
								@if (!empty($product->second_conversion_unit_id))
									@php
										$adjusted_second_quantity = $product->total_adjusted ?? 0;
									@endphp
										@if ($product->first_conversion_unit_rate>0 && $product->second_conversion_unit_rate>0)
											@php
												$adjusted_second_quantity = $adjusted_second_quantity / ($product->first_conversion_unit_rate * $product->second_conversion_unit_rate);
											@endphp
										@endif
									@php
										$second_unit = App\Unit::where('id', $product->second_conversion_unit_id)->first();
									@endphp
									{{ $adjusted_second_quantity }} {{ $second_unit->actual_name }}({{ $second_unit->short_name }})
									<br>
								@endif



                        	</td>

	            		</tr>

	            	@endforeach

	            </tbody>
	     	</table>
     	</div>
    </div>
</div>