@extends('layouts.app')
@section('title', __('report.stock_report'))

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1 class="tw-text-sm md:tw-text-sm tw-font-normal tw-text-black">{{ __('report.stock_report')}}</h1>
</section>

<!-- Main content -->
<section class="content">
    <div class="row">
        <div class="col-md-12">
            @component('components.filters', ['title' => __('report.filters')])
            {!! Form::open(['url' => action([\App\Http\Controllers\ReportController::class, 'getStockReport']), 'method'
            => 'get', 'id' => 'stock_report_filter_form' ]) !!}
            <div class="col-md-3">
                <div class="form-group">
                    {!! Form::label('location_id', __('purchase.business_location') . ':') !!}
                    {!! Form::select('location_id', $business_locations, null, ['class' => 'form-control select2',
                    'style' => 'width:100%']); !!}
                </div>
            </div>
            <div class="col-md-3">
                <div class="form-group">
                    {!! Form::label('category_id', __('category.category') . ':') !!}
                    {!! Form::select('category', $categories, null, ['placeholder' => __('messages.all'), 'class' =>
                    'form-control select2', 'style' => 'width:100%', 'id' => 'category_id']); !!}
                </div>
            </div>
            <div class="col-md-3">
                <div class="form-group">
                    {!! Form::label('sub_category_id', __('product.sub_category') . ':') !!}
                    {!! Form::select('sub_category', array(), null, ['placeholder' => __('messages.all'), 'class' =>
                    'form-control select2', 'style' => 'width:100%', 'id' => 'sub_category_id']); !!}
                </div>
            </div>
            <div class="col-md-3">
                <div class="form-group">
                    {!! Form::label('brand', __('product.brand') . ':') !!}
                    {!! Form::select('brand', $brands, null, ['placeholder' => __('messages.all'), 'class' =>
                    'form-control select2', 'style' => 'width:100%']); !!}
                </div>
            </div>
            <div class="col-md-3">
                <div class="form-group">
                    {!! Form::label('unit',__('product.unit') . ':') !!}
                    {!! Form::select('unit', $units, null, ['placeholder' => __('messages.all'), 'class' =>
                    'form-control select2', 'style' => 'width:100%']); !!}
                </div>
            </div>
            @if($show_manufacturing_data)
            <div class="col-md-3">
                <div class="form-group">
                    <br>
                    <div class="checkbox">
                        <label>
                            {!! Form::checkbox('only_mfg', 1, false,
                            [ 'class' => 'input-icheck', 'id' => 'only_mfg_products']); !!} {{
                            __('manufacturing::lang.only_mfg_products') }}
                        </label>
                    </div>
                </div>
            </div>
            @endif
            {!! Form::close() !!}
            @endcomponent
        </div>
    </div>
    @can('view_product_stock_value')
    <div class="row">
        <div class="col-md-12">
            @component('components.widget', ['class' => 'box-solid'])

            <div class="stock-value-summary mb-5">
                <h4 class="text-center mb-4 font-weight-bold">@lang('lang_v1.stock_value_summary')</h4>
                <div class="row">
                    <!-- Purchase Price Card -->
                    <div class="col-md-3 col-sm-6 mb-4">
                        <div class="value-card shadow-sm">
                            <div class="card-header-icon purchase-icon">
                                <i class="fas fa-money-bill-wave"></i>
                            </div>
                            <div class="card-body-content">
                                <h5 class="card-title">
                                    @lang('report.closing_stock')<br>(@lang('lang_v1.by_purchase_price'))</h5>
                                <div class="card-value" id="closing_stock_by_pp">-</div>
                            </div>
                        </div>
                    </div>

                    <!-- Sale Price Card -->
                    <div class="col-md-3 col-sm-6 mb-4">
                        <div class="value-card shadow-sm">
                            <div class="card-header-icon sale-icon">
                                <i class="fas fa-tags"></i>
                                <span class="price-label" id="current_price_group_badge">Default</span>
                            </div>
                            <div class="card-body-content">
                                <h5 class="card-title">@lang('report.closing_stock') (<span
                                        id="current_price_group_label">Default Price</span>)</h5>
                                <div class="card-value" id="closing_stock_by_sp">-</div>
                            </div>
                        </div>
                    </div>

                    <!-- Potential Profit Card -->
                    <div class="col-md-3 col-sm-6 mb-4">
                        <div class="value-card shadow-sm">
                            <div class="card-header-icon profit-icon">
                                <i class="fas fa-chart-line"></i>
                            </div>
                            <div class="card-body-content">
                                <h5 class="card-title">@lang('lang_v1.potential_profit')</h5>
                                <div class="card-value" id="potential_profit">-</div>
                            </div>
                        </div>
                    </div>

                    <!-- Profit Margin Card -->
                    <div class="col-md-3 col-sm-6 mb-4">
                        <div class="value-card shadow-sm">
                            <div class="card-header-icon margin-icon">
                                <i class="fas fa-percentage"></i>
                            </div>
                            <div class="card-body-content">
                                <h5 class="card-title">@lang('lang_v1.profit_margin')</h5>
                                <div class="card-value" id="profit_margin">-</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Price Group Comparison Table -->
            @if($selling_price_groups->count() > 0)
            <div class="price-group-comparison mb-5">
                <h4 class="text-center mb-4 font-weight-bold">@lang('lang_v1.price_group_comparison')</h4>
                <div class="table-responsive">
                    <table class="table custom-table">
                        <thead>
                            <tr>
                                <th>Price Group</th>
                                <th class="text-right">Purchase Value</th>
                                <th class="text-right">Sale Value</th>
                                <th class="text-right">Potential Profit</th>
                                <th class="text-right">Profit Margin</th>
                            </tr>
                        </thead>
                        <tbody id="price_group_comparison_body">
                            <!-- Will be filled by JavaScript -->
                        </tbody>
                    </table>
                </div>
            </div>
            @endif

            @endcomponent
        </div>
    </div>
    @endcan
    <div class="row">
        <div class="col-md-12">
            @component('components.widget', ['class' => 'box-solid'])
            @include('report.partials.stock_report_table')
            @endcomponent
        </div>
    </div>
</section>
<!-- /.content -->

@endsection
@section('css')
<style>
    /* Stock Value Summary Styling */
    .stock-value-summary h4 {
        color: #333;
        font-size: 1.4rem;
        position: relative;
        padding-bottom: 12px;
    }

    .stock-value-summary h4:after {
        content: '';
        position: absolute;
        bottom: 0;
        left: 50%;
        transform: translateX(-50%);
        width: 60px;
        height: 3px;
        background: #6777ef;
        border-radius: 3px;
    }

    /* Card Styling */
    .value-card {
        display: flex;
        flex-direction: column;
        height: 100%;
        border-radius: 8px;
        overflow: hidden;
        background: #fff;
        border: 1px solid rgba(0, 0, 0, 0.08);
        transition: all 0.3s ease;
    }

    .value-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 20px rgba(0, 0, 0, 0.1);
    }

    .card-header-icon {
        padding: 20px 15px 15px;
        text-align: center;
        color: white;
        position: relative;
    }

    .card-header-icon i {
        font-size: 2rem;
        margin-bottom: 5px;
    }

    .purchase-icon {
        background: linear-gradient(135deg, #6777ef, #4e5ed9);
    }

    .sale-icon {
        background: linear-gradient(135deg, #63ed7a, #4dbe5e);
    }

    .profit-icon {
        background: linear-gradient(135deg, #9c5bd7, #7d42b9);
    }

    .margin-icon {
        background: linear-gradient(135deg, #fd9644, #e07d2e);
    }

    .card-body-content {
        padding: 20px 15px;
        text-align: center;
        background: white;
        flex-grow: 1;
        display: flex;
        flex-direction: column;
        justify-content: space-between;
        height: 120px;
        /* Fixed height for card body */
    }

    .card-title {
        font-size: 0.9rem;
        color: #666;
        margin-bottom: 15px;
        line-height: 1.3;
        font-weight: 500;
        height: 45px;
        /* Fixed height for all titles */
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .card-value {
        font-size: 1.25rem;
        font-weight: 700;
        color: #333;
        margin-top: auto;
    }

    .price-label {
        position: absolute;
        bottom: -10px;
        right: 10px;
        background: white;
        color: #4dbe5e;
        border-radius: 20px;
        padding: 2px 10px;
        font-size: 0.7rem;
        font-weight: bold;
        box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
    }

    /* Responsive Adjustments */
    @media (max-width: 768px) {
        .value-card {
            margin-bottom: 20px;
        }

        .card-header-icon i {
            font-size: 1.8rem;
        }

        .card-value {
            font-size: 1.1rem;
        }
    }
</style>

<style>
    .price-group-comparison h4 {
        color: #333;
        font-size: 1.4rem;
        position: relative;
        padding-bottom: 12px;
    }

    .price-group-comparison h4:after {
        content: '';
        position: absolute;
        bottom: 0;
        left: 50%;
        transform: translateX(-50%);
        width: 60px;
        height: 3px;
        background: #6777ef;
        border-radius: 3px;
    }

    /* Table Styling */
    .custom-table {
        width: 100%;
        border-collapse: separate;
        border-spacing: 0;
        border-radius: 8px;
        overflow: hidden;
        box-shadow: 0 0 20px rgba(0, 0, 0, 0.05);
        background: white;
        margin-bottom: 0;
    }

    .custom-table thead tr {
        background: linear-gradient(135deg, #6777ef, #4e5ed9);
        color: white;
        text-align: left;
        font-weight: 500;
    }

    .custom-table th {
        padding: 15px;
        border: none;
        font-size: 0.95rem;
        letter-spacing: 0.03em;
        vertical-align: middle;
    }

    .custom-table td {
        padding: 12px 15px;
        border-bottom: 1px solid #f2f2f2;
        border-top: none;
        border-left: none;
        border-right: none;
        font-size: 0.9rem;
        vertical-align: middle;
    }

    .custom-table tbody tr {
        transition: background-color 0.3s ease;
    }

    .custom-table tbody tr:last-child td {
        border-bottom: none;
    }

    .custom-table tbody tr:hover {
        background-color: rgba(103, 119, 239, 0.05);
    }

    /* Highlight positive values in orange */
    .positive-value {
        color: #70b36c;
    }

    /* Highlight negative values in red */
    .negative-value {
        color: #fc544b;
    }
</style>

<style>
    .price-column {
        min-width: 180px;
        max-width: 220px;
        white-space: normal !important;
        word-wrap: break-word !important;
    }

    .price-column .label {
        display: inline-block;
        margin-top: 2px;
    }
</style>
@endsection
@section('javascript')
<script src="{{ asset('js/report.js?v=' . $asset_v) }}"></script>
<script>
    $(document).ready(function() {
        // This will be executed when the document is ready
        // We can add functionality to color profit values
        
        // Find the profit margin cells and color them based on value
        $('#price_group_comparison_body tr').each(function() {
            // Get the profit margin cell (5th column)
            const profitMarginCell = $(this).find('td:nth-child(5)');
            const profitMarginText = profitMarginCell.text().trim();
            
            // Extract the numeric value
            const profitValue = parseFloat(profitMarginText);
            
            // Apply orange color to all profit margin values
            if (!isNaN(profitValue)) {
                profitMarginCell.addClass('positive-value');
            }
        });
    });
</script>
@endsection