@extends('layouts.app')
@section('title', __('lang_v1.all_sales'))

@section('content')

    <!-- Content Header (Page header) -->
    <section class="content-header no-print">
        <h1  class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">@lang('sale.sells')
        </h1>
    </section>

    <!-- Main content -->
    <section class="content no-print">
        @component('components.filters', ['title' => __('report.filters')])
            @include('sell.partials.sell_list_filters')
            @if ($payment_types)
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('payment_method', __('lang_v1.payment_method') . ':') !!}
                        {!! Form::select('payment_method', $payment_types, null, [
                            'class' => 'form-control select2',
                            'style' => 'width:100%',
                            'placeholder' => __('lang_v1.all'),
                        ]) !!}
                    </div>
                </div>
            @endif

            @if (!empty($sources))
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('sell_list_filter_source', __('lang_v1.sources') . ':') !!}

                        {!! Form::select('sell_list_filter_source', $sources, null, [
                            'class' => 'form-control select2',
                            'style' => 'width:100%',
                            'placeholder' => __('lang_v1.all'),
                        ]) !!}
                    </div>
                </div>
            @endif
        @endcomponent
        @component('components.widget', ['class' => 'box-primary', 'title' => __('lang_v1.all_sales')])
            @can('direct_sell.access')
                @slot('tool')
                    <div class="box-tools">
                    <details id="sales-journal-dropdown" class="tw-dw-dropdown tw-relative tw-inline-block tw-text-left pull-right">
                        <summary class="tw-dw-btn tw-bg-gradient-to-r tw-from-indigo-600 tw-to-blue-500 tw-font-bold tw-text-white tw-border-none tw-rounded-full m-2 pull-right">
                            <i class="fa fa-print"></i>
                            Sales journal
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="tw-size-5 tw-ml-1">
                                <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                <path d="M12 15l-6-6h12l-6 6z"></path>
                            </svg>
                        </summary>
                    
                        <ul class="tw-p-2 tw-w-48 tw-absolute tw-right-0 tw-z-10 tw-bg-white tw-rounded-lg tw-shadow-lg tw-ring-1 tw-ring-gray-200 tw-mt-0 focus:tw-outline-none" role="menu" tabindex="-1" style="top: 100%; margin-top: 0.5rem;">
                            <li>
                                <a href="javascript:void(0);" class="tw-flex tw-items-center tw-gap-2 tw-px-3 tw-py-2 tw-text-sm tw-font-medium tw-text-gray-600 tw-transition-all tw-duration-200 tw-rounded-lg hover:tw-text-gray-900 hover:tw-bg-gray-100" role="menuitem" tabindex="-1" id="printSalesJournal">
                                    <i class="fa fa-print"></i>
                                    {{ __('messages.print') }}
                                </a>
                            </li>
                            <li>
                                <a href="javascript:void(0);" class="tw-flex tw-items-center tw-gap-2 tw-px-3 tw-py-2 tw-text-sm tw-font-medium tw-text-gray-600 tw-transition-all tw-duration-200 tw-rounded-lg hover:tw-text-gray-900 hover:tw-bg-gray-100" role="menuitem" tabindex="-1" id="exportSalesJournalToExcel">
                                    <i class="fa fa-file-excel"></i>
                                    {{ __('lang_v1.export_to_excel') }}
                                </a>
                            </li>
                        </ul>
                    </details>
                        <a class="tw-dw-btn tw-bg-gradient-to-r tw-from-indigo-600 tw-to-blue-500 tw-font-bold tw-text-white tw-border-none tw-rounded-full pull-right"
                            href="{{ action([\App\Http\Controllers\SellController::class, 'create']) }}">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none"
                                stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                                class="icon icon-tabler icons-tabler-outline icon-tabler-plus">
                                <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                <path d="M12 5l0 14" />
                                <path d="M5 12l14 0" />
                            </svg> @lang('messages.add')
                        </a>
                    </div>
                @endslot
            @endcan
            @if (auth()->user()->can('direct_sell.view') ||
                    auth()->user()->can('view_own_sell_only') ||
                    auth()->user()->can('view_commission_agent_sell'))
                @php
                    $custom_labels = json_decode(session('business.custom_labels'), true);
                @endphp
                <table class="table table-bordered table-striped ajax_view" id="sell_table">
                    <thead>
                        <tr>
                            <th>@lang('messages.action')</th>
                            <th>@lang('messages.date')</th>
                            <th>@lang('sale.invoice_no')</th>
                            <th>@lang('sale.customer_name')</th>
                            <th>@lang('lang_v1.contact_no')</th>
                            <th>@lang('sale.location')</th>
                            <th>@lang('sale.payment_status')</th>
                            <th>@lang('lang_v1.payment_method')</th>
                            <th>@lang('sale.total_amount')</th>
                            <th>@lang('sale.total_paid')</th>
                            <th>@lang('lang_v1.sell_due')</th>
                            <th>@lang('lang_v1.sell_return_due')</th>
                            <th>@lang('lang_v1.shipping_status')</th>
                            <th>@lang('lang_v1.total_items')</th>
                            <th>@lang('lang_v1.types_of_service')</th>
                            <th>{{ $custom_labels['types_of_service']['custom_field_1'] ?? __('lang_v1.service_custom_field_1') }}
                            </th>
                            <th>{{ $custom_labels['sell']['custom_field_1'] ?? '' }}</th>
                            <th>{{ $custom_labels['sell']['custom_field_2'] ?? '' }}</th>
                            <th>{{ $custom_labels['sell']['custom_field_3'] ?? '' }}</th>
                            <th>{{ $custom_labels['sell']['custom_field_4'] ?? '' }}</th>
                            <th>@lang('lang_v1.added_by')</th>
                            <th>@lang('sale.sell_note')</th>
                            <th>@lang('sale.staff_note')</th>
                            <th>@lang('sale.shipping_details')</th>
                            <th>@lang('restaurant.table')</th>
                            <th>@lang('restaurant.service_staff')</th>
                        </tr>
                    </thead>
                    <tbody></tbody>
                    <tfoot>
                        <tr class="bg-gray font-17 footer-total text-center">
                            <td colspan="6"><strong>@lang('sale.total'):</strong></td>
                            <td class="footer_payment_status_count"></td>
                            <td class="payment_method_count"></td>
                            <td class="footer_sale_total"></td>
                            <td class="footer_total_paid"></td>
                            <td class="footer_total_remaining"></td>
                            <td class="footer_total_sell_return_due"></td>
                            <td colspan="2"></td>
                            <td class="service_type_count"></td>
                            <td colspan="7"></td>
                        </tr>
                    </tfoot>
                </table>
            @endif
        @endcomponent
    </section>
    <!-- /.content -->
    <div class="modal fade payment_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel">
    </div>

    <div class="modal fade edit_payment_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel">
    </div>

    <!-- This will be printed -->
    <section class="invoice print_section" id="receipt_section">
        </section> 

@stop

@section('javascript')
    <script type="text/javascript">
        $(document).ready(function() {
            //Date range as a button
            $('#sell_list_filter_date_range').daterangepicker(
                dateRangeSettings,
                function(start, end) {
                    $('#sell_list_filter_date_range').val(start.format(moment_date_format) + ' ~ ' + end.format(
                        moment_date_format));
                    sell_table.ajax.reload();
                }
            );
            $('#sell_list_filter_date_range').on('cancel.daterangepicker', function(ev, picker) {
                $('#sell_list_filter_date_range').val('');
                sell_table.ajax.reload();
            });

            sell_table = $('#sell_table').DataTable({
                processing: true,
                serverSide: true,
                fixedHeader:false,
                aaSorting: [
                    [1, 'desc']
                ],
                "ajax": {
                    "url": "/sells",
                    "data": function(d) {
                        if ($('#sell_list_filter_date_range').val()) {
                            var start = $('#sell_list_filter_date_range').data('daterangepicker')
                                .startDate.format('YYYY-MM-DD');
                            var end = $('#sell_list_filter_date_range').data('daterangepicker').endDate
                                .format('YYYY-MM-DD');
                            d.start_date = start;
                            d.end_date = end;
                        }
                        d.is_direct_sale = 1;

                        d.location_id = $('#sell_list_filter_location_id').val();
                        d.customer_id = $('#sell_list_filter_customer_id').val();
                        d.payment_status = $('#sell_list_filter_payment_status').val();
                        d.created_by = $('#created_by').val();
                        d.sales_cmsn_agnt = $('#sales_cmsn_agnt').val();
                        d.service_staffs = $('#service_staffs').val();

                        if ($('#shipping_status').length) {
                            d.shipping_status = $('#shipping_status').val();
                        }

                        if ($('#sell_list_filter_source').length) {
                            d.source = $('#sell_list_filter_source').val();
                        }

                        if ($('#only_subscriptions').is(':checked')) {
                            d.only_subscriptions = 1;
                        }

                        if ($('#payment_method').length) {
                            d.payment_method = $('#payment_method').val();
                        }

                        d = __datatable_ajax_callback(d);
                    }
                },
                scrollY: "75vh",
                scrollX: true,
                scrollCollapse: true,
                columns: [{
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        "searchable": false
                    },
                    {
                        data: 'transaction_date',
                        name: 'transaction_date'
                    },
                    {
                        data: 'invoice_no',
                        name: 'invoice_no'
                    },
                    {
                        data: 'conatct_name',
                        name: 'conatct_name'
                    },
                    {
                        data: 'mobile',
                        name: 'contacts.mobile'
                    },
                    {
                        data: 'business_location',
                        name: 'bl.name'
                    },
                    {
                        data: 'payment_status',
                        name: 'payment_status'
                    },
                    {
                        data: 'payment_methods',
                        orderable: false,
                        "searchable": false
                    },
                    {
                        data: 'final_total',
                        name: 'final_total'
                    },
                    {
                        data: 'total_paid',
                        name: 'total_paid',
                        "searchable": false
                    },
                    {
                        data: 'total_remaining',
                        name: 'total_remaining'
                    },
                    {
                        data: 'return_due',
                        orderable: false,
                        "searchable": false
                    },
                    {
                        data: 'shipping_status',
                        name: 'shipping_status'
                    },
                    {
                        data: 'total_items',
                        name: 'total_items',
                        "searchable": false
                    },
                    {
                        data: 'types_of_service_name',
                        name: 'tos.name',
                        @if (empty($is_types_service_enabled))
                            visible: false
                        @endif
                    },
                    {
                        data: 'service_custom_field_1',
                        name: 'service_custom_field_1',
                        @if (empty($is_types_service_enabled))
                            visible: false
                        @endif
                    },
                    {
                        data: 'custom_field_1',
                        name: 'transactions.custom_field_1',
                        @if (empty($custom_labels['sell']['custom_field_1']))
                            visible: false
                        @endif
                    },
                    {
                        data: 'custom_field_2',
                        name: 'transactions.custom_field_2',
                        @if (empty($custom_labels['sell']['custom_field_2']))
                            visible: false
                        @endif
                    },
                    {
                        data: 'custom_field_3',
                        name: 'transactions.custom_field_3',
                        @if (empty($custom_labels['sell']['custom_field_3']))
                            visible: false
                        @endif
                    },
                    {
                        data: 'custom_field_4',
                        name: 'transactions.custom_field_4',
                        @if (empty($custom_labels['sell']['custom_field_4']))
                            visible: false
                        @endif
                    },
                    {
                        data: 'added_by',
                        name: 'u.first_name'
                    },
                    {
                        data: 'additional_notes',
                        name: 'additional_notes'
                    },
                    {
                        data: 'staff_note',
                        name: 'staff_note'
                    },
                    {
                        data: 'shipping_details',
                        name: 'shipping_details'
                    },
                    {
                        data: 'table_name',
                        name: 'tables.name',
                        @if (empty($is_tables_enabled))
                            visible: false
                        @endif
                    },
                    {
                        data: 'waiter',
                        name: 'ss.first_name',
                        @if (empty($is_service_staff_enabled))
                            visible: false
                        @endif
                    },
                ],
                "fnDrawCallback": function(oSettings) {
                    __currency_convert_recursively($('#sell_table'));
                },
                "footerCallback": function(row, data, start, end, display) {
                    var footer_sale_total = 0;
                    var footer_total_paid = 0;
                    var footer_total_remaining = 0;
                    var footer_total_sell_return_due = 0;
                    for (var r in data) {
                        footer_sale_total += $(data[r].final_total).data('orig-value') ? parseFloat($(
                            data[r].final_total).data('orig-value')) : 0;
                        footer_total_paid += $(data[r].total_paid).data('orig-value') ? parseFloat($(
                            data[r].total_paid).data('orig-value')) : 0;
                        footer_total_remaining += $(data[r].total_remaining).data('orig-value') ?
                            parseFloat($(data[r].total_remaining).data('orig-value')) : 0;
                        footer_total_sell_return_due += $(data[r].return_due).find('.sell_return_due')
                            .data('orig-value') ? parseFloat($(data[r].return_due).find(
                                '.sell_return_due').data('orig-value')) : 0;
                    }

                    $('.footer_total_sell_return_due').html(__currency_trans_from_en(
                        footer_total_sell_return_due));
                    $('.footer_total_remaining').html(__currency_trans_from_en(footer_total_remaining));
                    $('.footer_total_paid').html(__currency_trans_from_en(footer_total_paid));
                    $('.footer_sale_total').html(__currency_trans_from_en(footer_sale_total));

                    $('.footer_payment_status_count').html(__count_status(data, 'payment_status'));
                    $('.service_type_count').html(__count_status(data, 'types_of_service_name'));
                    $('.payment_method_count').html(__count_status(data, 'payment_methods'));
                },
                createdRow: function(row, data, dataIndex) {
                    $(row).find('td:eq(6)').attr('class', 'clickable_td');
                }
            });

            $(document).on('change',
                '#sell_list_filter_location_id, #sell_list_filter_customer_id, #sell_list_filter_payment_status, #created_by, #sales_cmsn_agnt, #service_staffs, #shipping_status, #sell_list_filter_source, #payment_method',
                function() {
                    sell_table.ajax.reload();
                });

            $('#only_subscriptions').on('ifChanged', function(event) {
                sell_table.ajax.reload();
            });
        });
    </script>
    <script src="{{ asset('js/payment.js?v=' . $asset_v) }}"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.18.5/xlsx.full.min.js"></script>

    <script type="text/javascript">
        $(document).ready(function() {
           // Content function
           function getPrintContent() {
                                var table = $('#sell_table').DataTable();
                        
                        // Obtenir la date actuelle ou la plage de dates sélectionnée
                        var dateRange = $('#sell_list_filter_date_range').val();
                        var formattedDate;

                        if (dateRange) {
                            formattedDate = dateRange;
                        } else {
                            var today = new Date();
                            var day = String(today.getDate()).padStart(2, '0');
                            var month = String(today.getMonth() + 1).padStart(2, '0'); // Les mois commencent à 0
                            var year = today.getFullYear();
                            formattedDate = `${day}/${month}/${year}`;
                        }

                        // Obtenir le location_id sélectionné
                        var locationId = $('#sell_list_filter_location_id option:selected').text();
                        var locationText = locationId ? ` Location ${locationId}`:'';

                        // Créer un contenu HTML pour l'impression
                        var printContent = `
                                    <html>
                                    <head>
                                        <title>{{ __('lang_v1.sales_journal') }}</title>
                                        <style>
                                        
                                        body {
                                        font-family: Arial, sans-serif;
                                        font-size: 10px;
                                        margin: 6px;
                                        -webkit-print-color-adjust: exact; /* Ensures print color accuracy */
                                    }

                                    h2, h3 {
                                        text-align: center;
                                        margin-bottom: 5px;
                                    }

                                    table {
                                        width: 100%;
                                        border-collapse: collapse;
                                        page-break-inside: auto; /* Allow table to break inside */
                                        margin-bottom: 20px; /* Ensure space after the table */
                                        page-break-after: auto; /* Ensure table doesn't completely move to the next page */
                                    }

                                    thead {
                                        display: table-header-group; /* Repeats the header on each page */
                                        page-break-inside: avoid; /* Prevent thead from breaking */
                                        page-break-after: avoid; /* Prevent header from being alone on a page */
                                    }

                                    tfoot {
                                        display: table-footer-group; /* Ensure the footer appears at the bottom */
                                        page-break-inside: avoid; /* Prevent footer from breaking */
                                        page-break-before: avoid; /* Prevent footer from being pushed to next page */
                                    }

                                    tbody {
                                        display: table-row-group;
                                        page-break-inside: avoid; /* Prevent rows from breaking inside */
                                    }

                                    tr {
                                        page-break-inside: avoid; /* Prevent row splitting */
                                        page-break-before: auto; /* Allow rows to flow naturally */
                                    }

                                    td, th {
                                        border: 1px solid black;
                                        font-size: 12px;
                                        padding: 4px;
                                        text-align: left;
                                    }

                                    th {
                                        background-color: #f2f2f2;
                                        text-align: center;
                                    }

                                    tfoot td {
                                        font-weight: bold;
                                        text-align: left;
                                    }

                                    @page {
                                        margin: 10mm 5mm 10mm 5mm; /* Ensure sufficient space for the content */
                                    }

                                    /* Tighter padding to fit content better */
                                    th, td {
                                        padding: 3px; /* Reduce padding for better fit */
                                    }

                                    /* Force table to not jump to the next page unnecessarily */
                                    @media print {
                                        h2, h3 {
                                            page-break-after: avoid; /* Keep the title with the table */
                                        }

                                        /* Additional Chrome-specific print optimizations */
                                        @supports (-webkit-print-color-adjust: exact) {
                                            table {
                                                page-break-inside: auto;
                                            }
                                        }
                                    }
                                    thead {
                                        display: table-header-group; /* This ensures the header appears, but we will control its behavior */
                                        page-break-after: avoid; /* Avoid breaking after the header */
                                    }

                                    @media print {
                                        thead {
                                            display: none; /* Completely hide the header for printing */
                                        }

                                        thead:first-of-type {
                                            display: table-header-group; /* Display the header only once, on the first page */
                                        }

                                        tbody {
                                            page-break-inside: auto; /* Allow body content to break across pages */
                                        }
                                    }

                                                    
                                        </style>
                                    </head>
                                    <body>
                                    <h2 style="border: 0.05rem solid; border-radius: 5px; padding: 5px;  text-align: center;">${locationText}: </h2> 
                                <h3 style="text-align: center;">{{ __('lang_v1.sales_journal') }} - ${formattedDate}</h3>
                                        <table>
                                            <thead>
                                                <tr>
                                                    <th style="text-align:center" width="4px">#</th>
                                                    <th style="text-wrap: nowrap;text-align:center">N°.</th>
                                                    <th style="text-align:center">{{ __('sale.amount') }}</th>
                                                    <th style="text-align:center">{{ __('sale.total_paid') }}</th>
                                                    <th style="text-align:center">{{ __('lang_v1.mode') }}</th>
                                                    <th style="text-align:center">{{ __('lang_v1.qty_prd') }}</th>
                                                    <th style="text-align:center">{{ __('lang_v1.commission_agent') }}</th>
                                                    <th style="text-align:center">{{ __('contact.customer') }}</th>
                                                    <th style="text-align:center">{{ __('lang_v1.customer_group') }}</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                `;

                        // Iterate through the rows of the DataTable and add a counter for the row number

                        var lineNumber = 1;
                        var totalPaidSum = 0;
                        var totalQteSum = 0;
                        var paymentMethodsCount = {};
                        var paymentMethodsTotalPaid = {};
                        var paymentMethodsFinalTotal = {};

                        var commissionAgentsCount = {};
                        var commissionAgentsTotalPaid = {};
                        var commissionAgentsFinalTotal = {};

                        var customerGroupCount = {};
                        var customerGroupTotalPaid = {};
                        var customerGroupFinalTotal = {};

                        var categoryByCount = {};
                        var categoryByTotalPaid = {};
                        var categoryByFinalTotal = {};

                        var locationByCount = {};
                        var locationByTotalPaid = {};
                        var locationByFinalTotal = {};

                        var finalTotalSum = 0;
                        var totalDiscount = 0;


                        table.rows().every(function () {
                            var data = this.data();
                         console.log(data);
                            
                            var cleanedTotalPaid = parseFloat(data.total_paid.replace(/[^\d.,]/g, '').replace(',', '.')) || 0;
                            totalPaidSum += cleanedTotalPaid;
                            var cleanedFinalTotal = parseFloat(data.final_total.replace(/[^\d.,]/g, '').replace(',', '.')) || 0;
                            finalTotalSum += cleanedFinalTotal;
                            
                            // Clean currency symbol from data.discount_amount
                            var cleanedtotalDiscount = parseFloat(data.discount_amount.replace(/[^\d.,]/g, '').replace(',', '.')) || 0;

                            totalDiscount += cleanedtotalDiscount;
                            
                            if (data.sell_lines && data.sell_lines.length > 0) {
                                for (var i = 0; i < data.sell_lines.length; i++) {
                                    var cleanedItem = parseFloat(data.sell_lines[i].line_discount_amount.replace(/[^\d.,]/g, '').replace(',', '.')) || 0;

                                    totalDiscount += cleanedItem;
                                }
                            }

                            // Check if paymentMethod is empty and set it to "CREDIT"
                            var paymentMethod = data.payment_methods.trim();

                            if (paymentMethod === '') {
                                paymentMethod = 'CREDIT';
                            }

                            if (paymentMethodsCount[paymentMethod]) {
                                paymentMethodsCount[paymentMethod]++;
                                paymentMethodsTotalPaid[paymentMethod] += cleanedTotalPaid;
                                paymentMethodsFinalTotal[paymentMethod] += cleanedFinalTotal;
                            } else {
                                paymentMethodsCount[paymentMethod] = 1;
                                paymentMethodsTotalPaid[paymentMethod] = cleanedTotalPaid;
                                paymentMethodsFinalTotal[paymentMethod] = cleanedFinalTotal;

                            }

                            // Commission agents
                            var commissionAgent = data.commission_agent;
                            if (commissionAgent === '' || commissionAgent === null || commissionAgent === undefined || commissionAgent === ' ' || commissionAgent === '  ') {
                                commissionAgent = '--';
                            }
                            if (commissionAgentsCount[commissionAgent]) {
                                commissionAgentsCount[commissionAgent]++;
                                commissionAgentsTotalPaid[commissionAgent] += cleanedTotalPaid
                                commissionAgentsFinalTotal[commissionAgent] += cleanedFinalTotal


                            } else {
                                commissionAgentsCount[commissionAgent] = 1;
                                commissionAgentsTotalPaid[commissionAgent] = cleanedTotalPaid
                                commissionAgentsFinalTotal[commissionAgent] = cleanedFinalTotal
                            }


                            // Customer group
                            var customerGroup = data.customer_group;
                            if (customerGroup === '' || customerGroup === null || customerGroup === undefined || customerGroup === ' ' || customerGroup === '  ') {
                                customerGroup = '{{ __('product.default_selling_price') }}';
                            }
                            if (customerGroupCount[customerGroup]) {
                                customerGroupCount[customerGroup]++;
                                customerGroupFinalTotal[customerGroup] += cleanedFinalTotal;
                                customerGroupTotalPaid[customerGroup] += cleanedTotalPaid
                            } else {
                                customerGroupCount[customerGroup] = 1;
                                customerGroupFinalTotal[customerGroup] = cleanedFinalTotal;
                                customerGroupTotalPaid[customerGroup] = cleanedTotalPaid
                            }

                            // Category
                            if (data.sell_lines && data.sell_lines.length > 0 &&
                        data.sell_lines[0].product && data.sell_lines[0].product.category) {

                        var category = data.sell_lines[0].product.category.name;
                        //  console.log('Category:', category);

                        } else {
                        var category = '';
                        // console.warn('Product category or sell lines data is missing.');
                        }
                            if (category === '') {
                                category = '--';
                            }
                            if (categoryByCount[category]) {
                                categoryByCount[category]++;
                                categoryByFinalTotal[category] += cleanedFinalTotal;
                                categoryByTotalPaid[category] += cleanedTotalPaid
                            } else {
                                categoryByCount[category] = 1;
                                categoryByFinalTotal[category] = cleanedFinalTotal;
                                categoryByTotalPaid[category] = cleanedTotalPaid
                            }

                            // Location
                            var location = data.business_location;
                            if (location === '' || location === null || location === undefined || location === ' ' || location === '  ') {
                                location = '--';
                            }
                            if (locationByCount[location]) {
                                locationByCount[location]++;
                                locationByFinalTotal[location] += cleanedFinalTotal;
                                locationByTotalPaid[location] += cleanedTotalPaid
                            } else {
                                locationByCount[location] = 1;
                                locationByFinalTotal[location] = cleanedFinalTotal;
                                locationByTotalPaid[location] = cleanedTotalPaid
                            }




                            var totalItems = parseFloat(data.total_items) || 0;
                                // Ensure htmlString has a default value if both data.name and data.contact_name are undefined
                                var htmlString = (data.name && data.name.trim() !== '') ? data.name : (data.supplier_business_name || '');

                                // Initialize customer variable
                                var customer;

                                // Check if the content contains an anchor tag (business case with HTML)
                                if (htmlString.includes('<a')) {
                                    var tempDiv = document.createElement('div');
                                    tempDiv.innerHTML = htmlString;

                                    // Get the anchor tag inside tempDiv
                                    var anchorTag = tempDiv.querySelector('a');

                                    // Set the customer variable to either the anchor text or a default value
                                    customer = anchorTag ? anchorTag.textContent.trim() : "--";
                                } else {
                                    // If it's just plain text (individual case), use it directly
                                    customer = htmlString.trim();
                                }

                                                    var customer_group = data.customer_group ? data.customer_group : '{{ __('product.default_selling_price') }}';
                                                var commission_agent = data.commission_agent ? data.commission_agent : '--';
                                                // Format cleanedTotalPaid with commas for thousands and fixed decimal places
                                                var formattedTotalPaid = cleanedTotalPaid.toLocaleString('en-US', {
                                                    minimumFractionDigits: 2,
                                                    maximumFractionDigits: 2
                                                });
                                                totalQteSum += totalItems;
                                                    // Format cleanedFinalTotal with commas for thousands and fixed decimal places
                                                    var formattedFinalTotal = cleanedFinalTotal.toLocaleString('en-US', {
                                                    minimumFractionDigits: 2,
                                                    maximumFractionDigits: 2
                                                });
                                                printContent += `
                                                        <tr>
                                                            <td>${lineNumber}</td>
                                                            <td style="text-wrap: nowrap;">${data.invoice_no}</td>
                                                            <td style="text-align:right">${formattedFinalTotal}</td>
                                                            <td style="text-align:right">${formattedTotalPaid}</td>
                                                            <td>${paymentMethod}</td>
                                                            <td style="text-align:right">${totalItems} P</td>
                                                            <td style="text-align:right">${commission_agent}</td>
                                                            <td style="text-align:right">${customer}</td>
                                                            <td style="text-align:right">${customer_group}</td>
                                                        </tr>
                                                    `;
                                                lineNumber++;
                                            });
                                    
                                
                                        // Payment Methods Footer
                                        var paymentMethodsFooter = '';
                                        for (var method in paymentMethodsCount) {
                                                            // Format the payment method amount for display
                                                    var formattedTotalPaid = paymentMethodsTotalPaid[method].toLocaleString('en-US', {
                                                        minimumFractionDigits: 2,
                                                        maximumFractionDigits: 2
                                                            });
                                                    var formattedFinalTotal = paymentMethodsFinalTotal[method].toLocaleString('en-US', {
                                                        minimumFractionDigits: 2,
                                                        maximumFractionDigits: 2
                                                            });
                                    
                                        paymentMethodsFooter += `
                                        <tr>
                                            <tr>
                                                <td colspan="4" style="font-weight: normal;">${method}</td>
                                                <td colspan="3" style="text-align:right; font-weight: normal;">${formattedFinalTotal}</td> <!-- Display formatted amount -->
                                                <td colspan="2" style="text-align:center; font-weight: normal;">${paymentMethodsCount[method]}</td>
                                            </tr>`;
                                        }
                                    
                                            var footerTotalPaid = totalPaidSum;
                                            // Format footerTotalPaid for display
                                            var formattedFooterTotalPaid = footerTotalPaid.toLocaleString('en-US', {
                                                minimumFractionDigits: 2,
                                            maximumFractionDigits: 2
                                        });
                                            var footerTotalAmount = finalTotalSum;
                                            // Format footerTotalPaid for display
                                            var formattedFooterFinalTotal = footerTotalAmount.toLocaleString('en-US', {
                                                minimumFractionDigits: 2,
                                            maximumFractionDigits: 2
                                        });
                                            var footerTotalDiscount = totalDiscount;
                                            // Format footerTotalDiscount for display
                                            var formattedFooterTotalDiscount = footerTotalDiscount.toLocaleString('en-US', {
                                                minimumFractionDigits: 2,
                                            maximumFractionDigits: 2
                                        });
                                    
                                            // Commission Agents Footer
                                            var commissionAgentsFooter = '';
                                            for (var agent in commissionAgentsCount) {
                                            // Format the commission agent amount for display
                                            var formattedFinalTotal = commissionAgentsFinalTotal[agent].toLocaleString('en-US', {
                                                minimumFractionDigits: 2,
                                            maximumFractionDigits: 2
                                            });
                                            var formattedTotalPaid = commissionAgentsTotalPaid[agent].toLocaleString('en-US', {
                                                minimumFractionDigits: 2,
                                            maximumFractionDigits: 2
                                            });
                                    
                                            commissionAgentsFooter += `
                                            <tr>
                                                <tr>
                                                    <td colspan="3" style="font-weight: normal;">${agent}</td>
                                                    <td colspan="2" style="text-align:right; font-weight: normal;">${formattedFinalTotal}</td> <!-- Display formatted amount -->
                                                    <td colspan="2" style="text-align:right; font-weight: normal;">${formattedTotalPaid}</td> <!-- Display formatted amount -->
                                                    <td colspan="2" style="text-align:center; font-weight: normal;">${commissionAgentsCount[agent]}</td>
                                                </tr>`;
                                        }
                                    
                                    
                                                        // Customer Group Footer
                                                        var customerGroupFooter = '';
                                                    for (var group in customerGroupCount) {
                                            // Format the customer group amount for display
                                            var formattedFinalTotal = customerGroupFinalTotal[group].toLocaleString('en-US', {
                                                        minimumFractionDigits: 2,
                                                    maximumFractionDigits: 2
                                            });
                                            var formattedTotalPaid = customerGroupTotalPaid[group].toLocaleString('en-US', {
                                                        minimumFractionDigits: 2,
                                                    maximumFractionDigits: 2
                                            });
                                    
                                                    customerGroupFooter += `
                                                    <tr>
                                                        <tr>
                                                            <td colspan="3" style="font-weight: normal;">${group}</td>
                                                            <td colspan="2" style="text-align:right;font-weight: normal;">${formattedFinalTotal}</td> <!-- Display formatted amount -->
                                                            <td colspan="2" style="text-align:right;font-weight: normal;">${formattedTotalPaid}</td> <!-- Display formatted amount -->
                                                            <td colspan="2" style="text-align:center;font-weight: normal;">${customerGroupCount[group]}</td>
                                                        </tr>`;
                                        }
                                    
                                                        // product Categories Footer
                                                        var productCategoriesFooter = '';
                                                        for (var category in categoryByCount) {
                                            // Format the product category amount for display
                                            var formattedFinalTotal = categoryByFinalTotal[category].toLocaleString('en-US', {
                                                            minimumFractionDigits: 2,
                                                        maximumFractionDigits: 2
                                            });
                                            var formattedTotalPaid = categoryByFinalTotal[category].toLocaleString('en-US', {
                                                            minimumFractionDigits: 2,
                                                        maximumFractionDigits: 2
                                            });
                                    
                                                        productCategoriesFooter += `
                                                        <tr>
                                                            <tr>
                                                                <td colspan="3" style="font-weight: normal;">${category}</td>
                                                                <td colspan="2" style="text-align:right;font-weight: normal;">${formattedFinalTotal}</td> <!-- Display formatted amount -->
                                                                <td colspan="2" style="text-align:right;font-weight: normal;">${formattedTotalPaid}</td> <!-- Display formatted amount -->
                                                                <td colspan="2" style="text-align:center;font-weight: normal;">${categoryByCount[category]}</td>
                                                            </tr>`;
                                        }
                                    
                                                            // Locations Footer
                                                            var locationsFooter = '';
                                                            for (var location in locationByCount) {
                                            // Format the location amount for display
                                            var formattedFinalTotal = locationByFinalTotal[location].toLocaleString('en-US', {
                                                                minimumFractionDigits: 2,
                                                            maximumFractionDigits: 2
                                            });
                                    
                                            var formattedTotalPaid = locationByTotalPaid[location].toLocaleString('en-US', {
                                                                minimumFractionDigits: 2,
                                                            maximumFractionDigits: 2
                                            });
                                    
                                                            locationsFooter += `
                                                            <tr>
                                                                <tr>
                                                                    <td colspan="3" style="font-weight: normal;">${location}</td>
                                                                    <td colspan="2" style="text-align:right;font-weight: normal;">${formattedFinalTotal}</td> <!-- Display formatted amount -->
                                                                    <td colspan="2" style="text-align:right;font-weight: normal;">${formattedTotalPaid}</td> <!-- Display formatted amount -->
                                                                    <td colspan="2" style="text-align:center;font-weight: normal;">${locationByCount[location]}</td>
                                                                </tr>`;
                                        }
                                    
                                                                printContent += `
                                                            </tbody>
                                                            <tfoot>
                                                                <tr>
                                                                    <td colspan="4" style="background-color: #f2f2f2;text-align:center" style="text-align:center">
                                                                        {{ __('lang_v1.total_amount') }} : ${formattedFooterFinalTotal}  / {{ __('lang_v1.total_discount') }} : ${formattedFooterTotalDiscount}
                                                                        </td>
                                                                    <td colspan="3" style="background-color: #f2f2f2;text-align:center" style="text-align:center">{{ __('sale.total_paid') }} :
                                                                        ${formattedFooterTotalPaid} </td>
                                                                    <td colspan="2" style="background-color: #f2f2f2;text-align:center ">{{ __('lang_v1.qty_total') }} :
                                                                        ${totalQteSum} {{ __('lang_v1.units') }}</td>
                                                                </tr>
                                                                <tr><td colspan="9" style="text-align:center">D E T A I L S</td></tr>
                                                                <tr><td colspan="9" style="text-align:center; background-color: #f2f2f2;">A:{{ strtoupper(__('sale.payment_mode')) }}</td></tr>
                                                                <tr>
                                                                    <td colspan="4" style="text-align:center">{{ __('lang_v1.mode') }}</td>
                                                                    <td colspan="3" style="text-align:center">{{ __('lang_v1.total_amount') }}</td>
                                                                    <td colspan="2" style="text-align:center">{{ __('lang_v1.number') }}</td>
                                    
                                                                </tr>
                                                                ${paymentMethodsFooter}
                                                                <tr><td colspan="9" style="text-align:center; background-color: #f2f2f2;">B:{{ strtoupper(__('lang_v1.customer_group')) }}</td></tr>
                                                                <tr>
                                                                    <td colspan="3" style="text-align:center">{{ __('contact.customer') }}</td>
                                                                    <td colspan="2" style="text-align:center">{{ __('lang_v1.total_amount') }}</td>
                                                                    <td colspan="2" style="text-align:center">{{ __('sale.total_paid') }}</td>
                                                                    <td colspan="2" style="text-align:center">{{ __('lang_v1.number') }}</td>
                                    
                                                                </tr>
                                                                ${customerGroupFooter}
                                                                <tr><td colspan="9" style="text-align:center; background-color: #f2f2f2;">C:{{ strtoupper(__('lang_v1.commission_agent')) }}</td></tr>
                                                                <tr>
                                                                    <td colspan="3" style="text-align:center">{{ __('lang_v1.commission_agent') }}</td>
                                                                    <td colspan="2" style="text-align:center">{{ __('lang_v1.total_amount') }}</td>
                                                                    <td colspan="2" style="text-align:center">{{ __('sale.total_paid') }}</td>
                                                                    <td colspan="2" style="text-align:center">{{ __('lang_v1.number') }}</td>
                                    
                                                                </tr>
                                                                ${commissionAgentsFooter}
                                                                <tr><td colspan="9" style="text-align:center; background-color: #f2f2f2;">D:{{ strtoupper(__('lang_v1.product_category')) }}</td></tr>
                                                                <tr>
                                                                    <td colspan="3" style="text-align:center">{{ __('category.category') }}</td>
                                                                    <td colspan="2" style="text-align:center">{{ __('lang_v1.total_amount') }}</td>
                                                                    <td colspan="2" style="text-align:center">{{ __('sale.total_paid') }}</td>
                                                                    <td colspan="2" style="text-align:center">{{ __('lang_v1.number') }}</td>
                                    
                                                                </tr>
                                                                ${productCategoriesFooter}
                                                                <tr><td colspan="9" style="text-align:center; background-color: #f2f2f2;">E:{{ strtoupper(__('business.location')) }}</td></tr>
                                                                <tr>
                                                                    <td colspan="3" style="text-align:center">{{ __('business.location') }}</td>
                                                                    <td colspan="2" style="text-align:center">{{ __('lang_v1.total_amount') }}</td>
                                                                    <td colspan="2" style="text-align:center">{{ __('sale.total_paid') }}</td>
                                                                    <td colspan="2" style="text-align:center">{{ __('lang_v1.number') }}</td>
                                    
                                                                </tr>
                                                                ${locationsFooter}
                                    
                                                            </tfoot>
                                                        </table>
                                                    </body>
                                                </html>
                                                `;

                                                return printContent;
           }
            $('#printSalesJournal').on('click', function () {
                
                    var printContent = getPrintContent();        
                                        var printWindow = window.open('', '', 'height=800,width=1000');
                                        printWindow.document.open();
                                        printWindow.document.write(printContent);
                                        printWindow.document.close();
                                        printWindow.focus();
                                        printWindow.print();
                                            });
            $('#exportSalesJournalToExcel').on('click', function () {

           var printContent = getPrintContent();        
           function exportToExcel(filename = 'exported-sales-journal-data') {
            // Create a temporary element to hold the HTML
            var tempDiv = document.createElement('div');
            tempDiv.innerHTML = printContent;

            // Get the table element from the temporary div
            var table = tempDiv.querySelector('table');

            // Add inline CSS for borders to the table and cells
            table.style.borderCollapse = 'collapse';
            table.style.width = '100%';

            const rows = table.querySelectorAll('tr');
            rows.forEach(row => {
                row.style.border = '1px solid black';
                const cells = row.querySelectorAll('td, th');
                cells.forEach(cell => {
                    cell.style.border = '1px solid black';
                    cell.style.padding = '5px'; // Optional: Add some padding
                });
            });

            // Create a new workbook and worksheet
            var workbook = XLSX.utils.book_new();
            var worksheet = XLSX.utils.table_to_sheet(table);

            // Append the worksheet to the workbook
            XLSX.utils.book_append_sheet(workbook, worksheet, 'SalesJournal');

            // Export the workbook to a .xlsx file
            XLSX.writeFile(workbook, filename + ".xlsx");
}

            // Call the export function
            exportToExcel('exported-sales-journal-data');
           
                });
                 });
                                   
            </script>
             <script>
                        // Close the dropdown when clicking outside of it
                        document.addEventListener('click', function(event) {
                            const dropdown = document.getElementById('sales-journal-dropdown');
                            if (!dropdown.contains(event.target)) {
                                dropdown.removeAttribute('open');
                            }
                        });
            </script>
@endsection
