/*M!999999\- enable the sandbox mode */ 

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;
DROP TABLE IF EXISTS `account_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `account_transactions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `account_id` int(11) NOT NULL,
  `type` enum('debit','credit') NOT NULL,
  `sub_type` enum('opening_balance','fund_transfer','deposit') DEFAULT NULL,
  `amount` decimal(22,4) NOT NULL,
  `reff_no` varchar(191) DEFAULT NULL,
  `operation_date` datetime NOT NULL,
  `created_by` int(11) NOT NULL,
  `transaction_id` int(11) DEFAULT NULL,
  `transaction_payment_id` int(11) DEFAULT NULL,
  `transfer_transaction_id` int(11) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `account_transactions_account_id_index` (`account_id`),
  KEY `account_transactions_transaction_id_index` (`transaction_id`),
  KEY `account_transactions_transaction_payment_id_index` (`transaction_payment_id`),
  KEY `account_transactions_transfer_transaction_id_index` (`transfer_transaction_id`),
  KEY `account_transactions_created_by_index` (`created_by`),
  KEY `account_transactions_type_index` (`type`),
  KEY `account_transactions_sub_type_index` (`sub_type`),
  KEY `account_transactions_operation_date_index` (`operation_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `account_transactions` WRITE;
/*!40000 ALTER TABLE `account_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `account_transactions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `account_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `account_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `parent_account_type_id` int(11) DEFAULT NULL,
  `business_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `account_types_parent_account_type_id_index` (`parent_account_type_id`),
  KEY `account_types_business_id_index` (`business_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `account_types` WRITE;
/*!40000 ALTER TABLE `account_types` DISABLE KEYS */;
/*!40000 ALTER TABLE `account_types` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `accounting_acc_trans_mappings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `accounting_acc_trans_mappings` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `ref_no` varchar(100) NOT NULL,
  `type` varchar(100) NOT NULL,
  `created_by` int(11) NOT NULL,
  `operation_date` datetime NOT NULL,
  `note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `accounting_acc_trans_mappings` WRITE;
/*!40000 ALTER TABLE `accounting_acc_trans_mappings` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounting_acc_trans_mappings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `accounting_account_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `accounting_account_types` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `business_id` int(11) DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `account_primary_type` varchar(191) DEFAULT NULL,
  `account_type` varchar(191) DEFAULT NULL,
  `parent_id` bigint(20) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `show_balance` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=155 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `accounting_account_types` WRITE;
/*!40000 ALTER TABLE `accounting_account_types` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounting_account_types` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `accounting_accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `accounting_accounts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `gl_code` varchar(191) DEFAULT NULL,
  `business_id` int(11) NOT NULL,
  `account_primary_type` varchar(191) DEFAULT NULL,
  `account_sub_type_id` bigint(20) DEFAULT NULL,
  `detail_type_id` bigint(20) DEFAULT NULL,
  `parent_account_id` bigint(20) DEFAULT NULL,
  `description` longtext DEFAULT NULL,
  `status` varchar(191) DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `accounting_accounts` WRITE;
/*!40000 ALTER TABLE `accounting_accounts` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounting_accounts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `accounting_accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `accounting_accounts_transactions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `accounting_account_id` bigint(20) unsigned NOT NULL,
  `acc_trans_mapping_id` int(11) DEFAULT NULL COMMENT 'id form accounting_acc_trans_mapping table',
  `transaction_id` int(11) DEFAULT NULL COMMENT 'id form transactions table',
  `transaction_payment_id` int(11) DEFAULT NULL COMMENT 'id form transaction_payments table',
  `amount` decimal(22,4) NOT NULL,
  `type` varchar(100) NOT NULL COMMENT 'debit, credit etc',
  `sub_type` varchar(100) NOT NULL,
  `map_type` varchar(100) DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `operation_date` datetime NOT NULL,
  `note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `accounting_accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounting_accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounting_accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `accounting_budgets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `accounting_budgets` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `accounting_account_id` bigint(20) unsigned NOT NULL,
  `financial_year` int(11) NOT NULL,
  `jan` decimal(22,4) DEFAULT NULL,
  `feb` decimal(22,4) DEFAULT NULL,
  `mar` decimal(22,4) DEFAULT NULL,
  `apr` decimal(22,4) DEFAULT NULL,
  `may` decimal(22,4) DEFAULT NULL,
  `jun` decimal(22,4) DEFAULT NULL,
  `jul` decimal(22,4) DEFAULT NULL,
  `aug` decimal(22,4) DEFAULT NULL,
  `sep` decimal(22,4) DEFAULT NULL,
  `oct` decimal(22,4) DEFAULT NULL,
  `nov` decimal(22,4) DEFAULT NULL,
  `dec` decimal(22,4) DEFAULT NULL,
  `quarter_1` decimal(22,4) DEFAULT NULL,
  `quarter_2` decimal(22,4) DEFAULT NULL,
  `quarter_3` decimal(22,4) DEFAULT NULL,
  `quarter_4` decimal(22,4) DEFAULT NULL,
  `yearly` decimal(22,4) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `accounting_budgets` WRITE;
/*!40000 ALTER TABLE `accounting_budgets` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounting_budgets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `accounts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `name` varchar(191) NOT NULL,
  `account_number` varchar(191) NOT NULL,
  `account_details` text DEFAULT NULL,
  `account_type_id` int(11) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `is_closed` tinyint(1) NOT NULL DEFAULT 0,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `accounts_business_id_index` (`business_id`),
  KEY `accounts_account_type_id_index` (`account_type_id`),
  KEY `accounts_created_by_index` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `activity_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activity_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `log_name` varchar(191) DEFAULT NULL,
  `description` text NOT NULL,
  `subject_id` int(11) DEFAULT NULL,
  `subject_type` varchar(191) DEFAULT NULL,
  `event` varchar(191) DEFAULT NULL,
  `business_id` int(11) DEFAULT NULL,
  `causer_id` int(11) DEFAULT NULL,
  `causer_type` varchar(191) DEFAULT NULL,
  `properties` text DEFAULT NULL,
  `batch_uuid` char(36) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `activity_log_log_name_index` (`log_name`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `activity_log` WRITE;
/*!40000 ALTER TABLE `activity_log` DISABLE KEYS */;
INSERT INTO `activity_log` VALUES (1,'default','added',1691,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":450}}',NULL,'2024-12-09 15:53:01','2024-12-09 15:53:01'),(2,'default','added',1692,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":600}}',NULL,'2024-12-09 15:59:54','2024-12-09 15:59:54'),(3,'default','sell_deleted',1692,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":1692,\"invoice_no\":\"0051\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"600.0000\"}}',NULL,'2024-12-09 16:00:09','2024-12-09 16:00:09'),(4,'default','sell_deleted',1691,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":1691,\"invoice_no\":\"0050\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"450.0000\"}}',NULL,'2024-12-09 16:00:14','2024-12-09 16:00:14'),(5,'default','added',1693,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":125}}',NULL,'2024-12-09 16:01:55','2024-12-09 16:01:55'),(6,'default','sell_deleted',1693,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":1693,\"invoice_no\":\"0052\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"125.0000\"}}',NULL,'2024-12-09 16:02:05','2024-12-09 16:02:05'),(7,'default','added',1694,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}',NULL,'2024-12-09 16:20:13','2024-12-09 16:20:13'),(8,'default','sell_deleted',1694,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":1694,\"invoice_no\":\"0053\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"150.0000\"}}',NULL,'2024-12-09 16:20:23','2024-12-09 16:20:23'),(9,'default','added',1695,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}',NULL,'2024-12-09 16:20:36','2024-12-09 16:20:36'),(10,'default','added',1696,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}',NULL,'2024-12-09 16:20:47','2024-12-09 16:20:47'),(11,'default','added',1697,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}',NULL,'2024-12-09 16:20:55','2024-12-09 16:20:55'),(12,'default','sell_deleted',1697,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":1697,\"invoice_no\":\"0056\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"150.0000\"}}',NULL,'2024-12-09 16:21:14','2024-12-09 16:21:14'),(13,'default','sell_deleted',1696,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":1696,\"invoice_no\":\"0055\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"150.0000\"}}',NULL,'2024-12-09 16:21:18','2024-12-09 16:21:18'),(14,'default','sell_deleted',1695,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":1695,\"invoice_no\":\"0054\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"150.0000\"}}',NULL,'2024-12-09 16:21:23','2024-12-09 16:21:23'),(15,'default','added',1698,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":125}}',NULL,'2024-12-09 16:26:45','2024-12-09 16:26:45'),(16,'default','sell_deleted',1698,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":1698,\"invoice_no\":\"0057\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"125.0000\"}}',NULL,'2024-12-09 16:26:55','2024-12-09 16:26:55');
/*!40000 ALTER TABLE `activity_log` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `asset_maintenances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `asset_maintenances` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `asset_id` int(11) NOT NULL,
  `maitenance_id` varchar(191) DEFAULT NULL,
  `status` varchar(191) DEFAULT NULL,
  `priority` varchar(191) DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `assigned_to` int(11) DEFAULT NULL,
  `details` text DEFAULT NULL,
  `maintenance_note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `asset_maintenances_business_id_index` (`business_id`),
  KEY `asset_maintenances_asset_id_index` (`asset_id`),
  KEY `asset_maintenances_status_index` (`status`),
  KEY `asset_maintenances_priority_index` (`priority`),
  KEY `asset_maintenances_created_by_index` (`created_by`),
  KEY `asset_maintenances_assigned_to_index` (`assigned_to`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `asset_maintenances` WRITE;
/*!40000 ALTER TABLE `asset_maintenances` DISABLE KEYS */;
/*!40000 ALTER TABLE `asset_maintenances` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `asset_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `asset_transactions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `asset_id` int(10) unsigned DEFAULT NULL,
  `transaction_type` varchar(191) NOT NULL,
  `ref_no` varchar(191) NOT NULL,
  `receiver` int(10) unsigned DEFAULT NULL COMMENT 'id from users table, who receives asset',
  `quantity` decimal(22,4) NOT NULL,
  `transaction_datetime` datetime NOT NULL,
  `allocated_upto` date DEFAULT NULL,
  `reason` text DEFAULT NULL,
  `parent_id` int(10) unsigned DEFAULT NULL COMMENT 'id from asset_transactions table',
  `created_by` int(10) unsigned NOT NULL COMMENT 'id from users table, who allocated asset',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `asset_transactions_business_id_foreign` (`business_id`),
  KEY `asset_transactions_asset_id_foreign` (`asset_id`),
  KEY `asset_transactions_receiver_foreign` (`receiver`),
  KEY `asset_transactions_parent_id_foreign` (`parent_id`),
  KEY `asset_transactions_created_by_foreign` (`created_by`),
  CONSTRAINT `asset_transactions_asset_id_foreign` FOREIGN KEY (`asset_id`) REFERENCES `assets` (`id`) ON DELETE CASCADE,
  CONSTRAINT `asset_transactions_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `asset_transactions_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`),
  CONSTRAINT `asset_transactions_parent_id_foreign` FOREIGN KEY (`parent_id`) REFERENCES `asset_transactions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `asset_transactions_receiver_foreign` FOREIGN KEY (`receiver`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `asset_transactions` WRITE;
/*!40000 ALTER TABLE `asset_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `asset_transactions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `asset_warranties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `asset_warranties` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(11) NOT NULL,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `additional_cost` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `additional_note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `asset_warranties` WRITE;
/*!40000 ALTER TABLE `asset_warranties` DISABLE KEYS */;
/*!40000 ALTER TABLE `asset_warranties` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `assets` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `asset_code` varchar(191) NOT NULL,
  `name` varchar(191) NOT NULL,
  `quantity` decimal(22,4) NOT NULL,
  `model` varchar(191) DEFAULT NULL,
  `serial_no` varchar(191) DEFAULT NULL,
  `category_id` int(10) unsigned DEFAULT NULL,
  `location_id` int(10) unsigned DEFAULT NULL,
  `purchase_date` date DEFAULT NULL,
  `purchase_type` varchar(191) DEFAULT NULL,
  `unit_price` decimal(22,4) NOT NULL,
  `depreciation` decimal(22,4) DEFAULT NULL,
  `is_allocatable` tinyint(1) NOT NULL DEFAULT 0,
  `description` text DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `assets_business_id_foreign` (`business_id`),
  KEY `assets_category_id_foreign` (`category_id`),
  KEY `assets_created_by_foreign` (`created_by`),
  CONSTRAINT `assets_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `assets_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `categories` (`id`),
  CONSTRAINT `assets_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `barcodes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `barcodes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  `width` double(22,4) DEFAULT NULL,
  `height` double(22,4) DEFAULT NULL,
  `paper_width` double(22,4) DEFAULT NULL,
  `paper_height` double(22,4) DEFAULT NULL,
  `top_margin` double(22,4) DEFAULT NULL,
  `left_margin` double(22,4) DEFAULT NULL,
  `row_distance` double(22,4) DEFAULT NULL,
  `col_distance` double(22,4) DEFAULT NULL,
  `stickers_in_one_row` int(11) DEFAULT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  `is_continuous` tinyint(1) NOT NULL DEFAULT 0,
  `stickers_in_one_sheet` int(11) DEFAULT NULL,
  `business_id` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `barcodes_business_id_foreign` (`business_id`),
  CONSTRAINT `barcodes_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `barcodes` WRITE;
/*!40000 ALTER TABLE `barcodes` DISABLE KEYS */;
INSERT INTO `barcodes` VALUES (1,'20 Labels per Sheet','Sheet Size: 8.5\" x 11\", Label Size: 4\" x 1\", Labels per sheet: 20',4.0000,1.0000,8.5000,11.0000,0.5000,0.1250,0.0000,0.1875,2,0,0,20,NULL,'2017-12-18 00:13:44','2017-12-18 00:13:44'),(2,'30 Labels per sheet','Sheet Size: 8.5\" x 11\", Label Size: 2.625\" x 1\", Labels per sheet: 30',2.6250,1.0000,8.5000,11.0000,0.5000,0.1880,0.0000,0.1250,3,0,0,30,NULL,'2017-12-18 00:04:39','2017-12-18 00:10:40'),(3,'32 Labels per sheet','Sheet Size: 8.5\" x 11\", Label Size: 2\" x 1.25\", Labels per sheet: 32',2.0000,1.2500,8.5000,11.0000,0.5000,0.2500,0.0000,0.0000,4,0,0,32,NULL,'2017-12-17 23:55:40','2017-12-17 23:55:40'),(4,'40 Labels per sheet','Sheet Size: 8.5\" x 11\", Label Size: 2\" x 1\", Labels per sheet: 40',2.0000,1.0000,8.5000,11.0000,0.5000,0.2500,0.0000,0.0000,4,0,0,40,NULL,'2017-12-17 23:58:40','2017-12-17 23:58:40'),(5,'50 Labels per Sheet','Sheet Size: 8.5\" x 11\", Label Size: 1.5\" x 1\", Labels per sheet: 50',1.5000,1.0000,8.5000,11.0000,0.5000,0.5000,0.0000,0.0000,5,0,0,50,NULL,'2017-12-17 23:51:10','2017-12-17 23:51:10'),(6,'Continuous Rolls - 31.75mm x 25.4mm','Label Size: 31.75mm x 25.4mm, Gap: 3.18mm',1.2500,1.0000,1.2500,0.0000,0.1250,0.0000,0.1250,0.0000,1,0,1,NULL,NULL,'2017-12-17 23:51:10','2017-12-17 23:51:10'),(7,'For Qr Code',NULL,0.9000,0.9000,10.0000,10.0000,0.0000,0.0000,0.1000,0.1000,1,0,0,1,1,'2024-11-02 06:35:28','2024-11-02 06:39:31');
/*!40000 ALTER TABLE `barcodes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `bookings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bookings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `contact_id` int(10) unsigned NOT NULL,
  `waiter_id` int(10) unsigned DEFAULT NULL,
  `table_id` int(10) unsigned DEFAULT NULL,
  `correspondent_id` int(11) DEFAULT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` int(10) unsigned NOT NULL,
  `booking_start` datetime NOT NULL,
  `booking_end` datetime NOT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `booking_status` varchar(191) NOT NULL,
  `booking_note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bookings_contact_id_foreign` (`contact_id`),
  KEY `bookings_business_id_foreign` (`business_id`),
  KEY `bookings_created_by_foreign` (`created_by`),
  KEY `bookings_table_id_index` (`table_id`),
  KEY `bookings_waiter_id_index` (`waiter_id`),
  KEY `bookings_location_id_index` (`location_id`),
  KEY `bookings_booking_status_index` (`booking_status`),
  KEY `bookings_correspondent_id_index` (`correspondent_id`),
  CONSTRAINT `bookings_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `bookings_contact_id_foreign` FOREIGN KEY (`contact_id`) REFERENCES `contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `bookings_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `bookings` WRITE;
/*!40000 ALTER TABLE `bookings` DISABLE KEYS */;
/*!40000 ALTER TABLE `bookings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `brands`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `brands` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `brands_business_id_foreign` (`business_id`),
  KEY `brands_created_by_foreign` (`created_by`),
  CONSTRAINT `brands_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `brands_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=69 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `brands` WRITE;
/*!40000 ALTER TABLE `brands` DISABLE KEYS */;
/*!40000 ALTER TABLE `brands` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `business`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `business` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `currency_id` int(10) unsigned NOT NULL,
  `start_date` date DEFAULT NULL,
  `tax_number_1` varchar(100) DEFAULT NULL,
  `tax_label_1` varchar(10) DEFAULT NULL,
  `tax_number_2` varchar(100) DEFAULT NULL,
  `tax_label_2` varchar(10) DEFAULT NULL,
  `code_label_1` varchar(191) DEFAULT NULL,
  `code_1` varchar(191) DEFAULT NULL,
  `code_label_2` varchar(191) DEFAULT NULL,
  `code_2` varchar(191) DEFAULT NULL,
  `default_sales_tax` int(10) unsigned DEFAULT NULL,
  `default_profit_percent` double(5,2) NOT NULL DEFAULT 0.00,
  `owner_id` int(10) unsigned NOT NULL,
  `time_zone` varchar(191) NOT NULL DEFAULT 'Asia/Kolkata',
  `fy_start_month` tinyint(4) NOT NULL DEFAULT 1,
  `accounting_method` enum('fifo','lifo','avco') NOT NULL DEFAULT 'fifo',
  `default_sales_discount` decimal(5,2) DEFAULT NULL,
  `sell_price_tax` enum('includes','excludes') NOT NULL DEFAULT 'includes',
  `logo` varchar(191) DEFAULT NULL,
  `sku_prefix` varchar(191) DEFAULT NULL,
  `enable_product_expiry` tinyint(1) NOT NULL DEFAULT 0,
  `expiry_type` enum('add_expiry','add_manufacturing') NOT NULL DEFAULT 'add_expiry',
  `on_product_expiry` enum('keep_selling','stop_selling','auto_delete') NOT NULL DEFAULT 'keep_selling',
  `stop_selling_before` int(11) NOT NULL COMMENT 'Stop selling expied item n days before expiry',
  `enable_tooltip` tinyint(1) NOT NULL DEFAULT 1,
  `purchase_in_diff_currency` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Allow purchase to be in different currency then the business currency',
  `purchase_currency_id` int(10) unsigned DEFAULT NULL,
  `p_exchange_rate` decimal(20,3) NOT NULL DEFAULT 1.000,
  `transaction_edit_days` int(10) unsigned NOT NULL DEFAULT 30,
  `stock_expiry_alert_days` int(10) unsigned NOT NULL DEFAULT 30,
  `keyboard_shortcuts` text DEFAULT NULL,
  `pos_settings` text DEFAULT NULL,
  `manufacturing_settings` text DEFAULT NULL,
  `essentials_settings` longtext DEFAULT NULL,
  `weighing_scale_setting` text NOT NULL COMMENT 'used to store the configuration of weighing scale',
  `enable_brand` tinyint(1) NOT NULL DEFAULT 1,
  `enable_category` tinyint(1) NOT NULL DEFAULT 1,
  `enable_sub_category` tinyint(1) NOT NULL DEFAULT 1,
  `enable_price_tax` tinyint(1) NOT NULL DEFAULT 1,
  `enable_purchase_status` tinyint(1) DEFAULT 1,
  `enable_lot_number` tinyint(1) NOT NULL DEFAULT 0,
  `default_unit` int(11) DEFAULT NULL,
  `enable_sub_units` tinyint(1) NOT NULL DEFAULT 0,
  `enable_racks` tinyint(1) NOT NULL DEFAULT 0,
  `enable_row` tinyint(1) NOT NULL DEFAULT 0,
  `enable_position` tinyint(1) NOT NULL DEFAULT 0,
  `enable_editing_product_from_purchase` tinyint(1) NOT NULL DEFAULT 1,
  `sales_cmsn_agnt` enum('logged_in_user','user','cmsn_agnt') DEFAULT NULL,
  `item_addition_method` tinyint(1) NOT NULL DEFAULT 1,
  `enable_inline_tax` tinyint(1) NOT NULL DEFAULT 1,
  `currency_symbol_placement` enum('before','after') NOT NULL DEFAULT 'before',
  `enabled_modules` text DEFAULT NULL,
  `date_format` varchar(191) NOT NULL DEFAULT 'm/d/Y',
  `time_format` enum('12','24') NOT NULL DEFAULT '24',
  `currency_precision` tinyint(4) NOT NULL DEFAULT 2,
  `quantity_precision` tinyint(4) NOT NULL DEFAULT 2,
  `ref_no_prefixes` text DEFAULT NULL,
  `theme_color` char(20) DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `asset_settings` text DEFAULT NULL,
  `crm_settings` text DEFAULT NULL,
  `accounting_settings` text DEFAULT NULL,
  `enable_rp` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'rp is the short form of reward points',
  `rp_name` varchar(191) DEFAULT NULL COMMENT 'rp is the short form of reward points',
  `amount_for_unit_rp` decimal(22,4) NOT NULL DEFAULT 1.0000 COMMENT 'rp is the short form of reward points',
  `min_order_total_for_rp` decimal(22,4) NOT NULL DEFAULT 1.0000 COMMENT 'rp is the short form of reward points',
  `max_rp_per_order` int(11) DEFAULT NULL COMMENT 'rp is the short form of reward points',
  `redeem_amount_per_unit_rp` decimal(22,4) NOT NULL DEFAULT 1.0000 COMMENT 'rp is the short form of reward points',
  `min_order_total_for_redeem` decimal(22,4) NOT NULL DEFAULT 1.0000 COMMENT 'rp is the short form of reward points',
  `min_redeem_point` int(11) DEFAULT NULL COMMENT 'rp is the short form of reward points',
  `max_redeem_point` int(11) DEFAULT NULL COMMENT 'rp is the short form of reward points',
  `rp_expiry_period` int(11) DEFAULT NULL COMMENT 'rp is the short form of reward points',
  `rp_expiry_type` enum('month','year') NOT NULL DEFAULT 'year' COMMENT 'rp is the short form of reward points',
  `email_settings` text DEFAULT NULL,
  `sms_settings` text DEFAULT NULL,
  `custom_labels` text DEFAULT NULL,
  `common_settings` text DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `business_owner_id_foreign` (`owner_id`),
  KEY `business_currency_id_foreign` (`currency_id`),
  KEY `business_default_sales_tax_foreign` (`default_sales_tax`),
  CONSTRAINT `business_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`),
  CONSTRAINT `business_default_sales_tax_foreign` FOREIGN KEY (`default_sales_tax`) REFERENCES `tax_rates` (`id`),
  CONSTRAINT `business_owner_id_foreign` FOREIGN KEY (`owner_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `business` WRITE;
/*!40000 ALTER TABLE `business` DISABLE KEYS */;
INSERT INTO `business` VALUES (1,'Warraich Store',91,'2024-10-25',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.00,1,'Asia/Karachi',1,'fifo',0.00,'includes',NULL,NULL,0,'add_expiry','keep_selling',0,0,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"search_by_barcode\":\"shift+a\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"recent_product_quantity\":\"f2\",\"weighing_scale\":null,\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"add_new_product\":\"f4\"}}','{\"amount_rounding_method\":null,\"allow_overselling\":\"1\",\"cmmsn_calculation_type\":\"invoice_value\",\"razor_pay_key_id\":null,\"razor_pay_key_secret\":null,\"stripe_public_key\":null,\"stripe_secret_key\":null,\"show_multi_unit\":\"1\",\"enebale_search_by_barcode\":\"1\",\"hide_product_suggestion\":\"1\",\"disable_order_tax\":\"1\",\"disable_suspend\":\"1\",\"cash_denominations\":null,\"enable_cash_denomination_on\":\"pos_screen\",\"disable_pay_checkout\":0,\"disable_draft\":0,\"disable_express_checkout\":0,\"hide_recent_trans\":0,\"disable_discount\":0,\"is_pos_subtotal_editable\":0}',NULL,NULL,'{\"label_prefix\":null,\"product_sku_length\":\"4\",\"qty_length\":\"3\",\"qty_length_decimal\":\"2\"}',1,1,0,1,1,0,NULL,0,0,0,0,1,NULL,1,1,'before','[\"purchases\",\"add_sale\",\"pos_sale\",\"stock_adjustment\",\"expenses\"]','d/m/Y','12',0,2,'{\"purchase\":\"PO\",\"purchase_return\":null,\"purchase_requisition\":null,\"purchase_order\":null,\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"expense_payment\":null,\"business_location\":\"BL\",\"username\":null,\"subscription\":null,\"draft\":null,\"sales_order\":null}','primary',NULL,NULL,NULL,NULL,0,NULL,1.0000,1.0000,NULL,1.0000,1.0000,NULL,NULL,NULL,'year','{\"mail_driver\":\"smtp\",\"mail_host\":null,\"mail_port\":null,\"mail_username\":null,\"mail_password\":null,\"mail_encryption\":null,\"mail_from_address\":null,\"mail_from_name\":null}','{\"sms_service\":\"other\",\"nexmo_key\":null,\"nexmo_secret\":null,\"nexmo_from\":null,\"twilio_sid\":null,\"twilio_token\":null,\"twilio_from\":null,\"url\":null,\"send_to_param_name\":\"to\",\"msg_param_name\":\"text\",\"request_method\":\"post\",\"header_1\":null,\"header_val_1\":null,\"header_2\":null,\"header_val_2\":null,\"header_3\":null,\"header_val_3\":null,\"param_1\":null,\"param_val_1\":null,\"param_2\":null,\"param_val_2\":null,\"param_3\":null,\"param_val_3\":null,\"param_4\":null,\"param_val_4\":null,\"param_5\":null,\"param_val_5\":null,\"param_6\":null,\"param_val_6\":null,\"param_7\":null,\"param_val_7\":null,\"param_8\":null,\"param_val_8\":null,\"param_9\":null,\"param_val_9\":null,\"param_10\":null,\"param_val_10\":null}','{\"payments\":{\"custom_pay_1\":\"Jazz Cash\",\"custom_pay_2\":\"Easy Paisa\",\"custom_pay_3\":null,\"custom_pay_4\":null,\"custom_pay_5\":null,\"custom_pay_6\":null,\"custom_pay_7\":null},\"contact\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null,\"custom_field_6\":null,\"custom_field_7\":null,\"custom_field_8\":null,\"custom_field_9\":null,\"custom_field_10\":null},\"product\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null,\"custom_field_6\":null,\"custom_field_7\":null,\"custom_field_8\":null,\"custom_field_9\":null,\"custom_field_10\":null,\"custom_field_11\":null,\"custom_field_12\":null,\"custom_field_13\":null,\"custom_field_14\":null,\"custom_field_15\":null,\"custom_field_16\":null,\"custom_field_17\":null,\"custom_field_18\":null,\"custom_field_19\":null,\"custom_field_20\":null},\"product_cf_details\":{\"1\":{\"type\":null,\"dropdown_options\":null},\"2\":{\"type\":null,\"dropdown_options\":null},\"3\":{\"type\":null,\"dropdown_options\":null},\"4\":{\"type\":null,\"dropdown_options\":null},\"5\":{\"type\":null,\"dropdown_options\":null},\"6\":{\"type\":null,\"dropdown_options\":null},\"7\":{\"type\":null,\"dropdown_options\":null},\"8\":{\"type\":null,\"dropdown_options\":null},\"9\":{\"type\":null,\"dropdown_options\":null},\"10\":{\"type\":null,\"dropdown_options\":null},\"11\":{\"type\":null,\"dropdown_options\":null},\"12\":{\"type\":null,\"dropdown_options\":null},\"13\":{\"type\":null,\"dropdown_options\":null},\"14\":{\"type\":null,\"dropdown_options\":null},\"15\":{\"type\":null,\"dropdown_options\":null},\"16\":{\"type\":null,\"dropdown_options\":null},\"17\":{\"type\":null,\"dropdown_options\":null},\"18\":{\"type\":null,\"dropdown_options\":null},\"19\":{\"type\":null,\"dropdown_options\":null},\"20\":{\"type\":null,\"dropdown_options\":null}},\"location\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"user\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"purchase\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"purchase_shipping\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null},\"sell\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"shipping\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null},\"types_of_service\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null,\"custom_field_6\":null}}','{\"enable_product_multi_unit\":\"1\",\"enable_product_defult_discount\":\"1\",\"default_credit_limit\":null,\"enable_serial_number\":\"1\",\"default_datatable_page_entries\":\"50\"}',1,'2024-10-25 16:39:24','2024-12-09 15:52:24');
/*!40000 ALTER TABLE `business` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `business_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `business_locations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` varchar(191) DEFAULT NULL,
  `kot_printer_type` enum('browser','printer') NOT NULL DEFAULT 'browser',
  `kot_printer_id` int(11) DEFAULT NULL,
  `name` varchar(256) NOT NULL,
  `landmark` text DEFAULT NULL,
  `country` varchar(100) NOT NULL,
  `state` varchar(100) NOT NULL,
  `city` varchar(100) NOT NULL,
  `zip_code` char(7) NOT NULL,
  `invoice_scheme_id` int(10) unsigned NOT NULL,
  `sale_invoice_scheme_id` int(11) DEFAULT NULL,
  `invoice_layout_id` int(10) unsigned NOT NULL,
  `sale_invoice_layout_id` int(11) DEFAULT NULL,
  `selling_price_group_id` int(11) DEFAULT NULL,
  `print_receipt_on_invoice` tinyint(1) DEFAULT 1,
  `receipt_printer_type` enum('browser','printer') NOT NULL DEFAULT 'browser',
  `printer_id` int(11) DEFAULT NULL,
  `mobile` varchar(191) DEFAULT NULL,
  `alternate_number` varchar(191) DEFAULT NULL,
  `email` varchar(191) DEFAULT NULL,
  `website` varchar(191) DEFAULT NULL,
  `featured_products` text DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `default_payment_accounts` text DEFAULT NULL,
  `custom_field1` varchar(191) DEFAULT NULL,
  `custom_field2` varchar(191) DEFAULT NULL,
  `custom_field3` varchar(191) DEFAULT NULL,
  `custom_field4` varchar(191) DEFAULT NULL,
  `accounting_default_map` text DEFAULT NULL COMMENT 'Default transactions mapping of accounting module',
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `business_locations_business_id_index` (`business_id`),
  KEY `business_locations_invoice_scheme_id_foreign` (`invoice_scheme_id`),
  KEY `business_locations_invoice_layout_id_foreign` (`invoice_layout_id`),
  KEY `business_locations_sale_invoice_layout_id_index` (`sale_invoice_layout_id`),
  KEY `business_locations_selling_price_group_id_index` (`selling_price_group_id`),
  KEY `business_locations_receipt_printer_type_index` (`receipt_printer_type`),
  KEY `business_locations_printer_id_index` (`printer_id`),
  CONSTRAINT `business_locations_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `business_locations_invoice_layout_id_foreign` FOREIGN KEY (`invoice_layout_id`) REFERENCES `invoice_layouts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `business_locations_invoice_scheme_id_foreign` FOREIGN KEY (`invoice_scheme_id`) REFERENCES `invoice_schemes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `business_locations` WRITE;
/*!40000 ALTER TABLE `business_locations` DISABLE KEYS */;
INSERT INTO `business_locations` VALUES (1,1,'BL0001','printer',1,'Warraich Store','admin@admin.com','Bangladesh','Dhaka','Charsindur','1612',1,1,1,1,NULL,1,'browser',NULL,NULL,NULL,NULL,NULL,NULL,1,'{\"cash\":{\"is_enabled\":\"1\"},\"other\":{\"is_enabled\":\"1\"},\"custom_pay_1\":{\"is_enabled\":\"1\"},\"custom_pay_2\":{\"is_enabled\":\"1\"}}',NULL,NULL,NULL,NULL,NULL,NULL,'2024-10-25 16:39:24','2024-12-09 15:44:21');
/*!40000 ALTER TABLE `business_locations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `cash_denominations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cash_denominations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `amount` decimal(22,4) NOT NULL,
  `total_count` int(11) NOT NULL,
  `model_type` varchar(191) NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cash_denominations_model_type_model_id_index` (`model_type`,`model_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `cash_denominations` WRITE;
/*!40000 ALTER TABLE `cash_denominations` DISABLE KEYS */;
/*!40000 ALTER TABLE `cash_denominations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `cash_register_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cash_register_transactions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cash_register_id` int(10) unsigned NOT NULL,
  `amount` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `pay_method` varchar(191) DEFAULT NULL,
  `type` enum('debit','credit') NOT NULL,
  `transaction_type` varchar(191) DEFAULT NULL,
  `transaction_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cash_register_transactions_cash_register_id_foreign` (`cash_register_id`),
  KEY `cash_register_transactions_transaction_id_index` (`transaction_id`),
  KEY `cash_register_transactions_type_index` (`type`),
  KEY `cash_register_transactions_transaction_type_index` (`transaction_type`),
  CONSTRAINT `cash_register_transactions_cash_register_id_foreign` FOREIGN KEY (`cash_register_id`) REFERENCES `cash_registers` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `cash_register_transactions` WRITE;
/*!40000 ALTER TABLE `cash_register_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `cash_register_transactions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `cash_registers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cash_registers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` int(11) DEFAULT NULL,
  `user_id` int(10) unsigned DEFAULT NULL,
  `status` enum('close','open') NOT NULL DEFAULT 'open',
  `closed_at` datetime DEFAULT NULL,
  `closing_amount` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `total_card_slips` int(11) NOT NULL DEFAULT 0,
  `total_cheques` int(11) NOT NULL DEFAULT 0,
  `denominations` text DEFAULT NULL,
  `closing_note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cash_registers_business_id_foreign` (`business_id`),
  KEY `cash_registers_user_id_foreign` (`user_id`),
  KEY `cash_registers_location_id_index` (`location_id`),
  CONSTRAINT `cash_registers_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cash_registers_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `cash_registers` WRITE;
/*!40000 ALTER TABLE `cash_registers` DISABLE KEYS */;
INSERT INTO `cash_registers` VALUES (2,1,1,1,'open',NULL,0.0000,0,0,NULL,NULL,'2024-11-24 06:36:00','2024-11-24 06:36:23');
/*!40000 ALTER TABLE `cash_registers` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `short_code` varchar(191) DEFAULT NULL,
  `parent_id` int(11) NOT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `category_type` varchar(191) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `slug` varchar(191) DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `categories_business_id_foreign` (`business_id`),
  KEY `categories_created_by_foreign` (`created_by`),
  KEY `categories_parent_id_index` (`parent_id`),
  CONSTRAINT `categories_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `categories_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=134 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `categories` WRITE;
/*!40000 ALTER TABLE `categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `categories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `categorizables`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categorizables` (
  `category_id` int(11) NOT NULL,
  `categorizable_type` varchar(191) NOT NULL,
  `categorizable_id` bigint(20) unsigned NOT NULL,
  KEY `categorizables_categorizable_type_categorizable_id_index` (`categorizable_type`,`categorizable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `categorizables` WRITE;
/*!40000 ALTER TABLE `categorizables` DISABLE KEYS */;
/*!40000 ALTER TABLE `categorizables` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `contacts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `contacts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `type` varchar(191) NOT NULL,
  `contact_type` varchar(191) DEFAULT NULL,
  `supplier_business_name` varchar(191) DEFAULT NULL,
  `name` varchar(191) DEFAULT NULL,
  `prefix` varchar(191) DEFAULT NULL,
  `first_name` varchar(191) DEFAULT NULL,
  `middle_name` varchar(191) DEFAULT NULL,
  `last_name` varchar(191) DEFAULT NULL,
  `email` varchar(191) DEFAULT NULL,
  `contact_id` varchar(191) DEFAULT NULL,
  `contact_status` varchar(191) NOT NULL DEFAULT 'active',
  `tax_number` varchar(191) DEFAULT NULL,
  `city` varchar(191) DEFAULT NULL,
  `state` varchar(191) DEFAULT NULL,
  `country` varchar(191) DEFAULT NULL,
  `address_line_1` text DEFAULT NULL,
  `address_line_2` text DEFAULT NULL,
  `zip_code` varchar(191) DEFAULT NULL,
  `dob` date DEFAULT NULL,
  `mobile` varchar(191) NOT NULL,
  `landline` varchar(191) DEFAULT NULL,
  `alternate_number` varchar(191) DEFAULT NULL,
  `pay_term_number` int(11) DEFAULT NULL,
  `pay_term_type` enum('days','months') DEFAULT NULL,
  `credit_limit` decimal(22,4) DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `converted_by` int(11) DEFAULT NULL,
  `converted_on` datetime DEFAULT NULL,
  `balance` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `total_rp` int(11) NOT NULL DEFAULT 0 COMMENT 'rp is the short form of reward points',
  `total_rp_used` int(11) NOT NULL DEFAULT 0 COMMENT 'rp is the short form of reward points',
  `total_rp_expired` int(11) NOT NULL DEFAULT 0 COMMENT 'rp is the short form of reward points',
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  `shipping_address` text DEFAULT NULL,
  `shipping_custom_field_details` longtext DEFAULT NULL,
  `is_export` tinyint(1) NOT NULL DEFAULT 0,
  `export_custom_field_1` varchar(191) DEFAULT NULL,
  `export_custom_field_2` varchar(191) DEFAULT NULL,
  `export_custom_field_3` varchar(191) DEFAULT NULL,
  `export_custom_field_4` varchar(191) DEFAULT NULL,
  `export_custom_field_5` varchar(191) DEFAULT NULL,
  `export_custom_field_6` varchar(191) DEFAULT NULL,
  `position` varchar(191) DEFAULT NULL,
  `customer_group_id` int(11) DEFAULT NULL,
  `crm_source` varchar(191) DEFAULT NULL,
  `crm_life_stage` varchar(191) DEFAULT NULL,
  `custom_field1` varchar(191) DEFAULT NULL,
  `custom_field2` varchar(191) DEFAULT NULL,
  `custom_field3` varchar(191) DEFAULT NULL,
  `custom_field4` varchar(191) DEFAULT NULL,
  `custom_field5` varchar(191) DEFAULT NULL,
  `custom_field6` varchar(191) DEFAULT NULL,
  `custom_field7` varchar(191) DEFAULT NULL,
  `custom_field8` varchar(191) DEFAULT NULL,
  `custom_field9` varchar(191) DEFAULT NULL,
  `custom_field10` varchar(191) DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `contacts_business_id_foreign` (`business_id`),
  KEY `contacts_created_by_foreign` (`created_by`),
  KEY `contacts_type_index` (`type`),
  KEY `contacts_contact_status_index` (`contact_status`),
  KEY `contacts_crm_source_index` (`crm_source`),
  KEY `contacts_crm_life_stage_index` (`crm_life_stage`),
  KEY `contacts_converted_by_index` (`converted_by`),
  CONSTRAINT `contacts_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `contacts_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `contacts` WRITE;
/*!40000 ALTER TABLE `contacts` DISABLE KEYS */;
INSERT INTO `contacts` VALUES (1,1,'customer',NULL,NULL,'Walk-In Customer',NULL,NULL,NULL,NULL,NULL,'CO0001','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,0.0000,1,NULL,NULL,0.0000,0,0,0,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-10-25 16:39:24','2024-10-25 16:39:24');
/*!40000 ALTER TABLE `contacts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `crm_call_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `crm_call_logs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `call_type` varchar(191) DEFAULT NULL,
  `mobile_number` varchar(191) NOT NULL,
  `mobile_name` varchar(191) DEFAULT NULL,
  `contact_id` int(11) DEFAULT NULL,
  `start_time` datetime DEFAULT NULL,
  `end_time` datetime DEFAULT NULL,
  `duration` int(11) DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `crm_call_logs_business_id_index` (`business_id`),
  KEY `crm_call_logs_user_id_index` (`user_id`),
  KEY `crm_call_logs_contact_id_index` (`contact_id`),
  KEY `crm_call_logs_created_by_index` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `crm_call_logs` WRITE;
/*!40000 ALTER TABLE `crm_call_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `crm_call_logs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `crm_campaigns`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `crm_campaigns` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) NOT NULL,
  `campaign_type` enum('sms','email') NOT NULL DEFAULT 'email',
  `subject` varchar(191) DEFAULT NULL,
  `email_body` text DEFAULT NULL,
  `sms_body` text DEFAULT NULL,
  `sent_on` datetime DEFAULT NULL,
  `contact_ids` text NOT NULL,
  `additional_info` text DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `crm_campaigns_business_id_foreign` (`business_id`),
  KEY `crm_campaigns_created_by_index` (`created_by`),
  CONSTRAINT `crm_campaigns_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `crm_campaigns` WRITE;
/*!40000 ALTER TABLE `crm_campaigns` DISABLE KEYS */;
/*!40000 ALTER TABLE `crm_campaigns` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `crm_contact_person_commissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `crm_contact_person_commissions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `contact_person_id` int(11) NOT NULL,
  `transaction_id` int(11) DEFAULT NULL,
  `commission_amount` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `crm_contact_person_commissions` WRITE;
/*!40000 ALTER TABLE `crm_contact_person_commissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `crm_contact_person_commissions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `crm_followup_invoices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `crm_followup_invoices` (
  `follow_up_id` int(11) NOT NULL,
  `transaction_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `crm_followup_invoices` WRITE;
/*!40000 ALTER TABLE `crm_followup_invoices` DISABLE KEYS */;
/*!40000 ALTER TABLE `crm_followup_invoices` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `crm_lead_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `crm_lead_users` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `contact_id` int(10) unsigned NOT NULL,
  `user_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `crm_lead_users_user_id_index` (`user_id`),
  KEY `crm_lead_users_contact_id_index` (`contact_id`),
  CONSTRAINT `crm_lead_users_contact_id_foreign` FOREIGN KEY (`contact_id`) REFERENCES `contacts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `crm_lead_users` WRITE;
/*!40000 ALTER TABLE `crm_lead_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `crm_lead_users` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `crm_marketplaces`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `crm_marketplaces` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `marketplace` varchar(191) DEFAULT NULL,
  `site_key` varchar(191) DEFAULT NULL,
  `site_id` varchar(191) DEFAULT NULL,
  `assigned_users` text DEFAULT NULL,
  `crm_source_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `crm_marketplaces` WRITE;
/*!40000 ALTER TABLE `crm_marketplaces` DISABLE KEYS */;
/*!40000 ALTER TABLE `crm_marketplaces` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `crm_proposal_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `crm_proposal_templates` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `subject` text NOT NULL,
  `body` longtext NOT NULL,
  `cc` text DEFAULT NULL,
  `bcc` text DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `crm_proposal_templates_business_id_foreign` (`business_id`),
  KEY `crm_proposal_templates_created_by_index` (`created_by`),
  CONSTRAINT `crm_proposal_templates_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `crm_proposal_templates` WRITE;
/*!40000 ALTER TABLE `crm_proposal_templates` DISABLE KEYS */;
/*!40000 ALTER TABLE `crm_proposal_templates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `crm_proposals`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `crm_proposals` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `contact_id` int(10) unsigned NOT NULL,
  `subject` text NOT NULL,
  `body` longtext NOT NULL,
  `cc` text DEFAULT NULL,
  `bcc` text DEFAULT NULL,
  `sent_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `crm_proposals_business_id_foreign` (`business_id`),
  KEY `crm_proposals_contact_id_foreign` (`contact_id`),
  KEY `crm_proposals_sent_by_index` (`sent_by`),
  CONSTRAINT `crm_proposals_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `crm_proposals_contact_id_foreign` FOREIGN KEY (`contact_id`) REFERENCES `contacts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `crm_proposals` WRITE;
/*!40000 ALTER TABLE `crm_proposals` DISABLE KEYS */;
/*!40000 ALTER TABLE `crm_proposals` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `crm_schedule_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `crm_schedule_logs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `schedule_id` bigint(20) unsigned NOT NULL,
  `log_type` enum('call','sms','meeting','email') NOT NULL DEFAULT 'email',
  `start_datetime` datetime NOT NULL,
  `end_datetime` datetime NOT NULL,
  `subject` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `crm_schedule_logs_schedule_id_foreign` (`schedule_id`),
  KEY `crm_schedule_logs_created_by_index` (`created_by`),
  CONSTRAINT `crm_schedule_logs_schedule_id_foreign` FOREIGN KEY (`schedule_id`) REFERENCES `crm_schedules` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `crm_schedule_logs` WRITE;
/*!40000 ALTER TABLE `crm_schedule_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `crm_schedule_logs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `crm_schedule_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `crm_schedule_users` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `schedule_id` bigint(20) unsigned NOT NULL,
  `user_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `crm_schedule_users_schedule_id_foreign` (`schedule_id`),
  KEY `crm_schedule_users_user_id_index` (`user_id`),
  CONSTRAINT `crm_schedule_users_schedule_id_foreign` FOREIGN KEY (`schedule_id`) REFERENCES `crm_schedules` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `crm_schedule_users` WRITE;
/*!40000 ALTER TABLE `crm_schedule_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `crm_schedule_users` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `crm_schedules`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `crm_schedules` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `contact_id` int(11) DEFAULT NULL,
  `title` varchar(191) NOT NULL,
  `status` varchar(191) DEFAULT NULL,
  `start_datetime` datetime DEFAULT NULL,
  `end_datetime` datetime DEFAULT NULL,
  `description` text DEFAULT NULL,
  `schedule_type` enum('call','sms','meeting','email') NOT NULL DEFAULT 'email',
  `followup_category_id` int(11) DEFAULT NULL,
  `allow_notification` tinyint(1) NOT NULL DEFAULT 1,
  `notify_via` text DEFAULT NULL,
  `notify_before` int(11) DEFAULT NULL,
  `notify_type` enum('minute','hour','day') NOT NULL DEFAULT 'hour',
  `created_by` int(11) NOT NULL,
  `is_recursive` tinyint(1) NOT NULL DEFAULT 0,
  `recursion_days` int(11) DEFAULT NULL,
  `followup_additional_info` text DEFAULT NULL,
  `follow_up_by` varchar(191) DEFAULT NULL,
  `follow_up_by_value` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `crm_schedules_created_by_index` (`created_by`),
  KEY `crm_schedules_business_id_index` (`business_id`),
  KEY `crm_schedules_contact_id_index` (`contact_id`),
  KEY `crm_schedules_schedule_type_index` (`schedule_type`),
  KEY `crm_schedules_notify_type_index` (`notify_type`),
  CONSTRAINT `crm_schedules_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `crm_schedules` WRITE;
/*!40000 ALTER TABLE `crm_schedules` DISABLE KEYS */;
/*!40000 ALTER TABLE `crm_schedules` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `currencies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `currencies` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `country` varchar(100) NOT NULL,
  `currency` varchar(100) NOT NULL,
  `code` varchar(25) NOT NULL,
  `symbol` varchar(25) NOT NULL,
  `thousand_separator` varchar(10) NOT NULL,
  `decimal_separator` varchar(10) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=142 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `currencies` WRITE;
/*!40000 ALTER TABLE `currencies` DISABLE KEYS */;
INSERT INTO `currencies` VALUES (91,'Pakistan','Rupees','PKR','₨',',','.',NULL,NULL);
/*!40000 ALTER TABLE `currencies` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `customer_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `customer_groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) NOT NULL,
  `amount` double(5,2) NOT NULL,
  `price_calculation_type` varchar(191) DEFAULT 'percentage',
  `selling_price_group_id` int(11) DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_groups_business_id_foreign` (`business_id`),
  KEY `customer_groups_created_by_index` (`created_by`),
  KEY `customer_groups_price_calculation_type_index` (`price_calculation_type`),
  KEY `customer_groups_selling_price_group_id_index` (`selling_price_group_id`),
  CONSTRAINT `customer_groups_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `customer_groups` WRITE;
/*!40000 ALTER TABLE `customer_groups` DISABLE KEYS */;
INSERT INTO `customer_groups` VALUES (2,1,'Fruit Teas',0.00,'percentage',6,1,'2024-11-28 13:55:14','2024-11-28 13:55:14');
/*!40000 ALTER TABLE `customer_groups` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `dashboard_configurations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dashboard_configurations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `created_by` int(11) NOT NULL,
  `name` varchar(191) NOT NULL,
  `color` varchar(191) NOT NULL,
  `configuration` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dashboard_configurations_business_id_foreign` (`business_id`),
  CONSTRAINT `dashboard_configurations_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `dashboard_configurations` WRITE;
/*!40000 ALTER TABLE `dashboard_configurations` DISABLE KEYS */;
/*!40000 ALTER TABLE `dashboard_configurations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `discount_variations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `discount_variations` (
  `discount_id` int(11) NOT NULL,
  `variation_id` int(11) NOT NULL,
  KEY `discount_variations_discount_id_index` (`discount_id`),
  KEY `discount_variations_variation_id_index` (`variation_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `discount_variations` WRITE;
/*!40000 ALTER TABLE `discount_variations` DISABLE KEYS */;
INSERT INTO `discount_variations` VALUES (1,1),(1,2),(1,3),(1,4),(1,5),(2,6),(3,7),(3,8),(3,9),(3,10),(3,11),(3,12),(3,13),(3,14),(3,15),(3,16),(3,17),(3,18),(3,19),(3,20),(3,21),(3,22),(3,23),(3,24),(3,25),(3,26),(3,27),(3,28),(3,29),(3,30),(3,31),(3,32),(3,33),(3,34),(3,35),(3,36),(3,37),(3,38),(3,39),(3,40),(3,41),(3,42),(3,43),(3,44),(3,45),(3,46),(3,47),(3,48),(3,49),(3,50),(3,51),(3,52),(3,53),(3,54),(3,55),(3,56),(3,57),(3,58),(3,59),(3,60),(3,61),(3,62),(3,63),(3,64),(3,65),(3,66),(3,67),(3,68),(3,69),(3,70),(3,71),(3,72),(3,73),(3,74),(3,75),(3,76),(3,77),(3,78),(3,79),(3,80),(3,81),(3,82),(3,83),(3,84),(3,85),(3,86),(3,87),(3,88),(3,89),(3,90),(3,91),(3,92),(3,93),(3,94),(3,95),(3,96),(3,97),(3,98),(3,99),(3,100),(3,101),(3,102),(3,103),(3,104),(3,105),(3,106),(3,107),(3,108),(3,109),(3,110),(3,111),(3,112),(3,113),(3,114),(3,115),(3,116),(3,117),(3,118),(3,119),(3,120),(3,121),(3,122),(3,123),(3,124),(3,125),(3,126),(4,127),(5,128),(5,129),(5,130),(5,131),(5,132),(5,133),(5,134),(5,135),(5,136),(5,137),(6,138),(6,139),(6,140),(6,141),(6,142),(6,143),(6,144),(6,145),(6,146),(6,147),(6,148),(6,149),(6,150),(6,151),(6,152),(6,153),(6,154),(6,155),(6,156),(6,157),(6,158),(6,159),(6,160),(6,161),(6,162),(6,163),(6,164),(6,165),(6,166),(6,167),(6,168),(6,169),(6,170),(6,171),(6,172),(6,173),(6,174),(6,175),(6,176),(6,177),(6,178),(6,179),(6,180),(6,181),(6,182),(6,183),(6,184),(6,185),(6,186),(6,187),(6,188),(6,189),(6,190),(6,191),(6,192),(6,193),(6,194),(6,195),(6,196),(6,197),(6,198),(6,199),(6,200),(6,201),(6,202),(6,203),(6,204),(6,205),(6,206),(6,207),(6,208),(6,209),(6,210),(6,211),(6,212),(6,213),(6,214),(6,215),(6,216),(6,217),(6,218),(6,219),(6,220),(6,221),(6,222),(6,223),(6,224),(6,225),(6,226),(6,227),(6,228),(6,229),(6,230),(6,231),(6,232),(6,233),(6,234),(6,235),(6,236),(6,237),(6,238),(6,239),(6,240),(6,241),(6,242),(6,243),(6,244),(6,245),(6,246),(6,247),(6,248),(6,249),(6,250),(6,251),(6,252),(6,253),(6,254),(6,255),(6,256),(6,257),(6,258),(6,259),(6,260),(6,261),(6,262),(6,263),(6,264),(6,265),(6,266),(6,267),(6,268),(6,269),(6,270),(6,271),(6,272),(6,273),(6,274),(6,275),(6,276),(6,277),(6,278),(6,279),(6,280),(6,281),(6,282),(6,283),(6,284),(6,285),(6,286),(6,287),(6,288),(6,289),(6,290),(6,291),(6,292),(6,293),(6,294),(6,295),(6,296),(6,297),(6,298),(6,299),(6,300),(6,301),(6,302),(6,303),(6,304),(6,305),(6,306),(6,307),(6,308),(6,309),(6,310),(6,311),(6,312),(6,313),(6,314),(6,315),(6,316),(6,317),(6,318),(6,319),(6,320),(6,321),(6,322),(6,323),(6,324),(6,325),(6,326),(6,327),(6,328),(6,329),(6,330),(6,331),(6,332),(6,333),(6,334),(6,335),(6,336),(6,337),(6,338),(6,339),(6,340),(6,341),(6,342),(6,343),(6,344),(6,345),(6,346),(6,347),(6,348),(6,349),(6,350),(6,351),(6,352),(6,353),(6,354),(6,355),(6,356),(6,357),(6,358),(6,359),(6,360),(6,361),(6,362),(6,363),(6,364),(6,365),(6,366),(6,367),(6,368),(6,369),(6,370),(6,371),(6,372),(6,373),(6,374),(6,375),(6,376),(6,377),(6,378),(6,379),(6,380),(6,381),(6,382),(6,383),(6,384),(6,385),(6,386),(6,387),(6,388),(6,389),(6,390),(6,391),(6,392),(6,393),(6,394),(6,395),(6,396),(6,397),(6,398),(6,399),(6,400),(6,401),(6,402),(6,403),(6,404),(6,405),(6,406),(6,407),(6,408),(6,409),(6,410),(6,411),(6,412),(6,413),(6,414),(6,415),(6,416),(6,417),(6,418),(6,419),(6,420),(6,421),(6,422),(6,423),(6,424),(6,425),(6,426),(6,427),(6,428),(6,429),(6,430),(6,431),(6,432),(6,433),(6,434),(6,435),(6,436),(6,437),(6,438),(6,439),(6,440),(6,441),(6,442),(6,443),(6,444),(6,445),(6,446),(6,447),(6,448),(6,449),(6,450),(6,451),(6,452),(6,453),(6,454),(6,455),(6,456),(6,457),(6,458),(6,459),(6,460),(6,461),(6,462),(6,463),(6,464),(6,465),(6,466),(6,467),(6,468),(6,469),(6,470),(6,471),(6,472),(6,473),(6,474),(6,475),(6,476),(6,477),(6,478),(6,479),(6,480),(6,481),(6,482),(6,483),(6,484),(6,485),(6,486),(6,487),(6,488),(6,489),(6,490),(6,491),(6,492),(6,493),(6,494),(6,495),(6,496),(6,497),(6,498),(6,499),(6,500),(6,501),(6,502),(6,503),(6,504),(6,505),(6,506),(6,507),(6,508),(6,509),(6,510),(6,511),(6,512),(6,513),(6,514),(6,515),(6,516),(6,517),(6,518),(6,519),(6,520),(6,521),(6,522),(6,523),(6,524),(6,525),(6,526),(6,527),(6,528),(6,529),(6,530),(6,531),(6,532),(6,533),(6,534),(6,535),(6,536),(6,537),(6,538),(6,539),(6,540),(6,541),(6,542),(6,543),(6,544),(6,545),(6,546),(6,547),(6,548),(6,549),(6,550),(6,551),(6,552),(6,553),(6,554),(6,555),(6,556),(6,557),(6,558),(6,559),(6,560),(6,561),(6,562),(6,563),(6,564),(6,565),(6,566),(6,567),(6,568),(6,569),(6,570),(6,571),(6,572),(6,573),(6,574),(6,575),(6,576),(6,577),(6,578),(6,579),(6,580),(6,581),(6,582),(6,583),(6,584),(6,585),(6,586),(6,587),(6,588),(6,589),(6,590),(6,591),(6,592),(6,593),(6,594),(6,595),(6,596),(6,597),(6,598),(6,599),(6,600),(6,601),(6,602),(6,603),(6,604),(6,605),(6,606),(6,607),(6,608),(6,609),(6,610),(6,611),(6,612),(6,613),(6,614),(6,615),(6,616),(6,617),(6,618),(6,619),(6,620),(6,621),(6,622),(6,623),(6,624),(6,625),(6,626),(6,627),(6,628),(6,629),(6,630),(6,631),(6,632),(6,633),(6,634),(6,635),(6,636),(6,637),(6,638),(6,639),(6,640),(6,641),(6,642),(6,643),(6,644),(6,645),(6,646),(6,647),(6,648),(6,649),(6,650),(6,651),(6,652),(6,653),(6,654),(6,655),(6,656),(6,657),(6,658),(6,659),(6,660),(6,661),(6,662),(6,663),(6,664),(6,665),(6,666),(6,667),(6,668),(6,669),(6,670),(6,671),(6,672),(6,673),(6,674),(6,675),(6,676),(6,677),(6,678),(6,679),(6,680),(6,681),(6,682),(6,683),(6,684),(6,685),(6,686),(6,687),(6,688),(6,689),(6,690),(6,691),(6,692),(6,693),(6,694),(6,695),(6,696),(6,697),(6,698),(6,699),(6,700),(6,701),(6,702),(6,703),(6,704),(6,705),(6,706),(6,707),(6,708),(6,709),(6,710),(6,711),(6,712),(6,713),(6,714),(6,715),(6,716),(6,717),(6,718),(6,719),(6,720),(6,721),(6,722),(6,723),(6,724),(6,725),(6,726),(6,727),(6,728),(6,729),(6,730),(6,731),(6,732),(6,733),(6,734),(6,735),(6,736),(6,737),(6,738),(6,739),(6,740),(6,741),(6,742),(6,743),(6,744),(6,745),(6,746),(6,747),(6,748),(6,749),(6,750),(6,751),(6,752),(6,753),(6,754),(6,755),(6,756),(6,757),(6,758),(6,759),(6,760),(6,761),(6,762),(6,763),(6,764),(6,765),(6,766),(6,767),(6,768),(6,769),(6,770),(6,771),(6,772),(6,773),(6,774),(6,775),(6,776),(6,777),(6,778),(6,779),(6,780),(6,781),(6,782),(6,783),(6,784),(6,785),(6,786),(6,787),(6,788),(6,789),(6,790),(6,791),(6,792),(6,793),(6,794),(6,795),(6,796),(6,797),(6,798),(6,799),(6,800),(6,801),(6,802),(6,803),(6,804),(6,805),(6,806),(6,807),(6,808),(6,809),(6,810),(6,811),(6,812),(6,813),(6,814),(6,815),(6,816),(6,817),(6,818),(6,819),(6,820),(6,821),(6,822),(6,823),(6,824),(6,825),(6,826),(6,827),(6,828),(6,829),(6,830),(6,831),(6,832),(6,833),(6,834),(6,835),(6,836),(6,837),(6,838),(6,839),(6,840),(6,841),(6,842),(6,843),(6,844),(6,845),(7,846),(7,847),(8,848),(8,849),(8,850),(8,851),(8,852),(8,853),(8,854),(8,855),(8,856),(8,857),(8,858),(8,859),(8,860),(8,861),(8,862),(8,863),(8,864),(8,865),(8,866),(8,867),(8,868),(8,869),(8,870),(8,871),(8,872),(8,873),(8,874),(8,875),(8,876),(8,877),(8,878),(8,879),(8,880),(8,881),(9,882),(9,883),(9,884),(9,885),(9,886),(9,887),(9,888),(9,889),(9,890),(9,891),(9,892),(9,893),(9,894),(9,895),(9,896),(9,897),(9,898),(10,899),(10,900),(10,901),(10,902),(10,903),(10,904),(10,905),(10,906),(10,907),(10,908),(10,909),(10,910),(10,911),(10,912),(10,913),(10,914),(10,915),(10,916),(10,917),(10,918),(10,919),(10,920),(10,921),(10,922),(10,923),(10,924),(10,925),(10,926),(10,927),(10,928),(10,929),(10,930),(10,931),(10,932),(10,933),(10,934),(10,935),(10,936),(10,937),(10,938),(10,939),(10,940),(10,941),(10,942),(10,943),(10,944),(10,945),(10,946),(10,947),(10,948),(10,949),(10,950),(10,951),(10,952),(10,953),(10,954),(10,955),(10,956),(10,957),(10,958),(10,959),(10,960),(10,961),(10,962),(10,963),(10,964),(10,965),(10,966),(10,967),(10,968),(10,969),(10,970),(10,971),(10,972),(10,973),(10,974),(10,975),(10,976),(10,977),(10,978),(10,979),(10,980),(10,981),(10,982),(10,983),(10,984),(10,985),(10,986),(10,987),(10,988),(10,989),(10,990),(10,991),(10,992),(10,993),(10,994),(10,995),(10,996),(10,997),(10,998),(10,999),(10,1000),(10,1001),(10,1002),(10,1003),(10,1004),(10,1005),(10,1006),(10,1007),(10,1008),(10,1009),(10,1010),(10,1011),(10,1012),(10,1013),(10,1014),(10,1015),(10,1016),(10,1017),(10,1018),(10,1019),(10,1020),(10,1021),(10,1022),(10,1023),(10,1024),(10,1025),(10,1026),(10,1027),(10,1028),(10,1029),(10,1030),(10,1031),(10,1032),(10,1033),(10,1034),(10,1035),(10,1036),(10,1037),(10,1038),(10,1039),(10,1040),(10,1041),(10,1042),(10,1043),(10,1044),(10,1045),(10,1046),(10,1047),(10,1048),(10,1049),(10,1050),(10,1051),(10,1052),(10,1053),(10,1054),(10,1055),(10,1056),(10,1057),(10,1058),(10,1059),(10,1060),(10,1061),(10,1062),(10,1063),(10,1064),(10,1065),(10,1066),(10,1067),(10,1068),(10,1069),(10,1070),(10,1071),(10,1072),(10,1073),(10,1074),(10,1075),(10,1076),(10,1077),(10,1078),(10,1079),(10,1080),(10,1081),(10,1082),(10,1083),(10,1084),(10,1085),(10,1086),(10,1087),(10,1088),(10,1089),(10,1090),(10,1091),(10,1092),(10,1093),(10,1094),(10,1095),(10,1096),(10,1097),(10,1098),(10,1099),(10,1100),(10,1101),(10,1102),(10,1103),(10,1104),(10,1105),(10,1106),(10,1107),(10,1108),(10,1109),(10,1110),(10,1111),(10,1112),(10,1113),(10,1114),(10,1115),(10,1116),(10,1117),(10,1118),(10,1119),(10,1120),(10,1121),(10,1122),(10,1123),(10,1124),(10,1125),(10,1126),(10,1127),(10,1128),(10,1129),(10,1130),(10,1131),(10,1132),(10,1133),(10,1134),(10,1135),(10,1136),(10,1137),(10,1138),(10,1139),(10,1140),(10,1141),(10,1142),(10,1143),(10,1144),(10,1145),(10,1146),(10,1147),(10,1148),(10,1149),(10,1150),(10,1151),(10,1152),(10,1153),(10,1154),(10,1155),(10,1156),(10,1157),(10,1158),(10,1159),(10,1160),(10,1161),(10,1162),(10,1163),(10,1164),(10,1165),(10,1166),(10,1167),(10,1168),(10,1169),(10,1170),(10,1171),(10,1172),(10,1173),(10,1174),(10,1175),(10,1176),(10,1177),(10,1178),(10,1179),(10,1180),(10,1181),(10,1182),(10,1183),(10,1184),(10,1185),(10,1186),(10,1187),(10,1188),(10,1189),(10,1190),(10,1191),(10,1192),(10,1193),(10,1194),(10,1195),(10,1196),(10,1197),(10,1198),(10,1199),(10,1200),(10,1201),(10,1202),(10,1203),(10,1204),(10,1205),(10,1206),(10,1207),(10,1208),(10,1209),(10,1210),(10,1211),(10,1212),(10,1213),(10,1214),(10,1215),(10,1216),(10,1217),(10,1218),(10,1219),(10,1220),(10,1221),(10,1222),(10,1223),(10,1224),(10,1225),(10,1226),(10,1227),(10,1228),(10,1229),(10,1230),(10,1231),(10,1232),(10,1233),(10,1234),(10,1235),(10,1236),(10,1237),(10,1238),(10,1239),(10,1240),(10,1241),(10,1242),(10,1243),(10,1244),(10,1245),(10,1246),(10,1247),(10,1248),(10,1249),(10,1250),(10,1251),(10,1252),(10,1253),(10,1254),(10,1255),(10,1256),(10,1257),(10,1258),(10,1259),(10,1260),(10,1261),(10,1262),(10,1263),(10,1264),(10,1265),(10,1266),(10,1267),(10,1268),(10,1269),(10,1270),(10,1271),(10,1272),(10,1273),(10,1274),(10,1275),(10,1276),(10,1277),(10,1278),(10,1279),(10,1280),(10,1281),(10,1282),(10,1283),(10,1284),(10,1285),(10,1286),(10,1287),(10,1288),(10,1289),(10,1290),(10,1291),(10,1292),(10,1293),(10,1294),(10,1295),(10,1296),(10,1297),(10,1298),(10,1299),(10,1300),(10,1301),(10,1302),(10,1303),(10,1304),(10,1305),(10,1306),(10,1307),(10,1308),(10,1309),(10,1310),(10,1311),(10,1312),(10,1313),(10,1314),(10,1315),(10,1316),(10,1317),(10,1318),(10,1319),(10,1320),(10,1321),(10,1322),(10,1323),(10,1324),(10,1325),(10,1326),(10,1327),(10,1328),(10,1329),(10,1330),(10,1331),(10,1332),(10,1333),(10,1334),(10,1335),(10,1336),(10,1337),(10,1338),(10,1339),(10,1340),(10,1341),(10,1342),(10,1343),(10,1344),(10,1345),(10,1346),(10,1347),(10,1348),(10,1349),(10,1350),(10,1351),(10,1352),(10,1353),(10,1354),(10,1355),(10,1356),(10,1357),(10,1358),(10,1359),(10,1360),(10,1361),(10,1362),(10,1363),(10,1364),(10,1365),(10,1366),(10,1367),(10,1368),(10,1369),(10,1370),(10,1371),(10,1372),(10,1373),(10,1374),(10,1375),(10,1376),(10,1377),(10,1378),(10,1379),(10,1380),(10,1381),(10,1382),(10,1383),(10,1384),(10,1385),(10,1386),(10,1387),(10,1388),(10,1389),(10,1390),(10,1391),(10,1392),(10,1393),(10,1394),(10,1395),(10,1396),(10,1397),(10,1398),(10,1399),(10,1400),(10,1401),(10,1402),(10,1403),(10,1404),(10,1405),(10,1406),(10,1407),(10,1408),(10,1409),(10,1410),(10,1411),(10,1412),(10,1413),(10,1414),(10,1415),(10,1416),(10,1417),(10,1418),(10,1419),(10,1420),(10,1421),(10,1422),(10,1423),(10,1424),(10,1425),(10,1426),(11,1427),(11,1428),(11,1429),(11,1430),(11,1431),(11,1432),(11,1433),(11,1434),(11,1435),(11,1436),(11,1437),(11,1438),(11,1439),(11,1440),(11,1441),(11,1442),(11,1443),(11,1444),(11,1445),(11,1446),(11,1447),(12,1448),(12,1449),(13,1450),(13,1451),(13,1452),(13,1453),(13,1454),(13,1455),(13,1456),(13,1457),(13,1458),(13,1459),(13,1460),(13,1461),(13,1462),(13,1463),(13,1464),(13,1465),(13,1466),(13,1467),(13,1468),(13,1469),(13,1470),(13,1471),(13,1472),(13,1473),(13,1474),(13,1475),(13,1476),(13,1477),(13,1478),(13,1479),(13,1480),(13,1481),(13,1482),(13,1483),(13,1484),(13,1485),(13,1486),(13,1487),(13,1488),(13,1489),(13,1490),(13,1491),(13,1492),(13,1493),(13,1494),(13,1495),(13,1496),(13,1497),(13,1498),(13,1499),(13,1500),(13,1501),(13,1502),(13,1503),(13,1504),(13,1505),(13,1506),(13,1507),(13,1508),(13,1509),(13,1510),(13,1511),(13,1512),(13,1513),(13,1514),(13,1515),(13,1516),(13,1517),(13,1518),(13,1519),(13,1520),(13,1521),(13,1522),(13,1523),(13,1524),(13,1525),(13,1526),(13,1527),(13,1528),(13,1529),(13,1530),(13,1531),(13,1532),(13,1533),(13,1534),(13,1535),(13,1536),(13,1537),(13,1538),(13,1539),(13,1540),(13,1541),(13,1542),(13,1543),(13,1544),(13,1545),(13,1546),(13,1547),(13,1548),(13,1549),(13,1550),(13,1551),(13,1552),(13,1553),(13,1554),(13,1555),(13,1556),(13,1557),(13,1558),(13,1559),(13,1560),(13,1561),(14,1562),(14,1563),(15,1564),(15,1565),(15,1566),(15,1567),(15,1568),(15,1569),(15,1570),(15,1571),(15,1572),(15,1573),(15,1574),(15,1575),(15,1576),(15,1577),(15,1578),(15,1579),(15,1580),(15,1581),(15,1582),(15,1583),(15,1584),(15,1585),(15,1586),(15,1587),(16,1588),(16,1589),(17,1590),(17,1591),(17,1592),(17,1593),(17,1594),(17,1595),(17,1596),(17,1597),(17,1598),(17,1599),(17,1600),(17,1601),(17,1602),(17,1603),(17,1604),(17,1605),(17,1606),(17,1607),(17,1608),(17,1609),(17,1610),(17,1611),(17,1612),(17,1613),(17,1614),(17,1615),(17,1616),(17,1617),(17,1618),(17,1619),(17,1620),(17,1621),(17,1622),(17,1623),(17,1624),(17,1625),(17,1626),(17,1627),(17,1628),(17,1629),(17,1630),(17,1631),(17,1632),(17,1633),(17,1634),(17,1635),(17,1636),(17,1637),(17,1638),(17,1639),(17,1640),(17,1641),(17,1642),(17,1643),(17,1644),(17,1645),(17,1646),(17,1647),(17,1648),(17,1649),(17,1650),(17,1651),(17,1652),(17,1653),(17,1654),(17,1655),(17,1656),(17,1657),(17,1658),(17,1659),(17,1660),(17,1661),(17,1662),(17,1663),(17,1664),(17,1665),(17,1666),(17,1667),(17,1668),(17,1669),(17,1670),(17,1671),(17,1672),(17,1673),(17,1674),(17,1675),(17,1676),(17,1677),(17,1678),(17,1679),(17,1680),(17,1681),(17,1682),(17,1683),(17,1684),(17,1685),(17,1686),(17,1687),(17,1688),(17,1689),(17,1690),(17,1691),(17,1692),(17,1693),(17,1694),(17,1695),(17,1696),(17,1697),(17,1698),(17,1699),(17,1700),(17,1701),(17,1702),(17,1703),(17,1704),(17,1705),(17,1706),(17,1707),(17,1708),(17,1709),(17,1710),(17,1711),(17,1712),(17,1713),(17,1714),(17,1715),(17,1716),(17,1717),(17,1718),(17,1719),(17,1720),(17,1721),(17,1722),(17,1723),(17,1724),(17,1725),(17,1726),(17,1727),(17,1728),(17,1729),(17,1730),(17,1731),(17,1732),(17,1733),(17,1734),(17,1735),(17,1736),(17,1737),(17,1738),(17,1739),(17,1740),(17,1741),(18,1742),(18,1743),(18,1744),(18,1745),(19,1746),(19,1747),(20,1748),(21,1749),(21,1750),(21,1751),(22,1752),(22,1753),(23,1754),(23,1755),(23,1756),(23,1757),(23,1758),(23,1759),(23,1760),(23,1761),(23,1762),(23,1763),(23,1764),(23,1765),(23,1766),(23,1767),(23,1768),(23,1769),(23,1770),(23,1771),(23,1772),(23,1773),(23,1774),(23,1775),(23,1776),(23,1777),(23,1778),(23,1779),(23,1780),(23,1781),(23,1782),(23,1783),(23,1784),(23,1785),(23,1786),(23,1787),(23,1788),(23,1789),(23,1790),(23,1791),(23,1792),(23,1793),(24,1794),(24,1795),(24,1796),(24,1797),(24,1798),(25,1799),(26,1800),(26,1801),(26,1802),(26,1803),(27,1804),(27,1805),(27,1806),(27,1807),(27,1808),(27,1809),(28,1810),(28,1811),(29,1812),(29,1813);
/*!40000 ALTER TABLE `discount_variations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `discounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `discounts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `business_id` int(11) NOT NULL,
  `brand_id` int(11) DEFAULT NULL,
  `category_id` int(11) DEFAULT NULL,
  `location_id` int(11) DEFAULT NULL,
  `priority` int(11) DEFAULT NULL,
  `discount_type` varchar(191) DEFAULT NULL,
  `discount_amount` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `starts_at` datetime DEFAULT NULL,
  `ends_at` datetime DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `spg` varchar(100) DEFAULT NULL COMMENT 'Applicable in specified selling price group only. Use of applicable_in_spg column is discontinued',
  `applicable_in_cg` tinyint(1) DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `discounts_business_id_index` (`business_id`),
  KEY `discounts_brand_id_index` (`brand_id`),
  KEY `discounts_category_id_index` (`category_id`),
  KEY `discounts_location_id_index` (`location_id`),
  KEY `discounts_priority_index` (`priority`),
  KEY `discounts_spg_index` (`spg`)
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `discounts` WRITE;
/*!40000 ALTER TABLE `discounts` DISABLE KEYS */;
INSERT INTO `discounts` VALUES (1,'Rs 3',1,NULL,NULL,1,1,'fixed',3.0000,'2024-12-09 16:01:00','2025-12-09 16:01:00',1,NULL,0,'2024-12-09 16:01:00','2024-12-09 16:01:00'),(2,'Rs 4',1,NULL,NULL,1,1,'fixed',4.0000,'2024-12-09 16:01:01','2025-12-09 16:01:00',1,NULL,0,'2024-12-09 16:01:00','2024-12-09 16:01:00'),(3,'Rs 5',1,NULL,NULL,1,1,'fixed',5.0000,'2024-12-09 16:01:02','2025-12-09 16:01:00',1,NULL,0,'2024-12-09 16:01:00','2024-12-09 16:01:00'),(4,'Rs 8',1,NULL,NULL,1,1,'fixed',8.0000,'2024-12-09 16:01:03','2025-12-09 16:01:00',1,NULL,0,'2024-12-09 16:01:00','2024-12-09 16:01:00'),(5,'Rs 9',1,NULL,NULL,1,1,'fixed',9.0000,'2024-12-09 16:01:04','2025-12-09 16:01:00',1,NULL,0,'2024-12-09 16:01:00','2024-12-09 16:01:00'),(6,'Rs 10',1,NULL,NULL,1,1,'fixed',10.0000,'2024-12-09 16:01:05','2025-12-09 16:01:00',1,NULL,0,'2024-12-09 16:01:00','2024-12-09 16:01:00'),(7,'Rs 14',1,NULL,NULL,1,1,'fixed',14.0000,'2024-12-09 16:01:06','2025-12-09 16:01:00',1,NULL,0,'2024-12-09 16:01:00','2024-12-09 16:01:00'),(8,'Rs 15',1,NULL,NULL,1,1,'fixed',15.0000,'2024-12-09 16:01:07','2025-12-09 16:01:00',1,NULL,0,'2024-12-09 16:01:00','2024-12-09 16:01:00'),(9,'Rs 19',1,NULL,NULL,1,1,'fixed',19.0000,'2024-12-09 16:01:08','2025-12-09 16:01:00',1,NULL,0,'2024-12-09 16:01:00','2024-12-09 16:01:00'),(10,'Rs 20',1,NULL,NULL,1,1,'fixed',20.0000,'2024-12-09 16:01:09','2025-12-09 16:01:00',1,NULL,0,'2024-12-09 16:01:00','2024-12-09 16:01:00'),(11,'Rs 25',1,NULL,NULL,1,1,'fixed',25.0000,'2024-12-09 16:01:10','2025-12-09 16:01:00',1,NULL,0,'2024-12-09 16:01:00','2024-12-09 16:01:00'),(12,'Rs 29',1,NULL,NULL,1,1,'fixed',29.0000,'2024-12-09 16:01:11','2025-12-09 16:01:00',1,NULL,0,'2024-12-09 16:01:00','2024-12-09 16:01:00'),(13,'Rs 30',1,NULL,NULL,1,1,'fixed',30.0000,'2024-12-09 16:01:12','2025-12-09 16:01:00',1,NULL,0,'2024-12-09 16:01:00','2024-12-09 16:01:00'),(14,'Rs 35',1,NULL,NULL,1,1,'fixed',35.0000,'2024-12-09 16:01:13','2025-12-09 16:01:00',1,NULL,0,'2024-12-09 16:01:00','2024-12-09 16:01:00'),(15,'Rs 40',1,NULL,NULL,1,1,'fixed',40.0000,'2024-12-09 16:01:14','2025-12-09 16:01:00',1,NULL,0,'2024-12-09 16:01:00','2024-12-09 16:01:00'),(16,'Rs 49',1,NULL,NULL,1,1,'fixed',49.0000,'2024-12-09 16:01:15','2025-12-09 16:01:00',1,NULL,0,'2024-12-09 16:01:00','2024-12-09 16:01:00'),(17,'Rs 50',1,NULL,NULL,1,1,'fixed',50.0000,'2024-12-09 16:01:16','2025-12-09 16:01:00',1,NULL,0,'2024-12-09 16:01:00','2024-12-09 16:01:00'),(18,'Rs 55',1,NULL,NULL,1,1,'fixed',55.0000,'2024-12-09 16:01:17','2025-12-09 16:01:00',1,NULL,0,'2024-12-09 16:01:00','2024-12-09 16:01:00'),(19,'Rs 60',1,NULL,NULL,1,1,'fixed',60.0000,'2024-12-09 16:01:18','2025-12-09 16:01:00',1,NULL,0,'2024-12-09 16:01:00','2024-12-09 16:01:00'),(20,'Rs 70',1,NULL,NULL,1,1,'fixed',70.0000,'2024-12-09 16:01:19','2025-12-09 16:01:00',1,NULL,0,'2024-12-09 16:01:00','2024-12-09 16:01:00'),(21,'Rs 90',1,NULL,NULL,1,1,'fixed',90.0000,'2024-12-09 16:01:20','2025-12-09 16:01:00',1,NULL,0,'2024-12-09 16:01:00','2024-12-09 16:01:00'),(22,'Rs 99',1,NULL,NULL,1,1,'fixed',99.0000,'2024-12-09 16:01:21','2025-12-09 16:01:00',1,NULL,0,'2024-12-09 16:01:00','2024-12-09 16:01:00'),(23,'Rs 100',1,NULL,NULL,1,1,'fixed',100.0000,'2024-12-09 16:01:22','2025-12-09 16:01:00',1,NULL,0,'2024-12-09 16:01:00','2024-12-09 16:01:00'),(24,'Rs 150',1,NULL,NULL,1,1,'fixed',150.0000,'2024-12-09 16:01:23','2025-12-09 16:01:00',1,NULL,0,'2024-12-09 16:01:00','2024-12-09 16:01:00'),(25,'Rs 199',1,NULL,NULL,1,1,'fixed',199.0000,'2024-12-09 16:01:24','2025-12-09 16:01:00',1,NULL,0,'2024-12-09 16:01:00','2024-12-09 16:01:00'),(26,'Rs 200',1,NULL,NULL,1,1,'fixed',200.0000,'2024-12-09 16:01:25','2025-12-09 16:01:00',1,NULL,0,'2024-12-09 16:01:00','2024-12-09 16:01:00'),(27,'Rs 249',1,NULL,NULL,1,1,'fixed',249.0000,'2024-12-09 16:01:26','2025-12-09 16:01:00',1,NULL,0,'2024-12-09 16:01:00','2024-12-09 16:01:00'),(28,'Rs 250',1,NULL,NULL,1,1,'fixed',250.0000,'2024-12-09 16:01:27','2025-12-09 16:01:00',1,NULL,0,'2024-12-09 16:01:00','2024-12-09 16:01:00'),(29,'Rs 300',1,NULL,NULL,1,1,'fixed',300.0000,'2024-12-09 16:01:28','2025-12-09 16:01:00',1,NULL,0,'2024-12-09 16:01:00','2024-12-09 16:01:00');
/*!40000 ALTER TABLE `discounts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `document_and_notes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `document_and_notes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `notable_id` int(11) NOT NULL,
  `notable_type` varchar(191) NOT NULL,
  `heading` text DEFAULT NULL,
  `description` text DEFAULT NULL,
  `is_private` tinyint(1) NOT NULL DEFAULT 0,
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `document_and_notes_business_id_index` (`business_id`),
  KEY `document_and_notes_notable_id_index` (`notable_id`),
  KEY `document_and_notes_created_by_index` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `document_and_notes` WRITE;
/*!40000 ALTER TABLE `document_and_notes` DISABLE KEYS */;
/*!40000 ALTER TABLE `document_and_notes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_allowances_and_deductions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `essentials_allowances_and_deductions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `description` varchar(191) NOT NULL,
  `type` enum('allowance','deduction') NOT NULL,
  `amount` decimal(22,4) NOT NULL,
  `amount_type` enum('fixed','percent') NOT NULL,
  `applicable_date` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_allowances_and_deductions_business_id_index` (`business_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_allowances_and_deductions` WRITE;
/*!40000 ALTER TABLE `essentials_allowances_and_deductions` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_allowances_and_deductions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_attendances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `essentials_attendances` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `business_id` int(11) NOT NULL,
  `clock_in_time` datetime DEFAULT NULL,
  `clock_out_time` datetime DEFAULT NULL,
  `essentials_shift_id` int(11) DEFAULT NULL,
  `ip_address` varchar(191) DEFAULT NULL,
  `clock_in_note` text DEFAULT NULL,
  `clock_out_note` text DEFAULT NULL,
  `clock_in_location` text DEFAULT NULL,
  `clock_out_location` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_attendances_user_id_index` (`user_id`),
  KEY `essentials_attendances_business_id_index` (`business_id`),
  KEY `essentials_attendances_essentials_shift_id_index` (`essentials_shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_attendances` WRITE;
/*!40000 ALTER TABLE `essentials_attendances` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_attendances` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_document_shares`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `essentials_document_shares` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `document_id` int(11) NOT NULL,
  `value_type` enum('user','role') NOT NULL,
  `value` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_document_shares_document_id_index` (`document_id`),
  KEY `essentials_document_shares_value_type_index` (`value_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_document_shares` WRITE;
/*!40000 ALTER TABLE `essentials_document_shares` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_document_shares` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_documents`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `essentials_documents` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `type` varchar(191) DEFAULT NULL,
  `name` varchar(191) NOT NULL,
  `description` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_documents` WRITE;
/*!40000 ALTER TABLE `essentials_documents` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_documents` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `essentials_holidays` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) DEFAULT NULL,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `business_id` int(11) NOT NULL,
  `location_id` int(11) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_holidays_business_id_index` (`business_id`),
  KEY `essentials_holidays_location_id_index` (`location_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_holidays` WRITE;
/*!40000 ALTER TABLE `essentials_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_holidays` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_kb`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `essentials_kb` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` bigint(20) unsigned NOT NULL,
  `title` varchar(191) NOT NULL,
  `content` longtext DEFAULT NULL,
  `status` varchar(191) NOT NULL,
  `kb_type` varchar(191) NOT NULL,
  `parent_id` bigint(20) unsigned DEFAULT NULL COMMENT 'id from essentials_kb table',
  `share_with` varchar(191) DEFAULT NULL COMMENT 'public, private, only_with',
  `created_by` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_kb_business_id_index` (`business_id`),
  KEY `essentials_kb_parent_id_index` (`parent_id`),
  KEY `essentials_kb_created_by_index` (`created_by`),
  CONSTRAINT `essentials_kb_parent_id_foreign` FOREIGN KEY (`parent_id`) REFERENCES `essentials_kb` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_kb` WRITE;
/*!40000 ALTER TABLE `essentials_kb` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_kb` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_kb_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `essentials_kb_users` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `kb_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_kb_users_kb_id_index` (`kb_id`),
  KEY `essentials_kb_users_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_kb_users` WRITE;
/*!40000 ALTER TABLE `essentials_kb_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_kb_users` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_leave_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `essentials_leave_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `leave_type` varchar(191) NOT NULL,
  `max_leave_count` int(11) DEFAULT NULL,
  `leave_count_interval` enum('month','year') DEFAULT NULL,
  `business_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_leave_types_business_id_index` (`business_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_leave_types` WRITE;
/*!40000 ALTER TABLE `essentials_leave_types` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_leave_types` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_leaves`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `essentials_leaves` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `essentials_leave_type_id` int(11) DEFAULT NULL,
  `business_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `ref_no` varchar(191) DEFAULT NULL,
  `status` enum('pending','approved','cancelled') DEFAULT NULL,
  `reason` text DEFAULT NULL,
  `status_note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_leaves_essentials_leave_type_id_index` (`essentials_leave_type_id`),
  KEY `essentials_leaves_business_id_index` (`business_id`),
  KEY `essentials_leaves_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_leaves` WRITE;
/*!40000 ALTER TABLE `essentials_leaves` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_leaves` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `essentials_messages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `message` text NOT NULL,
  `location_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_messages_business_id_index` (`business_id`),
  KEY `essentials_messages_user_id_index` (`user_id`),
  KEY `essentials_messages_location_id_index` (`location_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_messages` WRITE;
/*!40000 ALTER TABLE `essentials_messages` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_messages` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_payroll_group_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `essentials_payroll_group_transactions` (
  `payroll_group_id` bigint(20) unsigned NOT NULL,
  `transaction_id` int(11) NOT NULL,
  KEY `essentials_payroll_group_transactions_payroll_group_id_foreign` (`payroll_group_id`),
  CONSTRAINT `essentials_payroll_group_transactions_payroll_group_id_foreign` FOREIGN KEY (`payroll_group_id`) REFERENCES `essentials_payroll_groups` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_payroll_group_transactions` WRITE;
/*!40000 ALTER TABLE `essentials_payroll_group_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_payroll_group_transactions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_payroll_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `essentials_payroll_groups` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `location_id` int(11) DEFAULT NULL COMMENT 'payroll for work location',
  `name` varchar(191) NOT NULL,
  `status` varchar(191) NOT NULL,
  `payment_status` varchar(191) NOT NULL DEFAULT 'due',
  `gross_total` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_payroll_groups` WRITE;
/*!40000 ALTER TABLE `essentials_payroll_groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_payroll_groups` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_reminders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `essentials_reminders` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `name` varchar(191) NOT NULL,
  `date` date NOT NULL,
  `time` time NOT NULL,
  `end_time` time DEFAULT NULL,
  `repeat` enum('one_time','every_day','every_week','every_month') NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_reminders_business_id_index` (`business_id`),
  KEY `essentials_reminders_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_reminders` WRITE;
/*!40000 ALTER TABLE `essentials_reminders` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_reminders` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `essentials_shifts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `type` enum('fixed_shift','flexible_shift') NOT NULL DEFAULT 'fixed_shift',
  `business_id` int(11) NOT NULL,
  `start_time` time DEFAULT NULL,
  `end_time` time DEFAULT NULL,
  `is_allowed_auto_clockout` tinyint(1) NOT NULL DEFAULT 0,
  `auto_clockout_time` time DEFAULT NULL,
  `holidays` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_shifts_type_index` (`type`),
  KEY `essentials_shifts_business_id_index` (`business_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_shifts` WRITE;
/*!40000 ALTER TABLE `essentials_shifts` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_shifts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_to_dos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `essentials_to_dos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `task` text NOT NULL,
  `date` datetime DEFAULT NULL,
  `end_date` datetime DEFAULT NULL,
  `task_id` varchar(191) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `status` varchar(191) DEFAULT NULL,
  `estimated_hours` varchar(191) DEFAULT NULL,
  `priority` varchar(191) DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_to_dos_status_index` (`status`),
  KEY `essentials_to_dos_priority_index` (`priority`),
  KEY `essentials_to_dos_created_by_index` (`created_by`),
  KEY `essentials_to_dos_business_id_index` (`business_id`),
  KEY `essentials_to_dos_task_id_index` (`task_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_to_dos` WRITE;
/*!40000 ALTER TABLE `essentials_to_dos` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_to_dos` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_todo_comments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `essentials_todo_comments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `comment` text NOT NULL,
  `task_id` int(11) NOT NULL,
  `comment_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_todo_comments_task_id_index` (`task_id`),
  KEY `essentials_todo_comments_comment_by_index` (`comment_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_todo_comments` WRITE;
/*!40000 ALTER TABLE `essentials_todo_comments` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_todo_comments` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_todos_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `essentials_todos_users` (
  `todo_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_todos_users` WRITE;
/*!40000 ALTER TABLE `essentials_todos_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_todos_users` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_user_allowance_and_deductions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `essentials_user_allowance_and_deductions` (
  `user_id` int(11) NOT NULL,
  `allowance_deduction_id` int(11) NOT NULL,
  KEY `essentials_user_allowance_and_deductions_user_id_index` (`user_id`),
  KEY `allow_deduct_index` (`allowance_deduction_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_user_allowance_and_deductions` WRITE;
/*!40000 ALTER TABLE `essentials_user_allowance_and_deductions` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_user_allowance_and_deductions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_user_sales_targets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `essentials_user_sales_targets` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `target_start` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `target_end` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `commission_percent` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_user_sales_targets` WRITE;
/*!40000 ALTER TABLE `essentials_user_sales_targets` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_user_sales_targets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_user_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `essentials_user_shifts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `essentials_shift_id` int(11) NOT NULL,
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_user_shifts_user_id_index` (`user_id`),
  KEY `essentials_user_shifts_essentials_shift_id_index` (`essentials_shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_user_shifts` WRITE;
/*!40000 ALTER TABLE `essentials_user_shifts` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_user_shifts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `expense_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `expense_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `code` varchar(191) DEFAULT NULL,
  `parent_id` int(11) DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `expense_categories_business_id_foreign` (`business_id`),
  CONSTRAINT `expense_categories_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `expense_categories` WRITE;
/*!40000 ALTER TABLE `expense_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `expense_categories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `group_sub_taxes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `group_sub_taxes` (
  `group_tax_id` int(10) unsigned NOT NULL,
  `tax_id` int(10) unsigned NOT NULL,
  KEY `group_sub_taxes_group_tax_id_foreign` (`group_tax_id`),
  KEY `group_sub_taxes_tax_id_foreign` (`tax_id`),
  CONSTRAINT `group_sub_taxes_group_tax_id_foreign` FOREIGN KEY (`group_tax_id`) REFERENCES `tax_rates` (`id`) ON DELETE CASCADE,
  CONSTRAINT `group_sub_taxes_tax_id_foreign` FOREIGN KEY (`tax_id`) REFERENCES `tax_rates` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `group_sub_taxes` WRITE;
/*!40000 ALTER TABLE `group_sub_taxes` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_sub_taxes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `invoice_layouts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `invoice_layouts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `header_text` text DEFAULT NULL,
  `invoice_no_prefix` varchar(191) DEFAULT NULL,
  `quotation_no_prefix` varchar(191) DEFAULT NULL,
  `invoice_heading` varchar(191) DEFAULT NULL,
  `sub_heading_line1` varchar(191) DEFAULT NULL,
  `sub_heading_line2` varchar(191) DEFAULT NULL,
  `sub_heading_line3` varchar(191) DEFAULT NULL,
  `sub_heading_line4` varchar(191) DEFAULT NULL,
  `sub_heading_line5` varchar(191) DEFAULT NULL,
  `invoice_heading_not_paid` varchar(191) DEFAULT NULL,
  `invoice_heading_paid` varchar(191) DEFAULT NULL,
  `quotation_heading` varchar(191) DEFAULT NULL,
  `sub_total_label` varchar(191) DEFAULT NULL,
  `discount_label` varchar(191) DEFAULT NULL,
  `tax_label` varchar(191) DEFAULT NULL,
  `total_label` varchar(191) DEFAULT NULL,
  `round_off_label` varchar(191) DEFAULT NULL,
  `total_due_label` varchar(191) DEFAULT NULL,
  `paid_label` varchar(191) DEFAULT NULL,
  `show_client_id` tinyint(1) NOT NULL DEFAULT 0,
  `client_id_label` varchar(191) DEFAULT NULL,
  `client_tax_label` varchar(191) DEFAULT NULL,
  `date_label` varchar(191) DEFAULT NULL,
  `date_time_format` varchar(191) DEFAULT NULL,
  `show_time` tinyint(1) NOT NULL DEFAULT 1,
  `show_brand` tinyint(1) NOT NULL DEFAULT 0,
  `show_sku` tinyint(1) NOT NULL DEFAULT 1,
  `show_cat_code` tinyint(1) NOT NULL DEFAULT 1,
  `show_multi_unit_details` tinyint(1) NOT NULL DEFAULT 0,
  `show_expiry` tinyint(1) NOT NULL DEFAULT 0,
  `show_lot` tinyint(1) NOT NULL DEFAULT 0,
  `show_image` tinyint(1) NOT NULL DEFAULT 0,
  `show_sale_description` tinyint(1) NOT NULL DEFAULT 0,
  `sales_person_label` varchar(191) DEFAULT NULL,
  `show_sales_person` tinyint(1) NOT NULL DEFAULT 0,
  `table_product_label` varchar(191) DEFAULT NULL,
  `table_qty_label` varchar(191) DEFAULT NULL,
  `table_unit_price_label` varchar(191) DEFAULT NULL,
  `table_subtotal_label` varchar(191) DEFAULT NULL,
  `cat_code_label` varchar(191) DEFAULT NULL,
  `logo` varchar(191) DEFAULT NULL,
  `show_logo` tinyint(1) NOT NULL DEFAULT 0,
  `show_business_name` tinyint(1) NOT NULL DEFAULT 0,
  `show_location_name` tinyint(1) NOT NULL DEFAULT 1,
  `show_landmark` tinyint(1) NOT NULL DEFAULT 1,
  `show_city` tinyint(1) NOT NULL DEFAULT 1,
  `show_state` tinyint(1) NOT NULL DEFAULT 1,
  `show_zip_code` tinyint(1) NOT NULL DEFAULT 1,
  `show_country` tinyint(1) NOT NULL DEFAULT 1,
  `show_mobile_number` tinyint(1) NOT NULL DEFAULT 1,
  `show_alternate_number` tinyint(1) NOT NULL DEFAULT 0,
  `show_email` tinyint(1) NOT NULL DEFAULT 0,
  `show_tax_1` tinyint(1) NOT NULL DEFAULT 1,
  `show_tax_2` tinyint(1) NOT NULL DEFAULT 0,
  `show_barcode` tinyint(1) NOT NULL DEFAULT 0,
  `show_payments` tinyint(1) NOT NULL DEFAULT 0,
  `show_customer` tinyint(1) NOT NULL DEFAULT 0,
  `customer_label` varchar(191) DEFAULT NULL,
  `commission_agent_label` varchar(191) DEFAULT NULL,
  `show_commission_agent` tinyint(1) NOT NULL DEFAULT 0,
  `show_reward_point` tinyint(1) NOT NULL DEFAULT 0,
  `highlight_color` varchar(10) DEFAULT NULL,
  `footer_text` text DEFAULT NULL,
  `module_info` text DEFAULT NULL,
  `common_settings` text DEFAULT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  `business_id` int(10) unsigned NOT NULL,
  `show_letter_head` tinyint(1) NOT NULL DEFAULT 0,
  `letter_head` varchar(191) DEFAULT NULL,
  `show_qr_code` tinyint(1) NOT NULL DEFAULT 0,
  `qr_code_fields` text DEFAULT NULL,
  `design` varchar(190) DEFAULT 'classic',
  `cn_heading` varchar(191) DEFAULT NULL COMMENT 'cn = credit note',
  `cn_no_label` varchar(191) DEFAULT NULL,
  `cn_amount_label` varchar(191) DEFAULT NULL,
  `table_tax_headings` text DEFAULT NULL,
  `show_previous_bal` tinyint(1) NOT NULL DEFAULT 0,
  `prev_bal_label` varchar(191) DEFAULT NULL,
  `change_return_label` varchar(191) DEFAULT NULL,
  `product_custom_fields` text DEFAULT NULL,
  `contact_custom_fields` text DEFAULT NULL,
  `location_custom_fields` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `invoice_layouts_business_id_foreign` (`business_id`),
  CONSTRAINT `invoice_layouts_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `invoice_layouts` WRITE;
/*!40000 ALTER TABLE `invoice_layouts` DISABLE KEYS */;
INSERT INTO `invoice_layouts` VALUES (1,'Default',NULL,'Invoice No.',NULL,'Invoice',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Subtotal','Discount','Tax','Total',NULL,'Total Due','Total Paid',0,NULL,NULL,'Date',NULL,1,0,1,1,0,0,0,0,0,NULL,0,'Product','Quantity','Unit Price','Subtotal',NULL,NULL,0,0,1,1,1,1,1,1,1,0,0,1,0,0,1,1,'Customer',NULL,0,0,'#000000',NULL,NULL,'{\"proforma_heading\":null,\"sales_order_heading\":null,\"due_date_label\":null,\"show_multi_unit_details\":\"1\",\"show_only_sold_unit\":\"1\",\"show_serial_number\":\"1\",\"total_quantity_label\":null,\"item_discount_label\":null,\"discounted_unit_price_label\":null,\"total_items_label\":null,\"num_to_word_format\":\"international\",\"tax_summary_label\":null}',1,1,0,NULL,0,NULL,'classic',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'2024-10-25 16:39:24','2024-11-15 18:11:24');
/*!40000 ALTER TABLE `invoice_layouts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `invoice_schemes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `invoice_schemes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) NOT NULL,
  `scheme_type` enum('blank','year') NOT NULL,
  `number_type` varchar(100) NOT NULL DEFAULT 'sequential',
  `prefix` varchar(191) DEFAULT NULL,
  `start_number` int(11) DEFAULT NULL,
  `invoice_count` int(11) NOT NULL DEFAULT 0,
  `total_digits` int(11) DEFAULT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `invoice_schemes_business_id_foreign` (`business_id`),
  KEY `invoice_schemes_scheme_type_index` (`scheme_type`),
  KEY `invoice_schemes_number_type_index` (`number_type`),
  CONSTRAINT `invoice_schemes_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `invoice_schemes` WRITE;
/*!40000 ALTER TABLE `invoice_schemes` DISABLE KEYS */;
INSERT INTO `invoice_schemes` VALUES (1,1,'Default','blank','sequential','',1,57,4,1,'2024-10-25 16:39:24','2024-12-09 16:26:45');
/*!40000 ALTER TABLE `invoice_schemes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `media`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `media` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `file_name` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  `uploaded_by` int(11) DEFAULT NULL,
  `model_type` varchar(191) NOT NULL,
  `model_media_type` varchar(191) DEFAULT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `media_model_type_model_id_index` (`model_type`,`model_id`),
  KEY `media_business_id_index` (`business_id`),
  KEY `media_uploaded_by_index` (`uploaded_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `media` WRITE;
/*!40000 ALTER TABLE `media` DISABLE KEYS */;
/*!40000 ALTER TABLE `media` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `mfg_ingredient_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mfg_ingredient_groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `business_id` int(11) NOT NULL,
  `description` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `mfg_ingredient_groups` WRITE;
/*!40000 ALTER TABLE `mfg_ingredient_groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `mfg_ingredient_groups` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `mfg_recipe_ingredients`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mfg_recipe_ingredients` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mfg_recipe_id` int(10) unsigned NOT NULL,
  `variation_id` int(11) NOT NULL,
  `mfg_ingredient_group_id` int(11) DEFAULT NULL,
  `quantity` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `waste_percent` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `sub_unit_id` int(11) DEFAULT NULL,
  `sort_order` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mfg_recipe_ingredients_mfg_recipe_id_index` (`mfg_recipe_id`),
  KEY `mfg_recipe_ingredients_variation_id_index` (`variation_id`),
  KEY `mfg_recipe_ingredients_sub_unit_id_index` (`sub_unit_id`),
  CONSTRAINT `mfg_recipe_ingredients_mfg_recipe_id_foreign` FOREIGN KEY (`mfg_recipe_id`) REFERENCES `mfg_recipes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `mfg_recipe_ingredients` WRITE;
/*!40000 ALTER TABLE `mfg_recipe_ingredients` DISABLE KEYS */;
/*!40000 ALTER TABLE `mfg_recipe_ingredients` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `mfg_recipes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mfg_recipes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` int(11) NOT NULL,
  `variation_id` int(11) NOT NULL,
  `instructions` text DEFAULT NULL,
  `waste_percent` decimal(10,2) NOT NULL DEFAULT 0.00,
  `ingredients_cost` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `extra_cost` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `production_cost_type` varchar(191) DEFAULT 'percentage',
  `total_quantity` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `final_price` decimal(22,4) NOT NULL,
  `sub_unit_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mfg_recipes_product_id_index` (`product_id`),
  KEY `mfg_recipes_variation_id_index` (`variation_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `mfg_recipes` WRITE;
/*!40000 ALTER TABLE `mfg_recipes` DISABLE KEYS */;
/*!40000 ALTER TABLE `mfg_recipes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `migrations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(191) NOT NULL,
  `batch` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=400 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `migrations` WRITE;
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
INSERT INTO `migrations` VALUES (1,'2014_10_12_000000_create_users_table',1),(2,'2014_10_12_100000_create_password_resets_table',1),(3,'2016_06_01_000001_create_oauth_auth_codes_table',1),(4,'2016_06_01_000002_create_oauth_access_tokens_table',1),(5,'2016_06_01_000003_create_oauth_refresh_tokens_table',1),(6,'2016_06_01_000004_create_oauth_clients_table',1),(7,'2016_06_01_000005_create_oauth_personal_access_clients_table',1),(8,'2017_07_05_071953_create_currencies_table',1),(9,'2017_07_05_073658_create_business_table',1),(10,'2017_07_22_075923_add_business_id_users_table',1),(11,'2017_07_23_113209_create_brands_table',1),(12,'2017_07_26_083429_create_permission_tables',1),(13,'2017_07_26_110000_create_tax_rates_table',1),(14,'2017_07_26_122313_create_units_table',1),(15,'2017_07_27_075706_create_contacts_table',1),(16,'2017_08_04_071038_create_categories_table',1),(17,'2017_08_08_115903_create_products_table',1),(18,'2017_08_09_061616_create_variation_templates_table',1),(19,'2017_08_09_061638_create_variation_value_templates_table',1),(20,'2017_08_10_061146_create_product_variations_table',1),(21,'2017_08_10_061216_create_variations_table',1),(22,'2017_08_19_054827_create_transactions_table',1),(23,'2017_08_31_073533_create_purchase_lines_table',1),(24,'2017_10_15_064638_create_transaction_payments_table',1),(25,'2017_10_31_065621_add_default_sales_tax_to_business_table',1),(26,'2017_11_20_051930_create_table_group_sub_taxes',1),(27,'2017_11_20_063603_create_transaction_sell_lines',1),(28,'2017_11_21_064540_create_barcodes_table',1),(29,'2017_11_23_181237_create_invoice_schemes_table',1),(30,'2017_12_25_122822_create_business_locations_table',1),(31,'2017_12_25_160253_add_location_id_to_transactions_table',1),(32,'2017_12_25_163227_create_variation_location_details_table',1),(33,'2018_01_04_115627_create_sessions_table',1),(34,'2018_01_05_112817_create_invoice_layouts_table',1),(35,'2018_01_06_112303_add_invoice_scheme_id_and_invoice_layout_id_to_business_locations',1),(36,'2018_01_08_104124_create_expense_categories_table',1),(37,'2018_01_08_123327_modify_transactions_table_for_expenses',1),(38,'2018_01_09_111005_modify_payment_status_in_transactions_table',1),(39,'2018_01_09_111109_add_paid_on_column_to_transaction_payments_table',1),(40,'2018_01_25_172439_add_printer_related_fields_to_business_locations_table',1),(41,'2018_01_27_184322_create_printers_table',1),(42,'2018_01_30_181442_create_cash_registers_table',1),(43,'2018_01_31_125836_create_cash_register_transactions_table',1),(44,'2018_02_07_173326_modify_business_table',1),(45,'2018_02_08_105425_add_enable_product_expiry_column_to_business_table',1),(46,'2018_02_08_111027_add_expiry_period_and_expiry_period_type_columns_to_products_table',1),(47,'2018_02_08_131118_add_mfg_date_and_exp_date_purchase_lines_table',1),(48,'2018_02_08_155348_add_exchange_rate_to_transactions_table',1),(49,'2018_02_09_124945_modify_transaction_payments_table_for_contact_payments',1),(50,'2018_02_12_113640_create_transaction_sell_lines_purchase_lines_table',1),(51,'2018_02_12_114605_add_quantity_sold_in_purchase_lines_table',1),(52,'2018_02_13_183323_alter_decimal_fields_size',1),(53,'2018_02_14_161928_add_transaction_edit_days_to_business_table',1),(54,'2018_02_15_161032_add_document_column_to_transactions_table',1),(55,'2018_02_17_124709_add_more_options_to_invoice_layouts',1),(56,'2018_02_19_111517_add_keyboard_shortcut_column_to_business_table',1),(57,'2018_02_19_121537_stock_adjustment_move_to_transaction_table',1),(58,'2018_02_20_165505_add_is_direct_sale_column_to_transactions_table',1),(59,'2018_02_21_105329_create_system_table',1),(60,'2018_02_23_100549_version_1_2',1),(61,'2018_02_23_125648_add_enable_editing_sp_from_purchase_column_to_business_table',1),(62,'2018_02_26_103612_add_sales_commission_agent_column_to_business_table',1),(63,'2018_02_26_130519_modify_users_table_for_sales_cmmsn_agnt',1),(64,'2018_02_26_134500_add_commission_agent_to_transactions_table',1),(65,'2018_02_27_121422_add_item_addition_method_to_business_table',1),(66,'2018_02_27_170232_modify_transactions_table_for_stock_transfer',1),(67,'2018_03_05_153510_add_enable_inline_tax_column_to_business_table',1),(68,'2018_03_06_210206_modify_product_barcode_types',1),(69,'2018_03_13_181541_add_expiry_type_to_business_table',1),(70,'2018_03_16_113446_product_expiry_setting_for_business',1),(71,'2018_03_19_113601_add_business_settings_options',1),(72,'2018_03_26_125334_add_pos_settings_to_business_table',1),(73,'2018_03_26_165350_create_customer_groups_table',1),(74,'2018_03_27_122720_customer_group_related_changes_in_tables',1),(75,'2018_03_29_110138_change_tax_field_to_nullable_in_business_table',1),(76,'2018_03_29_115502_add_changes_for_sr_number_in_products_and_sale_lines_table',1),(77,'2018_03_29_134340_add_inline_discount_fields_in_purchase_lines',1),(78,'2018_03_31_140921_update_transactions_table_exchange_rate',1),(79,'2018_04_03_103037_add_contact_id_to_contacts_table',1),(80,'2018_04_03_122709_add_changes_to_invoice_layouts_table',1),(81,'2018_04_09_135320_change_exchage_rate_size_in_business_table',1),(82,'2018_04_17_123122_add_lot_number_to_business',1),(83,'2018_04_17_160845_add_product_racks_table',1),(84,'2018_04_20_182015_create_res_tables_table',1),(85,'2018_04_24_105246_restaurant_fields_in_transaction_table',1),(86,'2018_04_24_114149_add_enabled_modules_business_table',1),(87,'2018_04_24_133704_add_modules_fields_in_invoice_layout_table',1),(88,'2018_04_27_132653_quotation_related_change',1),(89,'2018_05_02_104439_add_date_format_and_time_format_to_business',1),(90,'2018_05_02_111939_add_sell_return_to_transaction_payments',1),(91,'2018_05_14_114027_add_rows_positions_for_products',1),(92,'2018_05_14_125223_add_weight_to_products_table',1),(93,'2018_05_14_164754_add_opening_stock_permission',1),(94,'2018_05_15_134729_add_design_to_invoice_layouts',1),(95,'2018_05_16_183307_add_tax_fields_invoice_layout',1),(96,'2018_05_18_191956_add_sell_return_to_transaction_table',1),(97,'2018_05_21_131349_add_custom_fileds_to_contacts_table',1),(98,'2018_05_21_131607_invoice_layout_fields_for_sell_return',1),(99,'2018_05_21_131949_add_custom_fileds_and_website_to_business_locations_table',1),(100,'2018_05_22_123527_create_reference_counts_table',1),(101,'2018_05_22_154540_add_ref_no_prefixes_column_to_business_table',1),(102,'2018_05_24_132620_add_ref_no_column_to_transaction_payments_table',1),(103,'2018_05_24_161026_add_location_id_column_to_business_location_table',1),(104,'2018_05_25_180603_create_modifiers_related_table',1),(105,'2018_05_29_121714_add_purchase_line_id_to_stock_adjustment_line_table',1),(106,'2018_05_31_114645_add_res_order_status_column_to_transactions_table',1),(107,'2018_06_05_103530_rename_purchase_line_id_in_stock_adjustment_lines_table',1),(108,'2018_06_05_111905_modify_products_table_for_modifiers',1),(109,'2018_06_06_110524_add_parent_sell_line_id_column_to_transaction_sell_lines_table',1),(110,'2018_06_07_152443_add_is_service_staff_to_roles_table',1),(111,'2018_06_07_182258_add_image_field_to_products_table',1),(112,'2018_06_13_133705_create_bookings_table',1),(113,'2018_06_15_173636_add_email_column_to_contacts_table',1),(114,'2018_06_27_182835_add_superadmin_related_fields_business',1),(115,'2018_07_10_101913_add_custom_fields_to_products_table',1),(116,'2018_07_17_103434_add_sales_person_name_label_to_invoice_layouts_table',1),(117,'2018_07_17_163920_add_theme_skin_color_column_to_business_table',1),(118,'2018_07_24_160319_add_lot_no_line_id_to_transaction_sell_lines_table',1),(119,'2018_07_25_110004_add_show_expiry_and_show_lot_colums_to_invoice_layouts_table',1),(120,'2018_07_25_172004_add_discount_columns_to_transaction_sell_lines_table',1),(121,'2018_07_26_124720_change_design_column_type_in_invoice_layouts_table',1),(122,'2018_07_26_170424_add_unit_price_before_discount_column_to_transaction_sell_line_table',1),(123,'2018_07_28_103614_add_credit_limit_column_to_contacts_table',1),(124,'2018_08_08_110755_add_new_payment_methods_to_transaction_payments_table',1),(125,'2018_08_08_122225_modify_cash_register_transactions_table_for_new_payment_methods',1),(126,'2018_08_14_104036_add_opening_balance_type_to_transactions_table',1),(127,'2018_09_04_155900_create_accounts_table',1),(128,'2018_09_06_114438_create_selling_price_groups_table',1),(129,'2018_09_06_154057_create_variation_group_prices_table',1),(130,'2018_09_07_102413_add_permission_to_access_default_selling_price',1),(131,'2018_09_07_134858_add_selling_price_group_id_to_transactions_table',1),(132,'2018_09_10_112448_update_product_type_to_single_if_null_in_products_table',1),(133,'2018_09_10_152703_create_account_transactions_table',1),(134,'2018_09_10_173656_add_account_id_column_to_transaction_payments_table',1),(135,'2018_09_19_123914_create_notification_templates_table',1),(136,'2018_09_22_110504_add_sms_and_email_settings_columns_to_business_table',1),(137,'2018_09_24_134942_add_lot_no_line_id_to_stock_adjustment_lines_table',1),(138,'2018_09_26_105557_add_transaction_payments_for_existing_expenses',1),(139,'2018_09_27_111609_modify_transactions_table_for_purchase_return',1),(140,'2018_09_27_131154_add_quantity_returned_column_to_purchase_lines_table',1),(141,'2018_10_02_131401_add_return_quantity_column_to_transaction_sell_lines_table',1),(142,'2018_10_03_104918_add_qty_returned_column_to_transaction_sell_lines_purchase_lines_table',1),(143,'2018_10_03_185947_add_default_notification_templates_to_database',1),(144,'2018_10_09_153105_add_business_id_to_transaction_payments_table',1),(145,'2018_10_16_135229_create_permission_for_sells_and_purchase',1),(146,'2018_10_22_114441_add_columns_for_variable_product_modifications',1),(147,'2018_10_22_134428_modify_variable_product_data',1),(148,'2018_10_30_181558_add_table_tax_headings_to_invoice_layout',1),(149,'2018_10_31_122619_add_pay_terms_field_transactions_table',1),(150,'2018_10_31_161328_add_new_permissions_for_pos_screen',1),(151,'2018_10_31_174752_add_access_selected_contacts_only_to_users_table',1),(152,'2018_10_31_175627_add_user_contact_access',1),(153,'2018_10_31_180559_add_auto_send_sms_column_to_notification_templates_table',1),(154,'2018_11_02_171949_change_card_type_column_to_varchar_in_transaction_payments_table',1),(155,'2018_11_08_105621_add_role_permissions',1),(156,'2018_11_26_114135_add_is_suspend_column_to_transactions_table',1),(157,'2018_11_28_104410_modify_units_table_for_multi_unit',1),(158,'2018_11_28_170952_add_sub_unit_id_to_purchase_lines_and_sell_lines',1),(159,'2018_11_29_115918_add_primary_key_in_system_table',1),(160,'2018_12_03_185546_add_product_description_column_to_products_table',1),(161,'2018_12_06_114937_modify_system_table_and_users_table',1),(162,'2018_12_13_160007_add_custom_fields_display_options_to_invoice_layouts_table',1),(163,'2018_12_14_103307_modify_system_table',1),(164,'2018_12_18_133837_add_prev_balance_due_columns_to_invoice_layouts_table',1),(165,'2018_12_18_170656_add_invoice_token_column_to_transaction_table',1),(166,'2018_12_20_133639_add_date_time_format_column_to_invoice_layouts_table',1),(167,'2018_12_21_120659_add_recurring_invoice_fields_to_transactions_table',1),(168,'2018_12_24_154933_create_notifications_table',1),(169,'2019_01_08_112015_add_document_column_to_transaction_payments_table',1),(170,'2019_01_10_124645_add_account_permission',1),(171,'2019_01_16_125825_add_subscription_no_column_to_transactions_table',1),(172,'2019_01_28_111647_add_order_addresses_column_to_transactions_table',1),(173,'2019_02_13_173821_add_is_inactive_column_to_products_table',1),(174,'2019_02_19_103118_create_discounts_table',1),(175,'2019_02_21_120324_add_discount_id_column_to_transaction_sell_lines_table',1),(176,'2019_02_21_134324_add_permission_for_discount',1),(177,'2019_03_04_170832_add_service_staff_columns_to_transaction_sell_lines_table',1),(178,'2019_03_09_102425_add_sub_type_column_to_transactions_table',1),(179,'2019_03_09_124457_add_indexing_transaction_sell_lines_purchase_lines_table',1),(180,'2019_03_12_120336_create_activity_log_table',1),(181,'2019_03_15_132925_create_media_table',1),(182,'2019_05_08_130339_add_indexing_to_parent_id_in_transaction_payments_table',1),(183,'2019_05_10_132311_add_missing_column_indexing',1),(184,'2019_05_14_091812_add_show_image_column_to_invoice_layouts_table',1),(185,'2019_05_25_104922_add_view_purchase_price_permission',1),(186,'2019_06_17_103515_add_profile_informations_columns_to_users_table',1),(187,'2019_06_18_135524_add_permission_to_view_own_sales_only',1),(188,'2019_06_19_112058_add_database_changes_for_reward_points',1),(189,'2019_06_28_133732_change_type_column_to_string_in_transactions_table',1),(190,'2019_07_13_111420_add_is_created_from_api_column_to_transactions_table',1),(191,'2019_07_15_165136_add_fields_for_combo_product',1),(192,'2019_07_19_103446_add_mfg_quantity_used_column_to_purchase_lines_table',1),(193,'2019_07_22_152649_add_not_for_selling_in_product_table',1),(194,'2019_07_29_185351_add_show_reward_point_column_to_invoice_layouts_table',1),(195,'2019_08_08_162302_add_sub_units_related_fields',1),(196,'2019_08_26_133419_update_price_fields_decimal_point',1),(197,'2019_09_02_160054_remove_location_permissions_from_roles',1),(198,'2019_09_03_185259_add_permission_for_pos_screen',1),(199,'2019_09_04_163141_add_location_id_to_cash_registers_table',1),(200,'2019_09_04_184008_create_types_of_services_table',1),(201,'2019_09_06_131445_add_types_of_service_fields_to_transactions_table',1),(202,'2019_09_09_134810_add_default_selling_price_group_id_column_to_business_locations_table',1),(203,'2019_09_12_105616_create_product_locations_table',1),(204,'2019_09_17_122522_add_custom_labels_column_to_business_table',1),(205,'2019_09_18_164319_add_shipping_fields_to_transactions_table',1),(206,'2019_09_19_170927_close_all_active_registers',1),(207,'2019_09_23_161906_add_media_description_cloumn_to_media_table',1),(208,'2019_10_18_155633_create_account_types_table',1),(209,'2019_10_22_163335_add_common_settings_column_to_business_table',1),(210,'2019_10_29_132521_add_update_purchase_status_permission',1),(211,'2019_11_09_110522_add_indexing_to_lot_number',1),(212,'2019_11_19_170824_add_is_active_column_to_business_locations_table',1),(213,'2019_11_21_162913_change_quantity_field_types_to_decimal',1),(214,'2019_11_25_160340_modify_categories_table_for_polymerphic_relationship',1),(215,'2019_12_02_105025_create_warranties_table',1),(216,'2019_12_03_180342_add_common_settings_field_to_invoice_layouts_table',1),(217,'2019_12_05_183955_add_more_fields_to_users_table',1),(218,'2019_12_06_174904_add_change_return_label_column_to_invoice_layouts_table',1),(219,'2019_12_11_121307_add_draft_and_quotation_list_permissions',1),(220,'2019_12_12_180126_copy_expense_total_to_total_before_tax',1),(221,'2019_12_19_181412_make_alert_quantity_field_nullable_on_products_table',1),(222,'2019_12_25_173413_create_dashboard_configurations_table',1),(223,'2020_01_08_133506_create_document_and_notes_table',1),(224,'2020_01_09_113252_add_cc_bcc_column_to_notification_templates_table',1),(225,'2020_01_16_174818_add_round_off_amount_field_to_transactions_table',1),(226,'2020_01_28_162345_add_weighing_scale_settings_in_business_settings_table',1),(227,'2020_02_18_172447_add_import_fields_to_transactions_table',1),(228,'2020_03_13_135844_add_is_active_column_to_selling_price_groups_table',1),(229,'2020_03_16_115449_add_contact_status_field_to_contacts_table',1),(230,'2020_03_26_124736_add_allow_login_column_in_users_table',1),(231,'2020_04_13_154150_add_feature_products_column_to_business_loactions',1),(232,'2020_04_15_151802_add_user_type_to_users_table',1),(233,'2020_04_22_153905_add_subscription_repeat_on_column_to_transactions_table',1),(234,'2020_04_28_111436_add_shipping_address_to_contacts_table',1),(235,'2020_06_01_094654_add_max_sale_discount_column_to_users_table',1),(236,'2020_06_12_162245_modify_contacts_table',1),(237,'2020_06_22_103104_change_recur_interval_default_to_one',1),(238,'2020_07_09_174621_add_balance_field_to_contacts_table',1),(239,'2020_07_23_104933_change_status_column_to_varchar_in_transaction_table',1),(240,'2020_09_07_171059_change_completed_stock_transfer_status_to_final',1),(241,'2020_09_21_123224_modify_booking_status_column_in_bookings_table',1),(242,'2020_09_22_121639_create_discount_variations_table',1),(243,'2020_10_05_121550_modify_business_location_table_for_invoice_layout',1),(244,'2020_10_16_175726_set_status_as_received_for_opening_stock',1),(245,'2020_10_23_170823_add_for_group_tax_column_to_tax_rates_table',1),(246,'2020_11_04_130940_add_more_custom_fields_to_contacts_table',1),(247,'2020_11_10_152841_add_cash_register_permissions',1),(248,'2020_11_17_164041_modify_type_column_to_varchar_in_contacts_table',1),(249,'2020_12_18_181447_add_shipping_custom_fields_to_transactions_table',1),(250,'2020_12_22_164303_add_sub_status_column_to_transactions_table',1),(251,'2020_12_24_153050_add_custom_fields_to_transactions_table',1),(252,'2020_12_28_105403_add_whatsapp_text_column_to_notification_templates_table',1),(253,'2020_12_29_165925_add_model_document_type_to_media_table',1),(254,'2021_02_08_175632_add_contact_number_fields_to_users_table',1),(255,'2021_02_11_172217_add_indexing_for_multiple_columns',1),(256,'2021_02_23_122043_add_more_columns_to_customer_groups_table',1),(257,'2021_02_24_175551_add_print_invoice_permission_to_all_roles',1),(258,'2021_03_03_162021_add_purchase_order_columns_to_purchase_lines_and_transactions_table',1),(259,'2021_03_11_120229_add_sales_order_columns',1),(260,'2021_03_16_120705_add_business_id_to_activity_log_table',1),(261,'2021_03_16_153427_add_code_columns_to_business_table',1),(262,'2021_03_18_173308_add_account_details_column_to_accounts_table',1),(263,'2021_03_18_183119_add_prefer_payment_account_columns_to_transactions_table',1),(264,'2021_03_22_120810_add_more_types_of_service_custom_fields',1),(265,'2021_03_24_183132_add_shipping_export_custom_field_details_to_contacts_table',1),(266,'2021_03_25_170715_add_export_custom_fields_info_to_transactions_table',1),(267,'2021_04_15_063449_add_denominations_column_to_cash_registers_table',1),(268,'2021_05_22_083426_add_indexing_to_account_transactions_table',1),(269,'2021_07_08_065808_add_additional_expense_columns_to_transaction_table',1),(270,'2021_07_13_082918_add_qr_code_columns_to_invoice_layouts_table',1),(271,'2021_07_21_061615_add_fields_to_show_commission_agent_in_invoice_layout',1),(272,'2021_08_13_105549_add_crm_contact_id_to_users_table',1),(273,'2021_08_25_114932_add_payment_link_fields_to_transaction_payments_table',1),(274,'2021_09_01_063110_add_spg_column_to_discounts_table',1),(275,'2021_09_03_061528_modify_cash_register_transactions_table',1),(276,'2021_10_05_061658_add_source_column_to_transactions_table',1),(277,'2021_12_16_121851_add_parent_id_column_to_expense_categories_table',1),(278,'2022_04_14_075120_add_payment_type_column_to_transaction_payments_table',1),(279,'2022_04_21_083327_create_cash_denominations_table',1),(280,'2022_05_10_055307_add_delivery_date_column_to_transactions_table',1),(281,'2022_06_13_123135_add_currency_precision_and_quantity_precision_fields_to_business_table',1),(282,'2022_06_28_133342_add_secondary_unit_columns_to_products_sell_line_purchase_lines_tables',1),(283,'2022_07_13_114307_create_purchase_requisition_related_columns',1),(284,'2022_08_25_132707_add_service_staff_timer_fields_to_products_and_users_table',1),(285,'2023_01_28_114255_add_letter_head_column_to_invoice_layouts_table',1),(286,'2023_02_11_161510_add_event_column_to_activity_log_table',1),(287,'2023_02_11_161511_add_batch_uuid_column_to_activity_log_table',1),(288,'2023_03_02_170312_add_provider_to_oauth_clients_table',1),(289,'2023_03_21_122731_add_sale_invoice_scheme_id_business_table',1),(290,'2023_03_21_170446_add_number_type_to_invoice_scheme',1),(291,'2023_04_17_155216_add_custom_fields_to_products',1),(292,'2023_04_28_130247_add_price_type_to_group_price_table',1),(293,'2023_06_21_033923_add_delivery_person_in_transactions',1),(294,'2023_09_13_153555_add_service_staff_pin_columns_in_users',1),(295,'2023_09_15_154404_add_is_kitchen_order_in_transactions',1),(296,'2023_12_06_152840_add_contact_type_in_contacts',1),(299,'2024_10_27_202427_add_multiunit_fields_to_products_table',2),(300,'2024_10_27_202522_add_sell_unit_id_column_to_transaction_sell_lines_table',2),(301,'2024_10_27_204557_add_changes_to_invoice_layouts_table',3),(302,'2024_10_27_204624_add_multi_unit_fields_to_variations_table',3),(303,'2024_10_28_134436_add_inline_discount_in_purchase_lines_table',4),(304,'2024_10_29_091611_add_multi_unit_column_to_stock_adjustment_lines_table',5),(305,'2024_07_31_215407_add_enable_serial_number_field_to_products_table',6),(306,'2024_07_31_215536_create_serial_numbers_table',6),(307,'2024_07_31_220505_add_enable_serial_number_field_to_purchase_lines_table',6),(308,'2024_07_31_221130_create_service_warranties_table',6),(309,'2022_10_31_115725_create_accounting_account_types_table',7),(310,'2022_11_01_104108_create_accounting_accounts_table',7),(311,'2022_11_10_135427_create_accounts_transactions_table',7),(312,'2022_11_14_171948_create_accounting_acc_trans_mapping',7),(313,'2022_12_02_133536_create_accounting_budgets_table',7),(314,'2022_12_19_124743_add_accounting_settings_column_to_business_table',7),(315,'2022_12_26_182821_AddAccountingModuleVersionToSystemTable',7),(316,'2023_05_25_131005_add_default_map_transactions_fields',7),(317,'2020_03_19_130231_add_contact_id_to_users_table',8),(318,'2020_03_27_133605_create_schedules_table',8),(319,'2020_03_27_133628_create_schedule_users_table',8),(320,'2020_03_30_112834_create_schedule_logs_table',8),(321,'2020_04_02_182331_add_crm_module_version_to_system_table',8),(322,'2020_04_08_153231_modify_cloumn_in_contacts_table',8),(323,'2020_04_09_101052_create_lead_users_table',8),(324,'2020_04_16_114747_create_crm_campaigns_table',8),(325,'2021_01_07_155757_add_followup_additional_info_column_to_crm_schedules_table',8),(326,'2021_02_02_140021_add_additional_info_to_crm_campaigns_table',8),(327,'2021_02_02_173651_add_new_columns_to_contacts_table',8),(328,'2021_02_04_120439_create_call_logs_table',8),(329,'2021_02_08_172047_add_mobile_name_column_to_crm_call_logs_table',8),(330,'2021_02_16_190038_add_crm_module_indexing',8),(331,'2021_02_19_120846_create_crm_followup_invoices',8),(332,'2021_02_22_132125_add_follow_up_by_to_crm_schedules_table',8),(333,'2021_03_24_160736_add_department_and_designation_to_users_table',8),(334,'2021_06_15_152924_create_proposal_templates_table',8),(335,'2021_06_16_114448_add_recursive_fields_to_crm_schedules_table',8),(336,'2021_06_16_125740_create_proposals_table',8),(337,'2021_09_24_065738_add_crm_settings_column_to_business_table',8),(338,'2022_02_09_055012_create_crm_marketplaces_table',8),(339,'2022_02_17_113045_add_source_id_to_marketplace',8),(340,'2022_03_02_180929_add_followup_category_id',8),(341,'2022_05_26_061553_create_crm_contact_person_commissions_table',8),(342,'2022_06_06_073006_add_cc_and_bcc_columns_to_crm_proposals_table',8),(343,'2018_10_01_151252_create_documents_table',9),(344,'2018_10_02_151803_create_document_shares_table',9),(345,'2018_10_09_134558_create_reminders_table',9),(346,'2018_11_16_170756_create_to_dos_table',9),(347,'2019_02_22_120329_essentials_messages',9),(348,'2019_02_22_161513_add_message_permissions',9),(349,'2019_03_29_164339_add_essentials_version_to_system_table',9),(350,'2019_05_17_153306_create_essentials_leave_types_table',9),(351,'2019_05_17_175921_create_essentials_leaves_table',9),(352,'2019_05_21_154517_add_essentials_settings_columns_to_business_table',9),(353,'2019_05_21_181653_create_table_essentials_attendance',9),(354,'2019_05_30_110049_create_essentials_payrolls_table',9),(355,'2019_06_04_105723_create_essentials_holidays_table',9),(356,'2019_06_28_134217_add_payroll_columns_to_transactions_table',9),(357,'2019_07_15_114211_add_manufacturing_module_version_to_system_table',9),(358,'2019_07_15_114403_create_mfg_recipes_table',9),(359,'2019_07_18_180217_add_production_columns_to_transactions_table',9),(360,'2019_07_26_110753_add_manufacturing_settings_column_to_business_table',9),(361,'2019_07_26_170450_add_manufacturing_permissions',9),(362,'2019_08_08_110035_create_mfg_recipe_ingredients_table',9),(363,'2019_08_08_172837_add_recipe_add_edit_permissions',9),(364,'2019_08_12_114610_add_ingredient_waste_percent_columns',9),(365,'2019_08_26_103520_add_approve_leave_permission',9),(366,'2019_08_27_103724_create_essentials_allowance_and_deduction_table',9),(367,'2019_08_27_105236_create_essentials_user_allowances_and_deductions',9),(368,'2019_09_20_115906_add_more_columns_to_essentials_to_dos_table',9),(369,'2019_09_23_120439_create_essentials_todo_comments_table',9),(370,'2019_11_05_115136_create_ingredient_groups_table',9),(371,'2019_12_05_170724_add_hrm_columns_to_users_table',9),(372,'2019_12_09_105809_add_allowance_and_deductions_permission',9),(373,'2020_02_22_120303_add_column_to_mfg_recipe_ingredients_table',9),(374,'2020_03_28_152838_create_essentials_shift_table',9),(375,'2020_03_30_162029_create_user_shifts_table',9),(376,'2020_03_31_134558_add_shift_id_to_attendance_table',9),(377,'2020_08_19_103831_add_production_cost_type_to_recipe_and_transaction_table',9),(378,'2020_08_19_175842_add_asset_management_module_version_to_system_table',9),(379,'2020_08_20_114339_create_assets_table',9),(380,'2020_08_20_173031_create_asset_transactions_table',9),(381,'2020_08_21_180138_add_asset_settings_column_to_business_table',9),(382,'2020_11_05_105157_modify_todos_date_column_type',9),(383,'2020_11_11_174852_add_end_time_column_to_essentials_reminders_table',9),(384,'2020_11_26_170527_create_essentials_kb_table',9),(385,'2020_11_30_112615_create_essentials_kb_users_table',9),(386,'2021_02_12_185514_add_clock_in_location_to_essentials_attendances_table',9),(387,'2021_02_16_190203_add_essentials_module_indexing',9),(388,'2021_02_16_190302_add_manufacturing_module_indexing',9),(389,'2021_02_27_133448_add_columns_to_users_table',9),(390,'2021_03_04_174857_create_payroll_groups_table',9),(391,'2021_03_04_175025_create_payroll_group_transactions_table',9),(392,'2021_03_09_123914_add_auto_clockout_to_essentials_shifts',9),(393,'2021_04_07_154331_add_mfg_ingredient_group_id_to_transaction_sell_lines_table',9),(394,'2021_06_17_121451_add_location_id_to_table',9),(395,'2021_09_28_091541_create_essentials_user_sales_targets_table',9),(396,'2021_10_29_110841_create_asset_warranties_table',9),(397,'2022_03_26_062215_create_asset_maintenances_table',9),(398,'2022_05_11_070711_add_maintenance_note_column_to_asset_maintenances_table',9),(399,'2024_11_03_102559_add_discount_id_field_to_products_table',9);
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `model_has_permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `model_has_permissions` (
  `permission_id` int(10) unsigned NOT NULL,
  `model_type` varchar(191) NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`model_id`,`model_type`),
  KEY `model_has_permissions_model_type_model_id_index` (`model_type`,`model_id`),
  CONSTRAINT `model_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `model_has_permissions` WRITE;
/*!40000 ALTER TABLE `model_has_permissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `model_has_permissions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `model_has_roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `model_has_roles` (
  `role_id` int(10) unsigned NOT NULL,
  `model_type` varchar(191) NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`role_id`,`model_id`,`model_type`),
  KEY `model_has_roles_model_type_model_id_index` (`model_type`,`model_id`),
  CONSTRAINT `model_has_roles_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `model_has_roles` WRITE;
/*!40000 ALTER TABLE `model_has_roles` DISABLE KEYS */;
INSERT INTO `model_has_roles` VALUES (1,'App\\User',1);
/*!40000 ALTER TABLE `model_has_roles` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `notification_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `notification_templates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `template_for` varchar(191) NOT NULL,
  `email_body` text DEFAULT NULL,
  `sms_body` text DEFAULT NULL,
  `whatsapp_text` text DEFAULT NULL,
  `subject` varchar(191) DEFAULT NULL,
  `cc` varchar(191) DEFAULT NULL,
  `bcc` varchar(191) DEFAULT NULL,
  `auto_send` tinyint(1) NOT NULL DEFAULT 0,
  `auto_send_sms` tinyint(1) NOT NULL DEFAULT 0,
  `auto_send_wa_notif` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `notification_templates` WRITE;
/*!40000 ALTER TABLE `notification_templates` DISABLE KEYS */;
INSERT INTO `notification_templates` VALUES (1,1,'new_sale','<p>Dear {contact_name},</p>\n\n                    <p>Your invoice number is {invoice_number}<br />\n                    Total amount: {total_amount}<br />\n                    Paid amount: {received_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2024-10-25 16:39:24','2024-10-25 16:39:24'),(2,1,'payment_received','<p>Dear {contact_name},</p>\n\n                <p>We have received a payment of {received_amount}</p>\n\n                <p>{business_logo}</p>','Dear {contact_name}, We have received a payment of {received_amount}. {business_name}',NULL,'Payment Received, from {business_name}',NULL,NULL,0,0,0,'2024-10-25 16:39:24','2024-10-25 16:39:24'),(3,1,'payment_reminder','<p>Dear {contact_name},</p>\n\n                    <p>This is to remind you that you have pending payment of {due_amount}. Kindly pay it as soon as possible.</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, You have pending payment of {due_amount}. Kindly pay it as soon as possible. {business_name}',NULL,'Payment Reminder, from {business_name}',NULL,NULL,0,0,0,'2024-10-25 16:39:24','2024-10-25 16:39:24'),(4,1,'new_booking','<p>Dear {contact_name},</p>\n\n                    <p>Your booking is confirmed</p>\n\n                    <p>Date: {start_time} to {end_time}</p>\n\n                    <p>Table: {table}</p>\n\n                    <p>Location: {location}</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, Your booking is confirmed. Date: {start_time} to {end_time}, Table: {table}, Location: {location}',NULL,'Booking Confirmed - {business_name}',NULL,NULL,0,0,0,'2024-10-25 16:39:24','2024-10-25 16:39:24'),(5,1,'new_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','Dear {contact_name}, We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible. {business_name}',NULL,'New Order, from {business_name}',NULL,NULL,0,0,0,'2024-10-25 16:39:24','2024-10-25 16:39:24'),(6,1,'payment_paid','<p>Dear {contact_name},</p>\n\n                    <p>We have paid amount {paid_amount} again invoice number {order_ref_number}.<br />\n                    Kindly note it down.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have paid amount {paid_amount} again invoice number {order_ref_number}.\n                    Kindly note it down. {business_name}',NULL,'Payment Paid, from {business_name}',NULL,NULL,0,0,0,'2024-10-25 16:39:24','2024-10-25 16:39:24'),(7,1,'items_received','<p>Dear {contact_name},</p>\n\n                    <p>We have received all items from invoice reference number {order_ref_number}. Thank you for processing it.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have received all items from invoice reference number {order_ref_number}. Thank you for processing it. {business_name}',NULL,'Items received, from {business_name}',NULL,NULL,0,0,0,'2024-10-25 16:39:24','2024-10-25 16:39:24'),(8,1,'items_pending','<p>Dear {contact_name},<br />\n                    This is to remind you that we have not yet received some items from invoice reference number {order_ref_number}. Please process it as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','This is to remind you that we have not yet received some items from invoice reference number {order_ref_number} . Please process it as soon as possible.{business_name}',NULL,'Items Pending, from {business_name}',NULL,NULL,0,0,0,'2024-10-25 16:39:24','2024-10-25 16:39:24'),(9,1,'new_quotation','<p>Dear {contact_name},</p>\n\n                    <p>Your quotation number is {invoice_number}<br />\n                    Total amount: {total_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2024-10-25 16:39:24','2024-10-25 16:39:24'),(10,1,'purchase_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new purchase order with reference number {order_ref_number}. The respective invoice is attached here with.</p>\n\n                    <p>{business_logo}</p>','We have a new purchase order with reference number {order_ref_number}. {business_name}',NULL,'New Purchase Order, from {business_name}',NULL,NULL,0,0,0,'2024-10-25 16:39:24','2024-10-25 16:39:24');
/*!40000 ALTER TABLE `notification_templates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `notifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `notifications` (
  `id` char(36) NOT NULL,
  `type` varchar(191) NOT NULL,
  `notifiable_type` varchar(191) NOT NULL,
  `notifiable_id` bigint(20) unsigned NOT NULL,
  `data` text NOT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `notifications_notifiable_type_notifiable_id_index` (`notifiable_type`,`notifiable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `notifications` WRITE;
/*!40000 ALTER TABLE `notifications` DISABLE KEYS */;
/*!40000 ALTER TABLE `notifications` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_access_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oauth_access_tokens` (
  `id` varchar(100) NOT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `client_id` int(10) unsigned NOT NULL,
  `name` varchar(191) DEFAULT NULL,
  `scopes` text DEFAULT NULL,
  `revoked` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_access_tokens_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_access_tokens` WRITE;
/*!40000 ALTER TABLE `oauth_access_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_access_tokens` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_auth_codes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oauth_auth_codes` (
  `id` varchar(100) NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `client_id` int(10) unsigned NOT NULL,
  `scopes` text DEFAULT NULL,
  `revoked` tinyint(1) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_auth_codes` WRITE;
/*!40000 ALTER TABLE `oauth_auth_codes` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_auth_codes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_clients`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oauth_clients` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) DEFAULT NULL,
  `name` varchar(191) NOT NULL,
  `secret` varchar(100) NOT NULL,
  `provider` varchar(191) DEFAULT NULL,
  `redirect` text NOT NULL,
  `personal_access_client` tinyint(1) NOT NULL,
  `password_client` tinyint(1) NOT NULL,
  `revoked` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_clients_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_clients` WRITE;
/*!40000 ALTER TABLE `oauth_clients` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_clients` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_personal_access_clients`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oauth_personal_access_clients` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `client_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_personal_access_clients_client_id_index` (`client_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_personal_access_clients` WRITE;
/*!40000 ALTER TABLE `oauth_personal_access_clients` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_personal_access_clients` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_refresh_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oauth_refresh_tokens` (
  `id` varchar(100) NOT NULL,
  `access_token_id` varchar(100) NOT NULL,
  `revoked` tinyint(1) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_refresh_tokens_access_token_id_index` (`access_token_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_refresh_tokens` WRITE;
/*!40000 ALTER TABLE `oauth_refresh_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_refresh_tokens` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `password_resets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `password_resets` (
  `email` varchar(191) NOT NULL,
  `token` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `password_resets_email_index` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `password_resets` WRITE;
/*!40000 ALTER TABLE `password_resets` DISABLE KEYS */;
/*!40000 ALTER TABLE `password_resets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `permissions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `guard_name` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=99 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `permissions` WRITE;
/*!40000 ALTER TABLE `permissions` DISABLE KEYS */;
INSERT INTO `permissions` VALUES (1,'profit_loss_report.view','web','2024-10-25 16:35:19',NULL),(2,'direct_sell.access','web','2024-10-25 16:35:19',NULL),(3,'product.opening_stock','web','2024-10-25 16:35:22','2024-10-25 16:35:22'),(4,'crud_all_bookings','web','2024-10-25 16:35:23','2024-10-25 16:35:23'),(5,'crud_own_bookings','web','2024-10-25 16:35:23','2024-10-25 16:35:23'),(6,'access_default_selling_price','web','2024-10-25 16:35:24','2024-10-25 16:35:24'),(7,'purchase.payments','web','2024-10-25 16:35:24','2024-10-25 16:35:24'),(8,'sell.payments','web','2024-10-25 16:35:24','2024-10-25 16:35:24'),(9,'edit_product_price_from_sale_screen','web','2024-10-25 16:35:25','2024-10-25 16:35:25'),(10,'edit_product_discount_from_sale_screen','web','2024-10-25 16:35:25','2024-10-25 16:35:25'),(11,'roles.view','web','2024-10-25 16:35:25','2024-10-25 16:35:25'),(12,'roles.create','web','2024-10-25 16:35:25','2024-10-25 16:35:25'),(13,'roles.update','web','2024-10-25 16:35:25','2024-10-25 16:35:25'),(14,'roles.delete','web','2024-10-25 16:35:25','2024-10-25 16:35:25'),(15,'account.access','web','2024-10-25 16:35:25','2024-10-25 16:35:25'),(16,'discount.access','web','2024-10-25 16:35:26','2024-10-25 16:35:26'),(17,'view_purchase_price','web','2024-10-25 16:35:26','2024-10-25 16:35:26'),(18,'view_own_sell_only','web','2024-10-25 16:35:26','2024-10-25 16:35:26'),(19,'edit_product_discount_from_pos_screen','web','2024-10-25 16:35:27','2024-10-25 16:35:27'),(20,'edit_product_price_from_pos_screen','web','2024-10-25 16:35:27','2024-10-25 16:35:27'),(21,'access_shipping','web','2024-10-25 16:35:28','2024-10-25 16:35:28'),(22,'purchase.update_status','web','2024-10-25 16:35:28','2024-10-25 16:35:28'),(23,'list_drafts','web','2024-10-25 16:35:29','2024-10-25 16:35:29'),(24,'list_quotations','web','2024-10-25 16:35:29','2024-10-25 16:35:29'),(25,'view_cash_register','web','2024-10-25 16:35:31','2024-10-25 16:35:31'),(26,'close_cash_register','web','2024-10-25 16:35:31','2024-10-25 16:35:31'),(27,'print_invoice','web','2024-10-25 16:35:33','2024-10-25 16:35:33'),(28,'user.view','web','2024-10-25 16:35:35',NULL),(29,'user.create','web','2024-10-25 16:35:35',NULL),(30,'user.update','web','2024-10-25 16:35:35',NULL),(31,'user.delete','web','2024-10-25 16:35:35',NULL),(32,'supplier.view','web','2024-10-25 16:35:35',NULL),(33,'supplier.create','web','2024-10-25 16:35:35',NULL),(34,'supplier.update','web','2024-10-25 16:35:35',NULL),(35,'supplier.delete','web','2024-10-25 16:35:35',NULL),(36,'customer.view','web','2024-10-25 16:35:35',NULL),(37,'customer.create','web','2024-10-25 16:35:35',NULL),(38,'customer.update','web','2024-10-25 16:35:35',NULL),(39,'customer.delete','web','2024-10-25 16:35:35',NULL),(40,'product.view','web','2024-10-25 16:35:35',NULL),(41,'product.create','web','2024-10-25 16:35:35',NULL),(42,'product.update','web','2024-10-25 16:35:35',NULL),(43,'product.delete','web','2024-10-25 16:35:35',NULL),(44,'purchase.view','web','2024-10-25 16:35:35',NULL),(45,'purchase.create','web','2024-10-25 16:35:35',NULL),(46,'purchase.update','web','2024-10-25 16:35:35',NULL),(47,'purchase.delete','web','2024-10-25 16:35:35',NULL),(48,'sell.view','web','2024-10-25 16:35:35',NULL),(49,'sell.create','web','2024-10-25 16:35:35',NULL),(50,'sell.update','web','2024-10-25 16:35:35',NULL),(51,'sell.delete','web','2024-10-25 16:35:35',NULL),(52,'purchase_n_sell_report.view','web','2024-10-25 16:35:35',NULL),(53,'contacts_report.view','web','2024-10-25 16:35:35',NULL),(54,'stock_report.view','web','2024-10-25 16:35:35',NULL),(55,'tax_report.view','web','2024-10-25 16:35:35',NULL),(56,'trending_product_report.view','web','2024-10-25 16:35:35',NULL),(57,'register_report.view','web','2024-10-25 16:35:35',NULL),(58,'sales_representative.view','web','2024-10-25 16:35:35',NULL),(59,'expense_report.view','web','2024-10-25 16:35:35',NULL),(60,'business_settings.access','web','2024-10-25 16:35:35',NULL),(61,'barcode_settings.access','web','2024-10-25 16:35:35',NULL),(62,'invoice_settings.access','web','2024-10-25 16:35:35',NULL),(63,'brand.view','web','2024-10-25 16:35:35',NULL),(64,'brand.create','web','2024-10-25 16:35:35',NULL),(65,'brand.update','web','2024-10-25 16:35:35',NULL),(66,'brand.delete','web','2024-10-25 16:35:35',NULL),(67,'tax_rate.view','web','2024-10-25 16:35:35',NULL),(68,'tax_rate.create','web','2024-10-25 16:35:35',NULL),(69,'tax_rate.update','web','2024-10-25 16:35:35',NULL),(70,'tax_rate.delete','web','2024-10-25 16:35:35',NULL),(71,'unit.view','web','2024-10-25 16:35:35',NULL),(72,'unit.create','web','2024-10-25 16:35:35',NULL),(73,'unit.update','web','2024-10-25 16:35:35',NULL),(74,'unit.delete','web','2024-10-25 16:35:35',NULL),(75,'category.view','web','2024-10-25 16:35:35',NULL),(76,'category.create','web','2024-10-25 16:35:35',NULL),(77,'category.update','web','2024-10-25 16:35:35',NULL),(78,'category.delete','web','2024-10-25 16:35:35',NULL),(79,'expense.access','web','2024-10-25 16:35:35',NULL),(80,'access_all_locations','web','2024-10-25 16:35:35',NULL),(81,'dashboard.data','web','2024-10-25 16:35:35',NULL),(82,'location.1','web','2024-10-25 16:39:24','2024-10-25 16:39:24'),(83,'location.2','web','2024-10-29 03:26:47','2024-10-29 03:26:47'),(84,'essentials.create_message','web','2024-11-03 04:26:40','2024-11-03 04:26:40'),(85,'essentials.view_message','web','2024-11-03 04:26:40','2024-11-03 04:26:40'),(86,'manufacturing.access_recipe','web','2024-11-03 04:26:41','2024-11-03 04:26:41'),(87,'manufacturing.access_production','web','2024-11-03 04:26:41','2024-11-03 04:26:41'),(88,'manufacturing.add_recipe','web','2024-11-03 04:26:41','2024-11-03 04:26:41'),(89,'manufacturing.edit_recipe','web','2024-11-03 04:26:41','2024-11-03 04:26:41'),(90,'essentials.approve_leave','web','2024-11-03 04:26:41','2024-11-03 04:26:41'),(91,'essentials.assign_todos','web','2024-11-03 04:26:41','2024-11-03 04:26:41'),(92,'essentials.add_allowance_and_deduction','web','2024-11-03 04:26:41','2024-11-03 04:26:41'),(93,'selling_price_group.1','web','2024-11-03 04:45:06','2024-11-03 04:45:06'),(94,'selling_price_group.2','web','2024-11-03 05:29:42','2024-11-03 05:29:42'),(95,'selling_price_group.5','web','2024-11-25 02:58:18','2024-11-25 02:58:18'),(96,'selling_price_group.6','web','2024-11-25 02:58:45','2024-11-25 02:58:45'),(97,'selling_price_group.7','web','2024-11-25 02:58:58','2024-11-25 02:58:58'),(98,'selling_price_group.8','web','2024-11-25 02:59:07','2024-11-25 02:59:07');
/*!40000 ALTER TABLE `permissions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `printers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `printers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `category_id` int(11) DEFAULT NULL,
  `name` varchar(191) NOT NULL,
  `connection_type` enum('network','windows','linux') NOT NULL,
  `capability_profile` enum('default','simple','SP2000','TEP-200M','P822D') NOT NULL DEFAULT 'default',
  `char_per_line` varchar(191) DEFAULT NULL,
  `ip_address` varchar(191) DEFAULT NULL,
  `port` varchar(191) DEFAULT NULL,
  `path` varchar(191) DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `printers_business_id_foreign` (`business_id`),
  CONSTRAINT `printers_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `printers` WRITE;
/*!40000 ALTER TABLE `printers` DISABLE KEYS */;
/*!40000 ALTER TABLE `printers` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `product_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_locations` (
  `product_id` int(11) NOT NULL,
  `location_id` int(11) NOT NULL,
  KEY `product_locations_product_id_index` (`product_id`),
  KEY `product_locations_location_id_index` (`location_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `product_locations` WRITE;
/*!40000 ALTER TABLE `product_locations` DISABLE KEYS */;
INSERT INTO `product_locations` VALUES (2,1),(3,1),(4,1),(5,1),(6,1),(9,1),(10,1),(11,1),(12,1),(13,1),(14,1),(15,1),(16,1),(17,1),(18,1),(19,1),(20,1),(21,1),(22,1),(23,1),(24,1),(25,1),(26,1),(27,1),(28,1),(29,1),(30,1),(31,1),(32,1),(33,1),(34,1),(35,1),(36,1),(37,1),(38,1),(39,1),(40,1),(41,1),(42,1),(43,1),(44,1),(46,1),(47,1),(49,1),(50,1),(51,1),(52,1),(53,1),(55,1),(57,1),(58,1),(59,1),(60,1),(61,1),(62,1),(63,1),(64,1),(65,1),(66,1),(67,1),(68,1),(69,1),(70,1),(71,1),(72,1),(73,1),(74,1),(75,1),(77,1),(78,1),(79,1),(80,1),(81,1),(83,1),(84,1),(85,1),(86,1),(87,1),(88,1),(89,1),(90,1),(91,1),(92,1),(94,1),(95,1),(96,1),(97,1),(98,1),(99,1),(100,1),(101,1),(102,1),(103,1),(104,1),(105,1),(106,1),(107,1),(108,1),(109,1),(110,1),(111,1),(112,1),(113,1),(114,1),(115,1),(116,1),(117,1),(118,1),(120,1),(121,1),(122,1),(123,1),(124,1),(125,1),(127,1),(128,1),(129,1),(130,1),(131,1),(132,1),(133,1),(134,1),(135,1),(136,1),(137,1),(138,1),(139,1),(140,1),(141,1),(142,1),(143,1),(144,1),(145,1),(147,1),(148,1),(149,1),(150,1),(151,1),(152,1),(153,1),(154,1),(155,1),(156,1),(157,1),(158,1),(159,1),(160,1),(161,1),(162,1),(163,1),(164,1),(165,1),(166,1),(167,1),(168,1),(169,1),(170,1),(171,1),(172,1),(173,1),(174,1),(175,1),(176,1),(177,1),(178,1),(179,1),(180,1),(181,1),(182,1),(183,1),(184,1),(185,1),(186,1),(187,1),(188,1),(189,1),(190,1),(191,1),(192,1),(193,1),(194,1),(195,1),(196,1),(197,1),(198,1),(199,1),(200,1),(201,1),(203,1),(204,1),(205,1),(206,1),(207,1),(209,1),(210,1),(211,1),(212,1),(213,1),(214,1),(215,1),(216,1),(217,1),(218,1),(219,1),(220,1),(221,1),(222,1),(223,1),(224,1),(225,1),(226,1),(227,1),(228,1),(229,1),(230,1),(231,1),(232,1),(233,1),(234,1),(235,1),(236,1),(237,1),(238,1),(239,1),(240,1),(241,1),(242,1),(243,1),(244,1),(245,1),(246,1),(247,1),(248,1),(249,1),(250,1),(251,1),(252,1),(253,1),(254,1),(255,1),(256,1),(257,1),(259,1),(260,1),(261,1),(262,1),(263,1),(264,1),(265,1),(266,1),(267,1),(268,1),(269,1),(270,1),(271,1),(272,1),(273,1),(274,1),(275,1),(276,1),(277,1),(278,1),(279,1),(280,1),(281,1),(282,1),(283,1),(284,1),(285,1),(286,1),(287,1),(288,1),(289,1),(290,1),(291,1),(292,1),(293,1),(294,1),(295,1),(296,1),(297,1),(298,1),(299,1),(300,1),(301,1),(302,1),(303,1),(304,1),(305,1),(306,1),(307,1),(308,1),(309,1),(310,1),(311,1),(312,1),(313,1),(314,1),(315,1),(316,1),(317,1),(319,1),(320,1),(321,1),(322,1),(323,1),(324,1),(325,1),(326,1),(327,1),(328,1),(329,1),(330,1),(331,1),(332,1),(333,1),(334,1),(335,1),(336,1),(337,1),(338,1),(339,1),(340,1),(341,1),(342,1),(343,1),(344,1),(345,1),(346,1),(347,1),(348,1),(349,1),(350,1),(351,1),(352,1),(353,1),(354,1),(355,1),(356,1),(357,1),(358,1),(359,1),(360,1),(361,1),(362,1),(363,1),(364,1),(365,1),(366,1),(368,1),(369,1),(370,1),(371,1),(372,1),(373,1),(374,1),(375,1),(376,1),(377,1),(378,1),(379,1),(380,1),(381,1),(382,1),(384,1),(385,1),(386,1),(387,1),(388,1),(389,1),(390,1),(391,1),(392,1),(393,1),(394,1),(395,1),(396,1),(397,1),(398,1),(399,1),(401,1),(402,1),(403,1),(404,1),(405,1),(406,1),(407,1),(409,1),(410,1),(411,1),(412,1),(413,1),(414,1),(415,1),(416,1),(417,1),(418,1),(419,1),(420,1),(421,1),(422,1),(423,1),(424,1),(425,1),(426,1),(427,1),(428,1),(429,1),(430,1),(431,1),(432,1),(433,1),(434,1),(436,1),(437,1),(438,1),(439,1),(440,1),(441,1),(442,1),(443,1),(444,1),(445,1),(446,1),(447,1),(448,1),(449,1),(450,1),(451,1),(452,1),(453,1),(454,1),(455,1),(456,1),(457,1),(458,1),(459,1),(460,1),(461,1),(462,1),(463,1),(464,1),(466,1),(467,1),(468,1),(469,1),(470,1),(471,1),(473,1),(474,1),(475,1),(476,1),(477,1),(478,1),(479,1),(480,1),(481,1),(483,1),(484,1),(485,1),(486,1),(487,1),(488,1),(489,1),(490,1),(492,1),(493,1),(494,1),(495,1),(496,1),(497,1),(498,1),(499,1),(500,1),(501,1),(502,1),(503,1),(504,1),(505,1),(506,1),(507,1),(508,1),(509,1),(510,1),(511,1),(512,1),(513,1),(514,1),(515,1),(516,1),(517,1),(518,1),(519,1),(520,1),(521,1),(522,1),(523,1),(524,1),(525,1),(526,1),(527,1),(529,1),(530,1),(531,1),(532,1),(533,1),(534,1),(535,1),(536,1),(537,1),(538,1),(539,1),(540,1),(541,1),(542,1),(543,1),(544,1),(546,1),(547,1),(548,1),(549,1),(550,1),(551,1),(552,1),(553,1),(554,1),(555,1),(556,1),(557,1),(558,1),(559,1),(560,1),(561,1),(562,1),(563,1),(564,1),(565,1),(566,1),(567,1),(568,1),(569,1),(570,1),(571,1),(572,1),(573,1),(574,1),(575,1),(576,1),(577,1),(578,1),(579,1),(580,1),(581,1),(582,1),(583,1),(584,1),(585,1),(586,1),(587,1),(588,1),(589,1),(590,1),(591,1),(592,1),(593,1),(594,1),(595,1),(596,1),(597,1),(598,1),(599,1),(600,1),(601,1),(602,1),(604,1),(605,1),(606,1),(607,1),(608,1),(609,1),(611,1),(612,1),(613,1),(614,1),(615,1),(616,1),(617,1),(618,1),(620,1),(621,1),(622,1),(623,1),(624,1),(625,1),(626,1),(627,1),(628,1),(629,1),(630,1),(631,1),(632,1),(633,1),(634,1),(635,1),(636,1),(637,1),(638,1),(639,1),(640,1),(641,1),(642,1),(643,1),(644,1),(645,1),(646,1),(647,1),(648,1),(649,1),(650,1),(651,1),(652,1),(653,1),(654,1),(655,1),(656,1),(657,1),(658,1),(659,1),(660,1),(661,1),(662,1),(663,1),(664,1),(665,1),(666,1),(667,1),(668,1),(669,1),(670,1),(672,1),(673,1),(674,1),(675,1),(676,1),(677,1),(678,1),(679,1),(680,1),(681,1),(682,1),(683,1),(684,1),(685,1),(686,1),(687,1),(688,1),(689,1),(690,1),(691,1),(692,1),(693,1),(694,1),(695,1),(696,1),(697,1),(699,1),(700,1),(701,1),(702,1),(703,1),(705,1),(706,1),(707,1),(708,1),(709,1),(710,1),(711,1),(712,1),(714,1),(715,1),(716,1),(717,1),(718,1),(719,1),(720,1),(721,1),(722,1),(723,1),(724,1),(725,1),(726,1),(727,1),(728,1),(729,1),(730,1),(731,1),(732,1),(733,1),(734,1),(735,1),(736,1),(737,1),(738,1),(740,1),(741,1),(742,1),(743,1),(745,1),(746,1),(747,1),(748,1),(749,1),(750,1),(751,1),(752,1),(753,1),(754,1),(755,1),(756,1),(757,1),(758,1),(760,1),(761,1),(762,1),(763,1),(764,1),(766,1),(767,1),(768,1),(769,1),(770,1),(771,1),(772,1),(775,1),(776,1),(777,1),(778,1),(779,1),(781,1),(782,1),(783,1),(784,1),(785,1),(786,1),(787,1),(788,1),(789,1),(790,1),(791,1),(792,1),(793,1),(794,1),(795,1),(796,1),(797,1),(798,1),(800,1),(801,1),(802,1),(803,1),(804,1),(805,1),(806,1),(807,1),(808,1),(809,1),(810,1),(811,1),(812,1),(813,1),(814,1),(815,1),(816,1),(818,1),(819,1),(820,1),(821,1),(822,1),(824,1),(825,1),(826,1),(827,1),(829,1),(830,1),(831,1),(833,1),(834,1),(835,1),(836,1),(837,1),(838,1),(839,1),(840,1),(842,1),(843,1),(845,1),(846,1),(847,1),(848,1),(850,1),(852,1),(853,1),(854,1),(855,1),(856,1),(857,1),(858,1),(859,1),(860,1),(861,1),(862,1),(864,1),(865,1),(868,1),(869,1),(870,1),(871,1),(872,1),(873,1),(875,1),(876,1),(877,1),(878,1),(880,1),(881,1),(882,1),(883,1),(884,1),(885,1),(886,1),(887,1),(888,1),(889,1),(890,1),(891,1),(892,1),(893,1),(894,1),(895,1),(896,1),(897,1),(898,1),(899,1),(900,1),(901,1),(902,1),(903,1),(904,1),(905,1),(906,1),(907,1),(908,1),(909,1),(910,1),(911,1),(912,1),(913,1),(915,1),(916,1),(918,1),(919,1),(920,1),(921,1),(922,1),(923,1),(924,1),(925,1),(926,1),(927,1),(928,1),(929,1),(930,1),(931,1),(932,1),(933,1),(934,1),(935,1),(936,1),(937,1),(938,1),(939,1),(940,1),(941,1),(942,1),(943,1),(945,1),(946,1),(947,1),(948,1),(949,1),(950,1),(951,1),(952,1),(953,1),(954,1),(955,1),(956,1),(957,1),(958,1),(959,1),(960,1),(961,1),(962,1),(963,1),(964,1),(966,1),(968,1),(969,1),(970,1),(971,1),(972,1),(973,1),(974,1),(975,1),(976,1),(977,1),(978,1),(980,1),(981,1),(982,1),(983,1),(984,1),(985,1),(986,1),(987,1),(988,1),(989,1),(990,1),(991,1),(992,1),(993,1),(994,1),(995,1),(996,1),(997,1),(998,1),(999,1),(1000,1),(1001,1),(1002,1),(1003,1),(1004,1),(1005,1),(1006,1),(1007,1),(1008,1),(1009,1),(1010,1),(1011,1),(1012,1),(1013,1),(1014,1),(1015,1),(1016,1),(1017,1),(1018,1),(1019,1),(1021,1),(1022,1),(1023,1),(1024,1),(1025,1),(1026,1),(1027,1),(1028,1),(1030,1),(1031,1),(1032,1),(1033,1),(1034,1),(1035,1),(1036,1),(1037,1),(1038,1),(1039,1),(1040,1),(1041,1),(1042,1),(1043,1),(1044,1),(1045,1),(1046,1),(1047,1),(1048,1),(1049,1),(1050,1),(1051,1),(1053,1),(1054,1),(1055,1),(1056,1),(1057,1),(1058,1),(1059,1),(1060,1),(1061,1),(1062,1),(1063,1),(1064,1),(1065,1),(1066,1),(1067,1),(1068,1),(1069,1),(1070,1),(1071,1),(1072,1),(1073,1),(1074,1),(1075,1),(1076,1),(1077,1),(1078,1),(1079,1),(1080,1),(1081,1),(1082,1),(1083,1),(1085,1),(1087,1),(1088,1),(1089,1),(1090,1),(1091,1),(1092,1),(1093,1),(1094,1),(1095,1),(1096,1),(1097,1),(1098,1),(1099,1),(1101,1),(1102,1),(1103,1),(1104,1),(1105,1),(1106,1),(1107,1),(1108,1),(1109,1),(1110,1),(1111,1),(1112,1),(1114,1),(1115,1),(1116,1),(1117,1),(1118,1),(1119,1),(1120,1),(1121,1),(1122,1),(1123,1),(1124,1),(1125,1),(1126,1),(1128,1),(1129,1),(1130,1),(1131,1),(1132,1),(1133,1),(1134,1),(1135,1),(1136,1),(1137,1),(1139,1),(1140,1),(1141,1),(1142,1),(1143,1),(1145,1),(1146,1),(1147,1),(1149,1),(1150,1),(1151,1),(1152,1),(1153,1),(1154,1),(1155,1),(1157,1),(1158,1),(1160,1),(1161,1),(1162,1),(1163,1),(1164,1),(1165,1),(1166,1),(1167,1),(1168,1),(1169,1),(1170,1),(1171,1),(1172,1),(1174,1),(1175,1),(1176,1),(1177,1),(1178,1),(1179,1),(1180,1),(1181,1),(1182,1),(1183,1),(1184,1),(1185,1),(1186,1),(1187,1),(1189,1),(1190,1),(1192,1),(1193,1),(1194,1),(1195,1),(1196,1),(1197,1),(1198,1),(1199,1),(1200,1),(1201,1),(1202,1),(1203,1),(1204,1),(1205,1),(1206,1),(1207,1),(1208,1),(1209,1),(1211,1),(1212,1),(1213,1),(1214,1),(1215,1),(1216,1),(1217,1),(1218,1),(1219,1),(1220,1),(1221,1),(1222,1),(1223,1),(1224,1),(1226,1),(1227,1),(1228,1),(1229,1),(1230,1),(1231,1),(1232,1),(1234,1),(1235,1),(1236,1),(1237,1),(1238,1),(1240,1),(1241,1),(1242,1),(1243,1),(1244,1),(1245,1),(1246,1),(1247,1),(1248,1),(1249,1),(1250,1),(1251,1),(1252,1),(1253,1),(1254,1),(1255,1),(1256,1),(1257,1),(1258,1),(1259,1),(1260,1),(1261,1),(1262,1),(1264,1),(1266,1),(1267,1),(1268,1),(1269,1),(1270,1),(1271,1),(1272,1),(1273,1),(1274,1),(1275,1),(1276,1),(1277,1),(1278,1),(1279,1),(1280,1),(1281,1),(1282,1),(1283,1),(1284,1),(1285,1),(1286,1),(1287,1),(1288,1),(1289,1),(1290,1),(1291,1),(1292,1),(1293,1),(1294,1),(1295,1),(1296,1),(1297,1),(1298,1),(1299,1),(1300,1),(1301,1),(1302,1),(1303,1),(1304,1),(1305,1),(1306,1),(1307,1),(1308,1),(1309,1),(1310,1),(1311,1),(1312,1),(1313,1),(1315,1),(1318,1),(1319,1),(1320,1),(1321,1),(1322,1),(1323,1),(1324,1),(1325,1),(1326,1),(1327,1),(1328,1),(1329,1),(1330,1),(1331,1),(1332,1),(1333,1),(1334,1),(1335,1),(1336,1),(1337,1),(1338,1),(1339,1),(1340,1),(1341,1),(1342,1),(1344,1),(1345,1),(1346,1),(1347,1),(1349,1),(1350,1),(1351,1),(1352,1),(1353,1),(1354,1),(1355,1),(1356,1),(1357,1),(1358,1),(1359,1),(1360,1),(1361,1),(1363,1),(1364,1),(1365,1),(1366,1),(1367,1),(1368,1),(1369,1),(1370,1),(1371,1),(1372,1),(1373,1),(1374,1),(1375,1),(1376,1),(1377,1),(1378,1),(1379,1),(1380,1),(1381,1),(1382,1),(1383,1),(1384,1),(1385,1),(1386,1),(1387,1),(1388,1),(1389,1),(1390,1),(1391,1),(1392,1),(1393,1),(1394,1),(1395,1),(1396,1),(1397,1),(1398,1),(1399,1),(1400,1),(1401,1),(1403,1),(1404,1),(1405,1),(1406,1),(1407,1),(1408,1),(1409,1),(1411,1),(1412,1),(1413,1),(1414,1),(1415,1),(1416,1),(1417,1),(1418,1),(1419,1),(1420,1),(1421,1),(1422,1),(1423,1),(1424,1),(1425,1),(1426,1),(1427,1),(1428,1),(1429,1),(1430,1),(1431,1),(1432,1),(1433,1),(1434,1),(1435,1),(1436,1),(1437,1),(1438,1),(1439,1),(1440,1),(1441,1),(1442,1),(1443,1),(1444,1),(1445,1),(1446,1),(1447,1),(1448,1),(1449,1),(1451,1),(1452,1),(1453,1),(1454,1),(1455,1),(1456,1),(1457,1),(1458,1),(1459,1),(1460,1),(1461,1),(1462,1),(1463,1),(1464,1),(1465,1),(1466,1),(1467,1),(1468,1),(1469,1),(1470,1),(1471,1),(1473,1),(1474,1),(1475,1),(1476,1),(1477,1),(1478,1),(1479,1),(1480,1),(1481,1),(1482,1),(1483,1),(1484,1),(1485,1),(1486,1),(1487,1),(1488,1),(1489,1),(1491,1),(1492,1),(1493,1),(1494,1),(1495,1),(1496,1),(1497,1),(1498,1),(1499,1),(1500,1),(1501,1),(1502,1),(1503,1),(1504,1),(1506,1),(1507,1),(1508,1),(1510,1),(1511,1),(1512,1),(1513,1),(1514,1),(1515,1),(1516,1),(1517,1),(1518,1),(1519,1),(1520,1),(1521,1),(1522,1),(1523,1),(1524,1),(1525,1),(1526,1),(1527,1),(1528,1),(1529,1),(1530,1),(1531,1),(1532,1),(1533,1),(1534,1),(1535,1),(1536,1),(1537,1),(1539,1),(1541,1),(1542,1),(1543,1),(1544,1),(1545,1),(1546,1),(1547,1),(1548,1),(1549,1),(1550,1),(1551,1),(1552,1),(1554,1),(1556,1),(1557,1),(1558,1),(1559,1),(1560,1),(1561,1),(1562,1),(1563,1),(1564,1),(1565,1),(1566,1),(1567,1),(1568,1),(1569,1),(1570,1),(1571,1),(1572,1),(1573,1),(1574,1),(1575,1),(1576,1),(1578,1),(1579,1),(1581,1),(1582,1),(1583,1),(1584,1),(1585,1),(1586,1),(1587,1),(1588,1),(1589,1),(1590,1),(1591,1),(1592,1),(1593,1),(1594,1),(1595,1),(1596,1),(1597,1),(1598,1),(1599,1),(1600,1),(1601,1),(1602,1),(1603,1),(1604,1),(1605,1),(1606,1),(1607,1),(1609,1),(1610,1),(1612,1),(1613,1),(1614,1),(1615,1),(1616,1),(1617,1),(1618,1),(1619,1),(1621,1),(1622,1),(1623,1),(1624,1),(1625,1),(1627,1),(1628,1),(1629,1),(1630,1),(1631,1),(1632,1),(1633,1),(1634,1),(1635,1),(1636,1),(1637,1),(1638,1),(1639,1),(1640,1),(1641,1),(1643,1),(1644,1),(1645,1),(1646,1),(1647,1),(1648,1),(1649,1),(1650,1),(1651,1),(1652,1),(1653,1),(1654,1),(1656,1),(1657,1),(1658,1),(1659,1),(1660,1),(1661,1),(1662,1),(1663,1),(1664,1),(1666,1),(1667,1),(1668,1),(1669,1),(1671,1),(1672,1),(1673,1),(1674,1),(1675,1),(1676,1),(1677,1),(1678,1),(1679,1),(1681,1),(1682,1),(1684,1),(1685,1),(1686,1),(1687,1),(1688,1),(1689,1),(1690,1),(1691,1),(1693,1),(1694,1),(1695,1),(1696,1),(1697,1),(1698,1),(1699,1),(1700,1),(1701,1),(1702,1),(1703,1),(1704,1),(1705,1),(1706,1),(1707,1),(1708,1),(1709,1),(1710,1),(1711,1),(1712,1),(1713,1),(1715,1),(1716,1),(1718,1),(1719,1),(1720,1),(1721,1),(1722,1),(1723,1),(1724,1),(1725,1),(1726,1),(1727,1),(1728,1),(1730,1),(1731,1),(1732,1),(1733,1),(1734,1),(1735,1),(1736,1),(1737,1),(1738,1),(1739,1),(1740,1),(1741,1),(1742,1),(1743,1),(1744,1),(1745,1),(1746,1),(1747,1),(1748,1),(1749,1),(1750,1),(1751,1),(1752,1),(1753,1),(1754,1),(1755,1),(1756,1),(1757,1),(1758,1),(1759,1),(1760,1),(1761,1),(1762,1),(1763,1),(1764,1),(1765,1),(1766,1),(1767,1),(1768,1),(1770,1),(1771,1),(1772,1),(1773,1),(1774,1),(1775,1),(1776,1),(1777,1),(1778,1),(1779,1),(1780,1),(1781,1),(1782,1),(1783,1),(1784,1),(1786,1),(1787,1),(1788,1),(1789,1),(1790,1),(1791,1),(1792,1),(1793,1),(1794,1),(1796,1),(1798,1),(1799,1),(1800,1),(1802,1),(1803,1),(1804,1),(1805,1),(1806,1),(1807,1),(1809,1),(1810,1),(1811,1),(1812,1),(1813,1),(1,1),(7,1),(8,1),(45,1),(48,1),(54,1),(56,1),(76,1),(82,1),(93,1),(119,1),(126,1),(146,1),(202,1),(208,1),(258,1),(318,1),(367,1),(383,1),(400,1),(408,1),(435,1),(465,1),(472,1),(482,1),(491,1),(528,1),(545,1),(603,1),(610,1),(619,1),(671,1),(698,1),(704,1),(713,1),(739,1),(744,1),(759,1),(765,1),(773,1),(774,1),(780,1),(799,1),(817,1),(823,1),(828,1),(832,1),(841,1),(844,1),(849,1),(851,1),(863,1),(866,1),(867,1),(874,1),(879,1),(914,1),(917,1),(944,1),(965,1),(967,1),(979,1),(1020,1),(1029,1),(1052,1),(1084,1),(1086,1),(1100,1),(1113,1),(1127,1),(1138,1),(1144,1),(1148,1),(1156,1),(1159,1),(1173,1),(1188,1),(1191,1),(1210,1),(1225,1),(1233,1),(1239,1),(1263,1),(1265,1),(1314,1),(1316,1),(1317,1),(1343,1),(1348,1),(1362,1),(1402,1),(1410,1),(1450,1),(1472,1),(1490,1),(1505,1),(1509,1),(1538,1),(1540,1),(1553,1),(1555,1),(1577,1),(1580,1),(1608,1),(1611,1),(1620,1),(1626,1),(1642,1),(1655,1),(1665,1),(1670,1),(1680,1),(1683,1),(1692,1),(1714,1),(1717,1),(1729,1),(1769,1),(1785,1),(1795,1),(1797,1),(1801,1),(1808,1);
/*!40000 ALTER TABLE `product_locations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `product_racks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_racks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `rack` varchar(191) DEFAULT NULL,
  `row` varchar(191) DEFAULT NULL,
  `position` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `product_racks_business_id_index` (`business_id`),
  KEY `product_racks_location_id_index` (`location_id`),
  KEY `product_racks_product_id_index` (`product_id`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `product_racks` WRITE;
/*!40000 ALTER TABLE `product_racks` DISABLE KEYS */;
/*!40000 ALTER TABLE `product_racks` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `product_variations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_variations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `variation_template_id` int(11) DEFAULT NULL,
  `name` varchar(191) NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `is_dummy` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `product_variations_name_index` (`name`),
  KEY `product_variations_product_id_index` (`product_id`),
  CONSTRAINT `product_variations_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1814 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `product_variations` WRITE;
/*!40000 ALTER TABLE `product_variations` DISABLE KEYS */;
INSERT INTO `product_variations` VALUES (1,NULL,'DUMMY',1,1,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(2,NULL,'DUMMY',2,1,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(3,NULL,'DUMMY',3,1,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(4,NULL,'DUMMY',4,1,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(5,NULL,'DUMMY',5,1,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(6,NULL,'DUMMY',6,1,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(7,NULL,'DUMMY',7,1,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(8,NULL,'DUMMY',8,1,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(9,NULL,'DUMMY',9,1,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(10,NULL,'DUMMY',10,1,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(11,NULL,'DUMMY',11,1,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(12,NULL,'DUMMY',12,1,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(13,NULL,'DUMMY',13,1,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(14,NULL,'DUMMY',14,1,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(15,NULL,'DUMMY',15,1,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(16,NULL,'DUMMY',16,1,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(17,NULL,'DUMMY',17,1,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(18,NULL,'DUMMY',18,1,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(19,NULL,'DUMMY',19,1,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(20,NULL,'DUMMY',20,1,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(21,NULL,'DUMMY',21,1,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(22,NULL,'DUMMY',22,1,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(23,NULL,'DUMMY',23,1,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(24,NULL,'DUMMY',24,1,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(25,NULL,'DUMMY',25,1,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(26,NULL,'DUMMY',26,1,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(27,NULL,'DUMMY',27,1,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(28,NULL,'DUMMY',28,1,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(29,NULL,'DUMMY',29,1,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(30,NULL,'DUMMY',30,1,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(31,NULL,'DUMMY',31,1,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(32,NULL,'DUMMY',32,1,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(33,NULL,'DUMMY',33,1,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(34,NULL,'DUMMY',34,1,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(35,NULL,'DUMMY',35,1,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(36,NULL,'DUMMY',36,1,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(37,NULL,'DUMMY',37,1,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(38,NULL,'DUMMY',38,1,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(39,NULL,'DUMMY',39,1,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(40,NULL,'DUMMY',40,1,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(41,NULL,'DUMMY',41,1,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(42,NULL,'DUMMY',42,1,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(43,NULL,'DUMMY',43,1,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(44,NULL,'DUMMY',44,1,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(45,NULL,'DUMMY',45,1,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(46,NULL,'DUMMY',46,1,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(47,NULL,'DUMMY',47,1,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(48,NULL,'DUMMY',48,1,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(49,NULL,'DUMMY',49,1,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(50,NULL,'DUMMY',50,1,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(51,NULL,'DUMMY',51,1,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(52,NULL,'DUMMY',52,1,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(53,NULL,'DUMMY',53,1,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(54,NULL,'DUMMY',54,1,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(55,NULL,'DUMMY',55,1,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(56,NULL,'DUMMY',56,1,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(57,NULL,'DUMMY',57,1,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(58,NULL,'DUMMY',58,1,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(59,NULL,'DUMMY',59,1,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(60,NULL,'DUMMY',60,1,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(61,NULL,'DUMMY',61,1,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(62,NULL,'DUMMY',62,1,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(63,NULL,'DUMMY',63,1,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(64,NULL,'DUMMY',64,1,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(65,NULL,'DUMMY',65,1,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(66,NULL,'DUMMY',66,1,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(67,NULL,'DUMMY',67,1,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(68,NULL,'DUMMY',68,1,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(69,NULL,'DUMMY',69,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(70,NULL,'DUMMY',70,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(71,NULL,'DUMMY',71,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(72,NULL,'DUMMY',72,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(73,NULL,'DUMMY',73,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(74,NULL,'DUMMY',74,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(75,NULL,'DUMMY',75,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(76,NULL,'DUMMY',76,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(77,NULL,'DUMMY',77,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(78,NULL,'DUMMY',78,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(79,NULL,'DUMMY',79,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(80,NULL,'DUMMY',80,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(81,NULL,'DUMMY',81,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(82,NULL,'DUMMY',82,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(83,NULL,'DUMMY',83,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(84,NULL,'DUMMY',84,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(85,NULL,'DUMMY',85,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(86,NULL,'DUMMY',86,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(87,NULL,'DUMMY',87,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(88,NULL,'DUMMY',88,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(89,NULL,'DUMMY',89,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(90,NULL,'DUMMY',90,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(91,NULL,'DUMMY',91,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(92,NULL,'DUMMY',92,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(93,NULL,'DUMMY',93,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(94,NULL,'DUMMY',94,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(95,NULL,'DUMMY',95,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(96,NULL,'DUMMY',96,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(97,NULL,'DUMMY',97,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(98,NULL,'DUMMY',98,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(99,NULL,'DUMMY',99,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(100,NULL,'DUMMY',100,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(101,NULL,'DUMMY',101,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(102,NULL,'DUMMY',102,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(103,NULL,'DUMMY',103,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(104,NULL,'DUMMY',104,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(105,NULL,'DUMMY',105,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(106,NULL,'DUMMY',106,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(107,NULL,'DUMMY',107,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(108,NULL,'DUMMY',108,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(109,NULL,'DUMMY',109,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(110,NULL,'DUMMY',110,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(111,NULL,'DUMMY',111,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(112,NULL,'DUMMY',112,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(113,NULL,'DUMMY',113,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(114,NULL,'DUMMY',114,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(115,NULL,'DUMMY',115,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(116,NULL,'DUMMY',116,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(117,NULL,'DUMMY',117,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(118,NULL,'DUMMY',118,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(119,NULL,'DUMMY',119,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(120,NULL,'DUMMY',120,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(121,NULL,'DUMMY',121,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(122,NULL,'DUMMY',122,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(123,NULL,'DUMMY',123,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(124,NULL,'DUMMY',124,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(125,NULL,'DUMMY',125,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(126,NULL,'DUMMY',126,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(127,NULL,'DUMMY',127,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(128,NULL,'DUMMY',128,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(129,NULL,'DUMMY',129,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(130,NULL,'DUMMY',130,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(131,NULL,'DUMMY',131,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(132,NULL,'DUMMY',132,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(133,NULL,'DUMMY',133,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(134,NULL,'DUMMY',134,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(135,NULL,'DUMMY',135,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(136,NULL,'DUMMY',136,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(137,NULL,'DUMMY',137,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(138,NULL,'DUMMY',138,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(139,NULL,'DUMMY',139,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(140,NULL,'DUMMY',140,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(141,NULL,'DUMMY',141,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(142,NULL,'DUMMY',142,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(143,NULL,'DUMMY',143,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(144,NULL,'DUMMY',144,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(145,NULL,'DUMMY',145,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(146,NULL,'DUMMY',146,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(147,NULL,'DUMMY',147,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(148,NULL,'DUMMY',148,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(149,NULL,'DUMMY',149,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(150,NULL,'DUMMY',150,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(151,NULL,'DUMMY',151,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(152,NULL,'DUMMY',152,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(153,NULL,'DUMMY',153,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(154,NULL,'DUMMY',154,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(155,NULL,'DUMMY',155,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(156,NULL,'DUMMY',156,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(157,NULL,'DUMMY',157,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(158,NULL,'DUMMY',158,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(159,NULL,'DUMMY',159,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(160,NULL,'DUMMY',160,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(161,NULL,'DUMMY',161,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(162,NULL,'DUMMY',162,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(163,NULL,'DUMMY',163,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(164,NULL,'DUMMY',164,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(165,NULL,'DUMMY',165,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(166,NULL,'DUMMY',166,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(167,NULL,'DUMMY',167,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(168,NULL,'DUMMY',168,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(169,NULL,'DUMMY',169,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(170,NULL,'DUMMY',170,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(171,NULL,'DUMMY',171,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(172,NULL,'DUMMY',172,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(173,NULL,'DUMMY',173,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(174,NULL,'DUMMY',174,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(175,NULL,'DUMMY',175,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(176,NULL,'DUMMY',176,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(177,NULL,'DUMMY',177,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(178,NULL,'DUMMY',178,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(179,NULL,'DUMMY',179,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(180,NULL,'DUMMY',180,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(181,NULL,'DUMMY',181,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(182,NULL,'DUMMY',182,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(183,NULL,'DUMMY',183,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(184,NULL,'DUMMY',184,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(185,NULL,'DUMMY',185,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(186,NULL,'DUMMY',186,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(187,NULL,'DUMMY',187,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(188,NULL,'DUMMY',188,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(189,NULL,'DUMMY',189,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(190,NULL,'DUMMY',190,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(191,NULL,'DUMMY',191,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(192,NULL,'DUMMY',192,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(193,NULL,'DUMMY',193,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(194,NULL,'DUMMY',194,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(195,NULL,'DUMMY',195,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(196,NULL,'DUMMY',196,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(197,NULL,'DUMMY',197,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(198,NULL,'DUMMY',198,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(199,NULL,'DUMMY',199,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(200,NULL,'DUMMY',200,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(201,NULL,'DUMMY',201,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(202,NULL,'DUMMY',202,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(203,NULL,'DUMMY',203,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(204,NULL,'DUMMY',204,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(205,NULL,'DUMMY',205,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(206,NULL,'DUMMY',206,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(207,NULL,'DUMMY',207,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(208,NULL,'DUMMY',208,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(209,NULL,'DUMMY',209,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(210,NULL,'DUMMY',210,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(211,NULL,'DUMMY',211,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(212,NULL,'DUMMY',212,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(213,NULL,'DUMMY',213,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(214,NULL,'DUMMY',214,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(215,NULL,'DUMMY',215,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(216,NULL,'DUMMY',216,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(217,NULL,'DUMMY',217,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(218,NULL,'DUMMY',218,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(219,NULL,'DUMMY',219,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(220,NULL,'DUMMY',220,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(221,NULL,'DUMMY',221,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(222,NULL,'DUMMY',222,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(223,NULL,'DUMMY',223,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(224,NULL,'DUMMY',224,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(225,NULL,'DUMMY',225,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(226,NULL,'DUMMY',226,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(227,NULL,'DUMMY',227,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(228,NULL,'DUMMY',228,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(229,NULL,'DUMMY',229,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(230,NULL,'DUMMY',230,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(231,NULL,'DUMMY',231,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(232,NULL,'DUMMY',232,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(233,NULL,'DUMMY',233,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(234,NULL,'DUMMY',234,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(235,NULL,'DUMMY',235,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(236,NULL,'DUMMY',236,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(237,NULL,'DUMMY',237,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(238,NULL,'DUMMY',238,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(239,NULL,'DUMMY',239,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(240,NULL,'DUMMY',240,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(241,NULL,'DUMMY',241,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(242,NULL,'DUMMY',242,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(243,NULL,'DUMMY',243,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(244,NULL,'DUMMY',244,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(245,NULL,'DUMMY',245,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(246,NULL,'DUMMY',246,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(247,NULL,'DUMMY',247,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(248,NULL,'DUMMY',248,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(249,NULL,'DUMMY',249,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(250,NULL,'DUMMY',250,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(251,NULL,'DUMMY',251,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(252,NULL,'DUMMY',252,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(253,NULL,'DUMMY',253,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(254,NULL,'DUMMY',254,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(255,NULL,'DUMMY',255,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(256,NULL,'DUMMY',256,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(257,NULL,'DUMMY',257,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(258,NULL,'DUMMY',258,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(259,NULL,'DUMMY',259,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(260,NULL,'DUMMY',260,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(261,NULL,'DUMMY',261,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(262,NULL,'DUMMY',262,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(263,NULL,'DUMMY',263,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(264,NULL,'DUMMY',264,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(265,NULL,'DUMMY',265,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(266,NULL,'DUMMY',266,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(267,NULL,'DUMMY',267,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(268,NULL,'DUMMY',268,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(269,NULL,'DUMMY',269,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(270,NULL,'DUMMY',270,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(271,NULL,'DUMMY',271,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(272,NULL,'DUMMY',272,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(273,NULL,'DUMMY',273,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(274,NULL,'DUMMY',274,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(275,NULL,'DUMMY',275,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(276,NULL,'DUMMY',276,1,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(277,NULL,'DUMMY',277,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(278,NULL,'DUMMY',278,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(279,NULL,'DUMMY',279,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(280,NULL,'DUMMY',280,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(281,NULL,'DUMMY',281,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(282,NULL,'DUMMY',282,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(283,NULL,'DUMMY',283,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(284,NULL,'DUMMY',284,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(285,NULL,'DUMMY',285,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(286,NULL,'DUMMY',286,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(287,NULL,'DUMMY',287,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(288,NULL,'DUMMY',288,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(289,NULL,'DUMMY',289,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(290,NULL,'DUMMY',290,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(291,NULL,'DUMMY',291,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(292,NULL,'DUMMY',292,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(293,NULL,'DUMMY',293,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(294,NULL,'DUMMY',294,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(295,NULL,'DUMMY',295,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(296,NULL,'DUMMY',296,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(297,NULL,'DUMMY',297,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(298,NULL,'DUMMY',298,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(299,NULL,'DUMMY',299,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(300,NULL,'DUMMY',300,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(301,NULL,'DUMMY',301,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(302,NULL,'DUMMY',302,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(303,NULL,'DUMMY',303,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(304,NULL,'DUMMY',304,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(305,NULL,'DUMMY',305,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(306,NULL,'DUMMY',306,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(307,NULL,'DUMMY',307,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(308,NULL,'DUMMY',308,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(309,NULL,'DUMMY',309,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(310,NULL,'DUMMY',310,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(311,NULL,'DUMMY',311,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(312,NULL,'DUMMY',312,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(313,NULL,'DUMMY',313,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(314,NULL,'DUMMY',314,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(315,NULL,'DUMMY',315,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(316,NULL,'DUMMY',316,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(317,NULL,'DUMMY',317,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(318,NULL,'DUMMY',318,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(319,NULL,'DUMMY',319,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(320,NULL,'DUMMY',320,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(321,NULL,'DUMMY',321,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(322,NULL,'DUMMY',322,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(323,NULL,'DUMMY',323,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(324,NULL,'DUMMY',324,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(325,NULL,'DUMMY',325,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(326,NULL,'DUMMY',326,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(327,NULL,'DUMMY',327,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(328,NULL,'DUMMY',328,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(329,NULL,'DUMMY',329,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(330,NULL,'DUMMY',330,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(331,NULL,'DUMMY',331,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(332,NULL,'DUMMY',332,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(333,NULL,'DUMMY',333,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(334,NULL,'DUMMY',334,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(335,NULL,'DUMMY',335,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(336,NULL,'DUMMY',336,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(337,NULL,'DUMMY',337,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(338,NULL,'DUMMY',338,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(339,NULL,'DUMMY',339,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(340,NULL,'DUMMY',340,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(341,NULL,'DUMMY',341,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(342,NULL,'DUMMY',342,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(343,NULL,'DUMMY',343,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(344,NULL,'DUMMY',344,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(345,NULL,'DUMMY',345,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(346,NULL,'DUMMY',346,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(347,NULL,'DUMMY',347,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(348,NULL,'DUMMY',348,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(349,NULL,'DUMMY',349,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(350,NULL,'DUMMY',350,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(351,NULL,'DUMMY',351,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(352,NULL,'DUMMY',352,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(353,NULL,'DUMMY',353,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(354,NULL,'DUMMY',354,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(355,NULL,'DUMMY',355,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(356,NULL,'DUMMY',356,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(357,NULL,'DUMMY',357,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(358,NULL,'DUMMY',358,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(359,NULL,'DUMMY',359,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(360,NULL,'DUMMY',360,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(361,NULL,'DUMMY',361,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(362,NULL,'DUMMY',362,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(363,NULL,'DUMMY',363,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(364,NULL,'DUMMY',364,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(365,NULL,'DUMMY',365,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(366,NULL,'DUMMY',366,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(367,NULL,'DUMMY',367,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(368,NULL,'DUMMY',368,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(369,NULL,'DUMMY',369,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(370,NULL,'DUMMY',370,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(371,NULL,'DUMMY',371,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(372,NULL,'DUMMY',372,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(373,NULL,'DUMMY',373,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(374,NULL,'DUMMY',374,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(375,NULL,'DUMMY',375,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(376,NULL,'DUMMY',376,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(377,NULL,'DUMMY',377,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(378,NULL,'DUMMY',378,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(379,NULL,'DUMMY',379,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(380,NULL,'DUMMY',380,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(381,NULL,'DUMMY',381,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(382,NULL,'DUMMY',382,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(383,NULL,'DUMMY',383,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(384,NULL,'DUMMY',384,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(385,NULL,'DUMMY',385,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(386,NULL,'DUMMY',386,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(387,NULL,'DUMMY',387,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(388,NULL,'DUMMY',388,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(389,NULL,'DUMMY',389,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(390,NULL,'DUMMY',390,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(391,NULL,'DUMMY',391,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(392,NULL,'DUMMY',392,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(393,NULL,'DUMMY',393,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(394,NULL,'DUMMY',394,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(395,NULL,'DUMMY',395,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(396,NULL,'DUMMY',396,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(397,NULL,'DUMMY',397,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(398,NULL,'DUMMY',398,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(399,NULL,'DUMMY',399,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(400,NULL,'DUMMY',400,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(401,NULL,'DUMMY',401,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(402,NULL,'DUMMY',402,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(403,NULL,'DUMMY',403,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(404,NULL,'DUMMY',404,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(405,NULL,'DUMMY',405,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(406,NULL,'DUMMY',406,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(407,NULL,'DUMMY',407,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(408,NULL,'DUMMY',408,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(409,NULL,'DUMMY',409,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(410,NULL,'DUMMY',410,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(411,NULL,'DUMMY',411,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(412,NULL,'DUMMY',412,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(413,NULL,'DUMMY',413,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(414,NULL,'DUMMY',414,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(415,NULL,'DUMMY',415,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(416,NULL,'DUMMY',416,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(417,NULL,'DUMMY',417,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(418,NULL,'DUMMY',418,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(419,NULL,'DUMMY',419,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(420,NULL,'DUMMY',420,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(421,NULL,'DUMMY',421,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(422,NULL,'DUMMY',422,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(423,NULL,'DUMMY',423,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(424,NULL,'DUMMY',424,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(425,NULL,'DUMMY',425,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(426,NULL,'DUMMY',426,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(427,NULL,'DUMMY',427,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(428,NULL,'DUMMY',428,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(429,NULL,'DUMMY',429,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(430,NULL,'DUMMY',430,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(431,NULL,'DUMMY',431,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(432,NULL,'DUMMY',432,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(433,NULL,'DUMMY',433,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(434,NULL,'DUMMY',434,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(435,NULL,'DUMMY',435,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(436,NULL,'DUMMY',436,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(437,NULL,'DUMMY',437,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(438,NULL,'DUMMY',438,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(439,NULL,'DUMMY',439,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(440,NULL,'DUMMY',440,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(441,NULL,'DUMMY',441,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(442,NULL,'DUMMY',442,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(443,NULL,'DUMMY',443,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(444,NULL,'DUMMY',444,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(445,NULL,'DUMMY',445,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(446,NULL,'DUMMY',446,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(447,NULL,'DUMMY',447,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(448,NULL,'DUMMY',448,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(449,NULL,'DUMMY',449,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(450,NULL,'DUMMY',450,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(451,NULL,'DUMMY',451,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(452,NULL,'DUMMY',452,1,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(453,NULL,'DUMMY',453,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(454,NULL,'DUMMY',454,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(455,NULL,'DUMMY',455,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(456,NULL,'DUMMY',456,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(457,NULL,'DUMMY',457,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(458,NULL,'DUMMY',458,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(459,NULL,'DUMMY',459,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(460,NULL,'DUMMY',460,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(461,NULL,'DUMMY',461,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(462,NULL,'DUMMY',462,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(463,NULL,'DUMMY',463,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(464,NULL,'DUMMY',464,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(465,NULL,'DUMMY',465,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(466,NULL,'DUMMY',466,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(467,NULL,'DUMMY',467,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(468,NULL,'DUMMY',468,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(469,NULL,'DUMMY',469,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(470,NULL,'DUMMY',470,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(471,NULL,'DUMMY',471,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(472,NULL,'DUMMY',472,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(473,NULL,'DUMMY',473,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(474,NULL,'DUMMY',474,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(475,NULL,'DUMMY',475,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(476,NULL,'DUMMY',476,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(477,NULL,'DUMMY',477,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(478,NULL,'DUMMY',478,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(479,NULL,'DUMMY',479,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(480,NULL,'DUMMY',480,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(481,NULL,'DUMMY',481,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(482,NULL,'DUMMY',482,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(483,NULL,'DUMMY',483,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(484,NULL,'DUMMY',484,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(485,NULL,'DUMMY',485,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(486,NULL,'DUMMY',486,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(487,NULL,'DUMMY',487,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(488,NULL,'DUMMY',488,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(489,NULL,'DUMMY',489,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(490,NULL,'DUMMY',490,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(491,NULL,'DUMMY',491,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(492,NULL,'DUMMY',492,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(493,NULL,'DUMMY',493,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(494,NULL,'DUMMY',494,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(495,NULL,'DUMMY',495,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(496,NULL,'DUMMY',496,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(497,NULL,'DUMMY',497,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(498,NULL,'DUMMY',498,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(499,NULL,'DUMMY',499,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(500,NULL,'DUMMY',500,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(501,NULL,'DUMMY',501,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(502,NULL,'DUMMY',502,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(503,NULL,'DUMMY',503,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(504,NULL,'DUMMY',504,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(505,NULL,'DUMMY',505,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(506,NULL,'DUMMY',506,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(507,NULL,'DUMMY',507,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(508,NULL,'DUMMY',508,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(509,NULL,'DUMMY',509,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(510,NULL,'DUMMY',510,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(511,NULL,'DUMMY',511,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(512,NULL,'DUMMY',512,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(513,NULL,'DUMMY',513,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(514,NULL,'DUMMY',514,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(515,NULL,'DUMMY',515,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(516,NULL,'DUMMY',516,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(517,NULL,'DUMMY',517,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(518,NULL,'DUMMY',518,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(519,NULL,'DUMMY',519,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(520,NULL,'DUMMY',520,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(521,NULL,'DUMMY',521,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(522,NULL,'DUMMY',522,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(523,NULL,'DUMMY',523,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(524,NULL,'DUMMY',524,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(525,NULL,'DUMMY',525,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(526,NULL,'DUMMY',526,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(527,NULL,'DUMMY',527,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(528,NULL,'DUMMY',528,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(529,NULL,'DUMMY',529,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(530,NULL,'DUMMY',530,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(531,NULL,'DUMMY',531,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(532,NULL,'DUMMY',532,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(533,NULL,'DUMMY',533,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(534,NULL,'DUMMY',534,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(535,NULL,'DUMMY',535,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(536,NULL,'DUMMY',536,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(537,NULL,'DUMMY',537,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(538,NULL,'DUMMY',538,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(539,NULL,'DUMMY',539,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(540,NULL,'DUMMY',540,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(541,NULL,'DUMMY',541,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(542,NULL,'DUMMY',542,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(543,NULL,'DUMMY',543,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(544,NULL,'DUMMY',544,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(545,NULL,'DUMMY',545,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(546,NULL,'DUMMY',546,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(547,NULL,'DUMMY',547,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(548,NULL,'DUMMY',548,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(549,NULL,'DUMMY',549,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(550,NULL,'DUMMY',550,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(551,NULL,'DUMMY',551,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(552,NULL,'DUMMY',552,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(553,NULL,'DUMMY',553,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(554,NULL,'DUMMY',554,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(555,NULL,'DUMMY',555,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(556,NULL,'DUMMY',556,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(557,NULL,'DUMMY',557,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(558,NULL,'DUMMY',558,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(559,NULL,'DUMMY',559,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(560,NULL,'DUMMY',560,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(561,NULL,'DUMMY',561,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(562,NULL,'DUMMY',562,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(563,NULL,'DUMMY',563,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(564,NULL,'DUMMY',564,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(565,NULL,'DUMMY',565,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(566,NULL,'DUMMY',566,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(567,NULL,'DUMMY',567,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(568,NULL,'DUMMY',568,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(569,NULL,'DUMMY',569,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(570,NULL,'DUMMY',570,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(571,NULL,'DUMMY',571,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(572,NULL,'DUMMY',572,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(573,NULL,'DUMMY',573,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(574,NULL,'DUMMY',574,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(575,NULL,'DUMMY',575,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(576,NULL,'DUMMY',576,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(577,NULL,'DUMMY',577,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(578,NULL,'DUMMY',578,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(579,NULL,'DUMMY',579,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(580,NULL,'DUMMY',580,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(581,NULL,'DUMMY',581,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(582,NULL,'DUMMY',582,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(583,NULL,'DUMMY',583,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(584,NULL,'DUMMY',584,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(585,NULL,'DUMMY',585,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(586,NULL,'DUMMY',586,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(587,NULL,'DUMMY',587,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(588,NULL,'DUMMY',588,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(589,NULL,'DUMMY',589,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(590,NULL,'DUMMY',590,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(591,NULL,'DUMMY',591,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(592,NULL,'DUMMY',592,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(593,NULL,'DUMMY',593,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(594,NULL,'DUMMY',594,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(595,NULL,'DUMMY',595,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(596,NULL,'DUMMY',596,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(597,NULL,'DUMMY',597,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(598,NULL,'DUMMY',598,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(599,NULL,'DUMMY',599,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(600,NULL,'DUMMY',600,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(601,NULL,'DUMMY',601,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(602,NULL,'DUMMY',602,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(603,NULL,'DUMMY',603,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(604,NULL,'DUMMY',604,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(605,NULL,'DUMMY',605,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(606,NULL,'DUMMY',606,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(607,NULL,'DUMMY',607,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(608,NULL,'DUMMY',608,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(609,NULL,'DUMMY',609,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(610,NULL,'DUMMY',610,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(611,NULL,'DUMMY',611,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(612,NULL,'DUMMY',612,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(613,NULL,'DUMMY',613,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(614,NULL,'DUMMY',614,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(615,NULL,'DUMMY',615,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(616,NULL,'DUMMY',616,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(617,NULL,'DUMMY',617,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(618,NULL,'DUMMY',618,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(619,NULL,'DUMMY',619,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(620,NULL,'DUMMY',620,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(621,NULL,'DUMMY',621,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(622,NULL,'DUMMY',622,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(623,NULL,'DUMMY',623,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(624,NULL,'DUMMY',624,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(625,NULL,'DUMMY',625,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(626,NULL,'DUMMY',626,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(627,NULL,'DUMMY',627,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(628,NULL,'DUMMY',628,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(629,NULL,'DUMMY',629,1,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(630,NULL,'DUMMY',630,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(631,NULL,'DUMMY',631,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(632,NULL,'DUMMY',632,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(633,NULL,'DUMMY',633,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(634,NULL,'DUMMY',634,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(635,NULL,'DUMMY',635,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(636,NULL,'DUMMY',636,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(637,NULL,'DUMMY',637,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(638,NULL,'DUMMY',638,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(639,NULL,'DUMMY',639,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(640,NULL,'DUMMY',640,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(641,NULL,'DUMMY',641,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(642,NULL,'DUMMY',642,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(643,NULL,'DUMMY',643,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(644,NULL,'DUMMY',644,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(645,NULL,'DUMMY',645,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(646,NULL,'DUMMY',646,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(647,NULL,'DUMMY',647,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(648,NULL,'DUMMY',648,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(649,NULL,'DUMMY',649,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(650,NULL,'DUMMY',650,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(651,NULL,'DUMMY',651,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(652,NULL,'DUMMY',652,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(653,NULL,'DUMMY',653,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(654,NULL,'DUMMY',654,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(655,NULL,'DUMMY',655,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(656,NULL,'DUMMY',656,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(657,NULL,'DUMMY',657,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(658,NULL,'DUMMY',658,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(659,NULL,'DUMMY',659,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(660,NULL,'DUMMY',660,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(661,NULL,'DUMMY',661,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(662,NULL,'DUMMY',662,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(663,NULL,'DUMMY',663,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(664,NULL,'DUMMY',664,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(665,NULL,'DUMMY',665,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(666,NULL,'DUMMY',666,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(667,NULL,'DUMMY',667,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(668,NULL,'DUMMY',668,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(669,NULL,'DUMMY',669,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(670,NULL,'DUMMY',670,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(671,NULL,'DUMMY',671,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(672,NULL,'DUMMY',672,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(673,NULL,'DUMMY',673,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(674,NULL,'DUMMY',674,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(675,NULL,'DUMMY',675,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(676,NULL,'DUMMY',676,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(677,NULL,'DUMMY',677,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(678,NULL,'DUMMY',678,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(679,NULL,'DUMMY',679,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(680,NULL,'DUMMY',680,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(681,NULL,'DUMMY',681,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(682,NULL,'DUMMY',682,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(683,NULL,'DUMMY',683,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(684,NULL,'DUMMY',684,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(685,NULL,'DUMMY',685,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(686,NULL,'DUMMY',686,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(687,NULL,'DUMMY',687,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(688,NULL,'DUMMY',688,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(689,NULL,'DUMMY',689,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(690,NULL,'DUMMY',690,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(691,NULL,'DUMMY',691,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(692,NULL,'DUMMY',692,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(693,NULL,'DUMMY',693,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(694,NULL,'DUMMY',694,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(695,NULL,'DUMMY',695,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(696,NULL,'DUMMY',696,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(697,NULL,'DUMMY',697,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(698,NULL,'DUMMY',698,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(699,NULL,'DUMMY',699,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(700,NULL,'DUMMY',700,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(701,NULL,'DUMMY',701,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(702,NULL,'DUMMY',702,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(703,NULL,'DUMMY',703,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(704,NULL,'DUMMY',704,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(705,NULL,'DUMMY',705,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(706,NULL,'DUMMY',706,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(707,NULL,'DUMMY',707,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(708,NULL,'DUMMY',708,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(709,NULL,'DUMMY',709,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(710,NULL,'DUMMY',710,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(711,NULL,'DUMMY',711,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(712,NULL,'DUMMY',712,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(713,NULL,'DUMMY',713,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(714,NULL,'DUMMY',714,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(715,NULL,'DUMMY',715,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(716,NULL,'DUMMY',716,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(717,NULL,'DUMMY',717,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(718,NULL,'DUMMY',718,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(719,NULL,'DUMMY',719,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(720,NULL,'DUMMY',720,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(721,NULL,'DUMMY',721,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(722,NULL,'DUMMY',722,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(723,NULL,'DUMMY',723,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(724,NULL,'DUMMY',724,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(725,NULL,'DUMMY',725,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(726,NULL,'DUMMY',726,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(727,NULL,'DUMMY',727,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(728,NULL,'DUMMY',728,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(729,NULL,'DUMMY',729,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(730,NULL,'DUMMY',730,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(731,NULL,'DUMMY',731,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(732,NULL,'DUMMY',732,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(733,NULL,'DUMMY',733,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(734,NULL,'DUMMY',734,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(735,NULL,'DUMMY',735,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(736,NULL,'DUMMY',736,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(737,NULL,'DUMMY',737,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(738,NULL,'DUMMY',738,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(739,NULL,'DUMMY',739,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(740,NULL,'DUMMY',740,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(741,NULL,'DUMMY',741,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(742,NULL,'DUMMY',742,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(743,NULL,'DUMMY',743,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(744,NULL,'DUMMY',744,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(745,NULL,'DUMMY',745,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(746,NULL,'DUMMY',746,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(747,NULL,'DUMMY',747,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(748,NULL,'DUMMY',748,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(749,NULL,'DUMMY',749,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(750,NULL,'DUMMY',750,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(751,NULL,'DUMMY',751,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(752,NULL,'DUMMY',752,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(753,NULL,'DUMMY',753,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(754,NULL,'DUMMY',754,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(755,NULL,'DUMMY',755,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(756,NULL,'DUMMY',756,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(757,NULL,'DUMMY',757,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(758,NULL,'DUMMY',758,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(759,NULL,'DUMMY',759,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(760,NULL,'DUMMY',760,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(761,NULL,'DUMMY',761,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(762,NULL,'DUMMY',762,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(763,NULL,'DUMMY',763,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(764,NULL,'DUMMY',764,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(765,NULL,'DUMMY',765,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(766,NULL,'DUMMY',766,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(767,NULL,'DUMMY',767,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(768,NULL,'DUMMY',768,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(769,NULL,'DUMMY',769,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(770,NULL,'DUMMY',770,1,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(771,NULL,'DUMMY',771,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(772,NULL,'DUMMY',772,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(773,NULL,'DUMMY',773,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(774,NULL,'DUMMY',774,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(775,NULL,'DUMMY',775,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(776,NULL,'DUMMY',776,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(777,NULL,'DUMMY',777,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(778,NULL,'DUMMY',778,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(779,NULL,'DUMMY',779,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(780,NULL,'DUMMY',780,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(781,NULL,'DUMMY',781,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(782,NULL,'DUMMY',782,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(783,NULL,'DUMMY',783,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(784,NULL,'DUMMY',784,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(785,NULL,'DUMMY',785,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(786,NULL,'DUMMY',786,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(787,NULL,'DUMMY',787,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(788,NULL,'DUMMY',788,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(789,NULL,'DUMMY',789,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(790,NULL,'DUMMY',790,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(791,NULL,'DUMMY',791,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(792,NULL,'DUMMY',792,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(793,NULL,'DUMMY',793,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(794,NULL,'DUMMY',794,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(795,NULL,'DUMMY',795,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(796,NULL,'DUMMY',796,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(797,NULL,'DUMMY',797,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(798,NULL,'DUMMY',798,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(799,NULL,'DUMMY',799,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(800,NULL,'DUMMY',800,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(801,NULL,'DUMMY',801,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(802,NULL,'DUMMY',802,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(803,NULL,'DUMMY',803,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(804,NULL,'DUMMY',804,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(805,NULL,'DUMMY',805,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(806,NULL,'DUMMY',806,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(807,NULL,'DUMMY',807,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(808,NULL,'DUMMY',808,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(809,NULL,'DUMMY',809,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(810,NULL,'DUMMY',810,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(811,NULL,'DUMMY',811,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(812,NULL,'DUMMY',812,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(813,NULL,'DUMMY',813,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(814,NULL,'DUMMY',814,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(815,NULL,'DUMMY',815,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(816,NULL,'DUMMY',816,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(817,NULL,'DUMMY',817,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(818,NULL,'DUMMY',818,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(819,NULL,'DUMMY',819,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(820,NULL,'DUMMY',820,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(821,NULL,'DUMMY',821,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(822,NULL,'DUMMY',822,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(823,NULL,'DUMMY',823,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(824,NULL,'DUMMY',824,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(825,NULL,'DUMMY',825,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(826,NULL,'DUMMY',826,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(827,NULL,'DUMMY',827,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(828,NULL,'DUMMY',828,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(829,NULL,'DUMMY',829,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(830,NULL,'DUMMY',830,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(831,NULL,'DUMMY',831,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(832,NULL,'DUMMY',832,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(833,NULL,'DUMMY',833,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(834,NULL,'DUMMY',834,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(835,NULL,'DUMMY',835,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(836,NULL,'DUMMY',836,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(837,NULL,'DUMMY',837,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(838,NULL,'DUMMY',838,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(839,NULL,'DUMMY',839,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(840,NULL,'DUMMY',840,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(841,NULL,'DUMMY',841,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(842,NULL,'DUMMY',842,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(843,NULL,'DUMMY',843,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(844,NULL,'DUMMY',844,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(845,NULL,'DUMMY',845,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(846,NULL,'DUMMY',846,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(847,NULL,'DUMMY',847,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(848,NULL,'DUMMY',848,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(849,NULL,'DUMMY',849,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(850,NULL,'DUMMY',850,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(851,NULL,'DUMMY',851,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(852,NULL,'DUMMY',852,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(853,NULL,'DUMMY',853,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(854,NULL,'DUMMY',854,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(855,NULL,'DUMMY',855,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(856,NULL,'DUMMY',856,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(857,NULL,'DUMMY',857,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(858,NULL,'DUMMY',858,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(859,NULL,'DUMMY',859,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(860,NULL,'DUMMY',860,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(861,NULL,'DUMMY',861,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(862,NULL,'DUMMY',862,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(863,NULL,'DUMMY',863,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(864,NULL,'DUMMY',864,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(865,NULL,'DUMMY',865,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(866,NULL,'DUMMY',866,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(867,NULL,'DUMMY',867,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(868,NULL,'DUMMY',868,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(869,NULL,'DUMMY',869,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(870,NULL,'DUMMY',870,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(871,NULL,'DUMMY',871,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(872,NULL,'DUMMY',872,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(873,NULL,'DUMMY',873,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(874,NULL,'DUMMY',874,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(875,NULL,'DUMMY',875,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(876,NULL,'DUMMY',876,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(877,NULL,'DUMMY',877,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(878,NULL,'DUMMY',878,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(879,NULL,'DUMMY',879,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(880,NULL,'DUMMY',880,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(881,NULL,'DUMMY',881,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(882,NULL,'DUMMY',882,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(883,NULL,'DUMMY',883,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(884,NULL,'DUMMY',884,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(885,NULL,'DUMMY',885,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(886,NULL,'DUMMY',886,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(887,NULL,'DUMMY',887,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(888,NULL,'DUMMY',888,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(889,NULL,'DUMMY',889,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(890,NULL,'DUMMY',890,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(891,NULL,'DUMMY',891,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(892,NULL,'DUMMY',892,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(893,NULL,'DUMMY',893,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(894,NULL,'DUMMY',894,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(895,NULL,'DUMMY',895,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(896,NULL,'DUMMY',896,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(897,NULL,'DUMMY',897,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(898,NULL,'DUMMY',898,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(899,NULL,'DUMMY',899,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(900,NULL,'DUMMY',900,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(901,NULL,'DUMMY',901,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(902,NULL,'DUMMY',902,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(903,NULL,'DUMMY',903,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(904,NULL,'DUMMY',904,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(905,NULL,'DUMMY',905,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(906,NULL,'DUMMY',906,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(907,NULL,'DUMMY',907,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(908,NULL,'DUMMY',908,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(909,NULL,'DUMMY',909,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(910,NULL,'DUMMY',910,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(911,NULL,'DUMMY',911,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(912,NULL,'DUMMY',912,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(913,NULL,'DUMMY',913,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(914,NULL,'DUMMY',914,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(915,NULL,'DUMMY',915,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(916,NULL,'DUMMY',916,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(917,NULL,'DUMMY',917,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(918,NULL,'DUMMY',918,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(919,NULL,'DUMMY',919,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(920,NULL,'DUMMY',920,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(921,NULL,'DUMMY',921,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(922,NULL,'DUMMY',922,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(923,NULL,'DUMMY',923,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(924,NULL,'DUMMY',924,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(925,NULL,'DUMMY',925,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(926,NULL,'DUMMY',926,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(927,NULL,'DUMMY',927,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(928,NULL,'DUMMY',928,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(929,NULL,'DUMMY',929,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(930,NULL,'DUMMY',930,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(931,NULL,'DUMMY',931,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(932,NULL,'DUMMY',932,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(933,NULL,'DUMMY',933,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(934,NULL,'DUMMY',934,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(935,NULL,'DUMMY',935,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(936,NULL,'DUMMY',936,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(937,NULL,'DUMMY',937,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(938,NULL,'DUMMY',938,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(939,NULL,'DUMMY',939,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(940,NULL,'DUMMY',940,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(941,NULL,'DUMMY',941,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(942,NULL,'DUMMY',942,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(943,NULL,'DUMMY',943,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(944,NULL,'DUMMY',944,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(945,NULL,'DUMMY',945,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(946,NULL,'DUMMY',946,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(947,NULL,'DUMMY',947,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(948,NULL,'DUMMY',948,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(949,NULL,'DUMMY',949,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(950,NULL,'DUMMY',950,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(951,NULL,'DUMMY',951,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(952,NULL,'DUMMY',952,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(953,NULL,'DUMMY',953,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(954,NULL,'DUMMY',954,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(955,NULL,'DUMMY',955,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(956,NULL,'DUMMY',956,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(957,NULL,'DUMMY',957,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(958,NULL,'DUMMY',958,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(959,NULL,'DUMMY',959,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(960,NULL,'DUMMY',960,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(961,NULL,'DUMMY',961,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(962,NULL,'DUMMY',962,1,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(963,NULL,'DUMMY',963,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(964,NULL,'DUMMY',964,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(965,NULL,'DUMMY',965,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(966,NULL,'DUMMY',966,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(967,NULL,'DUMMY',967,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(968,NULL,'DUMMY',968,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(969,NULL,'DUMMY',969,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(970,NULL,'DUMMY',970,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(971,NULL,'DUMMY',971,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(972,NULL,'DUMMY',972,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(973,NULL,'DUMMY',973,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(974,NULL,'DUMMY',974,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(975,NULL,'DUMMY',975,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(976,NULL,'DUMMY',976,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(977,NULL,'DUMMY',977,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(978,NULL,'DUMMY',978,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(979,NULL,'DUMMY',979,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(980,NULL,'DUMMY',980,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(981,NULL,'DUMMY',981,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(982,NULL,'DUMMY',982,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(983,NULL,'DUMMY',983,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(984,NULL,'DUMMY',984,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(985,NULL,'DUMMY',985,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(986,NULL,'DUMMY',986,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(987,NULL,'DUMMY',987,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(988,NULL,'DUMMY',988,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(989,NULL,'DUMMY',989,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(990,NULL,'DUMMY',990,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(991,NULL,'DUMMY',991,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(992,NULL,'DUMMY',992,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(993,NULL,'DUMMY',993,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(994,NULL,'DUMMY',994,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(995,NULL,'DUMMY',995,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(996,NULL,'DUMMY',996,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(997,NULL,'DUMMY',997,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(998,NULL,'DUMMY',998,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(999,NULL,'DUMMY',999,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1000,NULL,'DUMMY',1000,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1001,NULL,'DUMMY',1001,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1002,NULL,'DUMMY',1002,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1003,NULL,'DUMMY',1003,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1004,NULL,'DUMMY',1004,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1005,NULL,'DUMMY',1005,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1006,NULL,'DUMMY',1006,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1007,NULL,'DUMMY',1007,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1008,NULL,'DUMMY',1008,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1009,NULL,'DUMMY',1009,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1010,NULL,'DUMMY',1010,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1011,NULL,'DUMMY',1011,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1012,NULL,'DUMMY',1012,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1013,NULL,'DUMMY',1013,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1014,NULL,'DUMMY',1014,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1015,NULL,'DUMMY',1015,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1016,NULL,'DUMMY',1016,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1017,NULL,'DUMMY',1017,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1018,NULL,'DUMMY',1018,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1019,NULL,'DUMMY',1019,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1020,NULL,'DUMMY',1020,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1021,NULL,'DUMMY',1021,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1022,NULL,'DUMMY',1022,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1023,NULL,'DUMMY',1023,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1024,NULL,'DUMMY',1024,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1025,NULL,'DUMMY',1025,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1026,NULL,'DUMMY',1026,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1027,NULL,'DUMMY',1027,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1028,NULL,'DUMMY',1028,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1029,NULL,'DUMMY',1029,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1030,NULL,'DUMMY',1030,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1031,NULL,'DUMMY',1031,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1032,NULL,'DUMMY',1032,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1033,NULL,'DUMMY',1033,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1034,NULL,'DUMMY',1034,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1035,NULL,'DUMMY',1035,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1036,NULL,'DUMMY',1036,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1037,NULL,'DUMMY',1037,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1038,NULL,'DUMMY',1038,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1039,NULL,'DUMMY',1039,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1040,NULL,'DUMMY',1040,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1041,NULL,'DUMMY',1041,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1042,NULL,'DUMMY',1042,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1043,NULL,'DUMMY',1043,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1044,NULL,'DUMMY',1044,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1045,NULL,'DUMMY',1045,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1046,NULL,'DUMMY',1046,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1047,NULL,'DUMMY',1047,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1048,NULL,'DUMMY',1048,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1049,NULL,'DUMMY',1049,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1050,NULL,'DUMMY',1050,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1051,NULL,'DUMMY',1051,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1052,NULL,'DUMMY',1052,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1053,NULL,'DUMMY',1053,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1054,NULL,'DUMMY',1054,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1055,NULL,'DUMMY',1055,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1056,NULL,'DUMMY',1056,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1057,NULL,'DUMMY',1057,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1058,NULL,'DUMMY',1058,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1059,NULL,'DUMMY',1059,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1060,NULL,'DUMMY',1060,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1061,NULL,'DUMMY',1061,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1062,NULL,'DUMMY',1062,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1063,NULL,'DUMMY',1063,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1064,NULL,'DUMMY',1064,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1065,NULL,'DUMMY',1065,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1066,NULL,'DUMMY',1066,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1067,NULL,'DUMMY',1067,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1068,NULL,'DUMMY',1068,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1069,NULL,'DUMMY',1069,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1070,NULL,'DUMMY',1070,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1071,NULL,'DUMMY',1071,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1072,NULL,'DUMMY',1072,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1073,NULL,'DUMMY',1073,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1074,NULL,'DUMMY',1074,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1075,NULL,'DUMMY',1075,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1076,NULL,'DUMMY',1076,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1077,NULL,'DUMMY',1077,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1078,NULL,'DUMMY',1078,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1079,NULL,'DUMMY',1079,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1080,NULL,'DUMMY',1080,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1081,NULL,'DUMMY',1081,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1082,NULL,'DUMMY',1082,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1083,NULL,'DUMMY',1083,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1084,NULL,'DUMMY',1084,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1085,NULL,'DUMMY',1085,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1086,NULL,'DUMMY',1086,1,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1087,NULL,'DUMMY',1087,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1088,NULL,'DUMMY',1088,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1089,NULL,'DUMMY',1089,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1090,NULL,'DUMMY',1090,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1091,NULL,'DUMMY',1091,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1092,NULL,'DUMMY',1092,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1093,NULL,'DUMMY',1093,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1094,NULL,'DUMMY',1094,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1095,NULL,'DUMMY',1095,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1096,NULL,'DUMMY',1096,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1097,NULL,'DUMMY',1097,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1098,NULL,'DUMMY',1098,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1099,NULL,'DUMMY',1099,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1100,NULL,'DUMMY',1100,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1101,NULL,'DUMMY',1101,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1102,NULL,'DUMMY',1102,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1103,NULL,'DUMMY',1103,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1104,NULL,'DUMMY',1104,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1105,NULL,'DUMMY',1105,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1106,NULL,'DUMMY',1106,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1107,NULL,'DUMMY',1107,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1108,NULL,'DUMMY',1108,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1109,NULL,'DUMMY',1109,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1110,NULL,'DUMMY',1110,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1111,NULL,'DUMMY',1111,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1112,NULL,'DUMMY',1112,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1113,NULL,'DUMMY',1113,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1114,NULL,'DUMMY',1114,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1115,NULL,'DUMMY',1115,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1116,NULL,'DUMMY',1116,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1117,NULL,'DUMMY',1117,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1118,NULL,'DUMMY',1118,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1119,NULL,'DUMMY',1119,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1120,NULL,'DUMMY',1120,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1121,NULL,'DUMMY',1121,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1122,NULL,'DUMMY',1122,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1123,NULL,'DUMMY',1123,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1124,NULL,'DUMMY',1124,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1125,NULL,'DUMMY',1125,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1126,NULL,'DUMMY',1126,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1127,NULL,'DUMMY',1127,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1128,NULL,'DUMMY',1128,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1129,NULL,'DUMMY',1129,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1130,NULL,'DUMMY',1130,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1131,NULL,'DUMMY',1131,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1132,NULL,'DUMMY',1132,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1133,NULL,'DUMMY',1133,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1134,NULL,'DUMMY',1134,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1135,NULL,'DUMMY',1135,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1136,NULL,'DUMMY',1136,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1137,NULL,'DUMMY',1137,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1138,NULL,'DUMMY',1138,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1139,NULL,'DUMMY',1139,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1140,NULL,'DUMMY',1140,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1141,NULL,'DUMMY',1141,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1142,NULL,'DUMMY',1142,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1143,NULL,'DUMMY',1143,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1144,NULL,'DUMMY',1144,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1145,NULL,'DUMMY',1145,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1146,NULL,'DUMMY',1146,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1147,NULL,'DUMMY',1147,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1148,NULL,'DUMMY',1148,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1149,NULL,'DUMMY',1149,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1150,NULL,'DUMMY',1150,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1151,NULL,'DUMMY',1151,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1152,NULL,'DUMMY',1152,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1153,NULL,'DUMMY',1153,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1154,NULL,'DUMMY',1154,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1155,NULL,'DUMMY',1155,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1156,NULL,'DUMMY',1156,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1157,NULL,'DUMMY',1157,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1158,NULL,'DUMMY',1158,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1159,NULL,'DUMMY',1159,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1160,NULL,'DUMMY',1160,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1161,NULL,'DUMMY',1161,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1162,NULL,'DUMMY',1162,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1163,NULL,'DUMMY',1163,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1164,NULL,'DUMMY',1164,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1165,NULL,'DUMMY',1165,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1166,NULL,'DUMMY',1166,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1167,NULL,'DUMMY',1167,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1168,NULL,'DUMMY',1168,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1169,NULL,'DUMMY',1169,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1170,NULL,'DUMMY',1170,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1171,NULL,'DUMMY',1171,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1172,NULL,'DUMMY',1172,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1173,NULL,'DUMMY',1173,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1174,NULL,'DUMMY',1174,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1175,NULL,'DUMMY',1175,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1176,NULL,'DUMMY',1176,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1177,NULL,'DUMMY',1177,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1178,NULL,'DUMMY',1178,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1179,NULL,'DUMMY',1179,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1180,NULL,'DUMMY',1180,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1181,NULL,'DUMMY',1181,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1182,NULL,'DUMMY',1182,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1183,NULL,'DUMMY',1183,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1184,NULL,'DUMMY',1184,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1185,NULL,'DUMMY',1185,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1186,NULL,'DUMMY',1186,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1187,NULL,'DUMMY',1187,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1188,NULL,'DUMMY',1188,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1189,NULL,'DUMMY',1189,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1190,NULL,'DUMMY',1190,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1191,NULL,'DUMMY',1191,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1192,NULL,'DUMMY',1192,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1193,NULL,'DUMMY',1193,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1194,NULL,'DUMMY',1194,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1195,NULL,'DUMMY',1195,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1196,NULL,'DUMMY',1196,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1197,NULL,'DUMMY',1197,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1198,NULL,'DUMMY',1198,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1199,NULL,'DUMMY',1199,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1200,NULL,'DUMMY',1200,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1201,NULL,'DUMMY',1201,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1202,NULL,'DUMMY',1202,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1203,NULL,'DUMMY',1203,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1204,NULL,'DUMMY',1204,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1205,NULL,'DUMMY',1205,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1206,NULL,'DUMMY',1206,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1207,NULL,'DUMMY',1207,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1208,NULL,'DUMMY',1208,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1209,NULL,'DUMMY',1209,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1210,NULL,'DUMMY',1210,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1211,NULL,'DUMMY',1211,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1212,NULL,'DUMMY',1212,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1213,NULL,'DUMMY',1213,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1214,NULL,'DUMMY',1214,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1215,NULL,'DUMMY',1215,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1216,NULL,'DUMMY',1216,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1217,NULL,'DUMMY',1217,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1218,NULL,'DUMMY',1218,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1219,NULL,'DUMMY',1219,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1220,NULL,'DUMMY',1220,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1221,NULL,'DUMMY',1221,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1222,NULL,'DUMMY',1222,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1223,NULL,'DUMMY',1223,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1224,NULL,'DUMMY',1224,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1225,NULL,'DUMMY',1225,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1226,NULL,'DUMMY',1226,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1227,NULL,'DUMMY',1227,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1228,NULL,'DUMMY',1228,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1229,NULL,'DUMMY',1229,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1230,NULL,'DUMMY',1230,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1231,NULL,'DUMMY',1231,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1232,NULL,'DUMMY',1232,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1233,NULL,'DUMMY',1233,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1234,NULL,'DUMMY',1234,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1235,NULL,'DUMMY',1235,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1236,NULL,'DUMMY',1236,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1237,NULL,'DUMMY',1237,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1238,NULL,'DUMMY',1238,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1239,NULL,'DUMMY',1239,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1240,NULL,'DUMMY',1240,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1241,NULL,'DUMMY',1241,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1242,NULL,'DUMMY',1242,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1243,NULL,'DUMMY',1243,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1244,NULL,'DUMMY',1244,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1245,NULL,'DUMMY',1245,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1246,NULL,'DUMMY',1246,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1247,NULL,'DUMMY',1247,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1248,NULL,'DUMMY',1248,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1249,NULL,'DUMMY',1249,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1250,NULL,'DUMMY',1250,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1251,NULL,'DUMMY',1251,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1252,NULL,'DUMMY',1252,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1253,NULL,'DUMMY',1253,1,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1254,NULL,'DUMMY',1254,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1255,NULL,'DUMMY',1255,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1256,NULL,'DUMMY',1256,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1257,NULL,'DUMMY',1257,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1258,NULL,'DUMMY',1258,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1259,NULL,'DUMMY',1259,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1260,NULL,'DUMMY',1260,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1261,NULL,'DUMMY',1261,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1262,NULL,'DUMMY',1262,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1263,NULL,'DUMMY',1263,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1264,NULL,'DUMMY',1264,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1265,NULL,'DUMMY',1265,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1266,NULL,'DUMMY',1266,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1267,NULL,'DUMMY',1267,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1268,NULL,'DUMMY',1268,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1269,NULL,'DUMMY',1269,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1270,NULL,'DUMMY',1270,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1271,NULL,'DUMMY',1271,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1272,NULL,'DUMMY',1272,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1273,NULL,'DUMMY',1273,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1274,NULL,'DUMMY',1274,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1275,NULL,'DUMMY',1275,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1276,NULL,'DUMMY',1276,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1277,NULL,'DUMMY',1277,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1278,NULL,'DUMMY',1278,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1279,NULL,'DUMMY',1279,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1280,NULL,'DUMMY',1280,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1281,NULL,'DUMMY',1281,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1282,NULL,'DUMMY',1282,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1283,NULL,'DUMMY',1283,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1284,NULL,'DUMMY',1284,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1285,NULL,'DUMMY',1285,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1286,NULL,'DUMMY',1286,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1287,NULL,'DUMMY',1287,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1288,NULL,'DUMMY',1288,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1289,NULL,'DUMMY',1289,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1290,NULL,'DUMMY',1290,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1291,NULL,'DUMMY',1291,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1292,NULL,'DUMMY',1292,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1293,NULL,'DUMMY',1293,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1294,NULL,'DUMMY',1294,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1295,NULL,'DUMMY',1295,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1296,NULL,'DUMMY',1296,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1297,NULL,'DUMMY',1297,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1298,NULL,'DUMMY',1298,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1299,NULL,'DUMMY',1299,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1300,NULL,'DUMMY',1300,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1301,NULL,'DUMMY',1301,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1302,NULL,'DUMMY',1302,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1303,NULL,'DUMMY',1303,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1304,NULL,'DUMMY',1304,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1305,NULL,'DUMMY',1305,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1306,NULL,'DUMMY',1306,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1307,NULL,'DUMMY',1307,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1308,NULL,'DUMMY',1308,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1309,NULL,'DUMMY',1309,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1310,NULL,'DUMMY',1310,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1311,NULL,'DUMMY',1311,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1312,NULL,'DUMMY',1312,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1313,NULL,'DUMMY',1313,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1314,NULL,'DUMMY',1314,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1315,NULL,'DUMMY',1315,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1316,NULL,'DUMMY',1316,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1317,NULL,'DUMMY',1317,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1318,NULL,'DUMMY',1318,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1319,NULL,'DUMMY',1319,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1320,NULL,'DUMMY',1320,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1321,NULL,'DUMMY',1321,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1322,NULL,'DUMMY',1322,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1323,NULL,'DUMMY',1323,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1324,NULL,'DUMMY',1324,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1325,NULL,'DUMMY',1325,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1326,NULL,'DUMMY',1326,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1327,NULL,'DUMMY',1327,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1328,NULL,'DUMMY',1328,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1329,NULL,'DUMMY',1329,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1330,NULL,'DUMMY',1330,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1331,NULL,'DUMMY',1331,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1332,NULL,'DUMMY',1332,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1333,NULL,'DUMMY',1333,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1334,NULL,'DUMMY',1334,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1335,NULL,'DUMMY',1335,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1336,NULL,'DUMMY',1336,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1337,NULL,'DUMMY',1337,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1338,NULL,'DUMMY',1338,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1339,NULL,'DUMMY',1339,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1340,NULL,'DUMMY',1340,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1341,NULL,'DUMMY',1341,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1342,NULL,'DUMMY',1342,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1343,NULL,'DUMMY',1343,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1344,NULL,'DUMMY',1344,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1345,NULL,'DUMMY',1345,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1346,NULL,'DUMMY',1346,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1347,NULL,'DUMMY',1347,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1348,NULL,'DUMMY',1348,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1349,NULL,'DUMMY',1349,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1350,NULL,'DUMMY',1350,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1351,NULL,'DUMMY',1351,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1352,NULL,'DUMMY',1352,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1353,NULL,'DUMMY',1353,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1354,NULL,'DUMMY',1354,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1355,NULL,'DUMMY',1355,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1356,NULL,'DUMMY',1356,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1357,NULL,'DUMMY',1357,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1358,NULL,'DUMMY',1358,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1359,NULL,'DUMMY',1359,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1360,NULL,'DUMMY',1360,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1361,NULL,'DUMMY',1361,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1362,NULL,'DUMMY',1362,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1363,NULL,'DUMMY',1363,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1364,NULL,'DUMMY',1364,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1365,NULL,'DUMMY',1365,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1366,NULL,'DUMMY',1366,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1367,NULL,'DUMMY',1367,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1368,NULL,'DUMMY',1368,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1369,NULL,'DUMMY',1369,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1370,NULL,'DUMMY',1370,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1371,NULL,'DUMMY',1371,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1372,NULL,'DUMMY',1372,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1373,NULL,'DUMMY',1373,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1374,NULL,'DUMMY',1374,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1375,NULL,'DUMMY',1375,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1376,NULL,'DUMMY',1376,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1377,NULL,'DUMMY',1377,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1378,NULL,'DUMMY',1378,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1379,NULL,'DUMMY',1379,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1380,NULL,'DUMMY',1380,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1381,NULL,'DUMMY',1381,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1382,NULL,'DUMMY',1382,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1383,NULL,'DUMMY',1383,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1384,NULL,'DUMMY',1384,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1385,NULL,'DUMMY',1385,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1386,NULL,'DUMMY',1386,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1387,NULL,'DUMMY',1387,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1388,NULL,'DUMMY',1388,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1389,NULL,'DUMMY',1389,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1390,NULL,'DUMMY',1390,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1391,NULL,'DUMMY',1391,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1392,NULL,'DUMMY',1392,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1393,NULL,'DUMMY',1393,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1394,NULL,'DUMMY',1394,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1395,NULL,'DUMMY',1395,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1396,NULL,'DUMMY',1396,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1397,NULL,'DUMMY',1397,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1398,NULL,'DUMMY',1398,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1399,NULL,'DUMMY',1399,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1400,NULL,'DUMMY',1400,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1401,NULL,'DUMMY',1401,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1402,NULL,'DUMMY',1402,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1403,NULL,'DUMMY',1403,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1404,NULL,'DUMMY',1404,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1405,NULL,'DUMMY',1405,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1406,NULL,'DUMMY',1406,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1407,NULL,'DUMMY',1407,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1408,NULL,'DUMMY',1408,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1409,NULL,'DUMMY',1409,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1410,NULL,'DUMMY',1410,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1411,NULL,'DUMMY',1411,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1412,NULL,'DUMMY',1412,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1413,NULL,'DUMMY',1413,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1414,NULL,'DUMMY',1414,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1415,NULL,'DUMMY',1415,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1416,NULL,'DUMMY',1416,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1417,NULL,'DUMMY',1417,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1418,NULL,'DUMMY',1418,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1419,NULL,'DUMMY',1419,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1420,NULL,'DUMMY',1420,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1421,NULL,'DUMMY',1421,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1422,NULL,'DUMMY',1422,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1423,NULL,'DUMMY',1423,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1424,NULL,'DUMMY',1424,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1425,NULL,'DUMMY',1425,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1426,NULL,'DUMMY',1426,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1427,NULL,'DUMMY',1427,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1428,NULL,'DUMMY',1428,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1429,NULL,'DUMMY',1429,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1430,NULL,'DUMMY',1430,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1431,NULL,'DUMMY',1431,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1432,NULL,'DUMMY',1432,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1433,NULL,'DUMMY',1433,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1434,NULL,'DUMMY',1434,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1435,NULL,'DUMMY',1435,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1436,NULL,'DUMMY',1436,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1437,NULL,'DUMMY',1437,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1438,NULL,'DUMMY',1438,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1439,NULL,'DUMMY',1439,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1440,NULL,'DUMMY',1440,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1441,NULL,'DUMMY',1441,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1442,NULL,'DUMMY',1442,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1443,NULL,'DUMMY',1443,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1444,NULL,'DUMMY',1444,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1445,NULL,'DUMMY',1445,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1446,NULL,'DUMMY',1446,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1447,NULL,'DUMMY',1447,1,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1448,NULL,'DUMMY',1448,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1449,NULL,'DUMMY',1449,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1450,NULL,'DUMMY',1450,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1451,NULL,'DUMMY',1451,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1452,NULL,'DUMMY',1452,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1453,NULL,'DUMMY',1453,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1454,NULL,'DUMMY',1454,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1455,NULL,'DUMMY',1455,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1456,NULL,'DUMMY',1456,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1457,NULL,'DUMMY',1457,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1458,NULL,'DUMMY',1458,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1459,NULL,'DUMMY',1459,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1460,NULL,'DUMMY',1460,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1461,NULL,'DUMMY',1461,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1462,NULL,'DUMMY',1462,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1463,NULL,'DUMMY',1463,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1464,NULL,'DUMMY',1464,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1465,NULL,'DUMMY',1465,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1466,NULL,'DUMMY',1466,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1467,NULL,'DUMMY',1467,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1468,NULL,'DUMMY',1468,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1469,NULL,'DUMMY',1469,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1470,NULL,'DUMMY',1470,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1471,NULL,'DUMMY',1471,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1472,NULL,'DUMMY',1472,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1473,NULL,'DUMMY',1473,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1474,NULL,'DUMMY',1474,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1475,NULL,'DUMMY',1475,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1476,NULL,'DUMMY',1476,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1477,NULL,'DUMMY',1477,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1478,NULL,'DUMMY',1478,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1479,NULL,'DUMMY',1479,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1480,NULL,'DUMMY',1480,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1481,NULL,'DUMMY',1481,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1482,NULL,'DUMMY',1482,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1483,NULL,'DUMMY',1483,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1484,NULL,'DUMMY',1484,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1485,NULL,'DUMMY',1485,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1486,NULL,'DUMMY',1486,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1487,NULL,'DUMMY',1487,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1488,NULL,'DUMMY',1488,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1489,NULL,'DUMMY',1489,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1490,NULL,'DUMMY',1490,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1491,NULL,'DUMMY',1491,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1492,NULL,'DUMMY',1492,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1493,NULL,'DUMMY',1493,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1494,NULL,'DUMMY',1494,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1495,NULL,'DUMMY',1495,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1496,NULL,'DUMMY',1496,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1497,NULL,'DUMMY',1497,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1498,NULL,'DUMMY',1498,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1499,NULL,'DUMMY',1499,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1500,NULL,'DUMMY',1500,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1501,NULL,'DUMMY',1501,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1502,NULL,'DUMMY',1502,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1503,NULL,'DUMMY',1503,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1504,NULL,'DUMMY',1504,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1505,NULL,'DUMMY',1505,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1506,NULL,'DUMMY',1506,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1507,NULL,'DUMMY',1507,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1508,NULL,'DUMMY',1508,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1509,NULL,'DUMMY',1509,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1510,NULL,'DUMMY',1510,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1511,NULL,'DUMMY',1511,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1512,NULL,'DUMMY',1512,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1513,NULL,'DUMMY',1513,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1514,NULL,'DUMMY',1514,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1515,NULL,'DUMMY',1515,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1516,NULL,'DUMMY',1516,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1517,NULL,'DUMMY',1517,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1518,NULL,'DUMMY',1518,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1519,NULL,'DUMMY',1519,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1520,NULL,'DUMMY',1520,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1521,NULL,'DUMMY',1521,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1522,NULL,'DUMMY',1522,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1523,NULL,'DUMMY',1523,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1524,NULL,'DUMMY',1524,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1525,NULL,'DUMMY',1525,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1526,NULL,'DUMMY',1526,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1527,NULL,'DUMMY',1527,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1528,NULL,'DUMMY',1528,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1529,NULL,'DUMMY',1529,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1530,NULL,'DUMMY',1530,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1531,NULL,'DUMMY',1531,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1532,NULL,'DUMMY',1532,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1533,NULL,'DUMMY',1533,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1534,NULL,'DUMMY',1534,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1535,NULL,'DUMMY',1535,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1536,NULL,'DUMMY',1536,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1537,NULL,'DUMMY',1537,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1538,NULL,'DUMMY',1538,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1539,NULL,'DUMMY',1539,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1540,NULL,'DUMMY',1540,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1541,NULL,'DUMMY',1541,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1542,NULL,'DUMMY',1542,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1543,NULL,'DUMMY',1543,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1544,NULL,'DUMMY',1544,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1545,NULL,'DUMMY',1545,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1546,NULL,'DUMMY',1546,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1547,NULL,'DUMMY',1547,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1548,NULL,'DUMMY',1548,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1549,NULL,'DUMMY',1549,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1550,NULL,'DUMMY',1550,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1551,NULL,'DUMMY',1551,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1552,NULL,'DUMMY',1552,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1553,NULL,'DUMMY',1553,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1554,NULL,'DUMMY',1554,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1555,NULL,'DUMMY',1555,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1556,NULL,'DUMMY',1556,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1557,NULL,'DUMMY',1557,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1558,NULL,'DUMMY',1558,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1559,NULL,'DUMMY',1559,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1560,NULL,'DUMMY',1560,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1561,NULL,'DUMMY',1561,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1562,NULL,'DUMMY',1562,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1563,NULL,'DUMMY',1563,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1564,NULL,'DUMMY',1564,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1565,NULL,'DUMMY',1565,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1566,NULL,'DUMMY',1566,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1567,NULL,'DUMMY',1567,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1568,NULL,'DUMMY',1568,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1569,NULL,'DUMMY',1569,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1570,NULL,'DUMMY',1570,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1571,NULL,'DUMMY',1571,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1572,NULL,'DUMMY',1572,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1573,NULL,'DUMMY',1573,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1574,NULL,'DUMMY',1574,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1575,NULL,'DUMMY',1575,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1576,NULL,'DUMMY',1576,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1577,NULL,'DUMMY',1577,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1578,NULL,'DUMMY',1578,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1579,NULL,'DUMMY',1579,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1580,NULL,'DUMMY',1580,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1581,NULL,'DUMMY',1581,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1582,NULL,'DUMMY',1582,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1583,NULL,'DUMMY',1583,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1584,NULL,'DUMMY',1584,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1585,NULL,'DUMMY',1585,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1586,NULL,'DUMMY',1586,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1587,NULL,'DUMMY',1587,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1588,NULL,'DUMMY',1588,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1589,NULL,'DUMMY',1589,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1590,NULL,'DUMMY',1590,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1591,NULL,'DUMMY',1591,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1592,NULL,'DUMMY',1592,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1593,NULL,'DUMMY',1593,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1594,NULL,'DUMMY',1594,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1595,NULL,'DUMMY',1595,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1596,NULL,'DUMMY',1596,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1597,NULL,'DUMMY',1597,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1598,NULL,'DUMMY',1598,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1599,NULL,'DUMMY',1599,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1600,NULL,'DUMMY',1600,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1601,NULL,'DUMMY',1601,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1602,NULL,'DUMMY',1602,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1603,NULL,'DUMMY',1603,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1604,NULL,'DUMMY',1604,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1605,NULL,'DUMMY',1605,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1606,NULL,'DUMMY',1606,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1607,NULL,'DUMMY',1607,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1608,NULL,'DUMMY',1608,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1609,NULL,'DUMMY',1609,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1610,NULL,'DUMMY',1610,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1611,NULL,'DUMMY',1611,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1612,NULL,'DUMMY',1612,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1613,NULL,'DUMMY',1613,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1614,NULL,'DUMMY',1614,1,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1615,NULL,'DUMMY',1615,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1616,NULL,'DUMMY',1616,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1617,NULL,'DUMMY',1617,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1618,NULL,'DUMMY',1618,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1619,NULL,'DUMMY',1619,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1620,NULL,'DUMMY',1620,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1621,NULL,'DUMMY',1621,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1622,NULL,'DUMMY',1622,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1623,NULL,'DUMMY',1623,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1624,NULL,'DUMMY',1624,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1625,NULL,'DUMMY',1625,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1626,NULL,'DUMMY',1626,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1627,NULL,'DUMMY',1627,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1628,NULL,'DUMMY',1628,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1629,NULL,'DUMMY',1629,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1630,NULL,'DUMMY',1630,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1631,NULL,'DUMMY',1631,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1632,NULL,'DUMMY',1632,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1633,NULL,'DUMMY',1633,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1634,NULL,'DUMMY',1634,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1635,NULL,'DUMMY',1635,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1636,NULL,'DUMMY',1636,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1637,NULL,'DUMMY',1637,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1638,NULL,'DUMMY',1638,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1639,NULL,'DUMMY',1639,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1640,NULL,'DUMMY',1640,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1641,NULL,'DUMMY',1641,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1642,NULL,'DUMMY',1642,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1643,NULL,'DUMMY',1643,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1644,NULL,'DUMMY',1644,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1645,NULL,'DUMMY',1645,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1646,NULL,'DUMMY',1646,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1647,NULL,'DUMMY',1647,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1648,NULL,'DUMMY',1648,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1649,NULL,'DUMMY',1649,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1650,NULL,'DUMMY',1650,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1651,NULL,'DUMMY',1651,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1652,NULL,'DUMMY',1652,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1653,NULL,'DUMMY',1653,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1654,NULL,'DUMMY',1654,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1655,NULL,'DUMMY',1655,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1656,NULL,'DUMMY',1656,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1657,NULL,'DUMMY',1657,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1658,NULL,'DUMMY',1658,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1659,NULL,'DUMMY',1659,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1660,NULL,'DUMMY',1660,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1661,NULL,'DUMMY',1661,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1662,NULL,'DUMMY',1662,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1663,NULL,'DUMMY',1663,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1664,NULL,'DUMMY',1664,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1665,NULL,'DUMMY',1665,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1666,NULL,'DUMMY',1666,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1667,NULL,'DUMMY',1667,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1668,NULL,'DUMMY',1668,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1669,NULL,'DUMMY',1669,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1670,NULL,'DUMMY',1670,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1671,NULL,'DUMMY',1671,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1672,NULL,'DUMMY',1672,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1673,NULL,'DUMMY',1673,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1674,NULL,'DUMMY',1674,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1675,NULL,'DUMMY',1675,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1676,NULL,'DUMMY',1676,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1677,NULL,'DUMMY',1677,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1678,NULL,'DUMMY',1678,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1679,NULL,'DUMMY',1679,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1680,NULL,'DUMMY',1680,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1681,NULL,'DUMMY',1681,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1682,NULL,'DUMMY',1682,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1683,NULL,'DUMMY',1683,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1684,NULL,'DUMMY',1684,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1685,NULL,'DUMMY',1685,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1686,NULL,'DUMMY',1686,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1687,NULL,'DUMMY',1687,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1688,NULL,'DUMMY',1688,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1689,NULL,'DUMMY',1689,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1690,NULL,'DUMMY',1690,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1691,NULL,'DUMMY',1691,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1692,NULL,'DUMMY',1692,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1693,NULL,'DUMMY',1693,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1694,NULL,'DUMMY',1694,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1695,NULL,'DUMMY',1695,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1696,NULL,'DUMMY',1696,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1697,NULL,'DUMMY',1697,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1698,NULL,'DUMMY',1698,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1699,NULL,'DUMMY',1699,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1700,NULL,'DUMMY',1700,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1701,NULL,'DUMMY',1701,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1702,NULL,'DUMMY',1702,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1703,NULL,'DUMMY',1703,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1704,NULL,'DUMMY',1704,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1705,NULL,'DUMMY',1705,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1706,NULL,'DUMMY',1706,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1707,NULL,'DUMMY',1707,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1708,NULL,'DUMMY',1708,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1709,NULL,'DUMMY',1709,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1710,NULL,'DUMMY',1710,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1711,NULL,'DUMMY',1711,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1712,NULL,'DUMMY',1712,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1713,NULL,'DUMMY',1713,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1714,NULL,'DUMMY',1714,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1715,NULL,'DUMMY',1715,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1716,NULL,'DUMMY',1716,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1717,NULL,'DUMMY',1717,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1718,NULL,'DUMMY',1718,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1719,NULL,'DUMMY',1719,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1720,NULL,'DUMMY',1720,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1721,NULL,'DUMMY',1721,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1722,NULL,'DUMMY',1722,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1723,NULL,'DUMMY',1723,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1724,NULL,'DUMMY',1724,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1725,NULL,'DUMMY',1725,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1726,NULL,'DUMMY',1726,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1727,NULL,'DUMMY',1727,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1728,NULL,'DUMMY',1728,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1729,NULL,'DUMMY',1729,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1730,NULL,'DUMMY',1730,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1731,NULL,'DUMMY',1731,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1732,NULL,'DUMMY',1732,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1733,NULL,'DUMMY',1733,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1734,NULL,'DUMMY',1734,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1735,NULL,'DUMMY',1735,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1736,NULL,'DUMMY',1736,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1737,NULL,'DUMMY',1737,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1738,NULL,'DUMMY',1738,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1739,NULL,'DUMMY',1739,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1740,NULL,'DUMMY',1740,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1741,NULL,'DUMMY',1741,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1742,NULL,'DUMMY',1742,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1743,NULL,'DUMMY',1743,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1744,NULL,'DUMMY',1744,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1745,NULL,'DUMMY',1745,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1746,NULL,'DUMMY',1746,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1747,NULL,'DUMMY',1747,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1748,NULL,'DUMMY',1748,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1749,NULL,'DUMMY',1749,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1750,NULL,'DUMMY',1750,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1751,NULL,'DUMMY',1751,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1752,NULL,'DUMMY',1752,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1753,NULL,'DUMMY',1753,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1754,NULL,'DUMMY',1754,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1755,NULL,'DUMMY',1755,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1756,NULL,'DUMMY',1756,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1757,NULL,'DUMMY',1757,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1758,NULL,'DUMMY',1758,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1759,NULL,'DUMMY',1759,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1760,NULL,'DUMMY',1760,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1761,NULL,'DUMMY',1761,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1762,NULL,'DUMMY',1762,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1763,NULL,'DUMMY',1763,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1764,NULL,'DUMMY',1764,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1765,NULL,'DUMMY',1765,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1766,NULL,'DUMMY',1766,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1767,NULL,'DUMMY',1767,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1768,NULL,'DUMMY',1768,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1769,NULL,'DUMMY',1769,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1770,NULL,'DUMMY',1770,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1771,NULL,'DUMMY',1771,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1772,NULL,'DUMMY',1772,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1773,NULL,'DUMMY',1773,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1774,NULL,'DUMMY',1774,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1775,NULL,'DUMMY',1775,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1776,NULL,'DUMMY',1776,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1777,NULL,'DUMMY',1777,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1778,NULL,'DUMMY',1778,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1779,NULL,'DUMMY',1779,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1780,NULL,'DUMMY',1780,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1781,NULL,'DUMMY',1781,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1782,NULL,'DUMMY',1782,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1783,NULL,'DUMMY',1783,1,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1784,NULL,'DUMMY',1784,1,'2024-12-09 15:46:08','2024-12-09 15:46:08'),(1785,NULL,'DUMMY',1785,1,'2024-12-09 15:46:08','2024-12-09 15:46:08'),(1786,NULL,'DUMMY',1786,1,'2024-12-09 15:46:08','2024-12-09 15:46:08'),(1787,NULL,'DUMMY',1787,1,'2024-12-09 15:46:08','2024-12-09 15:46:08'),(1788,NULL,'DUMMY',1788,1,'2024-12-09 15:46:08','2024-12-09 15:46:08'),(1789,NULL,'DUMMY',1789,1,'2024-12-09 15:46:08','2024-12-09 15:46:08'),(1790,NULL,'DUMMY',1790,1,'2024-12-09 15:46:08','2024-12-09 15:46:08'),(1791,NULL,'DUMMY',1791,1,'2024-12-09 15:46:08','2024-12-09 15:46:08'),(1792,NULL,'DUMMY',1792,1,'2024-12-09 15:46:08','2024-12-09 15:46:08'),(1793,NULL,'DUMMY',1793,1,'2024-12-09 15:46:08','2024-12-09 15:46:08'),(1794,NULL,'DUMMY',1794,1,'2024-12-09 15:46:08','2024-12-09 15:46:08'),(1795,NULL,'DUMMY',1795,1,'2024-12-09 15:46:08','2024-12-09 15:46:08'),(1796,NULL,'DUMMY',1796,1,'2024-12-09 15:46:08','2024-12-09 15:46:08'),(1797,NULL,'DUMMY',1797,1,'2024-12-09 15:46:08','2024-12-09 15:46:08'),(1798,NULL,'DUMMY',1798,1,'2024-12-09 15:46:08','2024-12-09 15:46:08'),(1799,NULL,'DUMMY',1799,1,'2024-12-09 15:46:08','2024-12-09 15:46:08'),(1800,NULL,'DUMMY',1800,1,'2024-12-09 15:46:08','2024-12-09 15:46:08'),(1801,NULL,'DUMMY',1801,1,'2024-12-09 15:46:08','2024-12-09 15:46:08'),(1802,NULL,'DUMMY',1802,1,'2024-12-09 15:46:08','2024-12-09 15:46:08'),(1803,NULL,'DUMMY',1803,1,'2024-12-09 15:46:08','2024-12-09 15:46:08'),(1804,NULL,'DUMMY',1804,1,'2024-12-09 15:46:08','2024-12-09 15:46:08'),(1805,NULL,'DUMMY',1805,1,'2024-12-09 15:46:08','2024-12-09 15:46:08'),(1806,NULL,'DUMMY',1806,1,'2024-12-09 15:46:08','2024-12-09 15:46:08'),(1807,NULL,'DUMMY',1807,1,'2024-12-09 15:46:08','2024-12-09 15:46:08'),(1808,NULL,'DUMMY',1808,1,'2024-12-09 15:46:08','2024-12-09 15:46:08'),(1809,NULL,'DUMMY',1809,1,'2024-12-09 15:46:08','2024-12-09 15:46:08'),(1810,NULL,'DUMMY',1810,1,'2024-12-09 15:46:08','2024-12-09 15:46:08'),(1811,NULL,'DUMMY',1811,1,'2024-12-09 15:46:08','2024-12-09 15:46:08'),(1812,NULL,'DUMMY',1812,1,'2024-12-09 15:46:08','2024-12-09 15:46:08'),(1813,NULL,'DUMMY',1813,1,'2024-12-09 15:46:08','2024-12-09 15:46:08');
/*!40000 ALTER TABLE `product_variations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `products` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `type` enum('single','variable','modifier','combo') DEFAULT NULL,
  `unit_id` int(10) unsigned DEFAULT NULL,
  `secondary_unit_id` int(11) DEFAULT NULL,
  `sub_unit_ids` text DEFAULT NULL,
  `brand_id` int(10) unsigned DEFAULT NULL,
  `category_id` int(10) unsigned DEFAULT NULL,
  `sub_category_id` int(10) unsigned DEFAULT NULL,
  `discount_id` int(10) unsigned DEFAULT NULL,
  `tax` int(10) unsigned DEFAULT NULL,
  `tax_type` enum('inclusive','exclusive') NOT NULL,
  `enable_stock` tinyint(1) NOT NULL DEFAULT 0,
  `alert_quantity` decimal(22,4) DEFAULT NULL,
  `sku` varchar(191) NOT NULL,
  `barcode_type` enum('C39','C128','EAN13','EAN8','UPCA','UPCE') DEFAULT 'C128',
  `expiry_period` decimal(4,2) DEFAULT NULL,
  `expiry_period_type` enum('days','months') DEFAULT NULL,
  `enable_sr_no` tinyint(1) NOT NULL DEFAULT 0,
  `enable_serial_number` tinyint(1) NOT NULL DEFAULT 0,
  `weight` varchar(191) DEFAULT NULL,
  `use_multi_unit` tinyint(1) NOT NULL DEFAULT 0,
  `first_conversion_unit_id` int(10) unsigned DEFAULT NULL,
  `first_conversion_unit_rate` decimal(20,4) DEFAULT NULL,
  `second_conversion_unit_id` int(10) unsigned DEFAULT NULL,
  `second_conversion_unit_rate` decimal(20,4) DEFAULT NULL,
  `product_custom_field1` varchar(191) DEFAULT NULL,
  `product_custom_field2` varchar(191) DEFAULT NULL,
  `product_custom_field3` varchar(191) DEFAULT NULL,
  `product_custom_field4` varchar(191) DEFAULT NULL,
  `product_custom_field5` varchar(191) DEFAULT NULL,
  `product_custom_field6` varchar(191) DEFAULT NULL,
  `product_custom_field7` varchar(191) DEFAULT NULL,
  `product_custom_field8` varchar(191) DEFAULT NULL,
  `product_custom_field9` varchar(191) DEFAULT NULL,
  `product_custom_field10` varchar(191) DEFAULT NULL,
  `product_custom_field11` varchar(191) DEFAULT NULL,
  `product_custom_field12` varchar(191) DEFAULT NULL,
  `product_custom_field13` varchar(191) DEFAULT NULL,
  `product_custom_field14` varchar(191) DEFAULT NULL,
  `product_custom_field15` varchar(191) DEFAULT NULL,
  `product_custom_field16` varchar(191) DEFAULT NULL,
  `product_custom_field17` varchar(191) DEFAULT NULL,
  `product_custom_field18` varchar(191) DEFAULT NULL,
  `product_custom_field19` varchar(191) DEFAULT NULL,
  `product_custom_field20` varchar(191) DEFAULT NULL,
  `image` varchar(191) DEFAULT NULL,
  `product_description` text DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `preparation_time_in_minutes` int(11) DEFAULT NULL,
  `warranty_id` int(11) DEFAULT NULL,
  `is_inactive` tinyint(1) NOT NULL DEFAULT 0,
  `not_for_selling` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `products_brand_id_foreign` (`brand_id`),
  KEY `products_category_id_foreign` (`category_id`),
  KEY `products_sub_category_id_foreign` (`sub_category_id`),
  KEY `products_tax_foreign` (`tax`),
  KEY `products_name_index` (`name`),
  KEY `products_business_id_index` (`business_id`),
  KEY `products_unit_id_index` (`unit_id`),
  KEY `products_created_by_index` (`created_by`),
  KEY `products_warranty_id_index` (`warranty_id`),
  KEY `products_type_index` (`type`),
  KEY `products_tax_type_index` (`tax_type`),
  KEY `products_barcode_type_index` (`barcode_type`),
  KEY `products_secondary_unit_id_index` (`secondary_unit_id`),
  CONSTRAINT `products_brand_id_foreign` FOREIGN KEY (`brand_id`) REFERENCES `brands` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `categories` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_sub_category_id_foreign` FOREIGN KEY (`sub_category_id`) REFERENCES `categories` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_tax_foreign` FOREIGN KEY (`tax`) REFERENCES `tax_rates` (`id`),
  CONSTRAINT `products_unit_id_foreign` FOREIGN KEY (`unit_id`) REFERENCES `units` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1814 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `products` WRITE;
/*!40000 ALTER TABLE `products` DISABLE KEYS */;
INSERT INTO `products` VALUES (1,'PALMOLIVE FLAWLESS GLOW',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950031927','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(2,'PALMOLIVE HYDRATING 130G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950031897','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(3,'PALMOLIVE MOISTURISING GLOW 130',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950031910','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(4,'PALMOLIVE RADIANT GLOW 130G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950031880','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(5,'PALMOLIVE REFRESHING GLOW 98G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950031903','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(6,'TIBET DELUXE LAGRE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001024033','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(7,'ALMOND OIL 10ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000057339','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(8,'ASLI CREAM MILK 250ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961100360208','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(9,'BAJRA 500 G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'900406','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(10,'BASAN 250G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'900302','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(11,'BLUE DIMOND SMALL',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6291101522728','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(12,'CAPRI ALOE VERA SOAP 140GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961100022533','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(13,'CAPRI GREEN TEA SOAP 140GM*',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961100022557','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(14,'CAPRI MOISTURISING SOAP 120G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961100022991','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(15,'CAPRI PEACH SOAP 140GM*',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961100022571','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(16,'CAPRI STRAWBERRY SOAP 140GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961100022540','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(17,'CAPRI WATER LILLY SOAP 140GM*',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961100022564','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(18,'COLGATE HERBAL PASTE 75G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950052175','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(19,'COLGATE MISVAK 75G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950054209','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(20,'COLGATE PASTE FREE BRUSH 75GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950050225','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(21,'COLGATE PC TB 3 IN 1',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950093277','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(22,'COLGATE SPARKLE FREE BRUSH 70G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950066455','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(23,'CUP SHUP LIQUID TEA WHITNER',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961100502325','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(24,'DAAL CHANNA 250G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'900286','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(25,'DAAL MASH CHILKA 250G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'900338','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(26,'DAAL MASH DHULLI 250G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'900342','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(27,'DAAL MASOOR DESI 250G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'900535','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(28,'DAAL MASOOR MED 250G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'900310','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(29,'DAAL MASOOR MED 250G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'900486','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(30,'DAAL MONG CHILKA 250GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'900803','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(31,'DAAL MONG DHULLI 250GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'900314','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(32,'DAAL MONG SABIT 250GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'900784','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(33,'DABUR RED TOOTH PASTE 50G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964002492619','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(34,'DESI MASAR 250G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'900539','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(35,'DETTOL COOL 110G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961101233150','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(36,'DETTOL COOL 85G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961101233143','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(37,'DETTOL FRESH SOAP',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961101232924','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(38,'DETTOL HAND WASH POUCH PINK',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6001106209124','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(39,'DETTOL HANDWASH 150ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6001106209117','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(40,'DETTOL LEMON FRESH 110G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961101232931','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(41,'DETTOL ORIGINAL 110GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6001106209506','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(42,'DETTOL ORIGINAL SOAP 100G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6001106209261','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(43,'DETTOL SKIN CARE 170G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961101231767','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(44,'DETTOL SKIN CARE SOAP 100G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6001106209285','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(45,'DETTOL SKINCARE SOAP 145GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6001106209513','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(46,'DETTOL SOAP 130GM SOOTHE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961101231323','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(47,'DETTOL SOOTHE 170G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961101232269','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(48,'DETTOL SOOTHE 85G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961101231316','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(49,'GAI POWER WASH',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001226642','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(50,'GARNIER CN 3.16',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'3610340654954','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(51,'GARNIER COLOR N 1.0',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'3610340657320','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(52,'GARNIER COLOUR  3.0 DARKEST',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'3610340657337','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(53,'GARNIER HAIR COLOUR 4.0',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'3610340654961','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(54,'HEAD&SHOULDER SHAMPOO 75ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8001841460536','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(55,'HERO SURF 500G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001385035','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(56,'HOOR BEATY SOAP P',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000100936','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(57,'HOOR BEAUTY SOAP',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000100929','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(58,'HOOR SOAP 120G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000100943','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(59,'KABLI CHANNE 250GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'900807','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(60,'KALE CHANNE 250G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'900294','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(61,'KITCHEN QUEEN DW 500ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'32112306','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(62,'LAAL LOBIYA 250GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'900330','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(63,'LEMON MAX DISHWASH 475ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950096216','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(64,'LEMON MAX LIQUID 170ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950085234','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(65,'LEMON MAX LIQUID 275ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950096162','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(66,'LEMON MAX LIQUID 475ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950096179','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(67,'LEMON MAX PASTE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950074498','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(68,'LEMON MAX PASTE 200G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950073491','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(69,'LIFEBUOY HERBAL STRONG 90ML.',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014261172','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(70,'LIFEBUOY NATURALLY STRONG 90ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014255942','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(71,'LIFEBUOY TOTAL PROTECT 162G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014261752','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(72,'LUX GIOW',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014255171','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(73,'LUX SOAP VELVET GLOW',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014255188','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(74,'M N PINK SALT 800G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'2522523652217','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(75,'MAR ARQ_E_GULAB 50ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000057278','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(76,'MAR ARQE GULAB 120ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000057285','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(77,'MARHABA MEHNDI',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000057131','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(78,'MASAR MOTA 250G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'900306','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(79,'MAX SCRUB 1',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950076065','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(80,'MAX SCRUB GREASE CUTTING',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950076102','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(81,'MEDICAM ULTRA FRESH 75G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6291101523626','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(82,'MEDICAM ULTRAESH GEL 75G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6291101523657','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(83,'MEDICAM ULTRAFRESH GEL 75G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6291101523688','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(84,'NESTLE MILK PAK 250ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961008022185','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(85,'NURPUR 250ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961101372064','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(86,'OLPER MILK TBA 250ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000919934','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(87,'OPAL SOAP 4+1',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961100022694','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(88,'OPAL SOAP 4+1',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961100023271','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(89,'PALMOLIVE LUXURY SIZE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950031033','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(90,'PALMOLIVE SOAP LUXURY SIZE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950031811','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(91,'PALMOLIVE SOAP RADIANT GLOW',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950031828','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(92,'PANTENE A-H-S SHAMPOO 75ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8001841494210','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(93,'PANTENE ANTI HAIRFALL SHAMPOO 75ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8001841494128','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(94,'PANTENE SMOOTH & STRONG SHAMPOO 75ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8001841494395','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(95,'QARSHI ARQ E GULAB 120ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'855434012934','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(96,'ROBIN BLUE 75ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6001106309718','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(97,'ROYAL LATHER 150GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6291003231582','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(98,'ROYAL LATHER SOAP',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6291003616068','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(99,'ROYAL LEATHER',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6291003616075','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(100,'SABIT MASH KALE 250G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'900334','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(101,'SAFEGUARD FLORAL/SOAP 135G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8001841420554','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(102,'SAFEGUARD LEMON FRESH 103G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8006540021217','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(103,'SAFEGUARD LEMON FRESH 135GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8001841420615','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(104,'SAFEGUARD PURE WHITE 103G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8006540021156','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(105,'SAFEGUARD PURE WHITE 135GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8001841420677','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(106,'SAVANNAH BS DG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6291003615771','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(107,'SAVANNAH BS DREAMY CREAMY 125G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6291003615863','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(108,'SAVANNAH BS MAJESTIC GLOW 125G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6291003615740','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(109,'SAVANNAH BS MORNING GLOW 125G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6291003615849','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(110,'SAVANNAH BS PINK 125G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6291003615825','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(111,'SUFAID CHANNE BRK 250G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'900298','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(112,'SUFAID CHANNE MED 250G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'900290','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(113,'SUFAID LOBIYA 250G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'900326','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(114,'SUFI SOAP 1PC',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'99','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(115,'SUNSILK BLACK SHINE 80ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014250503','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(116,'SUNSILK LONG AND HEALTHY 80ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014250497','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(117,'SUNSLIK 80ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014260724','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(118,'TARANG 250ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000146651','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(119,'TOUCHME SHAVING CREAM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6291101520397','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(120,'VIM LEMON LIQUID 250ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014249446','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(121,'VITAL BEAUTY SOAP 155',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000818039','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(122,'VITAL CARE SOAP 125G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000818220','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(123,'VITAL CHIFFON FEEL SOAP 150G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000818169','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(124,'VITAL LEMON&TEA SOAP 155G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000818077','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(125,'VITAL SOAP MF',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964003729059','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(126,'YOUNGS CREAMY MAYO 500ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000061435','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(127,'EGG DOZEN',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'1004','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(128,'EDEN ROC PRICKLEY HEAT POWDER 125G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'222676274763','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(129,'EXPRESS POWER 1KG NEW',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950012148','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(130,'EXPRESS POWER 500G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950012223','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(131,'FAIR & L GIOW & HANDSOME',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014236866','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(132,'KNORR CHATT PATTA  6 IN 1',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014033847','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(133,'KNORR PARTY PACK CHICKEN',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014033830','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(134,'RIN SURF 500',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014262643','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(135,'SUNLIGHT 2 IN 1 2 KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014262209','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(136,'SUNLINGHT 2 IN 1 2KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014262193','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(137,'SURF EXCEL 500G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014264289','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(138,'A-1 AMLA SHAMPOO 110ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964003576431','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(139,'A-1 EGG SHAMPOO 110ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964003576462','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(140,'AL-TEEN BEAUTY SOAP 125G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'764613954906','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(141,'ALWAYS ALOE VERA',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8700216610445','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(142,'AMENITY GOLD DRY 300ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'676979204826','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(143,'ANNE FRENCH 25GMS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950049014','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(144,'ANNE FRENCH 40GMS JAR',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950049113','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(145,'ANNE FRENCH HAIR REMOVAL 50G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950049038','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(146,'ANNE FRENCH HAIR REMOVAL 80G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950049137','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(147,'ARIEL 500G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8700216736817','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(148,'ARIEL 500G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8700216451093','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(149,'ARIEL 500G SURF',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8001841256665','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(150,'ARIEL DOWNY SURF 500GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'4084500599789','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(151,'BAJRA 1 KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'900405','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(152,'BAKE PAR MACORINI BOX',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'1358946338404','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(153,'BAKE PAR SPAGHETTI 450G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'1358946337964','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(154,'BAKE PARLOR LASAGNE 400 G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'1358946338268','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(155,'BAKE PARLOR MACARONI 400G ELBO',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'1358946338572','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(156,'BAKE PARLOR MACARONI FU 400G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'1358946339258','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(157,'BAKE PARLOR SHELL 400G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'1358946339012','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(158,'BAKE PARLOR SP MACARONI 400G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'1358946338886','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(159,'BAKE PARLOR SPAGHETTI 500GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'1358946338022','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(160,'BAKE PARLOR TREE COLOR MACARON',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'1358946345716','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(161,'BAKE PARLOR TWISTED MACARONI 400G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'1358946338992','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(162,'BAKE PARLUR PENNE MACRONI 400G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'1358946339180','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(163,'BAKE PORLOR FUSILLI MACARONI 450G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'3563874554408','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(164,'BARRAQ ALMOND OIL 25ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'4710091004','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(165,'BARRAQ ARQ E GULAB 120ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'4710091006','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(166,'BARRAQ BLACK SEED 25ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'471009','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(167,'BARRAQ BLACK SEED 50ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'471010','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(168,'BARRAQ COCONUT OIL 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'4710091008','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(169,'BARRAQ KADU 25ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'4710091037','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(170,'BARRAQ OLIVE OIL 25ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'01287524507862','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(171,'BARRAQ OLIVE OIL 25ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'4710091002','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(172,'BARRAQ ROSEMARY OIL25ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'4710091038','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(173,'BASAN 1KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'900901','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(174,'BASAN 250G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'3566','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(175,'BASAN 500G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'3565','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(176,'BERG SNOW FALL POWDER 225GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000945407','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(177,'BERG SNOWFALL POW 125G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000944141','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(178,'BH CHAWAL 1 KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'900479','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(179,'BIO AMLA HAIR OIL 100MLL',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6009689191089','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(180,'BIO AMLA HAIR OIL 50ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6009689191843','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(181,'BIO AMLA SHAMPOO 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6009689191652','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(182,'BIQIN FEEDIN BOTTLE 300ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6948669531258','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(183,'BLACK  BEAUTY  COLOGNE TALC',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'1512147867280','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(184,'BLACK CAT PERFUME TALC LARGE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000749937','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(185,'BLACK CAT POWDER 70G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000749906','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(186,'BLUE BAND MARGRINE SPREAD 200',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961102110306','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(187,'BONUS 1KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950013848','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(188,'BONUS ACTIVE 1000G SAVE 50',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950014333','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(189,'BONUS ACTIVE 1KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950014845','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(190,'BONUS ACTIVE 500 G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950014319','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(191,'BONUS ACTIVE 770G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950014203','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(192,'BRITE STANIS MAXIMUM POWER 500',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950011141','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(193,'BROOKE BOND SUPREME 170 G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8720608619306','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(194,'BROWN SUGAR 300GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'1788110009326','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(195,'BRYLCREEM SC ANTI-DANDRUFF 75ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8999999025243','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(196,'BRYLCREEM SC LITE NOURISHING 125ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8999999025298','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(197,'BRYLCREEM SC ORIGNAL 75ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8999999025236','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(198,'BUTTERFLY LONG PAD XXL 16PCS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000043455','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(199,'CAPRI CALMING GOLE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961100023257','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(200,'CAPRI MOISTURISING 3PC',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961100023134','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(201,'CAPRI REFRESHING 3 IN ONE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961100023165','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(202,'CAPRI YOUTHFUL  GLOW',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961100023141','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(203,'CAPRIPURIFYING GREEN TEA',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961100023158','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(204,'CARE BS H&A 150G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6009679061583','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(205,'CARE HONEY LOTION 60ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6009679062436','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(206,'CHERRY BLACK POLISH 20ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6001106309732','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(207,'CHERRY DARK TAN POLISH 20ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6001106309749','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(208,'CHOCO BLISS CS MILKY',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000062586','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(209,'CHOCO BLISS DOUBLE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000062791','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(210,'CHOCO BLISS HAZELNUT COCA SPREAD',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000062562','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(211,'CHOCO BLISS MILKY 180G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000062579','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(212,'CLOSE UP DEEP ACTION 160G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8934839122515','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(213,'CLOSE UP DEEP ACTION 50ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'4800888113566','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(214,'CLOSE UP DIAMOND ATTRACTION 38ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8934839122492','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(215,'CLOSEUP DEEP ACTION 160GM*',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8934839122508','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(216,'CLOSEUP DEEP ACTION PASTE 100GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8934839122478','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(217,'CLOSEUP EF TP 50ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'4800888113481','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(218,'CLOSEUP EVERFRESH',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'4800888113559','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(219,'CLOSEUP FIRE FREEZE 160G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8999999008482','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(220,'CLOSEUP PASTE 95ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'4800888113474','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(221,'CLOSEUP PASTE DEEP ACTION 100',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8934839122461','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(222,'CLOSEUP RED HOT 125GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6902088606201','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(223,'COCA COLA 1 L',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'5449000054227','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(224,'COCA COLA 2.25 LITER',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'5449000025173','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(225,'COCACOLA 1.5 L',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'5449000051981','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(226,'COLA NEXT 1.5L',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001179009','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(227,'COLA NEXT 2.25L',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001179030','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(228,'COLAGATE MCP REGULAR 150+23G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950051468','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(229,'COLGATE 150GM GREAT',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950050317','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(230,'COLGATE 360 SENSITIVE BRUSH',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'4892368647579','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(231,'COLGATE ADVANCED WHITE 150GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6281001101192','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(232,'COLGATE HERBAL 100+25G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950052274','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(233,'COLGATE HERBAL 150G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950052168','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(234,'COLGATE HERBAL 200G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950052076','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(235,'COLGATE KIDS BATMAN BRUSH',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'9556031209857','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(236,'COLGATE KIDS BRUSH*',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'9556031209864','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(237,'COLGATE MAXFRESH 125+25',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950050362','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(238,'COLGATE MAXIMUM CAVITY 125G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950051444','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(239,'COLGATE MAXWHITE 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6920354824845','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(240,'COLGATE MCP TP 200G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950051383','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(241,'COLGATE MCP TP 200G ..',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950051451','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(242,'COLGATE MF CITUS BLAST 125+25',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950050386','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(243,'COLGATE MF SPICY FRESH 125+25G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950050379','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(244,'COLGATE MISVAK TP 100G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950054049','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(245,'COLGATE PASTE HERBAL 100GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950052038','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(246,'COLGATE PASTE HERBAL 150GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950052045','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(247,'COLGATE PASTE M/FRESH C/B 75GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950056050','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(248,'COLGATE PASTE M/FRESH P/I 125G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950056029','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(249,'COLGATE PASTE M/FRESH P/I 75GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950056012','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(250,'COLGATE PASTE M/FRESH S/F 125G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950056043','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(251,'COLGATE PASTE M/FRESH S/F 75GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950056036','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(252,'COLGATE PASTE MAX FRESH 125GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950056067','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(253,'COLGATE PASTE REGULAR 100GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950051031','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(254,'COLGATE PASTE REGULAR 150GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950051048','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(255,'COLGATE SPARKLE 130G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950066578','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(256,'COLGATE SPARKLE 130G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950066622','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(257,'COLGATE SPARKLE PASTE 130GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950066462','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(258,'COLGATE SPARKLE PASTE 200GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950066516','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(259,'COLGATE TOTAL 75G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950057057','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(260,'COLGATE TRIPLE ACTION 146G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6920354812521','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(261,'COLGATE ZIGZAG NEW*',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950093185','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(262,'COMFORT LILY FRESH',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014247749','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(263,'COMFORT LILY FRESH 400ML BTL',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014247008','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(264,'COMFORT MORNING FRESH BTL 400ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014246995','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(265,'COMFORT MORNING FRESH PCH 400ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014247732','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(266,'COMFORT POUCH PURPAL 600ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8851932188012','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(267,'CORAL AIR FRESHNER 300ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964003538453','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(268,'CORAL AS+BA+LJ+SA+RR+BO  AF 300ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964003538064','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(269,'CRISPO VERMICELLI',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000070154','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(270,'DAAL CHANNA 1KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'900284','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(271,'DAAL CHANNA 500GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'900285','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(272,'DAAL MASH CHILKA 500GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'900337','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(273,'DAAL MASH DHULLI 500G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'900341','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(274,'DAAL MASOOR DESI 1KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'900533','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(275,'DAAL MASOOR DESI 500GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'900534','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(276,'DAAL MASOOR MED 1KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'900484','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(277,'DAAL MASOOR MED 500GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'900309','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(278,'DAAL MONG CHILKA 1KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'900316','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(279,'DAAL MONG DHULLI 1KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'900312','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(280,'DAAL MONG DHULLI 500GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'900313','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(281,'DAAL MONG SABIT 1 KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'900782','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(282,'DAAL MONG SABIT 500GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'900783','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(283,'DABUR AMLA HAIR OIL 100 ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'5022496105002','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(284,'DABUR AMLA HAIR OIL 50ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'5022496103428','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(285,'DABUR AMLA R&S SHAMPOO 150ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964002492183','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(286,'DABUR RED TOOTHPASTE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8901207099106','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(287,'DABUR ROGHAN E BADAM AMLA HAIR OIL 90ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964002493449','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(288,'DAGHI CHAWAL 1 KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'900475','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(289,'DALDA BANASPATI 1KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961100502790','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(290,'DALDA COOKING OIL POUC 1L',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961100502813','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(291,'DALIYA GANDUM 1 KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'900344','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(292,'DALIYA GANDUM 500GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'900345','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(293,'DALIYA JAO 500GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'579975','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(294,'DELIGHT DUNEBILL DEZIRE AF 300ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'653341104779','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(295,'DELITE AF 213 VIB 300ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'653341105677','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(296,'DELITE AF CIK WON 300ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'653341104878','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(297,'DELITE AF DO HIT 300ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'653341104571','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(298,'DELITE DRAPES HANDWASH',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'653341108470','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(299,'DELITE HAND WASH 500G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'653341108876','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(300,'DELITE LAVENDER MIST AF 300ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'748252461056','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(301,'DELITE LEMON HAND WASH',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'653341108371','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(302,'DELITE LOVE POTION AF 300ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'653341105271','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(303,'DELITE ROOM SPRAY 300ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'748252460950','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(304,'DELITE ROSE GARDEN 300ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'748252461254','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(305,'DELYCIA PERFEUM SPRAY',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961100040667','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(306,'DELYCIA PERFUME 12ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961100040605','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(307,'DELYCIA PERFUMED SPRAY',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961100040636','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(308,'DENTIST KLEAR BRUSH',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000139271','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(309,'DENTIST TOOHT BRUSH H',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000139134','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(310,'DENTIST TOOHT BRUSH M',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000139127','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(311,'DENTIST TOOHT BRUSH S',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000139110','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(312,'DESI MASAR 1KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'900537','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(313,'DESI MASAR 500GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'900538','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(314,'DETTOL  LIQ 50ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6001106309428','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(315,'DETTOL COOL 160G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961101233099','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(316,'DETTOL COOL 3PC .',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961101233167','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(317,'DETTOL ORIGINAL 175 G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961101230906','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(318,'DETTOL ORIGIONAL 3PCS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961101232955','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(319,'DETTOL SKINCARE 3IN1',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961101232979','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(320,'DHANIA PISSA 250G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'900398','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(321,'DHANIA SALIM 250G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'900394','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(322,'DIPLOMAT SHAVING CREAM 120G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961100040292','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(323,'DLITE BOSSY PERFUME AF 300ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'653341105073','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(324,'DOCTOR ANTI LICE SHAMPOO 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000515198','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(325,'DOCTOR FLOURIDE TOOTHPASTE 65GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000515013','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(326,'DOCTOR JUMBO PACK PASTE 150G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000515051','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(327,'DOCTOR LARG BRUSH PACK',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000515020','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(328,'DOCTOR LONG TOOTHPASTE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000961858','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(329,'DOCTOR PRICKLY HEAT CREAM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000961247','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(330,'DOCTOR PRICKLY HEAT NEEM 80G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000961834','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(331,'DOCTOR TOOTH PASTE 65G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000961681','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(332,'DOCTOR TOTH PASTE SALTED 100',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000515037','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(333,'DOVE INTENSIVE REPAIR S IMP 200ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6281006532410','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(334,'DOVE SHAMPOO MOIS H 200ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6281006532427','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(335,'EDEN ROC PRICKLEY HEAT POWDER 225G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'222676274756','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(336,'EDEN ROC PRICKLEY HEAT POWDER NEEM 175G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'222676267741','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(337,'EDENROC PETROLEUM JELLY 50G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'377577377577','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(338,'EGIGRIP KOMBAT BRUSH H',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000139165','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(339,'ELITE KITCHEN ROLL',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'5205001649622','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(340,'EMAMI INSTANT GLOW FW 50G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8901248428446','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(341,'EMAMI RADIANT GLOW CFM 25G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'5060068528545','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(342,'EMAMI SMART & HANDSOME AG FACEWASH 50G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'5060068526770','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(343,'ENERGILE ORANGE 400 G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014032352','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(344,'ENERGILE ORIGINAL 400 G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014032383','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(345,'ENG PRICKLY HEAT POE NEEM 110G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000572221','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(346,'ENG PRICKLY HEAT POWDER',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000572481','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(347,'ENGLISH ANTI LICE SHAMPOO',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000571040','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(348,'ENGLISH NEEM SOAP',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000570418','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(349,'ENGLISH PRICKLY HEAT CREAM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000571002','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(350,'ENGLISH TOOTH PASTE REG 140GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000572559','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(351,'ENGLISH TOOTH PASTE REG 70GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000572535','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(352,'ENGLISH TOOTHPASTE 65G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000572542','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(353,'EU CREAM H/REMOVER 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000045480','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(354,'EU CREAM HAIR REMOVER  75ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000045459','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(355,'EU CREAM HAIR REMOVER 30ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000045442','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(356,'EU HAIR REMOVAL CREAM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000045411','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(357,'EU HAIR REMOVAL CREAM 75G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000045374','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(358,'EU HAIR REMOVER CREAM GREEN',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000045367','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(359,'EU HAIR REMOVER LOTION 50ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000045466','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(360,'EU LOTION HAIR REMOVER 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000045473','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(361,'EU SAFE AND SMOOTH HR 100G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000045381','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(362,'EZIGRIP KOMBAT KLEAR BRUSH/M',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000139189','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(363,'EZIGRIP SKOOL TB',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000139301','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(364,'EZIGRIP T/BURSH H',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000139196','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(365,'EZIGRIP T/BURSH S',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000139172','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(366,'FANTA 1.5 L',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'5449000052926','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(367,'FARDA H PINK SALT 800G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'745760385539','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(368,'FAUJI BARLEY PORRIDGE 175G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000064221','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(369,'FAUJI BARLEY PORRIDGE 250G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000064214','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(370,'FAUJI CORN FLAKES 150G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000064092','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(371,'FAUJI CORN FLAKES 250G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000064061','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(372,'FAUJI WHEAT PORIDGE 250G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000064153','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(373,'FIZ UP NEXT 1.5L',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001179412','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(374,'FIZ UP NEXT 2.25L',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001179405','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(375,'FOOD NET YEAST 40G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'fn368463427506','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(376,'FORHANS HAIR TONIC 100 ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000024133','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(377,'FORHANS HAIR TONIC 200ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000024126','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(378,'FORHANS PASTE 110GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000024010','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(379,'FORHANS TOOTH PASTE 150G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000024003','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(380,'FORHANS TOOTH PASTE 70G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000024027','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(381,'FREY AIR FRESHNER',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'748252469953','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(382,'FREY BAKHEER UL BAHRAIN 300ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'748252462954','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(383,'FREY BERRYLICIOUS 300ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'748252469854','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(384,'FRUITI-O SMILE 1 LITER',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000843901','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(385,'GAI AL BARKAT SOAP 500GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000100097','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(386,'GAI SOAP PACKET',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000100004','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(387,'GAI XTRA NEAT WP 1000GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000827628','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(388,'GAR OIL CLEAR FACE WASH 50GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001174745','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(389,'GARNEIR MEN 2IN1 POWER WHITE FW 50ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'3610340652448','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(390,'GARNIER SA FAST CLEAR FW 50ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'3610340672170','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(391,'GARNIER VITAMIN C F/W 50ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'3610340650994','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(392,'GATSBY HAIR GEL L2 75G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'4902806001976','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(393,'GATSBY WATER  GLOSS HG 75G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'4902806001952','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(394,'GATSBY WATER GLOSS HYPER SOLID 75G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8992222052993','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(395,'GIBS PASTA SPAGHETTI',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001311843','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(396,'GLAXOSE-D 400G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014186369','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(397,'GLOW & LOVELY 50G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014236828','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(398,'GLOW AND HANDSOME 50G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014236880','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(399,'GLOW AND LOVELY GLOW LOTION',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014236842','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(400,'GOLDEN PEARL CHARCOAL FACEWASH 75ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964003015619','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(401,'GOLDEN PEARL FC L&G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001753230','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(402,'GOLDEN PEARL FLAW LESS FW 75ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001753308','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(403,'GOLDEN PEARL HEARBAL FACE WASH 75ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001078043','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(404,'GOLDEN PEARL MEN F/WASH 75ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001078791','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(405,'GOLDEN PEARL NEEM FW 75ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001078074','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(406,'GOLDEN PEARL SOAP',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001078180','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(407,'GOLDEN PEARL TEA TREE FACE WASH 75ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964003015718','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(408,'GOLDEN PEARL VITAMIN C FW 75ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964003015695','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(409,'GOLDEN PEARL WHITENING SOAP 100G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001078173','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(410,'GOLDENPEARL F/W OIL CONTROL 75ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001078050','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(411,'GOREY ALL ROUNDER B',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'9211212181529','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(412,'GOREY ALL ROUNDER INFUSE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'9211211312238','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(413,'GOREY ANTI PLAQUE BRUSH',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'888887312238','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(414,'GOREY EXTRA HARD',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'9211212255237','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(415,'GOREY SUMEI BRUSH',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'729872535037','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(416,'GP HELLO HAIR SHAMPO DM 75ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001753841','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(417,'GP HELLO HAIR SHAMPO EP 75ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001753858','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(418,'GP HELLO HAIR SHAMPO HER 75ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001753865','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(419,'GP WHITENING SOAP',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001078166','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(420,'GREEN LEAF CHAI 170G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001058977','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(421,'GREEN LEAF CHAI 80G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001058953','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(422,'GREEN TEA LEMON',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8720608620654','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(423,'GREEN TEA PURE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8720608620708','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(424,'H&S CLASSIC CLEAN SHAMPOO 75ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8001841460291','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(425,'H&S SILKY BLACK SHAMPOO 75ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8001841460680','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(426,'HABIB GHEE POUCH 1KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6297000027197','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(427,'HABIB OIL POUCH 1LTR',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6297000027043','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(428,'HALEEB ASLI MILK  1LRT',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961100360000','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(429,'HALEEB CREAM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961100360383','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(430,'HAMALAYA ALOE VERA GEL 160',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'9230062603913','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(431,'HAMALAYA ALOE VERA GEL 260',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6928001834919','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(432,'HARPIC POWER PLUS 225ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6001106114619','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(433,'HARPIC RED 225 ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961101231156','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(434,'HELLO HAIR A D SHAMPOO 75ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001753872','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(435,'HERO SURF 1KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001385028','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(436,'HILAL CUP CAKE STRAWBERRY 12 PC',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961101787783','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(437,'HILAL WISPY BOX',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'769503781792','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(438,'HIO LEATHER SS D',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6392748882111','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(439,'HOME CARE LAVENDER AF 300ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'676979100722','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(440,'HONEY GOLD 300G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964003244200','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(441,'HOUSE CARE AF BIG BOSS 300ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'676979100760','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(442,'ITALIA FRUIT COCKTAIL 234GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'705105550633','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(443,'ITALIA OLIVE OIL 250ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6890767829754','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(444,'JOHN BABY PDR BLOSSOMS 100G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'4801010105206','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(445,'JOHN BABY POWDER 200GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8991111109138','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(446,'JOHN BABY POWDER CLASSIC 100GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'3574660028096','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(447,'JOHN BABY SHAMP 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'9556006014547','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(448,'JOHN BABY SOAP 100G BLOSSOM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'4801010561309','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(449,'JOHN BABY SOAP 100G REG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'4801010560500','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(450,'JOHNSON BABY OIL 50ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8991111101316','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(451,'JOHNSONS BABY LOTION 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'3574669909624','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(452,'JOHNSONS BABY POWDER 100G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8991111101415','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(453,'JOHNSONS BABY SHAMPOO 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8991111102603','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(454,'JOHNSONS BLOSSOMS POWDER 100G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8991111109121','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(455,'JOHNSONS SHAMPOO 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6223000659243','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(456,'KABLI CHANNE 1KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'900805','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(457,'KABLI CHANNE 500GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'900806','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(458,'KALA KOLA HAIR TONIC 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000047132','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(459,'KALE CHANNE 1KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'900292','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(460,'KALE CHANNE 500GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'900293','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(461,'KITE MATCH BOX',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'347018','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(462,'KLIM CASTER SUGAR 300G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'FN368463427576','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(463,'KLIM COCOA POWDER 40 G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'3684634275378','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(464,'KLIM GELATIN POWDER',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'3684634275699','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(465,'KLIM ICING SUGAR 300G..',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'3684634275521','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(466,'KNORR CHILLI GARLIC 300G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014032147','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(467,'KNORR CHILLI GARLIC 300G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014024432','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(468,'KNORR TOMATO KETCHUP 300G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014032130','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(469,'KNORR TOMATO KETCHUP 300G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014024425','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(470,'KODOMO FRUITY MIX PASTE 45G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8998866103084','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(471,'KODOMO LION PASTE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8998866100243','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(472,'KODOMO ORANGE PASTE 45G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8998866100250','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(473,'KODOMO STRAWBERRY PASTE 45G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8998866100229','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(474,'LAAL LOBIYA 500G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'900329','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(475,'LEMON MAX LDW 450ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950096186','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(476,'LEMON MAX LIQUID 750ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950096391','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(477,'LEMON MAX PASTE 400G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950073651','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(478,'LIFEBOUY ANTI BACTERIAL HANDWASH',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8999999001506','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(479,'LIFEBOUY ANTI KETOMBE SHAMPOO 170ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8999999033217','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(480,'LIFEBOUY P-R-R SHAMPOO 170ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8999999033132','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(481,'LIFEBUOY HAND WASH 400ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014255744','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(482,'LIFEBUOY HANDWASH MC 200ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8999999001476','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(483,'LIFEBUOY HANDWASH MILDCARE 400ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014255737','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(484,'LIFEBUOY HW MILD CARE 200ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014255782','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(485,'LIFEBUOY HW TOTAL PROTEC 200ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014255799','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(486,'LIPTON TEA BAGS 25PC',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'900360','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(487,'Lipton Yellow Label 140G New',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8720608622931','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(488,'LIPTON YELLOW LABEL 170G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8720608619344','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(489,'LIPTON YELLOW LABEL 25PC',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8720608620302','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(490,'LIPTON YELLOW LABEL 70G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8720608622924','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(491,'LIPTON YELLOW LABEL TEA 70G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8720608619337','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(492,'LISTERINE FRESHBURST 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8992725910417','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(493,'LISTERINE NATURAL GREEN 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8991111152073','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(494,'LISTERINE SIWAK 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8991111153131','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(495,'LUCKY 121 UCD MEN AIR FRESHNER 300ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'676979100111','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(496,'LUX FLAW-LESS SKIN IMP 170G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6281006527249','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(497,'LUX MAGICAL ORCHID IMP 170G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6281006527201','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(498,'LUX NOURISHED SKIN IMP 170G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6281006527140','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(499,'LUX RADIANT SKIN IMP 170G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6281006527164','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(500,'LUX ROSE GLOW 3 PACK',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014256178','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(501,'LUX VELVET GLOW B 390G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014264401','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(502,'LYFE FEEDING BOTTLE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'123321','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(503,'LYFE FEEDING BOTTLE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'lYFE 123 321','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(504,'MAR ARQE GULAB SPRY 120ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000057308','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(505,'MAR CASTOR OIL 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000057414','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(506,'MAR CASTOR OIL 50ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000057407','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(507,'MARHABA COCONAT OIL 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000088173','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(508,'MARHABA HONEY 80G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000057025','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(509,'MARHABA OLIVE OIL 50ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000057384','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(510,'MARHABA ROGHAN KALONGI 25ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000057421','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(511,'MARHABA ROGHAN KALONJI 50ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000057438','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(512,'MARHABA ROSE WATER 240ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000057292','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(513,'MARHABA ROSE WATER 300ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000055694','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(514,'MARIOS SPAGHETTI 500GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001525257','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(515,'MASAR MOTA 1KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'900304','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(516,'MASAR MOTA 500GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'900305','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(517,'MAYFAIR CREAMER CANDY M&C 100PCS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964003378592','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(518,'MAYFAIR CREAMER CANDY S&C 100PCS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964003378110','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(519,'MECLAY LONDON ANTI DANDRUFF 180ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'5060593000912','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(520,'MECLAY LONDON CP 185ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'5060593000196','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(521,'MECLAY LONDON LUSTROUS CONDITIONER 180ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'5060593000202','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(522,'MECLAY LONDON S&S SHAMPOO 185ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'5060593000189','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(523,'MECLAY LONDON STRONG & HEALTHY CONDITIONER 180ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'5060593000240','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(524,'MEDA 500G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'3583','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(525,'MEDICAM H/F BRUSH  150G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6291101524227','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(526,'MEDICAM PASTE  70G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6291101520120','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(527,'MEDICAM SHAPOO',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6291101520533','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(528,'MEDICAM TOOTH PASTE 100G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6291101520137','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(529,'MEDICAM TOOTH PASTE 140GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6291101520151','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(530,'MEDICAM TOOTH PASTE 180G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6291101522636','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(531,'MEDICAM TOOTH PASTE 65GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6291101520113','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(532,'MEDORA BOUQUET PP 12ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961100040469','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(533,'MEDORA JOY TALC 100GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961100040049','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(534,'MEDORA TALC LARGE 275GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961100040032','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(535,'MEEZAN COOKING OIL POUCH',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000419472','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(536,'MEHRAN  BIRYANI 100G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'633152009166','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(537,'MEHRAN ACHAR GOSHT 100G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'633152009159','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(538,'MEHRAN CHICKEN TIKKA MASALA 100GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'633152019783','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(539,'MEHRAN QORMA MASALA 100G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'633152009319','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(540,'MINHAJ MURABBA ASHARFI 500G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'999367','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(541,'MINHAJ MURABBA GULKAND 500G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'120057','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(542,'MINHAJ MURABBA KRONDA 500G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'999365','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(543,'MINI TREE PP REGULAR FEEDER',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'1250011','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(544,'MINITREE BABY FEEDER',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'999247','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(545,'MOSPEL 45ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6164003394017','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(546,'MOSPEL MOSQUITO REPELLENT SPRAY 45ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8002660040589','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(547,'MOTHER CARE GO RASH CREAM 30G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000982044','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(548,'MOTHERCARE BABY LOTION SOAP',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000982204','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(549,'MOTHERCARE BABY POWDER 130GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000982594','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(550,'MOTHERCARE BABY SOAP WHITE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000982198','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(551,'MOTHERCARE SHAMPOO 60ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000982563','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(552,'MOUNTAIN DEW 1.5 L',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000101117','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(553,'NAT ACHAR GHOSHT RM 90G D-PACK',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'620514008776','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(554,'NAT BIRYANI RM 83G D-PACK',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'620514008721','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(555,'NAT BOMBAY BIRYANI RM 150G D-PACK',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'620514008745','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(556,'NAT CHICKEN TIKKA RM 85G D-PACK',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'620514008806','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(557,'NAT DELHI NIHARI RM 130G D-PACK',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'620514009889','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(558,'NAT FISH RM 85G D-PACK',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'620514008783','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(559,'NAT KARAHI GHOST RM 99G D-PACK',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'620514008790','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(560,'NAT KASURI METHI 25G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'620514000060','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(561,'NAT KK BOMBAY BIRYANI RM 145G D-PACK',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'620514015552','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(562,'NAT KK NIHARI RM 112G D-PACK',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'620514019048','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(563,'NAT PULAO RM 140G D-PACK',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'620514010359','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(564,'NAT QUICK COOK HALEEM 345GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'620514000381','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(565,'NAT QUORMA RM 90G D-PACK',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'620514008738','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(566,'NATIONAL DAIGHI DANEDAR 293G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'620514017389','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(567,'NATIONAL TOMATO KETCHUP',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'620514019192','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(568,'NES CERELAC MG YF 175G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961008220482','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(569,'NES NODO FORTIGROW 200G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961008222769','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(570,'NESTLE CERELAC APPLE & STRAW 175G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961008220673','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(571,'NESTLE CERELAC MULTI GRAIN 175G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961008220499','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(572,'NESTLE CERELAC NATURE SELECTION 175G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961008219899','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(573,'NESTLE CERELAC RICE 175G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961008220451','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(574,'NESTLE CERELAC RICE 200G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961008235257','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(575,'NESTLE CERELAC THREE FRUIT & WHEAT 175G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961008220284','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(576,'NESTLE CERELAC THREE FRUIT & WHEAT 200G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961008235240','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(577,'NESTLE CERELAC WHEAT 175G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961008220352','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(578,'NESTLE NIDO 1+ 150G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961008224824','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(579,'NESTLE NIDO 3+ 150G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961008223179','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(580,'NESTLE NIDO 3+ 150G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961008224879','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(581,'NOOR GOLD NEEM FACE WASH 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8009689152453','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(582,'NOOR NEEM HERBAL SOAP 100G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'5845454441116','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(583,'NORANGI UBTAN LARGE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'120051','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(584,'NORANGI UBTAN SMALL',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'12004','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(585,'NUMBER 1 WASHING POWDER 1KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964002384020','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(586,'OLIVIA LOTION MCM 110ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'858167000292','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(587,'OREO BOX',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961003553370','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(588,'ORGANIC PAPRIKA POWDER',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'3684634275842','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(589,'ORIGIONAL OREO 10X',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961003036019','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(590,'PALMOLIVE HEALTHU & SMOOTH',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950035437','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(591,'PALMOLIVE INTENSE MOSITURE 80 ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950035444','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(592,'PARADOMNTAX 70G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8966000033467','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(593,'PARODONTAX E.FRESH PASTE 100GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'9200475733101','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(594,'PARODONTAX E/FRESH PASTE 50GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'9200475733057','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(595,'PARODONTAX EF COPLETE P 100G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'9780201379624','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(596,'PARODONTAX HF 100G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'9200743710469','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(597,'PARODONTAX ORIGINAL PASTE 100GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'9200475776108','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(598,'PARODONTAX ORIGINAL PASTE 50GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'9200475776504','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(599,'PAWAR APPLE HAND WASH',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'4396935439623','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(600,'PAWAR BLUE OCCEN HANDWASH',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'4396935439654','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(601,'PAWAR LEMON HAND WASH',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'4396935439630','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(602,'PAWAR ROSE HANDWASH',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'4396935439616','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(603,'PAWAR SUPERME CLEAN',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'3004396935295','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(604,'PEPSODENT PASTE 190G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8999999706180','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(605,'PEPSODENT TP 225G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8999999561031','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(606,'PERFUME TISSUE 550PCS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'810404142820','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(607,'POLKA SAWAIYAAN 250G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'999225','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(608,'POLKA SAWAIYAAN 500 G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'900568','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(609,'PONDS ACNE CONTROL FACE WASH 50G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014248890','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(610,'PONDS BRIGHT BEAUTY 50G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014249019','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(611,'PONDS BRIGHT BEAUTY FACE WASH 50ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014263039','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(612,'PONDS LIGHT MOISTURISER CREAM 75GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014250732','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(613,'PONDS PURE DETOX 50G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014249033','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(614,'PONDS PURE DETOX FW 50G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014263053','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(615,'PUNJAB BANASPATI 1KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000753057','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(616,'PUNJAB COOKING OIL',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000753064','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(617,'PUNJAB SOAP BAR',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001099758','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(618,'PURE LOVE FEEDING BOTTLE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'3214914012227','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(619,'PURE TISSUES',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961006016308','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(620,'QARSHI ISPAGHOL HUSK',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'855434000535','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(621,'RED ROSE DRY 300ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'676979100708','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(622,'RIN 500 G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014261684','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(623,'RIVAJ BAMBOO CHARCOAL BFW 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'5060453455326','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(624,'RIVAJ MILK EXTRACT FW 50ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'5060453458808','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(625,'RIVAJ SUN BLOCK W&V SPF60 40ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'5060453453452','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(626,'ROSE PETAL HI JEEN TISSUES',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961006010283','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(627,'ROSE PETAL LUXURY',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961006010016','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(628,'ROSE PETAL P/PACK WHITE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961006040068','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(629,'ROSE PETAL PARTY PACK',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961006040051','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:00','2024-12-09 15:46:00'),(630,'ROSE PETAL POP UP S&G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961006040044','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(631,'ROSE PETAL TOILET ROLL',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961006020015','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(632,'ROSEPAIR BAKING POWDER 100G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'1788110009623','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(633,'ROSEPAIR COCOA POWDER 40GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'1788110009111','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(634,'ROSEPAIR ICING SUGAR 300G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'9178811999408','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(635,'SABIT MASH KALE 500GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'900333','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(636,'SALVA CANOLA 0.5LTR',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001015932','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(637,'SALVA CANOLA 1LTR',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001015192','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(638,'SALVA CANOLA 1LTR BOTLE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001015314','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(639,'SALVA COOKING OIL 1L',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001015161','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(640,'SAMSOL EGG SHAMPO 150ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'182039000203','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(641,'SAMSOL HAIR COLOR #45',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'182039000067','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(642,'SAMSOL SHAVING CREAM 72G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'182039000418','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(643,'SAVANNAH ANTI ACNE FACE WASH 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6291003659898','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(644,'SAVANNAH BS CLASSIC 125G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6291003260056','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(645,'SAVANNAH BS EXOTIC GLOW 125G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6291003615764','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(646,'SAVANNAH FACE WASH 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6291003659911','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(647,'SAVANNAH OIL FREE FACE WASH 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6291003659904','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(648,'SENSODYNE 50G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'1507000224973','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(649,'SENSODYNE COMPLETE P 100G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'4457132488019','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(650,'SENSODYNE COMPLETE P 70G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'4457132488026','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(651,'SENSODYNE DEEP CLEAN 100 GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'9204757321000','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(652,'SENSODYNE DEEP CLEAN 70G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'5060415523339','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(653,'SENSODYNE FLUORIDE 100G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'9200475731008','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(654,'SENSODYNE FLUORIDE 70G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'9200475730704','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(655,'SENSODYNE FOR KIDS 50G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'1507000224997','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(656,'SENSODYNE FOR KIDS 50G P',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'1507000224980','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(657,'SENSODYNE HERBAL MULTI CARE 100GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'9200773410063','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(658,'SENSODYNE MULTI CARE  100G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'9200475781003','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(659,'SENSODYNE MULTI CARE 70G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'9200475780709','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(660,'SENSODYNE ORIGINAL 50G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'9200475760503','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(661,'SENSODYNE ORIGINAL 70G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'4567995365683','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(662,'SENSODYNE ORIGNL 100',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'9200475761005','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(663,'SENSODYNE RAPID ACTION 100G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'9200475721009','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(664,'SENSODYNE RAPID ACTION 70G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'9200475720705','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(665,'SG EXTRA W/L VITAMIN C 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000257654','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(666,'SHAN ACHAR GOSHT RM 100G D-PACK',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'788821001306','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(667,'SHAN BANASPATI 1KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000293201','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(668,'SHAN BIRYANI RM 100G D-PACK',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'788821001276','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(669,'SHAN CHICKEN MASALA RM 100G D-PACK',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'788821001337','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(670,'SHAN CHICKEN TIKKA RM 100G D-PACK',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'788821001313','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(671,'SHAN CHICKEN WHITE KARAHI RM 90G D-PACK',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'788821018182','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(672,'SHAN COOKING OIL 1L',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000293232','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(673,'SHAN DANEDAR SHAHI HALEEM MIX 350G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'788821151711','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(674,'SHAN EASY COOK HALEEM MIX 350G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'788821151704','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(675,'SHAN HALEEM RM 110G D-PACK',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'788821005458','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(676,'SHAN KARAHI RM 100G D-PACK',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'788821001283','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(677,'SHAN KORMA RM 100G D-PACK',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'788821001290','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(678,'SHAN MANGO CHUTNEY 400GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'788821000866','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(679,'SHAN NIHARI RM 120G D-PACK',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'788821001269','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(680,'SHAN PAYA RM 100G D-PACK',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'788821002105','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(681,'SHAN PILAU BIRYANI RM 85G D-PACK',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'788821002082','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(682,'SHAN S BOMBAY BIRYANI RM 130G D-PACK',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'788821001252','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(683,'SHAN SHAMI KABAB RM 100G D-PACK',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'788821005472','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(684,'SHAN SINDHI BIRYANI RM 110G D-PACK',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'788821002099','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(685,'SHAN TANDOORI RM 100G D-PACK',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'788821005465','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(686,'SHAN TIKKA SEEKH KABAB RM 100G D-PACK',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'788821002112','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(687,'SHAN WHITE CHICKEN KORMA RM 90G D-PACK',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'788821018175','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(688,'SHANGRILA BAR B Q SAUCE 400G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000022184','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(689,'SHANGRILA CHILLI SAUCE 275ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000020180','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(690,'SHANGRILA GUAVA 1L',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000843857','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(691,'SHANGRILA MIX PICKLE 400 GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000020678','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(692,'SHANGRILA MIXED PICKLE 1KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000020685','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(693,'SHANGRILA MIXED PICKLE 400G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000020784','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(694,'SHANGRILA SOY SAUCE 275ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000020081','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(695,'SHANGRILA SYNTHETIC VINEGAR 275ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000020289','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(696,'SHEZAN LEMON SQUASH 800ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'5078643001154','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(697,'SHEZAN TOMATO KETCHUP P 500G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000051078','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(698,'SHIELD BABY FIDER L',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964002137985','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(699,'SHIELD BABY WIPES 60PCS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964002137619','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(700,'SHIELD DELUME PLUS FEEDER 250ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001492283','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(701,'SHIELD DELUXE EVENFLO FEEDER 250ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001492191','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(702,'SHIELD DELUXE PLUS FEEDER 125M*',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001492276','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(703,'SHIELD EVENFLO FEEDER 125ML*',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001492160','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(704,'SHIELD EVENFLO FEEDER WITH HANDLE 125ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964002137978','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(705,'SHINE ULTRA BLUE 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8959030000486','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(706,'SHOE BRUSH',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'122004','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(707,'SHOE BRUSH RS 130',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'125002','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(708,'SILVER SHOE SHINE 75ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8690757001058','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(709,'SKIN WHITE SOAP DRY SKIN 110G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000578445','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(710,'SKIN WHITE SOAP NORMAL SKIN 110G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000578001','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(711,'SKIN WHITE SOAP OILY 110G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000578452','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(712,'SKIN WHITE SOAP SENSEITIVE 110G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000578483','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(713,'SMILE APPLE FD 1L',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000843925','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(714,'SMILE LYCHEE 1L',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000843888','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(715,'SMILE MIX FRUIT DRINK 1L',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000843529','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(716,'SODA WHITE TOOTH PASTE 135G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000570517','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(717,'SODA WHITE TOOTH PASTE 28G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000570166','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(718,'SODA WHITE TOOTH PASTE 65G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000570173','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(719,'SODA WHITE TOOTH PASTE BP 65G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000570180','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(720,'SOFTLAN FLORAL FANTASY 425ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950018256','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(721,'SOFTLAN FLORAL FANTASY 500ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950018058','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(722,'SOFTLAN SF 425ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950018263','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(723,'SOGO ZAPP IT COIL;',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8966000060401','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(724,'SPARKLE TOOTH PASTE 200G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950066479','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(725,'SPRITE 1.5L',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'5449000012203','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(726,'SPRITE 1L',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'5449000050939','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(727,'SPRITE 2.25 LITER',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'5449000034137','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(728,'SPRITE MINT 1.5 L',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'5449000216854','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(729,'SPRITE MINT 1L',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'5449000253958','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(730,'SUFAID CHANNE BRK 1 KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'900579','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(731,'SUFAID CHANNE BRK 500G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'900297','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(732,'SUFAID CHANNE MED  1KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'900288','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(733,'SUFAID CHANNE MED 500GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'900289','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(734,'SUFAID CHANNE MOTA 1KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'900884','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(735,'SUFAID LOBIYA 1KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'900324','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(736,'SUFAID LOBIYA 500GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'900325','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(737,'SUFI BANASPATI 1KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000038581','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(738,'SUFI CANOLA OIL 1L POUCH',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000038307','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(739,'SUFI SAFON LIQUID 600ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000039830','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(740,'SUFI SPECIAL BANASPA 1KG POUCH',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000038383','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(741,'SUFI SUNFLOWER OIL 1LTR POUCH',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000038284','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(742,'SUFI SUPER  POWDER 500GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001276043','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(743,'SUFI VERMICELLI 1KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000039571','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(744,'SUFI VERMICELLI 500GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000039595','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(745,'SUJI 500 GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'900721','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(746,'SUNLIGHT 2 IN 1 1KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014262131','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(747,'SUNLIGHT JASMINE 1 KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014262148','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(748,'SUNSILK DR SHAMPOO 160ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8851932354974','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(749,'SUNSILK HF SHAMPOO IMP 160ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8851932355049','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(750,'SUNSILK LC&F SHAMPOO 160ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8851932355025','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(751,'SUNSILK PS SHAMPOO IMP 160ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8851932354981','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(752,'SUNSILK SMOOTHIES CON 160ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8851932355438','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(753,'SUNSILK THAI SHAMPOO 160ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8851932354998','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(754,'SUNSILK THICK&LONG CON 180ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014250411','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(755,'SUPREME TEA 160G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'5063305006738','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(756,'Surf Excel Liquid Detergent 500ml',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014239621','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(757,'SW RICE MILK FW 50G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'796554222004','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(758,'SW WHIT FW DRY SKIN 60ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000578926','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(759,'SW WHIT FW NORMAL SKIN 60ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000578094','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(760,'SW WHIT FW OILY SKIN 60ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000578469','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(761,'TAHARAT SAFETY RAZOR',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'7398880011142','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(762,'TAPAL DANAEDAR 170G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961103600585','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(763,'Tapal Danedar 170G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961103601964','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(764,'TAPAL DANEDAR TEABAGS 25PCS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'815096000908','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(765,'TAPAL FAMILY MIX TEA 190GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'815096000687','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(766,'TAPAL FAMILY MIXTURE 170G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961103600479','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(767,'TAPAL GREEN TEA BAGS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'815096003442','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(768,'TAPAL GREEN TEA JASMINE 100GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'815096000311','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(769,'TAPAL GREEN TEA JASMINE 30BAGS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'815096000342','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(770,'TAPAL GREEN TEA LEMON 30TB',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'815096000373','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:01','2024-12-09 15:46:01'),(771,'TAPAL GREEN TEA LEMON GRASS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'815096001981','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(772,'TAPAL GREEN TEA MANGO 30TB',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'815096003435','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(773,'TAPAL GREEN TEA PEACH 30TB',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'815096002155','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(774,'TAPAL GREEN TEA PURE GREEN 30TB',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'815096002131','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(775,'TAPAL GREEN TEA SP  32TB',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'815096000809','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(776,'TAPAL GREEN TEA STRAWBERRY 30TB',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'815096002148','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(777,'TAPAL MINT GREEN TEA  30P',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'815096000595','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(778,'TAPAL TEA ELAICHI 45G/30 TB',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'815096000397','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(779,'TAPAL TEZDAM TEA 170G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'815096001868','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(780,'TIBET COLD CREAM 40ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961100002900','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(781,'TIBET COLD CREAM 60ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961100002931','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(782,'TIBET TALCUM LARGE 365GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961100001460','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(783,'TIBET TALCUM SMALL 85GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961100001408','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(784,'TILLONA SESAME OIL 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000088197','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(785,'TIME CHILLY SAUCE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'228628','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(786,'TIME SOY SAUCE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'228656','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(787,'TOPIC AF DIRHUM 300ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964002994045','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(788,'TOPIC AF ROMANTIC 300ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964002994052','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(789,'TOPIC AF SWEET 300ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964002994069','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(790,'TOPIC AF VDV 300ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000834831','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(791,'TOSHIBA CELL D SIZE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'4904530591952','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(792,'TRIO DISHWASH GEL 475ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8959030000523','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(793,'TWIN DETERGENT 1 KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001277989','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(794,'VASELINE AS BODY L 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8999999045562','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(795,'VASELINE COCOA RADIANT LOTION 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8999999020354','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(796,'VASELINE DEEP RESTORE 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8999999003081','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(797,'VASELINE HB B-LOTION 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8999999024772','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(798,'VASELINE IC ALOE FRE LOTION 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8999999003074','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(799,'VASELINE UV EXTRA B LOTION 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8999999719395','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(800,'VATIKA ALMOND HAIR OIL 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6291069705348','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(801,'VATIKA ARGAN HAIR OIL 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6291069724806','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(802,'VATIKA BLACK SEED HAIR OIL 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6291069724820','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(803,'VATIKA BLACK&STRONG CONDITIONER',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964002493333','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(804,'VATIKA CACTUS COND 180ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964002493326','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(805,'VATIKA CACTUS OIL 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6291069705355','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(806,'VATIKA COCONUT HAIR OIL 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6291069705331','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(807,'VATIKA GARLIC HAIR OIL 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6291069724813','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(808,'VATIKA MOISTURE TREATMENT CON 180ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964002493319','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(809,'VATIKA NATURAL SHIKAKAI',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6291069715682','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(810,'VATIKA NOURISH & PROTECT CONDITIONER',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6291069701685','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(811,'VATIKA OLIVE HAIR OIL 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6291069705324','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(812,'VATIKA ONION',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964002493234','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(813,'VATIKA SARSON HAIR OIL 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6291069709773','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(814,'VEET HRC DRY SKIN 40GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6001106209803','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(815,'VEET HRC DRY SKIN 50GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6001106309503','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(816,'VEET HRC NORMAL SKIN 25GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961101234027','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(817,'VEET HRC NORMAL SKIN 40GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6001106209650','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(818,'VEET HRC PURE DRY SKIN 25GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961101233952','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(819,'VEET HRC PURE NORMAL SKIN 50GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961101233945','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(820,'VEET HRC PURE NORMAL SKIN 50GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961101234010','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(821,'VEET HRC PURE SENSITIVE SKIN 25GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961101234065','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(822,'VENEEZIA LEMON WAX CREAM 135G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'7466050611123','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(823,'VENEEZIA LEMON WAX CREAM L 235G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'2889915058355','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(824,'VIKING GLASS CLEANER',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964002504114','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(825,'VITAL CARDAMOM GREEN TEA 30P',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000008850','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(826,'VITAL LEMON GREEN TEA 30P',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000008812','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(827,'Vital Lemon GT 30PCS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000818534','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(828,'VITAL PLAIN GREEN TEA 30P',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000008805','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(829,'VITAL TEA 190G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000008102','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(830,'VITAL TEA CHAMBMILE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001400233','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(831,'WHITE ROSE HAIR REMOVAL LOTION',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'045895600133','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(832,'WHITE ROSE LOTION H/R 80G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'4744545164761','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(833,'YC F/WASH MILK EXTRACT 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8857101125703','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(834,'YC NEEM FACE WASH 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8857101150651','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(835,'YC W/FACE WASH LEMON 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8857101125390','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(836,'YOUNGS BBQ CHICKEN SPREAD 500ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000062616','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(837,'YOUNGS CHICKEN SPREAD 200ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000061534','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(838,'YOUNGS CHICKEN SPREAD FAJITA 200ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000062654','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(839,'YOUNGS CHOCOLATY SPREAD SMALL',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000061725','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(840,'YOUNGS CRAVE DARK CC 200G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000062432','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(841,'YOUNGS HONEY 125GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000061831','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(842,'YOUNGS MAYO CHUP 500ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000061213','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(843,'YOUNGS MAYO GARLIC 500ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000061312','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(844,'YOUNGS MAYO RED CHILLI 500ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000061275','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(845,'YOUNGS SANDWICH SPREAD 500ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000061633','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(846,'PALMOLIVE RADIANT GLOW 3 IN 1',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950039381','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(847,'SOFTLAN SPRING FRESH 500ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950018065','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(848,'BIO AMLA HAIR OIL 200ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6009689191072','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(849,'BLUE BAND MAJ SPREAD 475G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961102110313','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(850,'BONUS TRISTAR SAVING PACK',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950013596','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(851,'CAPRI MOISTURISING PEACH 3PC',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961100023172','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(852,'COLGATE PASTE HERBAL 200GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950052069','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(853,'COLGATE TP MCP REGULAR 200+100G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950051390','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(854,'DETTOL LIQUID 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6001106309435','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(855,'EDENROC RASH CARE ARP 150G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'333673772272','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(856,'FORHANS TOOTHPAST 200G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000024164','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(857,'HIMALAYA NEEM FACE WASH 50ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001764021','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(858,'LIFIBUOY TOTAL PROTECT B 315',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014262971','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(859,'LOREAL FALL RESISIT 175ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'3610340655418','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(860,'MAR ALMOND OIL 25ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000057346','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(861,'MAR ISPAGHOL 25G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000057094','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(862,'MAR ISPAGHOL 50G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000057100','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(863,'MARHABA COCONAT OIL 200ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000054147','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(864,'MAX ALL PURPOSE CLEANER 500ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950086026','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(865,'MIT SQUASH 810ML LEMON',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961005010017','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(866,'MIT SQUASH 810ML MANGO',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961005010031','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(867,'MIT SQUASH 810ML ORANGE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961005010048','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(868,'MOTHERCARE BABY OIL 65ML.',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000982150','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(869,'PEARS BODY WASH 250ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6281006485396','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(870,'QARSHI ISPAGHOL HUSK 50G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'855434000542','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(871,'ROSE PETAL PARTY PACK',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961006040136','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(872,'SAFEGUARD FAMILY GERM PROTECT',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8006540639245','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(873,'SAFEGUARD FLORAL BLOOM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8006540639122','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(874,'SAFEGUARD FP LEMON FRESH',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8006540639177','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(875,'SOFTLAN FLORAL FANTASY 1L',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950018010','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(876,'SOFTLAN SPRING FRESH 1L',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950018027','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(877,'VEET HRC DRY SKIN 80GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6001106209797','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(878,'VEET HRC NORMAL SKIN 80GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6001106209643','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(879,'VEET HRC PURE SENSITIVE SKIN 50GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961101234058','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(880,'VEET HRC SENSTIVE SKIN 50GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6001106309527','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(881,'YOUNGS MAYONNAISE 500ML POUCH',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000061114','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(882,'BRITE TOTAL 1KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950011066','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(883,'DOMEX DISINFECTS 500ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014247848','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(884,'DOMEX ORIGINAL 500ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014001792','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(885,'F&L GLOW&LOVELY 65ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014261660','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(886,'GARNIER MEN FW ACNO FIGHT 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'3610340648717','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(887,'LOREAL ELVIV DREAM LONG S72H',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'3610340663468','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(888,'LOREAL ELVIVE 6OIL NOURISH CON 175ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'3610340655333','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(889,'LOREAL ELVIVE COLOUR PROTECT CONDITIONER 175ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'3610340655364','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(890,'LOREAL ELVIVE DREAM LONG 175ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'3610340653858','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(891,'LOREAL ELVIVE DREAM LONG S 72HCON 175ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'3610340663451','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(892,'LOREAL HYALURON 175ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'3610340670404','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(893,'LOREAL PARIS 6 OIL 175ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'3610340655326','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(894,'LOREAL TOTAL REPAIR 5 CON 175ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'3610340654275','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(895,'SUNSILK BLACK SHINE CON 180ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014250404','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(896,'Surf Excel Liquid Detergent 1000ml',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014261271','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(897,'Surf Excel Liquid Detergent 1000ml',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014253320','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(898,'SURF EXCEL MATRIC',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014008098','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(899,'AFTAB ARQ GULAB 800ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964003244354','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(900,'AL ARABIA SOFT',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6769791001422','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(901,'AL FARES DRY AIR FRESHNER',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'676979100944','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(902,'ALSHABAB SHAVER',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6949586645554','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(903,'ALWAYS DREAMZZZ 8PCS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'4015400648215','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(904,'ALWAYS FRESH ULTRA NORMAL 8PAD',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'4015400214496','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(905,'ALWAYS MAXI THICK E/LONG 8P',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'4015400457848','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(906,'ALWAYS MAXI THICK LONG 9PCS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'4015400417491','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(907,'ALWAYS ULTRA X/LONG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'4015400205258','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(908,'BARAKAH CLASSIC TISSUE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001141624','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(909,'BARRAQ OLIVE OIL 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'4710091017','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(910,'BH CHAWAL 2KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'999311','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(911,'BIO AMLA SHAMPOO 130ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6009689191621','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(912,'BLUESEAL VASELINE ALOE FRESH',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'60018885','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(913,'BLUESEAL VASELINE COCOA BUTTER 50ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'60018939','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(914,'BOOM PARTY PACK PINK',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001141419','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(915,'BRITE MACHINE WASH 1KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950011516','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(916,'CARE FAIRNESS CREAM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6009679062030','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(917,'CARE N/HONEY LOTION 110**',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6009679062443','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(918,'CHOCO BLISS CHOCO SPREAD M',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000062395','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(919,'CHOCO BLISS DOUBLE CHOCOLATE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000062777','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(920,'CHOCO BLISS PEANUT',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000062739','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(921,'CLEAN&CARE FACE WASH 50ML**',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8991111111964','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(922,'CLEAR BLACK SHINE SHAMPOO 185ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014245158','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(923,'CLEAR LEMON FRESH SHAMPOO 185ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014245202','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(924,'CLEAR SHAMPOO C/C 185ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014245189','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(925,'COMFORT 800ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014246971','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(926,'COMFORT LILY FRESH 800ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014247022','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(927,'CRACKERS DASHI PAPAD',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000241905','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(928,'CRUSHED PICKLE MIXED',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'620514015699','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(929,'DAAL CHANNA  2KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'900281','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(930,'DAAL MASH CHILKA 1KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'900336','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(931,'DAAL MASH DHULLI 1KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'900340','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(932,'DAAL MONG CHILKA 500GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'900802','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(933,'DABUR AMLA H/OIL 200ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'5022496102001','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(934,'DABUR RED TOOTH PASTTE 200G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8901207000324','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(935,'DAGHI CHAWAL 2 KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'900578','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(936,'DARHAHIM  AIR FRESHNER',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'676979101163','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(937,'DASHI BREAD CRUMBS 200G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000241776','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(938,'DETTOL COOL 4 IN 1',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961101234133','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(939,'DETTOL LEMON FRESH 4IN1',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961101233136','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(940,'DETTOL ORIGINAL HAND WASH 250M',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6001106209070','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(941,'DETTOL SAVE PACK ORIGINAL 1X4PC',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961101230937','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(942,'DETTOL SKIN CARE HAND WASH 250ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6001106209087','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(943,'DETTOL SOAP BP SKINCARE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961101233006','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(944,'DETTOL SOOTHE PACK 4',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961101232993','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(945,'DOCTOR PASTE 220GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000961377','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(946,'DORCO RAZOR 5 IN 1',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8801038562476','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(947,'DORCO TG 2 PLUS 5RAZOR',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8801038514895','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(948,'DOVE 2in1 DAILY CARE 200ML IMP',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6281006532441','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(949,'DOVE BEAUTY MOISTURE 100G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8999999598310','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(950,'DOVE DEEP PURE FACE WASH 100G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8999999597849','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(951,'DOVE DRYNESS CARE 175 ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014260786','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(952,'DOVE HAIRFALL RESCUE 175 ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014260779','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(953,'DOVE HAIRFALL RESCUE CON 180ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014255652','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(954,'DOVE INNER GLOW FACEWASH 100G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8999999597856','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(955,'DOVE INTENSE REPAIR CON 180ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014255645','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(956,'DOVE NOC SHAMPOO 175ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014254655','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(957,'DOVE NOURISHING OIL CARE FOR FIRZY DRY HAIR',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014260793','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(958,'DOVE PINK ROSA SOAP 135G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'7501056349288','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(959,'DOVE SHAMPOO INTENSE REPAIR 175ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014260809','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(960,'ENCHANTER STUNNING',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8888202065254','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(961,'ENCHANTEUR  ALLURING',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8888202026415','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(962,'ENCHANTEUR CHARMING TP 125G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'88821191','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:02','2024-12-09 15:46:02'),(963,'ENCHANTEUR GORGEOUS TP 125G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8888202045720','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(964,'ENCHANTEUR ROMANTIC 125G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'88821184','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(965,'ENCHANTEUR ROMANTIC L',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8888202005069','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(966,'ENCHANTEUR TALCAM 125G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8888202035233','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(967,'ENCHANTEUR TP ALLURING 250G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8888202026422','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(968,'ENCHANTEUR TP CHARMING 250G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8888202065261','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(969,'ENCHANTEUR TP GORGEOUS 250G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8888202035240','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(970,'ENG PRICKLY HEAT',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000572238','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(971,'ENG PRICKLY HEAT POWDER 220G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000572498','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(972,'ENGLISH A/LICE SHAMPOO F/PACK',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000571057','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(973,'F&L GLOW&LOVELY 50G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014261721','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(974,'FA AQUA DEODORENT 50ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'4015000280235','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(975,'FA BRIGHTNING&CARE ROLL-ON 50ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6281031255421','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(976,'FA CARIBBEAN WAVE 50ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'4015000280211','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(977,'FA FIJI DREAM 50ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6281031265604','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(978,'FA INVISIBLE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6281031265857','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(979,'FA MYSTIC MOMENTS 50ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6281031243534','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(980,'FA ROLL ON PINK PARADISE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'4015000519977','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(981,'FA SPORT SCENT',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'4015000280372','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(982,'FASCINO PRIME MAVIS BLOCK 250ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6291107676999','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(983,'FASCINO PRIME MAVIS GREEN 250ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6291107677002','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(984,'FASCINO PRIME VENIN 250ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6291107677040','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(985,'FAUJI CHOCO CORN FLAKES 250G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000064405','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(986,'FAUJI PHENYLE 3LTR',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'1595444333016','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(987,'FAUJI PHYNLE NEW 3L',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'5252585888886','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(988,'FOGG B/S BLUE 120ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8908001158480','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(989,'FOGG MAJESTIC B/SPRAY',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8908001158497','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(990,'FOGG MARCO BLACK 120ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8908001158305','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(991,'FOGG MONARCH BODY SPRAY 100G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8908001158954','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(992,'FOGG NAPOLEON DEO 120ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8908001158244','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(993,'FOGG PARADISE BODY SPRAY 100GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8908001158350','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(994,'FOGG ROYAL 120ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8908001158312','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(995,'FOGG VICTOR BODY SPRAY 100G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8908001158961','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(996,'FRUTON BERRY MAGIA HW 450ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6291107677965','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(997,'FRUTON CITRUS LEMON HW 450ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6291107677934','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(998,'FRUTON LIME REVIVE HW 450ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6291107677958','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(999,'FRUTON ORANGE SATSUMA HW 450ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6291107677941','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1000,'FRUTON STAWBERRY BLISS HW 450ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6291107677972','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1001,'GARNIER ACNO FIGHT F/W 50ML*',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001174783','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1002,'GARNIER MEN POWER WHITE 50ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001174769','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1003,'GARNIER SA FAST CLEAR FW 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'3610340672163','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1004,'GATSBY ANTI DANDRUFF HAIR CREAM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'4902806005509','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1005,'GATSBY LONG LASTING 125G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'4902806001518','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1006,'GERMSHOOT TC 250ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8959030000547','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1007,'GILLETTE BLUE 3 COMFORT',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'7702018494149','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1008,'GILLETTE FLEXI BLUE3',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'7702018608959','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1009,'GLOW & LOVELY 80G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014236835','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1010,'GOHNSONS BABY OIL 125ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8991111101323','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1011,'GOHNSONS BABY SHAMPOO 300ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'3574669907057','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1012,'GOLDEN PEARL D HERBAL FW 150ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964003015091','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1013,'GOLDEN PEARL FACE WASH 150ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001753292','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1014,'GOLDEN PEARL MEN FW 150ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964003015084','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1015,'GOLDEN PEARL OIL CONTROL FACEWASH 150ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964003015107','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1016,'GP HELLO HAIR COLOR #1',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964003015756','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1017,'GP HELLO HAIR COLOR #3',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964003015763','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1018,'GP HELLO HAIR COLOR #3.6',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964003015770','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1019,'GP HELLO HAIR COLOR #4',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964003015787','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1020,'GREEN LEAF TEA 430G..',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6428569632144','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1021,'H&S ANTI-HAIRFALL SHAMPOO 185ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8001841299303','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1022,'H&S CLASSIC CLEAN  SHAMPOO 185ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8001841299150','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1023,'H&S DRY SCALP CARE SHAMPOO 185ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8001841299211','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1024,'H&S NEEM SHAMPOO 185ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8006540314159','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1025,'H&S REFRESHING MENTHOL SHAMPOO 185ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8001841299181','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1026,'H&S SILKY BLACK SHAMPOO 185ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8001841299365','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1027,'H&S SMOOTH&SILKY SHAMPOO 185ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8001841299273','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1028,'HAMALIYA ALOE VERA FACE/W 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001764052','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1029,'HAVOC DEODRANT SPRAY 200ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'3700082500357','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1030,'HELLO HAIR BURGUNDY 4.6',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964003015794','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1031,'HELLO HAIR LIGHT BROWN 5',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964003015800','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1032,'HIMALAYA APRICOT FACE WASH 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001764281','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1033,'HIMALAYA CHARCOAL FACE WASH 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001764427','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1034,'HIMALAYA CLEAR COMPLEXION FACE WASH 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001764120','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1035,'HIMALAYA LEMON FACE/W 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001764083','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1036,'HIMALAYA NATURAL GLOW FACE WASH 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001764557','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1037,'HIMALAYA NEEM FACE WASH 100ML*',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001764014','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1038,'ISFAHAN ARABIAN NIGHT',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964003538163','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1039,'ISFAHAN BAKHOOR AL ARAB',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964003538095','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1040,'ISFAHAN DINAR',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964003538071','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1041,'ISFAHAN JAMAL',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964003538118','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1042,'ISFAHAN MUKHALAL MANAN',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964003538149','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1043,'ISFAHAN SHEIKHAA',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964003538125','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1044,'ITALIA BLACK SLI OLIVES 235G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6890767852738','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1045,'ITALIA GREEN SLI OLIVES 235G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'7051055555390','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1046,'ITALIA OLIVE POMACE OIL 175ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6890767822724','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1047,'ITALIA POMACE OIL 125ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6890767817706','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1048,'JHONSONS BABY OIL 125ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'4801010501312','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1049,'JOHNS BABY OIL COLOGNE 125ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'4801010120223','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1050,'JOHNSON BABY OIL COLOGNE BRISA 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8991111101583','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1051,'JOHNSONS BABY POWDER 200MG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8991111101422','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1052,'JOHNSONS BABY SHAMPOO 300ML*',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'3574669907842','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1053,'KALA KOLA HAIR TONIC 200ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000047125','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1054,'KENYA HIGH GROWN TEA 250GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8966000024915','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1055,'KING MOUSE RAT KILLER GLUE TRAP',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'653341107077','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1056,'KIWI  LIQUID SHOE POLISH D/T',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000749425','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1057,'KIWI SHOE POLISH LIQ 75ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000749401','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1058,'KLIM COCOA POWDER 85G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'3684634275255','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1059,'KNOR TOMATO KETCHUP 800G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014024449','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1060,'KNORR CHILLI GARLIC 800G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014032123','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1061,'KNORR CHILLI GARLIC 800G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014024456','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1062,'KNORR TOMATO KETCHUP 800 G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014032116','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1063,'LAAL LOBIYA 1KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'900328','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1064,'LAZZAT COCOA POWDER 80G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'334483045433','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1065,'LIFEBOUY NATURALLY LONG SHAMPOO 175ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014261158','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1066,'LIFEBUOY HERBAL 175ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014261141','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1067,'LIFEBUOY NATURALLY STRONG 175ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014255959','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1068,'LIFEBUOY SILKY SOFT 175 ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014261127','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1069,'LOREAL COLOR PROTECT 175 ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'3610340655401','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1070,'LOREAL FALL RESIST 175ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'3610340655388','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1071,'LOREAL PARIS DREAM LONG 175ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'3610340653841','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1072,'LOREAL TOTAL REPAIR 5 175G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'3610340654237','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1073,'LUVVEL LIQUID HANDWASH 500ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'R19L500HPE','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1074,'LUVVEL LIQUID HANDWASH 500ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'R19L500HRS','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1075,'MARHABA ALMOND OIL 50ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000057353','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1076,'MARHABA HONEY 235G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000056073','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1077,'MAXI ROLL TISSUE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001141594','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1078,'MECLAY LONDON',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'5060593000172','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1079,'MECLAY LONDON ANTI DANDRUFF 360ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'5060593000561','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1080,'MECLAY LONDON COLOUR PROTECT 360ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'5060593000592','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1081,'MECLAY LONDON DAMAGE REPAIR 360ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'5060593000578','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1082,'MECLAY LONDON HAIR FALL DEFENSE 185ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'5060593000134','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1083,'MECLAY LONDON L&H 185ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'5060593000127','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1084,'MECLAY LONDON LONG&HEALTHY 360ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'5060593000530','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1085,'MECLAY LONDON LUSTROUS SHINE 360ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'5060593000509','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1086,'MECLAY LONDON LUSTROUSE185ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'5060593000103','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:03','2024-12-09 15:46:03'),(1087,'MECLAY LONDON S&H SHAMPOO 360ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'5060593000554','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1088,'MECLAY LONDON S&S SHAMPOO 360ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'5060593000523','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1089,'MECLAY LONDON SOFT & SILKY 185ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'5060593000158','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1090,'MECLAY LONDON STRONG & HEALTHY 185ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'5060593000141','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1091,'MECLAY LONDON THICK & D ENSE185ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'5060593000110','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1092,'MECLAY LONDON THICK & DENSE 360ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'5060593000516','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1093,'MEDICAM PASTE 200G B/P',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6291101525668','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1094,'MEDORA PERFUME SHADOW',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961100040568','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1095,'MEZAN ROYAL COOKING OIL 1L',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000611388','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1096,'MILO POWDER 300G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961008215600','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1097,'MINHAJ MURABBA  AMLLA 1KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'999259','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1098,'MINHAJ MURABBA  APPLE 500G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'999254','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1099,'MINHAJ MURABBA AMLA 500G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'999253','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1100,'MINHAJ MURABBA APPLE 1KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'999258','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1101,'MINHAJ MURABBA ASHARFI 1KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'999366','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1102,'MINHAJ MURABBA BAHEE 1KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'999381','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1103,'MINHAJ MURABBA GAJJAR 1KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'999257','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1104,'MINHAJ MURABBA GAJJAR 500G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'999255','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1105,'MINHAJ MURABBA HAREER 1KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'999363','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1106,'MINHAJ MURABBA HAREER 500G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'999364','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1107,'MINHAJ MURABBA KRONDA 1KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'999256','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1108,'MINITREE HANDLE BOTTLE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'261874463312','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1109,'MIT APPLE JAM TIN 1050G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961005090019','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1110,'MIT GOLD MIST MARMALD JAM 450G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961005050013','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1111,'MIT GOLDEN APPLE JAM 200GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961005030404','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1112,'MIT GOLDEN APPLE JAM 450 ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961005030022','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1113,'MIT MANGO JAM 1050G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961005090040','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1114,'MIT MANGO JAM 200GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961005030411','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1115,'MIT MANGO JAM 450G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961005030039','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1116,'MIT MIX FRUIT JAM 450G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961005030046','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1117,'MIT MIX JAM 1050G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961005090033','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1118,'MIT MIXED FRUIT JAM 200GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961005030428','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1119,'MIT ORANGE MARMALADE1050G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961005090026','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1120,'MIT STRAWBERRY JAM 1050G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961005090088','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1121,'MITCHELLS LEMON JUICE 800ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961005010918','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1122,'MITCHELS GOLDEN APPLE JAM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961005030053','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1123,'MITCHELS MARMALADE JAM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961005050044','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1124,'MITCHELS MIXED FRUIT JAM 300G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961005030107','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1125,'MITCHELS STRAWBERRY JAM 300G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961005030091','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1126,'MITCHELS STRAWBERRY JAM 300G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961005030497','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1127,'MORTEIN PEACEFUL NIGHTS COILS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6001106114862','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1128,'MOTHER CARE BABY LOTION 115ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000982433','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1129,'MOTHER CARE G RASH  POWDER 150GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000982051','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1130,'MOTHER CARE GO RASH POWDER 250GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000982068','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1131,'MOTHER CARE SUN BLOCK 75G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000982372','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1132,'MOTHERCARE BABY SHAMPOO 110ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000982570','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1133,'NAT APPLE JAM 440G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'620514001920','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1134,'NAT CHILLI GARLIC SAUCE 500G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'620514008530','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1135,'NAT CRUSHED PICKLE MIXED 750G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'620514015705','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1136,'NAT MANGO JAM 440G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'620514001937','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1137,'NAT MARMALADE JAM 440G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'620514001951','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1138,'NAT MIX FRUIT JAM 440G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'620514001975','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1139,'NAT MIX PICKLE 370G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'620514009728','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1140,'NAT MIXED PICKLE 365G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'620514019260','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1141,'NAT MIXED PICKLE 370G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'620514020334','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1142,'NAT PICKLE MIX 1KG JAR',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'620514000701','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1143,'NAT STRABERRY JAM 440G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'620514001944','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1144,'NAT TOMATO KETCHUP 500GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'620514006130','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1145,'NATIONAL TOMATO KETCHUP 400G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'620514019208','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1146,'NATURAL JAM 1KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'900370','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1147,'NES CERELAC NS DATES 175G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961008235103','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1148,'NES MILO  CHOCLATE POWDER 150G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961008220826','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1149,'NES NIDO 1+ 375GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961008224848','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1150,'NES NIDO 3+ 375GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961008223155','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1151,'NESTLE BUNYAD 260G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961008218700','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1152,'NESTLE CERELAC NATURE SELECTION 350G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961008235110','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1153,'NESTLE CERELAC THREE FRUIT 350G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961008220321','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1154,'NESTLE CERELAC WHEAT 350G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961008220390','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1155,'NESTLE EVERYDAY 230G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961008221717','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1156,'NESTLE EVERYDAY 350G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961008217604','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1157,'NESTLE EVERYDAY MP 560G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961008219363','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1158,'Nestle Lactogen 1 200g',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961008235387','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1159,'Nestle Lactogen 2 200g',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961008235424','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1160,'NESTLE LACTOGEN 200G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961008223193','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1161,'NESTLE LACTOGROW 3 200G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961008223254','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1162,'NESTLE LACTOGROW 3 200G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961008235455','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1163,'NESTLE LECTOGEN RECOVER 200G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961008222295','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1164,'NESTLE NIDO 3+ PRESCHOOL',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961008224862','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1165,'NIVEA BLACK & WHITE 5IN1',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8999777004354','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1166,'NIVEA CREME 60ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'42164104','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1167,'NIVEA EXTRA WHITE LOTION 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8999777000165','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1168,'NIVEA INTENSIVE 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8999777000004','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1169,'NIVEA MEN COOL KICK 50ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8999777004484','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1170,'NIVEA MEN DEEP DARKWOOD 50ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8999777010638','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1171,'NIVEA MEN DEEP ESPRESSO 50ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8999777014315','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1172,'NIVEA MEN FRESH ACTIVE 50ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8999777007355','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1173,'NIVEA MEN SILVER PROTECT 50ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8999777004613','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1174,'NIVEA SOFT 50ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8999777890544','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1175,'OLIVIA HAIR COLOR #14',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001220619','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1176,'OLIVIA HAIR COLOR #16',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001220633','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1177,'OLIVIA HAIR COLOR 01',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'858167000018','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1178,'OLIVIA HAIR COLOR 02',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'858167000025','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1179,'OLIVIA HAIR COLOR 03',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'858167000032','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1180,'OLIVIA HAIR COLOR 04',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'858167000049','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1181,'OLIVIA HAIR COLOR 05',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'858167000056','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1182,'OLIVIA HAIR COLOR 06',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'858167000063','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1183,'OLIVIA HAIR COLOR 07',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'858167000070','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1184,'OLIVIA HAIR COLOR 08',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'858167000087','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1185,'OLIVIA HAIR COLOR 09',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'858167000094','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1186,'OLIVIA HAIR COLOR 10',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'858167000100','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1187,'OLIVIA HAIR COLOR 11',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'858167000568','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1188,'OLIVIA HAIR COLOR 12',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'858167000575','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1189,'OLIVIA HAIR COLOR 20',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001220671','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1190,'OLIVIA LOTION MCM 220ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'858167000285','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1191,'OLPERS PRO CAL LFM 1L',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000144978','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1192,'ORANGE TANG JAR',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'7622201716356','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1193,'ORIGANO 500G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6291106445701','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1194,'ORINGA BUTTERSCOTH BOX 50PCS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001394532','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1195,'OUD AIR FRESHNER',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'676979100937','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1196,'PALMOLIVE A/HAIR/F SHAMPOO 180ML*',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950035086','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1197,'PALMOLIVE BRILLIANT/S SHAMPOO 180ML*',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950035079','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1198,'PALMOLIVE H&S SHAMPOO 180ML*',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950035062','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1199,'PALMOLIVE H&S SHAMPOO 375ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950035123','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1200,'PALMOLIVE I/M SHAMPOO 375ML*',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950035109','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1201,'PALMOLIVE INTENSIVE/M SHAMPOO 180ML*',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950035048','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1202,'PALMOLIVE S/S SHAMPOO 180ML*',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950035055','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1203,'PALMOLIVE S/S SHAMPOO 375ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950035116','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1204,'PANTENE ANTI HAIR FALL SHAMPOO 185ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8001841494159','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1205,'PANTENE ANTI HF CON 180ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8001090791184','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1206,'PANTENE DEEP/BLACK SHAMPOO 185ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8001841494067','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1207,'PANTENE EXTRA TREATMENT 185ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8001841494241','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1208,'PANTENE GOODBYE SUMMER FRIZZ SHAMPOO 185ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8006540333952','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1209,'PANTENE MILKY CONDITIONER 180ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8001090789204','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1210,'PANTENE PRO-V TEMEL BAKIM IMP 200ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8001090915528','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1211,'PANTENE S&S SHAMPOO 185ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8001841494425','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1212,'PANTENE SMOOTH&STRONG CON 180ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8001090792730','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1213,'PARACHUTE COCONUT OIL 100ML..',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8901088169851','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1214,'PARACHUTE COCONUT OIL 200ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8901088167956','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1215,'PARACHUTE COCONUT OIL 90ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8901088150750','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1216,'PARACUUTE COCONUT OIL 170ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8901088149594','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1217,'PARACUUTE COCONUT OIL 170ML IND',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8901088747370','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1218,'PARACUUTE COCONUT&AMLA 7in1 HO 180ml',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6223002233113','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1219,'PARACUUTE COCONUT&ROSEMARY 7in1 HO 180ml',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6223002233137','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1220,'PARACUUTE COCONUT&VITAMIN-E 7in1 HO 180ml',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6223002233090','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1221,'PEARS BLUE SOAP 125G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8901030024023','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1222,'PEARS SOAP GREEN OIL CONTROL',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8901030005176','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1223,'PEARS YELLOW SOAP 125G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'5017306008321','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1224,'POLKA SAWAIYAAN 1KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'900663','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1225,'PONDS ACNE CONTROL 100G FW',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014249026','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1226,'PONDS BRIGHT BEAUTY 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014248913','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1227,'PONDS BRIGHT BEAUTY ANTI-D FW 100G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014263046','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1228,'PONDS BRIGHT BEAUTY CREAM 50GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014248951','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1229,'PONDS BRIGHT MIRACLE PD FW 100G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014263060','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1230,'PONDS FLAWLESS RADIANCE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8851932426862','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1231,'PONDS MEN AS F/W AD+OF 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8999999034719','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1232,'PONDS MEN BB F/W B+BDSC 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8999999034733','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1233,'PONDS MEN EC F/W B+AD',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8999999034696','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1234,'PONDS MEN LIGHTINING OIL CLEAR',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8999999527365','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1235,'PONDS MEN PC F/W PO+DOC 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8999999041656','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1236,'PONDS PURE DETOX 100G FW',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014248920','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1237,'PONDS TRIPLE VITAMIN 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014249002','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1238,'RAFHAN MANGO CUS 20 OFF',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014037746','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1239,'REFRESH MANGO 1L',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000702765','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1240,'REVLON COLORSILK 20DB',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'3099786951245','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1241,'REVLON CS 10 B',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'997869510224','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1242,'REVLON CS 30 DB',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'997869510231','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1243,'REVLON CS GB 54',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'3099786951214','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1244,'REVLON CS HC 51 LB',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'3099786951238','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1245,'REVLON HAIR COLOR SILK NO 30',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'309978695301','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1246,'RIN SURF 1KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014011586','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1247,'RIVAJ BAMBOO CHARCOAL BFW',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'5060453458792','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1248,'RIVAJ CUCUMBER FACE WASH 50ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'5056446709118','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1249,'RIVAJ LEMON BFW 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'5060453455357','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1250,'RIVAJ MILKY EXTRACT BFW 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'5060453455364','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1251,'RIVAJ NEEM BFW 50ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'5060453458051','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1252,'RIVAJ NEEM FW 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'5060453455371','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1253,'RIVAJ PAPAYA BFW 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'5060453456408','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:04','2024-12-09 15:46:04'),(1254,'RIVAJ PAPAYA FACEWASH 50G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'5060453456484','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1255,'RIVAJ SUN BLOCK W&V SPF60* 100',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'5060453450819','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1256,'RIVAJ SUNBLOCK SPF 90',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'5060453450826','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1257,'ROBIN BLEACH 250 ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964002686438','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1258,'ROBIN BLEACH LEMON FRAG 500 ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6001106208622','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1259,'ROBIN BLEACH LIQ 500ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6001106309985','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1260,'ROBIN BLUE LIQ 150ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6001106309725','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1261,'ROSE PATEL KITCHEN TOWEL TWIN PACK',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961006010115','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1262,'ROSE PETAL EMBRACE MAX',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961006090018','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1263,'ROSE PETAL EMBRACE MAX 9 PADS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961006090025','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1264,'ROSE PETAL KITCHEN TOWEL SINGEL',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961006040020','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1265,'ROSE PETAL MULTI COLOR TISSUE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961006010054','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1266,'ROSE PETAL PARTY PACK',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961006040129','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1267,'ROSEPAIR COCOA POWDER 80G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'1788110009128','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1268,'ROUX VINEGAR 750ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8959030100483','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1269,'SABIT MASH KALE 1KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'900332','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1270,'SAEED GHANI SOAP 90G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000258620','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1271,'SAMSOL 12 BEIGE BLONDE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'182039000692','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1272,'SAMSOL 14 MAHOGANY BROWN',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'182039000647','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1273,'SAMSOL 50ML NATURAL BLACK 44',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'182039000043','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1274,'SAMSOL 7 MOCHA',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'182039000685','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1275,'SAMSOL 8 BURGUNDY',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'182039000661','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1276,'SAMSOL 9 MAHOGANY',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'182039000654','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1277,'SAMSOL BLACK 1',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'182039000708','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1278,'SAMSOL COCONUT OIL 200ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'182039000852','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1279,'SAMSOL EGG SHAMPOO 200ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'182039000111','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1280,'SAMSOL HAIR COLOR # 42',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'182039000050','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1281,'SAMSOL HAIR COLOR 36',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'182039000678','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1282,'SAMSOL HAIR COLOR 39',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'182039000036','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1283,'SAMSOL HAIR COLOR 41',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'182039000029','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1284,'SAMSOL HAIR COLOR 43',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'182039000012','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1285,'SAMSOL HAIR COLOR 45',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'182039000005','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1286,'SAMSOL HAIR COLOUR 09',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'182039000722','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1287,'SAMSOL HAIR COLOUR 15',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'182039000760','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1288,'SAMSOL HAIR COLOUR 18',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'182039000715','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1289,'SAMSOL LIGHT BROWN 4',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'182039000753','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1290,'SAMSOL MEDIUM BROWN 3',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'182039000746','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1291,'SHANDAAR LAUNDRY SOAP 1KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6291003625077','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1292,'SHANGRILA APPLE VINEGAR 500ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000843697','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1293,'SHANGRILA CHILLI  GARLIC 400G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000020487','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1294,'SHANGRILA CHILLI SAUCE 700ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000020197','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1295,'SHANGRILA GINGER IMLI SAUCE 500G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000020579','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1296,'SHANGRILA GREEN CHILLI SAUCE 400G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000843109','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1297,'SHANGRILA LEMON JUICE 300ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000843765','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1298,'SHANGRILA MANGO PICKLE 400G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000020791','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1299,'SHANGRILA MANGO PICKLE 500G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000020869','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1300,'SHANGRILA MANGO PICKLE JAR 1KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000020777','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1301,'SHANGRILA MANGO SAUCE 400G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000843291','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1302,'SHANGRILA MIX PICKLE 1 KG JAR',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000020760','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1303,'SHANGRILA MIXED PICKLE 390G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000843642','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1304,'SHANGRILA MP CHUNKS 390G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000843819','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1305,'SHANGRILA MP CHUNKS 750G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000843802','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1306,'SHANGRILA PIZZA SAUCE 500GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000843567','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1307,'SHANGRILA SOY SAUCE 700ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000020098','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1308,'SHANGRILA SYNTHETIC VINEGAR 700ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000020296','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1309,'SHANGRILA TOMATO KETCHUP 400G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000020357','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1310,'SHANGRILA TRIO PACK 120ML 1X3',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000021583','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1311,'SHEZ CHILLI GARLIC SAUCE 1KG P',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000052716','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1312,'SHEZ JAM MANGO 440G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'5078643001208','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1313,'SHEZ JAM STRAWBERY 440G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'5078643001246','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1314,'SHEZ MANGO SQUASH 800ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'5078643001130','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1315,'SHEZ MIX FRUIT JAM 440G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'5078643001215','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1316,'SHEZ ORANGE MARMALDE 440G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'5078643001284','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1317,'SHEZAN APPLE JAM 370G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'5078643001222','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1318,'SHEZAN GARLIC PICKLE 325G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'5078643001116','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1319,'SHEZAN TOMATO KETCHUP P 1KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000051085','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1320,'SHIELD EVENFLO NIPPLE 6M+ TWIN*',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001492351','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1321,'SHINE ULTRA BLUE 200ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8959030000462','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1322,'SHOW ME TEUSER',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6922183620230','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1323,'SIGNATURE LIQUID POLISH',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8984000987665','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1324,'SILVA DRY HAIR FRESHNER',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6769791001354','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1325,'SIRAAT ARQ E GULAAB 800ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001178330','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1326,'SIRAAT SIRKA ANGOORI 800ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001178231','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1327,'SIRAAT SIRKA SAIB 800ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001178200','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1328,'SKIN WHITE GBC 20GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000578339','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1329,'SKIN WHITE LOTION  A&GM 150ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000578384','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1330,'SKIN WHITE LOTION H&GM 150ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000578162','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1331,'SKIN WHITE LOTION SEA BUTTER 150ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000578735','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1332,'SKIN WHITE LOTION V-E&GM 150ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000578377','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1333,'SKIN WHITE RICE MILK FACE WASH 100G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'796554222011','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1334,'SOGA ZAPPIT RAT GLUE TRAP',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964003538194','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1335,'SOGO ZAPPIT KIT',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8966000060418','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1336,'STILLMANS FAIRNESS CREAM 28G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001076056','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1337,'STILLMANS FRECKLE CREAM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001076087','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1338,'SUFI SOAP 1KG SPL',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000039519','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1339,'SUFI SUPER POWDER 1000GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001276029','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1340,'SUNSILK A/D SHAMPOO IMP 300ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8851932355155','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1341,'SUNSILK BLACK SHINE 185ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014250367','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1342,'SUNSILK BLACK SHINE 360ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014251944','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1343,'SUNSILK D/RESTORE SHAMPOO 320ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8851932353908','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1344,'SUNSILK HAIRFALL SOLUTION 185ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014250381','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1345,'SUNSILK HAIRFALL SOLUTION 360ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014251968','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1346,'SUNSILK HEALITHIER&LONG SHAMPOO 280ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8851932353915','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1347,'SUNSILK IMP H/FALL 320ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8851932355162','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1348,'SUNSILK L&H SHAMPOO 185ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014250398','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1349,'SUNSILK LONG AND HEALTHY 360ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014251975','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1350,'SUNSILK NATUIRAL RECHARGE 185ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014236620','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1351,'SUNSILK P&S SHAMPOO 300ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8851932353892','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1352,'SUNSILK PINK SHAMPOO IMP 320ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8851932353885','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1353,'SUNSILK SHAMPOO BS IMP 300ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8851932355131','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1354,'SUNSILK SHAMPOO LIVELY CLEAN&F 300ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8851932355148','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1355,'SUNSILK SHAMPOO SOFT&S IMP 300ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8851932353878','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1356,'SUNSILK THICK AND LONG 185ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014250374','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1357,'SUNSILK THICK AND LONG 360ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014251951','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1358,'SUPREME TEA 430G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'5063305006776','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1359,'SURF EXCEL 1KG NEW',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014264272','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1360,'SURF EXCEL 500G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014260090','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1361,'TANG MANGO 750G JAR',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'7622201716387','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1362,'TAPAL DANEDAR 200GM 100TB',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'815096000915','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1363,'TAPAL DANEDAR 350G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'815096000175','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1364,'TAPAL DANEDAR 350G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961103600516','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1365,'TAPAL DANEDAR 430G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961103600530','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1366,'TAPAL FAMILY MIXTURE 430G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'815096000632','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1367,'TAPAL FAMILY MIXTURE 430g',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961103600370','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1368,'TAPAL TEA BAG 50TB',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'815096003213','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1369,'TAPAL TEZDUM POUCH 430G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'815096000830','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1370,'TIME LEMON SQUASH',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'228765','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1371,'TIME WORCESTERSHIRE SAUCE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'228684','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1372,'TIMES LEMON SQUASH 1LTR',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'900365','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1373,'TIMES MANGO SQUASH 1LTR',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'900363','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1374,'TREET 3',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000768471','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1375,'TRESEMME B N&R SHAMPOO 170ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014262797','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1376,'TRESEMME COLOR REVITALISE 160ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014243468','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1377,'TRESEMME KERATIN SMOOTH 170ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014253863','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1378,'TRESEMME KERATIN SMOOTH CONDITIONER 160ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014242379','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1379,'TRESSEME PT SHAMPOO 170ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014253856','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1380,'TUX LUXURIOUSLY SOFT',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001141495','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1381,'TUX PERFUMED  LUXURIOUSLY',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001141501','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1382,'VASELINE ALOE SOOTHE 200ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8999999003098','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1383,'VASELINE AS LOTION 200ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8999999045579','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1384,'VASELINE BABY JELLY 50ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'60019035','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1385,'VASELINE COCOA BUTTER LOTION 2',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6001087357272','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1386,'VASELINE COCOA RADIANT BL 200ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8999999020293','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1387,'VASELINE FRESH&BRIGHT COOLING LOTION 200ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8999999533373','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1388,'VASELINE HAIR TONIC 200ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8901030203169','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1389,'VASELINE LOTION DRY SKIN 200ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6001087357258','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1390,'VASELINE ORIGINAL JELLY 50ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'60014399','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1391,'VASELINE PERFECT 10in1 LOTION 200ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8999999024789','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1392,'VASELINE UV EXTRA',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8999999719418','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1393,'VATIKA ALMOND & HONEY SHAMPOO 200ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6291069208207','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1394,'VATIKA ARGAN SHAMPOO 200ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6291069706376','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1395,'VATIKA BLACK SEED SHAMPOO 200M',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6291069706390','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1396,'VATIKA BLACK SHINE SHAMPOO 200ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6291069712117','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1397,'VATIKA BLACK SHINE SHAMPOO 200ML*',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6291069701067','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1398,'VATIKA COCONUT SHAMPOO 200ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6291069701265','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1399,'VATIKA EGG SHAMPOO 200ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6291069712179','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1400,'VATIKA GARLIC SHAMPOO 200ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6291069706383','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1401,'VATIKA HAIR FALL SHAMPOO 200ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6291069208245','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1402,'VATIKA HAIR FALL SHAMPOOO 185ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964002493678','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1403,'VATIKA HONEY & EGG SHAMPOO 200ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6291069208221','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1404,'VATIKA LEMON SHAMPOO 200ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8901207040986','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1405,'VATIKA OLIVE SHAMPOO 200ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'5022496001946','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1406,'VATIKA SARSON HAIR OIL 200ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6291069709780','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1407,'VEET HRC DRY SKIN 120GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961101232771','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1408,'VITAL 475G POUCH',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000008027','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1409,'VITAL PREMIUM BLACK TEA 200G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001400202','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1410,'VITAL TEA 385G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000008072','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1411,'VITAL TEA BAGS 50PCS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000008218','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1412,'VITAL TURKISH TEA 150G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001400189','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1413,'WAJEE 43 DARK BROWN',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'2023010050436','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1414,'WAJEE 45',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'2023010050450','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1415,'XTRA KLEEN POP UP',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001598848','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1416,'YOUNG CHICKEN SPREAD 1KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000061596','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1417,'YOUNGS CHICKEN SPREAD 500ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000061541','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1418,'YOUNGS CHICKEN SPREAD FAJITA 500ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000062661','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1419,'YOUNGS CHOCO BLISS HAZELNUT 350G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000062388','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1420,'YOUNGS CHOCOLATY SPREAD 360G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000061701','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1421,'YOUNGS HONEY 240GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000061848','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1422,'YOUNGS PEANUT BUTTER 340G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'725765615541','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1423,'YOUNGS PEANUT BUTTER 340G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'725765615527','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1424,'ZAPP IT SPRAY 325ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8966000060449','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1425,'ZAPP IT SPRAY 450ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8966000060456','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1426,'ZAPP IT SPRAY 600ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8966000060463','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1427,'BONUS TRISTAR 3KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950013343','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1428,'COLGATE F/MINT MOUTH WASH 250M',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8850006302088','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1429,'DETTOL LAVENDER 500ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6001106210076','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1430,'DETTOL MPC CLEANER 520ML FLORA',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6001106309565','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1431,'EVA COOKING OIL  POUCH IL',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000002025','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1432,'EXPREES POWER 1500K',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950012162','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1433,'EXPRESS POWER SURF 2KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950012230','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1434,'HARPIC BATHROOM CLEANER 500M',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961101230586','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1435,'HARPIC POWER PLUS 10X',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964002686131','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1436,'HARPIC POWER PLUS 450ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964002686117','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1437,'HARPIC POWER+ 500ML ORIG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6001106114626','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1438,'KIWI SHOE POLISH BLACK 45GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000749067','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1439,'KIWI SHOE POLISH BROWN 45GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000749098','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1440,'LIFEBUOY HERBAL S 650ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014261110','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1441,'LIFEBUOY NATURALLY LONG 650ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014261103','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1442,'LIFEBUOY NATURALLY STRONG S 650ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014263282','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1443,'MOTHER CARE LOTION 60ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000982440','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1444,'SHAN GINGER GARLIC PASTE 310GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'788821001184','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1445,'SKIN WHITE NIGHT CREAM 20GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964002548705','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1446,'SURF EXCEL 2KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014260113','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1447,'YOUNGS MAYONISE P 1KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000061121','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:05','2024-12-09 15:46:05'),(1448,'DETTOL ANTIBACTERIAL HANDWASH 750ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961101232726','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1449,'DOVE DRYNESS CARE 360 ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014260816','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1450,'ALWAYS MAXI THICK  V/PACK 18PC',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'4015400416869','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1451,'ALWAYS MAXI THICK E/LONG 16PCS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'4015400457879','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1452,'ARIEL DOWNY SURF 1KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'4084500599833','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1453,'ASHIFA  APPLE JAM 1KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'9232194588175','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1454,'ASHIFA MANGO JAM 1 KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'9232152744803','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1455,'ASHIFA MIX FRUIT JAM 1KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'9232194588168','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1456,'ASHIFA ORANGE JAM 1KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'9232152744186','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1457,'BIO 7DAY BEAUTY CREAM 105ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6009689192215','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1458,'BONUS ACTIVE 2KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950014050','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1459,'BRITE POWER 3KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950011455','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1460,'BULBULAY LEMON SODA BOX',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001166757','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1461,'CHERRY BLACK POLISH 42ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6001106309756','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1462,'CHERRY DARK TAN POLISH 45ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6001106309763','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1463,'CLEAN&CLEAR FACE WASH 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8991111111971','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1464,'CLEAR ANTI DANDRUFF 380ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014249200','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1465,'CLEAR ANTIDANDRUFF SHAMPOO 380ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014249224','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1466,'CLEAR MEN 380ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014249217','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1467,'DELYCIA PERFUME 35 ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961100040612','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1468,'DELYCIA PERFUME 35ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961100040643','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1469,'DETTOL MPC CLEANER 520ML CITRU',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6001106309589','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1470,'DETTOL ORIGNAL HW POUCH 375ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961101233549','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1471,'DETTOL SURFACE CLEANER 500ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000954256','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1472,'DOVE HAIRFALL RESCUE 360 ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014260823','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1473,'DOVE NOURISHING OIL CARE',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014260847','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1474,'DOVE NOURISHING SHAMPOO FOR DAMAGE HAIR',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014260830','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1475,'FACE FRESH BEAUTY CREAM 23G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'745604066402','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1476,'FINIS INSECT KILLER 400ML*',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001195047','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1477,'GANIER VITAMIN CFW',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'3610340650987','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1478,'GERMSHOOT BC 500ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8959030000578','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1479,'GERMSHOT JTC 500ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8959030000509','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1480,'GP HELLO HAIR SHAMPOO 180ML .',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001753889','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1481,'GP HELLO HAIR SHAMPOO 180ML.',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001753902','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1482,'GP HELLO HAIR SHAMPOO AD 180',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001753919','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1483,'GP HELLO HAIR SHAMPOO EP 180ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001753896','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1484,'H&S ANTI-HAIRFALL SHAMPOO 360ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8001841460567','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1485,'H&S CLASSIC CLEAN SHAMPOO 360ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8001841460321','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1486,'H&S DRY SCALP CARE SHAMPOO 360ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8001841460413','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1487,'H&S NEEM SHAMPOO 360ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8006540314180','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1488,'H&S REFRESHING MENTHOL SHAMPOO 360ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8001841460383','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1489,'H&S SILKY BLACK SHAMPOO 360ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8001841460710','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1490,'H&S SMOOTH&SILKY SHAMPOO 360ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8001841460505','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1491,'HARPIC TOILET CLEAN 750ML ORIG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6001106114633','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1492,'JAM- E- SHIRIN 800ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'855434000016','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1493,'JAM- E- SHIRIN 800ML DIET',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'855434000962','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1494,'KING LIQUID REFILL 45ML**',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'7137571776348','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1495,'KINGTOX SPRAY 325ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'689076783378','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1496,'KINGTOX SPRAY 400ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'689076783170','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1497,'KINGTOX SPRAY 600ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'689076783279','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1498,'LIFEBUOY HERBAL STRONG 370ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014261073','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1499,'LIFEBUOY NATURALLY LONG SHAMPOO 370ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014261097','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1500,'LIFEBUOY NATURALLY STRONG 370ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014255966','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1501,'LIFEBUOY SILKY SOFT 370ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014261066','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1502,'LOREAL DREAM LONG 360ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'3610340653810','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1503,'LOREAL ELIVE 6 OIL SHAMPOO',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'3610340655425','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1504,'LOREAL ELVIVE COLOR PROTECT 360ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'3610340655371','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1505,'LOREAL ELVIVE DREAM LONG STRAIGHT 360ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'3610340663475','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1506,'LOREAL ELVIVE NEW FALL RESIST 360ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'3610340655395','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1507,'LOREAL HYALURON 360ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'3610340669927','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1508,'LOREAL TOTAL REPAIR 5 360 ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'3610340654251','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1509,'LUX BLUE PEONY BW 250ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8999999036553','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1510,'LUX BODY WASH DREAM DELIGHT 250ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6221155046154','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1511,'LUX BODY WASH MAGICAL SPELL 250ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6221155046611','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1512,'LUX MAGICAL ORCHID BW 250ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8999999036584','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1513,'LUX SOFT ROSE BW 250ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8999999036539','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1514,'LUX VELVET JASMINE BW 250ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8999999036546','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1515,'MAR ISPAGHOL JAR 95G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000057919','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1516,'MARHABA HONEY 300G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000057032','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1517,'MEDORA PARFUME 60ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961100040513','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1518,'MEDORA PERFUME',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961100040537','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1519,'MOTHER CARE BABY OIL 110',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000982471','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1520,'MOTHERCARE BABY SHAMPOO 200ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000982662','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1521,'NAT CHILLI GARLIC SAUCE 800G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'620514008981','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1522,'NAT TOMATO KETCHUP 800GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'620514005836','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1523,'NAT TOMATO KETCHUP 800GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'620514019154','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1524,'NES LACTOGROW 3 400G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961008235462','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1525,'NESTLE BUNYAD 600G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961008218717','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1526,'NESTLE LACTOGEN RECOVER 375G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961008222301','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1527,'NESTLE LACTOGEN-2 400G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961008221021','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1528,'NESTLE LACTOGROW 400G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961008222103','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1529,'NESTLE MILK PAK  1LTR',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961008219561','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1530,'NESTLE NIDO GROWTH 650G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961008218908','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1531,'NESTLE NIDO SCHOOL AGE 390G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961008218892','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1532,'NYLE ANTI DANDRUFF SHAMPOO 200ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8902979027717','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1533,'NYLE DAMAGE REPAIR SHAMPOO 180ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8902979053945','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1534,'NYLE S&S SHAMPOO 180ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8902979053921','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1535,'OLPERS MILK 1L NEW',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964002706112','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1536,'OLPERS MILK 1LTR NEW',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000346679','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1537,'PALMOLIVE HEALTHY & SMOOTH 680ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950035321','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1538,'PALMOLIVE IM 680ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950035338','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1539,'PANTENE ANTI HAIR FALL SHAMPOO 360ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8001841494180','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1540,'PANTENE ANTI HAIRFALL SHAMPOO 360ML (DEEP BLACK)',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8001841494098','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1541,'PANTENE GOLD SERIES SHAMPOO 125ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'4902430878982','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1542,'PANTENE GOODBYE SUMMER CONDITIONER 360ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8001090789167','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1543,'PANTENE MILY/T SHAMPOO 360ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8001841494272','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1544,'PANTENE SMOOTH&S SHAMPOO 360ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8001841494456','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1545,'PARLEY GOLD CREAM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'2021053100101','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1546,'PONDS TRIPLE VITAMIN LOTION 200ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014248982','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1547,'SAMSOL EGG SHAMPOO 400ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'182039000173','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1548,'SHANGRILA HOT SRIRACHA SAUCE 350GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000844052','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1549,'SHINE BLEACH 300ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8959030000493','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1550,'SOFTLAN FLORAL FANTASY 2L',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950018072','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1551,'SOFTLAN SPRING FRESH 2LTR',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950018034','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1552,'STIFF ON SPRAY STARCH 567GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'718122102914','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1553,'TAPAL DANEDAR 440G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'815096002988','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1554,'TRESEMME B N&R SHAMPOO 360ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014238457','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1555,'TRESEMME BOT N&R SHAMPOO 360ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014238433','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1556,'TRESEMME CR SHAMPOO 360ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014253900','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1557,'TRESEMME KERATIN SMOOTH 360ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014253894','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1558,'TRESMME KS SHAMPOO 360ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014251340','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1559,'TRESSEME P T SHAMPOO 360ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014253887','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1560,'WHITE GOLD BLACK CREAM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'350801','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1561,'WHITE GOLD WHITENING CREAM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964002132508','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1562,'ARIEL ORIGNAL 4KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8700216451178','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1563,'OLPERS MILK 1.5L NEW',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000346334','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1564,'AFTAB QARSHI ANAAR 800ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964003244095','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1565,'AFTAB QARSHI BAZOORI 800ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964003244040','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1566,'AFTAB QARSHI ELACHI 800ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964003244101','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1567,'AFTAB QARSHI IMLI  ALUBKHARA 800ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964003244118','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1568,'ARIEL ORIGNAL 3KG.',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8700216451161','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1569,'BIO AMLA SHAMPOO 280ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6009689191027','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1570,'BRITE MP 2KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950011424','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1571,'BRITE SURF 2KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950011073','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1572,'GERMSHOOT BC 250ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8959030000585','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1573,'GOLDEN PEARL BEAUTY CREAM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001078586','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1574,'GP HELLO HAIR SHAMPOO AD 360ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001753957','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1575,'GP HELLO HAIR SHAMPOO DM 360ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001753926','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1576,'GP HELLO HAIR SHAMPOO EP 360ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001753933','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1577,'GP HELLO HAIR SHAMPOO HER 360ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001753940','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1578,'JAM-E-SHIRIN 1500ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'855434000665','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1579,'JHALAK BEAUTY  CREAM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'2880357942882','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1580,'MARHABA HONEY 500G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000056080','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1581,'NES LACTOGEN 1 400GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961008223209','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1582,'SAEED GHANI MUGHZIAT OIL 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000258804','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1583,'SANDAL BEAUTY CREAM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'151973298090','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1584,'SHANGRILA CHILLI GARLIC SAUCE 800G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000020531','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1585,'SHANGRILA TOMATO KETCHUP 800G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000020364','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1586,'SHANGRILA TRIO PACK 300ML 1X3',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000021576','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1587,'SHINE BLEACH 500ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8959030000417','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1588,'HARPIC LAVENDER 900ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964002686155','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1589,'HARRPIC POWER PLUS 900ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964002686179','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1590,'AATA 10 KG WS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'900541','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1591,'AATA 20 KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'900560','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1592,'AFTAB QARSHI HONEY 1KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964003244187','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1593,'AFTAB QARSHI HONEY GOLD 500GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964003244194','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1594,'AFTAB QARSHI SANDAL 800ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964003244026','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1595,'AFTAB QARSHI SANDAL 800ML..',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964003244019','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1596,'AFTAB QARSHI SHARBAT SANDAL 1.5L',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964003244033','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1597,'AGF LIME SEASONING POWDER 400G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'999242','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1598,'ARIEL ORIGINAL 1KG*',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8001841256788','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1599,'ARIEL ORIGNAL 2KG..',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8700216451086','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1600,'ARIEL SURF ORIGNAL 1KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8700216439039','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1601,'BAKEA FOOD SOLUTION ORGEGANO 500G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'122003','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1602,'Bayara Paprika Powder 1KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6291107613871','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1603,'BEST DAY PEANUT BUTTER',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6956495900407','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1604,'BEST DAY PEANUT BUTTER C 340G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6956495900421','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1605,'BIO 7DAY BEAUTY CREAM 225ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6009689191706','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1606,'BIO AMLA SHAMPOO 470ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6009689191010','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1607,'BLUESEAL VASELINE ALOE FRESH 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'60018915','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1608,'BLUESEAL VASELINE ORIGINAL 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6001085120946','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1609,'BONUS TRISTAR 5KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8886950013183','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1610,'BROOKE BOND SUPREME 900G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8720608619320','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1611,'CHOCO HEZE 180G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'745178478328','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1612,'COTTON BUDS 300PCS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6972350941309','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1613,'CYCLON INSTANT SPRAY 325ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'796554943145','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1614,'DAGHI CHAWAL 5KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'999393','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:06','2024-12-09 15:46:06'),(1615,'DALDA BANASPATI  (1*5)KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961100502806','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1616,'DALDA COOKING OIL (1*5)LTR',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961100502820','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1617,'DALDA COOKING OIL CARTON',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961100504442','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1618,'DETTOL CLEANER AQUA 1L',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000954249','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1619,'DETTOL LIQUID 500ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961101231309','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1620,'DETTOL MPC FLORAL 1LTR',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6001106209032','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1621,'DETTOL S/C LAVENDER 1.LTR',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6001106210069','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1622,'DETTOL S/CLEANER LEMON 1L',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6001106209049','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1623,'DIPIN BURGER+DRESSING MAYO 2L',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'9325675047862','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1624,'DIPIT OYSTER SAUCE 300ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'788821015099','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1625,'DIPITT PERI PERI HOT',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'788821018083','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1626,'DIPITT SRIRACHA 510G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'788821016690','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1627,'DIPITT THOUSAND ISLAND DRESSING 290G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'788821016843','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1628,'DOVE BODY WASH',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8999999028138','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1629,'DOVE BODY WASH SECRETS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8999999540562','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1630,'DOVE HAIRFALL R SHAMPOO 650ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014260861','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1631,'DOVE INTENSE REPAIR SHAM 650ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014260854','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1632,'EVA COOKING OIL (1*5)LTR',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000002247','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1633,'EVERYDAY MILK POWDER  900G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961008221946','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1634,'FAUJI NEW CORN FLAKES 500GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000064054','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1635,'FELEX SHAMPOO BLUE 592ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'4796002584506','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1636,'FIGARO BLACK OLIVE 450G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8410159267056','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1637,'FIGARO OLIVE 450G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8410159044336','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1638,'FINIS DAILY MOP 2.75L',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001195313','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1639,'FINIS INSECT KILLER/LIQ 800ML*',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001195030','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1640,'GERMSHOOT TC 500ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8959030000516','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1641,'GILLETTE BLUE 2 PLUS 5+1 PACK',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'4902430508377','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1642,'GREEN LEAF CHAI 900G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000156841','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1643,'H&S DRY SCALP CARE SHAMPOO 660ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8001841460444','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1644,'H&S SILKY BLACK SHAMPOO 660ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8001841460741','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1645,'HABIB GHEE 1X5KG BOX',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6297000027982','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1646,'HARPIC ORIGINAL 1000ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000954713','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1647,'HEAD & SHOULDER ANTI HAIRFALL 650ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8001841460628','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1648,'HEAD & SHOULDERS CLASSIC CLEAN 650ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8001841460352','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1649,'HOEST CANDY 60 PCS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000183717','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1650,'JOHAR JOSHANDA BOX',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'855434009682','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1651,'JOHNSONS BABY JELLY 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'60052377','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1652,'JOHNSONS FACE CARE GEL WASH 150 ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'3574660583861','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1653,'JOHSONS BABY SHAMPOO 500ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'3574661427843','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1654,'KING ELECTRIC MACHINE SET 2 IN 1',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'718122103218','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1655,'KRONE BODY SPRAY 120ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'653341119872','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1656,'KRONE DUNE 120ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'653341119773','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1657,'KRONE NOIR AQUA B/SPARY 125ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'653341120076','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1658,'KRONE NOIR ASH 120ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'653341120373','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1659,'KRONE NOIR MYTH B/SPARY 125ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'653341120175','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1660,'LIFEBUOY DEEP CLEANSE 680ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8901030860119','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1661,'LIPTON DANEDAR 475G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8720608621392','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1662,'LIPTON YELLOW LABEL 450G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'5063305004284','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1663,'LIPTON YELLOW LABEL TEA BAGS 50',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8720608619375','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1664,'MAR ISPAGHOL JAR 150G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000057124','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1665,'MARHABA HONEY 500G JAR',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000057063','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1666,'MARHABA SHARBAT SANDAL 1.5L',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000057490','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1667,'MEELA PINEAPPIE   BROKEN  SLICES',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8858878300201','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1668,'MORTEIN FLY & MOSQUITO KILLER 400ML*',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961101231415','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1669,'MORTEIN INSECT KILLER 2IN1 550ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964002686292','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1670,'MORTEIN KIT',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8966000041349','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1671,'MORTEIN PEACEFUL NIGHTS 400ML*',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961101231477','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1672,'MORTEIN SPRAY 300ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8966000041325','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1673,'MUMTAZ ACHAR 1KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'900942','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1674,'NATURES OWN WHITE OATS 500G*',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'4794235265261','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1675,'NES NIDO 3+ 800g',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961008224855','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1676,'NESCAFE CLASSIC 50G NEW',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'9556001249128','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1677,'NESTLE BUNYAD 900G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961008218724','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1678,'NESTLE BUNYAD 910G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961008223407','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1679,'NESTLE EVERYDAY 850G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961008217611','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1680,'NESTLE EVERYDAY 850G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961008223445','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1681,'NUMBER DAR DETERGENT 5KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964002384341','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1682,'NUTELLA CHOC SPREAD 350G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'80177173','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1683,'NYLE DAMAGE REPAIR',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8902979054003','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1684,'NYLE DRYNESS HYDRATION 400ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8902979053990','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1685,'NYLE SOFT&SHINY',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8902979053983','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1686,'OLIVOLA NOZZLE POUCH 1L',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000612484','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1687,'OREAL CHICKEN POWDER 1KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'4258633130007','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1688,'PANTENE MILKY ET SHAMPOO 650ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8001841494302','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1689,'PANTENE SMOOTH&S SHAMPOO 650ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8001841494487','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1690,'PHOOL MAKHANE 125G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'400267','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1691,'PUNAB DESI GHEE JAR M',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'735745717592','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1692,'PUNJAB DESI GHEE 1 KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'4437313321113','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1693,'PUNJAB DESI GHEE 500G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'4437313325005','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1694,'QUAKER WHITE OATS 500G *',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'5000108478119','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1695,'REVLON FLEX SHAMPOO BLUE 350ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'4792268700292','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1696,'ROOH AFZA 1.5L',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000122112','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1697,'ROOH AFZA 800ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000122105','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1698,'SAEED GHANI ONION HAIR OIL 140ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000507681','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1699,'SALMAN CHOC TOPPING 623G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000034712','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1700,'SALMANS STRAWBERY TOPPING 623G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000034729','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1701,'SALVA CANOLA OIL CARTON',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001015741','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1702,'SG  HYALURONIC ACID FC 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000506356','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1703,'SG ARGAN OIL SHAMPOO 200ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000505656','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1704,'SG CHARCOAL FW 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000506257','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1705,'SG GOAT MILK FW 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000506288','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1706,'SG SHAMPOO MUGHZIAT 200ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000259702','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1707,'SG SHAMPOO NEEM&MINT REF 200ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000259740','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1708,'SG SHAMPOO PURE AMLA  200ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000259610','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1709,'SG SHAMPOO TEA TREE & ALOVERA 200ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000259788','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1710,'SG TEA TREE&NEEM FW 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000506264','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1711,'SG VITAMIN C FW 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000507292','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1712,'SHAN COOKIN OIL 5L',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000293546','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1713,'SHANGRILA CHILLI SAUCE 3.5L',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000020166','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1714,'SHANGRILA SOY SAUCE 3.5L',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000020067','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1715,'SHANGRILA TOMATO KETCHUP 4.4KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000020425','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1716,'SHANGRILA TRIO PACK 700ML 1X3',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000021545','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1717,'SHANGRILA VINEGAR 3.5L',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000020265','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1718,'SHANGRILA YELLOW MUSTARD 227',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000844441','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1719,'SHANGRILLA CHILLI GARLIC 4KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000021927','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1720,'SHINE GERMSHOOT 1000ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8959030000554','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1721,'SKIN WHITE 7DAY BC PINK 225ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000578544','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1722,'SKIN WHITE 7DAY BC SHEA-B 225ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000578940','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1723,'SRIRACHA  HOT SAUCE 345ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8850344000271','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1724,'SUFI CANOLA OIL (1*5)LTR',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000038314','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1725,'SUFI SPECIAL BASANPATI (1*5)KG BOX',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000038390','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1726,'SUFI SUNFLOWER OIL (1*5)LTR',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000038291','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1727,'SUNSILK BLACK SHINE 660ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014238488','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1728,'SUNSILK HFS SHAMPOO 660ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014238501','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1729,'SUNSILK T&L SHAMPOO 660ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014238495','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1730,'TAPAL DANEDAR TEA 430G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961103601971','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1731,'TAPAL FAMILY MIXTURE 900G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'815096000694','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1732,'TAPAL TEZDUM 950G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'815096000793','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1733,'TIME JAM 1KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6672343001088','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1734,'TIME MANGO JAM 1KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6672343001095','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1735,'TIME MIX FRESH FRIUT JAM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6672343062027','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1736,'TRESEMME BOTANIQUE SHAMPOO 650ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014260236','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1737,'TRESEMME PT SHAMPOO 650ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014253917','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1738,'TRESMME KS SHAMPOO 650ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014253924','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1739,'VASELINE COCABUTTER 100ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'60018960','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1740,'VITAL TEA 950G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000008003','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1741,'VITAL TEA BAG 100P',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000008201','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1742,'MARHABA BAZOORI SYRUP 800ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000057537','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1743,'MARHABA GUL BAHAR SYRUP 800ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000057469','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1744,'MARHABA ILLAICHI SARBAT 1L',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000057926','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1745,'MARHABA SANDAL SYRUP 800ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000057483','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1746,'AFTAB QARSHI BADAM 800ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964003244125','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1747,'PAK DESI GHEE 500G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8910786050019','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1748,'MARHABA HONEY 1000GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000057070','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1749,'JAM-E-SHIRIN P.PACK 3 LTR',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'855434000733','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1750,'NESTLE NIDO FG SCHOOL AGE 900G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961008218915','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1751,'NESTLE NIDO GROWTH 990G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961008222400','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1752,'SUPREME TEA 900G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'5063305006783','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1753,'SUPREME TEA 900G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961014003758','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1754,'BIO 7DAY BEAUTY CREAM 485ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6009689191690','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1755,'BIO AMLA SHAMPO 720ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6009689191003','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1756,'FRUITAMINS BLACK OLIVE 3KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'7056324919040','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1757,'FRUITAMINS FRUIT COCKTAIL 3KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'705632492857','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1758,'FRUITAMINS PINEAPPLE SLICED COCKTAIL 2840G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'290000041619','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1759,'HABIB COOKING OIL (1*5)LTR',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6297000027975','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1760,'ITALIA OLIVE OIL 500',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6533411500738','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1761,'JOHNSONS BABY SHAMPOO 750ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'3574669907927','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1762,'KUWET BERRY ROCKS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'725765196101','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1763,'LIPTON TEA 430G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8720608619290','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1764,'LIPTON YELLOW LABEL TEA BAGS 100',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8720608619382','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1765,'MAJOR GRAINS CHOCO BALLS 150G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'725765196033','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1766,'MAJOR GRAINS CHOCO LOOPS 150G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'725765196057','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1767,'MAJOR GRAINS CHOCO SHELLS 150G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'725765196002','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1768,'MAJOR GRAINS MOONS STARS 150G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'725765196071','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1769,'ME BODY SPRAY CRAZE 120ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6291101526719','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1770,'ME BODY SPRAY EROTIC 120ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6291101526702','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1771,'ME BODY SPRAY GRACE 120ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6291101526757','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1772,'ME BODY SPRAY KICKY 120ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6291101526726','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1773,'ME BODY SPRAY MAJESTIC 120ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6291101526795','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1774,'ME BODY SPRAY SHOCK 120ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6291101526672','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1775,'ME BODY SPRAY SPIRIT 120ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6291101526764','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1776,'ME BODY SPRAY STORM 120ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6291101526801','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1777,'ME LIFE BODY SPRAY 120ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6291101526788','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1778,'MEZAN BANASPATI 1X5KG BOX',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000419144','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1779,'MEZAN COOKING OIL (1*5)LTR',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000419489','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1780,'MILKYZ CHOCO HAZE 350G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'745760337651','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1781,'MR OLIVES 3KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6224007949559','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1782,'MR.MUSHROOM 2400G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6927710589479','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1783,'MR.PEPPER JALAPENO 2300G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6224007949009','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:07','2024-12-09 15:46:07'),(1784,'NESTLE NIDO 1+ 900G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961008223810','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:08','2024-12-09 15:46:08'),(1785,'PAK DESI GHEE 1KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8910786100028','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:08','2024-12-09 15:46:08'),(1786,'PHOOL MAKHANE 250G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'400269','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:08','2024-12-09 15:46:08'),(1787,'PHOOL MAKHANE 500G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'400270','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:08','2024-12-09 15:46:08'),(1788,'PUNJAB DESI GHEE JAR L',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'735745717707','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:08','2024-12-09 15:46:08'),(1789,'ROOH AFZA 3L',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000122129','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:08','2024-12-09 15:46:08'),(1790,'TAPAL DANEDAR 1KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961103601988','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:08','2024-12-09 15:46:08'),(1791,'TAPAL DANEDAR 900G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'815096000274','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:08','2024-12-09 15:46:08'),(1792,'TRANDOZ HOT SAUSE 525G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'6087263693105','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:08','2024-12-09 15:46:08'),(1793,'VITAL TEA 1600G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000008058','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:08','2024-12-09 15:46:08'),(1794,'LIPTON YELLOW LABEL 900G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'5063305007414','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:08','2024-12-09 15:46:08'),(1795,'NES LACTOGEN 1 800G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961008235400','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:08','2024-12-09 15:46:08'),(1796,'NESTLE LACTOGEN 1 800G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961008223216','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:08','2024-12-09 15:46:08'),(1797,'NESTLE LACTOGEN 2 800G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8961008223247','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:08','2024-12-09 15:46:08'),(1798,'NESTLE NESCAFE CLASSIC 100G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'9556001249142','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:08','2024-12-09 15:46:08'),(1799,'LIPTON YELLOW LABEL 800G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8720608619368','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:08','2024-12-09 15:46:08'),(1800,'HARVEST FRUITCOOKTAIL',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'705632491850','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:08','2024-12-09 15:46:08'),(1801,'ITALIA OLIVE POMACE OIL 1LTR',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'7181221027168','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:08','2024-12-09 15:46:08'),(1802,'PHOOL MAKHANE 1KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'400271','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:08','2024-12-09 15:46:08'),(1803,'TODAYS FRUIT COCKTAIL 3.3L',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'4800024038548','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:08','2024-12-09 15:46:08'),(1804,'CHOCO VANILLA ASSORTED',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'725765196125','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:08','2024-12-09 15:46:08'),(1805,'MAJOR GRAINS CHOCO BALLS',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'725765196095','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:08','2024-12-09 15:46:08'),(1806,'MAJOR GRAINS CHOCO LOOPS 300G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'725765196132','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:08','2024-12-09 15:46:08'),(1807,'MAJOR GRAINS CHOCO SHEELS 300G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'725765196118','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:08','2024-12-09 15:46:08'),(1808,'MAJOR GRAINS MOONS STARS 300G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'725765196149','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:08','2024-12-09 15:46:08'),(1809,'NUTRIBOND CHOCO SHELLS 250G',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'725765196019','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:08','2024-12-09 15:46:08'),(1810,'KUVVET CHOCO ROCKS 250',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'725765196088','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:08','2024-12-09 15:46:08'),(1811,'OLIVOLA DOY POUCH (1*5)LTR',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964000612491','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:08','2024-12-09 15:46:08'),(1812,'CAFE VITAL 5KG',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'8964001400301','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:08','2024-12-09 15:46:08'),(1813,'NESCAFE CLASSIC 200GM',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',1,5.0000,'9556001249166','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-09 15:46:08','2024-12-09 15:46:08');
/*!40000 ALTER TABLE `products` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `purchase_lines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `purchase_lines` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `transaction_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `variation_id` int(10) unsigned NOT NULL,
  `quantity` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `serial_purchase_code` varchar(191) DEFAULT NULL,
  `secondary_unit_quantity` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `pp_without_discount` decimal(22,4) NOT NULL DEFAULT 0.0000 COMMENT 'Purchase price before inline discounts',
  `discount_percent` decimal(5,2) NOT NULL DEFAULT 0.00 COMMENT 'Inline discount percentage',
  `purchase_price` decimal(22,4) NOT NULL,
  `purchase_price_inc_tax` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `item_tax` decimal(22,4) NOT NULL COMMENT 'Tax for one quantity',
  `tax_id` int(10) unsigned DEFAULT NULL,
  `line_discount_type` enum('fixed','percentage') DEFAULT NULL,
  `line_discount_amount` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `purchase_requisition_line_id` int(11) DEFAULT NULL,
  `purchase_order_line_id` int(11) DEFAULT NULL,
  `quantity_sold` decimal(22,4) NOT NULL DEFAULT 0.0000 COMMENT 'Quanity sold from this purchase line',
  `quantity_adjusted` decimal(22,4) NOT NULL DEFAULT 0.0000 COMMENT 'Quanity adjusted in stock adjustment from this purchase line',
  `quantity_returned` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `po_quantity_purchased` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `mfg_quantity_used` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `mfg_date` date DEFAULT NULL,
  `exp_date` date DEFAULT NULL,
  `lot_number` varchar(191) DEFAULT NULL,
  `sub_unit_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `purchase_lines_transaction_id_foreign` (`transaction_id`),
  KEY `purchase_lines_product_id_foreign` (`product_id`),
  KEY `purchase_lines_variation_id_foreign` (`variation_id`),
  KEY `purchase_lines_tax_id_foreign` (`tax_id`),
  KEY `purchase_lines_sub_unit_id_index` (`sub_unit_id`),
  KEY `purchase_lines_lot_number_index` (`lot_number`),
  CONSTRAINT `purchase_lines_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE,
  CONSTRAINT `purchase_lines_tax_id_foreign` FOREIGN KEY (`tax_id`) REFERENCES `tax_rates` (`id`) ON DELETE CASCADE,
  CONSTRAINT `purchase_lines_transaction_id_foreign` FOREIGN KEY (`transaction_id`) REFERENCES `transactions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `purchase_lines_variation_id_foreign` FOREIGN KEY (`variation_id`) REFERENCES `variations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1691 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `purchase_lines` WRITE;
/*!40000 ALTER TABLE `purchase_lines` DISABLE KEYS */;
INSERT INTO `purchase_lines` VALUES (1,1,2,2,3.0000,NULL,0.0000,148.0000,0.00,148.0000,148.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(2,2,3,3,18.0000,NULL,0.0000,148.0000,0.00,148.0000,148.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(3,3,4,4,-32.0000,NULL,0.0000,148.0000,0.00,148.0000,148.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(4,4,5,5,-13.0000,NULL,0.0000,148.0000,0.00,148.0000,148.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(5,5,6,6,-92.0000,NULL,0.0000,119.0000,0.00,119.0000,119.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(6,6,9,9,-46.2500,NULL,0.0000,75.0000,0.00,75.0000,75.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(7,7,10,10,-197.0000,NULL,0.0000,115.0000,0.00,115.0000,115.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(8,8,11,11,1.0000,NULL,0.0000,195.0000,0.00,195.0000,195.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(9,9,12,12,4.0000,NULL,0.0000,145.0000,0.00,145.0000,145.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(10,10,13,13,6.0000,NULL,0.0000,145.0000,0.00,145.0000,145.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(11,11,14,14,-9.0000,NULL,0.0000,145.0000,0.00,145.0000,145.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(12,12,15,15,-18.0000,NULL,0.0000,145.0000,0.00,145.0000,145.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(13,13,16,16,-19.0000,NULL,0.0000,145.0000,0.00,145.0000,145.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(14,14,17,17,-10.0000,NULL,0.0000,145.0000,0.00,145.0000,145.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(15,15,18,18,-5.0000,NULL,0.0000,185.0000,0.00,185.0000,185.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(16,16,19,19,1.0000,NULL,0.0000,185.0000,0.00,185.0000,185.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(17,17,20,20,1.0000,NULL,0.0000,195.0000,0.00,195.0000,195.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(18,18,21,21,-26.0000,NULL,0.0000,200.0000,0.00,200.0000,200.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(19,19,22,22,1.0000,NULL,0.0000,160.0000,0.00,160.0000,160.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(20,20,23,23,-1.0000,NULL,0.0000,75.0000,0.00,75.0000,75.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(21,21,24,24,-3.5000,NULL,0.0000,115.0000,0.00,115.0000,115.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(22,22,25,25,-22.0000,NULL,0.0000,145.0000,0.00,145.0000,145.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(23,23,26,26,-69.0000,NULL,0.0000,165.0000,0.00,165.0000,165.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(24,24,27,27,-192.5000,NULL,0.0000,115.0000,0.00,115.0000,115.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(25,25,28,28,-41.0000,NULL,0.0000,95.0000,0.00,95.0000,95.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(26,26,29,29,-56.0000,NULL,0.0000,95.0000,0.00,95.0000,95.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(27,27,30,30,-106.0000,NULL,0.0000,125.0000,0.00,125.0000,125.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(28,28,31,31,-82.5000,NULL,0.0000,125.0000,0.00,125.0000,125.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(29,29,32,32,-257.0000,NULL,0.0000,125.0000,0.00,125.0000,125.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(30,30,33,33,13.0000,NULL,0.0000,145.0000,0.00,145.0000,145.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(31,31,34,34,11.5000,NULL,0.0000,120.0000,0.00,120.0000,120.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(32,32,35,35,4.0000,NULL,0.0000,170.0000,0.00,170.0000,170.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(33,33,36,36,8.0000,NULL,0.0000,150.0000,0.00,150.0000,150.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(34,34,37,37,10.0000,NULL,0.0000,150.0000,0.00,150.0000,150.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(35,35,38,38,4.0000,NULL,0.0000,295.0000,0.00,295.0000,295.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(36,36,39,39,11.0000,NULL,0.0000,295.0000,0.00,295.0000,295.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(37,37,40,40,1.0000,NULL,0.0000,170.0000,0.00,170.0000,170.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(38,38,41,41,5.0000,NULL,0.0000,170.0000,0.00,170.0000,170.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(39,39,42,42,3.0000,NULL,0.0000,150.0000,0.00,150.0000,150.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(40,40,43,43,1.0000,NULL,0.0000,210.0000,0.00,210.0000,210.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(41,41,44,44,14.0000,NULL,0.0000,150.0000,0.00,150.0000,150.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(42,42,46,46,16.0000,NULL,0.0000,170.0000,0.00,170.0000,170.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(43,43,47,47,20.0000,NULL,0.0000,210.0000,0.00,210.0000,210.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(44,44,49,49,-4.0000,NULL,0.0000,245.0000,0.00,245.0000,245.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(45,45,50,50,-2.0000,NULL,0.0000,205.0000,0.00,205.0000,205.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(46,46,51,51,4.0000,NULL,0.0000,205.0000,0.00,205.0000,205.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(47,47,52,52,1.0000,NULL,0.0000,205.0000,0.00,205.0000,205.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(48,48,53,53,1.0000,NULL,0.0000,205.0000,0.00,205.0000,205.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(49,49,55,55,3.0000,NULL,0.0000,135.0000,0.00,135.0000,135.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(50,50,57,57,1.0000,NULL,0.0000,105.0000,0.00,105.0000,105.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(51,51,58,58,58.0000,NULL,0.0000,105.0000,0.00,105.0000,105.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(52,52,59,59,-6.0000,NULL,0.0000,120.0000,0.00,120.0000,120.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(53,53,60,60,-62.0000,NULL,0.0000,115.0000,0.00,115.0000,115.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(54,54,61,61,-10.0000,NULL,0.0000,265.0000,0.00,265.0000,265.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(55,55,62,62,-37.0000,NULL,0.0000,205.0000,0.00,205.0000,205.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(56,56,63,63,41.0000,NULL,0.0000,305.0000,0.00,305.0000,305.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(57,57,64,64,-236.0000,NULL,0.0000,135.0000,0.00,135.0000,135.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(58,58,65,65,9.0000,NULL,0.0000,185.0000,0.00,185.0000,185.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(59,59,66,66,-10.0000,NULL,0.0000,275.0000,0.00,275.0000,275.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(60,60,67,67,2.0000,NULL,0.0000,170.0000,0.00,170.0000,170.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(61,61,68,68,7.0000,NULL,0.0000,170.0000,0.00,170.0000,170.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:57','2024-12-09 15:45:57'),(62,62,69,69,4.0000,NULL,0.0000,170.0000,0.00,170.0000,170.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(63,63,70,70,2.0000,NULL,0.0000,170.0000,0.00,170.0000,170.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(64,64,71,71,78.0000,NULL,0.0000,160.0000,0.00,160.0000,160.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(65,65,72,72,13.0000,NULL,0.0000,185.0000,0.00,185.0000,185.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(66,66,73,73,36.0000,NULL,0.0000,185.0000,0.00,185.0000,185.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(67,67,74,74,1.0000,NULL,0.0000,95.0000,0.00,95.0000,95.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(68,68,75,75,-42.0000,NULL,0.0000,85.0000,0.00,85.0000,85.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(69,69,77,77,1.0000,NULL,0.0000,75.0000,0.00,75.0000,75.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(70,70,78,78,-7.0000,NULL,0.0000,95.0000,0.00,95.0000,95.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(71,71,79,79,2.0000,NULL,0.0000,115.0000,0.00,115.0000,115.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(72,72,80,80,-32.0000,NULL,0.0000,135.0000,0.00,135.0000,135.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(73,73,81,81,-1.0000,NULL,0.0000,205.0000,0.00,205.0000,205.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(74,74,83,83,-1.0000,NULL,0.0000,205.0000,0.00,205.0000,205.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(75,75,84,84,-125.0000,NULL,0.0000,115.0000,0.00,115.0000,115.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(76,76,85,85,-4.0000,NULL,0.0000,115.0000,0.00,115.0000,115.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(77,77,86,86,-38.0000,NULL,0.0000,115.0000,0.00,115.0000,115.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(78,78,87,87,-12.0000,NULL,0.0000,220.0000,0.00,220.0000,220.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(79,79,88,88,34.0000,NULL,0.0000,220.0000,0.00,220.0000,220.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(80,80,89,89,-2.0000,NULL,0.0000,185.0000,0.00,185.0000,185.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(81,81,90,90,5.0000,NULL,0.0000,185.0000,0.00,185.0000,185.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(82,82,91,91,15.0000,NULL,0.0000,185.0000,0.00,185.0000,185.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(83,83,92,92,-8.0000,NULL,0.0000,210.0000,0.00,210.0000,210.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(84,84,94,94,-85.0000,NULL,0.0000,210.0000,0.00,210.0000,210.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(85,85,95,95,1.0000,NULL,0.0000,165.0000,0.00,165.0000,165.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(86,86,96,96,-13.0000,NULL,0.0000,295.0000,0.00,295.0000,295.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(87,87,97,97,16.0000,NULL,0.0000,140.0000,0.00,140.0000,140.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(88,88,98,98,11.0000,NULL,0.0000,140.0000,0.00,140.0000,140.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(89,89,99,99,-1.0000,NULL,0.0000,140.0000,0.00,140.0000,140.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(90,90,100,100,-50.0000,NULL,0.0000,135.0000,0.00,135.0000,135.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(91,91,101,101,4.0000,NULL,0.0000,170.0000,0.00,170.0000,170.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(92,92,102,102,35.0000,NULL,0.0000,180.0000,0.00,180.0000,180.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(93,93,103,103,9.0000,NULL,0.0000,170.0000,0.00,170.0000,170.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(94,94,104,104,54.0000,NULL,0.0000,160.0000,0.00,160.0000,160.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(95,95,105,105,3.0000,NULL,0.0000,170.0000,0.00,170.0000,170.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(96,96,106,106,6.0000,NULL,0.0000,130.0000,0.00,130.0000,130.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(97,97,107,107,1.0000,NULL,0.0000,130.0000,0.00,130.0000,130.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(98,98,108,108,-2.0000,NULL,0.0000,130.0000,0.00,130.0000,130.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(99,99,109,109,-6.0000,NULL,0.0000,130.0000,0.00,130.0000,130.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(100,100,110,110,3.0000,NULL,0.0000,130.0000,0.00,130.0000,130.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(101,101,111,111,-17.0000,NULL,0.0000,95.0000,0.00,95.0000,95.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(102,102,112,112,-206.0000,NULL,0.0000,95.0000,0.00,95.0000,95.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(103,103,113,113,-65.0000,NULL,0.0000,125.0000,0.00,125.0000,125.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(104,104,114,114,-87.0000,NULL,0.0000,150.0000,0.00,150.0000,150.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(105,105,115,115,10.0000,NULL,0.0000,210.0000,0.00,210.0000,210.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(106,106,116,116,6.0000,NULL,0.0000,210.0000,0.00,210.0000,210.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(107,107,117,117,8.0000,NULL,0.0000,210.0000,0.00,210.0000,210.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(108,108,118,118,-294.0000,NULL,0.0000,85.0000,0.00,85.0000,85.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(109,109,120,120,1.0000,NULL,0.0000,265.0000,0.00,265.0000,265.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(110,110,121,121,50.0000,NULL,0.0000,150.0000,0.00,150.0000,150.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(111,111,122,122,1.0000,NULL,0.0000,150.0000,0.00,150.0000,150.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(112,112,123,123,1.0000,NULL,0.0000,150.0000,0.00,150.0000,150.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(113,113,124,124,4.0000,NULL,0.0000,150.0000,0.00,150.0000,150.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(114,114,125,125,-40.0000,NULL,0.0000,150.0000,0.00,150.0000,150.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(115,115,127,127,-1.0000,NULL,0.0000,368.0000,0.00,368.0000,368.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(116,116,128,128,-12.0000,NULL,0.0000,219.0000,0.00,219.0000,219.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(117,117,129,129,1.0000,NULL,0.0000,419.0000,0.00,419.0000,419.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(118,118,130,130,-4.0000,NULL,0.0000,219.0000,0.00,219.0000,219.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(119,119,131,131,1.0000,NULL,0.0000,219.0000,0.00,219.0000,219.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(120,120,132,132,2.0000,NULL,0.0000,319.0000,0.00,319.0000,319.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(121,121,133,133,-30.0000,NULL,0.0000,319.0000,0.00,319.0000,319.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(122,122,134,134,12.0000,NULL,0.0000,219.0000,0.00,219.0000,219.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(123,123,135,135,-1.0000,NULL,0.0000,519.0000,0.00,519.0000,519.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(124,124,136,136,2.0000,NULL,0.0000,519.0000,0.00,519.0000,519.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(125,125,137,137,6.0000,NULL,0.0000,294.0000,0.00,294.0000,294.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(126,126,138,138,6.0000,NULL,0.0000,180.0000,0.00,180.0000,180.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 16:21:23'),(127,127,139,139,6.0000,NULL,0.0000,180.0000,0.00,180.0000,180.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(128,128,140,140,-2.0000,NULL,0.0000,180.0000,0.00,180.0000,180.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(129,129,141,141,5.0000,NULL,0.0000,470.0000,0.00,470.0000,470.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(130,130,142,142,2.0000,NULL,0.0000,270.0000,0.00,270.0000,270.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(131,131,143,143,1.0000,NULL,0.0000,120.0000,0.00,120.0000,120.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(132,132,144,144,1.0000,NULL,0.0000,120.0000,0.00,120.0000,120.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(133,133,145,145,1.0000,NULL,0.0000,190.0000,0.00,190.0000,190.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(134,134,147,147,-1.0000,NULL,0.0000,295.0000,0.00,295.0000,295.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(135,135,148,148,-1.0000,NULL,0.0000,320.0000,0.00,320.0000,320.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(136,136,149,149,4.0000,NULL,0.0000,295.0000,0.00,295.0000,295.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(137,137,150,150,-6.0000,NULL,0.0000,295.0000,0.00,295.0000,295.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(138,138,151,151,-3.0000,NULL,0.0000,130.0000,0.00,130.0000,130.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(139,139,152,152,-6.0000,NULL,0.0000,230.0000,0.00,230.0000,230.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(140,140,153,153,3.0000,NULL,0.0000,240.0000,0.00,240.0000,240.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(141,141,154,154,4.0000,NULL,0.0000,370.0000,0.00,370.0000,370.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(142,142,155,155,-3.0000,NULL,0.0000,230.0000,0.00,230.0000,230.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(143,143,156,156,5.0000,NULL,0.0000,240.0000,0.00,240.0000,240.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(144,144,157,157,3.0000,NULL,0.0000,230.0000,0.00,230.0000,230.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(145,145,158,158,6.0000,NULL,0.0000,230.0000,0.00,230.0000,230.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(146,146,159,159,3.0000,NULL,0.0000,280.0000,0.00,280.0000,280.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(147,147,160,160,-2.0000,NULL,0.0000,240.0000,0.00,240.0000,240.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(148,148,161,161,5.0000,NULL,0.0000,230.0000,0.00,230.0000,230.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(149,149,162,162,-1.0000,NULL,0.0000,230.0000,0.00,230.0000,230.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(150,150,163,163,-2.0000,NULL,0.0000,230.0000,0.00,230.0000,230.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(151,151,164,164,-1.0000,NULL,0.0000,240.0000,0.00,240.0000,240.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(152,152,165,165,7.0000,NULL,0.0000,170.0000,0.00,170.0000,170.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(153,153,166,166,6.0000,NULL,0.0000,170.0000,0.00,170.0000,170.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(154,154,167,167,2.0000,NULL,0.0000,250.0000,0.00,250.0000,250.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(155,155,168,168,1.0000,NULL,0.0000,230.0000,0.00,230.0000,230.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(156,156,169,169,-6.0000,NULL,0.0000,280.0000,0.00,280.0000,280.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(157,157,170,170,-2.0000,NULL,0.0000,140.0000,0.00,140.0000,140.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(158,158,171,171,1.0000,NULL,0.0000,140.0000,0.00,140.0000,140.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(159,159,172,172,24.0000,NULL,0.0000,300.0000,0.00,300.0000,300.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(160,160,173,173,4.0000,NULL,0.0000,390.0000,0.00,390.0000,390.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(161,161,174,174,-53.5000,NULL,0.0000,120.0000,0.00,120.0000,120.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(162,162,175,175,-98.0000,NULL,0.0000,210.0000,0.00,210.0000,210.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(163,163,176,176,1.0000,NULL,0.0000,370.0000,0.00,370.0000,370.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(164,164,177,177,8.0000,NULL,0.0000,220.0000,0.00,220.0000,220.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(165,165,178,178,1.0000,NULL,0.0000,280.0000,0.00,280.0000,280.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(166,166,179,179,-1.0000,NULL,0.0000,300.0000,0.00,300.0000,300.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(167,167,180,180,2.0000,NULL,0.0000,180.0000,0.00,180.0000,180.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(168,168,181,181,6.0000,NULL,0.0000,170.0000,0.00,170.0000,170.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(169,169,182,182,-4.0000,NULL,0.0000,240.0000,0.00,240.0000,240.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(170,170,183,183,-1.0000,NULL,0.0000,220.0000,0.00,220.0000,220.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(171,171,184,184,6.0000,NULL,0.0000,500.0000,0.00,500.0000,500.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(172,172,185,185,8.0000,NULL,0.0000,270.0000,0.00,270.0000,270.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(173,173,186,186,-2.0000,NULL,0.0000,510.0000,0.00,510.0000,510.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(174,174,187,187,-43.0000,NULL,0.0000,250.0000,0.00,250.0000,250.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(175,175,188,188,-9.0000,NULL,0.0000,320.0000,0.00,320.0000,320.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(176,176,189,189,-3.0000,NULL,0.0000,370.0000,0.00,370.0000,370.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(177,177,190,190,58.0000,NULL,0.0000,180.0000,0.00,180.0000,180.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(178,178,191,191,-13.0000,NULL,0.0000,270.0000,0.00,270.0000,270.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(179,179,192,192,-19.0000,NULL,0.0000,295.0000,0.00,295.0000,295.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(180,180,193,193,2.0000,NULL,0.0000,395.0000,0.00,395.0000,395.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(181,181,194,194,8.0000,NULL,0.0000,180.0000,0.00,180.0000,180.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(182,182,195,195,1.0000,NULL,0.0000,420.0000,0.00,420.0000,420.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(183,183,196,196,1.0000,NULL,0.0000,650.0000,0.00,650.0000,650.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(184,184,197,197,1.0000,NULL,0.0000,420.0000,0.00,420.0000,420.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(185,185,198,198,-2.0000,NULL,0.0000,470.0000,0.00,470.0000,470.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(186,186,199,199,-18.0000,NULL,0.0000,360.0000,0.00,360.0000,360.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(187,187,200,200,-47.0000,NULL,0.0000,360.0000,0.00,360.0000,360.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(188,188,201,201,1.0000,NULL,0.0000,360.0000,0.00,360.0000,360.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(189,189,203,203,2.0000,NULL,0.0000,360.0000,0.00,360.0000,360.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(190,190,204,204,14.0000,NULL,0.0000,170.0000,0.00,170.0000,170.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(191,191,205,205,-6.0000,NULL,0.0000,240.0000,0.00,240.0000,240.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(192,192,206,206,-63.0000,NULL,0.0000,310.0000,0.00,310.0000,310.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(193,193,207,207,19.0000,NULL,0.0000,310.0000,0.00,310.0000,310.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(194,194,209,209,2.0000,NULL,0.0000,460.0000,0.00,460.0000,460.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(195,195,210,210,2.0000,NULL,0.0000,500.0000,0.00,500.0000,500.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(196,196,211,211,1.0000,NULL,0.0000,460.0000,0.00,460.0000,460.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(197,197,212,212,1.0000,NULL,0.0000,420.0000,0.00,420.0000,420.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(198,198,213,213,1.0000,NULL,0.0000,260.0000,0.00,260.0000,260.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(199,199,214,214,1.0000,NULL,0.0000,270.0000,0.00,270.0000,270.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(200,200,215,215,8.0000,NULL,0.0000,400.0000,0.00,400.0000,400.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(201,201,216,216,1.0000,NULL,0.0000,370.0000,0.00,370.0000,370.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(202,202,217,217,4.0000,NULL,0.0000,260.0000,0.00,260.0000,260.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(203,203,218,218,1.0000,NULL,0.0000,320.0000,0.00,320.0000,320.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(204,204,219,219,8.0000,NULL,0.0000,400.0000,0.00,400.0000,400.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(205,205,220,220,1.0000,NULL,0.0000,320.0000,0.00,320.0000,320.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(206,206,221,221,1.0000,NULL,0.0000,370.0000,0.00,370.0000,370.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(207,207,222,222,1.0000,NULL,0.0000,400.0000,0.00,400.0000,400.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(208,208,223,223,10.0000,NULL,0.0000,180.0000,0.00,180.0000,180.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(209,209,224,224,1.0000,NULL,0.0000,270.0000,0.00,270.0000,270.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(210,210,225,225,1.0000,NULL,0.0000,200.0000,0.00,200.0000,200.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(211,211,226,226,-1.0000,NULL,0.0000,180.0000,0.00,180.0000,180.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(212,212,227,227,-106.0000,NULL,0.0000,230.0000,0.00,230.0000,230.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(213,213,228,228,-4.0000,NULL,0.0000,320.0000,0.00,320.0000,320.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(214,214,229,229,14.0000,NULL,0.0000,320.0000,0.00,320.0000,320.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(215,215,230,230,-14.0000,NULL,0.0000,210.0000,0.00,210.0000,210.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(216,216,231,231,1.0000,NULL,0.0000,400.0000,0.00,400.0000,400.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(217,217,232,232,1.0000,NULL,0.0000,220.0000,0.00,220.0000,220.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(218,218,233,233,4.0000,NULL,0.0000,305.0000,0.00,305.0000,305.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(219,219,234,234,-1.0000,NULL,0.0000,350.0000,0.00,350.0000,350.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(220,220,235,235,-13.0000,NULL,0.0000,210.0000,0.00,210.0000,210.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(221,221,236,236,-10.0000,NULL,0.0000,210.0000,0.00,210.0000,210.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(222,222,237,237,-11.0000,NULL,0.0000,305.0000,0.00,305.0000,305.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(223,223,238,238,-7.0000,NULL,0.0000,230.0000,0.00,230.0000,230.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(224,224,239,239,-9.0000,NULL,0.0000,400.0000,0.00,400.0000,400.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(225,225,240,240,-39.0000,NULL,0.0000,395.0000,0.00,395.0000,395.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(226,226,241,241,6.0000,NULL,0.0000,395.0000,0.00,395.0000,395.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(227,227,242,242,-17.0000,NULL,0.0000,305.0000,0.00,305.0000,305.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(228,228,243,243,1.0000,NULL,0.0000,305.0000,0.00,305.0000,305.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(229,229,244,244,1.0000,NULL,0.0000,220.0000,0.00,220.0000,220.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(230,230,245,245,-4.0000,NULL,0.0000,220.0000,0.00,220.0000,220.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(231,231,246,246,-17.0000,NULL,0.0000,305.0000,0.00,305.0000,305.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(232,232,247,247,6.0000,NULL,0.0000,220.0000,0.00,220.0000,220.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(233,233,248,248,6.0000,NULL,0.0000,305.0000,0.00,305.0000,305.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(234,234,249,249,-14.0000,NULL,0.0000,220.0000,0.00,220.0000,220.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(235,235,250,250,1.0000,NULL,0.0000,305.0000,0.00,305.0000,305.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(236,236,251,251,-14.0000,NULL,0.0000,220.0000,0.00,220.0000,220.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(237,237,252,252,-5.0000,NULL,0.0000,305.0000,0.00,305.0000,305.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(238,238,253,253,-8.0000,NULL,0.0000,230.0000,0.00,230.0000,230.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(239,239,254,254,-15.0000,NULL,0.0000,320.0000,0.00,320.0000,320.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(240,240,255,255,1.0000,NULL,0.0000,180.0000,0.00,180.0000,180.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(241,241,256,256,-8.0000,NULL,0.0000,190.0000,0.00,190.0000,190.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(242,242,257,257,-5.0000,NULL,0.0000,180.0000,0.00,180.0000,180.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(243,243,259,259,1.0000,NULL,0.0000,220.0000,0.00,220.0000,220.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(244,244,260,260,12.0000,NULL,0.0000,400.0000,0.00,400.0000,400.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(245,245,261,261,12.0000,NULL,0.0000,130.0000,0.00,130.0000,130.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(246,246,262,262,1.0000,NULL,0.0000,420.0000,0.00,420.0000,420.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(247,247,263,263,1.0000,NULL,0.0000,450.0000,0.00,450.0000,450.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(248,248,264,264,1.0000,NULL,0.0000,450.0000,0.00,450.0000,450.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(249,249,265,265,5.0000,NULL,0.0000,420.0000,0.00,420.0000,420.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(250,250,266,266,1.0000,NULL,0.0000,320.0000,0.00,320.0000,320.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(251,251,267,267,4.0000,NULL,0.0000,270.0000,0.00,270.0000,270.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(252,252,268,268,1.0000,NULL,0.0000,270.0000,0.00,270.0000,270.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(253,253,269,269,-34.0000,NULL,0.0000,150.0000,0.00,150.0000,150.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(254,254,270,270,-5.0000,NULL,0.0000,380.0000,0.00,380.0000,380.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(255,255,271,271,-110.0000,NULL,0.0000,220.0000,0.00,220.0000,220.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(256,256,272,272,-14.0000,NULL,0.0000,270.0000,0.00,270.0000,270.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(257,257,273,273,-52.0000,NULL,0.0000,310.0000,0.00,310.0000,310.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(258,258,274,274,-91.7500,NULL,0.0000,390.0000,0.00,390.0000,390.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(259,259,275,275,-187.5000,NULL,0.0000,210.0000,0.00,210.0000,210.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:58','2024-12-09 15:45:58'),(260,260,276,276,-12.0000,NULL,0.0000,310.0000,0.00,310.0000,310.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(261,261,277,277,-121.5000,NULL,0.0000,170.0000,0.00,170.0000,170.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(262,262,278,278,-128.0000,NULL,0.0000,410.0000,0.00,410.0000,410.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(263,263,279,279,-9.0000,NULL,0.0000,410.0000,0.00,410.0000,410.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(264,264,280,280,-20.0000,NULL,0.0000,220.0000,0.00,220.0000,220.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(265,265,281,281,-62.0000,NULL,0.0000,410.0000,0.00,410.0000,410.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(266,266,282,282,-4.0000,NULL,0.0000,220.0000,0.00,220.0000,220.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(267,267,283,283,-12.0000,NULL,0.0000,320.0000,0.00,320.0000,320.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(268,268,284,284,-15.5000,NULL,0.0000,180.0000,0.00,180.0000,180.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(269,269,285,285,-33.0000,NULL,0.0000,330.0000,0.00,330.0000,330.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(270,270,286,286,1.0000,NULL,0.0000,260.0000,0.00,260.0000,260.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(271,271,287,287,1.0000,NULL,0.0000,260.0000,0.00,260.0000,260.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(272,272,288,288,2.0000,NULL,0.0000,280.0000,0.00,280.0000,280.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(273,273,289,289,-99.0000,NULL,0.0000,580.0000,0.00,580.0000,580.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(274,274,290,290,-220.0000,NULL,0.0000,580.0000,0.00,580.0000,580.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(275,275,291,291,1.0000,NULL,0.0000,150.0000,0.00,150.0000,150.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(276,276,292,292,-362.0000,NULL,0.0000,90.0000,0.00,90.0000,90.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(277,277,293,293,-43.0000,NULL,0.0000,150.0000,0.00,150.0000,150.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(278,278,294,294,-1.0000,NULL,0.0000,270.0000,0.00,270.0000,270.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(279,279,295,295,-1.0000,NULL,0.0000,270.0000,0.00,270.0000,270.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(280,280,296,296,1.0000,NULL,0.0000,270.0000,0.00,270.0000,270.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(281,281,297,297,-1.0000,NULL,0.0000,270.0000,0.00,270.0000,270.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(282,282,298,298,-4.0000,NULL,0.0000,270.0000,0.00,270.0000,270.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(283,283,299,299,1.0000,NULL,0.0000,270.0000,0.00,270.0000,270.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(284,284,300,300,1.0000,NULL,0.0000,270.0000,0.00,270.0000,270.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(285,285,301,301,1.0000,NULL,0.0000,270.0000,0.00,270.0000,270.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(286,286,302,302,1.0000,NULL,0.0000,270.0000,0.00,270.0000,270.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(287,287,303,303,1.0000,NULL,0.0000,270.0000,0.00,270.0000,270.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(288,288,304,304,1.0000,NULL,0.0000,270.0000,0.00,270.0000,270.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(289,289,305,305,1.0000,NULL,0.0000,320.0000,0.00,320.0000,320.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(290,290,306,306,1.0000,NULL,0.0000,320.0000,0.00,320.0000,320.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(291,291,307,307,3.0000,NULL,0.0000,320.0000,0.00,320.0000,320.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(292,292,308,308,-13.0000,NULL,0.0000,120.0000,0.00,120.0000,120.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(293,293,309,309,-10.0000,NULL,0.0000,220.0000,0.00,220.0000,220.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(294,294,310,310,-2.0000,NULL,0.0000,220.0000,0.00,220.0000,220.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(295,295,311,311,-3.0000,NULL,0.0000,220.0000,0.00,220.0000,220.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(296,296,312,312,-11.5500,NULL,0.0000,430.0000,0.00,430.0000,430.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(297,297,313,313,-29.0000,NULL,0.0000,230.0000,0.00,230.0000,230.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(298,298,314,314,17.0000,NULL,0.0000,270.0000,0.00,270.0000,270.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(299,299,315,315,1.0000,NULL,0.0000,230.0000,0.00,230.0000,230.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(300,300,316,316,1.0000,NULL,0.0000,390.0000,0.00,390.0000,390.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(301,301,317,317,3.0000,NULL,0.0000,230.0000,0.00,230.0000,230.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(302,302,319,319,12.0000,NULL,0.0000,390.0000,0.00,390.0000,390.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(303,303,320,320,1.0000,NULL,0.0000,180.0000,0.00,180.0000,180.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(304,304,321,321,-13.0000,NULL,0.0000,180.0000,0.00,180.0000,180.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(305,305,322,322,5.0000,NULL,0.0000,210.0000,0.00,210.0000,210.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(306,306,323,323,5.0000,NULL,0.0000,270.0000,0.00,270.0000,270.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(307,307,324,324,2.0000,NULL,0.0000,210.0000,0.00,210.0000,210.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(308,308,325,325,-2.0000,NULL,0.0000,210.0000,0.00,210.0000,210.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(309,309,326,326,1.0000,NULL,0.0000,300.0000,0.00,300.0000,300.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(310,310,327,327,3.0000,NULL,0.0000,230.0000,0.00,230.0000,230.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(311,311,328,328,6.0000,NULL,0.0000,320.0000,0.00,320.0000,320.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(312,312,329,329,-2.0000,NULL,0.0000,220.0000,0.00,220.0000,220.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(313,313,330,330,4.0000,NULL,0.0000,220.0000,0.00,220.0000,220.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(314,314,331,331,4.0000,NULL,0.0000,220.0000,0.00,220.0000,220.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(315,315,332,332,2.0000,NULL,0.0000,270.0000,0.00,270.0000,270.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(316,316,333,333,1.0000,NULL,0.0000,480.0000,0.00,480.0000,480.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(317,317,334,334,1.0000,NULL,0.0000,480.0000,0.00,480.0000,480.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(318,318,335,335,8.0000,NULL,0.0000,295.0000,0.00,295.0000,295.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(319,319,336,336,1.0000,NULL,0.0000,265.0000,0.00,265.0000,265.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(320,320,337,337,7.0000,NULL,0.0000,160.0000,0.00,160.0000,160.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(321,321,338,338,-538.0000,NULL,0.0000,120.0000,0.00,120.0000,120.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(322,322,339,339,-3.0000,NULL,0.0000,240.0000,0.00,240.0000,240.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(323,323,340,340,-21.0000,NULL,0.0000,390.0000,0.00,390.0000,390.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(324,324,341,341,-1.1300,NULL,0.0000,320.0000,0.00,320.0000,320.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(325,325,342,342,1.0000,NULL,0.0000,390.0000,0.00,390.0000,390.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(326,326,343,343,2.0000,NULL,0.0000,300.0000,0.00,300.0000,300.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(327,327,344,344,1.0000,NULL,0.0000,300.0000,0.00,300.0000,300.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(328,328,345,345,11.0000,NULL,0.0000,240.0000,0.00,240.0000,240.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(329,329,346,346,1.0000,NULL,0.0000,240.0000,0.00,240.0000,240.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(330,330,347,347,7.0000,NULL,0.0000,220.0000,0.00,220.0000,220.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(331,331,348,348,4.0000,NULL,0.0000,210.0000,0.00,210.0000,210.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(332,332,349,349,4.0000,NULL,0.0000,240.0000,0.00,240.0000,240.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(333,333,350,350,-2.0000,NULL,0.0000,240.0000,0.00,240.0000,240.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(334,334,351,351,3.0000,NULL,0.0000,140.0000,0.00,140.0000,140.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(335,335,352,352,6.0000,NULL,0.0000,170.0000,0.00,170.0000,170.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(336,336,353,353,1.0000,NULL,0.0000,420.0000,0.00,420.0000,420.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(337,337,354,354,1.0000,NULL,0.0000,320.0000,0.00,320.0000,320.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(338,338,355,355,1.0000,NULL,0.0000,170.0000,0.00,170.0000,170.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(339,339,356,356,3.0000,NULL,0.0000,300.0000,0.00,300.0000,300.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(340,340,357,357,3.0000,NULL,0.0000,320.0000,0.00,320.0000,320.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(341,341,358,358,10.0000,NULL,0.0000,160.0000,0.00,160.0000,160.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(342,342,359,359,-1.0000,NULL,0.0000,210.0000,0.00,210.0000,210.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(343,343,360,360,3.0000,NULL,0.0000,320.0000,0.00,320.0000,320.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(344,344,361,361,3.0000,NULL,0.0000,380.0000,0.00,380.0000,380.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(345,345,362,362,-14.0000,NULL,0.0000,140.0000,0.00,140.0000,140.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(346,346,363,363,-14.0000,NULL,0.0000,170.0000,0.00,170.0000,170.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(347,347,364,364,-40.0000,NULL,0.0000,140.0000,0.00,140.0000,140.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(348,348,365,365,-5.0000,NULL,0.0000,140.0000,0.00,140.0000,140.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(349,349,366,366,1.0000,NULL,0.0000,200.0000,0.00,200.0000,200.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(350,350,368,368,1.0000,NULL,0.0000,270.0000,0.00,270.0000,270.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(351,351,369,369,5.0000,NULL,0.0000,390.0000,0.00,390.0000,390.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(352,352,370,370,-37.0000,NULL,0.0000,370.0000,0.00,370.0000,370.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(353,353,371,371,-67.0000,NULL,0.0000,570.0000,0.00,570.0000,570.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(354,354,372,372,-21.0000,NULL,0.0000,270.0000,0.00,270.0000,270.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(355,355,373,373,1.0000,NULL,0.0000,180.0000,0.00,180.0000,180.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(356,356,374,374,30.0000,NULL,0.0000,230.0000,0.00,230.0000,230.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(357,357,375,375,1.0000,NULL,0.0000,260.0000,0.00,260.0000,260.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(358,358,376,376,5.0000,NULL,0.0000,340.0000,0.00,340.0000,340.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(359,359,377,377,1.0000,NULL,0.0000,470.0000,0.00,470.0000,470.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(360,360,378,378,9.0000,NULL,0.0000,230.0000,0.00,230.0000,230.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(361,361,379,379,4.0000,NULL,0.0000,320.0000,0.00,320.0000,320.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(362,362,380,380,-3.0000,NULL,0.0000,200.0000,0.00,200.0000,200.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(363,363,381,381,2.0000,NULL,0.0000,270.0000,0.00,270.0000,270.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(364,364,382,382,6.0000,NULL,0.0000,270.0000,0.00,270.0000,270.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(365,365,384,384,13.0000,NULL,0.0000,240.0000,0.00,240.0000,240.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(366,366,385,385,3.0000,NULL,0.0000,280.0000,0.00,280.0000,280.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(367,367,386,386,18.0000,NULL,0.0000,380.0000,0.00,380.0000,380.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(368,368,387,387,-4.0000,NULL,0.0000,240.0000,0.00,240.0000,240.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(369,369,388,388,1.0000,NULL,0.0000,470.0000,0.00,470.0000,470.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(370,370,389,389,1.0000,NULL,0.0000,470.0000,0.00,470.0000,470.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(371,371,390,390,1.0000,NULL,0.0000,370.0000,0.00,370.0000,370.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(372,372,391,391,1.0000,NULL,0.0000,370.0000,0.00,370.0000,370.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(373,373,392,392,1.0000,NULL,0.0000,370.0000,0.00,370.0000,370.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(374,374,393,393,2.0000,NULL,0.0000,370.0000,0.00,370.0000,370.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(375,375,394,394,1.0000,NULL,0.0000,370.0000,0.00,370.0000,370.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(376,376,395,395,-64.5000,NULL,0.0000,180.0000,0.00,180.0000,180.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(377,377,396,396,1.0000,NULL,0.0000,300.0000,0.00,300.0000,300.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(378,378,397,397,3.0000,NULL,0.0000,240.0000,0.00,240.0000,240.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(379,379,398,398,-4.0000,NULL,0.0000,240.0000,0.00,240.0000,240.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(380,380,399,399,-4.0000,NULL,0.0000,280.0000,0.00,280.0000,280.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(381,381,401,401,4.0000,NULL,0.0000,240.0000,0.00,240.0000,240.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(382,382,402,402,1.0000,NULL,0.0000,270.0000,0.00,270.0000,270.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(383,383,403,403,2.0000,NULL,0.0000,270.0000,0.00,270.0000,270.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(384,384,404,404,1.0000,NULL,0.0000,270.0000,0.00,270.0000,270.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(385,385,405,405,2.0000,NULL,0.0000,270.0000,0.00,270.0000,270.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(386,386,406,406,5.0000,NULL,0.0000,170.0000,0.00,170.0000,170.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(387,387,407,407,-1.0000,NULL,0.0000,270.0000,0.00,270.0000,270.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(388,388,409,409,-4.0000,NULL,0.0000,170.0000,0.00,170.0000,170.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(389,389,410,410,14.0000,NULL,0.0000,240.0000,0.00,240.0000,240.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(390,390,411,411,-34.5000,NULL,0.0000,170.0000,0.00,170.0000,170.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(391,391,412,412,-31.0000,NULL,0.0000,220.0000,0.00,220.0000,220.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(392,392,413,413,-10.0000,NULL,0.0000,220.0000,0.00,220.0000,220.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(393,393,414,414,9.0000,NULL,0.0000,220.0000,0.00,220.0000,220.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(394,394,415,415,1.0000,NULL,0.0000,120.0000,0.00,120.0000,120.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(395,395,416,416,-2.0000,NULL,0.0000,170.0000,0.00,170.0000,170.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(396,396,417,417,9.0000,NULL,0.0000,170.0000,0.00,170.0000,170.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(397,397,418,418,6.0000,NULL,0.0000,170.0000,0.00,170.0000,170.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(398,398,419,419,7.0000,NULL,0.0000,170.0000,0.00,170.0000,170.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(399,399,420,420,23.0000,NULL,0.0000,350.0000,0.00,350.0000,350.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(400,400,421,421,1.0000,NULL,0.0000,190.0000,0.00,190.0000,190.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(401,401,422,422,1.0000,NULL,0.0000,320.0000,0.00,320.0000,320.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(402,402,423,423,-51.0000,NULL,0.0000,320.0000,0.00,320.0000,320.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(403,403,424,424,2.0000,NULL,0.0000,240.0000,0.00,240.0000,240.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(404,404,425,425,-4.0000,NULL,0.0000,240.0000,0.00,240.0000,240.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(405,405,426,426,1.0000,NULL,0.0000,570.0000,0.00,570.0000,570.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(406,406,427,427,1.0000,NULL,0.0000,580.0000,0.00,580.0000,580.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(407,407,428,428,-72.0000,NULL,0.0000,320.0000,0.00,320.0000,320.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(408,408,429,429,-11.0000,NULL,0.0000,180.0000,0.00,180.0000,180.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(409,409,430,430,-3.0000,NULL,0.0000,190.0000,0.00,190.0000,190.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(410,410,431,431,-281.0000,NULL,0.0000,250.0000,0.00,250.0000,250.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(411,411,432,432,6.0000,NULL,0.0000,220.0000,0.00,220.0000,220.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(412,412,433,433,8.0000,NULL,0.0000,300.0000,0.00,300.0000,300.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(413,413,434,434,-220.0000,NULL,0.0000,170.0000,0.00,170.0000,170.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(414,414,436,436,16.0000,NULL,0.0000,260.0000,0.00,260.0000,260.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(415,415,437,437,9.0000,NULL,0.0000,260.0000,0.00,260.0000,260.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(416,416,438,438,7.0000,NULL,0.0000,170.0000,0.00,170.0000,170.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(417,417,439,439,1.0000,NULL,0.0000,270.0000,0.00,270.0000,270.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(418,418,440,440,6.0000,NULL,0.0000,430.0000,0.00,430.0000,430.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(419,419,441,441,-81.5000,NULL,0.0000,270.0000,0.00,270.0000,270.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(420,420,442,442,733.0000,NULL,0.0000,430.0000,0.00,430.0000,430.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(421,421,443,443,4.0000,NULL,0.0000,1070.0000,0.00,1070.0000,1070.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(422,422,444,444,1.0000,NULL,0.0000,330.0000,0.00,330.0000,330.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(423,423,445,445,-5.0000,NULL,0.0000,470.0000,0.00,470.0000,470.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(424,424,446,446,1.0000,NULL,0.0000,340.0000,0.00,340.0000,340.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(425,425,447,447,1.0000,NULL,0.0000,370.0000,0.00,370.0000,370.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(426,426,448,448,2.0000,NULL,0.0000,220.0000,0.00,220.0000,220.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(427,427,449,449,1.0000,NULL,0.0000,220.0000,0.00,220.0000,220.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(428,428,450,450,7.0000,NULL,0.0000,410.0000,0.00,410.0000,410.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(429,429,451,451,1.0000,NULL,0.0000,290.0000,0.00,290.0000,290.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-12-09 15:45:59','2024-12-09 15:45:59'),(430,430,452,452,2.0000,NULL,0.0000,320.0000,0.00,320.0000,320.0000,0.0000,NULL,NULL,0.0000,NULL,NULL,0.0000,0