/*M!999999\- enable the sandbox mode */ 

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;
DROP TABLE IF EXISTS `account_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `account_transactions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `account_id` int(11) NOT NULL,
  `type` enum('debit','credit') NOT NULL,
  `sub_type` enum('opening_balance','fund_transfer','deposit') DEFAULT NULL,
  `amount` decimal(22,4) NOT NULL,
  `reff_no` varchar(191) DEFAULT NULL,
  `operation_date` datetime NOT NULL,
  `created_by` int(11) NOT NULL,
  `transaction_id` int(11) DEFAULT NULL,
  `transaction_payment_id` int(11) DEFAULT NULL,
  `transfer_transaction_id` int(11) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `account_transactions_account_id_index` (`account_id`),
  KEY `account_transactions_transaction_id_index` (`transaction_id`),
  KEY `account_transactions_transaction_payment_id_index` (`transaction_payment_id`),
  KEY `account_transactions_transfer_transaction_id_index` (`transfer_transaction_id`),
  KEY `account_transactions_created_by_index` (`created_by`),
  KEY `account_transactions_type_index` (`type`),
  KEY `account_transactions_sub_type_index` (`sub_type`),
  KEY `account_transactions_operation_date_index` (`operation_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `account_transactions` WRITE;
/*!40000 ALTER TABLE `account_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `account_transactions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `account_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `account_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `parent_account_type_id` int(11) DEFAULT NULL,
  `business_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `account_types_parent_account_type_id_index` (`parent_account_type_id`),
  KEY `account_types_business_id_index` (`business_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `account_types` WRITE;
/*!40000 ALTER TABLE `account_types` DISABLE KEYS */;
/*!40000 ALTER TABLE `account_types` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `accounting_acc_trans_mappings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `accounting_acc_trans_mappings` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `ref_no` varchar(100) NOT NULL,
  `type` varchar(100) NOT NULL,
  `created_by` int(11) NOT NULL,
  `operation_date` datetime NOT NULL,
  `note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `accounting_acc_trans_mappings` WRITE;
/*!40000 ALTER TABLE `accounting_acc_trans_mappings` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounting_acc_trans_mappings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `accounting_account_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `accounting_account_types` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `business_id` int(11) DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `account_primary_type` varchar(191) DEFAULT NULL,
  `account_type` varchar(191) DEFAULT NULL,
  `parent_id` bigint(20) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `show_balance` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=155 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `accounting_account_types` WRITE;
/*!40000 ALTER TABLE `accounting_account_types` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounting_account_types` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `accounting_accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `accounting_accounts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `gl_code` varchar(191) DEFAULT NULL,
  `business_id` int(11) NOT NULL,
  `account_primary_type` varchar(191) DEFAULT NULL,
  `account_sub_type_id` bigint(20) DEFAULT NULL,
  `detail_type_id` bigint(20) DEFAULT NULL,
  `parent_account_id` bigint(20) DEFAULT NULL,
  `description` longtext DEFAULT NULL,
  `status` varchar(191) DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `accounting_accounts` WRITE;
/*!40000 ALTER TABLE `accounting_accounts` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounting_accounts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `accounting_accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `accounting_accounts_transactions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `accounting_account_id` bigint(20) unsigned NOT NULL,
  `acc_trans_mapping_id` int(11) DEFAULT NULL COMMENT 'id form accounting_acc_trans_mapping table',
  `transaction_id` int(11) DEFAULT NULL COMMENT 'id form transactions table',
  `transaction_payment_id` int(11) DEFAULT NULL COMMENT 'id form transaction_payments table',
  `amount` decimal(22,4) NOT NULL,
  `type` varchar(100) NOT NULL COMMENT 'debit, credit etc',
  `sub_type` varchar(100) NOT NULL,
  `map_type` varchar(100) DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `operation_date` datetime NOT NULL,
  `note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `accounting_accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounting_accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounting_accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `accounting_budgets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `accounting_budgets` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `accounting_account_id` bigint(20) unsigned NOT NULL,
  `financial_year` int(11) NOT NULL,
  `jan` decimal(22,4) DEFAULT NULL,
  `feb` decimal(22,4) DEFAULT NULL,
  `mar` decimal(22,4) DEFAULT NULL,
  `apr` decimal(22,4) DEFAULT NULL,
  `may` decimal(22,4) DEFAULT NULL,
  `jun` decimal(22,4) DEFAULT NULL,
  `jul` decimal(22,4) DEFAULT NULL,
  `aug` decimal(22,4) DEFAULT NULL,
  `sep` decimal(22,4) DEFAULT NULL,
  `oct` decimal(22,4) DEFAULT NULL,
  `nov` decimal(22,4) DEFAULT NULL,
  `dec` decimal(22,4) DEFAULT NULL,
  `quarter_1` decimal(22,4) DEFAULT NULL,
  `quarter_2` decimal(22,4) DEFAULT NULL,
  `quarter_3` decimal(22,4) DEFAULT NULL,
  `quarter_4` decimal(22,4) DEFAULT NULL,
  `yearly` decimal(22,4) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `accounting_budgets` WRITE;
/*!40000 ALTER TABLE `accounting_budgets` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounting_budgets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `accounts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `name` varchar(191) NOT NULL,
  `account_number` varchar(191) NOT NULL,
  `account_details` text DEFAULT NULL,
  `account_type_id` int(11) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `is_closed` tinyint(1) NOT NULL DEFAULT 0,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `accounts_business_id_index` (`business_id`),
  KEY `accounts_account_type_id_index` (`account_type_id`),
  KEY `accounts_created_by_index` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `activity_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activity_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `log_name` varchar(191) DEFAULT NULL,
  `description` text NOT NULL,
  `subject_id` int(11) DEFAULT NULL,
  `subject_type` varchar(191) DEFAULT NULL,
  `event` varchar(191) DEFAULT NULL,
  `business_id` int(11) DEFAULT NULL,
  `causer_id` int(11) DEFAULT NULL,
  `causer_type` varchar(191) DEFAULT NULL,
  `properties` text DEFAULT NULL,
  `batch_uuid` char(36) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `activity_log_log_name_index` (`log_name`)
) ENGINE=InnoDB AUTO_INCREMENT=135 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `activity_log` WRITE;
/*!40000 ALTER TABLE `activity_log` DISABLE KEYS */;
INSERT INTO `activity_log` VALUES (1,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-04 09:01:43','2024-12-04 09:01:43'),(2,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-04 09:05:29','2024-12-04 09:05:29'),(3,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-04 09:14:08','2024-12-04 09:14:08'),(4,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-04 14:45:04','2024-12-04 14:45:04'),(5,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-04 16:48:46','2024-12-04 16:48:46'),(6,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-04 16:59:08','2024-12-04 16:59:08'),(7,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-04 16:59:11','2024-12-04 16:59:11'),(8,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-05 09:05:27','2024-12-05 09:05:27'),(9,'default','added',3452,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":32010}}',NULL,'2024-12-05 14:57:06','2024-12-05 14:57:06'),(10,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-06 10:15:29','2024-12-06 10:15:29'),(11,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-07 08:43:36','2024-12-07 08:43:36'),(12,'default','added',3457,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"status\":\"final\"}}',NULL,'2024-12-07 10:05:28','2024-12-07 10:05:28'),(13,'default','added',3459,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":44210}}',NULL,'2024-12-07 12:30:54','2024-12-07 12:30:54'),(14,'default','edited',3459,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":94050},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"44210.0000\"}}',NULL,'2024-12-07 13:27:29','2024-12-07 13:27:29'),(15,'default','edited',3459,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":314180},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"94050.0000\"}}',NULL,'2024-12-07 15:04:07','2024-12-07 15:04:07'),(16,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-10 08:36:02','2024-12-10 08:36:02'),(17,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-10 14:22:00','2024-12-10 14:22:00'),(18,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-10 22:34:23','2024-12-10 22:34:23'),(19,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-10 22:38:39','2024-12-10 22:38:39'),(20,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-11 02:08:13','2024-12-11 02:08:13'),(21,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-11 05:43:57','2024-12-11 05:43:57'),(22,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-11 09:33:47','2024-12-11 09:33:47'),(23,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-11 13:26:00','2024-12-11 13:26:00'),(24,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-11 13:56:55','2024-12-11 13:56:55'),(25,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-11 14:57:48','2024-12-11 14:57:48'),(26,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-11 15:32:25','2024-12-11 15:32:25'),(27,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-11 15:51:21','2024-12-11 15:51:21'),(28,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-11 17:56:03','2024-12-11 17:56:04'),(29,'default','added',3460,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":80}}',NULL,'2024-12-11 17:57:27','2024-12-11 17:57:27'),(30,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-13 04:29:36','2024-12-13 04:29:36'),(31,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-13 13:41:59','2024-12-13 13:41:59'),(32,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-13 22:24:03','2024-12-13 22:24:03'),(33,'default','added',8,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2024-12-13 22:28:22','2024-12-13 22:28:22'),(34,'default','added',3461,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":80}}',NULL,'2024-12-13 22:28:23','2024-12-13 22:28:23'),(35,'default','added',3462,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":80}}',NULL,'2024-12-13 22:29:42','2024-12-13 22:29:42'),(36,'default','added',3463,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":80}}',NULL,'2024-12-13 22:31:13','2024-12-13 22:31:13'),(37,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-14 00:10:11','2024-12-14 00:10:11'),(38,'default','added',3464,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":80}}',NULL,'2024-12-14 00:34:05','2024-12-14 00:34:05'),(39,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-14 08:38:59','2024-12-14 08:38:59'),(40,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-14 10:59:08','2024-12-14 10:59:08'),(41,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-14 13:08:36','2024-12-14 13:08:37'),(42,'default','added',2,'App\\User',NULL,1,1,'App\\User','{\"name\":\" Test \"}',NULL,'2024-12-14 13:29:35','2024-12-14 13:29:35'),(43,'default','added',9,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2024-12-14 13:32:07','2024-12-14 13:32:07'),(44,'default','added',3465,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":10500}}',NULL,'2024-12-14 13:32:48','2024-12-14 13:32:48'),(45,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2024-12-14 13:33:36','2024-12-14 13:33:36'),(46,'default','edited',2,'App\\User',NULL,1,1,'App\\User','{\"name\":\" Test \"}',NULL,'2024-12-14 13:46:12','2024-12-14 13:46:12'),(47,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-14 13:46:17','2024-12-14 13:46:17'),(48,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-14 13:46:42','2024-12-14 13:46:42'),(49,'default','edited',2,'App\\User',NULL,1,1,'App\\User','{\"name\":\" Test \"}',NULL,'2024-12-14 13:47:15','2024-12-14 13:47:15'),(50,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-14 13:47:25','2024-12-14 13:47:25'),(51,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-14 13:47:53','2024-12-14 13:47:53'),(52,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-14 13:48:04','2024-12-14 13:48:04'),(53,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2024-12-14 13:48:12','2024-12-14 13:48:12'),(54,'default','edited',2,'App\\User',NULL,1,2,'App\\User','{\"name\":\" Test \"}',NULL,'2024-12-14 13:48:38','2024-12-14 13:48:38'),(55,'default','logout',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2024-12-14 13:48:44','2024-12-14 13:48:44'),(56,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-14 13:48:48','2024-12-14 13:48:48'),(57,'default','edited',2,'App\\User',NULL,1,1,'App\\User','{\"name\":\" Test \"}',NULL,'2024-12-14 13:49:14','2024-12-14 13:49:14'),(58,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-14 13:49:37','2024-12-14 13:49:37'),(59,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2024-12-14 13:49:44','2024-12-14 13:49:44'),(60,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-14 21:32:45','2024-12-14 21:32:45'),(61,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-15 11:53:26','2024-12-15 11:53:26'),(62,'default','added',3466,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2024-12-15 11:54:38','2024-12-15 11:54:38'),(63,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-15 22:45:39','2024-12-15 22:45:39'),(64,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-16 00:24:30','2024-12-16 00:24:30'),(65,'default','payment_edited',3461,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"80.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"80.0000\"}}',NULL,'2024-12-16 03:11:48','2024-12-16 03:11:48'),(66,'default','payment_edited',3462,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"80.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"80.0000\"}}',NULL,'2024-12-16 03:11:48','2024-12-16 03:11:48'),(67,'default','payment_edited',3463,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"80.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"80.0000\"}}',NULL,'2024-12-16 03:11:48','2024-12-16 03:11:48'),(68,'default','payment_edited',3464,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"80.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"80.0000\"}}',NULL,'2024-12-16 03:11:48','2024-12-16 03:11:48'),(69,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-16 21:18:46','2024-12-16 21:18:46'),(70,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-17 11:34:47','2024-12-17 11:34:47'),(71,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-17 21:21:39','2024-12-17 21:21:39'),(72,'default','added',3467,'App\\Transaction',NULL,1,1,'App\\User','[]',NULL,'2024-12-17 21:26:03','2024-12-17 21:26:03'),(73,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-17 21:26:33','2024-12-17 21:26:33'),(74,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-18 11:51:39','2024-12-18 11:51:39'),(75,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-18 12:17:08','2024-12-18 12:17:08'),(76,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-18 12:17:38','2024-12-18 12:17:38'),(77,'default','added',3468,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"final_total\":40}}',NULL,'2024-12-18 12:17:49','2024-12-18 12:17:49'),(78,'default','added',3469,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":40}}',NULL,'2024-12-18 12:18:11','2024-12-18 12:18:11'),(79,'default','added',3470,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":40}}',NULL,'2024-12-18 12:19:57','2024-12-18 12:19:57'),(80,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-18 12:23:23','2024-12-18 12:23:23'),(81,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-18 12:24:29','2024-12-18 12:24:29'),(82,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-18 13:48:36','2024-12-18 13:48:36'),(83,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-18 16:04:48','2024-12-18 16:04:48'),(84,'default','added',3471,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":40}}',NULL,'2024-12-18 16:06:07','2024-12-18 16:06:07'),(85,'default','added',3472,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":40}}',NULL,'2024-12-18 16:06:07','2024-12-18 16:06:07'),(86,'default','added',3473,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":40}}',NULL,'2024-12-18 16:12:14','2024-12-18 16:12:14'),(87,'default','sell_deleted',3473,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":3473,\"invoice_no\":\"0061\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"40.0000\"}}',NULL,'2024-12-18 16:12:33','2024-12-18 16:12:33'),(88,'default','sell_deleted',3471,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":3471,\"invoice_no\":\"0059\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"40.0000\"}}',NULL,'2024-12-18 16:12:36','2024-12-18 16:12:36'),(89,'default','sell_deleted',3472,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":3472,\"invoice_no\":\"0060\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"40.0000\"}}',NULL,'2024-12-18 16:12:39','2024-12-18 16:12:39'),(90,'default','sell_deleted',3470,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":3470,\"invoice_no\":\"0058\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"40.0000\"}}',NULL,'2024-12-18 16:12:42','2024-12-18 16:12:42'),(91,'default','sell_deleted',3469,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":3469,\"invoice_no\":\"0057\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"40.0000\"}}',NULL,'2024-12-18 16:12:45','2024-12-18 16:12:45'),(92,'default','added',3474,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":40}}',NULL,'2024-12-18 16:13:03','2024-12-18 16:13:03'),(93,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-18 18:55:20','2024-12-18 18:55:20'),(94,'default','added',3475,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":110}}',NULL,'2024-12-18 18:58:55','2024-12-18 18:58:55'),(95,'default','added',3476,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":110}}',NULL,'2024-12-18 18:59:21','2024-12-18 18:59:21'),(96,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-18 19:48:51','2024-12-18 19:48:51'),(97,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-18 19:55:12','2024-12-18 19:55:12'),(98,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-18 19:58:37','2024-12-18 19:58:37'),(99,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-19 09:52:30','2024-12-19 09:52:30'),(100,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-19 11:09:58','2024-12-19 11:09:58'),(101,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-19 11:11:18','2024-12-19 11:11:18'),(102,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-19 11:20:53','2024-12-19 11:20:53'),(103,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-19 13:00:05','2024-12-19 13:00:05'),(104,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-20 01:14:06','2024-12-20 01:14:06'),(105,'default','added',3479,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"final_total\":40}}',NULL,'2024-12-20 01:14:21','2024-12-20 01:14:21'),(106,'default','added',3480,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"final_total\":40}}',NULL,'2024-12-20 01:15:08','2024-12-20 01:15:08'),(107,'default','added',3481,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"final_total\":40}}',NULL,'2024-12-20 01:16:00','2024-12-20 01:16:00'),(108,'default','added',3482,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"final_total\":40}}',NULL,'2024-12-20 02:22:08','2024-12-20 02:22:08'),(109,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-20 02:24:51','2024-12-20 02:24:51'),(110,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-20 02:26:00','2024-12-20 02:26:00'),(111,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-20 02:27:38','2024-12-20 02:27:38'),(112,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-20 02:28:07','2024-12-20 02:28:07'),(113,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-20 02:29:29','2024-12-20 02:29:29'),(114,'default','added',3483,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"final_total\":40}}',NULL,'2024-12-20 02:29:48','2024-12-20 02:29:48'),(115,'default','edited',3476,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"paid\",\"final_total\":110},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"110.0000\"}}',NULL,'2024-12-20 02:30:44','2024-12-20 02:30:44'),(116,'default','edited',3476,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"payment_status\":\"partial\",\"final_total\":240},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"paid\",\"final_total\":\"110.0000\"}}',NULL,'2024-12-20 02:34:50','2024-12-20 02:34:50'),(117,'default','added',3484,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"final_total\":40}}',NULL,'2024-12-20 02:35:40','2024-12-20 02:35:40'),(118,'default','added',3485,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"final_total\":150}}',NULL,'2024-12-20 02:43:15','2024-12-20 02:43:15'),(119,'default','added',3486,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"final_total\":40}}',NULL,'2024-12-20 03:44:09','2024-12-20 03:44:09'),(120,'default','added',3487,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"final_total\":110}}',NULL,'2024-12-20 04:00:05','2024-12-20 04:00:05'),(121,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-20 11:46:18','2024-12-20 11:46:18'),(122,'default','added',3488,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}',NULL,'2024-12-20 12:24:43','2024-12-20 12:24:43'),(123,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-20 13:39:12','2024-12-20 13:39:12'),(124,'default','added',10,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2024-12-20 14:58:02','2024-12-20 14:58:02'),(125,'default','added',3491,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":348}}',NULL,'2024-12-20 14:58:22','2024-12-20 14:58:22'),(126,'default','added',3492,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":348}}',NULL,'2024-12-20 15:01:24','2024-12-20 15:01:24'),(127,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-20 15:45:12','2024-12-20 15:45:12'),(128,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-20 15:54:01','2024-12-20 15:54:01'),(129,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-20 16:00:45','2024-12-20 16:00:45'),(130,'default','added',3493,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"final_total\":40}}',NULL,'2024-12-20 16:02:21','2024-12-20 16:02:21'),(131,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-20 19:11:02','2024-12-20 19:11:02'),(132,'default','edited',3492,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"payment_status\":\"paid\",\"final_total\":258},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"348.0000\"}}',NULL,'2024-12-20 20:01:53','2024-12-20 20:01:53'),(133,'default','edited',3493,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"payment_status\":\"due\",\"final_total\":20},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"final_total\":\"40.0000\"}}',NULL,'2024-12-20 20:02:43','2024-12-20 20:02:43'),(134,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-21 04:26:36','2024-12-21 04:26:36');
/*!40000 ALTER TABLE `activity_log` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `asset_maintenances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `asset_maintenances` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `asset_id` int(11) NOT NULL,
  `maitenance_id` varchar(191) DEFAULT NULL,
  `status` varchar(191) DEFAULT NULL,
  `priority` varchar(191) DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `assigned_to` int(11) DEFAULT NULL,
  `details` text DEFAULT NULL,
  `maintenance_note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `asset_maintenances_business_id_index` (`business_id`),
  KEY `asset_maintenances_asset_id_index` (`asset_id`),
  KEY `asset_maintenances_status_index` (`status`),
  KEY `asset_maintenances_priority_index` (`priority`),
  KEY `asset_maintenances_created_by_index` (`created_by`),
  KEY `asset_maintenances_assigned_to_index` (`assigned_to`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `asset_maintenances` WRITE;
/*!40000 ALTER TABLE `asset_maintenances` DISABLE KEYS */;
/*!40000 ALTER TABLE `asset_maintenances` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `asset_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `asset_transactions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `asset_id` int(10) unsigned DEFAULT NULL,
  `transaction_type` varchar(191) NOT NULL,
  `ref_no` varchar(191) NOT NULL,
  `receiver` int(10) unsigned DEFAULT NULL COMMENT 'id from users table, who receives asset',
  `quantity` decimal(22,4) NOT NULL,
  `transaction_datetime` datetime NOT NULL,
  `allocated_upto` date DEFAULT NULL,
  `reason` text DEFAULT NULL,
  `parent_id` int(10) unsigned DEFAULT NULL COMMENT 'id from asset_transactions table',
  `created_by` int(10) unsigned NOT NULL COMMENT 'id from users table, who allocated asset',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `asset_transactions_business_id_foreign` (`business_id`),
  KEY `asset_transactions_asset_id_foreign` (`asset_id`),
  KEY `asset_transactions_receiver_foreign` (`receiver`),
  KEY `asset_transactions_parent_id_foreign` (`parent_id`),
  KEY `asset_transactions_created_by_foreign` (`created_by`),
  CONSTRAINT `asset_transactions_asset_id_foreign` FOREIGN KEY (`asset_id`) REFERENCES `assets` (`id`) ON DELETE CASCADE,
  CONSTRAINT `asset_transactions_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `asset_transactions_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`),
  CONSTRAINT `asset_transactions_parent_id_foreign` FOREIGN KEY (`parent_id`) REFERENCES `asset_transactions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `asset_transactions_receiver_foreign` FOREIGN KEY (`receiver`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `asset_transactions` WRITE;
/*!40000 ALTER TABLE `asset_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `asset_transactions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `asset_warranties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `asset_warranties` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(11) NOT NULL,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `additional_cost` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `additional_note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `asset_warranties` WRITE;
/*!40000 ALTER TABLE `asset_warranties` DISABLE KEYS */;
/*!40000 ALTER TABLE `asset_warranties` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `assets` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `asset_code` varchar(191) NOT NULL,
  `name` varchar(191) NOT NULL,
  `quantity` decimal(22,4) NOT NULL,
  `model` varchar(191) DEFAULT NULL,
  `serial_no` varchar(191) DEFAULT NULL,
  `category_id` int(10) unsigned DEFAULT NULL,
  `location_id` int(10) unsigned DEFAULT NULL,
  `purchase_date` date DEFAULT NULL,
  `purchase_type` varchar(191) DEFAULT NULL,
  `unit_price` decimal(22,4) NOT NULL,
  `depreciation` decimal(22,4) DEFAULT NULL,
  `is_allocatable` tinyint(1) NOT NULL DEFAULT 0,
  `description` text DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `assets_business_id_foreign` (`business_id`),
  KEY `assets_category_id_foreign` (`category_id`),
  KEY `assets_created_by_foreign` (`created_by`),
  CONSTRAINT `assets_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `assets_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `categories` (`id`),
  CONSTRAINT `assets_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `barcodes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `barcodes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  `width` double(22,4) DEFAULT NULL,
  `height` double(22,4) DEFAULT NULL,
  `paper_width` double(22,4) DEFAULT NULL,
  `paper_height` double(22,4) DEFAULT NULL,
  `top_margin` double(22,4) DEFAULT NULL,
  `left_margin` double(22,4) DEFAULT NULL,
  `row_distance` double(22,4) DEFAULT NULL,
  `col_distance` double(22,4) DEFAULT NULL,
  `stickers_in_one_row` int(11) DEFAULT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  `is_continuous` tinyint(1) NOT NULL DEFAULT 0,
  `stickers_in_one_sheet` int(11) DEFAULT NULL,
  `business_id` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `barcodes_business_id_foreign` (`business_id`),
  CONSTRAINT `barcodes_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `barcodes` WRITE;
/*!40000 ALTER TABLE `barcodes` DISABLE KEYS */;
INSERT INTO `barcodes` VALUES (1,'20 Labels per Sheet','Sheet Size: 8.5\" x 11\", Label Size: 4\" x 1\", Labels per sheet: 20',4.0000,1.0000,8.5000,11.0000,0.5000,0.1250,0.0000,0.1875,2,0,0,20,NULL,'2017-12-18 00:13:44','2017-12-18 00:13:44'),(2,'30 Labels per sheet','Sheet Size: 8.5\" x 11\", Label Size: 2.625\" x 1\", Labels per sheet: 30',2.6250,1.0000,8.5000,11.0000,0.5000,0.1880,0.0000,0.1250,3,0,0,30,NULL,'2017-12-18 00:04:39','2017-12-18 00:10:40'),(3,'32 Labels per sheet','Sheet Size: 8.5\" x 11\", Label Size: 2\" x 1.25\", Labels per sheet: 32',2.0000,1.2500,8.5000,11.0000,0.5000,0.2500,0.0000,0.0000,4,0,0,32,NULL,'2017-12-17 23:55:40','2017-12-17 23:55:40'),(4,'40 Labels per sheet','Sheet Size: 8.5\" x 11\", Label Size: 2\" x 1\", Labels per sheet: 40',2.0000,1.0000,8.5000,11.0000,0.5000,0.2500,0.0000,0.0000,4,0,0,40,NULL,'2017-12-17 23:58:40','2017-12-17 23:58:40'),(5,'50 Labels per Sheet','Sheet Size: 8.5\" x 11\", Label Size: 1.5\" x 1\", Labels per sheet: 50',1.5000,1.0000,8.5000,11.0000,0.5000,0.5000,0.0000,0.0000,5,0,0,50,NULL,'2017-12-17 23:51:10','2017-12-17 23:51:10'),(6,'Continuous Rolls - 31.75mm x 25.4mm','Label Size: 31.75mm x 25.4mm, Gap: 3.18mm',1.2500,1.0000,1.2500,0.0000,0.1250,0.0000,0.1250,0.0000,1,0,1,NULL,NULL,'2017-12-17 23:51:10','2017-12-17 23:51:10'),(7,'For Qr Code',NULL,0.9000,0.9000,10.0000,10.0000,0.0000,0.0000,0.1000,0.1000,1,0,0,1,1,'2024-11-02 06:35:28','2024-11-02 06:39:31');
/*!40000 ALTER TABLE `barcodes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `bookings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bookings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `contact_id` int(10) unsigned NOT NULL,
  `waiter_id` int(10) unsigned DEFAULT NULL,
  `table_id` int(10) unsigned DEFAULT NULL,
  `correspondent_id` int(11) DEFAULT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` int(10) unsigned NOT NULL,
  `booking_start` datetime NOT NULL,
  `booking_end` datetime NOT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `booking_status` varchar(191) NOT NULL,
  `booking_note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bookings_contact_id_foreign` (`contact_id`),
  KEY `bookings_business_id_foreign` (`business_id`),
  KEY `bookings_created_by_foreign` (`created_by`),
  KEY `bookings_table_id_index` (`table_id`),
  KEY `bookings_waiter_id_index` (`waiter_id`),
  KEY `bookings_location_id_index` (`location_id`),
  KEY `bookings_booking_status_index` (`booking_status`),
  KEY `bookings_correspondent_id_index` (`correspondent_id`),
  CONSTRAINT `bookings_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `bookings_contact_id_foreign` FOREIGN KEY (`contact_id`) REFERENCES `contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `bookings_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `bookings` WRITE;
/*!40000 ALTER TABLE `bookings` DISABLE KEYS */;
/*!40000 ALTER TABLE `bookings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `brands`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `brands` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `brands_business_id_foreign` (`business_id`),
  KEY `brands_created_by_foreign` (`created_by`),
  CONSTRAINT `brands_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `brands_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=283 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `brands` WRITE;
/*!40000 ALTER TABLE `brands` DISABLE KEYS */;
INSERT INTO `brands` VALUES (69,1,'19',NULL,1,NULL,'2024-12-04 09:22:35','2024-12-04 09:22:35'),(70,1,'35',NULL,1,NULL,'2024-12-04 09:22:35','2024-12-04 09:22:35'),(71,1,'23',NULL,1,NULL,'2024-12-04 09:22:35','2024-12-04 09:22:35'),(72,1,'3',NULL,1,NULL,'2024-12-04 09:22:35','2024-12-04 09:22:35'),(73,1,'48',NULL,1,NULL,'2024-12-04 09:22:35','2024-12-04 09:22:35'),(74,1,'18',NULL,1,NULL,'2024-12-04 09:22:35','2024-12-04 09:22:35'),(75,1,'14',NULL,1,NULL,'2024-12-04 09:22:35','2024-12-04 09:22:35'),(76,1,'53',NULL,1,NULL,'2024-12-04 09:22:35','2024-12-04 09:22:35'),(77,1,'40',NULL,1,NULL,'2024-12-04 09:22:35','2024-12-04 09:22:35'),(78,1,'70',NULL,1,NULL,'2024-12-04 09:22:35','2024-12-04 09:22:35'),(79,1,'13/9',NULL,1,NULL,'2024-12-04 09:22:35','2024-12-04 09:22:35'),(80,1,'21/25/29/33',NULL,1,NULL,'2024-12-04 09:22:36','2024-12-04 09:22:36'),(81,1,'19/23',NULL,1,NULL,'2024-12-04 09:22:36','2024-12-04 09:22:36'),(82,1,'51',NULL,1,NULL,'2024-12-04 09:22:36','2024-12-04 09:22:36'),(83,1,'26',NULL,1,NULL,'2024-12-04 09:22:36','2024-12-04 09:22:36'),(84,1,'4',NULL,1,NULL,'2024-12-04 09:22:36','2024-12-04 09:22:36'),(85,1,'8',NULL,1,NULL,'2024-12-04 09:22:36','2024-12-04 09:22:36'),(86,1,'34',NULL,1,NULL,'2024-12-04 09:22:36','2024-12-04 09:22:36'),(87,1,'42626',NULL,1,NULL,'2024-12-04 09:22:36','2024-12-04 09:22:36'),(88,1,'9/13/16',NULL,1,NULL,'2024-12-04 09:22:36','2024-12-04 09:22:36'),(94,1,'Display cabinet',NULL,1,NULL,'2024-12-04 16:34:58','2024-12-04 16:34:58'),(95,1,'on glass rack',NULL,1,NULL,'2024-12-04 16:34:58','2024-12-04 16:34:58'),(96,1,'open',NULL,1,NULL,'2024-12-04 16:34:59','2024-12-04 16:34:59'),(97,1,'9.13.16',NULL,1,NULL,'2024-12-04 16:34:59','2024-12-04 16:34:59'),(98,1,'9/10',NULL,1,NULL,'2024-12-04 16:34:59','2024-12-04 16:34:59'),(99,1,'on a glass rack',NULL,1,NULL,'2024-12-04 16:34:59','2024-12-04 16:34:59'),(100,1,'74',NULL,1,NULL,'2024-12-04 16:34:59','2024-12-04 16:34:59'),(101,1,'49',NULL,1,NULL,'2024-12-04 16:34:59','2024-12-04 16:34:59'),(102,1,'25',NULL,1,NULL,'2024-12-04 16:34:59','2024-12-04 16:34:59'),(103,1,'93',NULL,1,NULL,'2024-12-04 16:34:59','2024-12-04 16:34:59'),(104,1,'151',NULL,1,NULL,'2024-12-04 16:34:59','2024-12-04 16:34:59'),(105,1,'39',NULL,1,NULL,'2024-12-04 16:34:59','2024-12-04 16:34:59'),(106,1,'114',NULL,1,NULL,'2024-12-04 16:34:59','2024-12-04 16:34:59'),(107,1,'64',NULL,1,NULL,'2024-12-04 16:34:59','2024-12-04 16:34:59'),(108,1,'17',NULL,1,NULL,'2024-12-04 16:34:59','2024-12-04 16:34:59'),(109,1,'5',NULL,1,NULL,'2024-12-04 16:35:00','2024-12-04 16:35:00'),(110,1,'140',NULL,1,NULL,'2024-12-04 16:35:00','2024-12-04 16:35:00'),(111,1,'60',NULL,1,NULL,'2024-12-04 16:35:00','2024-12-04 16:35:00'),(112,1,'127',NULL,1,NULL,'2024-12-04 16:35:00','2024-12-04 16:35:00'),(113,1,'83',NULL,1,NULL,'2024-12-04 16:35:00','2024-12-04 16:35:00'),(114,1,'24',NULL,1,NULL,'2024-12-04 16:35:00','2024-12-04 16:35:00'),(115,1,'47',NULL,1,NULL,'2024-12-04 16:35:00','2024-12-04 16:35:00'),(116,1,'80',NULL,1,NULL,'2024-12-04 16:35:00','2024-12-04 16:35:00'),(117,1,'Under glasses rack',NULL,1,NULL,'2024-12-04 16:35:01','2024-12-04 16:35:01'),(118,1,'91',NULL,1,NULL,'2024-12-04 16:35:01','2024-12-04 16:35:01'),(119,1,'55',NULL,1,NULL,'2024-12-04 16:35:01','2024-12-04 16:35:01'),(120,1,'13',NULL,1,NULL,'2024-12-04 16:35:01','2024-12-04 16:35:01'),(121,1,'38',NULL,1,NULL,'2024-12-04 16:35:01','2024-12-04 16:35:01'),(122,1,'3.4',NULL,1,NULL,'2024-12-04 16:35:01','2024-12-04 16:35:01'),(123,1,'59',NULL,1,NULL,'2024-12-04 16:35:01','2024-12-04 16:35:01'),(124,1,'65',NULL,1,NULL,'2024-12-04 16:35:01','2024-12-04 16:35:01'),(125,1,'12.13',NULL,1,NULL,'2024-12-04 16:35:01','2024-12-04 16:35:01'),(126,1,'10',NULL,1,NULL,'2024-12-04 16:35:01','2024-12-04 16:35:01'),(127,1,'50',NULL,1,NULL,'2024-12-04 16:35:01','2024-12-04 16:35:01'),(128,1,'16',NULL,1,NULL,'2024-12-04 16:35:01','2024-12-04 16:35:01'),(129,1,'43',NULL,1,NULL,'2024-12-04 16:35:01','2024-12-04 16:35:01'),(130,1,'11',NULL,1,NULL,'2024-12-04 16:35:01','2024-12-04 16:35:01'),(131,1,'109',NULL,1,NULL,'2024-12-04 16:35:01','2024-12-04 16:35:01'),(132,1,'9',NULL,1,NULL,'2024-12-04 16:35:01','2024-12-04 16:35:01'),(133,1,'32',NULL,1,NULL,'2024-12-04 16:35:01','2024-12-04 16:35:01'),(134,1,'104',NULL,1,NULL,'2024-12-04 16:35:01','2024-12-04 16:35:01'),(135,1,'30',NULL,1,NULL,'2024-12-04 16:35:01','2024-12-04 16:35:01'),(136,1,'103',NULL,1,NULL,'2024-12-04 16:35:01','2024-12-04 16:35:01'),(137,1,'115',NULL,1,NULL,'2024-12-04 16:35:01','2024-12-04 16:35:01'),(138,1,'94',NULL,1,NULL,'2024-12-04 16:35:01','2024-12-04 16:35:01'),(139,1,'57',NULL,1,NULL,'2024-12-04 16:35:01','2024-12-04 16:35:01'),(140,1,'82',NULL,1,NULL,'2024-12-04 16:35:01','2024-12-04 16:35:01'),(141,1,'7',NULL,1,NULL,'2024-12-04 16:35:01','2024-12-04 16:35:01'),(142,1,'58',NULL,1,NULL,'2024-12-04 16:35:01','2024-12-04 16:35:01'),(143,1,'54',NULL,1,NULL,'2024-12-04 16:35:01','2024-12-04 16:35:01'),(144,1,'120',NULL,1,NULL,'2024-12-04 16:35:01','2024-12-04 16:35:01'),(145,1,'129',NULL,1,NULL,'2024-12-04 16:35:01','2024-12-04 16:35:01'),(146,1,'33',NULL,1,NULL,'2024-12-04 16:35:01','2024-12-04 16:35:01'),(147,1,'29',NULL,1,NULL,'2024-12-04 16:35:01','2024-12-04 16:35:01'),(148,1,'113',NULL,1,NULL,'2024-12-04 16:35:01','2024-12-04 16:35:01'),(149,1,'92',NULL,1,NULL,'2024-12-04 16:35:01','2024-12-04 16:35:01'),(150,1,'85',NULL,1,NULL,'2024-12-04 16:35:01','2024-12-04 16:35:01'),(151,1,'1',NULL,1,NULL,'2024-12-04 16:35:01','2024-12-04 16:35:01'),(152,1,'1/22/26/30',NULL,1,NULL,'2024-12-04 16:35:02','2024-12-04 16:35:02'),(153,1,'1.26',NULL,1,NULL,'2024-12-04 16:35:03','2024-12-04 16:35:03'),(154,1,'68',NULL,1,NULL,'2024-12-04 16:35:05','2024-12-04 16:35:05'),(155,1,'67',NULL,1,NULL,'2024-12-04 16:35:05','2024-12-04 16:35:05'),(156,1,'71',NULL,1,NULL,'2024-12-04 16:35:05','2024-12-04 16:35:05'),(157,1,'72',NULL,1,NULL,'2024-12-04 16:35:05','2024-12-04 16:35:05'),(158,1,'76',NULL,1,NULL,'2024-12-04 16:35:05','2024-12-04 16:35:05'),(159,1,'77',NULL,1,NULL,'2024-12-04 16:35:05','2024-12-04 16:35:05'),(160,1,'78',NULL,1,NULL,'2024-12-04 16:35:05','2024-12-04 16:35:05'),(161,1,'90',NULL,1,NULL,'2024-12-04 16:35:05','2024-12-04 16:35:05'),(162,1,'81',NULL,1,NULL,'2024-12-04 16:35:06','2024-12-04 16:35:06'),(163,1,'84',NULL,1,NULL,'2024-12-04 16:35:06','2024-12-04 16:35:06'),(164,1,'87',NULL,1,NULL,'2024-12-04 16:35:06','2024-12-04 16:35:06'),(165,1,'20',NULL,1,NULL,'2024-12-04 16:35:06','2024-12-04 16:35:06'),(166,1,'21',NULL,1,NULL,'2024-12-04 16:35:06','2024-12-04 16:35:06'),(167,1,'2',NULL,1,NULL,'2024-12-04 16:35:06','2024-12-04 16:35:06'),(168,1,'66',NULL,1,NULL,'2024-12-04 16:35:06','2024-12-04 16:35:06'),(169,1,'79',NULL,1,NULL,'2024-12-04 16:35:06','2024-12-04 16:35:06'),(170,1,'159',NULL,1,NULL,'2024-12-04 16:35:06','2024-12-04 16:35:06'),(171,1,'124',NULL,1,NULL,'2024-12-04 16:35:06','2024-12-04 16:35:06'),(172,1,'37',NULL,1,NULL,'2024-12-04 16:35:06','2024-12-04 16:35:06'),(173,1,'15',NULL,1,NULL,'2024-12-04 16:35:06','2024-12-04 16:35:06'),(174,1,'62',NULL,1,NULL,'2024-12-04 16:35:06','2024-12-04 16:35:06'),(175,1,'130',NULL,1,NULL,'2024-12-04 16:35:06','2024-12-04 16:35:06'),(176,1,'89',NULL,1,NULL,'2024-12-04 16:35:06','2024-12-04 16:35:06'),(177,1,'63',NULL,1,NULL,'2024-12-04 16:35:06','2024-12-04 16:35:06'),(178,1,'56',NULL,1,NULL,'2024-12-04 16:35:07','2024-12-04 16:35:07'),(179,1,'46',NULL,1,NULL,'2024-12-04 16:35:07','2024-12-04 16:35:07'),(180,1,'45',NULL,1,NULL,'2024-12-04 16:35:07','2024-12-04 16:35:07'),(181,1,'111',NULL,1,NULL,'2024-12-04 16:35:07','2024-12-04 16:35:07'),(182,1,'12',NULL,1,NULL,'2024-12-04 16:35:07','2024-12-04 16:35:07'),(183,1,'44',NULL,1,NULL,'2024-12-04 16:35:07','2024-12-04 16:35:07'),(184,1,'6',NULL,1,NULL,'2024-12-04 16:35:07','2024-12-04 16:35:07'),(185,1,'52',NULL,1,NULL,'2024-12-04 16:35:07','2024-12-04 16:35:07'),(186,1,'107',NULL,1,NULL,'2024-12-04 16:35:07','2024-12-04 16:35:07'),(187,1,'42',NULL,1,NULL,'2024-12-04 16:35:07','2024-12-04 16:35:07'),(188,1,'105',NULL,1,NULL,'2024-12-04 16:35:07','2024-12-04 16:35:07'),(189,1,'97',NULL,1,NULL,'2024-12-04 16:35:07','2024-12-04 16:35:07'),(190,1,'98',NULL,1,NULL,'2024-12-04 16:35:07','2024-12-04 16:35:07'),(191,1,'163',NULL,1,NULL,'2024-12-04 16:35:07','2024-12-04 16:35:07'),(192,1,'131',NULL,1,NULL,'2024-12-04 16:35:08','2024-12-04 16:35:08'),(193,1,'41',NULL,1,NULL,'2024-12-04 16:35:08','2024-12-04 16:35:08'),(194,1,'7/11/15/19',NULL,1,NULL,'2024-12-04 16:35:08','2024-12-04 16:35:08'),(195,1,'27/31',NULL,1,NULL,'2024-12-04 16:35:08','2024-12-04 16:35:08'),(196,1,'3/7/11/15/19',NULL,1,NULL,'2024-12-04 16:35:08','2024-12-04 16:35:08'),(197,1,'3/7/11/15/23',NULL,1,NULL,'2024-12-04 16:35:09','2024-12-04 16:35:09'),(198,1,'31/32',NULL,1,NULL,'2024-12-04 16:35:09','2024-12-04 16:35:09'),(199,1,'22',NULL,1,NULL,'2024-12-04 16:35:10','2024-12-04 16:35:10'),(200,1,'31',NULL,1,NULL,'2024-12-04 16:35:10','2024-12-04 16:35:10'),(201,1,'36',NULL,1,NULL,'2024-12-04 16:35:10','2024-12-04 16:35:10'),(202,1,'27',NULL,1,NULL,'2024-12-04 16:35:11','2024-12-04 16:35:11'),(203,1,'112',NULL,1,NULL,'2024-12-04 16:35:11','2024-12-04 16:35:11'),(204,1,'96',NULL,1,NULL,'2024-12-04 16:35:11','2024-12-04 16:35:11'),(205,1,'2/6/10/14/18',NULL,1,NULL,'2024-12-04 16:35:11','2024-12-04 16:35:11'),(206,1,'61',NULL,1,NULL,'2024-12-04 16:35:11','2024-12-04 16:35:11'),(207,1,'86',NULL,1,NULL,'2024-12-04 16:35:11','2024-12-04 16:35:11'),(208,1,'8.12',NULL,1,NULL,'2024-12-04 16:35:12','2024-12-04 16:35:12'),(209,1,'119',NULL,1,NULL,'2024-12-04 16:35:12','2024-12-04 16:35:12'),(210,1,'118',NULL,1,NULL,'2024-12-04 16:35:13','2024-12-04 16:35:13'),(211,1,'95',NULL,1,NULL,'2024-12-04 16:35:13','2024-12-04 16:35:13'),(212,1,'24/4/34',NULL,1,NULL,'2024-12-04 16:35:13','2024-12-04 16:35:13'),(213,1,'04/35',NULL,1,NULL,'2024-12-04 16:35:14','2024-12-04 16:35:14'),(214,1,'4.24',NULL,1,NULL,'2024-12-04 16:35:14','2024-12-04 16:35:14'),(215,1,'16/20',NULL,1,NULL,'2024-12-04 16:35:15','2024-12-04 16:35:15'),(216,1,'28',NULL,1,NULL,'2024-12-04 16:35:16','2024-12-04 16:35:16'),(217,1,'108',NULL,1,NULL,'2024-12-04 16:35:16','2024-12-04 16:35:16'),(218,1,'106',NULL,1,NULL,'2024-12-04 16:35:17','2024-12-04 16:35:17'),(219,1,'145',NULL,1,NULL,'2024-12-04 16:35:17','2024-12-04 16:35:17'),(220,1,'117',NULL,1,NULL,'2024-12-04 16:35:17','2024-12-04 16:35:17'),(221,1,'102',NULL,1,NULL,'2024-12-04 16:35:17','2024-12-04 16:35:17'),(222,1,'166',NULL,1,NULL,'2024-12-04 16:35:17','2024-12-04 16:35:17'),(223,1,'148',NULL,1,NULL,'2024-12-04 16:35:17','2024-12-04 16:35:17'),(224,1,'69',NULL,1,NULL,'2024-12-04 16:35:17','2024-12-04 16:35:17'),(225,1,'150',NULL,1,NULL,'2024-12-04 16:35:17','2024-12-04 16:35:17'),(226,1,'38/39/40',NULL,1,NULL,'2024-12-04 16:35:18','2024-12-04 16:35:18'),(227,1,'88',NULL,1,NULL,'2024-12-04 16:35:18','2024-12-04 16:35:18'),(228,1,'141',NULL,1,NULL,'2024-12-04 16:35:18','2024-12-04 16:35:18'),(229,1,'99',NULL,1,NULL,'2024-12-04 16:35:18','2024-12-04 16:35:18'),(230,1,'100',NULL,1,NULL,'2024-12-04 16:35:18','2024-12-04 16:35:18'),(231,1,'162',NULL,1,NULL,'2024-12-04 16:35:18','2024-12-04 16:35:18'),(232,1,'128',NULL,1,NULL,'2024-12-04 16:35:18','2024-12-04 16:35:18'),(233,1,'139',NULL,1,NULL,'2024-12-04 16:35:18','2024-12-04 16:35:18'),(234,1,'165',NULL,1,NULL,'2024-12-04 16:35:18','2024-12-04 16:35:18'),(235,1,'160',NULL,1,NULL,'2024-12-04 16:35:18','2024-12-04 16:35:18'),(236,1,'152',NULL,1,NULL,'2024-12-04 16:35:18','2024-12-04 16:35:18'),(237,1,'143',NULL,1,NULL,'2024-12-04 16:35:19','2024-12-04 16:35:19'),(238,1,'137',NULL,1,NULL,'2024-12-04 16:35:19','2024-12-04 16:35:19'),(239,1,'73',NULL,1,NULL,'2024-12-04 16:35:19','2024-12-04 16:35:19'),(240,1,'132',NULL,1,NULL,'2024-12-04 16:35:19','2024-12-04 16:35:19'),(241,1,'147',NULL,1,NULL,'2024-12-04 16:35:19','2024-12-04 16:35:19'),(242,1,'134',NULL,1,NULL,'2024-12-04 16:35:19','2024-12-04 16:35:19'),(243,1,'136',NULL,1,NULL,'2024-12-04 16:35:19','2024-12-04 16:35:19'),(244,1,'158',NULL,1,NULL,'2024-12-04 16:35:19','2024-12-04 16:35:19'),(245,1,'133',NULL,1,NULL,'2024-12-04 16:35:19','2024-12-04 16:35:19'),(246,1,'116',NULL,1,NULL,'2024-12-04 16:35:19','2024-12-04 16:35:19'),(247,1,'110',NULL,1,NULL,'2024-12-04 16:35:19','2024-12-04 16:35:19'),(248,1,'101',NULL,1,NULL,'2024-12-04 16:35:19','2024-12-04 16:35:19'),(249,1,'154',NULL,1,NULL,'2024-12-04 16:35:20','2024-12-04 16:35:20'),(250,1,'153',NULL,1,NULL,'2024-12-04 16:35:20','2024-12-04 16:35:20'),(251,1,'149',NULL,1,NULL,'2024-12-04 16:35:20','2024-12-04 16:35:20'),(252,1,'157',NULL,1,NULL,'2024-12-04 16:35:20','2024-12-04 16:35:20'),(253,1,'125',NULL,1,NULL,'2024-12-04 16:35:20','2024-12-04 16:35:20'),(254,1,'142',NULL,1,NULL,'2024-12-04 16:35:20','2024-12-04 16:35:20'),(255,1,'155',NULL,1,NULL,'2024-12-04 16:35:20','2024-12-04 16:35:20'),(256,1,'121',NULL,1,NULL,'2024-12-04 16:35:20','2024-12-04 16:35:20'),(257,1,'146',NULL,1,NULL,'2024-12-04 16:35:20','2024-12-04 16:35:20'),(258,1,'126',NULL,1,NULL,'2024-12-04 16:35:20','2024-12-04 16:35:20'),(259,1,'123',NULL,1,NULL,'2024-12-04 16:35:20','2024-12-04 16:35:20'),(260,1,'122',NULL,1,NULL,'2024-12-04 16:35:20','2024-12-04 16:35:20'),(261,1,'156',NULL,1,NULL,'2024-12-04 16:35:21','2024-12-04 16:35:21'),(262,1,'75',NULL,1,NULL,'2024-12-04 16:35:21','2024-12-04 16:35:21'),(263,1,'144',NULL,1,NULL,'2024-12-04 16:35:21','2024-12-04 16:35:21'),(264,1,'16/36',NULL,1,NULL,'2024-12-04 16:49:29','2024-12-04 16:49:29'),(265,1,'1 to 5',NULL,1,NULL,'2024-12-05 09:18:43','2024-12-05 09:18:43'),(266,1,'6  to 10',NULL,1,NULL,'2024-12-05 09:24:59','2024-12-05 09:24:59'),(267,1,'16 to 20',NULL,1,NULL,'2024-12-05 09:33:14','2024-12-05 09:33:14'),(268,1,'21 to 27',NULL,1,NULL,'2024-12-05 09:36:48','2024-12-05 09:36:48'),(269,1,'11 to 15',NULL,1,NULL,'2024-12-05 09:48:19','2024-12-05 09:48:19'),(270,1,'33 to 37',NULL,1,NULL,'2024-12-05 10:27:40','2024-12-05 10:27:40'),(271,1,'28 to 32',NULL,1,NULL,'2024-12-05 10:34:19','2024-12-05 10:34:19'),(272,1,'13.7.24',NULL,1,NULL,'2024-12-05 10:45:07','2024-12-05 10:45:07'),(273,1,'96 to 98',NULL,1,NULL,'2024-12-05 11:13:26','2024-12-05 11:13:26'),(274,1,'38 to 42',NULL,1,NULL,'2024-12-05 11:20:16','2024-12-05 11:20:16'),(275,1,'48 to 52',NULL,1,NULL,'2024-12-05 11:45:44','2024-12-05 11:45:44'),(276,1,'43 to 47',NULL,1,NULL,'2024-12-05 11:56:23','2024-12-05 11:56:23'),(277,1,'94 to 95',NULL,1,NULL,'2024-12-05 12:19:11','2024-12-05 12:19:11'),(278,1,'105 to 106',NULL,1,NULL,'2024-12-05 12:30:06','2024-12-05 12:30:06'),(279,1,'53 to 57',NULL,1,NULL,'2024-12-05 12:36:26','2024-12-05 12:36:26'),(280,1,'13.7.24',NULL,1,NULL,'2024-12-07 09:04:48','2024-12-07 09:04:48'),(281,1,'GUARD',NULL,1,NULL,'2024-12-20 14:34:55','2024-12-20 14:34:55'),(282,1,'GUARD',NULL,1,NULL,'2024-12-20 14:39:19','2024-12-20 14:39:19');
/*!40000 ALTER TABLE `brands` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `business`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `business` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `currency_id` int(10) unsigned NOT NULL,
  `start_date` date DEFAULT NULL,
  `tax_number_1` varchar(100) DEFAULT NULL,
  `tax_label_1` varchar(10) DEFAULT NULL,
  `tax_number_2` varchar(100) DEFAULT NULL,
  `tax_label_2` varchar(10) DEFAULT NULL,
  `code_label_1` varchar(191) DEFAULT NULL,
  `code_1` varchar(191) DEFAULT NULL,
  `code_label_2` varchar(191) DEFAULT NULL,
  `code_2` varchar(191) DEFAULT NULL,
  `default_sales_tax` int(10) unsigned DEFAULT NULL,
  `default_profit_percent` double(5,2) NOT NULL DEFAULT 0.00,
  `owner_id` int(10) unsigned NOT NULL,
  `time_zone` varchar(191) NOT NULL DEFAULT 'Asia/Kolkata',
  `fy_start_month` tinyint(4) NOT NULL DEFAULT 1,
  `accounting_method` enum('fifo','lifo','avco') NOT NULL DEFAULT 'fifo',
  `default_sales_discount` decimal(5,2) DEFAULT NULL,
  `sell_price_tax` enum('includes','excludes') NOT NULL DEFAULT 'includes',
  `logo` varchar(191) DEFAULT NULL,
  `sku_prefix` varchar(191) DEFAULT NULL,
  `enable_product_expiry` tinyint(1) NOT NULL DEFAULT 0,
  `expiry_type` enum('add_expiry','add_manufacturing') NOT NULL DEFAULT 'add_expiry',
  `on_product_expiry` enum('keep_selling','stop_selling','auto_delete') NOT NULL DEFAULT 'keep_selling',
  `stop_selling_before` int(11) NOT NULL COMMENT 'Stop selling expied item n days before expiry',
  `enable_tooltip` tinyint(1) NOT NULL DEFAULT 1,
  `purchase_in_diff_currency` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Allow purchase to be in different currency then the business currency',
  `purchase_currency_id` int(10) unsigned DEFAULT NULL,
  `p_exchange_rate` decimal(20,3) NOT NULL DEFAULT 1.000,
  `transaction_edit_days` int(10) unsigned NOT NULL DEFAULT 30,
  `stock_expiry_alert_days` int(10) unsigned NOT NULL DEFAULT 30,
  `keyboard_shortcuts` text DEFAULT NULL,
  `pos_settings` text DEFAULT NULL,
  `manufacturing_settings` text DEFAULT NULL,
  `essentials_settings` longtext DEFAULT NULL,
  `weighing_scale_setting` text NOT NULL COMMENT 'used to store the configuration of weighing scale',
  `enable_brand` tinyint(1) NOT NULL DEFAULT 1,
  `enable_category` tinyint(1) NOT NULL DEFAULT 1,
  `enable_sub_category` tinyint(1) NOT NULL DEFAULT 1,
  `enable_price_tax` tinyint(1) NOT NULL DEFAULT 1,
  `enable_purchase_status` tinyint(1) DEFAULT 1,
  `enable_lot_number` tinyint(1) NOT NULL DEFAULT 0,
  `default_unit` int(11) DEFAULT NULL,
  `enable_sub_units` tinyint(1) NOT NULL DEFAULT 0,
  `enable_racks` tinyint(1) NOT NULL DEFAULT 0,
  `enable_row` tinyint(1) NOT NULL DEFAULT 0,
  `enable_position` tinyint(1) NOT NULL DEFAULT 0,
  `enable_editing_product_from_purchase` tinyint(1) NOT NULL DEFAULT 1,
  `sales_cmsn_agnt` enum('logged_in_user','user','cmsn_agnt') DEFAULT NULL,
  `item_addition_method` tinyint(1) NOT NULL DEFAULT 1,
  `enable_inline_tax` tinyint(1) NOT NULL DEFAULT 1,
  `currency_symbol_placement` enum('before','after') NOT NULL DEFAULT 'before',
  `enabled_modules` text DEFAULT NULL,
  `date_format` varchar(191) NOT NULL DEFAULT 'm/d/Y',
  `time_format` enum('12','24') NOT NULL DEFAULT '24',
  `currency_precision` tinyint(4) NOT NULL DEFAULT 2,
  `quantity_precision` tinyint(4) NOT NULL DEFAULT 2,
  `ref_no_prefixes` text DEFAULT NULL,
  `theme_color` char(20) DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `asset_settings` text DEFAULT NULL,
  `crm_settings` text DEFAULT NULL,
  `accounting_settings` text DEFAULT NULL,
  `enable_rp` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'rp is the short form of reward points',
  `rp_name` varchar(191) DEFAULT NULL COMMENT 'rp is the short form of reward points',
  `amount_for_unit_rp` decimal(22,4) NOT NULL DEFAULT 1.0000 COMMENT 'rp is the short form of reward points',
  `min_order_total_for_rp` decimal(22,4) NOT NULL DEFAULT 1.0000 COMMENT 'rp is the short form of reward points',
  `max_rp_per_order` int(11) DEFAULT NULL COMMENT 'rp is the short form of reward points',
  `redeem_amount_per_unit_rp` decimal(22,4) NOT NULL DEFAULT 1.0000 COMMENT 'rp is the short form of reward points',
  `min_order_total_for_redeem` decimal(22,4) NOT NULL DEFAULT 1.0000 COMMENT 'rp is the short form of reward points',
  `min_redeem_point` int(11) DEFAULT NULL COMMENT 'rp is the short form of reward points',
  `max_redeem_point` int(11) DEFAULT NULL COMMENT 'rp is the short form of reward points',
  `rp_expiry_period` int(11) DEFAULT NULL COMMENT 'rp is the short form of reward points',
  `rp_expiry_type` enum('month','year') NOT NULL DEFAULT 'year' COMMENT 'rp is the short form of reward points',
  `email_settings` text DEFAULT NULL,
  `sms_settings` text DEFAULT NULL,
  `custom_labels` text DEFAULT NULL,
  `common_settings` text DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `business_owner_id_foreign` (`owner_id`),
  KEY `business_currency_id_foreign` (`currency_id`),
  KEY `business_default_sales_tax_foreign` (`default_sales_tax`),
  CONSTRAINT `business_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`),
  CONSTRAINT `business_default_sales_tax_foreign` FOREIGN KEY (`default_sales_tax`) REFERENCES `tax_rates` (`id`),
  CONSTRAINT `business_owner_id_foreign` FOREIGN KEY (`owner_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `business` WRITE;
/*!40000 ALTER TABLE `business` DISABLE KEYS */;
INSERT INTO `business` VALUES (1,'Bajwa Trader',91,'2024-10-25',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.00,1,'Asia/Karachi',1,'fifo',0.00,'includes',NULL,NULL,0,'add_expiry','keep_selling',0,0,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"search_by_barcode\":\"shift+b\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"recent_product_quantity\":\"f2\",\"weighing_scale\":null,\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"add_new_product\":\"f4\"}}','{\"amount_rounding_method\":null,\"cmmsn_calculation_type\":\"invoice_value\",\"razor_pay_key_id\":null,\"razor_pay_key_secret\":null,\"stripe_public_key\":null,\"stripe_secret_key\":null,\"show_multi_unit\":\"1\",\"enebale_search_by_barcode\":\"1\",\"disable_order_tax\":\"1\",\"disable_suspend\":\"1\",\"cash_denominations\":null,\"enable_cash_denomination_on\":\"pos_screen\",\"disable_pay_checkout\":0,\"disable_draft\":0,\"disable_express_checkout\":0,\"hide_product_suggestion\":0,\"hide_recent_trans\":0,\"disable_discount\":0,\"is_pos_subtotal_editable\":0}',NULL,NULL,'{\"label_prefix\":null,\"product_sku_length\":\"4\",\"qty_length\":\"3\",\"qty_length_decimal\":\"2\"}',1,1,0,1,1,0,NULL,0,1,0,0,1,NULL,1,1,'before','[\"purchases\",\"add_sale\",\"pos_sale\",\"stock_transfers\",\"stock_adjustment\",\"expenses\",\"account\"]','d/m/Y','12',2,2,'{\"purchase\":\"PO\",\"purchase_return\":null,\"purchase_requisition\":null,\"purchase_order\":null,\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"expense_payment\":null,\"business_location\":\"BL\",\"username\":null,\"subscription\":null,\"draft\":null,\"sales_order\":null}',NULL,NULL,NULL,NULL,NULL,0,NULL,1.0000,1.0000,NULL,1.0000,1.0000,NULL,NULL,NULL,'year','{\"mail_driver\":\"smtp\",\"mail_host\":null,\"mail_port\":null,\"mail_username\":null,\"mail_password\":null,\"mail_encryption\":null,\"mail_from_address\":null,\"mail_from_name\":null}','{\"sms_service\":\"other\",\"nexmo_key\":null,\"nexmo_secret\":null,\"nexmo_from\":null,\"twilio_sid\":null,\"twilio_token\":null,\"twilio_from\":null,\"url\":null,\"send_to_param_name\":\"to\",\"msg_param_name\":\"text\",\"request_method\":\"post\",\"header_1\":null,\"header_val_1\":null,\"header_2\":null,\"header_val_2\":null,\"header_3\":null,\"header_val_3\":null,\"param_1\":null,\"param_val_1\":null,\"param_2\":null,\"param_val_2\":null,\"param_3\":null,\"param_val_3\":null,\"param_4\":null,\"param_val_4\":null,\"param_5\":null,\"param_val_5\":null,\"param_6\":null,\"param_val_6\":null,\"param_7\":null,\"param_val_7\":null,\"param_8\":null,\"param_val_8\":null,\"param_9\":null,\"param_val_9\":null,\"param_10\":null,\"param_val_10\":null}','{\"payments\":{\"custom_pay_1\":null,\"custom_pay_2\":null,\"custom_pay_3\":null,\"custom_pay_4\":null,\"custom_pay_5\":null,\"custom_pay_6\":null,\"custom_pay_7\":null},\"contact\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null,\"custom_field_6\":null,\"custom_field_7\":null,\"custom_field_8\":null,\"custom_field_9\":null,\"custom_field_10\":null},\"product\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null,\"custom_field_6\":null,\"custom_field_7\":null,\"custom_field_8\":null,\"custom_field_9\":null,\"custom_field_10\":null,\"custom_field_11\":null,\"custom_field_12\":null,\"custom_field_13\":null,\"custom_field_14\":null,\"custom_field_15\":null,\"custom_field_16\":null,\"custom_field_17\":null,\"custom_field_18\":null,\"custom_field_19\":null,\"custom_field_20\":null},\"product_cf_details\":{\"1\":{\"type\":null,\"dropdown_options\":null},\"2\":{\"type\":null,\"dropdown_options\":null},\"3\":{\"type\":null,\"dropdown_options\":null},\"4\":{\"type\":null,\"dropdown_options\":null},\"5\":{\"type\":null,\"dropdown_options\":null},\"6\":{\"type\":null,\"dropdown_options\":null},\"7\":{\"type\":null,\"dropdown_options\":null},\"8\":{\"type\":null,\"dropdown_options\":null},\"9\":{\"type\":null,\"dropdown_options\":null},\"10\":{\"type\":null,\"dropdown_options\":null},\"11\":{\"type\":null,\"dropdown_options\":null},\"12\":{\"type\":null,\"dropdown_options\":null},\"13\":{\"type\":null,\"dropdown_options\":null},\"14\":{\"type\":null,\"dropdown_options\":null},\"15\":{\"type\":null,\"dropdown_options\":null},\"16\":{\"type\":null,\"dropdown_options\":null},\"17\":{\"type\":null,\"dropdown_options\":null},\"18\":{\"type\":null,\"dropdown_options\":null},\"19\":{\"type\":null,\"dropdown_options\":null},\"20\":{\"type\":null,\"dropdown_options\":null}},\"location\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"user\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"purchase\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"purchase_shipping\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null},\"sell\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"shipping\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null},\"types_of_service\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null,\"custom_field_6\":null}}','{\"enable_product_multi_unit\":\"1\",\"enable_product_defult_discount\":\"1\",\"default_credit_limit\":null,\"default_datatable_page_entries\":\"25\"}',1,'2024-10-25 16:39:24','2024-12-20 19:13:23');
/*!40000 ALTER TABLE `business` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `business_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `business_locations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` varchar(191) DEFAULT NULL,
  `kot_printer_type` enum('browser','printer') NOT NULL DEFAULT 'browser',
  `kot_printer_id` int(11) DEFAULT NULL,
  `name` varchar(256) NOT NULL,
  `landmark` text DEFAULT NULL,
  `country` varchar(100) NOT NULL,
  `state` varchar(100) NOT NULL,
  `city` varchar(100) NOT NULL,
  `zip_code` char(7) NOT NULL,
  `invoice_scheme_id` int(10) unsigned NOT NULL,
  `sale_invoice_scheme_id` int(11) DEFAULT NULL,
  `invoice_layout_id` int(10) unsigned NOT NULL,
  `sale_invoice_layout_id` int(11) DEFAULT NULL,
  `selling_price_group_id` int(11) DEFAULT NULL,
  `print_receipt_on_invoice` tinyint(1) DEFAULT 1,
  `receipt_printer_type` enum('browser','printer') NOT NULL DEFAULT 'browser',
  `printer_id` int(11) DEFAULT NULL,
  `mobile` varchar(191) DEFAULT NULL,
  `alternate_number` varchar(191) DEFAULT NULL,
  `email` varchar(191) DEFAULT NULL,
  `website` varchar(191) DEFAULT NULL,
  `featured_products` text DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `default_payment_accounts` text DEFAULT NULL,
  `custom_field1` varchar(191) DEFAULT NULL,
  `custom_field2` varchar(191) DEFAULT NULL,
  `custom_field3` varchar(191) DEFAULT NULL,
  `custom_field4` varchar(191) DEFAULT NULL,
  `accounting_default_map` text DEFAULT NULL COMMENT 'Default transactions mapping of accounting module',
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `business_locations_business_id_index` (`business_id`),
  KEY `business_locations_invoice_scheme_id_foreign` (`invoice_scheme_id`),
  KEY `business_locations_invoice_layout_id_foreign` (`invoice_layout_id`),
  KEY `business_locations_sale_invoice_layout_id_index` (`sale_invoice_layout_id`),
  KEY `business_locations_selling_price_group_id_index` (`selling_price_group_id`),
  KEY `business_locations_receipt_printer_type_index` (`receipt_printer_type`),
  KEY `business_locations_printer_id_index` (`printer_id`),
  CONSTRAINT `business_locations_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `business_locations_invoice_layout_id_foreign` FOREIGN KEY (`invoice_layout_id`) REFERENCES `invoice_layouts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `business_locations_invoice_scheme_id_foreign` FOREIGN KEY (`invoice_scheme_id`) REFERENCES `invoice_schemes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `business_locations` WRITE;
/*!40000 ALTER TABLE `business_locations` DISABLE KEYS */;
INSERT INTO `business_locations` VALUES (1,1,'BL0001','printer',1,'Bajwa Trader','admin@admin.com','Pakistan','Punjab','Muridke','39000',1,1,1,1,NULL,1,'browser',NULL,NULL,NULL,NULL,NULL,NULL,1,'{\"cash\":{\"is_enabled\":\"1\",\"account\":null},\"card\":{\"is_enabled\":\"1\",\"account\":null},\"cheque\":{\"is_enabled\":\"1\",\"account\":null},\"bank_transfer\":{\"is_enabled\":\"1\",\"account\":null},\"other\":{\"is_enabled\":\"1\",\"account\":null},\"custom_pay_1\":{\"is_enabled\":\"1\",\"account\":null},\"custom_pay_2\":{\"is_enabled\":\"1\",\"account\":null},\"custom_pay_3\":{\"is_enabled\":\"1\",\"account\":null},\"custom_pay_4\":{\"is_enabled\":\"1\",\"account\":null},\"custom_pay_5\":{\"is_enabled\":\"1\",\"account\":null},\"custom_pay_6\":{\"is_enabled\":\"1\",\"account\":null},\"custom_pay_7\":{\"is_enabled\":\"1\",\"account\":null}}',NULL,NULL,NULL,NULL,NULL,NULL,'2024-10-25 16:39:24','2024-12-07 09:58:18'),(3,1,'BL0001','browser',NULL,'Bajwa Traders lahore',NULL,'Pak','Pu','lahore','05475',1,1,1,1,NULL,1,'browser',NULL,'03008913928','03338303928',NULL,NULL,NULL,1,'{\"cash\":{\"is_enabled\":\"1\",\"account\":null},\"card\":{\"is_enabled\":\"1\",\"account\":null},\"cheque\":{\"is_enabled\":\"1\",\"account\":null},\"bank_transfer\":{\"is_enabled\":\"1\",\"account\":null},\"other\":{\"is_enabled\":\"1\",\"account\":null},\"custom_pay_1\":{\"account\":null},\"custom_pay_2\":{\"account\":null},\"custom_pay_3\":{\"account\":null},\"custom_pay_4\":{\"account\":null},\"custom_pay_5\":{\"account\":null},\"custom_pay_6\":{\"account\":null},\"custom_pay_7\":{\"account\":null}}',NULL,NULL,NULL,NULL,NULL,NULL,'2024-12-07 09:56:20','2024-12-07 09:56:20');
/*!40000 ALTER TABLE `business_locations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `cash_denominations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cash_denominations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `amount` decimal(22,4) NOT NULL,
  `total_count` int(11) NOT NULL,
  `model_type` varchar(191) NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cash_denominations_model_type_model_id_index` (`model_type`,`model_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `cash_denominations` WRITE;
/*!40000 ALTER TABLE `cash_denominations` DISABLE KEYS */;
/*!40000 ALTER TABLE `cash_denominations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `cash_register_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cash_register_transactions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cash_register_id` int(10) unsigned NOT NULL,
  `amount` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `pay_method` varchar(191) DEFAULT NULL,
  `type` enum('debit','credit') NOT NULL,
  `transaction_type` varchar(191) DEFAULT NULL,
  `transaction_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cash_register_transactions_cash_register_id_foreign` (`cash_register_id`),
  KEY `cash_register_transactions_transaction_id_index` (`transaction_id`),
  KEY `cash_register_transactions_type_index` (`type`),
  KEY `cash_register_transactions_transaction_type_index` (`transaction_type`),
  CONSTRAINT `cash_register_transactions_cash_register_id_foreign` FOREIGN KEY (`cash_register_id`) REFERENCES `cash_registers` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `cash_register_transactions` WRITE;
/*!40000 ALTER TABLE `cash_register_transactions` DISABLE KEYS */;
INSERT INTO `cash_register_transactions` VALUES (1,2,32010.0000,'cash','debit','sell',3452,'2024-12-05 14:57:05','2024-12-05 14:57:05'),(2,3,44210.0000,'cash','debit','sell',3459,'2024-12-07 12:30:54','2024-12-07 12:30:54'),(3,3,138260.0000,'cash','credit','sell',3459,'2024-12-07 13:27:29','2024-12-07 13:27:29'),(4,3,220130.0000,'cash','credit','sell',3459,'2024-12-07 15:04:07','2024-12-07 15:04:07'),(5,3,80.0000,'cash','debit','sell',3460,'2024-12-11 17:57:27','2024-12-11 17:57:27'),(10,3,40.0000,'cash','debit','sell',3474,'2024-12-18 16:13:03','2024-12-18 16:13:03'),(11,3,220.0000,'cash','debit','sell',3476,'2024-12-18 18:59:21','2024-12-18 18:59:21'),(12,3,-110.0000,'cash','debit','sell',3476,'2024-12-18 18:59:21','2024-12-18 18:59:21'),(13,3,50.0000,'cash','debit','sell',3488,'2024-12-20 12:24:43','2024-12-20 12:24:43'),(14,3,348.0000,'cash','debit','sell',3492,'2024-12-20 15:01:24','2024-12-20 15:01:24');
/*!40000 ALTER TABLE `cash_register_transactions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `cash_registers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cash_registers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` int(11) DEFAULT NULL,
  `user_id` int(10) unsigned DEFAULT NULL,
  `status` enum('close','open') NOT NULL DEFAULT 'open',
  `closed_at` datetime DEFAULT NULL,
  `closing_amount` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `total_card_slips` int(11) NOT NULL DEFAULT 0,
  `total_cheques` int(11) NOT NULL DEFAULT 0,
  `denominations` text DEFAULT NULL,
  `closing_note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cash_registers_business_id_foreign` (`business_id`),
  KEY `cash_registers_user_id_foreign` (`user_id`),
  KEY `cash_registers_location_id_index` (`location_id`),
  CONSTRAINT `cash_registers_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cash_registers_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `cash_registers` WRITE;
/*!40000 ALTER TABLE `cash_registers` DISABLE KEYS */;
INSERT INTO `cash_registers` VALUES (2,1,1,1,'close','2024-12-05 17:06:41',32010.0000,0,0,NULL,NULL,'2024-11-24 06:36:00','2024-12-05 17:06:41'),(3,1,1,1,'open',NULL,0.0000,0,0,NULL,NULL,'2024-12-06 10:15:00','2024-12-06 10:15:38');
/*!40000 ALTER TABLE `cash_registers` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `short_code` varchar(191) DEFAULT NULL,
  `parent_id` int(11) NOT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `category_type` varchar(191) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `slug` varchar(191) DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `categories_business_id_foreign` (`business_id`),
  KEY `categories_created_by_foreign` (`created_by`),
  KEY `categories_parent_id_index` (`parent_id`),
  CONSTRAINT `categories_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `categories_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=152 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `categories` WRITE;
/*!40000 ALTER TABLE `categories` DISABLE KEYS */;
INSERT INTO `categories` VALUES (134,'3',1,NULL,0,1,'product',NULL,NULL,NULL,'2024-12-04 09:22:35','2024-12-04 09:22:35'),(135,'1',1,NULL,0,1,'product',NULL,NULL,NULL,'2024-12-04 09:22:35','2024-12-04 09:22:35'),(136,'7',1,NULL,0,1,'product',NULL,NULL,NULL,'2024-12-04 09:22:35','2024-12-04 09:22:35'),(137,'4',1,NULL,0,1,'product',NULL,NULL,NULL,'2024-12-04 09:22:36','2024-12-04 09:22:36'),(138,'5',1,NULL,0,1,'product',NULL,NULL,NULL,'2024-12-04 09:22:36','2024-12-04 09:22:36'),(143,'10',1,NULL,0,1,'product',NULL,NULL,NULL,'2024-12-04 16:34:58','2024-12-04 16:34:58'),(144,'11',1,NULL,0,1,'product',NULL,NULL,NULL,'2024-12-04 16:34:58','2024-12-04 16:34:58'),(145,'2',1,NULL,0,1,'product',NULL,NULL,NULL,'2024-12-04 16:34:59','2024-12-04 16:34:59'),(146,'12',1,NULL,0,1,'product',NULL,NULL,NULL,'2024-12-04 16:34:59','2024-12-04 16:34:59'),(147,'6',1,NULL,0,1,'product',NULL,NULL,NULL,'2024-12-04 16:35:00','2024-12-04 16:35:00'),(148,'14',1,NULL,0,1,'product',NULL,NULL,NULL,'2024-12-04 16:35:00','2024-12-04 16:35:00'),(149,'8',1,NULL,0,1,'product',NULL,NULL,NULL,'2024-12-04 16:35:01','2024-12-04 16:35:01'),(150,'9',1,NULL,0,1,'product',NULL,NULL,NULL,'2024-12-04 16:49:29','2024-12-04 16:49:29'),(151,'13',1,NULL,0,1,'product',NULL,NULL,NULL,'2024-12-04 16:49:30','2024-12-04 16:49:30');
/*!40000 ALTER TABLE `categories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `categorizables`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categorizables` (
  `category_id` int(11) NOT NULL,
  `categorizable_type` varchar(191) NOT NULL,
  `categorizable_id` bigint(20) unsigned NOT NULL,
  KEY `categorizables_categorizable_type_categorizable_id_index` (`categorizable_type`,`categorizable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `categorizables` WRITE;
/*!40000 ALTER TABLE `categorizables` DISABLE KEYS */;
/*!40000 ALTER TABLE `categorizables` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `contacts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `contacts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `type` varchar(191) NOT NULL,
  `contact_type` varchar(191) DEFAULT NULL,
  `supplier_business_name` varchar(191) DEFAULT NULL,
  `name` varchar(191) DEFAULT NULL,
  `prefix` varchar(191) DEFAULT NULL,
  `first_name` varchar(191) DEFAULT NULL,
  `middle_name` varchar(191) DEFAULT NULL,
  `last_name` varchar(191) DEFAULT NULL,
  `email` varchar(191) DEFAULT NULL,
  `contact_id` varchar(191) DEFAULT NULL,
  `contact_status` varchar(191) NOT NULL DEFAULT 'active',
  `tax_number` varchar(191) DEFAULT NULL,
  `city` varchar(191) DEFAULT NULL,
  `state` varchar(191) DEFAULT NULL,
  `country` varchar(191) DEFAULT NULL,
  `address_line_1` text DEFAULT NULL,
  `address_line_2` text DEFAULT NULL,
  `zip_code` varchar(191) DEFAULT NULL,
  `dob` date DEFAULT NULL,
  `mobile` varchar(191) NOT NULL,
  `landline` varchar(191) DEFAULT NULL,
  `alternate_number` varchar(191) DEFAULT NULL,
  `pay_term_number` int(11) DEFAULT NULL,
  `pay_term_type` enum('days','months') DEFAULT NULL,
  `credit_limit` decimal(22,4) DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `converted_by` int(11) DEFAULT NULL,
  `converted_on` datetime DEFAULT NULL,
  `balance` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `total_rp` int(11) NOT NULL DEFAULT 0 COMMENT 'rp is the short form of reward points',
  `total_rp_used` int(11) NOT NULL DEFAULT 0 COMMENT 'rp is the short form of reward points',
  `total_rp_expired` int(11) NOT NULL DEFAULT 0 COMMENT 'rp is the short form of reward points',
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  `shipping_address` text DEFAULT NULL,
  `shipping_custom_field_details` longtext DEFAULT NULL,
  `is_export` tinyint(1) NOT NULL DEFAULT 0,
  `export_custom_field_1` varchar(191) DEFAULT NULL,
  `export_custom_field_2` varchar(191) DEFAULT NULL,
  `export_custom_field_3` varchar(191) DEFAULT NULL,
  `export_custom_field_4` varchar(191) DEFAULT NULL,
  `export_custom_field_5` varchar(191) DEFAULT NULL,
  `export_custom_field_6` varchar(191) DEFAULT NULL,
  `position` varchar(191) DEFAULT NULL,
  `customer_group_id` int(11) DEFAULT NULL,
  `crm_source` varchar(191) DEFAULT NULL,
  `crm_life_stage` varchar(191) DEFAULT NULL,
  `custom_field1` varchar(191) DEFAULT NULL,
  `custom_field2` varchar(191) DEFAULT NULL,
  `custom_field3` varchar(191) DEFAULT NULL,
  `custom_field4` varchar(191) DEFAULT NULL,
  `custom_field5` varchar(191) DEFAULT NULL,
  `custom_field6` varchar(191) DEFAULT NULL,
  `custom_field7` varchar(191) DEFAULT NULL,
  `custom_field8` varchar(191) DEFAULT NULL,
  `custom_field9` varchar(191) DEFAULT NULL,
  `custom_field10` varchar(191) DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `contacts_business_id_foreign` (`business_id`),
  KEY `contacts_created_by_foreign` (`created_by`),
  KEY `contacts_type_index` (`type`),
  KEY `contacts_contact_status_index` (`contact_status`),
  KEY `contacts_crm_source_index` (`crm_source`),
  KEY `contacts_crm_life_stage_index` (`crm_life_stage`),
  KEY `contacts_converted_by_index` (`converted_by`),
  CONSTRAINT `contacts_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `contacts_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `contacts` WRITE;
/*!40000 ALTER TABLE `contacts` DISABLE KEYS */;
INSERT INTO `contacts` VALUES (1,1,'customer',NULL,NULL,'Walk-In Customer',NULL,NULL,NULL,NULL,NULL,'CO0001','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,0.0000,1,NULL,NULL,0.0000,0,0,0,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-10-25 16:39:24','2024-10-25 16:39:24'),(8,1,'customer','individual',NULL,'Aslam',NULL,'Aslam',NULL,NULL,NULL,'CO0005','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'88',NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-12-13 22:28:22','2024-12-13 22:28:22'),(9,1,'supplier','business','Supplier','',NULL,NULL,NULL,NULL,NULL,'CO0006','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'265365',NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-12-14 13:32:07','2024-12-14 13:32:07'),(10,1,'customer','individual',NULL,'Mr  Salman s/o yaseen','Mr ','Salman','s/o','yaseen',NULL,'CO0007','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'03045064039',NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-12-20 14:58:02','2024-12-20 14:58:02');
/*!40000 ALTER TABLE `contacts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `crm_call_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `crm_call_logs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `call_type` varchar(191) DEFAULT NULL,
  `mobile_number` varchar(191) NOT NULL,
  `mobile_name` varchar(191) DEFAULT NULL,
  `contact_id` int(11) DEFAULT NULL,
  `start_time` datetime DEFAULT NULL,
  `end_time` datetime DEFAULT NULL,
  `duration` int(11) DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `crm_call_logs_business_id_index` (`business_id`),
  KEY `crm_call_logs_user_id_index` (`user_id`),
  KEY `crm_call_logs_contact_id_index` (`contact_id`),
  KEY `crm_call_logs_created_by_index` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `crm_call_logs` WRITE;
/*!40000 ALTER TABLE `crm_call_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `crm_call_logs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `crm_campaigns`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `crm_campaigns` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) NOT NULL,
  `campaign_type` enum('sms','email') NOT NULL DEFAULT 'email',
  `subject` varchar(191) DEFAULT NULL,
  `email_body` text DEFAULT NULL,
  `sms_body` text DEFAULT NULL,
  `sent_on` datetime DEFAULT NULL,
  `contact_ids` text NOT NULL,
  `additional_info` text DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `crm_campaigns_business_id_foreign` (`business_id`),
  KEY `crm_campaigns_created_by_index` (`created_by`),
  CONSTRAINT `crm_campaigns_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `crm_campaigns` WRITE;
/*!40000 ALTER TABLE `crm_campaigns` DISABLE KEYS */;
/*!40000 ALTER TABLE `crm_campaigns` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `crm_contact_person_commissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `crm_contact_person_commissions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `contact_person_id` int(11) NOT NULL,
  `transaction_id` int(11) DEFAULT NULL,
  `commission_amount` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `crm_contact_person_commissions` WRITE;
/*!40000 ALTER TABLE `crm_contact_person_commissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `crm_contact_person_commissions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `crm_followup_invoices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `crm_followup_invoices` (
  `follow_up_id` int(11) NOT NULL,
  `transaction_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `crm_followup_invoices` WRITE;
/*!40000 ALTER TABLE `crm_followup_invoices` DISABLE KEYS */;
/*!40000 ALTER TABLE `crm_followup_invoices` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `crm_lead_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `crm_lead_users` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `contact_id` int(10) unsigned NOT NULL,
  `user_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `crm_lead_users_user_id_index` (`user_id`),
  KEY `crm_lead_users_contact_id_index` (`contact_id`),
  CONSTRAINT `crm_lead_users_contact_id_foreign` FOREIGN KEY (`contact_id`) REFERENCES `contacts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `crm_lead_users` WRITE;
/*!40000 ALTER TABLE `crm_lead_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `crm_lead_users` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `crm_marketplaces`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `crm_marketplaces` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `marketplace` varchar(191) DEFAULT NULL,
  `site_key` varchar(191) DEFAULT NULL,
  `site_id` varchar(191) DEFAULT NULL,
  `assigned_users` text DEFAULT NULL,
  `crm_source_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `crm_marketplaces` WRITE;
/*!40000 ALTER TABLE `crm_marketplaces` DISABLE KEYS */;
/*!40000 ALTER TABLE `crm_marketplaces` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `crm_proposal_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `crm_proposal_templates` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `subject` text NOT NULL,
  `body` longtext NOT NULL,
  `cc` text DEFAULT NULL,
  `bcc` text DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `crm_proposal_templates_business_id_foreign` (`business_id`),
  KEY `crm_proposal_templates_created_by_index` (`created_by`),
  CONSTRAINT `crm_proposal_templates_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `crm_proposal_templates` WRITE;
/*!40000 ALTER TABLE `crm_proposal_templates` DISABLE KEYS */;
/*!40000 ALTER TABLE `crm_proposal_templates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `crm_proposals`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `crm_proposals` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `contact_id` int(10) unsigned NOT NULL,
  `subject` text NOT NULL,
  `body` longtext NOT NULL,
  `cc` text DEFAULT NULL,
  `bcc` text DEFAULT NULL,
  `sent_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `crm_proposals_business_id_foreign` (`business_id`),
  KEY `crm_proposals_contact_id_foreign` (`contact_id`),
  KEY `crm_proposals_sent_by_index` (`sent_by`),
  CONSTRAINT `crm_proposals_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `crm_proposals_contact_id_foreign` FOREIGN KEY (`contact_id`) REFERENCES `contacts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `crm_proposals` WRITE;
/*!40000 ALTER TABLE `crm_proposals` DISABLE KEYS */;
/*!40000 ALTER TABLE `crm_proposals` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `crm_schedule_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `crm_schedule_logs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `schedule_id` bigint(20) unsigned NOT NULL,
  `log_type` enum('call','sms','meeting','email') NOT NULL DEFAULT 'email',
  `start_datetime` datetime NOT NULL,
  `end_datetime` datetime NOT NULL,
  `subject` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `crm_schedule_logs_schedule_id_foreign` (`schedule_id`),
  KEY `crm_schedule_logs_created_by_index` (`created_by`),
  CONSTRAINT `crm_schedule_logs_schedule_id_foreign` FOREIGN KEY (`schedule_id`) REFERENCES `crm_schedules` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `crm_schedule_logs` WRITE;
/*!40000 ALTER TABLE `crm_schedule_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `crm_schedule_logs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `crm_schedule_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `crm_schedule_users` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `schedule_id` bigint(20) unsigned NOT NULL,
  `user_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `crm_schedule_users_schedule_id_foreign` (`schedule_id`),
  KEY `crm_schedule_users_user_id_index` (`user_id`),
  CONSTRAINT `crm_schedule_users_schedule_id_foreign` FOREIGN KEY (`schedule_id`) REFERENCES `crm_schedules` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `crm_schedule_users` WRITE;
/*!40000 ALTER TABLE `crm_schedule_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `crm_schedule_users` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `crm_schedules`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `crm_schedules` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `contact_id` int(11) DEFAULT NULL,
  `title` varchar(191) NOT NULL,
  `status` varchar(191) DEFAULT NULL,
  `start_datetime` datetime DEFAULT NULL,
  `end_datetime` datetime DEFAULT NULL,
  `description` text DEFAULT NULL,
  `schedule_type` enum('call','sms','meeting','email') NOT NULL DEFAULT 'email',
  `followup_category_id` int(11) DEFAULT NULL,
  `allow_notification` tinyint(1) NOT NULL DEFAULT 1,
  `notify_via` text DEFAULT NULL,
  `notify_before` int(11) DEFAULT NULL,
  `notify_type` enum('minute','hour','day') NOT NULL DEFAULT 'hour',
  `created_by` int(11) NOT NULL,
  `is_recursive` tinyint(1) NOT NULL DEFAULT 0,
  `recursion_days` int(11) DEFAULT NULL,
  `followup_additional_info` text DEFAULT NULL,
  `follow_up_by` varchar(191) DEFAULT NULL,
  `follow_up_by_value` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `crm_schedules_created_by_index` (`created_by`),
  KEY `crm_schedules_business_id_index` (`business_id`),
  KEY `crm_schedules_contact_id_index` (`contact_id`),
  KEY `crm_schedules_schedule_type_index` (`schedule_type`),
  KEY `crm_schedules_notify_type_index` (`notify_type`),
  CONSTRAINT `crm_schedules_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `crm_schedules` WRITE;
/*!40000 ALTER TABLE `crm_schedules` DISABLE KEYS */;
/*!40000 ALTER TABLE `crm_schedules` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `currencies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `currencies` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `country` varchar(100) NOT NULL,
  `currency` varchar(100) NOT NULL,
  `code` varchar(25) NOT NULL,
  `symbol` varchar(25) NOT NULL,
  `thousand_separator` varchar(10) NOT NULL,
  `decimal_separator` varchar(10) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=142 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `currencies` WRITE;
/*!40000 ALTER TABLE `currencies` DISABLE KEYS */;
INSERT INTO `currencies` VALUES (91,'Pakistan','Rupees','PKR','₨',',','.',NULL,NULL);
/*!40000 ALTER TABLE `currencies` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `customer_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `customer_groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) NOT NULL,
  `amount` double(5,2) NOT NULL,
  `price_calculation_type` varchar(191) DEFAULT 'percentage',
  `selling_price_group_id` int(11) DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_groups_business_id_foreign` (`business_id`),
  KEY `customer_groups_created_by_index` (`created_by`),
  KEY `customer_groups_price_calculation_type_index` (`price_calculation_type`),
  KEY `customer_groups_selling_price_group_id_index` (`selling_price_group_id`),
  CONSTRAINT `customer_groups_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `customer_groups` WRITE;
/*!40000 ALTER TABLE `customer_groups` DISABLE KEYS */;
INSERT INTO `customer_groups` VALUES (2,1,'Fruit Teas',0.00,'percentage',6,1,'2024-11-28 13:55:14','2024-11-28 13:55:14');
/*!40000 ALTER TABLE `customer_groups` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `dashboard_configurations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dashboard_configurations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `created_by` int(11) NOT NULL,
  `name` varchar(191) NOT NULL,
  `color` varchar(191) NOT NULL,
  `configuration` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dashboard_configurations_business_id_foreign` (`business_id`),
  CONSTRAINT `dashboard_configurations_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `dashboard_configurations` WRITE;
/*!40000 ALTER TABLE `dashboard_configurations` DISABLE KEYS */;
/*!40000 ALTER TABLE `dashboard_configurations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `discount_variations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `discount_variations` (
  `discount_id` int(11) NOT NULL,
  `variation_id` int(11) NOT NULL,
  KEY `discount_variations_discount_id_index` (`discount_id`),
  KEY `discount_variations_variation_id_index` (`variation_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `discount_variations` WRITE;
/*!40000 ALTER TABLE `discount_variations` DISABLE KEYS */;
INSERT INTO `discount_variations` VALUES (3,381);
/*!40000 ALTER TABLE `discount_variations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `discounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `discounts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `business_id` int(11) NOT NULL,
  `brand_id` int(11) DEFAULT NULL,
  `category_id` int(11) DEFAULT NULL,
  `location_id` int(11) DEFAULT NULL,
  `priority` int(11) DEFAULT NULL,
  `discount_type` varchar(191) DEFAULT NULL,
  `discount_amount` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `starts_at` datetime DEFAULT NULL,
  `ends_at` datetime DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `spg` varchar(100) DEFAULT NULL COMMENT 'Applicable in specified selling price group only. Use of applicable_in_spg column is discontinued',
  `applicable_in_cg` tinyint(1) DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `discounts_business_id_index` (`business_id`),
  KEY `discounts_brand_id_index` (`brand_id`),
  KEY `discounts_category_id_index` (`category_id`),
  KEY `discounts_location_id_index` (`location_id`),
  KEY `discounts_priority_index` (`priority`),
  KEY `discounts_spg_index` (`spg`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `discounts` WRITE;
/*!40000 ALTER TABLE `discounts` DISABLE KEYS */;
INSERT INTO `discounts` VALUES (3,'Discount',1,NULL,NULL,1,1,'percentage',2.0000,NULL,NULL,1,NULL,0,'2024-11-25 19:41:55','2024-11-25 19:41:55');
/*!40000 ALTER TABLE `discounts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `document_and_notes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `document_and_notes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `notable_id` int(11) NOT NULL,
  `notable_type` varchar(191) NOT NULL,
  `heading` text DEFAULT NULL,
  `description` text DEFAULT NULL,
  `is_private` tinyint(1) NOT NULL DEFAULT 0,
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `document_and_notes_business_id_index` (`business_id`),
  KEY `document_and_notes_notable_id_index` (`notable_id`),
  KEY `document_and_notes_created_by_index` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `document_and_notes` WRITE;
/*!40000 ALTER TABLE `document_and_notes` DISABLE KEYS */;
/*!40000 ALTER TABLE `document_and_notes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_allowances_and_deductions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `essentials_allowances_and_deductions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `description` varchar(191) NOT NULL,
  `type` enum('allowance','deduction') NOT NULL,
  `amount` decimal(22,4) NOT NULL,
  `amount_type` enum('fixed','percent') NOT NULL,
  `applicable_date` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_allowances_and_deductions_business_id_index` (`business_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_allowances_and_deductions` WRITE;
/*!40000 ALTER TABLE `essentials_allowances_and_deductions` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_allowances_and_deductions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_attendances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `essentials_attendances` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `business_id` int(11) NOT NULL,
  `clock_in_time` datetime DEFAULT NULL,
  `clock_out_time` datetime DEFAULT NULL,
  `essentials_shift_id` int(11) DEFAULT NULL,
  `ip_address` varchar(191) DEFAULT NULL,
  `clock_in_note` text DEFAULT NULL,
  `clock_out_note` text DEFAULT NULL,
  `clock_in_location` text DEFAULT NULL,
  `clock_out_location` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_attendances_user_id_index` (`user_id`),
  KEY `essentials_attendances_business_id_index` (`business_id`),
  KEY `essentials_attendances_essentials_shift_id_index` (`essentials_shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_attendances` WRITE;
/*!40000 ALTER TABLE `essentials_attendances` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_attendances` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_document_shares`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `essentials_document_shares` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `document_id` int(11) NOT NULL,
  `value_type` enum('user','role') NOT NULL,
  `value` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_document_shares_document_id_index` (`document_id`),
  KEY `essentials_document_shares_value_type_index` (`value_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_document_shares` WRITE;
/*!40000 ALTER TABLE `essentials_document_shares` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_document_shares` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_documents`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `essentials_documents` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `type` varchar(191) DEFAULT NULL,
  `name` varchar(191) NOT NULL,
  `description` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_documents` WRITE;
/*!40000 ALTER TABLE `essentials_documents` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_documents` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `essentials_holidays` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) DEFAULT NULL,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `business_id` int(11) NOT NULL,
  `location_id` int(11) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_holidays_business_id_index` (`business_id`),
  KEY `essentials_holidays_location_id_index` (`location_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_holidays` WRITE;
/*!40000 ALTER TABLE `essentials_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_holidays` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_kb`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `essentials_kb` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` bigint(20) unsigned NOT NULL,
  `title` varchar(191) NOT NULL,
  `content` longtext DEFAULT NULL,
  `status` varchar(191) NOT NULL,
  `kb_type` varchar(191) NOT NULL,
  `parent_id` bigint(20) unsigned DEFAULT NULL COMMENT 'id from essentials_kb table',
  `share_with` varchar(191) DEFAULT NULL COMMENT 'public, private, only_with',
  `created_by` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_kb_business_id_index` (`business_id`),
  KEY `essentials_kb_parent_id_index` (`parent_id`),
  KEY `essentials_kb_created_by_index` (`created_by`),
  CONSTRAINT `essentials_kb_parent_id_foreign` FOREIGN KEY (`parent_id`) REFERENCES `essentials_kb` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_kb` WRITE;
/*!40000 ALTER TABLE `essentials_kb` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_kb` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_kb_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `essentials_kb_users` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `kb_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_kb_users_kb_id_index` (`kb_id`),
  KEY `essentials_kb_users_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_kb_users` WRITE;
/*!40000 ALTER TABLE `essentials_kb_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_kb_users` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_leave_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `essentials_leave_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `leave_type` varchar(191) NOT NULL,
  `max_leave_count` int(11) DEFAULT NULL,
  `leave_count_interval` enum('month','year') DEFAULT NULL,
  `business_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_leave_types_business_id_index` (`business_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_leave_types` WRITE;
/*!40000 ALTER TABLE `essentials_leave_types` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_leave_types` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_leaves`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `essentials_leaves` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `essentials_leave_type_id` int(11) DEFAULT NULL,
  `business_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `ref_no` varchar(191) DEFAULT NULL,
  `status` enum('pending','approved','cancelled') DEFAULT NULL,
  `reason` text DEFAULT NULL,
  `status_note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_leaves_essentials_leave_type_id_index` (`essentials_leave_type_id`),
  KEY `essentials_leaves_business_id_index` (`business_id`),
  KEY `essentials_leaves_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_leaves` WRITE;
/*!40000 ALTER TABLE `essentials_leaves` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_leaves` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `essentials_messages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `message` text NOT NULL,
  `location_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_messages_business_id_index` (`business_id`),
  KEY `essentials_messages_user_id_index` (`user_id`),
  KEY `essentials_messages_location_id_index` (`location_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_messages` WRITE;
/*!40000 ALTER TABLE `essentials_messages` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_messages` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_payroll_group_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `essentials_payroll_group_transactions` (
  `payroll_group_id` bigint(20) unsigned NOT NULL,
  `transaction_id` int(11) NOT NULL,
  KEY `essentials_payroll_group_transactions_payroll_group_id_foreign` (`payroll_group_id`),
  CONSTRAINT `essentials_payroll_group_transactions_payroll_group_id_foreign` FOREIGN KEY (`payroll_group_id`) REFERENCES `essentials_payroll_groups` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_payroll_group_transactions` WRITE;
/*!40000 ALTER TABLE `essentials_payroll_group_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_payroll_group_transactions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_payroll_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `essentials_payroll_groups` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `location_id` int(11) DEFAULT NULL COMMENT 'payroll for work location',
  `name` varchar(191) NOT NULL,
  `status` varchar(191) NOT NULL,
  `payment_status` varchar(191) NOT NULL DEFAULT 'due',
  `gross_total` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_payroll_groups` WRITE;
/*!40000 ALTER TABLE `essentials_payroll_groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_payroll_groups` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_reminders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `essentials_reminders` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `name` varchar(191) NOT NULL,
  `date` date NOT NULL,
  `time` time NOT NULL,
  `end_time` time DEFAULT NULL,
  `repeat` enum('one_time','every_day','every_week','every_month') NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_reminders_business_id_index` (`business_id`),
  KEY `essentials_reminders_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_reminders` WRITE;
/*!40000 ALTER TABLE `essentials_reminders` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_reminders` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `essentials_shifts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `type` enum('fixed_shift','flexible_shift') NOT NULL DEFAULT 'fixed_shift',
  `business_id` int(11) NOT NULL,
  `start_time` time DEFAULT NULL,
  `end_time` time DEFAULT NULL,
  `is_allowed_auto_clockout` tinyint(1) NOT NULL DEFAULT 0,
  `auto_clockout_time` time DEFAULT NULL,
  `holidays` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_shifts_type_index` (`type`),
  KEY `essentials_shifts_business_id_index` (`business_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_shifts` WRITE;
/*!40000 ALTER TABLE `essentials_shifts` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_shifts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_to_dos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `essentials_to_dos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `task` text NOT NULL,
  `date` datetime DEFAULT NULL,
  `end_date` datetime DEFAULT NULL,
  `task_id` varchar(191) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `status` varchar(191) DEFAULT NULL,
  `estimated_hours` varchar(191) DEFAULT NULL,
  `priority` varchar(191) DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_to_dos_status_index` (`status`),
  KEY `essentials_to_dos_priority_index` (`priority`),
  KEY `essentials_to_dos_created_by_index` (`created_by`),
  KEY `essentials_to_dos_business_id_index` (`business_id`),
  KEY `essentials_to_dos_task_id_index` (`task_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_to_dos` WRITE;
/*!40000 ALTER TABLE `essentials_to_dos` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_to_dos` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_todo_comments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `essentials_todo_comments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `comment` text NOT NULL,
  `task_id` int(11) NOT NULL,
  `comment_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_todo_comments_task_id_index` (`task_id`),
  KEY `essentials_todo_comments_comment_by_index` (`comment_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_todo_comments` WRITE;
/*!40000 ALTER TABLE `essentials_todo_comments` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_todo_comments` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_todos_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `essentials_todos_users` (
  `todo_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_todos_users` WRITE;
/*!40000 ALTER TABLE `essentials_todos_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_todos_users` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_user_allowance_and_deductions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `essentials_user_allowance_and_deductions` (
  `user_id` int(11) NOT NULL,
  `allowance_deduction_id` int(11) NOT NULL,
  KEY `essentials_user_allowance_and_deductions_user_id_index` (`user_id`),
  KEY `allow_deduct_index` (`allowance_deduction_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_user_allowance_and_deductions` WRITE;
/*!40000 ALTER TABLE `essentials_user_allowance_and_deductions` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_user_allowance_and_deductions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_user_sales_targets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `essentials_user_sales_targets` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `target_start` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `target_end` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `commission_percent` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_user_sales_targets` WRITE;
/*!40000 ALTER TABLE `essentials_user_sales_targets` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_user_sales_targets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_user_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `essentials_user_shifts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `essentials_shift_id` int(11) NOT NULL,
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_user_shifts_user_id_index` (`user_id`),
  KEY `essentials_user_shifts_essentials_shift_id_index` (`essentials_shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_user_shifts` WRITE;
/*!40000 ALTER TABLE `essentials_user_shifts` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_user_shifts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `expense_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `expense_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `code` varchar(191) DEFAULT NULL,
  `parent_id` int(11) DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `expense_categories_business_id_foreign` (`business_id`),
  CONSTRAINT `expense_categories_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `expense_categories` WRITE;
/*!40000 ALTER TABLE `expense_categories` DISABLE KEYS */;
INSERT INTO `expense_categories` VALUES (1,'Bills',1,NULL,NULL,NULL,'2024-12-15 11:54:00','2024-12-15 11:54:00');
/*!40000 ALTER TABLE `expense_categories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `group_sub_taxes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `group_sub_taxes` (
  `group_tax_id` int(10) unsigned NOT NULL,
  `tax_id` int(10) unsigned NOT NULL,
  KEY `group_sub_taxes_group_tax_id_foreign` (`group_tax_id`),
  KEY `group_sub_taxes_tax_id_foreign` (`tax_id`),
  CONSTRAINT `group_sub_taxes_group_tax_id_foreign` FOREIGN KEY (`group_tax_id`) REFERENCES `tax_rates` (`id`) ON DELETE CASCADE,
  CONSTRAINT `group_sub_taxes_tax_id_foreign` FOREIGN KEY (`tax_id`) REFERENCES `tax_rates` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `group_sub_taxes` WRITE;
/*!40000 ALTER TABLE `group_sub_taxes` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_sub_taxes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `invoice_layouts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `invoice_layouts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `header_text` text DEFAULT NULL,
  `invoice_no_prefix` varchar(191) DEFAULT NULL,
  `quotation_no_prefix` varchar(191) DEFAULT NULL,
  `invoice_heading` varchar(191) DEFAULT NULL,
  `sub_heading_line1` varchar(191) DEFAULT NULL,
  `sub_heading_line2` varchar(191) DEFAULT NULL,
  `sub_heading_line3` varchar(191) DEFAULT NULL,
  `sub_heading_line4` varchar(191) DEFAULT NULL,
  `sub_heading_line5` varchar(191) DEFAULT NULL,
  `invoice_heading_not_paid` varchar(191) DEFAULT NULL,
  `invoice_heading_paid` varchar(191) DEFAULT NULL,
  `quotation_heading` varchar(191) DEFAULT NULL,
  `sub_total_label` varchar(191) DEFAULT NULL,
  `discount_label` varchar(191) DEFAULT NULL,
  `tax_label` varchar(191) DEFAULT NULL,
  `total_label` varchar(191) DEFAULT NULL,
  `round_off_label` varchar(191) DEFAULT NULL,
  `total_due_label` varchar(191) DEFAULT NULL,
  `paid_label` varchar(191) DEFAULT NULL,
  `show_client_id` tinyint(1) NOT NULL DEFAULT 0,
  `client_id_label` varchar(191) DEFAULT NULL,
  `client_tax_label` varchar(191) DEFAULT NULL,
  `date_label` varchar(191) DEFAULT NULL,
  `date_time_format` varchar(191) DEFAULT NULL,
  `show_time` tinyint(1) NOT NULL DEFAULT 1,
  `show_brand` tinyint(1) NOT NULL DEFAULT 0,
  `show_sku` tinyint(1) NOT NULL DEFAULT 1,
  `show_cat_code` tinyint(1) NOT NULL DEFAULT 1,
  `show_multi_unit_details` tinyint(1) NOT NULL DEFAULT 0,
  `show_expiry` tinyint(1) NOT NULL DEFAULT 0,
  `show_lot` tinyint(1) NOT NULL DEFAULT 0,
  `show_image` tinyint(1) NOT NULL DEFAULT 0,
  `show_sale_description` tinyint(1) NOT NULL DEFAULT 0,
  `sales_person_label` varchar(191) DEFAULT NULL,
  `show_sales_person` tinyint(1) NOT NULL DEFAULT 0,
  `table_product_label` varchar(191) DEFAULT NULL,
  `table_qty_label` varchar(191) DEFAULT NULL,
  `table_unit_price_label` varchar(191) DEFAULT NULL,
  `table_subtotal_label` varchar(191) DEFAULT NULL,
  `cat_code_label` varchar(191) DEFAULT NULL,
  `logo` varchar(191) DEFAULT NULL,
  `show_logo` tinyint(1) NOT NULL DEFAULT 0,
  `show_business_name` tinyint(1) NOT NULL DEFAULT 0,
  `show_location_name` tinyint(1) NOT NULL DEFAULT 1,
  `show_landmark` tinyint(1) NOT NULL DEFAULT 1,
  `show_city` tinyint(1) NOT NULL DEFAULT 1,
  `show_state` tinyint(1) NOT NULL DEFAULT 1,
  `show_zip_code` tinyint(1) NOT NULL DEFAULT 1,
  `show_country` tinyint(1) NOT NULL DEFAULT 1,
  `show_mobile_number` tinyint(1) NOT NULL DEFAULT 1,
  `show_alternate_number` tinyint(1) NOT NULL DEFAULT 0,
  `show_email` tinyint(1) NOT NULL DEFAULT 0,
  `show_tax_1` tinyint(1) NOT NULL DEFAULT 1,
  `show_tax_2` tinyint(1) NOT NULL DEFAULT 0,
  `show_barcode` tinyint(1) NOT NULL DEFAULT 0,
  `show_payments` tinyint(1) NOT NULL DEFAULT 0,
  `show_customer` tinyint(1) NOT NULL DEFAULT 0,
  `customer_label` varchar(191) DEFAULT NULL,
  `commission_agent_label` varchar(191) DEFAULT NULL,
  `show_commission_agent` tinyint(1) NOT NULL DEFAULT 0,
  `show_reward_point` tinyint(1) NOT NULL DEFAULT 0,
  `highlight_color` varchar(10) DEFAULT NULL,
  `footer_text` text DEFAULT NULL,
  `module_info` text DEFAULT NULL,
  `common_settings` text DEFAULT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  `business_id` int(10) unsigned NOT NULL,
  `show_letter_head` tinyint(1) NOT NULL DEFAULT 0,
  `letter_head` varchar(191) DEFAULT NULL,
  `show_qr_code` tinyint(1) NOT NULL DEFAULT 0,
  `qr_code_fields` text DEFAULT NULL,
  `design` varchar(190) DEFAULT 'classic',
  `cn_heading` varchar(191) DEFAULT NULL COMMENT 'cn = credit note',
  `cn_no_label` varchar(191) DEFAULT NULL,
  `cn_amount_label` varchar(191) DEFAULT NULL,
  `table_tax_headings` text DEFAULT NULL,
  `show_previous_bal` tinyint(1) NOT NULL DEFAULT 0,
  `prev_bal_label` varchar(191) DEFAULT NULL,
  `change_return_label` varchar(191) DEFAULT NULL,
  `product_custom_fields` text DEFAULT NULL,
  `contact_custom_fields` text DEFAULT NULL,
  `location_custom_fields` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `invoice_layouts_business_id_foreign` (`business_id`),
  CONSTRAINT `invoice_layouts_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `invoice_layouts` WRITE;
/*!40000 ALTER TABLE `invoice_layouts` DISABLE KEYS */;
INSERT INTO `invoice_layouts` VALUES (1,'Default',NULL,'Invoice No.',NULL,'Invoice',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Subtotal','Discount','Tax','Total',NULL,'Total Due','Total Paid',0,NULL,NULL,'Date',NULL,1,0,1,1,0,0,0,0,0,NULL,0,'Product','Quantity','Unit Price','Subtotal',NULL,'1733285225_1731317912_1731045386_1730879404_Asset 6@2x (1).png',1,0,1,1,1,1,1,1,1,0,0,1,0,0,1,1,'Customer',NULL,0,0,'#000000',NULL,NULL,'{\"proforma_heading\":null,\"sales_order_heading\":null,\"due_date_label\":\"Due Date:\",\"show_due_date\":\"1\",\"show_multi_unit_details\":\"1\",\"show_only_sold_unit\":\"1\",\"show_serial_number\":\"1\",\"total_quantity_label\":null,\"item_discount_label\":null,\"discounted_unit_price_label\":null,\"total_items_label\":null,\"num_to_word_format\":\"international\",\"tax_summary_label\":null}',1,1,0,NULL,0,NULL,'classic',NULL,NULL,NULL,NULL,0,NULL,NULL,'[\"product_custom_field1\"]',NULL,NULL,'2024-10-25 16:39:24','2024-12-13 22:28:57');
/*!40000 ALTER TABLE `invoice_layouts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `invoice_schemes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `invoice_schemes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) NOT NULL,
  `scheme_type` enum('blank','year') NOT NULL,
  `number_type` varchar(100) NOT NULL DEFAULT 'sequential',
  `prefix` varchar(191) DEFAULT NULL,
  `start_number` int(11) DEFAULT NULL,
  `invoice_count` int(11) NOT NULL DEFAULT 0,
  `total_digits` int(11) DEFAULT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `invoice_schemes_business_id_foreign` (`business_id`),
  KEY `invoice_schemes_scheme_type_index` (`scheme_type`),
  KEY `invoice_schemes_number_type_index` (`number_type`),
  CONSTRAINT `invoice_schemes_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `invoice_schemes` WRITE;
/*!40000 ALTER TABLE `invoice_schemes` DISABLE KEYS */;
INSERT INTO `invoice_schemes` VALUES (1,1,'Default','blank','sequential','',1,67,4,1,'2024-10-25 16:39:24','2024-12-20 15:01:24');
/*!40000 ALTER TABLE `invoice_schemes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `media`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `media` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `file_name` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  `uploaded_by` int(11) DEFAULT NULL,
  `model_type` varchar(191) NOT NULL,
  `model_media_type` varchar(191) DEFAULT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `media_model_type_model_id_index` (`model_type`,`model_id`),
  KEY `media_business_id_index` (`business_id`),
  KEY `media_uploaded_by_index` (`uploaded_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `media` WRITE;
/*!40000 ALTER TABLE `media` DISABLE KEYS */;
/*!40000 ALTER TABLE `media` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `mfg_ingredient_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mfg_ingredient_groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `business_id` int(11) NOT NULL,
  `description` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `mfg_ingredient_groups` WRITE;
/*!40000 ALTER TABLE `mfg_ingredient_groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `mfg_ingredient_groups` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `mfg_recipe_ingredients`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mfg_recipe_ingredients` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mfg_recipe_id` int(10) unsigned NOT NULL,
  `variation_id` int(11) NOT NULL,
  `mfg_ingredient_group_id` int(11) DEFAULT NULL,
  `quantity` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `waste_percent` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `sub_unit_id` int(11) DEFAULT NULL,
  `sort_order` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mfg_recipe_ingredients_mfg_recipe_id_index` (`mfg_recipe_id`),
  KEY `mfg_recipe_ingredients_variation_id_index` (`variation_id`),
  KEY `mfg_recipe_ingredients_sub_unit_id_index` (`sub_unit_id`),
  CONSTRAINT `mfg_recipe_ingredients_mfg_recipe_id_foreign` FOREIGN KEY (`mfg_recipe_id`) REFERENCES `mfg_recipes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `mfg_recipe_ingredients` WRITE;
/*!40000 ALTER TABLE `mfg_recipe_ingredients` DISABLE KEYS */;
/*!40000 ALTER TABLE `mfg_recipe_ingredients` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `mfg_recipes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mfg_recipes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` int(11) NOT NULL,
  `variation_id` int(11) NOT NULL,
  `instructions` text DEFAULT NULL,
  `waste_percent` decimal(10,2) NOT NULL DEFAULT 0.00,
  `ingredients_cost` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `extra_cost` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `production_cost_type` varchar(191) DEFAULT 'percentage',
  `total_quantity` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `final_price` decimal(22,4) NOT NULL,
  `sub_unit_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mfg_recipes_product_id_index` (`product_id`),
  KEY `mfg_recipes_variation_id_index` (`variation_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `mfg_recipes` WRITE;
/*!40000 ALTER TABLE `mfg_recipes` DISABLE KEYS */;
/*!40000 ALTER TABLE `mfg_recipes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `migrations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(191) NOT NULL,
  `batch` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=400 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `migrations` WRITE;
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
INSERT INTO `migrations` VALUES (1,'2014_10_12_000000_create_users_table',1),(2,'2014_10_12_100000_create_password_resets_table',1),(3,'2016_06_01_000001_create_oauth_auth_codes_table',1),(4,'2016_06_01_000002_create_oauth_access_tokens_table',1),(5,'2016_06_01_000003_create_oauth_refresh_tokens_table',1),(6,'2016_06_01_000004_create_oauth_clients_table',1),(7,'2016_06_01_000005_create_oauth_personal_access_clients_table',1),(8,'2017_07_05_071953_create_currencies_table',1),(9,'2017_07_05_073658_create_business_table',1),(10,'2017_07_22_075923_add_business_id_users_table',1),(11,'2017_07_23_113209_create_brands_table',1),(12,'2017_07_26_083429_create_permission_tables',1),(13,'2017_07_26_110000_create_tax_rates_table',1),(14,'2017_07_26_122313_create_units_table',1),(15,'2017_07_27_075706_create_contacts_table',1),(16,'2017_08_04_071038_create_categories_table',1),(17,'2017_08_08_115903_create_products_table',1),(18,'2017_08_09_061616_create_variation_templates_table',1),(19,'2017_08_09_061638_create_variation_value_templates_table',1),(20,'2017_08_10_061146_create_product_variations_table',1),(21,'2017_08_10_061216_create_variations_table',1),(22,'2017_08_19_054827_create_transactions_table',1),(23,'2017_08_31_073533_create_purchase_lines_table',1),(24,'2017_10_15_064638_create_transaction_payments_table',1),(25,'2017_10_31_065621_add_default_sales_tax_to_business_table',1),(26,'2017_11_20_051930_create_table_group_sub_taxes',1),(27,'2017_11_20_063603_create_transaction_sell_lines',1),(28,'2017_11_21_064540_create_barcodes_table',1),(29,'2017_11_23_181237_create_invoice_schemes_table',1),(30,'2017_12_25_122822_create_business_locations_table',1),(31,'2017_12_25_160253_add_location_id_to_transactions_table',1),(32,'2017_12_25_163227_create_variation_location_details_table',1),(33,'2018_01_04_115627_create_sessions_table',1),(34,'2018_01_05_112817_create_invoice_layouts_table',1),(35,'2018_01_06_112303_add_invoice_scheme_id_and_invoice_layout_id_to_business_locations',1),(36,'2018_01_08_104124_create_expense_categories_table',1),(37,'2018_01_08_123327_modify_transactions_table_for_expenses',1),(38,'2018_01_09_111005_modify_payment_status_in_transactions_table',1),(39,'2018_01_09_111109_add_paid_on_column_to_transaction_payments_table',1),(40,'2018_01_25_172439_add_printer_related_fields_to_business_locations_table',1),(41,'2018_01_27_184322_create_printers_table',1),(42,'2018_01_30_181442_create_cash_registers_table',1),(43,'2018_01_31_125836_create_cash_register_transactions_table',1),(44,'2018_02_07_173326_modify_business_table',1),(45,'2018_02_08_105425_add_enable_product_expiry_column_to_business_table',1),(46,'2018_02_08_111027_add_expiry_period_and_expiry_period_type_columns_to_products_table',1),(47,'2018_02_08_131118_add_mfg_date_and_exp_date_purchase_lines_table',1),(48,'2018_02_08_155348_add_exchange_rate_to_transactions_table',1),(49,'2018_02_09_124945_modify_transaction_payments_table_for_contact_payments',1),(50,'2018_02_12_113640_create_transaction_sell_lines_purchase_lines_table',1),(51,'2018_02_12_114605_add_quantity_sold_in_purchase_lines_table',1),(52,'2018_02_13_183323_alter_decimal_fields_size',1),(53,'2018_02_14_161928_add_transaction_edit_days_to_business_table',1),(54,'2018_02_15_161032_add_document_column_to_transactions_table',1),(55,'2018_02_17_124709_add_more_options_to_invoice_layouts',1),(56,'2018_02_19_111517_add_keyboard_shortcut_column_to_business_table',1),(57,'2018_02_19_121537_stock_adjustment_move_to_transaction_table',1),(58,'2018_02_20_165505_add_is_direct_sale_column_to_transactions_table',1),(59,'2018_02_21_105329_create_system_table',1),(60,'2018_02_23_100549_version_1_2',1),(61,'2018_02_23_125648_add_enable_editing_sp_from_purchase_column_to_business_table',1),(62,'2018_02_26_103612_add_sales_commission_agent_column_to_business_table',1),(63,'2018_02_26_130519_modify_users_table_for_sales_cmmsn_agnt',1),(64,'2018_02_26_134500_add_commission_agent_to_transactions_table',1),(65,'2018_02_27_121422_add_item_addition_method_to_business_table',1),(66,'2018_02_27_170232_modify_transactions_table_for_stock_transfer',1),(67,'2018_03_05_153510_add_enable_inline_tax_column_to_business_table',1),(68,'2018_03_06_210206_modify_product_barcode_types',1),(69,'2018_03_13_181541_add_expiry_type_to_business_table',1),(70,'2018_03_16_113446_product_expiry_setting_for_business',1),(71,'2018_03_19_113601_add_business_settings_options',1),(72,'2018_03_26_125334_add_pos_settings_to_business_table',1),(73,'2018_03_26_165350_create_customer_groups_table',1),(74,'2018_03_27_122720_customer_group_related_changes_in_tables',1),(75,'2018_03_29_110138_change_tax_field_to_nullable_in_business_table',1),(76,'2018_03_29_115502_add_changes_for_sr_number_in_products_and_sale_lines_table',1),(77,'2018_03_29_134340_add_inline_discount_fields_in_purchase_lines',1),(78,'2018_03_31_140921_update_transactions_table_exchange_rate',1),(79,'2018_04_03_103037_add_contact_id_to_contacts_table',1),(80,'2018_04_03_122709_add_changes_to_invoice_layouts_table',1),(81,'2018_04_09_135320_change_exchage_rate_size_in_business_table',1),(82,'2018_04_17_123122_add_lot_number_to_business',1),(83,'2018_04_17_160845_add_product_racks_table',1),(84,'2018_04_20_182015_create_res_tables_table',1),(85,'2018_04_24_105246_restaurant_fields_in_transaction_table',1),(86,'2018_04_24_114149_add_enabled_modules_business_table',1),(87,'2018_04_24_133704_add_modules_fields_in_invoice_layout_table',1),(88,'2018_04_27_132653_quotation_related_change',1),(89,'2018_05_02_104439_add_date_format_and_time_format_to_business',1),(90,'2018_05_02_111939_add_sell_return_to_transaction_payments',1),(91,'2018_05_14_114027_add_rows_positions_for_products',1),(92,'2018_05_14_125223_add_weight_to_products_table',1),(93,'2018_05_14_164754_add_opening_stock_permission',1),(94,'2018_05_15_134729_add_design_to_invoice_layouts',1),(95,'2018_05_16_183307_add_tax_fields_invoice_layout',1),(96,'2018_05_18_191956_add_sell_return_to_transaction_table',1),(97,'2018_05_21_131349_add_custom_fileds_to_contacts_table',1),(98,'2018_05_21_131607_invoice_layout_fields_for_sell_return',1),(99,'2018_05_21_131949_add_custom_fileds_and_website_to_business_locations_table',1),(100,'2018_05_22_123527_create_reference_counts_table',1),(101,'2018_05_22_154540_add_ref_no_prefixes_column_to_business_table',1),(102,'2018_05_24_132620_add_ref_no_column_to_transaction_payments_table',1),(103,'2018_05_24_161026_add_location_id_column_to_business_location_table',1),(104,'2018_05_25_180603_create_modifiers_related_table',1),(105,'2018_05_29_121714_add_purchase_line_id_to_stock_adjustment_line_table',1),(106,'2018_05_31_114645_add_res_order_status_column_to_transactions_table',1),(107,'2018_06_05_103530_rename_purchase_line_id_in_stock_adjustment_lines_table',1),(108,'2018_06_05_111905_modify_products_table_for_modifiers',1),(109,'2018_06_06_110524_add_parent_sell_line_id_column_to_transaction_sell_lines_table',1),(110,'2018_06_07_152443_add_is_service_staff_to_roles_table',1),(111,'2018_06_07_182258_add_image_field_to_products_table',1),(112,'2018_06_13_133705_create_bookings_table',1),(113,'2018_06_15_173636_add_email_column_to_contacts_table',1),(114,'2018_06_27_182835_add_superadmin_related_fields_business',1),(115,'2018_07_10_101913_add_custom_fields_to_products_table',1),(116,'2018_07_17_103434_add_sales_person_name_label_to_invoice_layouts_table',1),(117,'2018_07_17_163920_add_theme_skin_color_column_to_business_table',1),(118,'2018_07_24_160319_add_lot_no_line_id_to_transaction_sell_lines_table',1),(119,'2018_07_25_110004_add_show_expiry_and_show_lot_colums_to_invoice_layouts_table',1),(120,'2018_07_25_172004_add_discount_columns_to_transaction_sell_lines_table',1),(121,'2018_07_26_124720_change_design_column_type_in_invoice_layouts_table',1),(122,'2018_07_26_170424_add_unit_price_before_discount_column_to_transaction_sell_line_table',1),(123,'2018_07_28_103614_add_credit_limit_column_to_contacts_table',1),(124,'2018_08_08_110755_add_new_payment_methods_to_transaction_payments_table',1),(125,'2018_08_08_122225_modify_cash_register_transactions_table_for_new_payment_methods',1),(126,'2018_08_14_104036_add_opening_balance_type_to_transactions_table',1),(127,'2018_09_04_155900_create_accounts_table',1),(128,'2018_09_06_114438_create_selling_price_groups_table',1),(129,'2018_09_06_154057_create_variation_group_prices_table',1),(130,'2018_09_07_102413_add_permission_to_access_default_selling_price',1),(131,'2018_09_07_134858_add_selling_price_group_id_to_transactions_table',1),(132,'2018_09_10_112448_update_product_type_to_single_if_null_in_products_table',1),(133,'2018_09_10_152703_create_account_transactions_table',1),(134,'2018_09_10_173656_add_account_id_column_to_transaction_payments_table',1),(135,'2018_09_19_123914_create_notification_templates_table',1),(136,'2018_09_22_110504_add_sms_and_email_settings_columns_to_business_table',1),(137,'2018_09_24_134942_add_lot_no_line_id_to_stock_adjustment_lines_table',1),(138,'2018_09_26_105557_add_transaction_payments_for_existing_expenses',1),(139,'2018_09_27_111609_modify_transactions_table_for_purchase_return',1),(140,'2018_09_27_131154_add_quantity_returned_column_to_purchase_lines_table',1),(141,'2018_10_02_131401_add_return_quantity_column_to_transaction_sell_lines_table',1),(142,'2018_10_03_104918_add_qty_returned_column_to_transaction_sell_lines_purchase_lines_table',1),(143,'2018_10_03_185947_add_default_notification_templates_to_database',1),(144,'2018_10_09_153105_add_business_id_to_transaction_payments_table',1),(145,'2018_10_16_135229_create_permission_for_sells_and_purchase',1),(146,'2018_10_22_114441_add_columns_for_variable_product_modifications',1),(147,'2018_10_22_134428_modify_variable_product_data',1),(148,'2018_10_30_181558_add_table_tax_headings_to_invoice_layout',1),(149,'2018_10_31_122619_add_pay_terms_field_transactions_table',1),(150,'2018_10_31_161328_add_new_permissions_for_pos_screen',1),(151,'2018_10_31_174752_add_access_selected_contacts_only_to_users_table',1),(152,'2018_10_31_175627_add_user_contact_access',1),(153,'2018_10_31_180559_add_auto_send_sms_column_to_notification_templates_table',1),(154,'2018_11_02_171949_change_card_type_column_to_varchar_in_transaction_payments_table',1),(155,'2018_11_08_105621_add_role_permissions',1),(156,'2018_11_26_114135_add_is_suspend_column_to_transactions_table',1),(157,'2018_11_28_104410_modify_units_table_for_multi_unit',1),(158,'2018_11_28_170952_add_sub_unit_id_to_purchase_lines_and_sell_lines',1),(159,'2018_11_29_115918_add_primary_key_in_system_table',1),(160,'2018_12_03_185546_add_product_description_column_to_products_table',1),(161,'2018_12_06_114937_modify_system_table_and_users_table',1),(162,'2018_12_13_160007_add_custom_fields_display_options_to_invoice_layouts_table',1),(163,'2018_12_14_103307_modify_system_table',1),(164,'2018_12_18_133837_add_prev_balance_due_columns_to_invoice_layouts_table',1),(165,'2018_12_18_170656_add_invoice_token_column_to_transaction_table',1),(166,'2018_12_20_133639_add_date_time_format_column_to_invoice_layouts_table',1),(167,'2018_12_21_120659_add_recurring_invoice_fields_to_transactions_table',1),(168,'2018_12_24_154933_create_notifications_table',1),(169,'2019_01_08_112015_add_document_column_to_transaction_payments_table',1),(170,'2019_01_10_124645_add_account_permission',1),(171,'2019_01_16_125825_add_subscription_no_column_to_transactions_table',1),(172,'2019_01_28_111647_add_order_addresses_column_to_transactions_table',1),(173,'2019_02_13_173821_add_is_inactive_column_to_products_table',1),(174,'2019_02_19_103118_create_discounts_table',1),(175,'2019_02_21_120324_add_discount_id_column_to_transaction_sell_lines_table',1),(176,'2019_02_21_134324_add_permission_for_discount',1),(177,'2019_03_04_170832_add_service_staff_columns_to_transaction_sell_lines_table',1),(178,'2019_03_09_102425_add_sub_type_column_to_transactions_table',1),(179,'2019_03_09_124457_add_indexing_transaction_sell_lines_purchase_lines_table',1),(180,'2019_03_12_120336_create_activity_log_table',1),(181,'2019_03_15_132925_create_media_table',1),(182,'2019_05_08_130339_add_indexing_to_parent_id_in_transaction_payments_table',1),(183,'2019_05_10_132311_add_missing_column_indexing',1),(184,'2019_05_14_091812_add_show_image_column_to_invoice_layouts_table',1),(185,'2019_05_25_104922_add_view_purchase_price_permission',1),(186,'2019_06_17_103515_add_profile_informations_columns_to_users_table',1),(187,'2019_06_18_135524_add_permission_to_view_own_sales_only',1),(188,'2019_06_19_112058_add_database_changes_for_reward_points',1),(189,'2019_06_28_133732_change_type_column_to_string_in_transactions_table',1),(190,'2019_07_13_111420_add_is_created_from_api_column_to_transactions_table',1),(191,'2019_07_15_165136_add_fields_for_combo_product',1),(192,'2019_07_19_103446_add_mfg_quantity_used_column_to_purchase_lines_table',1),(193,'2019_07_22_152649_add_not_for_selling_in_product_table',1),(194,'2019_07_29_185351_add_show_reward_point_column_to_invoice_layouts_table',1),(195,'2019_08_08_162302_add_sub_units_related_fields',1),(196,'2019_08_26_133419_update_price_fields_decimal_point',1),(197,'2019_09_02_160054_remove_location_permissions_from_roles',1),(198,'2019_09_03_185259_add_permission_for_pos_screen',1),(199,'2019_09_04_163141_add_location_id_to_cash_registers_table',1),(200,'2019_09_04_184008_create_types_of_services_table',1),(201,'2019_09_06_131445_add_types_of_service_fields_to_transactions_table',1),(202,'2019_09_09_134810_add_default_selling_price_group_id_column_to_business_locations_table',1),(203,'2019_09_12_105616_create_product_locations_table',1),(204,'2019_09_17_122522_add_custom_labels_column_to_business_table',1),(205,'2019_09_18_164319_add_shipping_fields_to_transactions_table',1),(206,'2019_09_19_170927_close_all_active_registers',1),(207,'2019_09_23_161906_add_media_description_cloumn_to_media_table',1),(208,'2019_10_18_155633_create_account_types_table',1),(209,'2019_10_22_163335_add_common_settings_column_to_business_table',1),(210,'2019_10_29_132521_add_update_purchase_status_permission',1),(211,'2019_11_09_110522_add_indexing_to_lot_number',1),(212,'2019_11_19_170824_add_is_active_column_to_business_locations_table',1),(213,'2019_11_21_162913_change_quantity_field_types_to_decimal',1),(214,'2019_11_25_160340_modify_categories_table_for_polymerphic_relationship',1),(215,'2019_12_02_105025_create_warranties_table',1),(216,'2019_12_03_180342_add_common_settings_field_to_invoice_layouts_table',1),(217,'2019_12_05_183955_add_more_fields_to_users_table',1),(218,'2019_12_06_174904_add_change_return_label_column_to_invoice_layouts_table',1),(219,'2019_12_11_121307_add_draft_and_quotation_list_permissions',1),(220,'2019_12_12_180126_copy_expense_total_to_total_before_tax',1),(221,'2019_12_19_181412_make_alert_quantity_field_nullable_on_products_table',1),(222,'2019_12_25_173413_create_dashboard_configurations_table',1),(223,'2020_01_08_133506_create_document_and_notes_table',1),(224,'2020_01_09_113252_add_cc_bcc_column_to_notification_templates_table',1),(225,'2020_01_16_174818_add_round_off_amount_field_to_transactions_table',1),(226,'2020_01_28_162345_add_weighing_scale_settings_in_business_settings_table',1),(227,'2020_02_18_172447_add_import_fields_to_transactions_table',1),(228,'2020_03_13_135844_add_is_active_column_to_selling_price_groups_table',1),(229,'2020_03_16_115449_add_contact_status_field_to_contacts_table',1),(230,'2020_03_26_124736_add_allow_login_column_in_users_table',1),(231,'2020_04_13_154150_add_feature_products_column_to_business_loactions',1),(232,'2020_04_15_151802_add_user_type_to_users_table',1),(233,'2020_04_22_153905_add_subscription_repeat_on_column_to_transactions_table',1),(234,'2020_04_28_111436_add_shipping_address_to_contacts_table',1),(235,'2020_06_01_094654_add_max_sale_discount_column_to_users_table',1),(236,'2020_06_12_162245_modify_contacts_table',1),(237,'2020_06_22_103104_change_recur_interval_default_to_one',1),(238,'2020_07_09_174621_add_balance_field_to_contacts_table',1),(239,'2020_07_23_104933_change_status_column_to_varchar_in_transaction_table',1),(240,'2020_09_07_171059_change_completed_stock_transfer_status_to_final',1),(241,'2020_09_21_123224_modify_booking_status_column_in_bookings_table',1),(242,'2020_09_22_121639_create_discount_variations_table',1),(243,'2020_10_05_121550_modify_business_location_table_for_invoice_layout',1),(244,'2020_10_16_175726_set_status_as_received_for_opening_stock',1),(245,'2020_10_23_170823_add_for_group_tax_column_to_tax_rates_table',1),(246,'2020_11_04_130940_add_more_custom_fields_to_contacts_table',1),(247,'2020_11_10_152841_add_cash_register_permissions',1),(248,'2020_11_17_164041_modify_type_column_to_varchar_in_contacts_table',1),(249,'2020_12_18_181447_add_shipping_custom_fields_to_transactions_table',1),(250,'2020_12_22_164303_add_sub_status_column_to_transactions_table',1),(251,'2020_12_24_153050_add_custom_fields_to_transactions_table',1),(252,'2020_12_28_105403_add_whatsapp_text_column_to_notification_templates_table',1),(253,'2020_12_29_165925_add_model_document_type_to_media_table',1),(254,'2021_02_08_175632_add_contact_number_fields_to_users_table',1),(255,'2021_02_11_172217_add_indexing_for_multiple_columns',1),(256,'2021_02_23_122043_add_more_columns_to_customer_groups_table',1),(257,'2021_02_24_175551_add_print_invoice_permission_to_all_roles',1),(258,'2021_03_03_162021_add_purchase_order_columns_to_purchase_lines_and_transactions_table',1),(259,'2021_03_11_120229_add_sales_order_columns',1),(260,'2021_03_16_120705_add_business_id_to_activity_log_table',1),(261,'2021_03_16_153427_add_code_columns_to_business_table',1),(262,'2021_03_18_173308_add_account_details_column_to_accounts_table',1),(263,'2021_03_18_183119_add_prefer_payment_account_columns_to_transactions_table',1),(264,'2021_03_22_120810_add_more_types_of_service_custom_fields',1),(265,'2021_03_24_183132_add_shipping_export_custom_field_details_to_contacts_table',1),(266,'2021_03_25_170715_add_export_custom_fields_info_to_transactions_table',1),(267,'2021_04_15_063449_add_denominations_column_to_cash_registers_table',1),(268,'2021_05_22_083426_add_indexing_to_account_transactions_table',1),(269,'2021_07_08_065808_add_additional_expense_columns_to_transaction_table',1),(270,'2021_07_13_082918_add_qr_code_columns_to_invoice_layouts_table',1),(271,'2021_07_21_061615_add_fields_to_show_commission_agent_in_invoice_layout',1),(272,'2021_08_13_105549_add_crm_contact_id_to_users_table',1),(273,'2021_08_25_114932_add_payment_link_fields_to_transaction_payments_table',1),(274,'2021_09_01_063110_add_spg_column_to_discounts_table',1),(275,'2021_09_03_061528_modify_cash_register_transactions_table',1),(276,'2021_10_05_061658_add_source_column_to_transactions_table',1),(277,'2021_12_16_121851_add_parent_id_column_to_expense_categories_table',1),(278,'2022_04_14_075120_add_payment_type_column_to_transaction_payments_table',1),(279,'2022_04_21_083327_create_cash_denominations_table',1),(280,'2022_05_10_055307_add_delivery_date_column_to_transactions_table',1),(281,'2022_06_13_123135_add_currency_precision_and_quantity_precision_fields_to_business_table',1),(282,'2022_06_28_133342_add_secondary_unit_columns_to_products_sell_line_purchase_lines_tables',1),(283,'2022_07_13_114307_create_purchase_requisition_related_columns',1),(284,'2022_08_25_132707_add_service_staff_timer_fields_to_products_and_users_table',1),(285,'2023_01_28_114255_add_letter_head_column_to_invoice_layouts_table',1),(286,'2023_02_11_161510_add_event_column_to_activity_log_table',1),(287,'2023_02_11_161511_add_batch_uuid_column_to_activity_log_table',1),(288,'2023_03_02_170312_add_provider_to_oauth_clients_table',1),(289,'2023_03_21_122731_add_sale_invoice_scheme_id_business_table',1),(290,'2023_03_21_170446_add_number_type_to_invoice_scheme',1),(291,'2023_04_17_155216_add_custom_fields_to_products',1),(292,'2023_04_28_130247_add_price_type_to_group_price_table',1),(293,'2023_06_21_033923_add_delivery_person_in_transactions',1),(294,'2023_09_13_153555_add_service_staff_pin_columns_in_users',1),(295,'2023_09_15_154404_add_is_kitchen_order_in_transactions',1),(296,'2023_12_06_152840_add_contact_type_in_contacts',1),(299,'2024_10_27_202427_add_multiunit_fields_to_products_table',2),(300,'2024_10_27_202522_add_sell_unit_id_column_to_transaction_sell_lines_table',2),(301,'2024_10_27_204557_add_changes_to_invoice_layouts_table',3),(302,'2024_10_27_204624_add_multi_unit_fields_to_variations_table',3),(303,'2024_10_28_134436_add_inline_discount_in_purchase_lines_table',4),(304,'2024_10_29_091611_add_multi_unit_column_to_stock_adjustment_lines_table',5),(305,'2024_07_31_215407_add_enable_serial_number_field_to_products_table',6),(306,'2024_07_31_215536_create_serial_numbers_table',6),(307,'2024_07_31_220505_add_enable_serial_number_field_to_purchase_lines_table',6),(308,'2024_07_31_221130_create_service_warranties_table',6),(309,'2022_10_31_115725_create_accounting_account_types_table',7),(310,'2022_11_01_104108_create_accounting_accounts_table',7),(311,'2022_11_10_135427_create_accounts_transactions_table',7),(312,'2022_11_14_171948_create_accounting_acc_trans_mapping',7),(313,'2022_12_02_133536_create_accounting_budgets_table',7),(314,'2022_12_19_124743_add_accounting_settings_column_to_business_table',7),(315,'2022_12_26_182821_AddAccountingModuleVersionToSystemTable',7),(316,'2023_05_25_131005_add_default_map_transactions_fields',7),(317,'2020_03_19_130231_add_contact_id_to_users_table',8),(318,'2020_03_27_133605_create_schedules_table',8),(319,'2020_03_27_133628_create_schedule_users_table',8),(320,'2020_03_30_112834_create_schedule_logs_table',8),(321,'2020_04_02_182331_add_crm_module_version_to_system_table',8),(322,'2020_04_08_153231_modify_cloumn_in_contacts_table',8),(323,'2020_04_09_101052_create_lead_users_table',8),(324,'2020_04_16_114747_create_crm_campaigns_table',8),(325,'2021_01_07_155757_add_followup_additional_info_column_to_crm_schedules_table',8),(326,'2021_02_02_140021_add_additional_info_to_crm_campaigns_table',8),(327,'2021_02_02_173651_add_new_columns_to_contacts_table',8),(328,'2021_02_04_120439_create_call_logs_table',8),(329,'2021_02_08_172047_add_mobile_name_column_to_crm_call_logs_table',8),(330,'2021_02_16_190038_add_crm_module_indexing',8),(331,'2021_02_19_120846_create_crm_followup_invoices',8),(332,'2021_02_22_132125_add_follow_up_by_to_crm_schedules_table',8),(333,'2021_03_24_160736_add_department_and_designation_to_users_table',8),(334,'2021_06_15_152924_create_proposal_templates_table',8),(335,'2021_06_16_114448_add_recursive_fields_to_crm_schedules_table',8),(336,'2021_06_16_125740_create_proposals_table',8),(337,'2021_09_24_065738_add_crm_settings_column_to_business_table',8),(338,'2022_02_09_055012_create_crm_marketplaces_table',8),(339,'2022_02_17_113045_add_source_id_to_marketplace',8),(340,'2022_03_02_180929_add_followup_category_id',8),(341,'2022_05_26_061553_create_crm_contact_person_commissions_table',8),(342,'2022_06_06_073006_add_cc_and_bcc_columns_to_crm_proposals_table',8),(343,'2018_10_01_151252_create_documents_table',9),(344,'2018_10_02_151803_create_document_shares_table',9),(345,'2018_10_09_134558_create_reminders_table',9),(346,'2018_11_16_170756_create_to_dos_table',9),(347,'2019_02_22_120329_essentials_messages',9),(348,'2019_02_22_161513_add_message_permissions',9),(349,'2019_03_29_164339_add_essentials_version_to_system_table',9),(350,'2019_05_17_153306_create_essentials_leave_types_table',9),(351,'2019_05_17_175921_create_essentials_leaves_table',9),(352,'2019_05_21_154517_add_essentials_settings_columns_to_business_table',9),(353,'2019_05_21_181653_create_table_essentials_attendance',9),(354,'2019_05_30_110049_create_essentials_payrolls_table',9),(355,'2019_06_04_105723_create_essentials_holidays_table',9),(356,'2019_06_28_134217_add_payroll_columns_to_transactions_table',9),(357,'2019_07_15_114211_add_manufacturing_module_version_to_system_table',9),(358,'2019_07_15_114403_create_mfg_recipes_table',9),(359,'2019_07_18_180217_add_production_columns_to_transactions_table',9),(360,'2019_07_26_110753_add_manufacturing_settings_column_to_business_table',9),(361,'2019_07_26_170450_add_manufacturing_permissions',9),(362,'2019_08_08_110035_create_mfg_recipe_ingredients_table',9),(363,'2019_08_08_172837_add_recipe_add_edit_permissions',9),(364,'2019_08_12_114610_add_ingredient_waste_percent_columns',9),(365,'2019_08_26_103520_add_approve_leave_permission',9),(366,'2019_08_27_103724_create_essentials_allowance_and_deduction_table',9),(367,'2019_08_27_105236_create_essentials_user_allowances_and_deductions',9),(368,'2019_09_20_115906_add_more_columns_to_essentials_to_dos_table',9),(369,'2019_09_23_120439_create_essentials_todo_comments_table',9),(370,'2019_11_05_115136_create_ingredient_groups_table',9),(371,'2019_12_05_170724_add_hrm_columns_to_users_table',9),(372,'2019_12_09_105809_add_allowance_and_deductions_permission',9),(373,'2020_02_22_120303_add_column_to_mfg_recipe_ingredients_table',9),(374,'2020_03_28_152838_create_essentials_shift_table',9),(375,'2020_03_30_162029_create_user_shifts_table',9),(376,'2020_03_31_134558_add_shift_id_to_attendance_table',9),(377,'2020_08_19_103831_add_production_cost_type_to_recipe_and_transaction_table',9),(378,'2020_08_19_175842_add_asset_management_module_version_to_system_table',9),(379,'2020_08_20_114339_create_assets_table',9),(380,'2020_08_20_173031_create_asset_transactions_table',9),(381,'2020_08_21_180138_add_asset_settings_column_to_business_table',9),(382,'2020_11_05_105157_modify_todos_date_column_type',9),(383,'2020_11_11_174852_add_end_time_column_to_essentials_reminders_table',9),(384,'2020_11_26_170527_create_essentials_kb_table',9),(385,'2020_11_30_112615_create_essentials_kb_users_table',9),(386,'2021_02_12_185514_add_clock_in_location_to_essentials_attendances_table',9),(387,'2021_02_16_190203_add_essentials_module_indexing',9),(388,'2021_02_16_190302_add_manufacturing_module_indexing',9),(389,'2021_02_27_133448_add_columns_to_users_table',9),(390,'2021_03_04_174857_create_payroll_groups_table',9),(391,'2021_03_04_175025_create_payroll_group_transactions_table',9),(392,'2021_03_09_123914_add_auto_clockout_to_essentials_shifts',9),(393,'2021_04_07_154331_add_mfg_ingredient_group_id_to_transaction_sell_lines_table',9),(394,'2021_06_17_121451_add_location_id_to_table',9),(395,'2021_09_28_091541_create_essentials_user_sales_targets_table',9),(396,'2021_10_29_110841_create_asset_warranties_table',9),(397,'2022_03_26_062215_create_asset_maintenances_table',9),(398,'2022_05_11_070711_add_maintenance_note_column_to_asset_maintenances_table',9),(399,'2024_11_03_102559_add_discount_id_field_to_products_table',9);
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `model_has_permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `model_has_permissions` (
  `permission_id` int(10) unsigned NOT NULL,
  `model_type` varchar(191) NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`model_id`,`model_type`),
  KEY `model_has_permissions_model_type_model_id_index` (`model_type`,`model_id`),
  CONSTRAINT `model_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `model_has_permissions` WRITE;
/*!40000 ALTER TABLE `model_has_permissions` DISABLE KEYS */;
INSERT INTO `model_has_permissions` VALUES (99,'App\\User',2);
/*!40000 ALTER TABLE `model_has_permissions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `model_has_roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `model_has_roles` (
  `role_id` int(10) unsigned NOT NULL,
  `model_type` varchar(191) NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`role_id`,`model_id`,`model_type`),
  KEY `model_has_roles_model_type_model_id_index` (`model_type`,`model_id`),
  CONSTRAINT `model_has_roles_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `model_has_roles` WRITE;
/*!40000 ALTER TABLE `model_has_roles` DISABLE KEYS */;
INSERT INTO `model_has_roles` VALUES (1,'App\\User',1),(3,'App\\User',2);
/*!40000 ALTER TABLE `model_has_roles` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `notification_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `notification_templates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `template_for` varchar(191) NOT NULL,
  `email_body` text DEFAULT NULL,
  `sms_body` text DEFAULT NULL,
  `whatsapp_text` text DEFAULT NULL,
  `subject` varchar(191) DEFAULT NULL,
  `cc` varchar(191) DEFAULT NULL,
  `bcc` varchar(191) DEFAULT NULL,
  `auto_send` tinyint(1) NOT NULL DEFAULT 0,
  `auto_send_sms` tinyint(1) NOT NULL DEFAULT 0,
  `auto_send_wa_notif` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `notification_templates` WRITE;
/*!40000 ALTER TABLE `notification_templates` DISABLE KEYS */;
INSERT INTO `notification_templates` VALUES (1,1,'new_sale','<p>Dear {contact_name},</p>\n\n                    <p>Your invoice number is {invoice_number}<br />\n                    Total amount: {total_amount}<br />\n                    Paid amount: {received_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2024-10-25 16:39:24','2024-10-25 16:39:24'),(2,1,'payment_received','<p>Dear {contact_name},</p>\n\n                <p>We have received a payment of {received_amount}</p>\n\n                <p>{business_logo}</p>','Dear {contact_name}, We have received a payment of {received_amount}. {business_name}',NULL,'Payment Received, from {business_name}',NULL,NULL,0,0,0,'2024-10-25 16:39:24','2024-10-25 16:39:24'),(3,1,'payment_reminder','<p>Dear {contact_name},</p>\n\n                    <p>This is to remind you that you have pending payment of {due_amount}. Kindly pay it as soon as possible.</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, You have pending payment of {due_amount}. Kindly pay it as soon as possible. {business_name}',NULL,'Payment Reminder, from {business_name}',NULL,NULL,0,0,0,'2024-10-25 16:39:24','2024-10-25 16:39:24'),(4,1,'new_booking','<p>Dear {contact_name},</p>\n\n                    <p>Your booking is confirmed</p>\n\n                    <p>Date: {start_time} to {end_time}</p>\n\n                    <p>Table: {table}</p>\n\n                    <p>Location: {location}</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, Your booking is confirmed. Date: {start_time} to {end_time}, Table: {table}, Location: {location}',NULL,'Booking Confirmed - {business_name}',NULL,NULL,0,0,0,'2024-10-25 16:39:24','2024-10-25 16:39:24'),(5,1,'new_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','Dear {contact_name}, We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible. {business_name}',NULL,'New Order, from {business_name}',NULL,NULL,0,0,0,'2024-10-25 16:39:24','2024-10-25 16:39:24'),(6,1,'payment_paid','<p>Dear {contact_name},</p>\n\n                    <p>We have paid amount {paid_amount} again invoice number {order_ref_number}.<br />\n                    Kindly note it down.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have paid amount {paid_amount} again invoice number {order_ref_number}.\n                    Kindly note it down. {business_name}',NULL,'Payment Paid, from {business_name}',NULL,NULL,0,0,0,'2024-10-25 16:39:24','2024-10-25 16:39:24'),(7,1,'items_received','<p>Dear {contact_name},</p>\n\n                    <p>We have received all items from invoice reference number {order_ref_number}. Thank you for processing it.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have received all items from invoice reference number {order_ref_number}. Thank you for processing it. {business_name}',NULL,'Items received, from {business_name}',NULL,NULL,0,0,0,'2024-10-25 16:39:24','2024-10-25 16:39:24'),(8,1,'items_pending','<p>Dear {contact_name},<br />\n                    This is to remind you that we have not yet received some items from invoice reference number {order_ref_number}. Please process it as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','This is to remind you that we have not yet received some items from invoice reference number {order_ref_number} . Please process it as soon as possible.{business_name}',NULL,'Items Pending, from {business_name}',NULL,NULL,0,0,0,'2024-10-25 16:39:24','2024-10-25 16:39:24'),(9,1,'new_quotation','<p>Dear {contact_name},</p>\n\n                    <p>Your quotation number is {invoice_number}<br />\n                    Total amount: {total_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2024-10-25 16:39:24','2024-10-25 16:39:24'),(10,1,'purchase_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new purchase order with reference number {order_ref_number}. The respective invoice is attached here with.</p>\n\n                    <p>{business_logo}</p>','We have a new purchase order with reference number {order_ref_number}. {business_name}',NULL,'New Purchase Order, from {business_name}',NULL,NULL,0,0,0,'2024-10-25 16:39:24','2024-10-25 16:39:24');
/*!40000 ALTER TABLE `notification_templates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `notifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `notifications` (
  `id` char(36) NOT NULL,
  `type` varchar(191) NOT NULL,
  `notifiable_type` varchar(191) NOT NULL,
  `notifiable_id` bigint(20) unsigned NOT NULL,
  `data` text NOT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `notifications_notifiable_type_notifiable_id_index` (`notifiable_type`,`notifiable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `notifications` WRITE;
/*!40000 ALTER TABLE `notifications` DISABLE KEYS */;
/*!40000 ALTER TABLE `notifications` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_access_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oauth_access_tokens` (
  `id` varchar(100) NOT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `client_id` int(10) unsigned NOT NULL,
  `name` varchar(191) DEFAULT NULL,
  `scopes` text DEFAULT NULL,
  `revoked` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_access_tokens_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_access_tokens` WRITE;
/*!40000 ALTER TABLE `oauth_access_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_access_tokens` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_auth_codes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oauth_auth_codes` (
  `id` varchar(100) NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `client_id` int(10) unsigned NOT NULL,
  `scopes` text DEFAULT NULL,
  `revoked` tinyint(1) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_auth_codes` WRITE;
/*!40000 ALTER TABLE `oauth_auth_codes` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_auth_codes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_clients`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oauth_clients` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) DEFAULT NULL,
  `name` varchar(191) NOT NULL,
  `secret` varchar(100) NOT NULL,
  `provider` varchar(191) DEFAULT NULL,
  `redirect` text NOT NULL,
  `personal_access_client` tinyint(1) NOT NULL,
  `password_client` tinyint(1) NOT NULL,
  `revoked` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_clients_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_clients` WRITE;
/*!40000 ALTER TABLE `oauth_clients` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_clients` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_personal_access_clients`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oauth_personal_access_clients` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `client_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_personal_access_clients_client_id_index` (`client_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_personal_access_clients` WRITE;
/*!40000 ALTER TABLE `oauth_personal_access_clients` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_personal_access_clients` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_refresh_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oauth_refresh_tokens` (
  `id` varchar(100) NOT NULL,
  `access_token_id` varchar(100) NOT NULL,
  `revoked` tinyint(1) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_refresh_tokens_access_token_id_index` (`access_token_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_refresh_tokens` WRITE;
/*!40000 ALTER TABLE `oauth_refresh_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_refresh_tokens` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `password_resets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `password_resets` (
  `email` varchar(191) NOT NULL,
  `token` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `password_resets_email_index` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `password_resets` WRITE;
/*!40000 ALTER TABLE `password_resets` DISABLE KEYS */;
/*!40000 ALTER TABLE `password_resets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `permissions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `guard_name` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=130 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `permissions` WRITE;
/*!40000 ALTER TABLE `permissions` DISABLE KEYS */;
INSERT INTO `permissions` VALUES (1,'profit_loss_report.view','web','2024-10-25 16:35:19',NULL),(2,'direct_sell.access','web','2024-10-25 16:35:19',NULL),(3,'product.opening_stock','web','2024-10-25 16:35:22','2024-10-25 16:35:22'),(4,'crud_all_bookings','web','2024-10-25 16:35:23','2024-10-25 16:35:23'),(5,'crud_own_bookings','web','2024-10-25 16:35:23','2024-10-25 16:35:23'),(6,'access_default_selling_price','web','2024-10-25 16:35:24','2024-10-25 16:35:24'),(7,'purchase.payments','web','2024-10-25 16:35:24','2024-10-25 16:35:24'),(8,'sell.payments','web','2024-10-25 16:35:24','2024-10-25 16:35:24'),(9,'edit_product_price_from_sale_screen','web','2024-10-25 16:35:25','2024-10-25 16:35:25'),(10,'edit_product_discount_from_sale_screen','web','2024-10-25 16:35:25','2024-10-25 16:35:25'),(11,'roles.view','web','2024-10-25 16:35:25','2024-10-25 16:35:25'),(12,'roles.create','web','2024-10-25 16:35:25','2024-10-25 16:35:25'),(13,'roles.update','web','2024-10-25 16:35:25','2024-10-25 16:35:25'),(14,'roles.delete','web','2024-10-25 16:35:25','2024-10-25 16:35:25'),(15,'account.access','web','2024-10-25 16:35:25','2024-10-25 16:35:25'),(16,'discount.access','web','2024-10-25 16:35:26','2024-10-25 16:35:26'),(17,'view_purchase_price','web','2024-10-25 16:35:26','2024-10-25 16:35:26'),(18,'view_own_sell_only','web','2024-10-25 16:35:26','2024-10-25 16:35:26'),(19,'edit_product_discount_from_pos_screen','web','2024-10-25 16:35:27','2024-10-25 16:35:27'),(20,'edit_product_price_from_pos_screen','web','2024-10-25 16:35:27','2024-10-25 16:35:27'),(21,'access_shipping','web','2024-10-25 16:35:28','2024-10-25 16:35:28'),(22,'purchase.update_status','web','2024-10-25 16:35:28','2024-10-25 16:35:28'),(23,'list_drafts','web','2024-10-25 16:35:29','2024-10-25 16:35:29'),(24,'list_quotations','web','2024-10-25 16:35:29','2024-10-25 16:35:29'),(25,'view_cash_register','web','2024-10-25 16:35:31','2024-10-25 16:35:31'),(26,'close_cash_register','web','2024-10-25 16:35:31','2024-10-25 16:35:31'),(27,'print_invoice','web','2024-10-25 16:35:33','2024-10-25 16:35:33'),(28,'user.view','web','2024-10-25 16:35:35',NULL),(29,'user.create','web','2024-10-25 16:35:35',NULL),(30,'user.update','web','2024-10-25 16:35:35',NULL),(31,'user.delete','web','2024-10-25 16:35:35',NULL),(32,'supplier.view','web','2024-10-25 16:35:35',NULL),(33,'supplier.create','web','2024-10-25 16:35:35',NULL),(34,'supplier.update','web','2024-10-25 16:35:35',NULL),(35,'supplier.delete','web','2024-10-25 16:35:35',NULL),(36,'customer.view','web','2024-10-25 16:35:35',NULL),(37,'customer.create','web','2024-10-25 16:35:35',NULL),(38,'customer.update','web','2024-10-25 16:35:35',NULL),(39,'customer.delete','web','2024-10-25 16:35:35',NULL),(40,'product.view','web','2024-10-25 16:35:35',NULL),(41,'product.create','web','2024-10-25 16:35:35',NULL),(42,'product.update','web','2024-10-25 16:35:35',NULL),(43,'product.delete','web','2024-10-25 16:35:35',NULL),(44,'purchase.view','web','2024-10-25 16:35:35',NULL),(45,'purchase.create','web','2024-10-25 16:35:35',NULL),(46,'purchase.update','web','2024-10-25 16:35:35',NULL),(47,'purchase.delete','web','2024-10-25 16:35:35',NULL),(48,'sell.view','web','2024-10-25 16:35:35',NULL),(49,'sell.create','web','2024-10-25 16:35:35',NULL),(50,'sell.update','web','2024-10-25 16:35:35',NULL),(51,'sell.delete','web','2024-10-25 16:35:35',NULL),(52,'purchase_n_sell_report.view','web','2024-10-25 16:35:35',NULL),(53,'contacts_report.view','web','2024-10-25 16:35:35',NULL),(54,'stock_report.view','web','2024-10-25 16:35:35',NULL),(55,'tax_report.view','web','2024-10-25 16:35:35',NULL),(56,'trending_product_report.view','web','2024-10-25 16:35:35',NULL),(57,'register_report.view','web','2024-10-25 16:35:35',NULL),(58,'sales_representative.view','web','2024-10-25 16:35:35',NULL),(59,'expense_report.view','web','2024-10-25 16:35:35',NULL),(60,'business_settings.access','web','2024-10-25 16:35:35',NULL),(61,'barcode_settings.access','web','2024-10-25 16:35:35',NULL),(62,'invoice_settings.access','web','2024-10-25 16:35:35',NULL),(63,'brand.view','web','2024-10-25 16:35:35',NULL),(64,'brand.create','web','2024-10-25 16:35:35',NULL),(65,'brand.update','web','2024-10-25 16:35:35',NULL),(66,'brand.delete','web','2024-10-25 16:35:35',NULL),(67,'tax_rate.view','web','2024-10-25 16:35:35',NULL),(68,'tax_rate.create','web','2024-10-25 16:35:35',NULL),(69,'tax_rate.update','web','2024-10-25 16:35:35',NULL),(70,'tax_rate.delete','web','2024-10-25 16:35:35',NULL),(71,'unit.view','web','2024-10-25 16:35:35',NULL),(72,'unit.create','web','2024-10-25 16:35:35',NULL),(73,'unit.update','web','2024-10-25 16:35:35',NULL),(74,'unit.delete','web','2024-10-25 16:35:35',NULL),(75,'category.view','web','2024-10-25 16:35:35',NULL),(76,'category.create','web','2024-10-25 16:35:35',NULL),(77,'category.update','web','2024-10-25 16:35:35',NULL),(78,'category.delete','web','2024-10-25 16:35:35',NULL),(79,'expense.access','web','2024-10-25 16:35:35',NULL),(80,'access_all_locations','web','2024-10-25 16:35:35',NULL),(81,'dashboard.data','web','2024-10-25 16:35:35',NULL),(82,'location.1','web','2024-10-25 16:39:24','2024-10-25 16:39:24'),(83,'location.2','web','2024-10-29 03:26:47','2024-10-29 03:26:47'),(84,'essentials.create_message','web','2024-11-03 04:26:40','2024-11-03 04:26:40'),(85,'essentials.view_message','web','2024-11-03 04:26:40','2024-11-03 04:26:40'),(86,'manufacturing.access_recipe','web','2024-11-03 04:26:41','2024-11-03 04:26:41'),(87,'manufacturing.access_production','web','2024-11-03 04:26:41','2024-11-03 04:26:41'),(88,'manufacturing.add_recipe','web','2024-11-03 04:26:41','2024-11-03 04:26:41'),(89,'manufacturing.edit_recipe','web','2024-11-03 04:26:41','2024-11-03 04:26:41'),(90,'essentials.approve_leave','web','2024-11-03 04:26:41','2024-11-03 04:26:41'),(91,'essentials.assign_todos','web','2024-11-03 04:26:41','2024-11-03 04:26:41'),(92,'essentials.add_allowance_and_deduction','web','2024-11-03 04:26:41','2024-11-03 04:26:41'),(93,'selling_price_group.1','web','2024-11-03 04:45:06','2024-11-03 04:45:06'),(94,'selling_price_group.2','web','2024-11-03 05:29:42','2024-11-03 05:29:42'),(95,'selling_price_group.5','web','2024-11-25 02:58:18','2024-11-25 02:58:18'),(96,'selling_price_group.6','web','2024-11-25 02:58:45','2024-11-25 02:58:45'),(97,'selling_price_group.7','web','2024-11-25 02:58:58','2024-11-25 02:58:58'),(98,'selling_price_group.8','web','2024-11-25 02:59:07','2024-11-25 02:59:07'),(99,'location.3','web','2024-12-07 09:56:20','2024-12-07 09:56:20'),(100,'selling_price_group.3','web','2024-12-14 00:15:57','2024-12-14 00:15:57'),(101,'selling_price_group.4','web','2024-12-14 00:18:16','2024-12-14 00:18:16'),(102,'view_export_buttons','web','2024-12-14 13:28:31','2024-12-14 13:28:31'),(103,'edit_purchase_payment','web','2024-12-14 13:28:31','2024-12-14 13:28:31'),(104,'delete_purchase_payment','web','2024-12-14 13:28:31','2024-12-14 13:28:31'),(105,'edit_pos_payment','web','2024-12-14 13:28:31','2024-12-14 13:28:31'),(106,'disable_pay_checkout','web','2024-12-14 13:28:31','2024-12-14 13:28:31'),(107,'disable_draft','web','2024-12-14 13:28:31','2024-12-14 13:28:31'),(108,'disable_express_checkout','web','2024-12-14 13:28:31','2024-12-14 13:28:31'),(109,'disable_discount','web','2024-12-14 13:28:31','2024-12-14 13:28:31'),(110,'disable_suspend_sale','web','2024-12-14 13:28:31','2024-12-14 13:28:31'),(111,'disable_credit_sale','web','2024-12-14 13:28:31','2024-12-14 13:28:31'),(112,'disable_quotation','web','2024-12-14 13:28:31','2024-12-14 13:28:31'),(113,'disable_card','web','2024-12-14 13:28:31','2024-12-14 13:28:31'),(114,'view_paid_sells_only','web','2024-12-14 13:28:31','2024-12-14 13:28:31'),(115,'view_due_sells_only','web','2024-12-14 13:28:31','2024-12-14 13:28:31'),(116,'view_partial_sells_only','web','2024-12-14 13:28:31','2024-12-14 13:28:31'),(117,'view_overdue_sells_only','web','2024-12-14 13:28:31','2024-12-14 13:28:31'),(118,'direct_sell.update','web','2024-12-14 13:28:31','2024-12-14 13:28:31'),(119,'direct_sell.delete','web','2024-12-14 13:28:31','2024-12-14 13:28:31'),(120,'view_commission_agent_sell','web','2024-12-14 13:28:31','2024-12-14 13:28:31'),(121,'edit_sell_payment','web','2024-12-14 13:28:31','2024-12-14 13:28:31'),(122,'delete_sell_payment','web','2024-12-14 13:28:31','2024-12-14 13:28:31'),(123,'access_sell_return','web','2024-12-14 13:28:31','2024-12-14 13:28:31'),(124,'access_own_sell_return','web','2024-12-14 13:28:31','2024-12-14 13:28:31'),(125,'edit_invoice_number','web','2024-12-14 13:28:31','2024-12-14 13:28:31'),(126,'view_product_stock_value','web','2024-12-14 13:28:31','2024-12-14 13:28:31'),(127,'supplier.view_own','web','2024-12-14 13:28:31','2024-12-14 13:28:31'),(128,'customer_irrespective_of_sell','web','2024-12-14 13:28:31','2024-12-14 13:28:31'),(129,'direct_sell.view','web','2024-12-14 13:28:31','2024-12-14 13:28:31');
/*!40000 ALTER TABLE `permissions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `printers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `printers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `category_id` int(11) DEFAULT NULL,
  `name` varchar(191) NOT NULL,
  `connection_type` enum('network','windows','linux') NOT NULL,
  `capability_profile` enum('default','simple','SP2000','TEP-200M','P822D') NOT NULL DEFAULT 'default',
  `char_per_line` varchar(191) DEFAULT NULL,
  `ip_address` varchar(191) DEFAULT NULL,
  `port` varchar(191) DEFAULT NULL,
  `path` varchar(191) DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `printers_business_id_foreign` (`business_id`),
  CONSTRAINT `printers_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `printers` WRITE;
/*!40000 ALTER TABLE `printers` DISABLE KEYS */;
/*!40000 ALTER TABLE `printers` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `product_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_locations` (
  `product_id` int(11) NOT NULL,
  `location_id` int(11) NOT NULL,
  KEY `product_locations_product_id_index` (`product_id`),
  KEY `product_locations_location_id_index` (`location_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `product_locations` WRITE;
/*!40000 ALTER TABLE `product_locations` DISABLE KEYS */;
INSERT INTO `product_locations` VALUES (1,1),(2,1),(3,1),(4,1),(5,1),(6,1),(7,1),(8,1),(9,1),(10,1),(11,1),(12,1),(13,1),(14,1),(15,1),(16,1),(17,1),(18,1),(19,1),(20,1),(21,1),(22,1),(23,1),(24,1),(25,1),(26,1),(27,1),(28,1),(29,1),(30,1),(31,1),(32,1),(33,1),(34,1),(35,1),(36,1),(37,1),(38,1),(39,1),(40,1),(41,1),(42,1),(43,1),(44,1),(45,1),(46,1),(47,1),(48,1),(49,1),(50,1),(51,1),(52,1),(53,1),(54,1),(55,1),(56,1),(57,1),(58,1),(59,1),(60,1),(61,1),(62,1),(63,1),(64,1),(65,1),(66,1),(67,1),(68,1),(69,1),(70,1),(71,1),(72,1),(73,1),(74,1),(75,1),(76,1),(77,1),(78,1),(79,1),(80,1),(81,1),(82,1),(83,1),(84,1),(85,1),(86,1),(87,1),(88,1),(89,1),(90,1),(91,1),(92,1),(93,1),(94,1),(95,1),(96,1),(97,1),(98,1),(99,1),(100,1),(101,1),(102,1),(103,1),(104,1),(105,1),(106,1),(107,1),(108,1),(109,1),(110,1),(111,1),(112,1),(113,1),(114,1),(115,1),(116,1),(117,1),(118,1),(119,1),(120,1),(121,1),(122,1),(123,1),(124,1),(125,1),(126,1),(127,1),(128,1),(129,1),(130,1),(131,1),(132,1),(133,1),(134,1),(135,1),(136,1),(137,1),(138,1),(139,1),(140,1),(141,1),(142,1),(143,1),(144,1),(145,1),(146,1),(147,1),(148,1),(149,1),(150,1),(151,1),(152,1),(153,1),(154,1),(155,1),(156,1),(157,1),(158,1),(159,1),(160,1),(161,1),(162,1),(163,1),(164,1),(165,1),(166,1),(167,1),(168,1),(169,1),(170,1),(171,1),(172,1),(173,1),(174,1),(175,1),(176,1),(177,1),(178,1),(179,1),(180,1),(181,1),(182,1),(183,1),(184,1),(185,1),(186,1),(187,1),(188,1),(189,1),(190,1),(191,1),(192,1),(193,1),(194,1),(195,1),(196,1),(197,1),(198,1),(199,1),(200,1),(201,1),(202,1),(203,1),(204,1),(205,1),(206,1),(207,1),(208,1),(209,1),(210,1),(211,1),(212,1),(213,1),(214,1),(215,1),(216,1),(217,1),(218,1),(219,1),(220,1),(221,1),(222,1),(223,1),(224,1),(225,1),(226,1),(227,1),(228,1),(229,1),(230,1),(231,1),(232,1),(233,1),(234,1),(235,1),(236,1),(237,1),(238,1),(239,1),(240,1),(241,1),(242,1),(243,1),(244,1),(245,1),(246,1),(247,1),(248,1),(249,1),(250,1),(251,1),(252,1),(253,1),(254,1),(255,1),(256,1),(257,1),(258,1),(259,1),(260,1),(261,1),(262,1),(263,1),(264,1),(265,1),(266,1),(267,1),(268,1),(269,1),(270,1),(271,1),(272,1),(273,1),(274,1),(275,1),(276,1),(277,1),(278,1),(279,1),(280,1),(281,1),(282,1),(283,1),(284,1),(285,1),(286,1),(287,1),(288,1),(289,1),(290,1),(291,1),(292,1),(293,1),(294,1),(295,1),(296,1),(297,1),(298,1),(299,1),(300,1),(301,1),(302,1),(303,1),(304,1),(305,1),(306,1),(307,1),(308,1),(309,1),(310,1),(311,1),(312,1),(313,1),(314,1),(315,1),(316,1),(317,1),(318,1),(319,1),(320,1),(321,1),(322,1),(323,1),(324,1),(325,1),(326,1),(327,1),(328,1),(329,1),(330,1),(331,1),(332,1),(333,1),(334,1),(335,1),(336,1),(337,1),(338,1),(340,1),(341,1),(342,1),(343,1),(344,1),(345,1),(346,1),(347,1),(348,1),(349,1),(350,1),(351,1),(352,1),(353,1),(354,1),(355,1),(356,1),(357,1),(358,1),(359,1),(360,1),(361,1),(362,1),(363,1),(364,1),(365,1),(366,1),(367,1),(368,1),(369,1),(370,1),(371,1),(372,1),(373,1),(374,1),(375,1),(376,1),(377,1),(378,1),(379,1),(380,1),(381,1),(382,1),(383,1),(384,1),(385,1),(386,1),(387,1),(388,1),(389,1),(390,1),(391,1),(392,1),(393,1),(394,1),(395,1),(396,1),(397,1),(398,1),(399,1),(400,1),(401,1),(402,1),(403,1),(404,1),(405,1),(406,1),(407,1),(408,1),(409,1),(410,1),(411,1),(412,1),(413,1),(414,1),(415,1),(416,1),(417,1),(418,1),(419,1),(420,1),(421,1),(422,1),(423,1),(424,1),(425,1),(426,1),(427,1),(428,1),(429,1),(430,1),(431,1),(432,1),(433,1),(434,1),(435,1),(436,1),(437,1),(438,1),(439,1),(440,1),(441,1),(442,1),(443,1),(444,1),(445,1),(446,1),(447,1),(448,1),(449,1),(450,1),(451,1),(452,1),(453,1),(454,1),(455,1),(456,1),(457,1),(458,1),(459,1),(460,1),(461,1),(462,1),(463,1),(464,1),(465,1),(466,1),(467,1),(468,1),(469,1),(470,1),(471,1),(472,1),(473,1),(474,1),(475,1),(476,1),(477,1),(478,1),(479,1),(480,1),(481,1),(482,1),(483,1),(484,1),(485,1),(486,1),(487,1),(488,1),(489,1),(490,1),(491,1),(492,1),(493,1),(494,1),(495,1),(496,1),(497,1),(498,1),(499,1),(500,1),(501,1),(502,1),(503,1),(504,1),(505,1),(506,1),(507,1),(508,1),(509,1),(510,1),(511,1),(512,1),(513,1),(514,1),(515,1),(516,1),(517,1),(518,1),(519,1),(520,1),(521,1),(522,1),(523,1),(524,1),(525,1),(526,1),(527,1),(528,1),(529,1),(530,1),(531,1),(532,1),(533,1),(534,1),(535,1),(536,1),(537,1),(538,1),(539,1),(540,1),(541,1),(542,1),(543,1),(544,1),(545,1),(546,1),(547,1),(548,1),(549,1),(550,1),(551,1),(552,1),(553,1),(554,1),(555,1),(556,1),(557,1),(558,1),(559,1),(560,1),(561,1),(562,1),(563,1),(564,1),(565,1),(566,1),(567,1),(568,1),(569,1),(570,1),(571,1),(572,1),(573,1),(574,1),(575,1),(576,1),(577,1),(578,1),(579,1),(580,1),(581,1),(582,1),(583,1),(584,1),(585,1),(586,1),(587,1),(588,1),(589,1),(590,1),(591,1),(592,1),(593,1),(594,1),(595,1),(596,1),(597,1),(598,1),(599,1),(600,1),(601,1),(602,1),(603,1),(604,1),(605,1),(606,1),(607,1),(608,1),(609,1),(610,1),(611,1),(612,1),(613,1),(614,1),(615,1),(616,1),(617,1),(618,1),(619,1),(620,1),(621,1),(622,1),(623,1),(624,1),(625,1),(626,1),(627,1),(628,1),(629,1),(630,1),(631,1),(632,1),(633,1),(634,1),(635,1),(636,1),(637,1),(638,1),(639,1),(640,1),(641,1),(642,1),(643,1),(644,1),(645,1),(646,1),(647,1),(648,1),(649,1),(650,1),(651,1),(652,1),(653,1),(654,1),(655,1),(656,1),(657,1),(658,1),(659,1),(660,1),(661,1),(662,1),(663,1),(664,1),(665,1),(666,1),(667,1),(668,1),(669,1),(670,1),(671,1),(672,1),(673,1),(674,1),(675,1),(676,1),(677,1),(678,1),(679,1),(680,1),(681,1),(682,1),(683,1),(684,1),(685,1),(686,1),(687,1),(688,1),(689,1),(690,1),(691,1),(692,1),(693,1),(694,1),(695,1),(696,1),(697,1),(698,1),(699,1),(700,1),(701,1),(702,1),(703,1),(704,1),(705,1),(706,1),(707,1),(708,1),(709,1),(710,1),(711,1),(712,1),(713,1),(714,1),(715,1),(716,1),(717,1),(718,1),(719,1),(720,1),(721,1),(722,1),(723,1),(724,1),(725,1),(726,1),(727,1),(728,1),(729,1),(730,1),(731,1),(732,1),(733,1),(734,1),(735,1),(736,1),(737,1),(738,1),(739,1),(740,1),(741,1),(742,1),(743,1),(744,1),(745,1),(746,1),(747,1),(748,1),(749,1),(750,1),(751,1),(752,1),(753,1),(754,1),(755,1),(756,1),(757,1),(758,1),(759,1),(760,1),(761,1),(762,1),(763,1),(764,1),(765,1),(766,1),(767,1),(768,1),(769,1),(770,1),(771,1),(772,1),(773,1),(774,1),(775,1),(776,1),(777,1),(778,1),(779,1),(780,1),(781,1),(782,1),(783,1),(784,1),(785,1),(786,1),(787,1),(788,1),(789,1),(790,1),(791,1),(792,1),(793,1),(794,1),(795,1),(796,1),(797,1),(798,1),(799,1),(800,1),(801,1),(802,1),(803,1),(804,1),(805,1),(806,1),(807,1),(808,1),(809,1),(810,1),(811,1),(812,1),(813,1),(814,1),(815,1),(816,1),(817,1),(818,1),(819,1),(820,1),(821,1),(822,1),(823,1),(824,1),(825,1),(826,1),(827,1),(828,1),(829,1),(830,1),(831,1),(832,1),(833,1),(834,1),(835,1),(836,1),(837,1),(838,1),(839,1),(840,1),(841,1),(842,1),(843,1),(844,1),(845,1),(846,1),(847,1),(848,1),(849,1),(850,1),(851,1),(852,1),(853,1),(854,1),(855,1),(856,1),(857,1),(858,1),(859,1),(860,1),(861,1),(862,1),(863,1),(864,1),(865,1),(866,1),(867,1),(868,1),(869,1),(870,1),(871,1),(872,1),(873,1),(874,1),(875,1),(876,1),(877,1),(878,1),(879,1),(880,1),(881,1),(882,1),(883,1),(884,1),(885,1),(886,1),(887,1),(888,1),(889,1),(890,1),(891,1),(892,1),(893,1),(894,1),(895,1),(896,1),(897,1),(898,1),(899,1),(900,1),(901,1),(902,1),(903,1),(904,1),(905,1),(906,1),(907,1),(908,1),(909,1),(910,1),(911,1),(912,1),(913,1),(914,1),(915,1),(916,1),(917,1),(918,1),(919,1),(920,1),(921,1),(922,1),(923,1),(924,1),(925,1),(926,1),(927,1),(928,1),(929,1),(930,1),(931,1),(932,1),(933,1),(934,1),(935,1),(936,1),(937,1),(938,1),(939,1),(940,1),(941,1),(942,1),(943,1),(944,1),(945,1),(946,1),(947,1),(948,1),(949,1),(950,1),(951,1),(952,1),(953,1),(954,1),(955,1),(956,1),(957,1),(958,1),(959,1),(960,1),(961,1),(962,1),(963,1),(964,1),(965,1),(966,1),(967,1),(968,1),(969,1),(970,1),(971,1),(972,1),(973,1),(974,1),(975,1),(976,1),(977,1),(978,1),(979,1),(980,1),(981,1),(982,1),(983,1),(984,1),(985,1),(986,1),(987,1),(988,1),(989,1),(990,1),(991,1),(992,1),(993,1),(994,1),(995,1),(996,1),(997,1),(998,1),(999,1),(1000,1),(1001,1),(1002,1),(1003,1),(1004,1),(1005,1),(1006,1),(1007,1),(1008,1),(1009,1),(1010,1),(1011,1),(1012,1),(1013,1),(1014,1),(1015,1),(1016,1),(1017,1),(1018,1),(1019,1),(1020,1),(1021,1),(1022,1),(1023,1),(1024,1),(1025,1),(1026,1),(1027,1),(1028,1),(1029,1),(1030,1),(1031,1),(1032,1),(1033,1),(1034,1),(1035,1),(1036,1),(1037,1),(1038,1),(1039,1),(1040,1),(1041,1),(1042,1),(1043,1),(1044,1),(1045,1),(1046,1),(1047,1),(1048,1),(1049,1),(1050,1),(1051,1),(1052,1),(1053,1),(1054,1),(1055,1),(1056,1),(1057,1),(1058,1),(1059,1),(1060,1),(1061,1),(1062,1),(1063,1),(1064,1),(1065,1),(1066,1),(1067,1),(1068,1),(1069,1),(1070,1),(1071,1),(1072,1),(1073,1),(1074,1),(1075,1),(1076,1),(1077,1),(1078,1),(1079,1),(1080,1),(1081,1),(1082,1),(1083,1),(1084,1),(1085,1),(1086,1),(1087,1),(1088,1),(1089,1),(1090,1),(1091,1),(1092,1),(1093,1),(1094,1),(1095,1),(1096,1),(1097,1),(1098,1),(1099,1),(1101,1),(1102,1),(1103,1),(1104,1),(1105,1),(1106,1),(1107,1),(1108,1),(1109,1),(1110,1),(1111,1),(1112,1),(1113,1),(1114,1),(1115,1),(1116,1),(1117,1),(1118,1),(1119,1),(1120,1),(1121,1),(1122,1),(1123,1),(1124,1),(1125,1),(1126,1),(1127,1),(1128,1),(1129,1),(1130,1),(1131,1),(1132,1),(1133,1),(1134,1),(1135,1),(1136,1),(1137,1),(1138,1),(1139,1),(1140,1),(1141,1),(1142,1),(1143,1),(1144,1),(1145,1),(1146,1),(1147,1),(1148,1),(1149,1),(1150,1),(1152,1),(1153,1),(1154,1),(1155,1),(1157,1),(1158,1),(1159,1),(1160,1),(1161,1),(1162,1),(1163,1),(1164,1),(1165,1),(1166,1),(1167,1),(1168,1),(1169,1),(1170,1),(1171,1),(1172,1),(1173,1),(1174,1),(1175,1),(1176,1),(1177,1),(1178,1),(1179,1),(1180,1),(1181,1),(1182,1),(1183,1),(1184,1),(1185,1),(1186,1),(1187,1),(1188,1),(1189,1),(1190,1),(1191,1),(1192,1),(1193,1),(1194,1),(1195,1),(1196,1),(1197,1),(1198,1),(1199,1),(1200,1),(1201,1),(1202,1),(1204,1),(1205,1),(1206,1),(1207,1),(1208,1),(1209,1),(1210,1),(1211,1),(1212,1),(1213,1),(1214,1),(1215,1),(1216,1),(1217,1),(1218,1),(1219,1),(1220,1),(1221,1),(1222,1),(1223,1),(1224,1),(1225,1),(1226,1),(1227,1),(1228,1),(1229,1),(1230,1),(1231,1),(1232,1),(1233,1),(1234,1),(1235,1),(1236,1),(1237,1),(1238,1),(1239,1),(1240,1),(1241,1),(1242,1),(1243,1),(1244,1),(1245,1),(1246,1),(1247,1),(1248,1),(1249,1),(1250,1),(1251,1),(1252,1),(1253,1),(1254,1),(1255,1),(1256,1),(1257,1),(1258,1),(1259,1),(1260,1),(1261,1),(1262,1),(1263,1),(1264,1),(1265,1),(1266,1),(1267,1),(1268,1),(1269,1),(1270,1),(1271,1),(1272,1),(1273,1),(1274,1),(1275,1),(1276,1),(1277,1),(1279,1),(1280,1),(1281,1),(1282,1),(1283,1),(1284,1),(1285,1),(1286,1),(1287,1),(1288,1),(1289,1),(1290,1),(1291,1),(1293,1),(1294,1),(1295,1),(1296,1),(1297,1),(1298,1),(1299,1),(1300,1),(1301,1),(1302,1),(1303,1),(1304,1),(1305,1),(1306,1),(1307,1),(1308,1),(1309,1),(1310,1),(1311,1),(1312,1),(1313,1),(1314,1),(1315,1),(1316,1),(1317,1),(1318,1),(1319,1),(1320,1),(1321,1),(1322,1),(1323,1),(1324,1),(1325,1),(1326,1),(1327,1),(1328,1),(1329,1),(1330,1),(1331,1),(1332,1),(1333,1),(1334,1),(1335,1),(1336,1),(1337,1),(1338,1),(1339,1),(1340,1),(1341,1),(1342,1),(1343,1),(1344,1),(1345,1),(1346,1),(1347,1),(1348,1),(1349,1),(1350,1),(1351,1),(1352,1),(1353,1),(1354,1),(1355,1),(1356,1),(1357,1),(1358,1),(1359,1),(1360,1),(1361,1),(1362,1),(1363,1),(1364,1),(1365,1),(1366,1),(1367,1),(1368,1),(1369,1),(1370,1),(1371,1),(1372,1),(1373,1),(1374,1),(1375,1),(1376,1),(1377,1),(1378,1),(1380,1),(1381,1),(1382,1),(1383,1),(1384,1),(1385,1),(1386,1),(1387,1),(1388,1),(1389,1),(1390,1),(1391,1),(1392,1),(1393,1),(1394,1),(1395,1),(1396,1),(1397,1),(1398,1),(1399,1),(1400,1),(1401,1),(1402,1),(1403,1),(1404,1),(1405,1),(1406,1),(1407,1),(1408,1),(1409,1),(1410,1),(1411,1),(1412,1),(1413,1),(1414,1),(1415,1),(1416,1),(1417,1),(1418,1),(1419,1),(1420,1),(1421,1),(1422,1),(1423,1),(1424,1),(1425,1),(1426,1),(1427,1),(1428,1),(1429,1),(1430,1),(1431,1),(1432,1),(1433,1),(1434,1),(1435,1),(1436,1),(1437,1),(1438,1),(1439,1),(1440,1),(1441,1),(1442,1),(1443,1),(1444,1),(1445,1),(1446,1),(1447,1),(1448,1),(1449,1),(1450,1),(1451,1),(1452,1),(1453,1),(1454,1),(1455,1),(1456,1),(1457,1),(1458,1),(1459,1),(1460,1),(1461,1),(1462,1),(1463,1),(1464,1),(1465,1),(1466,1),(1467,1),(1468,1),(1469,1),(1470,1),(1471,1),(1472,1),(1473,1),(1474,1),(1475,1),(1476,1),(1477,1),(1478,1),(1479,1),(1480,1),(1481,1),(1482,1),(1483,1),(1484,1),(1485,1),(1486,1),(1487,1),(1488,1),(1489,1),(1490,1),(1491,1),(1492,1),(1493,1),(1494,1),(1495,1),(1496,1),(1497,1),(1498,1),(1499,1),(1500,1),(1501,1),(1502,1),(1503,1),(1504,1),(1505,1),(1506,1),(1507,1),(1508,1),(1509,1),(1510,1),(1511,1),(1512,1),(1513,1),(1514,1),(1515,1),(1516,1),(1517,1),(1518,1),(1519,1),(1520,1),(1521,1),(1522,1),(1523,1),(1524,1),(1525,1),(1526,1),(1527,1),(1528,1),(1529,1),(1530,1),(1531,1),(1532,1),(1533,1),(1534,1),(1535,1),(1536,1),(1537,1),(1538,1),(1539,1),(1540,1),(1541,1),(1542,1),(1543,1),(1544,1),(1545,1),(1546,1),(1547,1),(1548,1),(1549,1),(1550,1),(1551,1),(1552,1),(1553,1),(1554,1),(1555,1),(1556,1),(1557,1),(1558,1),(1559,1),(1560,1),(1561,1),(1562,1),(1563,1),(1564,1),(1565,1),(1566,1),(1567,1),(1568,1),(1569,1),(1570,1),(1571,1),(1572,1),(1573,1),(1574,1),(1575,1),(1576,1),(1577,1),(1578,1),(1579,1),(1580,1),(1581,1),(1582,1),(1583,1),(1584,1),(1585,1),(1586,1),(1587,1),(1588,1),(1589,1),(1590,1),(1591,1),(1592,1),(1593,1),(1594,1),(1595,1),(1596,1),(1597,1),(1598,1),(1599,1),(1600,1),(1601,1),(1602,1),(1603,1),(1604,1),(1605,1),(1606,1),(1607,1),(1608,1),(1609,1),(1610,1),(1611,1),(1612,1),(1613,1),(1614,1),(1615,1),(1616,1),(1617,1),(1618,1),(1619,1),(1620,1),(1621,1),(1622,1),(1623,1),(1624,1),(1625,1),(1626,1),(1627,1),(1628,1),(1629,1),(1630,1),(1631,1),(1632,1),(1633,1),(1634,1),(1635,1),(1636,1),(1637,1),(1638,1),(1639,1),(1640,1),(1641,1),(1642,1),(1643,1),(1644,1),(1645,1),(1646,1),(1647,1),(1648,1),(1649,1),(1650,1),(1651,1),(1652,1),(1653,1),(1654,1),(1655,1),(1656,1),(1657,1),(1658,1),(1659,1),(1660,1),(1661,1),(1662,1),(1663,1),(1664,1),(1665,1),(1666,1),(1667,1),(1668,1),(1669,1),(1670,1),(1671,1),(1672,1),(1673,1),(1674,1),(1675,1),(1676,1),(1677,1),(1678,1),(1679,1),(1680,1),(1681,1),(1682,1),(1683,1),(1684,1),(1685,1),(1686,1),(1687,1),(1688,1),(1689,1),(1690,1),(1691,1),(1692,1),(1693,1),(1694,1),(1695,1),(1696,1),(1697,1),(1698,1),(1699,1),(1700,1),(1701,1),(1702,1),(1703,1),(1704,1),(1705,1),(1706,1),(1707,1),(1708,1),(1710,1),(1711,1),(1712,1),(1713,1),(1714,1),(1715,1),(1716,1),(1717,1),(1718,1),(1719,1),(1720,1),(1721,1),(1722,1),(1723,1),(1724,1),(1725,1),(1726,1),(1727,1),(1728,1),(1729,1),(1730,1),(1731,1),(1732,1),(1733,1),(1734,1),(1735,1),(1736,1),(1737,1),(1738,1),(1739,1),(1741,1),(1742,1),(1743,1),(1744,1),(1745,1),(1746,1),(1747,1),(1749,1),(1750,1),(1751,1),(1752,1),(1753,1),(1754,1),(1756,1),(1757,1),(1758,1),(1759,1),(1760,1),(1762,1),(1763,1),(1764,1),(1765,1),(1766,1),(1767,1),(1768,1),(1769,1),(1770,1),(1771,1),(1772,1),(1773,1),(1774,1),(1775,1),(1776,1),(1777,1),(1778,1),(1779,1),(1780,1),(1781,1),(1782,1),(1783,1),(1784,1),(1785,1),(1786,1),(1787,1),(1788,1),(1789,1),(1790,1),(1791,1),(1792,1),(1793,1),(1794,1),(1795,1),(1796,1),(1797,1),(1798,1),(1799,1),(1800,1),(1801,1),(1802,1),(1803,1),(1804,1),(1805,1),(1806,1),(1807,1),(1808,1),(1809,1),(1810,1),(1811,1),(1812,1),(1813,1),(1814,1),(1815,1),(1816,1),(1817,1),(1818,1),(1819,1),(1820,1),(1821,1),(1822,1),(1823,1),(1824,1),(1825,1),(1826,1),(1827,1),(1828,1),(1829,1),(1830,1),(1831,1),(1832,1),(1833,1),(1834,1),(1835,1),(1836,1),(1837,1),(1838,1),(1839,1),(1840,1),(1841,1),(1842,1),(1843,1),(1844,1),(1845,1),(1846,1),(1847,1),(1848,1),(1849,1),(1850,1),(1851,1),(1852,1),(1853,1),(1854,1),(1855,1),(1856,1),(1857,1),(1858,1),(1859,1),(1860,1),(1861,1),(1862,1),(1863,1),(1864,1),(1865,1),(1866,1),(1867,1),(1868,1),(1869,1),(1870,1),(1871,1),(1872,1),(1873,1),(1874,1),(1875,1),(1876,1),(1877,1),(1878,1),(1879,1),(1880,1),(1881,1),(1882,1),(1883,1),(1884,1),(1885,1),(1886,1),(1887,1),(1888,1),(1889,1),(1890,1),(1891,1),(1892,1),(1893,1),(1894,1),(1895,1),(1896,1),(1897,1),(1898,1),(1899,1),(1900,1),(1901,1),(1902,1),(1903,1),(1904,1),(1905,1),(1906,1),(1907,1),(1908,1),(1909,1),(1910,1),(1911,1),(1912,1),(1913,1),(1914,1),(1915,1),(1916,1),(1917,1),(1918,1),(1919,1),(1920,1),(1921,1),(1922,1),(1923,1),(1924,1),(1925,1),(1926,1),(1927,1),(1928,1),(1929,1),(1930,1),(1931,1),(1932,1),(1933,1),(1934,1),(1935,1),(1936,1),(1937,1),(1938,1),(1939,1),(1940,1),(1941,1),(1942,1),(1943,1),(1944,1),(1945,1),(1946,1),(1947,1),(1948,1),(1949,1),(1950,1),(1951,1),(1952,1),(1953,1),(1954,1),(1955,1),(1956,1),(1957,1),(1958,1),(1959,1),(1960,1),(1961,1),(1962,1),(1963,1),(1964,1),(1965,1),(1966,1),(1967,1),(1968,1),(1969,1),(1970,1),(1971,1),(1972,1),(1973,1),(1974,1),(1975,1),(1976,1),(1977,1),(1978,1),(1979,1),(1980,1),(1981,1),(1982,1),(1983,1),(1984,1),(1985,1),(1986,1),(1987,1),(1988,1),(1989,1),(1990,1),(1991,1),(1992,1),(1993,1),(1994,1),(1995,1),(1996,1),(1997,1),(1998,1),(1999,1),(2000,1),(2001,1),(2002,1),(2003,1),(2004,1),(2005,1),(2006,1),(2007,1),(2008,1),(2009,1),(2011,1),(2012,1),(2013,1),(2014,1),(2015,1),(2016,1),(2017,1),(2018,1),(2019,1),(2020,1),(2021,1),(2022,1),(2023,1),(2024,1),(2025,1),(2026,1),(2027,1),(2028,1),(2029,1),(2030,1),(2031,1),(2032,1),(2033,1),(2034,1),(2035,1),(2036,1),(2037,1),(2038,1),(2039,1),(2040,1),(2041,1),(2042,1),(2043,1),(2044,1),(2045,1),(2046,1),(2048,1),(2049,1),(2050,1),(2051,1),(2052,1),(2053,1),(2054,1),(2055,1),(2057,1),(2058,1),(2059,1),(2060,1),(2061,1),(2062,1),(2063,1),(2064,1),(2065,1),(2066,1),(2067,1),(2068,1),(2069,1),(2070,1),(2071,1),(2072,1),(2073,1),(2074,1),(2075,1),(2076,1),(2077,1),(2078,1),(2079,1),(2080,1),(2081,1),(2082,1),(2083,1),(2084,1),(2085,1),(2086,1),(2087,1),(2088,1),(2089,1),(2090,1),(2091,1),(2092,1),(2093,1),(2094,1),(2095,1),(2096,1),(2097,1),(2098,1),(2099,1),(2100,1),(2101,1),(2102,1),(2103,1),(2104,1),(2105,1),(2106,1),(2107,1),(2108,1),(2109,1),(2110,1),(2111,1),(2112,1),(2113,1),(2114,1),(2115,1),(2116,1),(2117,1),(2118,1),(2119,1),(2120,1),(2121,1),(2122,1),(2123,1),(2124,1),(2125,1),(2126,1),(2127,1),(2128,1),(2129,1),(2130,1),(2131,1),(2132,1),(2133,1),(2134,1),(2135,1),(2136,1),(2137,1),(2138,1),(2139,1),(2140,1),(2141,1),(2142,1),(2143,1),(2144,1),(2145,1),(2146,1),(2147,1),(2148,1),(2149,1),(2150,1),(2151,1),(2152,1),(2153,1),(2154,1),(2155,1),(2156,1),(2157,1),(2158,1),(2159,1),(2160,1),(2161,1),(2162,1),(2163,1),(2164,1),(2165,1),(2166,1),(2167,1),(2168,1),(2169,1),(2170,1),(2171,1),(2172,1),(2173,1),(2174,1),(2175,1),(2176,1),(2177,1),(2178,1),(2179,1),(2180,1),(2181,1),(2182,1),(2183,1),(2184,1),(2185,1),(2186,1),(2187,1),(2188,1),(2189,1),(2190,1),(2191,1),(2192,1),(2193,1),(2194,1),(2195,1),(2196,1),(2197,1),(2198,1),(2199,1),(2200,1),(2201,1),(2202,1),(2203,1),(2204,1),(2205,1),(2206,1),(2207,1),(2208,1),(2209,1),(2210,1),(2211,1),(2212,1),(2213,1),(2214,1),(2215,1),(2216,1),(2217,1),(2218,1),(2219,1),(2220,1),(2221,1),(2222,1),(2223,1),(2224,1),(2225,1),(2226,1),(2227,1),(2228,1),(2229,1),(2230,1),(2231,1),(2232,1),(2233,1),(2234,1),(2235,1),(2236,1),(2237,1),(2238,1),(2239,1),(2240,1),(2241,1),(2242,1),(2243,1),(2244,1),(2245,1),(2246,1),(2247,1),(2248,1),(2249,1),(2250,1),(2251,1),(2252,1),(2253,1),(2254,1),(2255,1),(2256,1),(2257,1),(2258,1),(2259,1),(2260,1),(2261,1),(2262,1),(2263,1),(2264,1),(2265,1),(2266,1),(2267,1),(2268,1),(2269,1),(2270,1),(2271,1),(2272,1),(2273,1),(2274,1),(2275,1),(2276,1),(2277,1),(2278,1),(2279,1),(2280,1),(2281,1),(2282,1),(2283,1),(2284,1),(2285,1),(2286,1),(2287,1),(2288,1),(2289,1),(2290,1),(2291,1),(2292,1),(2293,1),(2294,1),(2295,1),(2296,1),(2297,1),(2298,1),(2299,1),(2300,1),(2301,1),(2302,1),(2303,1),(2304,1),(2305,1),(2306,1),(2307,1),(2308,1),(2309,1),(2310,1),(2311,1),(2312,1),(2313,1),(2314,1),(2315,1),(2316,1),(2317,1),(2318,1),(2319,1),(2320,1),(2321,1),(2322,1),(2323,1),(2324,1),(2325,1),(2326,1),(2327,1),(2328,1),(2329,1),(2330,1),(2331,1),(2332,1),(2333,1),(2334,1),(2335,1),(2336,1),(2337,1),(2338,1),(2339,1),(2340,1),(2341,1),(2342,1),(2343,1),(2344,1),(2345,1),(2346,1),(2347,1),(2348,1),(2349,1),(2350,1),(2351,1),(2352,1),(2353,1),(2354,1),(2355,1),(2356,1),(2357,1),(2358,1),(2359,1),(2360,1),(2361,1),(2362,1),(2363,1),(2364,1),(2365,1),(2366,1),(2367,1),(2368,1),(2369,1),(2370,1),(2371,1),(2372,1),(2373,1),(2374,1),(2375,1),(2376,1),(2377,1),(2378,1),(2379,1),(2380,1),(2381,1),(2382,1),(2383,1),(2384,1),(2385,1),(2386,1),(2387,1),(2388,1),(2389,1),(2390,1),(2391,1),(2392,1),(2393,1),(2394,1),(2395,1),(2396,1),(2397,1),(2398,1),(2399,1),(2400,1),(2401,1),(2402,1),(2403,1),(2404,1),(2405,1),(2406,1),(2407,1),(2408,1),(2409,1),(2410,1),(2411,1),(2412,1),(2413,1),(2414,1),(2415,1),(2416,1),(2417,1),(2418,1),(2419,1),(2420,1),(2421,1),(2422,1),(2423,1),(2424,1),(2425,1),(2426,1),(2427,1),(2428,1),(2429,1),(2430,1),(2431,1),(2432,1),(2433,1),(2434,1),(2435,1),(2436,1),(2437,1),(2438,1),(2439,1),(2440,1),(2441,1),(2442,1),(2443,1),(2444,1),(2445,1),(2446,1),(2447,1),(2448,1),(2449,1),(2450,1),(2451,1),(2452,1),(2453,1),(2454,1),(2455,1),(2456,1),(2457,1),(2458,1),(2459,1),(2460,1),(2461,1),(2462,1),(2463,1),(2464,1),(2465,1),(2466,1),(2467,1),(2468,1),(2469,1),(2470,1),(2471,1),(2472,1),(2473,1),(2474,1),(2475,1),(2476,1),(2477,1),(2478,1),(2479,1),(2480,1),(2481,1),(2482,1),(2483,1),(2484,1),(2485,1),(2486,1),(2487,1),(2488,1),(2489,1),(2490,1),(2491,1),(2492,1),(2493,1),(2494,1),(2495,1),(2497,1),(2498,1),(2499,1),(2500,1),(2501,1),(2502,1),(2503,1),(2504,1),(2505,1),(2506,1),(2507,1),(2508,1),(2509,1),(2510,1),(2511,1),(2512,1),(2513,1),(2514,1),(2515,1),(2516,1),(2517,1),(2518,1),(2519,1),(2520,1),(2521,1),(2522,1),(2523,1),(2524,1),(2525,1),(2526,1),(2527,1),(2528,1),(2529,1),(2530,1),(2531,1),(2532,1),(2533,1),(2534,1),(2535,1),(2536,1),(2537,1),(2538,1),(2539,1),(2540,1),(2541,1),(2542,1),(2543,1),(2544,1),(2545,1),(2546,1),(2548,1),(2550,1),(2551,1),(2552,1),(2553,1),(2554,1),(2555,1),(2556,1),(2557,1),(2558,1),(2559,1),(2560,1),(2561,1),(2562,1),(2563,1),(2565,1),(2566,1),(2567,1),(2568,1),(2569,1),(2570,1),(2571,1),(2572,1),(2573,1),(2574,1),(2575,1),(2576,1),(2577,1),(2578,1),(2579,1),(2580,1),(2581,1),(2582,1),(2583,1),(2584,1),(2585,1),(2586,1),(2587,1),(2588,1),(2589,1),(2590,1),(2591,1),(2592,1),(2593,1),(2594,1),(2595,1),(2596,1),(2597,1),(2598,1),(2599,1),(2600,1),(2601,1),(2602,1),(2603,1),(2604,1),(2605,1),(2606,1),(2607,1),(2608,1),(2609,1),(2610,1),(2611,1),(2612,1),(2613,1),(2614,1),(2615,1),(2616,1),(2617,1),(2618,1),(2619,1),(2620,1),(2621,1),(2622,1),(2623,1),(2624,1),(2625,1),(2626,1),(2627,1),(2628,1),(2629,1),(2630,1),(2631,1),(2632,1),(2633,1),(2634,1),(2635,1),(2636,1),(2637,1),(2638,1),(2639,1),(2640,1),(2641,1),(2642,1),(2643,1),(2644,1),(2645,1),(2646,1),(2647,1),(2648,1),(2649,1),(2650,1),(2651,1),(2652,1),(2653,1),(2654,1),(2655,1),(2656,1),(2657,1),(2658,1),(2659,1),(2660,1),(2661,1),(2662,1),(2663,1),(2664,1),(2665,1),(2666,1),(2667,1),(2668,1),(2669,1),(2670,1),(2671,1),(2672,1),(2673,1),(2674,1),(2675,1),(2676,1),(2677,1),(2678,1),(2679,1),(2680,1),(2681,1),(2682,1),(2683,1),(2684,1),(2685,1),(2686,1),(2687,1),(2688,1),(2689,1),(2690,1),(2691,1),(2692,1),(2693,1),(2694,1),(2695,1),(2696,1),(2697,1),(2698,1),(2699,1),(2700,1),(2701,1),(2702,1),(2703,1),(2704,1),(2705,1),(2706,1),(2707,1),(2708,1),(2709,1),(2710,1),(2711,1),(2712,1),(2713,1),(2714,1),(2715,1),(2716,1),(2717,1),(2718,1),(2719,1),(2720,1),(2721,1),(2722,1),(2723,1),(2724,1),(2725,1),(2726,1),(2727,1),(2728,1),(2729,1),(2730,1),(2731,1),(2732,1),(2733,1),(2734,1),(2736,1),(2737,1),(2738,1),(2739,1),(2740,1),(2741,1),(2742,1),(2743,1),(2744,1),(2745,1),(2746,1),(2747,1),(2748,1),(2749,1),(2750,1),(2751,1),(2752,1),(2753,1),(2754,1),(2755,1),(2756,1),(2757,1),(2758,1),(2759,1),(2760,1),(2761,1),(2762,1),(2763,1),(2764,1),(2765,1),(2766,1),(2767,1),(2768,1),(2769,1),(2770,1),(2771,1),(2772,1),(2773,1),(2774,1),(2775,1),(2776,1),(2777,1),(2778,1),(2779,1),(2780,1),(2781,1),(2782,1),(2783,1),(2784,1),(2785,1),(2786,1),(2787,1),(2788,1),(2789,1),(2790,1),(2791,1),(2792,1),(2793,1),(2794,1),(2795,1),(2796,1),(2797,1),(2798,1),(2799,1),(2800,1),(2801,1),(2802,1),(2803,1),(2804,1),(2805,1),(2806,1),(2807,1),(2808,1),(2809,1),(2810,1),(2811,1),(2812,1),(2813,1),(2814,1),(2815,1),(2816,1),(2817,1),(2818,1),(2819,1),(2820,1),(2821,1),(2822,1),(2823,1),(2824,1),(2825,1),(2826,1),(2827,1),(2828,1),(2829,1),(2830,1),(2831,1),(2832,1),(2833,1),(2834,1),(2835,1),(2836,1),(2837,1),(2838,1),(2839,1),(2840,1),(2841,1),(2842,1),(2843,1),(2844,1),(2845,1),(2846,1),(2847,1),(2848,1),(2849,1),(2850,1),(2851,1),(2852,1),(2853,1),(2854,1),(2855,1),(2856,1),(2857,1),(2858,1),(2859,1),(2860,1),(2861,1),(2862,1),(2863,1),(2864,1),(2865,1),(2866,1),(2867,1),(2868,1),(2869,1),(2870,1),(2871,1),(2873,1),(2874,1),(2875,1),(2876,1),(2877,1),(2878,1),(2879,1),(2880,1),(2881,1),(2882,1),(2883,1),(2884,1),(2885,1),(2886,1),(2887,1),(2888,1),(2889,1),(2890,1),(2891,1),(2892,1),(2893,1),(2894,1),(2895,1),(2896,1),(2897,1),(2899,1),(2900,1),(2901,1),(2902,1),(2903,1),(2904,1),(2905,1),(2906,1),(2907,1),(2908,1),(2909,1),(2910,1),(2911,1),(2912,1),(2913,1),(2914,1),(2915,1),(2916,1),(2917,1),(2918,1),(2919,1),(2920,1),(2921,1),(2922,1),(2923,1),(2924,1),(2925,1),(2926,1),(2927,1),(2928,1),(2929,1),(2930,1),(2931,1),(2932,1),(2933,1),(2934,1),(2935,1),(2936,1),(2937,1),(2938,1),(2939,1),(2940,1),(2941,1),(2942,1),(2943,1),(2944,1),(2945,1),(2946,1),(2947,1),(2948,1),(2949,1),(2950,1),(2951,1),(2952,1),(2953,1),(2954,1),(2955,1),(2956,1),(2957,1),(2958,1),(2959,1),(2960,1),(2962,1),(2963,1),(2964,1),(2965,1),(2966,1),(2967,1),(2968,1),(2969,1),(2970,1),(2971,1),(2972,1),(2973,1),(2974,1),(2975,1),(2976,1),(2977,1),(2979,1),(2980,1),(2981,1),(2982,1),(2983,1),(2984,1),(2985,1),(2986,1),(2987,1),(2988,1),(2989,1),(2991,1),(2992,1),(2993,1),(2994,1),(2995,1),(2996,1),(2997,1),(2998,1),(2999,1),(3000,1),(3001,1),(3002,1),(3003,1),(3004,1),(3005,1),(3006,1),(3007,1),(3008,1),(3009,1),(3010,1),(3011,1),(3012,1),(3013,1),(3014,1),(3015,1),(3016,1),(3017,1),(3018,1),(3019,1),(3020,1),(3021,1),(3022,1),(3023,1),(3024,1),(3025,1),(3026,1),(3027,1),(3028,1),(3029,1),(3030,1),(3031,1),(3032,1),(3033,1),(3034,1),(3035,1),(3036,1),(3037,1),(3038,1),(3039,1),(3040,1),(3041,1),(3042,1),(3043,1),(3044,1),(3045,1),(3046,1),(3047,1),(3048,1),(3049,1),(3050,1),(3051,1),(3052,1),(3053,1),(3054,1),(3055,1),(3056,1),(3057,1),(3058,1),(3059,1),(3060,1),(3061,1),(3062,1),(3063,1),(3064,1),(3065,1),(3066,1),(3067,1),(3068,1),(3069,1),(3070,1),(3071,1),(3072,1),(3073,1),(3074,1),(3075,1),(3076,1),(3077,1),(3078,1),(3079,1),(3080,1),(3081,1),(3082,1),(3083,1),(3084,1),(3085,1),(3086,1),(3087,1),(3088,1),(3089,1),(3090,1),(3091,1),(3092,1),(3093,1),(3094,1),(3095,1),(3096,1),(3098,1),(3099,1),(3100,1),(3101,1),(3102,1),(3103,1),(3104,1),(3105,1),(3106,1),(3107,1),(3108,1),(3109,1),(3110,1),(3111,1),(3112,1),(3113,1),(3114,1),(3115,1),(3116,1),(3117,1),(3118,1),(3119,1),(3120,1),(3121,1),(3122,1),(3123,1),(3124,1),(3125,1),(3126,1),(3127,1),(3128,1),(3129,1),(3130,1),(3131,1),(3132,1),(3133,1),(3134,1),(3135,1),(3136,1),(3137,1),(3139,1),(3140,1),(3141,1),(3142,1),(3143,1),(3144,1),(3146,1),(3147,1),(3148,1),(3149,1),(3150,1),(3151,1),(3152,1),(3153,1),(3154,1),(3155,1),(3156,1),(3157,1),(3158,1),(3159,1),(3160,1),(3161,1),(3162,1),(3163,1),(3164,1),(3165,1),(3166,1),(3167,1),(3168,1),(3169,1),(3170,1),(3172,1),(3173,1),(3174,1),(3175,1),(3176,1),(3177,1),(3178,1),(3179,1),(3180,1),(3181,1),(3182,1),(3183,1),(3184,1),(3185,1),(3187,1),(3188,1),(3189,1),(3190,1),(3191,1),(3192,1),(3193,1),(3194,1),(3195,1),(3196,1),(3197,1),(3198,1),(3199,1),(3200,1),(3201,1),(3202,1),(3203,1),(3204,1),(3205,1),(3206,1),(3207,1),(3208,1),(3209,1),(3210,1),(3211,1),(3212,1),(3213,1),(3214,1),(3215,1),(3216,1),(3217,1),(3218,1),(3219,1),(3220,1),(3221,1),(3222,1),(3223,1),(3224,1),(3225,1),(3226,1),(3227,1),(3229,1),(3230,1),(3231,1),(3232,1),(3233,1),(3234,1),(3235,1),(3236,1),(3237,1),(3238,1),(3239,1),(3240,1),(3241,1),(3242,1),(3243,1),(3244,1),(3245,1),(3246,1),(3247,1),(3248,1),(3249,1),(3250,1),(3251,1),(3252,1),(3253,1),(3254,1),(3255,1),(3256,1),(3257,1),(3258,1),(3259,1),(3260,1),(3261,1),(3262,1),(3263,1),(3264,1),(3265,1),(3266,1),(3267,1),(3268,1),(3269,1),(3270,1),(3271,1),(3272,1),(3273,1),(3274,1),(3275,1),(3276,1),(3277,1),(3278,1),(3279,1),(3280,1),(3281,1),(3282,1),(3283,1),(3284,1),(3285,1),(3286,1),(3287,1),(3288,1),(3289,1),(3290,1),(3291,1),(3292,1),(3293,1),(3294,1),(3295,1),(3296,1),(3297,1),(3298,1),(3299,1),(3300,1),(3301,1),(3302,1),(3303,1),(3304,1),(3305,1),(3306,1),(3307,1),(3308,1),(3309,1),(3310,1),(3311,1),(3312,1),(3313,1),(3314,1),(3315,1),(3316,1),(3317,1),(3318,1),(3319,1),(3320,1),(3321,1),(3322,1),(3323,1),(3324,1),(3325,1),(3326,1),(3327,1),(3328,1),(3329,1),(3330,1),(3331,1),(3332,1),(3333,1),(3334,1),(3335,1),(3336,1),(3337,1),(3338,1),(3339,1),(3340,1),(3341,1),(3342,1),(3343,1),(3344,1),(3345,1),(3346,1),(3347,1),(3348,1),(3349,1),(3350,1),(3351,1),(3352,1),(3353,1),(3354,1),(3355,1),(3356,1),(3357,1),(3358,1),(3359,1),(3360,1),(3361,1),(3362,1),(3363,1),(3364,1),(3365,1),(3366,1),(3367,1),(3368,1),(3369,1),(3370,1),(3371,1),(3373,1),(3374,1),(3375,1),(3376,1),(3377,1),(3378,1),(3379,1),(3380,1),(3381,1),(3382,1),(3383,1),(3384,1),(3385,1),(3386,1),(3387,1),(3388,1),(3389,1),(3390,1),(3391,1),(3392,1),(3393,1),(3394,1),(3395,1),(3396,1),(3398,1),(3400,1),(3401,1),(3402,1),(3403,1),(3405,1),(3406,1),(3407,1),(3408,1),(3409,1),(3410,1),(3411,1),(3412,1),(3413,1),(3414,1),(3415,1),(3416,1),(3417,1),(3418,1),(3419,1),(3420,1),(3421,1),(3422,1),(3423,1),(3424,1),(3425,1),(3426,1),(3427,1),(3428,1),(3429,1),(3430,1),(3431,1),(3432,1),(3433,1),(3434,1),(3435,1),(3436,1),(3437,1),(3438,1),(3439,1),(3440,1),(3441,1),(3442,1),(3443,1),(3444,1),(3445,1),(3446,1),(3447,1),(3448,1),(3449,1),(3450,1),(3451,1),(3452,1),(3453,1),(3454,1),(3455,1),(3456,1),(3457,1),(3458,1),(3459,1),(3460,1),(3461,1),(3462,1),(3463,1),(3464,1),(3465,1),(3466,1),(3467,1),(3468,1),(3469,1),(3470,1),(3471,1),(3472,1),(3473,1),(3474,1),(3475,1),(3476,1),(3477,1),(3478,1),(3479,1),(3480,1),(3481,1),(3482,1),(3483,1),(3484,1),(3485,1),(3486,1),(3487,1),(3488,1),(3489,1),(3490,1),(3491,1),(3492,1),(3493,1),(3228,1),(3494,1),(3495,1),(1,3),(2,3),(3,3),(4,3),(5,3),(6,3),(7,3),(8,3),(9,3),(10,3),(11,3),(12,3),(13,3),(14,3),(15,3),(16,3),(17,3),(18,3),(19,3),(20,3),(21,3),(22,3),(23,3),(24,3),(25,3),(26,3),(27,3),(28,3),(29,3),(30,3),(31,3),(32,3),(33,3),(34,3),(35,3),(36,3),(37,3),(38,3),(39,3),(40,3),(41,3),(42,3),(43,3),(44,3),(45,3),(46,3),(47,3),(48,3),(49,3),(50,3),(51,3),(52,3),(53,3),(54,3),(55,3),(56,3),(57,3),(58,3),(59,3),(60,3),(61,3),(62,3),(63,3),(64,3),(65,3),(66,3),(67,3),(68,3),(69,3),(70,3),(71,3),(72,3),(73,3),(74,3),(75,3),(76,3),(77,3),(78,3),(79,3),(80,3),(81,3),(82,3),(83,3),(84,3),(85,3),(86,3),(87,3),(88,3),(89,3),(90,3),(91,3),(92,3),(93,3),(94,3),(95,3),(96,3),(97,3),(98,3),(99,3),(100,3),(101,3),(102,3),(103,3),(104,3),(105,3),(106,3),(107,3),(108,3),(109,3),(110,3),(111,3),(112,3),(113,3),(114,3),(115,3),(116,3),(117,3),(118,3),(119,3),(120,3),(121,3),(122,3),(123,3),(124,3),(125,3),(126,3),(127,3),(128,3),(129,3),(130,3),(131,3),(132,3),(133,3),(134,3),(135,3),(136,3),(137,3),(138,3),(139,3),(140,3),(141,3),(142,3),(143,3),(144,3),(145,3),(146,3),(147,3),(148,3),(149,3),(150,3),(151,3),(152,3),(153,3),(154,3),(155,3),(156,3),(157,3),(158,3),(159,3),(160,3),(161,3),(162,3),(163,3),(164,3),(165,3),(166,3),(167,3),(168,3),(169,3),(170,3),(171,3),(172,3),(173,3),(174,3),(175,3),(176,3),(177,3),(178,3),(179,3),(180,3),(181,3),(182,3),(183,3),(184,3),(185,3),(186,3),(187,3),(188,3),(189,3),(190,3),(191,3),(192,3),(193,3),(194,3),(195,3),(196,3),(197,3),(198,3),(199,3),(200,3),(201,3),(202,3),(203,3),(204,3),(205,3),(206,3),(207,3),(208,3),(209,3),(210,3),(211,3),(212,3),(213,3),(214,3),(215,3),(216,3),(217,3),(218,3),(219,3),(220,3),(221,3),(222,3),(223,3),(224,3),(225,3),(226,3),(227,3),(228,3),(229,3),(230,3),(231,3),(232,3),(233,3),(234,3),(235,3),(236,3),(237,3),(238,3),(239,3),(240,3),(241,3),(242,3),(243,3),(244,3),(245,3),(246,3),(247,3),(248,3),(249,3),(250,3),(251,3),(252,3),(253,3),(254,3),(255,3),(256,3),(257,3),(258,3),(259,3),(260,3),(261,3),(262,3),(263,3),(264,3),(265,3),(266,3),(267,3),(268,3),(269,3),(270,3),(271,3),(272,3),(273,3),(274,3),(275,3),(276,3),(277,3),(278,3),(279,3),(280,3),(281,3),(282,3),(283,3),(284,3),(285,3),(286,3),(287,3),(288,3),(289,3),(290,3),(291,3),(292,3),(293,3),(294,3),(295,3),(296,3),(297,3),(298,3),(299,3),(300,3),(301,3),(302,3),(303,3),(304,3),(305,3),(306,3),(307,3),(308,3),(309,3),(310,3),(311,3),(312,3),(313,3),(314,3),(315,3),(316,3),(317,3),(318,3),(319,3),(320,3),(321,3),(322,3),(323,3),(324,3),(325,3),(326,3),(327,3),(328,3),(329,3),(330,3),(331,3),(332,3),(333,3),(334,3),(335,3),(336,3),(337,3),(338,3),(339,3),(340,3),(341,3),(342,3),(343,3),(344,3),(345,3),(346,3),(347,3),(348,3),(349,3),(350,3),(351,3),(352,3),(353,3),(354,3),(355,3),(356,3),(357,3),(358,3),(359,3),(360,3),(361,3),(362,3),(363,3),(364,3),(365,3),(366,3),(367,3),(368,3),(369,3),(370,3),(371,3),(372,3),(373,3),(374,3),(375,3),(376,3),(377,3),(378,3),(379,3),(380,3),(381,3),(382,3),(383,3),(384,3),(385,3),(386,3),(387,3),(388,3),(389,3),(390,3),(391,3),(392,3),(393,3),(394,3),(395,3),(396,3),(397,3),(398,3),(399,3),(400,3),(401,3),(402,3),(403,3),(404,3),(405,3),(406,3),(407,3),(408,3),(409,3),(410,3),(411,3),(412,3),(413,3),(414,3),(415,3),(416,3),(417,3),(418,3),(419,3),(420,3),(421,3),(422,3),(423,3),(424,3),(425,3),(426,3),(427,3),(428,3),(429,3),(430,3),(431,3),(432,3),(433,3),(434,3),(435,3),(436,3),(437,3),(438,3),(439,3),(440,3),(441,3),(442,3),(443,3),(444,3),(445,3),(446,3),(447,3),(448,3),(449,3),(450,3),(451,3),(452,3),(453,3),(454,3),(455,3),(456,3),(457,3),(458,3),(459,3),(460,3),(461,3),(462,3),(463,3),(464,3),(465,3),(466,3),(467,3),(468,3),(469,3),(470,3),(471,3),(472,3),(473,3),(474,3),(475,3),(476,3),(477,3),(478,3),(479,3),(480,3),(481,3),(482,3),(483,3),(484,3),(485,3),(486,3),(487,3),(488,3),(489,3),(490,3),(491,3),(492,3),(493,3),(494,3),(495,3),(496,3),(497,3),(498,3),(499,3),(500,3),(501,3),(502,3),(503,3),(504,3),(505,3),(506,3),(507,3),(508,3),(509,3),(510,3),(511,3),(512,3),(513,3),(514,3),(515,3),(516,3),(517,3),(518,3),(519,3),(520,3),(521,3),(522,3),(523,3),(524,3),(525,3),(526,3),(527,3),(528,3),(529,3),(530,3),(531,3),(532,3),(533,3),(534,3),(535,3),(536,3),(537,3),(538,3),(539,3),(540,3),(541,3),(542,3),(543,3),(544,3),(545,3),(546,3),(547,3),(548,3),(549,3),(550,3),(551,3),(552,3),(553,3),(554,3),(555,3),(556,3),(557,3),(558,3),(559,3),(560,3),(561,3),(562,3),(563,3),(564,3),(565,3),(566,3),(567,3),(568,3),(569,3),(570,3),(571,3),(572,3),(573,3),(574,3),(575,3),(576,3),(577,3),(578,3),(579,3),(580,3),(581,3),(582,3),(583,3),(584,3),(585,3),(586,3),(587,3),(588,3),(589,3),(590,3),(591,3),(592,3),(593,3),(594,3),(595,3),(596,3),(597,3),(598,3),(599,3),(600,3),(601,3),(602,3),(603,3),(604,3),(605,3),(606,3),(607,3),(608,3),(609,3),(610,3),(611,3),(612,3),(613,3),(614,3),(615,3),(616,3),(617,3),(618,3),(619,3),(620,3),(621,3),(622,3),(623,3),(624,3),(625,3),(626,3),(627,3),(628,3),(629,3),(630,3),(631,3),(632,3),(633,3),(634,3),(635,3),(636,3),(637,3),(638,3),(639,3),(640,3),(641,3),(642,3),(643,3),(644,3),(645,3),(646,3),(647,3),(648,3),(649,3),(650,3),(651,3),(652,3),(653,3),(654,3),(655,3),(656,3),(657,3),(658,3),(659,3),(660,3),(661,3),(662,3),(663,3),(664,3),(665,3),(666,3),(667,3),(668,3),(669,3),(670,3),(671,3),(672,3),(673,3),(674,3),(675,3),(676,3),(677,3),(678,3),(679,3),(680,3),(681,3),(682,3),(683,3),(684,3),(685,3),(686,3),(687,3),(688,3),(689,3),(690,3),(691,3),(692,3),(693,3),(694,3),(695,3),(696,3),(697,3),(698,3),(699,3),(700,3),(701,3),(702,3),(703,3),(704,3),(705,3),(706,3),(707,3),(708,3),(709,3),(710,3),(711,3),(712,3),(713,3),(714,3),(715,3),(716,3),(717,3),(718,3),(719,3),(720,3),(721,3),(722,3),(723,3),(724,3),(725,3),(726,3),(727,3),(728,3),(729,3),(730,3),(731,3),(732,3),(733,3),(734,3),(735,3),(736,3),(737,3),(738,3),(739,3),(740,3),(741,3),(742,3),(743,3),(744,3),(745,3),(746,3),(747,3),(748,3),(749,3),(750,3),(751,3),(752,3),(753,3),(754,3),(755,3),(756,3),(757,3),(758,3),(759,3),(760,3),(761,3),(762,3),(763,3),(764,3),(765,3),(766,3),(767,3),(768,3),(769,3),(770,3),(771,3),(772,3),(773,3),(774,3),(775,3),(776,3),(777,3),(778,3),(779,3),(780,3),(781,3),(782,3),(783,3),(784,3),(785,3),(786,3),(787,3),(788,3),(789,3),(790,3),(791,3),(792,3),(793,3),(794,3),(795,3),(796,3),(797,3),(798,3),(799,3),(800,3),(801,3),(802,3),(803,3),(804,3),(805,3),(806,3),(807,3),(808,3),(809,3),(810,3),(811,3),(812,3),(813,3),(814,3),(815,3),(816,3),(817,3),(818,3),(819,3),(820,3),(821,3),(822,3),(823,3),(824,3),(825,3),(826,3),(827,3),(828,3),(829,3),(830,3),(831,3),(832,3),(833,3),(834,3),(835,3),(836,3),(837,3),(838,3),(839,3),(840,3),(841,3),(842,3),(843,3),(844,3),(845,3),(846,3),(847,3),(848,3),(849,3),(850,3),(851,3),(852,3),(853,3),(854,3),(855,3),(856,3),(857,3),(858,3),(859,3),(860,3),(861,3),(862,3),(863,3),(864,3),(865,3),(866,3),(867,3),(868,3),(869,3),(870,3),(871,3),(872,3),(873,3),(874,3),(875,3),(876,3),(877,3),(878,3),(879,3),(880,3),(881,3),(882,3),(883,3),(884,3),(885,3),(886,3),(887,3),(888,3),(889,3),(890,3),(891,3),(892,3),(893,3),(894,3),(895,3),(896,3),(897,3),(898,3),(899,3),(900,3),(901,3),(902,3),(903,3),(904,3),(905,3),(906,3),(907,3),(908,3),(909,3),(910,3),(911,3),(912,3),(913,3),(914,3),(915,3),(916,3),(917,3),(918,3),(919,3),(920,3),(921,3),(922,3),(923,3),(924,3),(925,3),(926,3),(927,3),(928,3),(929,3),(930,3),(931,3),(932,3),(933,3),(934,3),(935,3),(936,3),(937,3),(938,3),(939,3),(940,3),(941,3),(942,3),(943,3),(944,3),(945,3),(946,3),(947,3),(948,3),(949,3),(950,3),(951,3),(952,3),(953,3),(954,3),(955,3),(956,3),(957,3),(958,3),(959,3),(960,3),(961,3),(962,3),(963,3),(964,3),(965,3),(966,3),(967,3),(968,3),(969,3),(970,3),(971,3),(972,3),(973,3),(974,3),(975,3),(976,3),(977,3),(978,3),(979,3),(980,3),(981,3),(982,3),(983,3),(984,3),(985,3),(986,3),(987,3),(988,3),(989,3),(990,3),(991,3),(992,3),(993,3),(994,3),(995,3),(996,3),(997,3),(998,3),(999,3),(1000,3),(1001,3),(1002,3),(1003,3),(1004,3),(1005,3),(1006,3),(1007,3),(1008,3),(1009,3),(1010,3),(1011,3),(1012,3),(1013,3),(1014,3),(1015,3),(1016,3),(1017,3),(1018,3),(1019,3),(1020,3),(1021,3),(1022,3),(1023,3),(1024,3),(1025,3),(1026,3),(1027,3),(1028,3),(1029,3),(1030,3),(1031,3),(1032,3),(1033,3),(1034,3),(1035,3),(1036,3),(1037,3),(1038,3),(1039,3),(1040,3),(1041,3),(1042,3),(1043,3),(1044,3),(1045,3),(1046,3),(1047,3),(1048,3),(1049,3),(1050,3),(1051,3),(1052,3),(1053,3),(1054,3),(1055,3),(1056,3),(1057,3),(1058,3),(1059,3),(1060,3),(1061,3),(1062,3),(1063,3),(1064,3),(1065,3),(1066,3),(1067,3),(1068,3),(1069,3),(1070,3),(1071,3),(1072,3),(1073,3),(1074,3),(1075,3),(1076,3),(1077,3),(1078,3),(1079,3),(1080,3),(1081,3),(1082,3),(1083,3),(1084,3),(1085,3),(1086,3),(1087,3),(1088,3),(1089,3),(1090,3),(1091,3),(1092,3),(1093,3),(1094,3),(1095,3),(1096,3),(1097,3),(1098,3),(1099,3),(1100,3),(1101,3),(1102,3),(1103,3),(1104,3),(1105,3),(1106,3),(1107,3),(1108,3),(1109,3),(1110,3),(1111,3),(1112,3),(1113,3),(1114,3),(1115,3),(1116,3),(1117,3),(1118,3),(1119,3),(1120,3),(1121,3),(1122,3),(1123,3),(1124,3),(1125,3),(1126,3),(1127,3),(1128,3),(1129,3),(1130,3),(1131,3),(1132,3),(1133,3),(1134,3),(1135,3),(1136,3),(1137,3),(1138,3),(1139,3),(1140,3),(1141,3),(1142,3),(1143,3),(1144,3),(1145,3),(1146,3),(1147,3),(1148,3),(1149,3),(1150,3),(1151,3),(1152,3),(1153,3),(1154,3),(1155,3),(1156,3),(1157,3),(1158,3),(1159,3),(1160,3),(1161,3),(1162,3),(1163,3),(1164,3),(1165,3),(1166,3),(1167,3),(1168,3),(1169,3),(1170,3),(1171,3),(1172,3),(1173,3),(1174,3),(1175,3),(1176,3),(1177,3),(1178,3),(1179,3),(1180,3),(1181,3),(1182,3),(1183,3),(1184,3),(1185,3),(1186,3),(1187,3),(1188,3),(1189,3),(1190,3),(1191,3),(1192,3),(1193,3),(1194,3),(1195,3),(1196,3),(1197,3),(1198,3),(1199,3),(1200,3),(1201,3),(1202,3),(1203,3),(1204,3),(1205,3),(1206,3),(1207,3),(1208,3),(1209,3),(1210,3),(1211,3),(1212,3),(1213,3),(1214,3),(1215,3),(1216,3),(1217,3),(1218,3),(1219,3),(1220,3),(1221,3),(1222,3),(1223,3),(1224,3),(1225,3),(1226,3),(1227,3),(1228,3),(1229,3),(1230,3),(1231,3),(1232,3),(1233,3),(1234,3),(1235,3),(1236,3),(1237,3),(1238,3),(1239,3),(1240,3),(1241,3),(1242,3),(1243,3),(1244,3),(1245,3),(1246,3),(1247,3),(1248,3),(1249,3),(1250,3),(1251,3),(1252,3),(1253,3),(1254,3),(1255,3),(1256,3),(1257,3),(1258,3),(1259,3),(1260,3),(1261,3),(1262,3),(1263,3),(1264,3),(1265,3),(1266,3),(1267,3),(1268,3),(1269,3),(1270,3),(1271,3),(1272,3),(1273,3),(1274,3),(1275,3),(1276,3),(1277,3),(1278,3),(1279,3),(1280,3),(1281,3),(1282,3),(1283,3),(1284,3),(1285,3),(1286,3),(1287,3),(1288,3),(1289,3),(1290,3),(1291,3),(1292,3),(1293,3),(1294,3),(1295,3),(1296,3),(1297,3),(1298,3),(1299,3),(1300,3),(1301,3),(1302,3),(1303,3),(1304,3),(1305,3),(1306,3),(1307,3),(1308,3),(1309,3),(1310,3),(1311,3),(1312,3),(1313,3),(1314,3),(1315,3),(1316,3),(1317,3),(1318,3),(1319,3),(1320,3),(1321,3),(1322,3),(1323,3),(1324,3),(1325,3),(1326,3),(1327,3),(1328,3),(1329,3),(1330,3),(1331,3),(1332,3),(1333,3),(1334,3),(1335,3),(1336,3),(1337,3),(1338,3),(1339,3),(1340,3),(1341,3),(1342,3),(1343,3),(1344,3),(1345,3),(1346,3),(1347,3),(1348,3),(1349,3),(1350,3),(1351,3),(1352,3),(1353,3),(1354,3),(1355,3),(1356,3),(1357,3),(1358,3),(1359,3),(1360,3),(1361,3),(1362,3),(1363,3),(1364,3),(1365,3),(1366,3),(1367,3),(1368,3),(1369,3),(1370,3),(1371,3),(1372,3),(1373,3),(1374,3),(1375,3),(1376,3),(1377,3),(1378,3),(1379,3),(1380,3),(1381,3),(1382,3),(1383,3),(1384,3),(1385,3),(1386,3),(1387,3),(1388,3),(1389,3),(1390,3),(1391,3),(1392,3),(1393,3),(1394,3),(1395,3),(1396,3),(1397,3),(1398,3),(1399,3),(1400,3),(1401,3),(1402,3),(1403,3),(1404,3),(1405,3),(1406,3),(1407,3),(1408,3),(1409,3),(1410,3),(1411,3),(1412,3),(1413,3),(1414,3),(1415,3),(1416,3),(1417,3),(1418,3),(1419,3),(1420,3),(1421,3),(1422,3),(1423,3),(1424,3),(1425,3),(1426,3),(1427,3),(1428,3),(1429,3),(1430,3),(1431,3),(1432,3),(1433,3),(1434,3),(1435,3),(1436,3),(1437,3),(1438,3),(1439,3),(1440,3),(1441,3),(1442,3),(1443,3),(1444,3),(1445,3),(1446,3),(1447,3),(1448,3),(1449,3),(1450,3),(1451,3),(1452,3),(1453,3),(1454,3),(1455,3),(1456,3),(1457,3),(1458,3),(1459,3),(1460,3),(1461,3),(1462,3),(1463,3),(1464,3),(1465,3),(1466,3),(1467,3),(1468,3),(1469,3),(1470,3),(1471,3),(1472,3),(1473,3),(1474,3),(1475,3),(1476,3),(1477,3),(1478,3),(1479,3),(1480,3),(1481,3),(1482,3),(1483,3),(1484,3),(1485,3),(1486,3),(1487,3),(1488,3),(1489,3),(1490,3),(1491,3),(1492,3),(1493,3),(1494,3),(1495,3),(1496,3),(1497,3),(1498,3),(1499,3),(1500,3),(1501,3),(1502,3),(1503,3),(1504,3),(1505,3),(1506,3),(1507,3),(1508,3),(1509,3),(1510,3),(1511,3),(1512,3),(1513,3),(1514,3),(1515,3),(1516,3),(1517,3),(1518,3),(1519,3),(1520,3),(1521,3),(1522,3),(1523,3),(1524,3),(1525,3),(1526,3),(1527,3),(1528,3),(1529,3),(1530,3),(1531,3),(1532,3),(1533,3),(1534,3),(1535,3),(1536,3),(1537,3),(1538,3),(1539,3),(1540,3),(1541,3),(1542,3),(1543,3),(1544,3),(1545,3),(1546,3),(1547,3),(1548,3),(1549,3),(1550,3),(1551,3),(1552,3),(1553,3),(1554,3),(1555,3),(1556,3),(1557,3),(1558,3),(1559,3),(1560,3),(1561,3),(1562,3),(1563,3),(1564,3),(1565,3),(1566,3),(1567,3),(1568,3),(1569,3),(1570,3),(1571,3),(1572,3),(1573,3),(1574,3),(1575,3),(1576,3),(1577,3),(1578,3),(1579,3),(1580,3),(1581,3),(1582,3),(1583,3),(1584,3),(1585,3),(1586,3),(1587,3),(1588,3),(1589,3),(1590,3),(1591,3),(1592,3),(1593,3),(1594,3),(1595,3),(1596,3),(1597,3),(1598,3),(1599,3),(1600,3),(1601,3),(1602,3),(1603,3),(1604,3),(1605,3),(1606,3),(1607,3),(1608,3),(1609,3),(1610,3),(1611,3),(1612,3),(1613,3),(1614,3),(1615,3),(1616,3),(1617,3),(1618,3),(1619,3),(1620,3),(1621,3),(1622,3),(1623,3),(1624,3),(1625,3),(1626,3),(1627,3),(1628,3),(1629,3),(1630,3),(1631,3),(1632,3),(1633,3),(1634,3),(1635,3),(1636,3),(1637,3),(1638,3),(1639,3),(1640,3),(1641,3),(1642,3),(1643,3),(1644,3),(1645,3),(1646,3),(1647,3),(1648,3),(1649,3),(1650,3),(1651,3),(1652,3),(1653,3),(1654,3),(1655,3),(1656,3),(1657,3),(1658,3),(1659,3),(1660,3),(1661,3),(1662,3),(1663,3),(1664,3),(1665,3),(1666,3),(1667,3),(1668,3),(1669,3),(1670,3),(1671,3),(1672,3),(1673,3),(1674,3),(1675,3),(1676,3),(1677,3),(1678,3),(1679,3),(1680,3),(1681,3),(1682,3),(1683,3),(1684,3),(1685,3),(1686,3),(1687,3),(1688,3),(1689,3),(1690,3),(1691,3),(1692,3),(1693,3),(1694,3),(1695,3),(1696,3),(1697,3),(1698,3),(1699,3),(1700,3),(1701,3),(1702,3),(1703,3),(1704,3),(1705,3),(1706,3),(1707,3),(1708,3),(1709,3),(1710,3),(1711,3),(1712,3),(1713,3),(1714,3),(1715,3),(1716,3),(1717,3),(1718,3),(1719,3),(1720,3),(1721,3),(1722,3),(1723,3),(1724,3),(1725,3),(1726,3),(1727,3),(1728,3),(1729,3),(1730,3),(1731,3),(1732,3),(1733,3),(1734,3),(1735,3),(1736,3),(1737,3),(1738,3),(1739,3),(1740,3),(1741,3),(1742,3),(1743,3),(1744,3),(1745,3),(1746,3),(1747,3),(1748,3),(1749,3),(1750,3),(1751,3),(1752,3),(1753,3),(1754,3),(1755,3),(1756,3),(1757,3),(1758,3),(1759,3),(1760,3),(1761,3),(1762,3),(1763,3),(1764,3),(1765,3),(1766,3),(1767,3),(1768,3),(1769,3),(1770,3),(1771,3),(1772,3),(1773,3),(1774,3),(1775,3),(1776,3),(1777,3),(1778,3),(1779,3),(1780,3),(1781,3),(1782,3),(1783,3),(1784,3),(1785,3),(1786,3),(1787,3),(1788,3),(1789,3),(1790,3),(1791,3),(1792,3),(1793,3),(1794,3),(1795,3),(1796,3),(1797,3),(1798,3),(1799,3),(1800,3),(1801,3),(1802,3),(1803,3),(1804,3),(1805,3),(1806,3),(1807,3),(1808,3),(1809,3),(1810,3),(1811,3),(1812,3),(1813,3),(1814,3),(1815,3),(1816,3),(1817,3),(1818,3),(1819,3),(1820,3),(1821,3),(1822,3),(1823,3),(1824,3),(1825,3),(1826,3),(1827,3),(1828,3),(1829,3),(1830,3),(1831,3),(1832,3),(1833,3),(1834,3),(1835,3),(1836,3),(1837,3),(1838,3),(1839,3),(1840,3),(1841,3),(1842,3),(1843,3),(1844,3),(1845,3),(1846,3),(1847,3),(1848,3),(1849,3),(1850,3),(1851,3),(1852,3),(1853,3),(1854,3),(1855,3),(1856,3),(1857,3),(1858,3),(1859,3),(1860,3),(1861,3),(1862,3),(1863,3),(1864,3),(1865,3),(1866,3),(1867,3),(1868,3),(1869,3),(1870,3),(1871,3),(1872,3),(1873,3),(1874,3),(1875,3),(1876,3),(1877,3),(1878,3),(1879,3),(1880,3),(1881,3),(1882,3),(1883,3),(1884,3),(1885,3),(1886,3),(1887,3),(1888,3),(1889,3),(1890,3),(1891,3),(1892,3),(1893,3),(1894,3),(1895,3),(1896,3),(1897,3),(1898,3),(1899,3),(1900,3),(1901,3),(1902,3),(1903,3),(1904,3),(1905,3),(1906,3),(1907,3),(1908,3),(1909,3),(1910,3),(1911,3),(1912,3),(1913,3),(1914,3),(1915,3),(1916,3),(1917,3),(1918,3),(1919,3),(1920,3),(1921,3),(1922,3),(1923,3),(1924,3),(1925,3),(1926,3),(1927,3),(1928,3),(1929,3),(1930,3),(1931,3),(1932,3),(1933,3),(1934,3),(1935,3),(1936,3),(1937,3),(1938,3),(1939,3),(1940,3),(1941,3),(1942,3),(1943,3),(1944,3),(1945,3),(1946,3),(1947,3),(1948,3),(1949,3),(1950,3),(1951,3),(1952,3),(1953,3),(1954,3),(1955,3),(1956,3),(1957,3),(1958,3),(1959,3),(1960,3),(1961,3),(1962,3),(1963,3),(1964,3),(1965,3),(1966,3),(1967,3),(1968,3),(1969,3),(1970,3),(1971,3),(1972,3),(1973,3),(1974,3),(1975,3),(1976,3),(1977,3),(1978,3),(1979,3),(1980,3),(1981,3),(1982,3),(1983,3),(1984,3),(1985,3),(1986,3),(1987,3),(1988,3),(1989,3),(1990,3),(1991,3),(1992,3),(1993,3),(1994,3),(1995,3),(1996,3),(1997,3),(1998,3),(1999,3),(2000,3),(2001,3),(2002,3),(2003,3),(2004,3),(2005,3),(2006,3),(2007,3),(2008,3),(2009,3),(2010,3),(2011,3),(2012,3),(2013,3),(2014,3),(2015,3),(2016,3),(2017,3),(2018,3),(2019,3),(2020,3),(2021,3),(2022,3),(2023,3),(2024,3),(2025,3),(2026,3),(2027,3),(2028,3),(2029,3),(2030,3),(2031,3),(2032,3),(2033,3),(2034,3),(2035,3),(2036,3),(2037,3),(2038,3),(2039,3),(2040,3),(2041,3),(2042,3),(2043,3),(2044,3),(2045,3),(2046,3),(2047,3),(2048,3),(2049,3),(2050,3),(2051,3),(2052,3),(2053,3),(2054,3),(2055,3),(2056,3),(2057,3),(2058,3),(2059,3),(2060,3),(2061,3),(2062,3),(2063,3),(2064,3),(2065,3),(2066,3),(2067,3),(2068,3),(2069,3),(2070,3),(2071,3),(2072,3),(2073,3),(2074,3),(2075,3),(2076,3),(2077,3),(2078,3),(2079,3),(2080,3),(2081,3),(2082,3),(2083,3),(2084,3),(2085,3),(2086,3),(2087,3),(2088,3),(2089,3),(2090,3),(2091,3),(2092,3),(2093,3),(2094,3),(2095,3),(2096,3),(2097,3),(2098,3),(2099,3),(2100,3),(2101,3),(2102,3),(2103,3),(2104,3),(2105,3),(2106,3),(2107,3),(2108,3),(2109,3),(2110,3),(2111,3),(2112,3),(2113,3),(2114,3),(2115,3),(2116,3),(2117,3),(2118,3),(2119,3),(2120,3),(2121,3),(2122,3),(2123,3),(2124,3),(2125,3),(2126,3),(2127,3),(2128,3),(2129,3),(2130,3),(2131,3),(2132,3),(2133,3),(2134,3),(2135,3),(2136,3),(2137,3),(2138,3),(2139,3),(2140,3),(2141,3),(2142,3),(2143,3),(2144,3),(2145,3),(2146,3),(2147,3),(2148,3),(2149,3),(2150,3),(2151,3),(2152,3),(2153,3),(2154,3),(2155,3),(2156,3),(2157,3),(2158,3),(2159,3),(2160,3),(2161,3),(2162,3),(2163,3),(2164,3),(2165,3),(2166,3),(2167,3),(2168,3),(2169,3),(2170,3),(2171,3),(2172,3),(2173,3),(2174,3),(2175,3),(2176,3),(2177,3),(2178,3),(2179,3),(2180,3),(2181,3),(2182,3),(2183,3),(2184,3),(2185,3),(2186,3),(2187,3),(2188,3),(2189,3),(2190,3),(2191,3),(2192,3),(2193,3),(2194,3),(2195,3),(2196,3),(2197,3),(2198,3),(2199,3),(2200,3),(2201,3),(2202,3),(2203,3),(2204,3),(2205,3),(2206,3),(2207,3),(2208,3),(2209,3),(2210,3),(2211,3),(2212,3),(2213,3),(2214,3),(2215,3),(2216,3),(2217,3),(2218,3),(2219,3),(2220,3),(2221,3),(2222,3),(2223,3),(2224,3),(2225,3),(2226,3),(2227,3),(2228,3),(2229,3),(2230,3),(2231,3),(2232,3),(2233,3),(2234,3),(2235,3),(2236,3),(2237,3),(2238,3),(2239,3),(2240,3),(2241,3),(2242,3),(2243,3),(2244,3),(2245,3),(2246,3),(2247,3),(2248,3),(2249,3),(2250,3),(2251,3),(2252,3),(2253,3),(2254,3),(2255,3),(2256,3),(2257,3),(2258,3),(2259,3),(2260,3),(2261,3),(2262,3),(2263,3),(2264,3),(2265,3),(2266,3),(2267,3),(2268,3),(2269,3),(2270,3),(2271,3),(2272,3),(2273,3),(2274,3),(2275,3),(2276,3),(2277,3),(2278,3),(2279,3),(2280,3),(2281,3),(2282,3),(2283,3),(2284,3),(2285,3),(2286,3),(2287,3),(2288,3),(2289,3),(2290,3),(2291,3),(2292,3),(2293,3),(2294,3),(2295,3),(2296,3),(2297,3),(2298,3),(2299,3),(2300,3),(2301,3),(2302,3),(2303,3),(2304,3),(2305,3),(2306,3),(2307,3),(2308,3),(2309,3),(2310,3),(2311,3),(2312,3),(2313,3),(2314,3),(2315,3),(2316,3),(2317,3),(2318,3),(2319,3),(2320,3),(2321,3),(2322,3),(2323,3),(2324,3),(2325,3),(2326,3),(2327,3),(2328,3),(2329,3),(2330,3),(2331,3),(2332,3),(2333,3),(2334,3),(2335,3),(2336,3),(2337,3),(2338,3),(2339,3),(2340,3),(2341,3),(2342,3),(2343,3),(2344,3),(2345,3),(2346,3),(2347,3),(2348,3),(2349,3),(2350,3),(2351,3),(2352,3),(2353,3),(2354,3),(2355,3),(2356,3),(2357,3),(2358,3),(2359,3),(2360,3),(2361,3),(2362,3),(2363,3),(2364,3),(2365,3),(2366,3),(2367,3),(2368,3),(2369,3),(2370,3),(2371,3),(2372,3),(2373,3),(2374,3),(2375,3),(2376,3),(2377,3),(2378,3),(2379,3),(2380,3),(2381,3),(2382,3),(2383,3),(2384,3),(2385,3),(2386,3),(2387,3),(2388,3),(2389,3),(2390,3),(2391,3),(2392,3),(2393,3),(2394,3),(2395,3),(2396,3),(2397,3),(2398,3),(2399,3),(2400,3),(2401,3),(2402,3),(2403,3),(2404,3),(2405,3),(2406,3),(2407,3),(2408,3),(2409,3),(2410,3),(2411,3),(2412,3),(2413,3),(2414,3),(2415,3),(2416,3),(2417,3),(2418,3),(2419,3),(2420,3),(2421,3),(2422,3),(2423,3),(2424,3),(2425,3),(2426,3),(2427,3),(2428,3),(2429,3),(2430,3),(2431,3),(2432,3),(2433,3),(2434,3),(2435,3),(2436,3),(2437,3),(2438,3),(2439,3),(2440,3),(2441,3),(2442,3),(2443,3),(2444,3),(2445,3),(2446,3),(2447,3),(2448,3),(2449,3),(2450,3),(2451,3),(2452,3),(2453,3),(2454,3),(2455,3),(2456,3),(2457,3),(2458,3),(2459,3),(2460,3),(2461,3),(2462,3),(2463,3),(2464,3),(2465,3),(2466,3),(2467,3),(2468,3),(2469,3),(2470,3),(2471,3),(2472,3),(2473,3),(2474,3),(2475,3),(2476,3),(2477,3),(2478,3),(2479,3),(2480,3),(2481,3),(2482,3),(2483,3),(2484,3),(2485,3),(2486,3),(2487,3),(2488,3),(2489,3),(2490,3),(2491,3),(2492,3),(2493,3),(2494,3),(2495,3),(2496,3),(2497,3),(2498,3),(2499,3),(2500,3),(2501,3),(2502,3),(2503,3),(2504,3),(2505,3),(2506,3),(2507,3),(2508,3),(2509,3),(2510,3),(2511,3),(2512,3),(2513,3),(2514,3),(2515,3),(2516,3),(2517,3),(2518,3),(2519,3),(2520,3),(2521,3),(2522,3),(2523,3),(2524,3),(2525,3),(2526,3),(2527,3),(2528,3),(2529,3),(2530,3),(2531,3),(2532,3),(2533,3),(2534,3),(2535,3),(2536,3),(2537,3),(2538,3),(2539,3),(2540,3),(2541,3),(2542,3),(2543,3),(2544,3),(2545,3),(2546,3),(2547,3),(2548,3),(2549,3),(2550,3),(2551,3),(2552,3),(2553,3),(2554,3),(2555,3),(2556,3),(2557,3),(2558,3),(2559,3),(2560,3),(2561,3),(2562,3),(2563,3),(2564,3),(2565,3),(2566,3),(2567,3),(2568,3),(2569,3),(2570,3),(2571,3),(2572,3),(2573,3),(2574,3),(2575,3),(2576,3),(2577,3),(2578,3),(2579,3),(2580,3),(2581,3),(2582,3),(2583,3),(2584,3),(2585,3),(2586,3),(2587,3),(2588,3),(2589,3),(2590,3),(2591,3),(2592,3),(2593,3),(2594,3),(2595,3),(2596,3),(2597,3),(2598,3),(2599,3),(2600,3),(2601,3),(2602,3),(2603,3),(2604,3),(2605,3),(2606,3),(2607,3),(2608,3),(2609,3),(2610,3),(2611,3),(2612,3),(2613,3),(2614,3),(2615,3),(2616,3),(2617,3),(2618,3),(2619,3),(2620,3),(2621,3),(2622,3),(2623,3),(2624,3),(2625,3),(2626,3),(2627,3),(2628,3),(2629,3),(2630,3),(2631,3),(2632,3),(2633,3),(2634,3),(2635,3),(2636,3),(2637,3),(2638,3),(2639,3),(2640,3),(2641,3),(2642,3),(2643,3),(2644,3),(2645,3),(2646,3),(2647,3),(2648,3),(2649,3),(2650,3),(2651,3),(2652,3),(2653,3),(2654,3),(2655,3),(2656,3),(2657,3),(2658,3),(2659,3),(2660,3),(2661,3),(2662,3),(2663,3),(2664,3),(2665,3),(2666,3),(2667,3),(2668,3),(2669,3),(2670,3),(2671,3),(2672,3),(2673,3),(2674,3),(2675,3),(2676,3),(2677,3),(2678,3),(2679,3),(2680,3),(2681,3),(2682,3),(2683,3),(2684,3),(2685,3),(2686,3),(2687,3),(2688,3),(2689,3),(2690,3),(2691,3),(2692,3),(2693,3),(2694,3),(2695,3),(2696,3),(2697,3),(2698,3),(2699,3),(2700,3),(2701,3),(2702,3),(2703,3),(2704,3),(2705,3),(2706,3),(2707,3),(2708,3),(2709,3),(2710,3),(2711,3),(2712,3),(2713,3),(2714,3),(2715,3),(2716,3),(2717,3),(2718,3),(2719,3),(2720,3),(2721,3),(2722,3),(2723,3),(2724,3),(2725,3),(2726,3),(2727,3),(2728,3),(2729,3),(2730,3),(2731,3),(2732,3),(2733,3),(2734,3),(2735,3),(2736,3),(2737,3),(2738,3),(2739,3),(2740,3),(2741,3),(2742,3),(2743,3),(2744,3),(2745,3),(2746,3),(2747,3),(2748,3),(2749,3),(2750,3),(2751,3),(2752,3),(2753,3),(2754,3),(2755,3),(2756,3),(2757,3),(2758,3),(2759,3),(2760,3),(2761,3),(2762,3),(2763,3),(2764,3),(2765,3),(2766,3),(2767,3),(2768,3),(2769,3),(2770,3),(2771,3),(2772,3),(2773,3),(2774,3),(2775,3),(2776,3),(2777,3),(2778,3),(2779,3),(2780,3),(2781,3),(2782,3),(2783,3),(2784,3),(2785,3),(2786,3),(2787,3),(2788,3),(2789,3),(2790,3),(2791,3),(2792,3),(2793,3),(2794,3),(2795,3),(2796,3),(2797,3),(2798,3),(2799,3),(2800,3),(2801,3),(2802,3),(2803,3),(2804,3),(2805,3),(2806,3),(2807,3),(2808,3),(2809,3),(2810,3),(2811,3),(2812,3),(2813,3),(2814,3),(2815,3),(2816,3),(2817,3),(2818,3),(2819,3),(2820,3),(2821,3),(2822,3),(2823,3),(2824,3),(2825,3),(2826,3),(2827,3),(2828,3),(2829,3),(2830,3),(2831,3),(2832,3),(2833,3),(2834,3),(2835,3),(2836,3),(2837,3),(2838,3),(2839,3),(2840,3),(2841,3),(2842,3),(2843,3),(2844,3),(2845,3),(2846,3),(2847,3),(2848,3),(2849,3),(2850,3),(2851,3),(2852,3),(2853,3),(2854,3),(2855,3),(2856,3),(2857,3),(2858,3),(2859,3),(2860,3),(2861,3),(2862,3),(2863,3),(2864,3),(2865,3),(2866,3),(2867,3),(2868,3),(2869,3),(2870,3),(2871,3),(2872,3),(2873,3),(2874,3),(2875,3),(2876,3),(2877,3),(2878,3),(2879,3),(2880,3),(2881,3),(2882,3),(2883,3),(2884,3),(2885,3),(2886,3),(2887,3),(2888,3),(2889,3),(2890,3),(2891,3),(2892,3),(2893,3),(2894,3),(2895,3),(2896,3),(2897,3),(2898,3),(2899,3),(2900,3),(2901,3),(2902,3),(2903,3),(2904,3),(2905,3),(2906,3),(2907,3),(2908,3),(2909,3),(2910,3),(2911,3),(2912,3),(2913,3),(2914,3),(2915,3),(2916,3),(2917,3),(2918,3),(2919,3),(2920,3),(2921,3),(2922,3),(2923,3),(2924,3),(2925,3),(2926,3),(2927,3),(2928,3),(2929,3),(2930,3),(2931,3),(2932,3),(2933,3),(2934,3),(2935,3),(2936,3),(2937,3),(2938,3),(2939,3),(2940,3),(2941,3),(2942,3),(2943,3),(2944,3),(2945,3),(2946,3),(2947,3),(2948,3),(2949,3),(2950,3),(2951,3),(2952,3),(2953,3),(2954,3),(2955,3),(2956,3),(2957,3),(2958,3),(2959,3),(2960,3),(2961,3),(2962,3),(2963,3),(2964,3),(2965,3),(2966,3),(2967,3),(2968,3),(2969,3),(2970,3),(2971,3),(2972,3),(2973,3),(2974,3),(2975,3),(2976,3),(2977,3),(2978,3),(2979,3),(2980,3),(2981,3),(2982,3),(2983,3),(2984,3),(2985,3),(2986,3),(2987,3),(2988,3),(2989,3),(2990,3),(2991,3),(2992,3),(2993,3),(2994,3),(2995,3),(2996,3),(2997,3),(2998,3),(2999,3),(3000,3),(3001,3),(3002,3),(3003,3),(3004,3),(3005,3),(3006,3),(3007,3),(3008,3),(3009,3),(3010,3),(3011,3),(3012,3),(3013,3),(3014,3),(3015,3),(3016,3),(3017,3),(3018,3),(3019,3),(3020,3),(3021,3),(3022,3),(3023,3),(3024,3),(3025,3),(3026,3),(3027,3),(3028,3),(3029,3),(3030,3),(3031,3),(3032,3),(3033,3),(3034,3),(3035,3),(3036,3),(3037,3),(3038,3),(3039,3),(3040,3),(3041,3),(3042,3),(3043,3),(3044,3),(3045,3),(3046,3),(3047,3),(3048,3),(3049,3),(3050,3),(3051,3),(3052,3),(3053,3),(3054,3),(3055,3),(3056,3),(3057,3),(3058,3),(3059,3),(3060,3),(3061,3),(3062,3),(3063,3),(3064,3),(3065,3),(3066,3),(3067,3),(3068,3),(3069,3),(3070,3),(3071,3),(3072,3),(3073,3),(3074,3),(3075,3),(3076,3),(3077,3),(3078,3),(3079,3),(3080,3),(3081,3),(3082,3),(3083,3),(3084,3),(3085,3),(3086,3),(3087,3),(3088,3),(3089,3),(3090,3),(3091,3),(3092,3),(3093,3),(3094,3),(3095,3),(3096,3),(3097,3),(3098,3),(3099,3),(3100,3),(3101,3),(3102,3),(3103,3),(3104,3),(3105,3),(3106,3),(3107,3),(3108,3),(3109,3),(3110,3),(3111,3),(3112,3),(3113,3),(3114,3),(3115,3),(3116,3),(3117,3),(3118,3),(3119,3),(3120,3),(3121,3),(3122,3),(3123,3),(3124,3),(3125,3),(3126,3),(3127,3),(3128,3),(3129,3),(3130,3),(3131,3),(3132,3),(3133,3),(3134,3),(3135,3),(3136,3),(3137,3),(3138,3),(3139,3),(3140,3),(3141,3),(3142,3),(3143,3),(3144,3),(3145,3),(3146,3),(3147,3),(3148,3),(3149,3),(3150,3),(3151,3),(3152,3),(3153,3),(3154,3),(3155,3),(3156,3),(3157,3),(3158,3),(3159,3),(3160,3),(3161,3),(3162,3),(3163,3),(3164,3),(3165,3),(3166,3),(3167,3),(3168,3),(3169,3),(3170,3),(3171,3),(3172,3),(3173,3),(3174,3),(3175,3),(3176,3),(3177,3),(3178,3),(3179,3),(3180,3),(3181,3),(3182,3),(3183,3),(3184,3),(3185,3),(3186,3),(3187,3),(3188,3),(3189,3),(3190,3),(3191,3),(3192,3),(3193,3),(3194,3),(3195,3),(3196,3),(3197,3),(3198,3),(3199,3),(3200,3),(3201,3),(3202,3),(3203,3),(3204,3),(3205,3),(3206,3),(3207,3),(3208,3),(3209,3),(3210,3),(3211,3),(3212,3),(3213,3),(3214,3),(3215,3),(3216,3),(3217,3),(3218,3),(3219,3),(3220,3),(3221,3),(3222,3),(3223,3),(3224,3),(3225,3),(3226,3),(3227,3),(3228,3),(3229,3),(3230,3),(3231,3),(3232,3),(3233,3),(3234,3),(3235,3),(3236,3),(3237,3),(3238,3),(3239,3),(3240,3),(3241,3),(3242,3),(3243,3),(3244,3),(3245,3),(3246,3),(3247,3),(3248,3),(3249,3),(3250,3),(3251,3),(3252,3),(3253,3),(3254,3),(3255,3),(3256,3),(3257,3),(3258,3),(3259,3),(3260,3),(3261,3),(3262,3),(3263,3),(3264,3),(3265,3),(3266,3),(3267,3),(3268,3),(3269,3),(3270,3),(3271,3),(3272,3),(3273,3),(3274,3),(3275,3),(3276,3),(3277,3),(3278,3),(3279,3),(3280,3),(3281,3),(3282,3),(3283,3),(3284,3),(3285,3),(3286,3),(3287,3),(3288,3),(3289,3),(3290,3),(3291,3),(3292,3),(3293,3),(3294,3),(3295,3),(3296,3),(3297,3),(3298,3),(3299,3),(3300,3),(3301,3),(3302,3),(3303,3),(3304,3),(3305,3),(3306,3),(3307,3),(3308,3),(3309,3),(3310,3),(3311,3),(3312,3),(3313,3),(3314,3),(3315,3),(3316,3),(3317,3),(3318,3),(3319,3),(3320,3),(3321,3),(3322,3),(3323,3),(3324,3),(3325,3),(3326,3),(3327,3),(3328,3),(3329,3),(3330,3),(3331,3),(3332,3),(3333,3),(3334,3),(3335,3),(3336,3),(3337,3),(3338,3),(3339,3),(3340,3),(3341,3),(3342,3),(3343,3),(3344,3),(3345,3),(3346,3),(3347,3),(3348,3),(3349,3),(3350,3),(3351,3),(3352,3),(3353,3),(3354,3),(3355,3),(3356,3),(3357,3),(3358,3),(3359,3),(3360,3),(3361,3),(3362,3),(3363,3),(3364,3),(3365,3),(3366,3),(3367,3),(3368,3),(3369,3),(3370,3),(3371,3),(3372,3),(3373,3),(3374,3),(3375,3),(3376,3),(3377,3),(3378,3),(3379,3),(3380,3),(3381,3),(3382,3),(3383,3),(3384,3),(3385,3),(3386,3),(3387,3),(3388,3),(3389,3),(3390,3),(3391,3),(3392,3),(3393,3),(3394,3),(3395,3),(3396,3),(3397,3),(3398,3),(3399,3),(3400,3),(3401,3),(3402,3),(3403,3),(3404,3),(3405,3),(3406,3),(3407,3),(3408,3),(3409,3),(3410,3),(3411,3),(3412,3),(3413,3),(3414,3),(3415,3),(3416,3),(3417,3),(3418,3),(3419,3),(3420,3),(3421,3),(3422,3),(3423,3),(3424,3),(3425,3),(3426,3),(3427,3),(3428,3),(3429,3),(3430,3),(3431,3),(3432,3),(3433,3),(3434,3),(3435,3),(3436,3),(3437,3),(3438,3),(3439,3),(3440,3),(3441,3),(3442,3),(3443,3),(3444,3),(3445,3),(3446,3),(3447,3),(3448,3),(3449,3),(3450,3),(3451,3),(3452,3),(3453,3),(3454,3),(3455,3),(3456,3),(3457,3),(3458,3),(3459,3),(3460,3),(3461,3),(3462,3),(3463,3),(3464,3),(3465,3),(3466,3),(3467,3),(3468,3),(3469,3),(3470,3),(3471,3),(3472,3),(3473,3),(3474,3),(3475,3),(3476,3),(3477,3),(3478,3),(3479,3),(3480,3),(3481,3),(3482,3),(3483,3),(3484,3),(3485,3),(3486,3),(3487,3),(3488,3),(3489,3),(3490,3),(3491,3),(3492,3),(3494,3),(3495,3),(3497,1),(3498,1),(3498,3),(3500,1),(3500,3);
/*!40000 ALTER TABLE `product_locations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `product_racks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_racks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `rack` varchar(191) DEFAULT NULL,
  `row` varchar(191) DEFAULT NULL,
  `position` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `product_racks_business_id_index` (`business_id`),
  KEY `product_racks_location_id_index` (`location_id`),
  KEY `product_racks_product_id_index` (`product_id`)
) ENGINE=InnoDB AUTO_INCREMENT=380 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `product_racks` WRITE;
/*!40000 ALTER TABLE `product_racks` DISABLE KEYS */;
INSERT INTO `product_racks` VALUES (17,1,1,1,'china fitting',NULL,NULL,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(18,1,1,2,'00110-06-r11',NULL,NULL,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(19,1,1,3,'00110-06-r14',NULL,NULL,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(20,1,1,4,'00110-08-r15',NULL,NULL,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(21,1,1,5,'00110-08-r18',NULL,NULL,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(22,1,1,6,'00210-06-r11',NULL,NULL,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(23,1,1,7,'china fitting',NULL,NULL,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(24,1,1,8,'00210-06-r14',NULL,NULL,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(25,1,1,9,'00210-08-r15',NULL,NULL,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(26,1,1,10,'china fitting',NULL,NULL,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(27,1,1,11,'00210-08-r18',NULL,NULL,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(28,1,1,12,'00210-12-r21',NULL,NULL,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(29,1,1,13,'china fitting',NULL,NULL,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(30,1,1,14,'00210-16-r27',NULL,NULL,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(31,1,1,15,'00210-20',NULL,NULL,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(32,1,1,16,'00210-24',NULL,NULL,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(33,1,1,17,'00210-24',NULL,NULL,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(34,1,1,18,'00210-32',NULL,NULL,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(35,1,1,19,'00400-12-r21',NULL,NULL,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(36,1,1,20,'china fitting',NULL,NULL,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(37,1,1,21,'00400-16',NULL,NULL,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(38,1,1,22,'00400-20',NULL,NULL,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(39,1,1,23,'00400-24',NULL,NULL,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(40,1,1,24,'00400-32',NULL,NULL,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(41,1,1,25,'btr',NULL,NULL,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(42,1,1,26,'btr',NULL,NULL,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(43,1,1,27,'canada',NULL,NULL,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(44,1,1,28,'canada',NULL,NULL,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(45,1,1,29,'canada',NULL,NULL,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(46,1,1,30,'canada',NULL,NULL,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(47,1,1,31,'canada',NULL,NULL,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(48,1,1,32,'canada',NULL,NULL,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(49,1,1,33,'canada',NULL,NULL,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(50,1,1,34,'canada',NULL,NULL,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(51,1,1,35,'canada',NULL,NULL,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(52,1,1,36,'canada',NULL,NULL,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(53,1,1,37,'canada',NULL,NULL,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(54,1,1,38,'canada',NULL,NULL,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(55,1,1,39,'canada',NULL,NULL,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(56,1,1,40,'canada',NULL,NULL,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(57,1,1,41,'canada',NULL,NULL,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(58,1,1,42,'canada',NULL,NULL,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(59,1,1,43,'canada',NULL,NULL,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(60,1,1,44,'canada',NULL,NULL,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(61,1,1,45,'canada',NULL,NULL,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(62,1,1,46,'canada',NULL,NULL,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(63,1,1,47,'canada',NULL,NULL,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(64,1,1,48,'canada',NULL,NULL,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(65,1,1,49,'canada',NULL,NULL,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(66,1,1,50,'canada',NULL,NULL,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(67,1,1,51,'canada',NULL,NULL,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(68,1,1,52,'canada',NULL,NULL,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(69,1,1,53,'canada',NULL,NULL,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(70,1,1,54,'canada',NULL,NULL,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(71,1,1,55,'canada',NULL,NULL,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(72,1,1,56,'canada',NULL,NULL,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(73,1,1,57,'canada',NULL,NULL,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(74,1,1,58,'canada',NULL,NULL,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(75,1,1,59,'canada',NULL,NULL,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(76,1,1,60,'canada',NULL,NULL,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(77,1,1,61,'canada',NULL,NULL,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(78,1,1,62,'canada',NULL,NULL,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(79,1,1,63,'canada',NULL,NULL,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(80,1,1,64,'canada',NULL,NULL,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(81,1,1,65,'canada',NULL,NULL,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(82,1,1,66,'canada',NULL,NULL,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(83,1,1,67,'canada',NULL,NULL,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(84,1,1,68,'canada',NULL,NULL,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(85,1,1,69,'canada',NULL,NULL,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(86,1,1,70,'canada',NULL,NULL,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(87,1,1,71,'canada',NULL,NULL,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(88,1,1,72,'canada',NULL,NULL,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(89,1,1,73,'canada',NULL,NULL,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(90,1,1,74,'canada',NULL,NULL,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(91,1,1,75,'canada',NULL,NULL,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(92,1,1,76,'canada',NULL,NULL,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(93,1,1,77,'canada',NULL,NULL,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(94,1,1,78,'canada',NULL,NULL,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(95,1,1,79,'canada',NULL,NULL,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(96,1,1,80,'canada',NULL,NULL,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(97,1,1,81,'canada',NULL,NULL,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(98,1,1,82,'canada',NULL,NULL,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(99,1,1,83,'canada',NULL,NULL,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(100,1,1,84,'canada',NULL,NULL,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(101,1,1,85,'canada',NULL,NULL,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(102,1,1,86,'canada',NULL,NULL,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(103,1,1,87,'canada',NULL,NULL,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(104,1,1,88,'canada',NULL,NULL,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(105,1,1,89,'canada',NULL,NULL,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(106,1,1,90,'canada',NULL,NULL,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(107,1,1,91,'canada',NULL,NULL,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(108,1,1,92,'canada',NULL,NULL,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(109,1,1,93,'canada',NULL,NULL,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(110,1,1,94,'canada',NULL,NULL,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(111,1,1,95,'canada',NULL,NULL,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(112,1,1,96,'canada',NULL,NULL,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(113,1,1,3237,'china fitting',NULL,NULL,'2024-12-04 16:49:31','2024-12-04 16:49:31'),(114,1,1,3238,'china fitting',NULL,NULL,'2024-12-04 16:49:31','2024-12-04 16:49:31'),(115,1,1,3239,'china fitting',NULL,NULL,'2024-12-04 16:49:31','2024-12-04 16:49:31'),(116,1,1,3240,'china fitting',NULL,NULL,'2024-12-04 16:49:31','2024-12-04 16:49:31'),(117,1,1,3241,'china fitting',NULL,NULL,'2024-12-04 16:49:31','2024-12-04 16:49:31'),(118,1,1,3242,'china fitting',NULL,NULL,'2024-12-04 16:49:31','2024-12-04 16:49:31'),(119,1,1,3243,'china fitting',NULL,NULL,'2024-12-04 16:49:31','2024-12-04 16:49:31'),(120,1,1,3244,'china fitting',NULL,NULL,'2024-12-04 16:49:31','2024-12-04 16:49:31'),(121,1,1,3245,'china fitting',NULL,NULL,'2024-12-04 16:49:31','2024-12-04 16:49:31'),(122,1,1,3246,'china fitting',NULL,NULL,'2024-12-04 16:49:31','2024-12-04 16:49:31'),(123,1,1,3247,'china fitting',NULL,NULL,'2024-12-04 16:49:31','2024-12-04 16:49:31'),(124,1,1,3248,'china fitting',NULL,NULL,'2024-12-04 16:49:31','2024-12-04 16:49:31'),(125,1,1,3249,'china fitting',NULL,NULL,'2024-12-04 16:49:31','2024-12-04 16:49:31'),(126,1,1,3250,'china fitting',NULL,NULL,'2024-12-04 16:49:31','2024-12-04 16:49:31'),(127,1,1,3251,'china fitting',NULL,NULL,'2024-12-04 16:49:31','2024-12-04 16:49:31'),(128,1,1,3252,'china fitting',NULL,NULL,'2024-12-04 16:49:31','2024-12-04 16:49:31'),(129,1,1,3253,'china fitting',NULL,NULL,'2024-12-04 16:49:31','2024-12-04 16:49:31'),(130,1,1,3254,'china fitting',NULL,NULL,'2024-12-04 16:49:31','2024-12-04 16:49:31'),(131,1,1,3255,'china fitting',NULL,NULL,'2024-12-04 16:49:31','2024-12-04 16:49:31'),(132,1,1,3256,'china fitting',NULL,NULL,'2024-12-04 16:49:31','2024-12-04 16:49:31'),(133,1,1,3257,'china fitting',NULL,NULL,'2024-12-04 16:49:32','2024-12-04 16:49:32'),(134,1,1,3258,'china fitting',NULL,NULL,'2024-12-04 16:49:32','2024-12-04 16:49:32'),(135,1,1,3259,'china fitting',NULL,NULL,'2024-12-04 16:49:32','2024-12-04 16:49:32'),(136,1,1,3260,'china fitting',NULL,NULL,'2024-12-04 16:49:32','2024-12-04 16:49:32'),(137,1,1,3261,'china fitting',NULL,NULL,'2024-12-04 16:49:32','2024-12-04 16:49:32'),(138,1,1,3262,'china fitting',NULL,NULL,'2024-12-04 16:49:32','2024-12-04 16:49:32'),(139,1,1,3263,'china fitting',NULL,NULL,'2024-12-04 16:49:32','2024-12-04 16:49:32'),(140,1,1,3264,'china fitting',NULL,NULL,'2024-12-04 16:49:32','2024-12-04 16:49:32'),(141,1,1,3265,'china fitting',NULL,NULL,'2024-12-04 16:49:32','2024-12-04 16:49:32'),(142,1,1,3266,'china fitting',NULL,NULL,'2024-12-04 16:49:32','2024-12-04 16:49:32'),(143,1,1,3267,'china fitting',NULL,NULL,'2024-12-04 16:49:32','2024-12-04 16:49:32'),(144,1,1,3268,'china fitting',NULL,NULL,'2024-12-04 16:49:32','2024-12-04 16:49:32'),(145,1,1,3269,'china fitting',NULL,NULL,'2024-12-04 16:49:32','2024-12-04 16:49:32'),(146,1,1,3270,'china fitting',NULL,NULL,'2024-12-04 16:49:32','2024-12-04 16:49:32'),(147,1,1,3271,'china fitting',NULL,NULL,'2024-12-04 16:49:32','2024-12-04 16:49:32'),(148,1,1,3272,'china fitting',NULL,NULL,'2024-12-04 16:49:32','2024-12-04 16:49:32'),(149,1,1,3273,'china fitting',NULL,NULL,'2024-12-04 16:49:32','2024-12-04 16:49:32'),(150,1,1,3274,'china fitting',NULL,NULL,'2024-12-04 16:49:32','2024-12-04 16:49:32'),(151,1,1,3275,'china fitting',NULL,NULL,'2024-12-04 16:49:32','2024-12-04 16:49:32'),(152,1,1,3276,'china fitting',NULL,NULL,'2024-12-04 16:49:32','2024-12-04 16:49:32'),(153,1,1,3277,'china fitting',NULL,NULL,'2024-12-04 16:49:32','2024-12-04 16:49:32'),(154,1,1,3278,'china fitting',NULL,NULL,'2024-12-04 16:49:32','2024-12-04 16:49:32'),(155,1,1,3279,'china fitting',NULL,NULL,'2024-12-04 16:49:32','2024-12-04 16:49:32'),(156,1,1,3280,'china fitting',NULL,NULL,'2024-12-04 16:49:32','2024-12-04 16:49:32'),(157,1,1,3281,'china fitting',NULL,NULL,'2024-12-04 16:49:32','2024-12-04 16:49:32'),(158,1,1,3282,'china fitting',NULL,NULL,'2024-12-04 16:49:32','2024-12-04 16:49:32'),(159,1,1,3283,'china fitting',NULL,NULL,'2024-12-04 16:49:32','2024-12-04 16:49:32'),(160,1,1,3284,'china fitting',NULL,NULL,'2024-12-04 16:49:32','2024-12-04 16:49:32'),(161,1,1,3285,'china fitting',NULL,NULL,'2024-12-04 16:49:32','2024-12-04 16:49:32'),(162,1,1,3286,'china fitting',NULL,NULL,'2024-12-04 16:49:32','2024-12-04 16:49:32'),(163,1,1,3287,'china fitting',NULL,NULL,'2024-12-04 16:49:32','2024-12-04 16:49:32'),(164,1,1,3288,'china fitting',NULL,NULL,'2024-12-04 16:49:32','2024-12-04 16:49:32'),(165,1,1,3289,'china fitting',NULL,NULL,'2024-12-04 16:49:32','2024-12-04 16:49:32'),(166,1,1,3290,'china fitting',NULL,NULL,'2024-12-04 16:49:32','2024-12-04 16:49:32'),(167,1,1,3291,'china fitting',NULL,NULL,'2024-12-04 16:49:32','2024-12-04 16:49:32'),(168,1,1,3292,'china fitting',NULL,NULL,'2024-12-04 16:49:32','2024-12-04 16:49:32'),(169,1,1,3293,'china fitting',NULL,NULL,'2024-12-04 16:49:32','2024-12-04 16:49:32'),(170,1,1,3294,'china fitting',NULL,NULL,'2024-12-04 16:49:32','2024-12-04 16:49:32'),(171,1,1,3295,'china fitting',NULL,NULL,'2024-12-04 16:49:32','2024-12-04 16:49:32'),(172,1,1,3296,'china fitting',NULL,NULL,'2024-12-04 16:49:33','2024-12-04 16:49:33'),(173,1,1,3297,'china fitting',NULL,NULL,'2024-12-04 16:49:33','2024-12-04 16:49:33'),(174,1,1,3298,'china fitting',NULL,NULL,'2024-12-04 16:49:33','2024-12-04 16:49:33'),(175,1,1,3299,'china fitting',NULL,NULL,'2024-12-04 16:49:33','2024-12-04 16:49:33'),(176,1,1,3300,'china fitting',NULL,NULL,'2024-12-04 16:49:33','2024-12-04 16:49:33'),(177,1,1,3301,'china fitting',NULL,NULL,'2024-12-04 16:49:33','2024-12-04 16:49:33'),(178,1,1,3302,'china fitting',NULL,NULL,'2024-12-04 16:49:33','2024-12-04 16:49:33'),(179,1,1,3303,'china fitting',NULL,NULL,'2024-12-04 16:49:33','2024-12-04 16:49:33'),(180,1,1,3304,'china fitting',NULL,NULL,'2024-12-04 16:49:33','2024-12-04 16:49:33'),(181,1,1,3305,'china fitting',NULL,NULL,'2024-12-04 16:49:33','2024-12-04 16:49:33'),(182,1,1,3306,'china fitting',NULL,NULL,'2024-12-04 16:49:33','2024-12-04 16:49:33'),(183,1,1,3307,'china fitting',NULL,NULL,'2024-12-04 16:49:33','2024-12-04 16:49:33'),(184,1,1,3308,'china fitting',NULL,NULL,'2024-12-04 16:49:33','2024-12-04 16:49:33'),(185,1,1,3309,'china fitting',NULL,NULL,'2024-12-04 16:49:33','2024-12-04 16:49:33'),(186,1,1,3310,'china fitting',NULL,NULL,'2024-12-04 16:49:33','2024-12-04 16:49:33'),(187,1,1,3311,'china fitting',NULL,NULL,'2024-12-04 16:49:33','2024-12-04 16:49:33'),(188,1,1,3312,'china fitting',NULL,NULL,'2024-12-04 16:49:33','2024-12-04 16:49:33'),(189,1,1,3313,'china fitting',NULL,NULL,'2024-12-04 16:49:33','2024-12-04 16:49:33'),(190,1,1,3314,'china fitting',NULL,NULL,'2024-12-04 16:49:33','2024-12-04 16:49:33'),(191,1,1,3315,'china fitting',NULL,NULL,'2024-12-04 16:49:33','2024-12-04 16:49:33'),(192,1,1,3316,'china fitting',NULL,NULL,'2024-12-04 16:49:33','2024-12-04 16:49:33'),(193,1,1,3317,'china fitting',NULL,NULL,'2024-12-04 16:49:33','2024-12-04 16:49:33'),(194,1,1,3318,'china fitting',NULL,NULL,'2024-12-04 16:49:33','2024-12-04 16:49:33'),(195,1,1,3319,'china fitting',NULL,NULL,'2024-12-04 16:49:33','2024-12-04 16:49:33'),(196,1,1,3320,'china fitting',NULL,NULL,'2024-12-04 16:49:33','2024-12-16 00:40:38'),(197,1,1,3321,'china fitting',NULL,NULL,'2024-12-04 16:49:33','2024-12-04 16:49:33'),(198,1,1,3322,'china fitting',NULL,NULL,'2024-12-04 16:49:33','2024-12-04 16:49:33'),(199,1,1,3323,'china fitting',NULL,NULL,'2024-12-04 16:49:33','2024-12-04 16:49:33'),(200,1,1,3324,'china fitting',NULL,NULL,'2024-12-04 16:49:33','2024-12-04 16:49:33'),(201,1,1,3325,'china fitting',NULL,NULL,'2024-12-04 16:49:33','2024-12-04 16:49:33'),(202,1,1,3326,'china fitting',NULL,NULL,'2024-12-04 16:49:33','2024-12-04 16:49:33'),(203,1,1,3327,'china fitting',NULL,NULL,'2024-12-04 16:49:33','2024-12-04 16:49:33'),(204,1,1,3328,'china fitting',NULL,NULL,'2024-12-04 16:49:33','2024-12-04 16:49:33'),(205,1,1,3329,'china fitting',NULL,NULL,'2024-12-04 16:49:33','2024-12-04 16:49:33'),(206,1,1,3330,'china fitting',NULL,NULL,'2024-12-04 16:49:33','2024-12-04 16:49:33'),(207,1,1,3331,'china fitting',NULL,NULL,'2024-12-04 16:49:33','2024-12-04 16:49:33'),(208,1,1,3332,'china fitting',NULL,NULL,'2024-12-04 16:49:34','2024-12-04 16:49:34'),(209,1,1,3333,'china fitting',NULL,NULL,'2024-12-04 16:49:34','2024-12-04 16:49:34'),(210,1,1,3334,'china fitting',NULL,NULL,'2024-12-04 16:49:34','2024-12-04 16:49:34'),(211,1,1,3335,'china fitting',NULL,NULL,'2024-12-04 16:49:34','2024-12-04 16:49:34'),(212,1,1,3336,'china fitting',NULL,NULL,'2024-12-04 16:49:34','2024-12-04 16:49:34'),(213,1,1,3337,'china fitting',NULL,NULL,'2024-12-04 16:49:34','2024-12-04 16:49:34'),(214,1,1,3338,'china fitting',NULL,NULL,'2024-12-04 16:49:34','2024-12-04 16:49:34'),(215,1,1,3339,'china fitting',NULL,NULL,'2024-12-04 16:49:34','2024-12-04 16:49:34'),(216,1,1,3340,'china fitting',NULL,NULL,'2024-12-04 16:49:34','2024-12-04 16:49:34'),(217,1,1,3341,'china fitting',NULL,NULL,'2024-12-04 16:49:34','2024-12-04 16:49:34'),(218,1,1,3342,'imported',NULL,NULL,'2024-12-04 16:49:34','2024-12-04 16:49:34'),(219,1,1,3343,'imported',NULL,NULL,'2024-12-04 16:49:34','2024-12-04 16:49:34'),(220,1,1,3344,'china fitting',NULL,NULL,'2024-12-04 16:49:34','2024-12-04 16:49:34'),(221,1,1,3345,'imported',NULL,NULL,'2024-12-04 16:49:34','2024-12-04 16:49:34'),(222,1,1,3346,'imported',NULL,NULL,'2024-12-04 16:49:34','2024-12-04 16:49:34'),(223,1,1,3347,'imported',NULL,NULL,'2024-12-04 16:49:34','2024-12-04 16:49:34'),(224,1,1,3348,'china fitting',NULL,NULL,'2024-12-04 16:49:34','2024-12-04 16:49:34'),(225,1,1,3349,'china fitting',NULL,NULL,'2024-12-04 16:49:34','2024-12-04 16:49:34'),(226,1,1,3350,'china fitting',NULL,NULL,'2024-12-04 16:49:34','2024-12-04 16:49:34'),(227,1,1,3351,'china fitting',NULL,NULL,'2024-12-04 16:49:34','2024-12-04 16:49:34'),(228,1,1,3352,'china fitting',NULL,NULL,'2024-12-04 16:49:34','2024-12-04 16:49:34'),(229,1,1,3353,'china fitting',NULL,NULL,'2024-12-04 16:49:34','2024-12-04 16:49:34'),(230,1,1,3354,'china fitting',NULL,NULL,'2024-12-04 16:49:34','2024-12-04 16:49:34'),(231,1,1,3355,'china fitting',NULL,NULL,'2024-12-04 16:49:34','2024-12-04 16:49:34'),(232,1,1,3356,'china fitting',NULL,NULL,'2024-12-04 16:49:34','2024-12-04 16:49:34'),(233,1,1,3357,'china fitting',NULL,NULL,'2024-12-04 16:49:34','2024-12-04 16:49:34'),(234,1,1,3358,'china fitting',NULL,NULL,'2024-12-04 16:49:34','2024-12-04 16:49:34'),(235,1,1,3359,'imported',NULL,NULL,'2024-12-04 16:49:34','2024-12-04 16:49:34'),(236,1,1,3360,'china fitting',NULL,NULL,'2024-12-04 16:49:34','2024-12-04 16:49:34'),(237,1,1,3361,'china fitting',NULL,NULL,'2024-12-04 16:49:34','2024-12-04 16:49:34'),(238,1,1,3362,'hydrolic',NULL,NULL,'2024-12-04 16:49:34','2024-12-04 16:49:34'),(239,1,1,3363,'hydrolic',NULL,NULL,'2024-12-04 16:49:34','2024-12-04 16:49:34'),(240,1,1,3364,'hydrolic',NULL,NULL,'2024-12-04 16:49:34','2024-12-04 16:49:34'),(241,1,1,3365,'hydrolic',NULL,NULL,'2024-12-04 16:49:34','2024-12-04 16:49:34'),(242,1,1,3366,'hydrolic',NULL,NULL,'2024-12-04 16:49:34','2024-12-04 16:49:34'),(243,1,1,3367,'hydrolic',NULL,NULL,'2024-12-04 16:49:34','2024-12-04 16:49:34'),(244,1,1,3368,'hydrolic',NULL,NULL,'2024-12-04 16:49:34','2024-12-04 16:49:34'),(245,1,1,3369,'hydrolic',NULL,NULL,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(246,1,1,3370,'hydrolic',NULL,NULL,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(247,1,1,3371,'hydrolic',NULL,NULL,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(248,1,1,3372,'hydrolic',NULL,NULL,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(249,1,1,3373,'hydrolic',NULL,NULL,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(250,1,1,3374,'hydrolic',NULL,NULL,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(251,1,1,3375,'hydrolic',NULL,NULL,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(252,1,1,3376,'hydrolic',NULL,NULL,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(253,1,1,3377,'hydrolic',NULL,NULL,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(254,1,1,3378,'hydrolic',NULL,NULL,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(255,1,1,3379,'hydrolic',NULL,NULL,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(256,1,1,3380,'hydrolic',NULL,NULL,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(257,1,1,3381,'hydrolic',NULL,NULL,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(258,1,1,3382,'hydrolic',NULL,NULL,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(259,1,1,3383,'hydrolic',NULL,NULL,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(260,1,1,3384,'china fitting',NULL,NULL,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(261,1,1,3385,'china fitting',NULL,NULL,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(262,1,1,3386,'hydrolic',NULL,NULL,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(263,1,1,3387,'hydrolic',NULL,NULL,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(264,1,1,3388,'hydrolic',NULL,NULL,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(265,1,1,3389,'hydrolic',NULL,NULL,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(266,1,1,3390,'hydrolic',NULL,NULL,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(267,1,1,3391,'hydrolic',NULL,NULL,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(268,1,1,3392,'hydrolic',NULL,NULL,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(269,1,1,3393,'hydrolic',NULL,NULL,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(270,1,1,3394,'hydrolic',NULL,NULL,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(271,1,1,3395,'hydrolic',NULL,NULL,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(272,1,1,3396,'hydrolic',NULL,NULL,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(273,1,1,3397,'hydrolic',NULL,NULL,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(274,1,1,3398,'hydrolic',NULL,NULL,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(275,1,1,3399,'hydrolic',NULL,NULL,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(276,1,1,3400,'hydrolic',NULL,NULL,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(277,1,1,3401,'hydrolic',NULL,NULL,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(278,1,1,3402,'hydrolic',NULL,NULL,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(279,1,1,3403,'hydrolic',NULL,NULL,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(280,1,1,3404,'hydrolic',NULL,NULL,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(281,1,1,3405,'hydrolic',NULL,NULL,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(282,1,1,3406,'hydrolic',NULL,NULL,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(283,1,1,3407,'hydrolic',NULL,NULL,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(284,1,1,3408,'hydrolic',NULL,NULL,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(285,1,1,3409,'hydrolic',NULL,NULL,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(286,1,1,3410,'china fitting',NULL,NULL,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(287,1,1,3411,'china fitting',NULL,NULL,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(288,1,1,3412,'china fitting',NULL,NULL,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(289,1,1,3413,'china fitting',NULL,NULL,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(290,1,1,3414,'china fitting',NULL,NULL,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(291,1,1,3415,'china fitting',NULL,NULL,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(292,1,1,3416,'china fitting',NULL,NULL,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(293,1,1,3417,'china fitting',NULL,NULL,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(294,1,1,3418,'china fitting',NULL,NULL,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(295,1,1,3419,'china fitting',NULL,NULL,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(296,1,1,3420,'china fitting',NULL,NULL,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(297,1,1,3421,'china fitting',NULL,NULL,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(298,1,1,3422,'china fitting',NULL,NULL,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(299,1,1,3423,'hydrolic',NULL,NULL,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(300,1,1,3424,'hydrolic',NULL,NULL,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(301,1,1,3425,'hydrolic',NULL,NULL,'2024-12-04 16:49:36','2024-12-04 16:49:36'),(302,1,1,3426,'hydrolic',NULL,NULL,'2024-12-04 16:49:36','2024-12-04 16:49:36'),(303,1,1,3427,'hydrolic',NULL,NULL,'2024-12-04 16:49:36','2024-12-04 16:49:36'),(304,1,1,3428,'hydrolic',NULL,NULL,'2024-12-04 16:49:36','2024-12-04 16:49:36'),(305,1,1,3429,'hydrolic',NULL,NULL,'2024-12-04 16:49:36','2024-12-04 16:49:36'),(306,1,1,3430,'hydrolic',NULL,NULL,'2024-12-04 16:49:36','2024-12-04 16:49:36'),(307,1,1,3431,'hydrolic',NULL,NULL,'2024-12-04 16:49:36','2024-12-04 16:49:36'),(308,1,1,3432,'hydrolic',NULL,NULL,'2024-12-04 16:49:36','2024-12-04 16:49:36'),(309,1,1,3433,'hydrolic',NULL,NULL,'2024-12-04 16:49:36','2024-12-04 16:49:36'),(310,1,1,3434,'hydrolic',NULL,NULL,'2024-12-04 16:49:36','2024-12-04 16:49:36'),(311,1,1,3435,'hydrolic',NULL,NULL,'2024-12-04 16:49:36','2024-12-04 16:49:36'),(312,1,1,3436,'hydrolic',NULL,NULL,'2024-12-04 16:49:36','2024-12-04 16:49:36'),(313,1,1,3437,'hydrolic',NULL,NULL,'2024-12-04 16:49:36','2024-12-04 16:49:36'),(314,1,1,3438,'hydrolic',NULL,NULL,'2024-12-04 16:49:36','2024-12-04 16:49:36'),(315,1,1,3439,'hydrolic',NULL,NULL,'2024-12-04 16:49:36','2024-12-04 16:49:36'),(316,1,1,3440,'hydrolic',NULL,NULL,'2024-12-04 16:49:36','2024-12-04 16:49:36'),(317,1,1,3441,'hydrolic',NULL,NULL,'2024-12-04 16:49:36','2024-12-04 16:49:36'),(318,1,1,3442,'china fitting',NULL,NULL,'2024-12-04 16:49:36','2024-12-04 16:49:36'),(319,1,1,3443,'china fitting',NULL,NULL,'2024-12-04 16:49:36','2024-12-04 16:49:36'),(320,1,1,3444,'china fitting',NULL,NULL,'2024-12-04 16:49:36','2024-12-04 16:49:36'),(321,1,1,3445,'china fitting',NULL,NULL,'2024-12-04 16:49:36','2024-12-04 16:49:36'),(322,1,1,3446,'china fitting',NULL,NULL,'2024-12-04 16:49:36','2024-12-04 16:49:36'),(323,1,1,3447,'china fitting',NULL,NULL,'2024-12-04 16:49:36','2024-12-04 16:49:36'),(324,1,1,3448,'china fitting',NULL,NULL,'2024-12-04 16:49:36','2024-12-04 16:49:36'),(325,1,1,3449,'china fitting',NULL,NULL,'2024-12-04 16:49:36','2024-12-04 16:49:36'),(326,1,1,3450,'china fitting',NULL,NULL,'2024-12-04 16:49:36','2024-12-04 16:49:36'),(327,1,1,3451,'china fitting',NULL,NULL,'2024-12-04 16:49:36','2024-12-04 16:49:36'),(328,1,1,3452,'china fitting',NULL,NULL,'2024-12-04 16:49:36','2024-12-04 16:49:36'),(329,1,1,3453,'china fitting',NULL,NULL,'2024-12-04 16:49:36','2024-12-04 16:49:36'),(330,1,1,3454,'china fitting',NULL,NULL,'2024-12-04 16:49:36','2024-12-04 16:49:36'),(331,1,1,3455,'china fitting',NULL,NULL,'2024-12-04 16:49:36','2024-12-04 16:49:36'),(332,1,1,3456,'china fitting',NULL,NULL,'2024-12-04 16:49:36','2024-12-04 16:49:36'),(333,1,1,3457,'china fitting',NULL,NULL,'2024-12-04 16:49:36','2024-12-04 16:49:36'),(334,1,1,3458,'china fitting',NULL,NULL,'2024-12-04 16:49:36','2024-12-04 16:49:36'),(335,1,1,3459,'china',NULL,NULL,'2024-12-04 17:08:12','2024-12-04 17:08:12'),(336,1,1,3460,'china',NULL,NULL,'2024-12-04 17:42:40','2024-12-04 17:42:40'),(337,1,1,3461,'china',NULL,NULL,'2024-12-04 17:47:36','2024-12-04 17:47:36'),(338,1,1,3462,'china',NULL,NULL,'2024-12-05 09:19:30','2024-12-05 09:19:30'),(339,1,1,3463,'china',NULL,NULL,'2024-12-05 09:22:44','2024-12-05 09:22:44'),(340,1,1,3464,'china',NULL,NULL,'2024-12-05 09:25:57','2024-12-05 09:25:57'),(341,1,1,3465,'china',NULL,NULL,'2024-12-05 09:29:17','2024-12-05 09:29:17'),(342,1,1,3466,'china',NULL,NULL,'2024-12-05 09:33:45','2024-12-05 09:33:45'),(343,1,1,3467,'spacial china',NULL,NULL,'2024-12-05 09:37:42','2024-12-05 09:42:25'),(344,1,1,3468,'spacial china',NULL,NULL,'2024-12-05 09:41:00','2024-12-05 09:41:00'),(345,1,1,3469,'china',NULL,NULL,'2024-12-05 09:46:37','2024-12-05 09:46:37'),(346,1,1,3470,'china',NULL,NULL,'2024-12-05 09:48:55','2024-12-05 09:48:55'),(347,1,1,3471,'china',NULL,NULL,'2024-12-05 10:25:34','2024-12-05 10:25:34'),(348,1,1,3472,'china',NULL,NULL,'2024-12-05 10:28:40','2024-12-05 10:28:40'),(349,1,1,3473,'china',NULL,NULL,'2024-12-05 10:31:24','2024-12-05 10:31:24'),(350,1,1,3474,'china',NULL,NULL,'2024-12-05 10:34:55','2024-12-05 10:34:55'),(351,1,1,3475,'USA',NULL,NULL,'2024-12-05 10:40:25','2024-12-05 10:40:25'),(352,1,1,3476,'impoted',NULL,NULL,'2024-12-05 10:46:57','2024-12-05 10:46:57'),(353,1,1,3477,'impoted',NULL,NULL,'2024-12-05 10:52:29','2024-12-05 10:52:29'),(354,1,1,3478,'impoted',NULL,NULL,'2024-12-05 10:57:11','2024-12-05 10:57:11'),(355,1,1,3479,'impoted',NULL,NULL,'2024-12-05 10:59:27','2024-12-05 10:59:27'),(356,1,1,3480,'china',NULL,NULL,'2024-12-05 11:06:35','2024-12-05 11:06:35'),(357,1,1,3481,'china',NULL,NULL,'2024-12-05 11:10:12','2024-12-05 11:13:34'),(358,1,1,3482,'china',NULL,NULL,'2024-12-05 11:17:02','2024-12-05 11:17:02'),(359,1,1,3483,'china',NULL,NULL,'2024-12-05 11:21:03','2024-12-05 11:21:03'),(360,1,1,3484,'spacial china',NULL,NULL,'2024-12-05 11:46:32','2024-12-05 11:46:32'),(361,1,1,3485,'china',NULL,NULL,'2024-12-05 11:52:33','2024-12-05 11:52:33'),(362,1,1,3486,'china',NULL,NULL,'2024-12-05 11:56:49','2024-12-05 11:56:49'),(363,1,1,3487,'china',NULL,NULL,'2024-12-05 11:59:48','2024-12-05 11:59:48'),(364,1,1,3488,'china',NULL,NULL,'2024-12-05 12:19:56','2024-12-05 12:21:51'),(365,1,1,3489,'china',NULL,NULL,'2024-12-05 12:27:47','2024-12-05 12:27:47'),(366,1,1,3490,'china',NULL,NULL,'2024-12-05 12:32:10','2024-12-05 12:32:10'),(367,1,1,3491,'china',NULL,NULL,'2024-12-05 12:34:07','2024-12-05 12:34:07'),(368,1,1,3492,'china',NULL,NULL,'2024-12-05 12:36:51','2024-12-05 12:36:51'),(369,1,1,3493,'BTR',NULL,NULL,'2024-12-05 16:21:29','2024-12-05 16:21:29'),(370,1,1,3228,NULL,NULL,NULL,'2024-12-05 16:23:11','2024-12-05 16:23:11'),(371,1,1,3494,'impoted',NULL,NULL,'2024-12-07 09:06:36','2024-12-07 09:06:36'),(372,1,1,3495,'impoted',NULL,NULL,'2024-12-07 09:16:52','2024-12-07 09:16:52'),(373,1,3,3320,NULL,NULL,NULL,'2024-12-16 00:40:38','2024-12-16 00:40:38'),(374,1,1,3496,NULL,NULL,NULL,'2024-12-17 21:23:32','2024-12-17 21:23:32'),(375,1,3,3496,NULL,NULL,NULL,'2024-12-17 21:23:32','2024-12-17 21:23:32'),(376,1,1,3497,NULL,NULL,NULL,'2024-12-17 21:23:49','2024-12-17 21:23:49'),(377,1,3,3497,NULL,NULL,NULL,'2024-12-17 21:23:49','2024-12-17 21:23:49'),(378,1,1,3499,NULL,NULL,NULL,'2024-12-20 14:38:35','2024-12-20 14:38:35'),(379,1,3,3499,NULL,NULL,NULL,'2024-12-20 14:38:35','2024-12-20 14:38:35');
/*!40000 ALTER TABLE `product_racks` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `product_variations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_variations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `variation_template_id` int(11) DEFAULT NULL,
  `name` varchar(191) NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `is_dummy` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `product_variations_name_index` (`name`),
  KEY `product_variations_product_id_index` (`product_id`),
  CONSTRAINT `product_variations_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3501 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `product_variations` WRITE;
/*!40000 ALTER TABLE `product_variations` DISABLE KEYS */;
INSERT INTO `product_variations` VALUES (1,NULL,'DUMMY',1,1,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(2,NULL,'DUMMY',2,1,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(3,NULL,'DUMMY',3,1,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(4,NULL,'DUMMY',4,1,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(5,NULL,'DUMMY',5,1,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(6,NULL,'DUMMY',6,1,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(7,NULL,'DUMMY',7,1,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(8,NULL,'DUMMY',8,1,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(9,NULL,'DUMMY',9,1,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(10,NULL,'DUMMY',10,1,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(11,NULL,'DUMMY',11,1,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(12,NULL,'DUMMY',12,1,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(13,NULL,'DUMMY',13,1,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(14,NULL,'DUMMY',14,1,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(15,NULL,'DUMMY',15,1,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(16,NULL,'DUMMY',16,1,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(17,NULL,'DUMMY',17,1,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(18,NULL,'DUMMY',18,1,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(19,NULL,'DUMMY',19,1,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(20,NULL,'DUMMY',20,1,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(21,NULL,'DUMMY',21,1,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(22,NULL,'DUMMY',22,1,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(23,NULL,'DUMMY',23,1,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(24,NULL,'DUMMY',24,1,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(25,NULL,'DUMMY',25,1,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(26,NULL,'DUMMY',26,1,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(27,NULL,'DUMMY',27,1,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(28,NULL,'DUMMY',28,1,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(29,NULL,'DUMMY',29,1,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(30,NULL,'DUMMY',30,1,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(31,NULL,'DUMMY',31,1,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(32,NULL,'DUMMY',32,1,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(33,NULL,'DUMMY',33,1,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(34,NULL,'DUMMY',34,1,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(35,NULL,'DUMMY',35,1,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(36,NULL,'DUMMY',36,1,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(37,NULL,'DUMMY',37,1,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(38,NULL,'DUMMY',38,1,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(39,NULL,'DUMMY',39,1,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(40,NULL,'DUMMY',40,1,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(41,NULL,'DUMMY',41,1,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(42,NULL,'DUMMY',42,1,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(43,NULL,'DUMMY',43,1,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(44,NULL,'DUMMY',44,1,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(45,NULL,'DUMMY',45,1,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(46,NULL,'DUMMY',46,1,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(47,NULL,'DUMMY',47,1,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(48,NULL,'DUMMY',48,1,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(49,NULL,'DUMMY',49,1,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(50,NULL,'DUMMY',50,1,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(51,NULL,'DUMMY',51,1,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(52,NULL,'DUMMY',52,1,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(53,NULL,'DUMMY',53,1,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(54,NULL,'DUMMY',54,1,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(55,NULL,'DUMMY',55,1,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(56,NULL,'DUMMY',56,1,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(57,NULL,'DUMMY',57,1,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(58,NULL,'DUMMY',58,1,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(59,NULL,'DUMMY',59,1,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(60,NULL,'DUMMY',60,1,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(61,NULL,'DUMMY',61,1,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(62,NULL,'DUMMY',62,1,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(63,NULL,'DUMMY',63,1,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(64,NULL,'DUMMY',64,1,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(65,NULL,'DUMMY',65,1,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(66,NULL,'DUMMY',66,1,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(67,NULL,'DUMMY',67,1,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(68,NULL,'DUMMY',68,1,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(69,NULL,'DUMMY',69,1,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(70,NULL,'DUMMY',70,1,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(71,NULL,'DUMMY',71,1,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(72,NULL,'DUMMY',72,1,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(73,NULL,'DUMMY',73,1,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(74,NULL,'DUMMY',74,1,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(75,NULL,'DUMMY',75,1,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(76,NULL,'DUMMY',76,1,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(77,NULL,'DUMMY',77,1,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(78,NULL,'DUMMY',78,1,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(79,NULL,'DUMMY',79,1,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(80,NULL,'DUMMY',80,1,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(81,NULL,'DUMMY',81,1,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(82,NULL,'DUMMY',82,1,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(83,NULL,'DUMMY',83,1,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(84,NULL,'DUMMY',84,1,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(85,NULL,'DUMMY',85,1,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(86,NULL,'DUMMY',86,1,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(87,NULL,'DUMMY',87,1,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(88,NULL,'DUMMY',88,1,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(89,NULL,'DUMMY',89,1,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(90,NULL,'DUMMY',90,1,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(91,NULL,'DUMMY',91,1,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(92,NULL,'DUMMY',92,1,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(93,NULL,'DUMMY',93,1,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(94,NULL,'DUMMY',94,1,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(95,NULL,'DUMMY',95,1,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(96,NULL,'DUMMY',96,1,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(97,NULL,'DUMMY',97,1,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(98,NULL,'DUMMY',98,1,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(99,NULL,'DUMMY',99,1,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(100,NULL,'DUMMY',100,1,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(101,NULL,'DUMMY',101,1,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(102,NULL,'DUMMY',102,1,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(103,NULL,'DUMMY',103,1,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(104,NULL,'DUMMY',104,1,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(105,NULL,'DUMMY',105,1,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(106,NULL,'DUMMY',106,1,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(107,NULL,'DUMMY',107,1,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(108,NULL,'DUMMY',108,1,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(109,NULL,'DUMMY',109,1,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(110,NULL,'DUMMY',110,1,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(111,NULL,'DUMMY',111,1,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(112,NULL,'DUMMY',112,1,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(113,NULL,'DUMMY',113,1,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(114,NULL,'DUMMY',114,1,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(115,NULL,'DUMMY',115,1,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(116,NULL,'DUMMY',116,1,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(117,NULL,'DUMMY',117,1,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(118,NULL,'DUMMY',118,1,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(119,NULL,'DUMMY',119,1,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(120,NULL,'DUMMY',120,1,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(121,NULL,'DUMMY',121,1,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(122,NULL,'DUMMY',122,1,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(123,NULL,'DUMMY',123,1,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(124,NULL,'DUMMY',124,1,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(125,NULL,'DUMMY',125,1,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(126,NULL,'DUMMY',126,1,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(127,NULL,'DUMMY',127,1,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(128,NULL,'DUMMY',128,1,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(129,NULL,'DUMMY',129,1,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(130,NULL,'DUMMY',130,1,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(131,NULL,'DUMMY',131,1,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(132,NULL,'DUMMY',132,1,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(133,NULL,'DUMMY',133,1,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(134,NULL,'DUMMY',134,1,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(135,NULL,'DUMMY',135,1,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(136,NULL,'DUMMY',136,1,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(137,NULL,'DUMMY',137,1,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(138,NULL,'DUMMY',138,1,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(139,NULL,'DUMMY',139,1,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(140,NULL,'DUMMY',140,1,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(141,NULL,'DUMMY',141,1,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(142,NULL,'DUMMY',142,1,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(143,NULL,'DUMMY',143,1,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(144,NULL,'DUMMY',144,1,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(145,NULL,'DUMMY',145,1,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(146,NULL,'DUMMY',146,1,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(147,NULL,'DUMMY',147,1,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(148,NULL,'DUMMY',148,1,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(149,NULL,'DUMMY',149,1,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(150,NULL,'DUMMY',150,1,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(151,NULL,'DUMMY',151,1,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(152,NULL,'DUMMY',152,1,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(153,NULL,'DUMMY',153,1,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(154,NULL,'DUMMY',154,1,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(155,NULL,'DUMMY',155,1,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(156,NULL,'DUMMY',156,1,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(157,NULL,'DUMMY',157,1,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(158,NULL,'DUMMY',158,1,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(159,NULL,'DUMMY',159,1,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(160,NULL,'DUMMY',160,1,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(161,NULL,'DUMMY',161,1,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(162,NULL,'DUMMY',162,1,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(163,NULL,'DUMMY',163,1,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(164,NULL,'DUMMY',164,1,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(165,NULL,'DUMMY',165,1,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(166,NULL,'DUMMY',166,1,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(167,NULL,'DUMMY',167,1,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(168,NULL,'DUMMY',168,1,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(169,NULL,'DUMMY',169,1,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(170,NULL,'DUMMY',170,1,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(171,NULL,'DUMMY',171,1,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(172,NULL,'DUMMY',172,1,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(173,NULL,'DUMMY',173,1,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(174,NULL,'DUMMY',174,1,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(175,NULL,'DUMMY',175,1,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(176,NULL,'DUMMY',176,1,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(177,NULL,'DUMMY',177,1,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(178,NULL,'DUMMY',178,1,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(179,NULL,'DUMMY',179,1,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(180,NULL,'DUMMY',180,1,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(181,NULL,'DUMMY',181,1,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(182,NULL,'DUMMY',182,1,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(183,NULL,'DUMMY',183,1,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(184,NULL,'DUMMY',184,1,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(185,NULL,'DUMMY',185,1,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(186,NULL,'DUMMY',186,1,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(187,NULL,'DUMMY',187,1,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(188,NULL,'DUMMY',188,1,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(189,NULL,'DUMMY',189,1,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(190,NULL,'DUMMY',190,1,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(191,NULL,'DUMMY',191,1,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(192,NULL,'DUMMY',192,1,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(193,NULL,'DUMMY',193,1,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(194,NULL,'DUMMY',194,1,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(195,NULL,'DUMMY',195,1,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(196,NULL,'DUMMY',196,1,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(197,NULL,'DUMMY',197,1,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(198,NULL,'DUMMY',198,1,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(199,NULL,'DUMMY',199,1,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(200,NULL,'DUMMY',200,1,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(201,NULL,'DUMMY',201,1,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(202,NULL,'DUMMY',202,1,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(203,NULL,'DUMMY',203,1,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(204,NULL,'DUMMY',204,1,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(205,NULL,'DUMMY',205,1,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(206,NULL,'DUMMY',206,1,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(207,NULL,'DUMMY',207,1,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(208,NULL,'DUMMY',208,1,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(209,NULL,'DUMMY',209,1,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(210,NULL,'DUMMY',210,1,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(211,NULL,'DUMMY',211,1,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(212,NULL,'DUMMY',212,1,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(213,NULL,'DUMMY',213,1,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(214,NULL,'DUMMY',214,1,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(215,NULL,'DUMMY',215,1,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(216,NULL,'DUMMY',216,1,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(217,NULL,'DUMMY',217,1,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(218,NULL,'DUMMY',218,1,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(219,NULL,'DUMMY',219,1,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(220,NULL,'DUMMY',220,1,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(221,NULL,'DUMMY',221,1,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(222,NULL,'DUMMY',222,1,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(223,NULL,'DUMMY',223,1,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(224,NULL,'DUMMY',224,1,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(225,NULL,'DUMMY',225,1,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(226,NULL,'DUMMY',226,1,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(227,NULL,'DUMMY',227,1,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(228,NULL,'DUMMY',228,1,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(229,NULL,'DUMMY',229,1,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(230,NULL,'DUMMY',230,1,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(231,NULL,'DUMMY',231,1,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(232,NULL,'DUMMY',232,1,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(233,NULL,'DUMMY',233,1,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(234,NULL,'DUMMY',234,1,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(235,NULL,'DUMMY',235,1,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(236,NULL,'DUMMY',236,1,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(237,NULL,'DUMMY',237,1,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(238,NULL,'DUMMY',238,1,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(239,NULL,'DUMMY',239,1,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(240,NULL,'DUMMY',240,1,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(241,NULL,'DUMMY',241,1,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(242,NULL,'DUMMY',242,1,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(243,NULL,'DUMMY',243,1,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(244,NULL,'DUMMY',244,1,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(245,NULL,'DUMMY',245,1,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(246,NULL,'DUMMY',246,1,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(247,NULL,'DUMMY',247,1,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(248,NULL,'DUMMY',248,1,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(249,NULL,'DUMMY',249,1,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(250,NULL,'DUMMY',250,1,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(251,NULL,'DUMMY',251,1,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(252,NULL,'DUMMY',252,1,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(253,NULL,'DUMMY',253,1,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(254,NULL,'DUMMY',254,1,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(255,NULL,'DUMMY',255,1,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(256,NULL,'DUMMY',256,1,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(257,NULL,'DUMMY',257,1,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(258,NULL,'DUMMY',258,1,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(259,NULL,'DUMMY',259,1,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(260,NULL,'DUMMY',260,1,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(261,NULL,'DUMMY',261,1,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(262,NULL,'DUMMY',262,1,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(263,NULL,'DUMMY',263,1,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(264,NULL,'DUMMY',264,1,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(265,NULL,'DUMMY',265,1,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(266,NULL,'DUMMY',266,1,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(267,NULL,'DUMMY',267,1,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(268,NULL,'DUMMY',268,1,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(269,NULL,'DUMMY',269,1,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(270,NULL,'DUMMY',270,1,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(271,NULL,'DUMMY',271,1,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(272,NULL,'DUMMY',272,1,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(273,NULL,'DUMMY',273,1,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(274,NULL,'DUMMY',274,1,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(275,NULL,'DUMMY',275,1,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(276,NULL,'DUMMY',276,1,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(277,NULL,'DUMMY',277,1,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(278,NULL,'DUMMY',278,1,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(279,NULL,'DUMMY',279,1,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(280,NULL,'DUMMY',280,1,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(281,NULL,'DUMMY',281,1,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(282,NULL,'DUMMY',282,1,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(283,NULL,'DUMMY',283,1,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(284,NULL,'DUMMY',284,1,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(285,NULL,'DUMMY',285,1,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(286,NULL,'DUMMY',286,1,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(287,NULL,'DUMMY',287,1,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(288,NULL,'DUMMY',288,1,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(289,NULL,'DUMMY',289,1,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(290,NULL,'DUMMY',290,1,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(291,NULL,'DUMMY',291,1,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(292,NULL,'DUMMY',292,1,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(293,NULL,'DUMMY',293,1,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(294,NULL,'DUMMY',294,1,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(295,NULL,'DUMMY',295,1,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(296,NULL,'DUMMY',296,1,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(297,NULL,'DUMMY',297,1,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(298,NULL,'DUMMY',298,1,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(299,NULL,'DUMMY',299,1,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(300,NULL,'DUMMY',300,1,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(301,NULL,'DUMMY',301,1,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(302,NULL,'DUMMY',302,1,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(303,NULL,'DUMMY',303,1,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(304,NULL,'DUMMY',304,1,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(305,NULL,'DUMMY',305,1,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(306,NULL,'DUMMY',306,1,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(307,NULL,'DUMMY',307,1,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(308,NULL,'DUMMY',308,1,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(309,NULL,'DUMMY',309,1,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(310,NULL,'DUMMY',310,1,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(311,NULL,'DUMMY',311,1,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(312,NULL,'DUMMY',312,1,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(313,NULL,'DUMMY',313,1,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(314,NULL,'DUMMY',314,1,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(315,NULL,'DUMMY',315,1,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(316,NULL,'DUMMY',316,1,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(317,NULL,'DUMMY',317,1,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(318,NULL,'DUMMY',318,1,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(319,NULL,'DUMMY',319,1,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(320,NULL,'DUMMY',320,1,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(321,NULL,'DUMMY',321,1,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(322,NULL,'DUMMY',322,1,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(323,NULL,'DUMMY',323,1,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(324,NULL,'DUMMY',324,1,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(325,NULL,'DUMMY',325,1,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(326,NULL,'DUMMY',326,1,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(327,NULL,'DUMMY',327,1,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(328,NULL,'DUMMY',328,1,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(329,NULL,'DUMMY',329,1,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(330,NULL,'DUMMY',330,1,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(331,NULL,'DUMMY',331,1,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(332,NULL,'DUMMY',332,1,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(333,NULL,'DUMMY',333,1,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(334,NULL,'DUMMY',334,1,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(335,NULL,'DUMMY',335,1,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(336,NULL,'DUMMY',336,1,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(337,NULL,'DUMMY',337,1,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(338,NULL,'DUMMY',338,1,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(339,NULL,'DUMMY',339,1,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(340,NULL,'DUMMY',340,1,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(341,NULL,'DUMMY',341,1,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(342,NULL,'DUMMY',342,1,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(343,NULL,'DUMMY',343,1,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(344,NULL,'DUMMY',344,1,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(345,NULL,'DUMMY',345,1,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(346,NULL,'DUMMY',346,1,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(347,NULL,'DUMMY',347,1,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(348,NULL,'DUMMY',348,1,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(349,NULL,'DUMMY',349,1,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(350,NULL,'DUMMY',350,1,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(351,NULL,'DUMMY',351,1,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(352,NULL,'DUMMY',352,1,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(353,NULL,'DUMMY',353,1,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(354,NULL,'DUMMY',354,1,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(355,NULL,'DUMMY',355,1,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(356,NULL,'DUMMY',356,1,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(357,NULL,'DUMMY',357,1,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(358,NULL,'DUMMY',358,1,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(359,NULL,'DUMMY',359,1,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(360,NULL,'DUMMY',360,1,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(361,NULL,'DUMMY',361,1,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(362,NULL,'DUMMY',362,1,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(363,NULL,'DUMMY',363,1,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(364,NULL,'DUMMY',364,1,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(365,NULL,'DUMMY',365,1,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(366,NULL,'DUMMY',366,1,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(367,NULL,'DUMMY',367,1,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(368,NULL,'DUMMY',368,1,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(369,NULL,'DUMMY',369,1,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(370,NULL,'DUMMY',370,1,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(371,NULL,'DUMMY',371,1,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(372,NULL,'DUMMY',372,1,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(373,NULL,'DUMMY',373,1,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(374,NULL,'DUMMY',374,1,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(375,NULL,'DUMMY',375,1,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(376,NULL,'DUMMY',376,1,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(377,NULL,'DUMMY',377,1,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(378,NULL,'DUMMY',378,1,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(379,NULL,'DUMMY',379,1,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(380,NULL,'DUMMY',380,1,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(381,NULL,'DUMMY',381,1,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(382,NULL,'DUMMY',382,1,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(383,NULL,'DUMMY',383,1,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(384,NULL,'DUMMY',384,1,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(385,NULL,'DUMMY',385,1,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(386,NULL,'DUMMY',386,1,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(387,NULL,'DUMMY',387,1,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(388,NULL,'DUMMY',388,1,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(389,NULL,'DUMMY',389,1,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(390,NULL,'DUMMY',390,1,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(391,NULL,'DUMMY',391,1,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(392,NULL,'DUMMY',392,1,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(393,NULL,'DUMMY',393,1,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(394,NULL,'DUMMY',394,1,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(395,NULL,'DUMMY',395,1,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(396,NULL,'DUMMY',396,1,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(397,NULL,'DUMMY',397,1,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(398,NULL,'DUMMY',398,1,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(399,NULL,'DUMMY',399,1,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(400,NULL,'DUMMY',400,1,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(401,NULL,'DUMMY',401,1,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(402,NULL,'DUMMY',402,1,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(403,NULL,'DUMMY',403,1,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(404,NULL,'DUMMY',404,1,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(405,NULL,'DUMMY',405,1,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(406,NULL,'DUMMY',406,1,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(407,NULL,'DUMMY',407,1,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(408,NULL,'DUMMY',408,1,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(409,NULL,'DUMMY',409,1,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(410,NULL,'DUMMY',410,1,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(411,NULL,'DUMMY',411,1,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(412,NULL,'DUMMY',412,1,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(413,NULL,'DUMMY',413,1,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(414,NULL,'DUMMY',414,1,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(415,NULL,'DUMMY',415,1,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(416,NULL,'DUMMY',416,1,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(417,NULL,'DUMMY',417,1,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(418,NULL,'DUMMY',418,1,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(419,NULL,'DUMMY',419,1,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(420,NULL,'DUMMY',420,1,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(421,NULL,'DUMMY',421,1,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(422,NULL,'DUMMY',422,1,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(423,NULL,'DUMMY',423,1,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(424,NULL,'DUMMY',424,1,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(425,NULL,'DUMMY',425,1,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(426,NULL,'DUMMY',426,1,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(427,NULL,'DUMMY',427,1,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(428,NULL,'DUMMY',428,1,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(429,NULL,'DUMMY',429,1,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(430,NULL,'DUMMY',430,1,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(431,NULL,'DUMMY',431,1,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(432,NULL,'DUMMY',432,1,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(433,NULL,'DUMMY',433,1,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(434,NULL,'DUMMY',434,1,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(435,NULL,'DUMMY',435,1,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(436,NULL,'DUMMY',436,1,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(437,NULL,'DUMMY',437,1,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(438,NULL,'DUMMY',438,1,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(439,NULL,'DUMMY',439,1,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(440,NULL,'DUMMY',440,1,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(441,NULL,'DUMMY',441,1,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(442,NULL,'DUMMY',442,1,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(443,NULL,'DUMMY',443,1,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(444,NULL,'DUMMY',444,1,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(445,NULL,'DUMMY',445,1,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(446,NULL,'DUMMY',446,1,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(447,NULL,'DUMMY',447,1,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(448,NULL,'DUMMY',448,1,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(449,NULL,'DUMMY',449,1,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(450,NULL,'DUMMY',450,1,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(451,NULL,'DUMMY',451,1,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(452,NULL,'DUMMY',452,1,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(453,NULL,'DUMMY',453,1,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(454,NULL,'DUMMY',454,1,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(455,NULL,'DUMMY',455,1,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(456,NULL,'DUMMY',456,1,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(457,NULL,'DUMMY',457,1,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(458,NULL,'DUMMY',458,1,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(459,NULL,'DUMMY',459,1,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(460,NULL,'DUMMY',460,1,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(461,NULL,'DUMMY',461,1,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(462,NULL,'DUMMY',462,1,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(463,NULL,'DUMMY',463,1,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(464,NULL,'DUMMY',464,1,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(465,NULL,'DUMMY',465,1,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(466,NULL,'DUMMY',466,1,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(467,NULL,'DUMMY',467,1,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(468,NULL,'DUMMY',468,1,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(469,NULL,'DUMMY',469,1,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(470,NULL,'DUMMY',470,1,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(471,NULL,'DUMMY',471,1,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(472,NULL,'DUMMY',472,1,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(473,NULL,'DUMMY',473,1,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(474,NULL,'DUMMY',474,1,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(475,NULL,'DUMMY',475,1,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(476,NULL,'DUMMY',476,1,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(477,NULL,'DUMMY',477,1,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(478,NULL,'DUMMY',478,1,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(479,NULL,'DUMMY',479,1,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(480,NULL,'DUMMY',480,1,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(481,NULL,'DUMMY',481,1,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(482,NULL,'DUMMY',482,1,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(483,NULL,'DUMMY',483,1,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(484,NULL,'DUMMY',484,1,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(485,NULL,'DUMMY',485,1,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(486,NULL,'DUMMY',486,1,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(487,NULL,'DUMMY',487,1,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(488,NULL,'DUMMY',488,1,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(489,NULL,'DUMMY',489,1,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(490,NULL,'DUMMY',490,1,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(491,NULL,'DUMMY',491,1,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(492,NULL,'DUMMY',492,1,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(493,NULL,'DUMMY',493,1,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(494,NULL,'DUMMY',494,1,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(495,NULL,'DUMMY',495,1,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(496,NULL,'DUMMY',496,1,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(497,NULL,'DUMMY',497,1,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(498,NULL,'DUMMY',498,1,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(499,NULL,'DUMMY',499,1,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(500,NULL,'DUMMY',500,1,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(501,NULL,'DUMMY',501,1,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(502,NULL,'DUMMY',502,1,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(503,NULL,'DUMMY',503,1,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(504,NULL,'DUMMY',504,1,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(505,NULL,'DUMMY',505,1,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(506,NULL,'DUMMY',506,1,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(507,NULL,'DUMMY',507,1,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(508,NULL,'DUMMY',508,1,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(509,NULL,'DUMMY',509,1,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(510,NULL,'DUMMY',510,1,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(511,NULL,'DUMMY',511,1,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(512,NULL,'DUMMY',512,1,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(513,NULL,'DUMMY',513,1,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(514,NULL,'DUMMY',514,1,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(515,NULL,'DUMMY',515,1,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(516,NULL,'DUMMY',516,1,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(517,NULL,'DUMMY',517,1,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(518,NULL,'DUMMY',518,1,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(519,NULL,'DUMMY',519,1,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(520,NULL,'DUMMY',520,1,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(521,NULL,'DUMMY',521,1,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(522,NULL,'DUMMY',522,1,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(523,NULL,'DUMMY',523,1,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(524,NULL,'DUMMY',524,1,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(525,NULL,'DUMMY',525,1,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(526,NULL,'DUMMY',526,1,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(527,NULL,'DUMMY',527,1,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(528,NULL,'DUMMY',528,1,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(529,NULL,'DUMMY',529,1,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(530,NULL,'DUMMY',530,1,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(531,NULL,'DUMMY',531,1,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(532,NULL,'DUMMY',532,1,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(533,NULL,'DUMMY',533,1,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(534,NULL,'DUMMY',534,1,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(535,NULL,'DUMMY',535,1,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(536,NULL,'DUMMY',536,1,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(537,NULL,'DUMMY',537,1,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(538,NULL,'DUMMY',538,1,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(539,NULL,'DUMMY',539,1,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(540,NULL,'DUMMY',540,1,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(541,NULL,'DUMMY',541,1,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(542,NULL,'DUMMY',542,1,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(543,NULL,'DUMMY',543,1,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(544,NULL,'DUMMY',544,1,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(545,NULL,'DUMMY',545,1,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(546,NULL,'DUMMY',546,1,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(547,NULL,'DUMMY',547,1,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(548,NULL,'DUMMY',548,1,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(549,NULL,'DUMMY',549,1,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(550,NULL,'DUMMY',550,1,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(551,NULL,'DUMMY',551,1,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(552,NULL,'DUMMY',552,1,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(553,NULL,'DUMMY',553,1,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(554,NULL,'DUMMY',554,1,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(555,NULL,'DUMMY',555,1,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(556,NULL,'DUMMY',556,1,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(557,NULL,'DUMMY',557,1,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(558,NULL,'DUMMY',558,1,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(559,NULL,'DUMMY',559,1,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(560,NULL,'DUMMY',560,1,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(561,NULL,'DUMMY',561,1,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(562,NULL,'DUMMY',562,1,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(563,NULL,'DUMMY',563,1,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(564,NULL,'DUMMY',564,1,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(565,NULL,'DUMMY',565,1,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(566,NULL,'DUMMY',566,1,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(567,NULL,'DUMMY',567,1,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(568,NULL,'DUMMY',568,1,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(569,NULL,'DUMMY',569,1,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(570,NULL,'DUMMY',570,1,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(571,NULL,'DUMMY',571,1,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(572,NULL,'DUMMY',572,1,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(573,NULL,'DUMMY',573,1,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(574,NULL,'DUMMY',574,1,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(575,NULL,'DUMMY',575,1,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(576,NULL,'DUMMY',576,1,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(577,NULL,'DUMMY',577,1,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(578,NULL,'DUMMY',578,1,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(579,NULL,'DUMMY',579,1,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(580,NULL,'DUMMY',580,1,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(581,NULL,'DUMMY',581,1,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(582,NULL,'DUMMY',582,1,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(583,NULL,'DUMMY',583,1,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(584,NULL,'DUMMY',584,1,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(585,NULL,'DUMMY',585,1,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(586,NULL,'DUMMY',586,1,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(587,NULL,'DUMMY',587,1,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(588,NULL,'DUMMY',588,1,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(589,NULL,'DUMMY',589,1,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(590,NULL,'DUMMY',590,1,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(591,NULL,'DUMMY',591,1,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(592,NULL,'DUMMY',592,1,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(593,NULL,'DUMMY',593,1,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(594,NULL,'DUMMY',594,1,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(595,NULL,'DUMMY',595,1,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(596,NULL,'DUMMY',596,1,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(597,NULL,'DUMMY',597,1,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(598,NULL,'DUMMY',598,1,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(599,NULL,'DUMMY',599,1,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(600,NULL,'DUMMY',600,1,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(601,NULL,'DUMMY',601,1,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(602,NULL,'DUMMY',602,1,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(603,NULL,'DUMMY',603,1,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(604,NULL,'DUMMY',604,1,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(605,NULL,'DUMMY',605,1,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(606,NULL,'DUMMY',606,1,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(607,NULL,'DUMMY',607,1,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(608,NULL,'DUMMY',608,1,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(609,NULL,'DUMMY',609,1,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(610,NULL,'DUMMY',610,1,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(611,NULL,'DUMMY',611,1,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(612,NULL,'DUMMY',612,1,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(613,NULL,'DUMMY',613,1,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(614,NULL,'DUMMY',614,1,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(615,NULL,'DUMMY',615,1,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(616,NULL,'DUMMY',616,1,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(617,NULL,'DUMMY',617,1,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(618,NULL,'DUMMY',618,1,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(619,NULL,'DUMMY',619,1,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(620,NULL,'DUMMY',620,1,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(621,NULL,'DUMMY',621,1,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(622,NULL,'DUMMY',622,1,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(623,NULL,'DUMMY',623,1,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(624,NULL,'DUMMY',624,1,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(625,NULL,'DUMMY',625,1,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(626,NULL,'DUMMY',626,1,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(627,NULL,'DUMMY',627,1,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(628,NULL,'DUMMY',628,1,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(629,NULL,'DUMMY',629,1,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(630,NULL,'DUMMY',630,1,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(631,NULL,'DUMMY',631,1,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(632,NULL,'DUMMY',632,1,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(633,NULL,'DUMMY',633,1,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(634,NULL,'DUMMY',634,1,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(635,NULL,'DUMMY',635,1,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(636,NULL,'DUMMY',636,1,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(637,NULL,'DUMMY',637,1,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(638,NULL,'DUMMY',638,1,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(639,NULL,'DUMMY',639,1,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(640,NULL,'DUMMY',640,1,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(641,NULL,'DUMMY',641,1,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(642,NULL,'DUMMY',642,1,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(643,NULL,'DUMMY',643,1,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(644,NULL,'DUMMY',644,1,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(645,NULL,'DUMMY',645,1,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(646,NULL,'DUMMY',646,1,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(647,NULL,'DUMMY',647,1,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(648,NULL,'DUMMY',648,1,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(649,NULL,'DUMMY',649,1,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(650,NULL,'DUMMY',650,1,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(651,NULL,'DUMMY',651,1,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(652,NULL,'DUMMY',652,1,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(653,NULL,'DUMMY',653,1,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(654,NULL,'DUMMY',654,1,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(655,NULL,'DUMMY',655,1,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(656,NULL,'DUMMY',656,1,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(657,NULL,'DUMMY',657,1,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(658,NULL,'DUMMY',658,1,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(659,NULL,'DUMMY',659,1,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(660,NULL,'DUMMY',660,1,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(661,NULL,'DUMMY',661,1,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(662,NULL,'DUMMY',662,1,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(663,NULL,'DUMMY',663,1,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(664,NULL,'DUMMY',664,1,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(665,NULL,'DUMMY',665,1,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(666,NULL,'DUMMY',666,1,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(667,NULL,'DUMMY',667,1,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(668,NULL,'DUMMY',668,1,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(669,NULL,'DUMMY',669,1,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(670,NULL,'DUMMY',670,1,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(671,NULL,'DUMMY',671,1,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(672,NULL,'DUMMY',672,1,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(673,NULL,'DUMMY',673,1,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(674,NULL,'DUMMY',674,1,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(675,NULL,'DUMMY',675,1,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(676,NULL,'DUMMY',676,1,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(677,NULL,'DUMMY',677,1,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(678,NULL,'DUMMY',678,1,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(679,NULL,'DUMMY',679,1,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(680,NULL,'DUMMY',680,1,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(681,NULL,'DUMMY',681,1,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(682,NULL,'DUMMY',682,1,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(683,NULL,'DUMMY',683,1,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(684,NULL,'DUMMY',684,1,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(685,NULL,'DUMMY',685,1,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(686,NULL,'DUMMY',686,1,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(687,NULL,'DUMMY',687,1,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(688,NULL,'DUMMY',688,1,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(689,NULL,'DUMMY',689,1,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(690,NULL,'DUMMY',690,1,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(691,NULL,'DUMMY',691,1,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(692,NULL,'DUMMY',692,1,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(693,NULL,'DUMMY',693,1,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(694,NULL,'DUMMY',694,1,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(695,NULL,'DUMMY',695,1,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(696,NULL,'DUMMY',696,1,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(697,NULL,'DUMMY',697,1,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(698,NULL,'DUMMY',698,1,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(699,NULL,'DUMMY',699,1,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(700,NULL,'DUMMY',700,1,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(701,NULL,'DUMMY',701,1,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(702,NULL,'DUMMY',702,1,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(703,NULL,'DUMMY',703,1,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(704,NULL,'DUMMY',704,1,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(705,NULL,'DUMMY',705,1,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(706,NULL,'DUMMY',706,1,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(707,NULL,'DUMMY',707,1,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(708,NULL,'DUMMY',708,1,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(709,NULL,'DUMMY',709,1,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(710,NULL,'DUMMY',710,1,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(711,NULL,'DUMMY',711,1,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(712,NULL,'DUMMY',712,1,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(713,NULL,'DUMMY',713,1,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(714,NULL,'DUMMY',714,1,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(715,NULL,'DUMMY',715,1,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(716,NULL,'DUMMY',716,1,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(717,NULL,'DUMMY',717,1,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(718,NULL,'DUMMY',718,1,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(719,NULL,'DUMMY',719,1,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(720,NULL,'DUMMY',720,1,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(721,NULL,'DUMMY',721,1,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(722,NULL,'DUMMY',722,1,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(723,NULL,'DUMMY',723,1,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(724,NULL,'DUMMY',724,1,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(725,NULL,'DUMMY',725,1,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(726,NULL,'DUMMY',726,1,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(727,NULL,'DUMMY',727,1,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(728,NULL,'DUMMY',728,1,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(729,NULL,'DUMMY',729,1,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(730,NULL,'DUMMY',730,1,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(731,NULL,'DUMMY',731,1,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(732,NULL,'DUMMY',732,1,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(733,NULL,'DUMMY',733,1,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(734,NULL,'DUMMY',734,1,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(735,NULL,'DUMMY',735,1,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(736,NULL,'DUMMY',736,1,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(737,NULL,'DUMMY',737,1,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(738,NULL,'DUMMY',738,1,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(739,NULL,'DUMMY',739,1,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(740,NULL,'DUMMY',740,1,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(741,NULL,'DUMMY',741,1,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(742,NULL,'DUMMY',742,1,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(743,NULL,'DUMMY',743,1,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(744,NULL,'DUMMY',744,1,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(745,NULL,'DUMMY',745,1,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(746,NULL,'DUMMY',746,1,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(747,NULL,'DUMMY',747,1,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(748,NULL,'DUMMY',748,1,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(749,NULL,'DUMMY',749,1,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(750,NULL,'DUMMY',750,1,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(751,NULL,'DUMMY',751,1,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(752,NULL,'DUMMY',752,1,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(753,NULL,'DUMMY',753,1,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(754,NULL,'DUMMY',754,1,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(755,NULL,'DUMMY',755,1,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(756,NULL,'DUMMY',756,1,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(757,NULL,'DUMMY',757,1,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(758,NULL,'DUMMY',758,1,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(759,NULL,'DUMMY',759,1,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(760,NULL,'DUMMY',760,1,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(761,NULL,'DUMMY',761,1,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(762,NULL,'DUMMY',762,1,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(763,NULL,'DUMMY',763,1,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(764,NULL,'DUMMY',764,1,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(765,NULL,'DUMMY',765,1,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(766,NULL,'DUMMY',766,1,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(767,NULL,'DUMMY',767,1,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(768,NULL,'DUMMY',768,1,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(769,NULL,'DUMMY',769,1,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(770,NULL,'DUMMY',770,1,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(771,NULL,'DUMMY',771,1,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(772,NULL,'DUMMY',772,1,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(773,NULL,'DUMMY',773,1,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(774,NULL,'DUMMY',774,1,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(775,NULL,'DUMMY',775,1,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(776,NULL,'DUMMY',776,1,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(777,NULL,'DUMMY',777,1,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(778,NULL,'DUMMY',778,1,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(779,NULL,'DUMMY',779,1,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(780,NULL,'DUMMY',780,1,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(781,NULL,'DUMMY',781,1,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(782,NULL,'DUMMY',782,1,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(783,NULL,'DUMMY',783,1,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(784,NULL,'DUMMY',784,1,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(785,NULL,'DUMMY',785,1,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(786,NULL,'DUMMY',786,1,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(787,NULL,'DUMMY',787,1,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(788,NULL,'DUMMY',788,1,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(789,NULL,'DUMMY',789,1,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(790,NULL,'DUMMY',790,1,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(791,NULL,'DUMMY',791,1,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(792,NULL,'DUMMY',792,1,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(793,NULL,'DUMMY',793,1,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(794,NULL,'DUMMY',794,1,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(795,NULL,'DUMMY',795,1,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(796,NULL,'DUMMY',796,1,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(797,NULL,'DUMMY',797,1,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(798,NULL,'DUMMY',798,1,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(799,NULL,'DUMMY',799,1,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(800,NULL,'DUMMY',800,1,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(801,NULL,'DUMMY',801,1,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(802,NULL,'DUMMY',802,1,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(803,NULL,'DUMMY',803,1,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(804,NULL,'DUMMY',804,1,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(805,NULL,'DUMMY',805,1,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(806,NULL,'DUMMY',806,1,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(807,NULL,'DUMMY',807,1,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(808,NULL,'DUMMY',808,1,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(809,NULL,'DUMMY',809,1,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(810,NULL,'DUMMY',810,1,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(811,NULL,'DUMMY',811,1,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(812,NULL,'DUMMY',812,1,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(813,NULL,'DUMMY',813,1,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(814,NULL,'DUMMY',814,1,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(815,NULL,'DUMMY',815,1,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(816,NULL,'DUMMY',816,1,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(817,NULL,'DUMMY',817,1,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(818,NULL,'DUMMY',818,1,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(819,NULL,'DUMMY',819,1,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(820,NULL,'DUMMY',820,1,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(821,NULL,'DUMMY',821,1,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(822,NULL,'DUMMY',822,1,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(823,NULL,'DUMMY',823,1,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(824,NULL,'DUMMY',824,1,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(825,NULL,'DUMMY',825,1,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(826,NULL,'DUMMY',826,1,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(827,NULL,'DUMMY',827,1,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(828,NULL,'DUMMY',828,1,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(829,NULL,'DUMMY',829,1,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(830,NULL,'DUMMY',830,1,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(831,NULL,'DUMMY',831,1,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(832,NULL,'DUMMY',832,1,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(833,NULL,'DUMMY',833,1,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(834,NULL,'DUMMY',834,1,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(835,NULL,'DUMMY',835,1,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(836,NULL,'DUMMY',836,1,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(837,NULL,'DUMMY',837,1,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(838,NULL,'DUMMY',838,1,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(839,NULL,'DUMMY',839,1,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(840,NULL,'DUMMY',840,1,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(841,NULL,'DUMMY',841,1,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(842,NULL,'DUMMY',842,1,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(843,NULL,'DUMMY',843,1,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(844,NULL,'DUMMY',844,1,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(845,NULL,'DUMMY',845,1,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(846,NULL,'DUMMY',846,1,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(847,NULL,'DUMMY',847,1,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(848,NULL,'DUMMY',848,1,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(849,NULL,'DUMMY',849,1,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(850,NULL,'DUMMY',850,1,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(851,NULL,'DUMMY',851,1,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(852,NULL,'DUMMY',852,1,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(853,NULL,'DUMMY',853,1,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(854,NULL,'DUMMY',854,1,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(855,NULL,'DUMMY',855,1,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(856,NULL,'DUMMY',856,1,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(857,NULL,'DUMMY',857,1,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(858,NULL,'DUMMY',858,1,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(859,NULL,'DUMMY',859,1,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(860,NULL,'DUMMY',860,1,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(861,NULL,'DUMMY',861,1,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(862,NULL,'DUMMY',862,1,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(863,NULL,'DUMMY',863,1,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(864,NULL,'DUMMY',864,1,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(865,NULL,'DUMMY',865,1,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(866,NULL,'DUMMY',866,1,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(867,NULL,'DUMMY',867,1,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(868,NULL,'DUMMY',868,1,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(869,NULL,'DUMMY',869,1,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(870,NULL,'DUMMY',870,1,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(871,NULL,'DUMMY',871,1,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(872,NULL,'DUMMY',872,1,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(873,NULL,'DUMMY',873,1,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(874,NULL,'DUMMY',874,1,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(875,NULL,'DUMMY',875,1,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(876,NULL,'DUMMY',876,1,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(877,NULL,'DUMMY',877,1,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(878,NULL,'DUMMY',878,1,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(879,NULL,'DUMMY',879,1,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(880,NULL,'DUMMY',880,1,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(881,NULL,'DUMMY',881,1,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(882,NULL,'DUMMY',882,1,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(883,NULL,'DUMMY',883,1,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(884,NULL,'DUMMY',884,1,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(885,NULL,'DUMMY',885,1,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(886,NULL,'DUMMY',886,1,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(887,NULL,'DUMMY',887,1,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(888,NULL,'DUMMY',888,1,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(889,NULL,'DUMMY',889,1,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(890,NULL,'DUMMY',890,1,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(891,NULL,'DUMMY',891,1,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(892,NULL,'DUMMY',892,1,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(893,NULL,'DUMMY',893,1,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(894,NULL,'DUMMY',894,1,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(895,NULL,'DUMMY',895,1,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(896,NULL,'DUMMY',896,1,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(897,NULL,'DUMMY',897,1,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(898,NULL,'DUMMY',898,1,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(899,NULL,'DUMMY',899,1,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(900,NULL,'DUMMY',900,1,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(901,NULL,'DUMMY',901,1,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(902,NULL,'DUMMY',902,1,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(903,NULL,'DUMMY',903,1,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(904,NULL,'DUMMY',904,1,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(905,NULL,'DUMMY',905,1,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(906,NULL,'DUMMY',906,1,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(907,NULL,'DUMMY',907,1,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(908,NULL,'DUMMY',908,1,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(909,NULL,'DUMMY',909,1,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(910,NULL,'DUMMY',910,1,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(911,NULL,'DUMMY',911,1,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(912,NULL,'DUMMY',912,1,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(913,NULL,'DUMMY',913,1,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(914,NULL,'DUMMY',914,1,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(915,NULL,'DUMMY',915,1,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(916,NULL,'DUMMY',916,1,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(917,NULL,'DUMMY',917,1,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(918,NULL,'DUMMY',918,1,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(919,NULL,'DUMMY',919,1,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(920,NULL,'DUMMY',920,1,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(921,NULL,'DUMMY',921,1,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(922,NULL,'DUMMY',922,1,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(923,NULL,'DUMMY',923,1,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(924,NULL,'DUMMY',924,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(925,NULL,'DUMMY',925,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(926,NULL,'DUMMY',926,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(927,NULL,'DUMMY',927,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(928,NULL,'DUMMY',928,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(929,NULL,'DUMMY',929,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(930,NULL,'DUMMY',930,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(931,NULL,'DUMMY',931,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(932,NULL,'DUMMY',932,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(933,NULL,'DUMMY',933,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(934,NULL,'DUMMY',934,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(935,NULL,'DUMMY',935,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(936,NULL,'DUMMY',936,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(937,NULL,'DUMMY',937,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(938,NULL,'DUMMY',938,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(939,NULL,'DUMMY',939,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(940,NULL,'DUMMY',940,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(941,NULL,'DUMMY',941,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(942,NULL,'DUMMY',942,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(943,NULL,'DUMMY',943,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(944,NULL,'DUMMY',944,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(945,NULL,'DUMMY',945,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(946,NULL,'DUMMY',946,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(947,NULL,'DUMMY',947,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(948,NULL,'DUMMY',948,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(949,NULL,'DUMMY',949,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(950,NULL,'DUMMY',950,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(951,NULL,'DUMMY',951,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(952,NULL,'DUMMY',952,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(953,NULL,'DUMMY',953,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(954,NULL,'DUMMY',954,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(955,NULL,'DUMMY',955,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(956,NULL,'DUMMY',956,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(957,NULL,'DUMMY',957,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(958,NULL,'DUMMY',958,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(959,NULL,'DUMMY',959,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(960,NULL,'DUMMY',960,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(961,NULL,'DUMMY',961,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(962,NULL,'DUMMY',962,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(963,NULL,'DUMMY',963,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(964,NULL,'DUMMY',964,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(965,NULL,'DUMMY',965,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(966,NULL,'DUMMY',966,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(967,NULL,'DUMMY',967,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(968,NULL,'DUMMY',968,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(969,NULL,'DUMMY',969,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(970,NULL,'DUMMY',970,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(971,NULL,'DUMMY',971,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(972,NULL,'DUMMY',972,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(973,NULL,'DUMMY',973,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(974,NULL,'DUMMY',974,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(975,NULL,'DUMMY',975,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(976,NULL,'DUMMY',976,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(977,NULL,'DUMMY',977,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(978,NULL,'DUMMY',978,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(979,NULL,'DUMMY',979,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(980,NULL,'DUMMY',980,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(981,NULL,'DUMMY',981,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(982,NULL,'DUMMY',982,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(983,NULL,'DUMMY',983,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(984,NULL,'DUMMY',984,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(985,NULL,'DUMMY',985,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(986,NULL,'DUMMY',986,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(987,NULL,'DUMMY',987,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(988,NULL,'DUMMY',988,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(989,NULL,'DUMMY',989,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(990,NULL,'DUMMY',990,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(991,NULL,'DUMMY',991,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(992,NULL,'DUMMY',992,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(993,NULL,'DUMMY',993,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(994,NULL,'DUMMY',994,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(995,NULL,'DUMMY',995,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(996,NULL,'DUMMY',996,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(997,NULL,'DUMMY',997,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(998,NULL,'DUMMY',998,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(999,NULL,'DUMMY',999,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(1000,NULL,'DUMMY',1000,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(1001,NULL,'DUMMY',1001,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(1002,NULL,'DUMMY',1002,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(1003,NULL,'DUMMY',1003,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(1004,NULL,'DUMMY',1004,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(1005,NULL,'DUMMY',1005,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(1006,NULL,'DUMMY',1006,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(1007,NULL,'DUMMY',1007,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(1008,NULL,'DUMMY',1008,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(1009,NULL,'DUMMY',1009,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(1010,NULL,'DUMMY',1010,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(1011,NULL,'DUMMY',1011,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(1012,NULL,'DUMMY',1012,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(1013,NULL,'DUMMY',1013,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(1014,NULL,'DUMMY',1014,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(1015,NULL,'DUMMY',1015,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(1016,NULL,'DUMMY',1016,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(1017,NULL,'DUMMY',1017,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(1018,NULL,'DUMMY',1018,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(1019,NULL,'DUMMY',1019,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(1020,NULL,'DUMMY',1020,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(1021,NULL,'DUMMY',1021,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(1022,NULL,'DUMMY',1022,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(1023,NULL,'DUMMY',1023,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(1024,NULL,'DUMMY',1024,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(1025,NULL,'DUMMY',1025,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(1026,NULL,'DUMMY',1026,1,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(1027,NULL,'DUMMY',1027,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1028,NULL,'DUMMY',1028,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1029,NULL,'DUMMY',1029,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1030,NULL,'DUMMY',1030,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1031,NULL,'DUMMY',1031,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1032,NULL,'DUMMY',1032,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1033,NULL,'DUMMY',1033,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1034,NULL,'DUMMY',1034,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1035,NULL,'DUMMY',1035,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1036,NULL,'DUMMY',1036,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1037,NULL,'DUMMY',1037,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1038,NULL,'DUMMY',1038,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1039,NULL,'DUMMY',1039,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1040,NULL,'DUMMY',1040,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1041,NULL,'DUMMY',1041,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1042,NULL,'DUMMY',1042,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1043,NULL,'DUMMY',1043,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1044,NULL,'DUMMY',1044,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1045,NULL,'DUMMY',1045,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1046,NULL,'DUMMY',1046,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1047,NULL,'DUMMY',1047,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1048,NULL,'DUMMY',1048,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1049,NULL,'DUMMY',1049,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1050,NULL,'DUMMY',1050,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1051,NULL,'DUMMY',1051,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1052,NULL,'DUMMY',1052,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1053,NULL,'DUMMY',1053,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1054,NULL,'DUMMY',1054,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1055,NULL,'DUMMY',1055,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1056,NULL,'DUMMY',1056,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1057,NULL,'DUMMY',1057,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1058,NULL,'DUMMY',1058,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1059,NULL,'DUMMY',1059,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1060,NULL,'DUMMY',1060,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1061,NULL,'DUMMY',1061,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1062,NULL,'DUMMY',1062,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1063,NULL,'DUMMY',1063,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1064,NULL,'DUMMY',1064,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1065,NULL,'DUMMY',1065,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1066,NULL,'DUMMY',1066,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1067,NULL,'DUMMY',1067,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1068,NULL,'DUMMY',1068,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1069,NULL,'DUMMY',1069,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1070,NULL,'DUMMY',1070,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1071,NULL,'DUMMY',1071,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1072,NULL,'DUMMY',1072,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1073,NULL,'DUMMY',1073,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1074,NULL,'DUMMY',1074,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1075,NULL,'DUMMY',1075,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1076,NULL,'DUMMY',1076,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1077,NULL,'DUMMY',1077,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1078,NULL,'DUMMY',1078,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1079,NULL,'DUMMY',1079,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1080,NULL,'DUMMY',1080,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1081,NULL,'DUMMY',1081,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1082,NULL,'DUMMY',1082,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1083,NULL,'DUMMY',1083,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1084,NULL,'DUMMY',1084,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1085,NULL,'DUMMY',1085,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1086,NULL,'DUMMY',1086,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1087,NULL,'DUMMY',1087,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1088,NULL,'DUMMY',1088,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1089,NULL,'DUMMY',1089,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1090,NULL,'DUMMY',1090,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1091,NULL,'DUMMY',1091,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1092,NULL,'DUMMY',1092,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1093,NULL,'DUMMY',1093,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1094,NULL,'DUMMY',1094,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1095,NULL,'DUMMY',1095,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1096,NULL,'DUMMY',1096,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1097,NULL,'DUMMY',1097,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1098,NULL,'DUMMY',1098,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1099,NULL,'DUMMY',1099,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1100,NULL,'DUMMY',1100,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1101,NULL,'DUMMY',1101,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1102,NULL,'DUMMY',1102,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1103,NULL,'DUMMY',1103,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1104,NULL,'DUMMY',1104,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1105,NULL,'DUMMY',1105,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1106,NULL,'DUMMY',1106,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1107,NULL,'DUMMY',1107,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1108,NULL,'DUMMY',1108,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1109,NULL,'DUMMY',1109,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1110,NULL,'DUMMY',1110,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1111,NULL,'DUMMY',1111,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1112,NULL,'DUMMY',1112,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1113,NULL,'DUMMY',1113,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1114,NULL,'DUMMY',1114,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1115,NULL,'DUMMY',1115,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1116,NULL,'DUMMY',1116,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1117,NULL,'DUMMY',1117,1,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1118,NULL,'DUMMY',1118,1,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1119,NULL,'DUMMY',1119,1,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1120,NULL,'DUMMY',1120,1,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1121,NULL,'DUMMY',1121,1,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1122,NULL,'DUMMY',1122,1,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1123,NULL,'DUMMY',1123,1,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1124,NULL,'DUMMY',1124,1,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1125,NULL,'DUMMY',1125,1,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1126,NULL,'DUMMY',1126,1,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1127,NULL,'DUMMY',1127,1,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1128,NULL,'DUMMY',1128,1,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1129,NULL,'DUMMY',1129,1,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1130,NULL,'DUMMY',1130,1,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1131,NULL,'DUMMY',1131,1,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1132,NULL,'DUMMY',1132,1,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1133,NULL,'DUMMY',1133,1,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1134,NULL,'DUMMY',1134,1,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1135,NULL,'DUMMY',1135,1,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1136,NULL,'DUMMY',1136,1,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1137,NULL,'DUMMY',1137,1,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1138,NULL,'DUMMY',1138,1,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1139,NULL,'DUMMY',1139,1,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1140,NULL,'DUMMY',1140,1,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1141,NULL,'DUMMY',1141,1,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1142,NULL,'DUMMY',1142,1,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1143,NULL,'DUMMY',1143,1,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1144,NULL,'DUMMY',1144,1,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1145,NULL,'DUMMY',1145,1,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1146,NULL,'DUMMY',1146,1,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1147,NULL,'DUMMY',1147,1,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1148,NULL,'DUMMY',1148,1,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1149,NULL,'DUMMY',1149,1,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1150,NULL,'DUMMY',1150,1,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1151,NULL,'DUMMY',1151,1,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1152,NULL,'DUMMY',1152,1,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1153,NULL,'DUMMY',1153,1,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1154,NULL,'DUMMY',1154,1,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1155,NULL,'DUMMY',1155,1,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1156,NULL,'DUMMY',1156,1,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1157,NULL,'DUMMY',1157,1,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1158,NULL,'DUMMY',1158,1,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1159,NULL,'DUMMY',1159,1,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1160,NULL,'DUMMY',1160,1,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1161,NULL,'DUMMY',1161,1,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1162,NULL,'DUMMY',1162,1,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1163,NULL,'DUMMY',1163,1,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1164,NULL,'DUMMY',1164,1,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1165,NULL,'DUMMY',1165,1,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1166,NULL,'DUMMY',1166,1,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1167,NULL,'DUMMY',1167,1,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1168,NULL,'DUMMY',1168,1,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1169,NULL,'DUMMY',1169,1,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1170,NULL,'DUMMY',1170,1,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1171,NULL,'DUMMY',1171,1,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1172,NULL,'DUMMY',1172,1,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1173,NULL,'DUMMY',1173,1,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1174,NULL,'DUMMY',1174,1,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1175,NULL,'DUMMY',1175,1,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1176,NULL,'DUMMY',1176,1,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1177,NULL,'DUMMY',1177,1,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1178,NULL,'DUMMY',1178,1,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1179,NULL,'DUMMY',1179,1,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1180,NULL,'DUMMY',1180,1,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1181,NULL,'DUMMY',1181,1,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1182,NULL,'DUMMY',1182,1,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1183,NULL,'DUMMY',1183,1,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1184,NULL,'DUMMY',1184,1,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1185,NULL,'DUMMY',1185,1,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1186,NULL,'DUMMY',1186,1,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1187,NULL,'DUMMY',1187,1,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1188,NULL,'DUMMY',1188,1,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1189,NULL,'DUMMY',1189,1,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1190,NULL,'DUMMY',1190,1,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1191,NULL,'DUMMY',1191,1,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1192,NULL,'DUMMY',1192,1,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1193,NULL,'DUMMY',1193,1,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1194,NULL,'DUMMY',1194,1,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1195,NULL,'DUMMY',1195,1,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1196,NULL,'DUMMY',1196,1,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1197,NULL,'DUMMY',1197,1,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1198,NULL,'DUMMY',1198,1,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1199,NULL,'DUMMY',1199,1,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1200,NULL,'DUMMY',1200,1,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1201,NULL,'DUMMY',1201,1,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1202,NULL,'DUMMY',1202,1,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1203,NULL,'DUMMY',1203,1,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1204,NULL,'DUMMY',1204,1,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1205,NULL,'DUMMY',1205,1,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1206,NULL,'DUMMY',1206,1,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1207,NULL,'DUMMY',1207,1,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1208,NULL,'DUMMY',1208,1,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1209,NULL,'DUMMY',1209,1,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1210,NULL,'DUMMY',1210,1,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1211,NULL,'DUMMY',1211,1,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1212,NULL,'DUMMY',1212,1,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1213,NULL,'DUMMY',1213,1,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1214,NULL,'DUMMY',1214,1,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1215,NULL,'DUMMY',1215,1,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1216,NULL,'DUMMY',1216,1,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1217,NULL,'DUMMY',1217,1,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1218,NULL,'DUMMY',1218,1,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1219,NULL,'DUMMY',1219,1,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1220,NULL,'DUMMY',1220,1,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1221,NULL,'DUMMY',1221,1,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1222,NULL,'DUMMY',1222,1,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1223,NULL,'DUMMY',1223,1,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1224,NULL,'DUMMY',1224,1,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1225,NULL,'DUMMY',1225,1,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1226,NULL,'DUMMY',1226,1,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1227,NULL,'DUMMY',1227,1,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1228,NULL,'DUMMY',1228,1,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1229,NULL,'DUMMY',1229,1,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1230,NULL,'DUMMY',1230,1,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1231,NULL,'DUMMY',1231,1,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1232,NULL,'DUMMY',1232,1,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1233,NULL,'DUMMY',1233,1,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1234,NULL,'DUMMY',1234,1,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1235,NULL,'DUMMY',1235,1,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1236,NULL,'DUMMY',1236,1,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1237,NULL,'DUMMY',1237,1,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1238,NULL,'DUMMY',1238,1,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1239,NULL,'DUMMY',1239,1,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1240,NULL,'DUMMY',1240,1,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1241,NULL,'DUMMY',1241,1,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1242,NULL,'DUMMY',1242,1,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1243,NULL,'DUMMY',1243,1,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1244,NULL,'DUMMY',1244,1,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1245,NULL,'DUMMY',1245,1,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1246,NULL,'DUMMY',1246,1,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1247,NULL,'DUMMY',1247,1,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1248,NULL,'DUMMY',1248,1,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1249,NULL,'DUMMY',1249,1,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1250,NULL,'DUMMY',1250,1,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1251,NULL,'DUMMY',1251,1,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1252,NULL,'DUMMY',1252,1,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1253,NULL,'DUMMY',1253,1,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1254,NULL,'DUMMY',1254,1,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1255,NULL,'DUMMY',1255,1,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1256,NULL,'DUMMY',1256,1,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1257,NULL,'DUMMY',1257,1,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1258,NULL,'DUMMY',1258,1,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1259,NULL,'DUMMY',1259,1,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1260,NULL,'DUMMY',1260,1,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1261,NULL,'DUMMY',1261,1,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1262,NULL,'DUMMY',1262,1,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1263,NULL,'DUMMY',1263,1,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1264,NULL,'DUMMY',1264,1,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1265,NULL,'DUMMY',1265,1,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1266,NULL,'DUMMY',1266,1,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1267,NULL,'DUMMY',1267,1,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1268,NULL,'DUMMY',1268,1,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1269,NULL,'DUMMY',1269,1,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1270,NULL,'DUMMY',1270,1,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1271,NULL,'DUMMY',1271,1,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1272,NULL,'DUMMY',1272,1,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1273,NULL,'DUMMY',1273,1,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1274,NULL,'DUMMY',1274,1,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1275,NULL,'DUMMY',1275,1,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1276,NULL,'DUMMY',1276,1,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1277,NULL,'DUMMY',1277,1,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1278,NULL,'DUMMY',1278,1,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1279,NULL,'DUMMY',1279,1,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1280,NULL,'DUMMY',1280,1,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1281,NULL,'DUMMY',1281,1,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1282,NULL,'DUMMY',1282,1,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1283,NULL,'DUMMY',1283,1,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1284,NULL,'DUMMY',1284,1,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1285,NULL,'DUMMY',1285,1,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1286,NULL,'DUMMY',1286,1,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1287,NULL,'DUMMY',1287,1,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1288,NULL,'DUMMY',1288,1,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1289,NULL,'DUMMY',1289,1,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1290,NULL,'DUMMY',1290,1,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1291,NULL,'DUMMY',1291,1,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1292,NULL,'DUMMY',1292,1,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1293,NULL,'DUMMY',1293,1,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1294,NULL,'DUMMY',1294,1,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1295,NULL,'DUMMY',1295,1,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1296,NULL,'DUMMY',1296,1,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1297,NULL,'DUMMY',1297,1,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1298,NULL,'DUMMY',1298,1,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1299,NULL,'DUMMY',1299,1,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1300,NULL,'DUMMY',1300,1,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1301,NULL,'DUMMY',1301,1,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1302,NULL,'DUMMY',1302,1,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1303,NULL,'DUMMY',1303,1,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1304,NULL,'DUMMY',1304,1,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1305,NULL,'DUMMY',1305,1,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1306,NULL,'DUMMY',1306,1,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1307,NULL,'DUMMY',1307,1,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1308,NULL,'DUMMY',1308,1,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1309,NULL,'DUMMY',1309,1,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1310,NULL,'DUMMY',1310,1,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1311,NULL,'DUMMY',1311,1,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1312,NULL,'DUMMY',1312,1,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1313,NULL,'DUMMY',1313,1,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1314,NULL,'DUMMY',1314,1,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1315,NULL,'DUMMY',1315,1,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1316,NULL,'DUMMY',1316,1,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1317,NULL,'DUMMY',1317,1,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1318,NULL,'DUMMY',1318,1,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1319,NULL,'DUMMY',1319,1,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1320,NULL,'DUMMY',1320,1,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1321,NULL,'DUMMY',1321,1,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1322,NULL,'DUMMY',1322,1,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1323,NULL,'DUMMY',1323,1,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1324,NULL,'DUMMY',1324,1,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1325,NULL,'DUMMY',1325,1,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1326,NULL,'DUMMY',1326,1,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1327,NULL,'DUMMY',1327,1,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1328,NULL,'DUMMY',1328,1,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1329,NULL,'DUMMY',1329,1,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1330,NULL,'DUMMY',1330,1,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1331,NULL,'DUMMY',1331,1,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1332,NULL,'DUMMY',1332,1,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1333,NULL,'DUMMY',1333,1,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1334,NULL,'DUMMY',1334,1,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1335,NULL,'DUMMY',1335,1,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1336,NULL,'DUMMY',1336,1,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1337,NULL,'DUMMY',1337,1,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1338,NULL,'DUMMY',1338,1,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1339,NULL,'DUMMY',1339,1,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1340,NULL,'DUMMY',1340,1,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1341,NULL,'DUMMY',1341,1,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1342,NULL,'DUMMY',1342,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1343,NULL,'DUMMY',1343,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1344,NULL,'DUMMY',1344,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1345,NULL,'DUMMY',1345,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1346,NULL,'DUMMY',1346,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1347,NULL,'DUMMY',1347,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1348,NULL,'DUMMY',1348,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1349,NULL,'DUMMY',1349,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1350,NULL,'DUMMY',1350,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1351,NULL,'DUMMY',1351,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1352,NULL,'DUMMY',1352,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1353,NULL,'DUMMY',1353,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1354,NULL,'DUMMY',1354,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1355,NULL,'DUMMY',1355,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1356,NULL,'DUMMY',1356,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1357,NULL,'DUMMY',1357,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1358,NULL,'DUMMY',1358,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1359,NULL,'DUMMY',1359,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1360,NULL,'DUMMY',1360,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1361,NULL,'DUMMY',1361,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1362,NULL,'DUMMY',1362,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1363,NULL,'DUMMY',1363,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1364,NULL,'DUMMY',1364,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1365,NULL,'DUMMY',1365,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1366,NULL,'DUMMY',1366,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1367,NULL,'DUMMY',1367,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1368,NULL,'DUMMY',1368,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1369,NULL,'DUMMY',1369,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1370,NULL,'DUMMY',1370,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1371,NULL,'DUMMY',1371,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1372,NULL,'DUMMY',1372,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1373,NULL,'DUMMY',1373,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1374,NULL,'DUMMY',1374,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1375,NULL,'DUMMY',1375,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1376,NULL,'DUMMY',1376,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1377,NULL,'DUMMY',1377,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1378,NULL,'DUMMY',1378,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1379,NULL,'DUMMY',1379,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1380,NULL,'DUMMY',1380,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1381,NULL,'DUMMY',1381,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1382,NULL,'DUMMY',1382,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1383,NULL,'DUMMY',1383,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1384,NULL,'DUMMY',1384,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1385,NULL,'DUMMY',1385,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1386,NULL,'DUMMY',1386,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1387,NULL,'DUMMY',1387,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1388,NULL,'DUMMY',1388,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1389,NULL,'DUMMY',1389,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1390,NULL,'DUMMY',1390,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1391,NULL,'DUMMY',1391,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1392,NULL,'DUMMY',1392,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1393,NULL,'DUMMY',1393,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1394,NULL,'DUMMY',1394,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1395,NULL,'DUMMY',1395,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1396,NULL,'DUMMY',1396,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1397,NULL,'DUMMY',1397,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1398,NULL,'DUMMY',1398,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1399,NULL,'DUMMY',1399,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1400,NULL,'DUMMY',1400,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1401,NULL,'DUMMY',1401,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1402,NULL,'DUMMY',1402,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1403,NULL,'DUMMY',1403,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1404,NULL,'DUMMY',1404,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1405,NULL,'DUMMY',1405,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1406,NULL,'DUMMY',1406,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1407,NULL,'DUMMY',1407,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1408,NULL,'DUMMY',1408,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1409,NULL,'DUMMY',1409,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1410,NULL,'DUMMY',1410,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1411,NULL,'DUMMY',1411,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1412,NULL,'DUMMY',1412,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1413,NULL,'DUMMY',1413,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1414,NULL,'DUMMY',1414,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1415,NULL,'DUMMY',1415,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1416,NULL,'DUMMY',1416,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1417,NULL,'DUMMY',1417,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1418,NULL,'DUMMY',1418,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1419,NULL,'DUMMY',1419,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1420,NULL,'DUMMY',1420,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1421,NULL,'DUMMY',1421,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1422,NULL,'DUMMY',1422,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1423,NULL,'DUMMY',1423,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1424,NULL,'DUMMY',1424,1,'2024-12-04 16:35:40','2024-12-04 16:35:40'),(1425,NULL,'DUMMY',1425,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1426,NULL,'DUMMY',1426,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1427,NULL,'DUMMY',1427,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1428,NULL,'DUMMY',1428,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1429,NULL,'DUMMY',1429,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1430,NULL,'DUMMY',1430,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1431,NULL,'DUMMY',1431,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1432,NULL,'DUMMY',1432,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1433,NULL,'DUMMY',1433,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1434,NULL,'DUMMY',1434,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1435,NULL,'DUMMY',1435,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1436,NULL,'DUMMY',1436,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1437,NULL,'DUMMY',1437,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1438,NULL,'DUMMY',1438,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1439,NULL,'DUMMY',1439,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1440,NULL,'DUMMY',1440,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1441,NULL,'DUMMY',1441,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1442,NULL,'DUMMY',1442,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1443,NULL,'DUMMY',1443,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1444,NULL,'DUMMY',1444,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1445,NULL,'DUMMY',1445,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1446,NULL,'DUMMY',1446,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1447,NULL,'DUMMY',1447,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1448,NULL,'DUMMY',1448,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1449,NULL,'DUMMY',1449,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1450,NULL,'DUMMY',1450,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1451,NULL,'DUMMY',1451,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1452,NULL,'DUMMY',1452,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1453,NULL,'DUMMY',1453,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1454,NULL,'DUMMY',1454,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1455,NULL,'DUMMY',1455,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1456,NULL,'DUMMY',1456,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1457,NULL,'DUMMY',1457,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1458,NULL,'DUMMY',1458,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1459,NULL,'DUMMY',1459,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1460,NULL,'DUMMY',1460,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1461,NULL,'DUMMY',1461,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1462,NULL,'DUMMY',1462,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1463,NULL,'DUMMY',1463,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1464,NULL,'DUMMY',1464,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1465,NULL,'DUMMY',1465,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1466,NULL,'DUMMY',1466,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1467,NULL,'DUMMY',1467,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1468,NULL,'DUMMY',1468,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1469,NULL,'DUMMY',1469,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1470,NULL,'DUMMY',1470,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1471,NULL,'DUMMY',1471,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1472,NULL,'DUMMY',1472,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1473,NULL,'DUMMY',1473,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1474,NULL,'DUMMY',1474,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1475,NULL,'DUMMY',1475,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1476,NULL,'DUMMY',1476,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1477,NULL,'DUMMY',1477,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1478,NULL,'DUMMY',1478,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1479,NULL,'DUMMY',1479,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1480,NULL,'DUMMY',1480,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1481,NULL,'DUMMY',1481,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1482,NULL,'DUMMY',1482,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1483,NULL,'DUMMY',1483,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1484,NULL,'DUMMY',1484,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1485,NULL,'DUMMY',1485,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1486,NULL,'DUMMY',1486,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1487,NULL,'DUMMY',1487,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1488,NULL,'DUMMY',1488,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1489,NULL,'DUMMY',1489,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1490,NULL,'DUMMY',1490,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1491,NULL,'DUMMY',1491,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1492,NULL,'DUMMY',1492,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1493,NULL,'DUMMY',1493,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1494,NULL,'DUMMY',1494,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1495,NULL,'DUMMY',1495,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1496,NULL,'DUMMY',1496,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1497,NULL,'DUMMY',1497,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1498,NULL,'DUMMY',1498,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1499,NULL,'DUMMY',1499,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1500,NULL,'DUMMY',1500,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1501,NULL,'DUMMY',1501,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1502,NULL,'DUMMY',1502,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1503,NULL,'DUMMY',1503,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1504,NULL,'DUMMY',1504,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1505,NULL,'DUMMY',1505,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1506,NULL,'DUMMY',1506,1,'2024-12-04 16:35:41','2024-12-04 16:35:41'),(1507,NULL,'DUMMY',1507,1,'2024-12-04 16:35:42','2024-12-04 16:35:42'),(1508,NULL,'DUMMY',1508,1,'2024-12-04 16:35:42','2024-12-04 16:35:42'),(1509,NULL,'DUMMY',1509,1,'2024-12-04 16:35:42','2024-12-04 16:35:42'),(1510,NULL,'DUMMY',1510,1,'2024-12-04 16:35:42','2024-12-04 16:35:42'),(1511,NULL,'DUMMY',1511,1,'2024-12-04 16:35:42','2024-12-04 16:35:42'),(1512,NULL,'DUMMY',1512,1,'2024-12-04 16:35:42','2024-12-04 16:35:42'),(1513,NULL,'DUMMY',1513,1,'2024-12-04 16:35:42','2024-12-04 16:35:42'),(1514,NULL,'DUMMY',1514,1,'2024-12-04 16:35:42','2024-12-04 16:35:42'),(1515,NULL,'DUMMY',1515,1,'2024-12-04 16:35:42','2024-12-04 16:35:42'),(1516,NULL,'DUMMY',1516,1,'2024-12-04 16:35:42','2024-12-04 16:35:42'),(1517,NULL,'DUMMY',1517,1,'2024-12-04 16:35:42','2024-12-04 16:35:42'),(1518,NULL,'DUMMY',1518,1,'2024-12-04 16:35:42','2024-12-04 16:35:42'),(1519,NULL,'DUMMY',1519,1,'2024-12-04 16:35:42','2024-12-04 16:35:42'),(1520,NULL,'DUMMY',1520,1,'2024-12-04 16:35:42','2024-12-04 16:35:42'),(1521,NULL,'DUMMY',1521,1,'2024-12-04 16:35:42','2024-12-04 16:35:42'),(1522,NULL,'DUMMY',1522,1,'2024-12-04 16:35:42','2024-12-04 16:35:42'),(1523,NULL,'DUMMY',1523,1,'2024-12-04 16:35:42','2024-12-04 16:35:42'),(1524,NULL,'DUMMY',1524,1,'2024-12-04 16:35:42','2024-12-04 16:35:42'),(1525,NULL,'DUMMY',1525,1,'2024-12-04 16:35:42','2024-12-04 16:35:42'),(1526,NULL,'DUMMY',1526,1,'2024-12-04 16:35:42','2024-12-04 16:35:42'),(1527,NULL,'DUMMY',1527,1,'2024-12-04 16:35:42','2024-12-04 16:35:42'),(1528,NULL,'DUMMY',1528,1,'2024-12-04 16:35:42','2024-12-04 16:35:42'),(1529,NULL,'DUMMY',1529,1,'2024-12-04 16:35:42','2024-12-04 16:35:42'),(1530,NULL,'DUMMY',1530,1,'2024-12-04 16:35:42','2024-12-04 16:35:42'),(1531,NULL,'DUMMY',1531,1,'2024-12-04 16:35:42','2024-12-04 16:35:42'),(1532,NULL,'DUMMY',1532,1,'2024-12-04 16:35:42','2024-12-04 16:35:42'),(1533,NULL,'DUMMY',1533,1,'2024-12-04 16:35:42','2024-12-04 16:35:42'),(1534,NULL,'DUMMY',1534,1,'2024-12-04 16:35:42','2024-12-04 16:35:42'),(1535,NULL,'DUMMY',1535,1,'2024-12-04 16:35:42','2024-12-04 16:35:42'),(1536,NULL,'DUMMY',1536,1,'2024-12-04 16:35:42','2024-12-04 16:35:42'),(1537,NULL,'DUMMY',1537,1,'2024-12-04 16:35:42','2024-12-04 16:35:42'),(1538,NULL,'DUMMY',1538,1,'2024-12-04 16:35:42','2024-12-04 16:35:42'),(1539,NULL,'DUMMY',1539,1,'2024-12-04 16:35:42','2024-12-04 16:35:42'),(1540,NULL,'DUMMY',1540,1,'2024-12-04 16:35:42','2024-12-04 16:35:42'),(1541,NULL,'DUMMY',1541,1,'2024-12-04 16:35:42','2024-12-04 16:35:42'),(1542,NULL,'DUMMY',1542,1,'2024-12-04 16:35:42','2024-12-04 16:35:42'),(1543,NULL,'DUMMY',1543,1,'2024-12-04 16:35:42','2024-12-04 16:35:42'),(1544,NULL,'DUMMY',1544,1,'2024-12-04 16:35:42','2024-12-04 16:35:42'),(1545,NULL,'DUMMY',1545,1,'2024-12-04 16:35:42','2024-12-04 16:35:42'),(1546,NULL,'DUMMY',1546,1,'2024-12-04 16:35:42','2024-12-04 16:35:42'),(1547,NULL,'DUMMY',1547,1,'2024-12-04 16:35:42','2024-12-04 16:35:42'),(1548,NULL,'DUMMY',1548,1,'2024-12-04 16:35:42','2024-12-04 16:35:42'),(1549,NULL,'DUMMY',1549,1,'2024-12-04 16:35:42','2024-12-04 16:35:42'),(1550,NULL,'DUMMY',1550,1,'2024-12-04 16:35:42','2024-12-04 16:35:42'),(1551,NULL,'DUMMY',1551,1,'2024-12-04 16:35:42','2024-12-04 16:35:42'),(1552,NULL,'DUMMY',1552,1,'2024-12-04 16:35:42','2024-12-04 16:35:42'),(1553,NULL,'DUMMY',1553,1,'2024-12-04 16:35:42','2024-12-04 16:35:42'),(1554,NULL,'DUMMY',1554,1,'2024-12-04 16:35:42','2024-12-04 16:35:42'),(1555,NULL,'DUMMY',1555,1,'2024-12-04 16:35:42','2024-12-04 16:35:42'),(1556,NULL,'DUMMY',1556,1,'2024-12-04 16:35:42','2024-12-04 16:35:42'),(1557,NULL,'DUMMY',1557,1,'2024-12-04 16:35:42','2024-12-04 16:35:42'),(1558,NULL,'DUMMY',1558,1,'2024-12-04 16:35:42','2024-12-04 16:35:42'),(1559,NULL,'DUMMY',1559,1,'2024-12-04 16:35:42','2024-12-04 16:35:42'),(1560,NULL,'DUMMY',1560,1,'2024-12-04 16:35:42','2024-12-04 16:35:42'),(1561,NULL,'DUMMY',1561,1,'2024-12-04 16:35:42','2024-12-04 16:35:42'),(1562,NULL,'DUMMY',1562,1,'2024-12-04 16:35:42','2024-12-04 16:35:42'),(1563,NULL,'DUMMY',1563,1,'2024-12-04 16:35:42','2024-12-04 16:35:42'),(1564,NULL,'DUMMY',1564,1,'2024-12-04 16:35:42','2024-12-04 16:35:42'),(1565,NULL,'DUMMY',1565,1,'2024-12-04 16:35:42','2024-12-04 16:35:42'),(1566,NULL,'DUMMY',1566,1,'2024-12-04 16:35:42','2024-12-04 16:35:42'),(1567,NULL,'DUMMY',1567,1,'2024-12-04 16:35:42','2024-12-04 16:35:42'),(1568,NULL,'DUMMY',1568,1,'2024-12-04 16:35:42','2024-12-04 16:35:42'),(1569,NULL,'DUMMY',1569,1,'2024-12-04 16:35:42','2024-12-04 16:35:42'),(1570,NULL,'DUMMY',1570,1,'2024-12-04 16:35:42','2024-12-04 16:35:42'),(1571,NULL,'DUMMY',1571,1,'2024-12-04 16:35:42','2024-12-04 16:35:42'),(1572,NULL,'DUMMY',1572,1,'2024-12-04 16:35:42','2024-12-04 16:35:42'),(1573,NULL,'DUMMY',1573,1,'2024-12-04 16:35:42','2024-12-04 16:35:42'),(1574,NULL,'DUMMY',1574,1,'2024-12-04 16:35:42','2024-12-04 16:35:42'),(1575,NULL,'DUMMY',1575,1,'2024-12-04 16:35:42','2024-12-04 16:35:42'),(1576,NULL,'DUMMY',1576,1,'2024-12-04 16:35:43','2024-12-04 16:35:43'),(1577,NULL,'DUMMY',1577,1,'2024-12-04 16:35:43','2024-12-04 16:35:43'),(1578,NULL,'DUMMY',1578,1,'2024-12-04 16:35:43','2024-12-04 16:35:43'),(1579,NULL,'DUMMY',1579,1,'2024-12-04 16:35:43','2024-12-04 16:35:43'),(1580,NULL,'DUMMY',1580,1,'2024-12-04 16:35:43','2024-12-04 16:35:43'),(1581,NULL,'DUMMY',1581,1,'2024-12-04 16:35:43','2024-12-04 16:35:43'),(1582,NULL,'DUMMY',1582,1,'2024-12-04 16:35:43','2024-12-04 16:35:43'),(1583,NULL,'DUMMY',1583,1,'2024-12-04 16:35:43','2024-12-04 16:35:43'),(1584,NULL,'DUMMY',1584,1,'2024-12-04 16:35:43','2024-12-04 16:35:43'),(1585,NULL,'DUMMY',1585,1,'2024-12-04 16:35:43','2024-12-04 16:35:43'),(1586,NULL,'DUMMY',1586,1,'2024-12-04 16:35:43','2024-12-04 16:35:43'),(1587,NULL,'DUMMY',1587,1,'2024-12-04 16:35:43','2024-12-04 16:35:43'),(1588,NULL,'DUMMY',1588,1,'2024-12-04 16:35:43','2024-12-04 16:35:43'),(1589,NULL,'DUMMY',1589,1,'2024-12-04 16:35:43','2024-12-04 16:35:43'),(1590,NULL,'DUMMY',1590,1,'2024-12-04 16:35:43','2024-12-04 16:35:43'),(1591,NULL,'DUMMY',1591,1,'2024-12-04 16:35:43','2024-12-04 16:35:43'),(1592,NULL,'DUMMY',1592,1,'2024-12-04 16:35:43','2024-12-04 16:35:43'),(1593,NULL,'DUMMY',1593,1,'2024-12-04 16:35:43','2024-12-04 16:35:43'),(1594,NULL,'DUMMY',1594,1,'2024-12-04 16:35:43','2024-12-04 16:35:43'),(1595,NULL,'DUMMY',1595,1,'2024-12-04 16:35:43','2024-12-04 16:35:43'),(1596,NULL,'DUMMY',1596,1,'2024-12-04 16:35:43','2024-12-04 16:35:43'),(1597,NULL,'DUMMY',1597,1,'2024-12-04 16:35:43','2024-12-04 16:35:43'),(1598,NULL,'DUMMY',1598,1,'2024-12-04 16:35:43','2024-12-04 16:35:43'),(1599,NULL,'DUMMY',1599,1,'2024-12-04 16:35:43','2024-12-04 16:35:43'),(1600,NULL,'DUMMY',1600,1,'2024-12-04 16:35:43','2024-12-04 16:35:43'),(1601,NULL,'DUMMY',1601,1,'2024-12-04 16:35:43','2024-12-04 16:35:43'),(1602,NULL,'DUMMY',1602,1,'2024-12-04 16:35:43','2024-12-04 16:35:43'),(1603,NULL,'DUMMY',1603,1,'2024-12-04 16:35:43','2024-12-04 16:35:43'),(1604,NULL,'DUMMY',1604,1,'2024-12-04 16:35:43','2024-12-04 16:35:43'),(1605,NULL,'DUMMY',1605,1,'2024-12-04 16:35:43','2024-12-04 16:35:43'),(1606,NULL,'DUMMY',1606,1,'2024-12-04 16:35:43','2024-12-04 16:35:43'),(1607,NULL,'DUMMY',1607,1,'2024-12-04 16:35:43','2024-12-04 16:35:43'),(1608,NULL,'DUMMY',1608,1,'2024-12-04 16:35:43','2024-12-04 16:35:43'),(1609,NULL,'DUMMY',1609,1,'2024-12-04 16:35:43','2024-12-04 16:35:43'),(1610,NULL,'DUMMY',1610,1,'2024-12-04 16:35:43','2024-12-04 16:35:43'),(1611,NULL,'DUMMY',1611,1,'2024-12-04 16:35:43','2024-12-04 16:35:43'),(1612,NULL,'DUMMY',1612,1,'2024-12-04 16:35:43','2024-12-04 16:35:43'),(1613,NULL,'DUMMY',1613,1,'2024-12-04 16:35:43','2024-12-04 16:35:43'),(1614,NULL,'DUMMY',1614,1,'2024-12-04 16:35:43','2024-12-04 16:35:43'),(1615,NULL,'DUMMY',1615,1,'2024-12-04 16:35:43','2024-12-04 16:35:43'),(1616,NULL,'DUMMY',1616,1,'2024-12-04 16:35:43','2024-12-04 16:35:43'),(1617,NULL,'DUMMY',1617,1,'2024-12-04 16:35:43','2024-12-04 16:35:43'),(1618,NULL,'DUMMY',1618,1,'2024-12-04 16:35:43','2024-12-04 16:35:43'),(1619,NULL,'DUMMY',1619,1,'2024-12-04 16:35:43','2024-12-04 16:35:43'),(1620,NULL,'DUMMY',1620,1,'2024-12-04 16:35:43','2024-12-04 16:35:43'),(1621,NULL,'DUMMY',1621,1,'2024-12-04 16:35:43','2024-12-04 16:35:43'),(1622,NULL,'DUMMY',1622,1,'2024-12-04 16:35:43','2024-12-04 16:35:43'),(1623,NULL,'DUMMY',1623,1,'2024-12-04 16:35:43','2024-12-04 16:35:43'),(1624,NULL,'DUMMY',1624,1,'2024-12-04 16:35:43','2024-12-04 16:35:43'),(1625,NULL,'DUMMY',1625,1,'2024-12-04 16:35:43','2024-12-04 16:35:43'),(1626,NULL,'DUMMY',1626,1,'2024-12-04 16:35:43','2024-12-04 16:35:43'),(1627,NULL,'DUMMY',1627,1,'2024-12-04 16:35:43','2024-12-04 16:35:43'),(1628,NULL,'DUMMY',1628,1,'2024-12-04 16:35:43','2024-12-04 16:35:43'),(1629,NULL,'DUMMY',1629,1,'2024-12-04 16:35:43','2024-12-04 16:35:43'),(1630,NULL,'DUMMY',1630,1,'2024-12-04 16:35:43','2024-12-04 16:35:43'),(1631,NULL,'DUMMY',1631,1,'2024-12-04 16:35:43','2024-12-04 16:35:43'),(1632,NULL,'DUMMY',1632,1,'2024-12-04 16:35:43','2024-12-04 16:35:43'),(1633,NULL,'DUMMY',1633,1,'2024-12-04 16:35:43','2024-12-04 16:35:43'),(1634,NULL,'DUMMY',1634,1,'2024-12-04 16:35:43','2024-12-04 16:35:43'),(1635,NULL,'DUMMY',1635,1,'2024-12-04 16:35:43','2024-12-04 16:35:43'),(1636,NULL,'DUMMY',1636,1,'2024-12-04 16:35:43','2024-12-04 16:35:43'),(1637,NULL,'DUMMY',1637,1,'2024-12-04 16:35:43','2024-12-04 16:35:43'),(1638,NULL,'DUMMY',1638,1,'2024-12-04 16:35:43','2024-12-04 16:35:43'),(1639,NULL,'DUMMY',1639,1,'2024-12-04 16:35:43','2024-12-04 16:35:43'),(1640,NULL,'DUMMY',1640,1,'2024-12-04 16:35:43','2024-12-04 16:35:43'),(1641,NULL,'DUMMY',1641,1,'2024-12-04 16:35:43','2024-12-04 16:35:43'),(1642,NULL,'DUMMY',1642,1,'2024-12-04 16:35:43','2024-12-04 16:35:43'),(1643,NULL,'DUMMY',1643,1,'2024-12-04 16:35:43','2024-12-04 16:35:43'),(1644,NULL,'DUMMY',1644,1,'2024-12-04 16:35:43','2024-12-04 16:35:43'),(1645,NULL,'DUMMY',1645,1,'2024-12-04 16:35:43','2024-12-04 16:35:43'),(1646,NULL,'DUMMY',1646,1,'2024-12-04 16:35:43','2024-12-04 16:35:43'),(1647,NULL,'DUMMY',1647,1,'2024-12-04 16:35:43','2024-12-04 16:35:43'),(1648,NULL,'DUMMY',1648,1,'2024-12-04 16:35:43','2024-12-04 16:35:43'),(1649,NULL,'DUMMY',1649,1,'2024-12-04 16:35:43','2024-12-04 16:35:43'),(1650,NULL,'DUMMY',1650,1,'2024-12-04 16:35:44','2024-12-04 16:35:44'),(1651,NULL,'DUMMY',1651,1,'2024-12-04 16:35:44','2024-12-04 16:35:44'),(1652,NULL,'DUMMY',1652,1,'2024-12-04 16:35:44','2024-12-04 16:35:44'),(1653,NULL,'DUMMY',1653,1,'2024-12-04 16:35:44','2024-12-04 16:35:44'),(1654,NULL,'DUMMY',1654,1,'2024-12-04 16:35:44','2024-12-04 16:35:44'),(1655,NULL,'DUMMY',1655,1,'2024-12-04 16:35:44','2024-12-04 16:35:44'),(1656,NULL,'DUMMY',1656,1,'2024-12-04 16:35:44','2024-12-04 16:35:44'),(1657,NULL,'DUMMY',1657,1,'2024-12-04 16:35:44','2024-12-04 16:35:44'),(1658,NULL,'DUMMY',1658,1,'2024-12-04 16:35:44','2024-12-04 16:35:44'),(1659,NULL,'DUMMY',1659,1,'2024-12-04 16:35:44','2024-12-04 16:35:44'),(1660,NULL,'DUMMY',1660,1,'2024-12-04 16:35:44','2024-12-04 16:35:44'),(1661,NULL,'DUMMY',1661,1,'2024-12-04 16:35:44','2024-12-04 16:35:44'),(1662,NULL,'DUMMY',1662,1,'2024-12-04 16:35:44','2024-12-04 16:35:44'),(1663,NULL,'DUMMY',1663,1,'2024-12-04 16:35:44','2024-12-04 16:35:44'),(1664,NULL,'DUMMY',1664,1,'2024-12-04 16:35:44','2024-12-04 16:35:44'),(1665,NULL,'DUMMY',1665,1,'2024-12-04 16:35:44','2024-12-04 16:35:44'),(1666,NULL,'DUMMY',1666,1,'2024-12-04 16:35:44','2024-12-04 16:35:44'),(1667,NULL,'DUMMY',1667,1,'2024-12-04 16:35:44','2024-12-04 16:35:44'),(1668,NULL,'DUMMY',1668,1,'2024-12-04 16:35:44','2024-12-04 16:35:44'),(1669,NULL,'DUMMY',1669,1,'2024-12-04 16:35:44','2024-12-04 16:35:44'),(1670,NULL,'DUMMY',1670,1,'2024-12-04 16:35:44','2024-12-04 16:35:44'),(1671,NULL,'DUMMY',1671,1,'2024-12-04 16:35:44','2024-12-04 16:35:44'),(1672,NULL,'DUMMY',1672,1,'2024-12-04 16:35:44','2024-12-04 16:35:44'),(1673,NULL,'DUMMY',1673,1,'2024-12-04 16:35:44','2024-12-04 16:35:44'),(1674,NULL,'DUMMY',1674,1,'2024-12-04 16:35:44','2024-12-04 16:35:44'),(1675,NULL,'DUMMY',1675,1,'2024-12-04 16:35:44','2024-12-04 16:35:44'),(1676,NULL,'DUMMY',1676,1,'2024-12-04 16:35:44','2024-12-04 16:35:44'),(1677,NULL,'DUMMY',1677,1,'2024-12-04 16:35:44','2024-12-04 16:35:44'),(1678,NULL,'DUMMY',1678,1,'2024-12-04 16:35:44','2024-12-04 16:35:44'),(1679,NULL,'DUMMY',1679,1,'2024-12-04 16:35:44','2024-12-04 16:35:44'),(1680,NULL,'DUMMY',1680,1,'2024-12-04 16:35:44','2024-12-04 16:35:44'),(1681,NULL,'DUMMY',1681,1,'2024-12-04 16:35:44','2024-12-04 16:35:44'),(1682,NULL,'DUMMY',1682,1,'2024-12-04 16:35:44','2024-12-04 16:35:44'),(1683,NULL,'DUMMY',1683,1,'2024-12-04 16:35:44','2024-12-04 16:35:44'),(1684,NULL,'DUMMY',1684,1,'2024-12-04 16:35:44','2024-12-04 16:35:44'),(1685,NULL,'DUMMY',1685,1,'2024-12-04 16:35:44','2024-12-04 16:35:44'),(1686,NULL,'DUMMY',1686,1,'2024-12-04 16:35:44','2024-12-04 16:35:44'),(1687,NULL,'DUMMY',1687,1,'2024-12-04 16:35:44','2024-12-04 16:35:44'),(1688,NULL,'DUMMY',1688,1,'2024-12-04 16:35:44','2024-12-04 16:35:44'),(1689,NULL,'DUMMY',1689,1,'2024-12-04 16:35:44','2024-12-04 16:35:44'),(1690,NULL,'DUMMY',1690,1,'2024-12-04 16:35:44','2024-12-04 16:35:44'),(1691,NULL,'DUMMY',1691,1,'2024-12-04 16:35:44','2024-12-04 16:35:44'),(1692,NULL,'DUMMY',1692,1,'2024-12-04 16:35:44','2024-12-04 16:35:44'),(1693,NULL,'DUMMY',1693,1,'2024-12-04 16:35:44','2024-12-04 16:35:44'),(1694,NULL,'DUMMY',1694,1,'2024-12-04 16:35:44','2024-12-04 16:35:44'),(1695,NULL,'DUMMY',1695,1,'2024-12-04 16:35:44','2024-12-04 16:35:44'),(1696,NULL,'DUMMY',1696,1,'2024-12-04 16:35:44','2024-12-04 16:35:44'),(1697,NULL,'DUMMY',1697,1,'2024-12-04 16:35:44','2024-12-04 16:35:44'),(1698,NULL,'DUMMY',1698,1,'2024-12-04 16:35:44','2024-12-04 16:35:44'),(1699,NULL,'DUMMY',1699,1,'2024-12-04 16:35:44','2024-12-04 16:35:44'),(1700,NULL,'DUMMY',1700,1,'2024-12-04 16:35:44','2024-12-04 16:35:44'),(1701,NULL,'DUMMY',1701,1,'2024-12-04 16:35:44','2024-12-04 16:35:44'),(1702,NULL,'DUMMY',1702,1,'2024-12-04 16:35:44','2024-12-04 16:35:44'),(1703,NULL,'DUMMY',1703,1,'2024-12-04 16:35:44','2024-12-04 16:35:44'),(1704,NULL,'DUMMY',1704,1,'2024-12-04 16:35:44','2024-12-04 16:35:44'),(1705,NULL,'DUMMY',1705,1,'2024-12-04 16:35:44','2024-12-04 16:35:44'),(1706,NULL,'DUMMY',1706,1,'2024-12-04 16:35:44','2024-12-04 16:35:44'),(1707,NULL,'DUMMY',1707,1,'2024-12-04 16:35:44','2024-12-04 16:35:44'),(1708,NULL,'DUMMY',1708,1,'2024-12-04 16:35:44','2024-12-04 16:35:44'),(1709,NULL,'DUMMY',1709,1,'2024-12-04 16:35:44','2024-12-04 16:35:44'),(1710,NULL,'DUMMY',1710,1,'2024-12-04 16:35:44','2024-12-04 16:35:44'),(1711,NULL,'DUMMY',1711,1,'2024-12-04 16:35:44','2024-12-04 16:35:44'),(1712,NULL,'DUMMY',1712,1,'2024-12-04 16:35:44','2024-12-04 16:35:44'),(1713,NULL,'DUMMY',1713,1,'2024-12-04 16:35:44','2024-12-04 16:35:44'),(1714,NULL,'DUMMY',1714,1,'2024-12-04 16:35:44','2024-12-04 16:35:44'),(1715,NULL,'DUMMY',1715,1,'2024-12-04 16:35:44','2024-12-04 16:35:44'),(1716,NULL,'DUMMY',1716,1,'2024-12-04 16:35:44','2024-12-04 16:35:44'),(1717,NULL,'DUMMY',1717,1,'2024-12-04 16:35:44','2024-12-04 16:35:44'),(1718,NULL,'DUMMY',1718,1,'2024-12-04 16:35:45','2024-12-04 16:35:45'),(1719,NULL,'DUMMY',1719,1,'2024-12-04 16:35:45','2024-12-04 16:35:45'),(1720,NULL,'DUMMY',1720,1,'2024-12-04 16:35:45','2024-12-04 16:35:45'),(1721,NULL,'DUMMY',1721,1,'2024-12-04 16:35:45','2024-12-04 16:35:45'),(1722,NULL,'DUMMY',1722,1,'2024-12-04 16:35:45','2024-12-04 16:35:45'),(1723,NULL,'DUMMY',1723,1,'2024-12-04 16:35:45','2024-12-04 16:35:45'),(1724,NULL,'DUMMY',1724,1,'2024-12-04 16:35:45','2024-12-04 16:35:45'),(1725,NULL,'DUMMY',1725,1,'2024-12-04 16:35:45','2024-12-04 16:35:45'),(1726,NULL,'DUMMY',1726,1,'2024-12-04 16:35:45','2024-12-04 16:35:45'),(1727,NULL,'DUMMY',1727,1,'2024-12-04 16:35:45','2024-12-04 16:35:45'),(1728,NULL,'DUMMY',1728,1,'2024-12-04 16:35:45','2024-12-04 16:35:45'),(1729,NULL,'DUMMY',1729,1,'2024-12-04 16:35:45','2024-12-04 16:35:45'),(1730,NULL,'DUMMY',1730,1,'2024-12-04 16:35:45','2024-12-04 16:35:45'),(1731,NULL,'DUMMY',1731,1,'2024-12-04 16:35:45','2024-12-04 16:35:45'),(1732,NULL,'DUMMY',1732,1,'2024-12-04 16:35:45','2024-12-04 16:35:45'),(1733,NULL,'DUMMY',1733,1,'2024-12-04 16:35:45','2024-12-04 16:35:45'),(1734,NULL,'DUMMY',1734,1,'2024-12-04 16:35:45','2024-12-04 16:35:45'),(1735,NULL,'DUMMY',1735,1,'2024-12-04 16:35:45','2024-12-04 16:35:45'),(1736,NULL,'DUMMY',1736,1,'2024-12-04 16:35:45','2024-12-04 16:35:45'),(1737,NULL,'DUMMY',1737,1,'2024-12-04 16:35:45','2024-12-04 16:35:45'),(1738,NULL,'DUMMY',1738,1,'2024-12-04 16:35:45','2024-12-04 16:35:45'),(1739,NULL,'DUMMY',1739,1,'2024-12-04 16:35:45','2024-12-04 16:35:45'),(1740,NULL,'DUMMY',1740,1,'2024-12-04 16:35:45','2024-12-04 16:35:45'),(1741,NULL,'DUMMY',1741,1,'2024-12-04 16:35:45','2024-12-04 16:35:45'),(1742,NULL,'DUMMY',1742,1,'2024-12-04 16:35:45','2024-12-04 16:35:45'),(1743,NULL,'DUMMY',1743,1,'2024-12-04 16:35:45','2024-12-04 16:35:45'),(1744,NULL,'DUMMY',1744,1,'2024-12-04 16:35:45','2024-12-04 16:35:45'),(1745,NULL,'DUMMY',1745,1,'2024-12-04 16:35:45','2024-12-04 16:35:45'),(1746,NULL,'DUMMY',1746,1,'2024-12-04 16:35:45','2024-12-04 16:35:45'),(1747,NULL,'DUMMY',1747,1,'2024-12-04 16:35:45','2024-12-04 16:35:45'),(1748,NULL,'DUMMY',1748,1,'2024-12-04 16:35:45','2024-12-04 16:35:45'),(1749,NULL,'DUMMY',1749,1,'2024-12-04 16:35:45','2024-12-04 16:35:45'),(1750,NULL,'DUMMY',1750,1,'2024-12-04 16:35:45','2024-12-04 16:35:45'),(1751,NULL,'DUMMY',1751,1,'2024-12-04 16:35:45','2024-12-04 16:35:45'),(1752,NULL,'DUMMY',1752,1,'2024-12-04 16:35:45','2024-12-04 16:35:45'),(1753,NULL,'DUMMY',1753,1,'2024-12-04 16:35:45','2024-12-04 16:35:45'),(1754,NULL,'DUMMY',1754,1,'2024-12-04 16:35:45','2024-12-04 16:35:45'),(1755,NULL,'DUMMY',1755,1,'2024-12-04 16:35:45','2024-12-04 16:35:45'),(1756,NULL,'DUMMY',1756,1,'2024-12-04 16:35:45','2024-12-04 16:35:45'),(1757,NULL,'DUMMY',1757,1,'2024-12-04 16:35:45','2024-12-04 16:35:45'),(1758,NULL,'DUMMY',1758,1,'2024-12-04 16:35:45','2024-12-04 16:35:45'),(1759,NULL,'DUMMY',1759,1,'2024-12-04 16:35:45','2024-12-04 16:35:45'),(1760,NULL,'DUMMY',1760,1,'2024-12-04 16:35:45','2024-12-04 16:35:45'),(1761,NULL,'DUMMY',1761,1,'2024-12-04 16:35:45','2024-12-04 16:35:45'),(1762,NULL,'DUMMY',1762,1,'2024-12-04 16:35:45','2024-12-04 16:35:45'),(1763,NULL,'DUMMY',1763,1,'2024-12-04 16:35:45','2024-12-04 16:35:45'),(1764,NULL,'DUMMY',1764,1,'2024-12-04 16:35:45','2024-12-04 16:35:45'),(1765,NULL,'DUMMY',1765,1,'2024-12-04 16:35:45','2024-12-04 16:35:45'),(1766,NULL,'DUMMY',1766,1,'2024-12-04 16:35:45','2024-12-04 16:35:45'),(1767,NULL,'DUMMY',1767,1,'2024-12-04 16:35:45','2024-12-04 16:35:45'),(1768,NULL,'DUMMY',1768,1,'2024-12-04 16:35:45','2024-12-04 16:35:45'),(1769,NULL,'DUMMY',1769,1,'2024-12-04 16:35:45','2024-12-04 16:35:45'),(1770,NULL,'DUMMY',1770,1,'2024-12-04 16:35:45','2024-12-04 16:35:45'),(1771,NULL,'DUMMY',1771,1,'2024-12-04 16:35:45','2024-12-04 16:35:45'),(1772,NULL,'DUMMY',1772,1,'2024-12-04 16:35:45','2024-12-04 16:35:45'),(1773,NULL,'DUMMY',1773,1,'2024-12-04 16:35:45','2024-12-04 16:35:45'),(1774,NULL,'DUMMY',1774,1,'2024-12-04 16:35:45','2024-12-04 16:35:45'),(1775,NULL,'DUMMY',1775,1,'2024-12-04 16:35:45','2024-12-04 16:35:45'),(1776,NULL,'DUMMY',1776,1,'2024-12-04 16:35:45','2024-12-04 16:35:45'),(1777,NULL,'DUMMY',1777,1,'2024-12-04 16:35:45','2024-12-04 16:35:45'),(1778,NULL,'DUMMY',1778,1,'2024-12-04 16:35:45','2024-12-04 16:35:45'),(1779,NULL,'DUMMY',1779,1,'2024-12-04 16:35:45','2024-12-04 16:35:45'),(1780,NULL,'DUMMY',1780,1,'2024-12-04 16:35:45','2024-12-04 16:35:45'),(1781,NULL,'DUMMY',1781,1,'2024-12-04 16:35:45','2024-12-04 16:35:45'),(1782,NULL,'DUMMY',1782,1,'2024-12-04 16:35:45','2024-12-04 16:35:45'),(1783,NULL,'DUMMY',1783,1,'2024-12-04 16:35:45','2024-12-04 16:35:45'),(1784,NULL,'DUMMY',1784,1,'2024-12-04 16:35:45','2024-12-04 16:35:45'),(1785,NULL,'DUMMY',1785,1,'2024-12-04 16:35:45','2024-12-04 16:35:45'),(1786,NULL,'DUMMY',1786,1,'2024-12-04 16:35:45','2024-12-04 16:35:45'),(1787,NULL,'DUMMY',1787,1,'2024-12-04 16:35:45','2024-12-04 16:35:45'),(1788,NULL,'DUMMY',1788,1,'2024-12-04 16:35:45','2024-12-04 16:35:45'),(1789,NULL,'DUMMY',1789,1,'2024-12-04 16:35:45','2024-12-04 16:35:45'),(1790,NULL,'DUMMY',1790,1,'2024-12-04 16:35:45','2024-12-04 16:35:45'),(1791,NULL,'DUMMY',1791,1,'2024-12-04 16:35:45','2024-12-04 16:35:45'),(1792,NULL,'DUMMY',1792,1,'2024-12-04 16:35:45','2024-12-04 16:35:45'),(1793,NULL,'DUMMY',1793,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1794,NULL,'DUMMY',1794,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1795,NULL,'DUMMY',1795,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1796,NULL,'DUMMY',1796,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1797,NULL,'DUMMY',1797,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1798,NULL,'DUMMY',1798,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1799,NULL,'DUMMY',1799,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1800,NULL,'DUMMY',1800,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1801,NULL,'DUMMY',1801,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1802,NULL,'DUMMY',1802,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1803,NULL,'DUMMY',1803,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1804,NULL,'DUMMY',1804,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1805,NULL,'DUMMY',1805,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1806,NULL,'DUMMY',1806,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1807,NULL,'DUMMY',1807,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1808,NULL,'DUMMY',1808,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1809,NULL,'DUMMY',1809,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1810,NULL,'DUMMY',1810,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1811,NULL,'DUMMY',1811,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1812,NULL,'DUMMY',1812,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1813,NULL,'DUMMY',1813,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1814,NULL,'DUMMY',1814,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1815,NULL,'DUMMY',1815,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1816,NULL,'DUMMY',1816,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1817,NULL,'DUMMY',1817,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1818,NULL,'DUMMY',1818,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1819,NULL,'DUMMY',1819,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1820,NULL,'DUMMY',1820,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1821,NULL,'DUMMY',1821,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1822,NULL,'DUMMY',1822,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1823,NULL,'DUMMY',1823,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1824,NULL,'DUMMY',1824,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1825,NULL,'DUMMY',1825,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1826,NULL,'DUMMY',1826,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1827,NULL,'DUMMY',1827,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1828,NULL,'DUMMY',1828,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1829,NULL,'DUMMY',1829,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1830,NULL,'DUMMY',1830,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1831,NULL,'DUMMY',1831,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1832,NULL,'DUMMY',1832,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1833,NULL,'DUMMY',1833,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1834,NULL,'DUMMY',1834,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1835,NULL,'DUMMY',1835,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1836,NULL,'DUMMY',1836,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1837,NULL,'DUMMY',1837,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1838,NULL,'DUMMY',1838,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1839,NULL,'DUMMY',1839,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1840,NULL,'DUMMY',1840,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1841,NULL,'DUMMY',1841,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1842,NULL,'DUMMY',1842,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1843,NULL,'DUMMY',1843,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1844,NULL,'DUMMY',1844,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1845,NULL,'DUMMY',1845,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1846,NULL,'DUMMY',1846,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1847,NULL,'DUMMY',1847,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1848,NULL,'DUMMY',1848,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1849,NULL,'DUMMY',1849,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1850,NULL,'DUMMY',1850,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1851,NULL,'DUMMY',1851,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1852,NULL,'DUMMY',1852,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1853,NULL,'DUMMY',1853,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1854,NULL,'DUMMY',1854,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1855,NULL,'DUMMY',1855,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1856,NULL,'DUMMY',1856,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1857,NULL,'DUMMY',1857,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1858,NULL,'DUMMY',1858,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1859,NULL,'DUMMY',1859,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1860,NULL,'DUMMY',1860,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1861,NULL,'DUMMY',1861,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1862,NULL,'DUMMY',1862,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1863,NULL,'DUMMY',1863,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1864,NULL,'DUMMY',1864,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1865,NULL,'DUMMY',1865,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1866,NULL,'DUMMY',1866,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1867,NULL,'DUMMY',1867,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1868,NULL,'DUMMY',1868,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1869,NULL,'DUMMY',1869,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1870,NULL,'DUMMY',1870,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1871,NULL,'DUMMY',1871,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1872,NULL,'DUMMY',1872,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1873,NULL,'DUMMY',1873,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1874,NULL,'DUMMY',1874,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1875,NULL,'DUMMY',1875,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1876,NULL,'DUMMY',1876,1,'2024-12-04 16:35:46','2024-12-04 16:35:46'),(1877,NULL,'DUMMY',1877,1,'2024-12-04 16:35:47','2024-12-04 16:35:47'),(1878,NULL,'DUMMY',1878,1,'2024-12-04 16:35:47','2024-12-04 16:35:47'),(1879,NULL,'DUMMY',1879,1,'2024-12-04 16:35:47','2024-12-04 16:35:47'),(1880,NULL,'DUMMY',1880,1,'2024-12-04 16:35:47','2024-12-04 16:35:47'),(1881,NULL,'DUMMY',1881,1,'2024-12-04 16:35:47','2024-12-04 16:35:47'),(1882,NULL,'DUMMY',1882,1,'2024-12-04 16:35:47','2024-12-04 16:35:47'),(1883,NULL,'DUMMY',1883,1,'2024-12-04 16:35:47','2024-12-04 16:35:47'),(1884,NULL,'DUMMY',1884,1,'2024-12-04 16:35:47','2024-12-04 16:35:47'),(1885,NULL,'DUMMY',1885,1,'2024-12-04 16:35:47','2024-12-04 16:35:47'),(1886,NULL,'DUMMY',1886,1,'2024-12-04 16:35:47','2024-12-04 16:35:47'),(1887,NULL,'DUMMY',1887,1,'2024-12-04 16:35:47','2024-12-04 16:35:47'),(1888,NULL,'DUMMY',1888,1,'2024-12-04 16:35:47','2024-12-04 16:35:47'),(1889,NULL,'DUMMY',1889,1,'2024-12-04 16:35:47','2024-12-04 16:35:47'),(1890,NULL,'DUMMY',1890,1,'2024-12-04 16:35:47','2024-12-04 16:35:47'),(1891,NULL,'DUMMY',1891,1,'2024-12-04 16:35:47','2024-12-04 16:35:47'),(1892,NULL,'DUMMY',1892,1,'2024-12-04 16:35:47','2024-12-04 16:35:47'),(1893,NULL,'DUMMY',1893,1,'2024-12-04 16:35:47','2024-12-04 16:35:47'),(1894,NULL,'DUMMY',1894,1,'2024-12-04 16:35:47','2024-12-04 16:35:47'),(1895,NULL,'DUMMY',1895,1,'2024-12-04 16:35:47','2024-12-04 16:35:47'),(1896,NULL,'DUMMY',1896,1,'2024-12-04 16:35:47','2024-12-04 16:35:47'),(1897,NULL,'DUMMY',1897,1,'2024-12-04 16:35:47','2024-12-04 16:35:47'),(1898,NULL,'DUMMY',1898,1,'2024-12-04 16:35:47','2024-12-04 16:35:47'),(1899,NULL,'DUMMY',1899,1,'2024-12-04 16:35:47','2024-12-04 16:35:47'),(1900,NULL,'DUMMY',1900,1,'2024-12-04 16:35:47','2024-12-04 16:35:47'),(1901,NULL,'DUMMY',1901,1,'2024-12-04 16:35:47','2024-12-04 16:35:47'),(1902,NULL,'DUMMY',1902,1,'2024-12-04 16:35:47','2024-12-04 16:35:47'),(1903,NULL,'DUMMY',1903,1,'2024-12-04 16:35:47','2024-12-04 16:35:47'),(1904,NULL,'DUMMY',1904,1,'2024-12-04 16:35:47','2024-12-04 16:35:47'),(1905,NULL,'DUMMY',1905,1,'2024-12-04 16:35:47','2024-12-04 16:35:47'),(1906,NULL,'DUMMY',1906,1,'2024-12-04 16:35:47','2024-12-04 16:35:47'),(1907,NULL,'DUMMY',1907,1,'2024-12-04 16:35:47','2024-12-04 16:35:47'),(1908,NULL,'DUMMY',1908,1,'2024-12-04 16:35:47','2024-12-04 16:35:47'),(1909,NULL,'DUMMY',1909,1,'2024-12-04 16:35:47','2024-12-04 16:35:47'),(1910,NULL,'DUMMY',1910,1,'2024-12-04 16:35:47','2024-12-04 16:35:47'),(1911,NULL,'DUMMY',1911,1,'2024-12-04 16:35:47','2024-12-04 16:35:47'),(1912,NULL,'DUMMY',1912,1,'2024-12-04 16:35:47','2024-12-04 16:35:47'),(1913,NULL,'DUMMY',1913,1,'2024-12-04 16:35:47','2024-12-04 16:35:47'),(1914,NULL,'DUMMY',1914,1,'2024-12-04 16:35:47','2024-12-04 16:35:47'),(1915,NULL,'DUMMY',1915,1,'2024-12-04 16:35:47','2024-12-04 16:35:47'),(1916,NULL,'DUMMY',1916,1,'2024-12-04 16:35:47','2024-12-04 16:35:47'),(1917,NULL,'DUMMY',1917,1,'2024-12-04 16:35:47','2024-12-04 16:35:47'),(1918,NULL,'DUMMY',1918,1,'2024-12-04 16:35:47','2024-12-04 16:35:47'),(1919,NULL,'DUMMY',1919,1,'2024-12-04 16:35:47','2024-12-04 16:35:47'),(1920,NULL,'DUMMY',1920,1,'2024-12-04 16:35:47','2024-12-04 16:35:47'),(1921,NULL,'DUMMY',1921,1,'2024-12-04 16:35:47','2024-12-04 16:35:47'),(1922,NULL,'DUMMY',1922,1,'2024-12-04 16:35:47','2024-12-04 16:35:47'),(1923,NULL,'DUMMY',1923,1,'2024-12-04 16:35:47','2024-12-04 16:35:47'),(1924,NULL,'DUMMY',1924,1,'2024-12-04 16:35:47','2024-12-04 16:35:47'),(1925,NULL,'DUMMY',1925,1,'2024-12-04 16:35:47','2024-12-04 16:35:47'),(1926,NULL,'DUMMY',1926,1,'2024-12-04 16:35:47','2024-12-04 16:35:47'),(1927,NULL,'DUMMY',1927,1,'2024-12-04 16:35:47','2024-12-04 16:35:47'),(1928,NULL,'DUMMY',1928,1,'2024-12-04 16:35:47','2024-12-04 16:35:47'),(1929,NULL,'DUMMY',1929,1,'2024-12-04 16:35:47','2024-12-04 16:35:47'),(1930,NULL,'DUMMY',1930,1,'2024-12-04 16:35:47','2024-12-04 16:35:47'),(1931,NULL,'DUMMY',1931,1,'2024-12-04 16:35:47','2024-12-04 16:35:47'),(1932,NULL,'DUMMY',1932,1,'2024-12-04 16:35:47','2024-12-04 16:35:47'),(1933,NULL,'DUMMY',1933,1,'2024-12-04 16:35:47','2024-12-04 16:35:47'),(1934,NULL,'DUMMY',1934,1,'2024-12-04 16:35:47','2024-12-04 16:35:47'),(1935,NULL,'DUMMY',1935,1,'2024-12-04 16:35:47','2024-12-04 16:35:47'),(1936,NULL,'DUMMY',1936,1,'2024-12-04 16:35:47','2024-12-04 16:35:47'),(1937,NULL,'DUMMY',1937,1,'2024-12-04 16:35:47','2024-12-04 16:35:47'),(1938,NULL,'DUMMY',1938,1,'2024-12-04 16:35:47','2024-12-04 16:35:47'),(1939,NULL,'DUMMY',1939,1,'2024-12-04 16:35:47','2024-12-04 16:35:47'),(1940,NULL,'DUMMY',1940,1,'2024-12-04 16:35:47','2024-12-04 16:35:47'),(1941,NULL,'DUMMY',1941,1,'2024-12-04 16:35:47','2024-12-04 16:35:47'),(1942,NULL,'DUMMY',1942,1,'2024-12-04 16:35:47','2024-12-04 16:35:47'),(1943,NULL,'DUMMY',1943,1,'2024-12-04 16:35:47','2024-12-04 16:35:47'),(1944,NULL,'DUMMY',1944,1,'2024-12-04 16:35:47','2024-12-04 16:35:47'),(1945,NULL,'DUMMY',1945,1,'2024-12-04 16:35:47','2024-12-04 16:35:47'),(1946,NULL,'DUMMY',1946,1,'2024-12-04 16:35:47','2024-12-04 16:35:47'),(1947,NULL,'DUMMY',1947,1,'2024-12-04 16:35:47','2024-12-04 16:35:47'),(1948,NULL,'DUMMY',1948,1,'2024-12-04 16:35:47','2024-12-04 16:35:47'),(1949,NULL,'DUMMY',1949,1,'2024-12-04 16:35:47','2024-12-04 16:35:47'),(1950,NULL,'DUMMY',1950,1,'2024-12-04 16:35:47','2024-12-04 16:35:47'),(1951,NULL,'DUMMY',1951,1,'2024-12-04 16:35:47','2024-12-04 16:35:47'),(1952,NULL,'DUMMY',1952,1,'2024-12-04 16:35:47','2024-12-04 16:35:47'),(1953,NULL,'DUMMY',1953,1,'2024-12-04 16:35:47','2024-12-04 16:35:47'),(1954,NULL,'DUMMY',1954,1,'2024-12-04 16:35:47','2024-12-04 16:35:47'),(1955,NULL,'DUMMY',1955,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(1956,NULL,'DUMMY',1956,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(1957,NULL,'DUMMY',1957,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(1958,NULL,'DUMMY',1958,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(1959,NULL,'DUMMY',1959,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(1960,NULL,'DUMMY',1960,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(1961,NULL,'DUMMY',1961,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(1962,NULL,'DUMMY',1962,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(1963,NULL,'DUMMY',1963,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(1964,NULL,'DUMMY',1964,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(1965,NULL,'DUMMY',1965,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(1966,NULL,'DUMMY',1966,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(1967,NULL,'DUMMY',1967,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(1968,NULL,'DUMMY',1968,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(1969,NULL,'DUMMY',1969,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(1970,NULL,'DUMMY',1970,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(1971,NULL,'DUMMY',1971,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(1972,NULL,'DUMMY',1972,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(1973,NULL,'DUMMY',1973,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(1974,NULL,'DUMMY',1974,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(1975,NULL,'DUMMY',1975,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(1976,NULL,'DUMMY',1976,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(1977,NULL,'DUMMY',1977,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(1978,NULL,'DUMMY',1978,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(1979,NULL,'DUMMY',1979,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(1980,NULL,'DUMMY',1980,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(1981,NULL,'DUMMY',1981,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(1982,NULL,'DUMMY',1982,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(1983,NULL,'DUMMY',1983,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(1984,NULL,'DUMMY',1984,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(1985,NULL,'DUMMY',1985,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(1986,NULL,'DUMMY',1986,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(1987,NULL,'DUMMY',1987,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(1988,NULL,'DUMMY',1988,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(1989,NULL,'DUMMY',1989,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(1990,NULL,'DUMMY',1990,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(1991,NULL,'DUMMY',1991,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(1992,NULL,'DUMMY',1992,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(1993,NULL,'DUMMY',1993,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(1994,NULL,'DUMMY',1994,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(1995,NULL,'DUMMY',1995,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(1996,NULL,'DUMMY',1996,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(1997,NULL,'DUMMY',1997,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(1998,NULL,'DUMMY',1998,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(1999,NULL,'DUMMY',1999,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(2000,NULL,'DUMMY',2000,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(2001,NULL,'DUMMY',2001,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(2002,NULL,'DUMMY',2002,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(2003,NULL,'DUMMY',2003,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(2004,NULL,'DUMMY',2004,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(2005,NULL,'DUMMY',2005,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(2006,NULL,'DUMMY',2006,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(2007,NULL,'DUMMY',2007,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(2008,NULL,'DUMMY',2008,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(2009,NULL,'DUMMY',2009,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(2010,NULL,'DUMMY',2010,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(2011,NULL,'DUMMY',2011,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(2012,NULL,'DUMMY',2012,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(2013,NULL,'DUMMY',2013,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(2014,NULL,'DUMMY',2014,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(2015,NULL,'DUMMY',2015,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(2016,NULL,'DUMMY',2016,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(2017,NULL,'DUMMY',2017,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(2018,NULL,'DUMMY',2018,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(2019,NULL,'DUMMY',2019,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(2020,NULL,'DUMMY',2020,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(2021,NULL,'DUMMY',2021,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(2022,NULL,'DUMMY',2022,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(2023,NULL,'DUMMY',2023,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(2024,NULL,'DUMMY',2024,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(2025,NULL,'DUMMY',2025,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(2026,NULL,'DUMMY',2026,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(2027,NULL,'DUMMY',2027,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(2028,NULL,'DUMMY',2028,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(2029,NULL,'DUMMY',2029,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(2030,NULL,'DUMMY',2030,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(2031,NULL,'DUMMY',2031,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(2032,NULL,'DUMMY',2032,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(2033,NULL,'DUMMY',2033,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(2034,NULL,'DUMMY',2034,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(2035,NULL,'DUMMY',2035,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(2036,NULL,'DUMMY',2036,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(2037,NULL,'DUMMY',2037,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(2038,NULL,'DUMMY',2038,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(2039,NULL,'DUMMY',2039,1,'2024-12-04 16:35:48','2024-12-04 16:35:48'),(2040,NULL,'DUMMY',2040,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2041,NULL,'DUMMY',2041,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2042,NULL,'DUMMY',2042,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2043,NULL,'DUMMY',2043,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2044,NULL,'DUMMY',2044,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2045,NULL,'DUMMY',2045,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2046,NULL,'DUMMY',2046,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2047,NULL,'DUMMY',2047,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2048,NULL,'DUMMY',2048,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2049,NULL,'DUMMY',2049,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2050,NULL,'DUMMY',2050,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2051,NULL,'DUMMY',2051,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2052,NULL,'DUMMY',2052,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2053,NULL,'DUMMY',2053,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2054,NULL,'DUMMY',2054,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2055,NULL,'DUMMY',2055,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2056,NULL,'DUMMY',2056,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2057,NULL,'DUMMY',2057,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2058,NULL,'DUMMY',2058,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2059,NULL,'DUMMY',2059,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2060,NULL,'DUMMY',2060,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2061,NULL,'DUMMY',2061,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2062,NULL,'DUMMY',2062,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2063,NULL,'DUMMY',2063,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2064,NULL,'DUMMY',2064,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2065,NULL,'DUMMY',2065,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2066,NULL,'DUMMY',2066,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2067,NULL,'DUMMY',2067,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2068,NULL,'DUMMY',2068,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2069,NULL,'DUMMY',2069,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2070,NULL,'DUMMY',2070,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2071,NULL,'DUMMY',2071,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2072,NULL,'DUMMY',2072,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2073,NULL,'DUMMY',2073,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2074,NULL,'DUMMY',2074,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2075,NULL,'DUMMY',2075,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2076,NULL,'DUMMY',2076,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2077,NULL,'DUMMY',2077,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2078,NULL,'DUMMY',2078,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2079,NULL,'DUMMY',2079,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2080,NULL,'DUMMY',2080,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2081,NULL,'DUMMY',2081,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2082,NULL,'DUMMY',2082,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2083,NULL,'DUMMY',2083,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2084,NULL,'DUMMY',2084,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2085,NULL,'DUMMY',2085,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2086,NULL,'DUMMY',2086,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2087,NULL,'DUMMY',2087,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2088,NULL,'DUMMY',2088,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2089,NULL,'DUMMY',2089,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2090,NULL,'DUMMY',2090,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2091,NULL,'DUMMY',2091,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2092,NULL,'DUMMY',2092,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2093,NULL,'DUMMY',2093,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2094,NULL,'DUMMY',2094,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2095,NULL,'DUMMY',2095,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2096,NULL,'DUMMY',2096,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2097,NULL,'DUMMY',2097,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2098,NULL,'DUMMY',2098,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2099,NULL,'DUMMY',2099,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2100,NULL,'DUMMY',2100,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2101,NULL,'DUMMY',2101,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2102,NULL,'DUMMY',2102,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2103,NULL,'DUMMY',2103,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2104,NULL,'DUMMY',2104,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2105,NULL,'DUMMY',2105,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2106,NULL,'DUMMY',2106,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2107,NULL,'DUMMY',2107,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2108,NULL,'DUMMY',2108,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2109,NULL,'DUMMY',2109,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2110,NULL,'DUMMY',2110,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2111,NULL,'DUMMY',2111,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2112,NULL,'DUMMY',2112,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2113,NULL,'DUMMY',2113,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2114,NULL,'DUMMY',2114,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2115,NULL,'DUMMY',2115,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2116,NULL,'DUMMY',2116,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2117,NULL,'DUMMY',2117,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2118,NULL,'DUMMY',2118,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2119,NULL,'DUMMY',2119,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2120,NULL,'DUMMY',2120,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2121,NULL,'DUMMY',2121,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2122,NULL,'DUMMY',2122,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2123,NULL,'DUMMY',2123,1,'2024-12-04 16:35:49','2024-12-04 16:35:49'),(2124,NULL,'DUMMY',2124,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2125,NULL,'DUMMY',2125,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2126,NULL,'DUMMY',2126,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2127,NULL,'DUMMY',2127,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2128,NULL,'DUMMY',2128,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2129,NULL,'DUMMY',2129,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2130,NULL,'DUMMY',2130,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2131,NULL,'DUMMY',2131,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2132,NULL,'DUMMY',2132,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2133,NULL,'DUMMY',2133,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2134,NULL,'DUMMY',2134,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2135,NULL,'DUMMY',2135,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2136,NULL,'DUMMY',2136,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2137,NULL,'DUMMY',2137,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2138,NULL,'DUMMY',2138,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2139,NULL,'DUMMY',2139,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2140,NULL,'DUMMY',2140,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2141,NULL,'DUMMY',2141,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2142,NULL,'DUMMY',2142,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2143,NULL,'DUMMY',2143,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2144,NULL,'DUMMY',2144,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2145,NULL,'DUMMY',2145,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2146,NULL,'DUMMY',2146,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2147,NULL,'DUMMY',2147,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2148,NULL,'DUMMY',2148,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2149,NULL,'DUMMY',2149,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2150,NULL,'DUMMY',2150,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2151,NULL,'DUMMY',2151,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2152,NULL,'DUMMY',2152,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2153,NULL,'DUMMY',2153,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2154,NULL,'DUMMY',2154,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2155,NULL,'DUMMY',2155,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2156,NULL,'DUMMY',2156,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2157,NULL,'DUMMY',2157,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2158,NULL,'DUMMY',2158,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2159,NULL,'DUMMY',2159,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2160,NULL,'DUMMY',2160,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2161,NULL,'DUMMY',2161,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2162,NULL,'DUMMY',2162,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2163,NULL,'DUMMY',2163,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2164,NULL,'DUMMY',2164,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2165,NULL,'DUMMY',2165,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2166,NULL,'DUMMY',2166,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2167,NULL,'DUMMY',2167,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2168,NULL,'DUMMY',2168,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2169,NULL,'DUMMY',2169,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2170,NULL,'DUMMY',2170,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2171,NULL,'DUMMY',2171,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2172,NULL,'DUMMY',2172,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2173,NULL,'DUMMY',2173,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2174,NULL,'DUMMY',2174,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2175,NULL,'DUMMY',2175,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2176,NULL,'DUMMY',2176,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2177,NULL,'DUMMY',2177,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2178,NULL,'DUMMY',2178,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2179,NULL,'DUMMY',2179,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2180,NULL,'DUMMY',2180,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2181,NULL,'DUMMY',2181,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2182,NULL,'DUMMY',2182,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2183,NULL,'DUMMY',2183,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2184,NULL,'DUMMY',2184,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2185,NULL,'DUMMY',2185,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2186,NULL,'DUMMY',2186,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2187,NULL,'DUMMY',2187,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2188,NULL,'DUMMY',2188,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2189,NULL,'DUMMY',2189,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2190,NULL,'DUMMY',2190,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2191,NULL,'DUMMY',2191,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2192,NULL,'DUMMY',2192,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2193,NULL,'DUMMY',2193,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2194,NULL,'DUMMY',2194,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2195,NULL,'DUMMY',2195,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2196,NULL,'DUMMY',2196,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2197,NULL,'DUMMY',2197,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2198,NULL,'DUMMY',2198,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2199,NULL,'DUMMY',2199,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2200,NULL,'DUMMY',2200,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2201,NULL,'DUMMY',2201,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2202,NULL,'DUMMY',2202,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2203,NULL,'DUMMY',2203,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2204,NULL,'DUMMY',2204,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2205,NULL,'DUMMY',2205,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2206,NULL,'DUMMY',2206,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2207,NULL,'DUMMY',2207,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2208,NULL,'DUMMY',2208,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2209,NULL,'DUMMY',2209,1,'2024-12-04 16:35:50','2024-12-04 16:35:50'),(2210,NULL,'DUMMY',2210,1,'2024-12-04 16:35:51','2024-12-04 16:35:51'),(2211,NULL,'DUMMY',2211,1,'2024-12-04 16:35:51','2024-12-04 16:35:51'),(2212,NULL,'DUMMY',2212,1,'2024-12-04 16:35:51','2024-12-04 16:35:51'),(2213,NULL,'DUMMY',2213,1,'2024-12-04 16:35:51','2024-12-04 16:35:51'),(2214,NULL,'DUMMY',2214,1,'2024-12-04 16:35:51','2024-12-04 16:35:51'),(2215,NULL,'DUMMY',2215,1,'2024-12-04 16:35:51','2024-12-04 16:35:51'),(2216,NULL,'DUMMY',2216,1,'2024-12-04 16:35:51','2024-12-04 16:35:51'),(2217,NULL,'DUMMY',2217,1,'2024-12-04 16:35:51','2024-12-04 16:35:51'),(2218,NULL,'DUMMY',2218,1,'2024-12-04 16:35:51','2024-12-04 16:35:51'),(2219,NULL,'DUMMY',2219,1,'2024-12-04 16:35:51','2024-12-04 16:35:51'),(2220,NULL,'DUMMY',2220,1,'2024-12-04 16:35:51','2024-12-04 16:35:51'),(2221,NULL,'DUMMY',2221,1,'2024-12-04 16:35:51','2024-12-04 16:35:51'),(2222,NULL,'DUMMY',2222,1,'2024-12-04 16:35:51','2024-12-04 16:35:51'),(2223,NULL,'DUMMY',2223,1,'2024-12-04 16:35:51','2024-12-04 16:35:51'),(2224,NULL,'DUMMY',2224,1,'2024-12-04 16:35:51','2024-12-04 16:35:51'),(2225,NULL,'DUMMY',2225,1,'2024-12-04 16:35:51','2024-12-04 16:35:51'),(2226,NULL,'DUMMY',2226,1,'2024-12-04 16:35:51','2024-12-04 16:35:51'),(2227,NULL,'DUMMY',2227,1,'2024-12-04 16:35:51','2024-12-04 16:35:51'),(2228,NULL,'DUMMY',2228,1,'2024-12-04 16:35:51','2024-12-04 16:35:51'),(2229,NULL,'DUMMY',2229,1,'2024-12-04 16:35:51','2024-12-04 16:35:51'),(2230,NULL,'DUMMY',2230,1,'2024-12-04 16:35:51','2024-12-04 16:35:51'),(2231,NULL,'DUMMY',2231,1,'2024-12-04 16:35:51','2024-12-04 16:35:51'),(2232,NULL,'DUMMY',2232,1,'2024-12-04 16:35:51','2024-12-04 16:35:51'),(2233,NULL,'DUMMY',2233,1,'2024-12-04 16:35:51','2024-12-04 16:35:51'),(2234,NULL,'DUMMY',2234,1,'2024-12-04 16:35:51','2024-12-04 16:35:51'),(2235,NULL,'DUMMY',2235,1,'2024-12-04 16:35:51','2024-12-04 16:35:51'),(2236,NULL,'DUMMY',2236,1,'2024-12-04 16:35:51','2024-12-04 16:35:51'),(2237,NULL,'DUMMY',2237,1,'2024-12-04 16:35:51','2024-12-04 16:35:51'),(2238,NULL,'DUMMY',2238,1,'2024-12-04 16:35:51','2024-12-04 16:35:51'),(2239,NULL,'DUMMY',2239,1,'2024-12-04 16:35:51','2024-12-04 16:35:51'),(2240,NULL,'DUMMY',2240,1,'2024-12-04 16:35:51','2024-12-04 16:35:51'),(2241,NULL,'DUMMY',2241,1,'2024-12-04 16:35:51','2024-12-04 16:35:51'),(2242,NULL,'DUMMY',2242,1,'2024-12-04 16:35:51','2024-12-04 16:35:51'),(2243,NULL,'DUMMY',2243,1,'2024-12-04 16:35:51','2024-12-04 16:35:51'),(2244,NULL,'DUMMY',2244,1,'2024-12-04 16:35:51','2024-12-04 16:35:51'),(2245,NULL,'DUMMY',2245,1,'2024-12-04 16:35:51','2024-12-04 16:35:51'),(2246,NULL,'DUMMY',2246,1,'2024-12-04 16:35:51','2024-12-04 16:35:51'),(2247,NULL,'DUMMY',2247,1,'2024-12-04 16:35:51','2024-12-04 16:35:51'),(2248,NULL,'DUMMY',2248,1,'2024-12-04 16:35:51','2024-12-04 16:35:51'),(2249,NULL,'DUMMY',2249,1,'2024-12-04 16:35:51','2024-12-04 16:35:51'),(2250,NULL,'DUMMY',2250,1,'2024-12-04 16:35:51','2024-12-04 16:35:51'),(2251,NULL,'DUMMY',2251,1,'2024-12-04 16:35:51','2024-12-04 16:35:51'),(2252,NULL,'DUMMY',2252,1,'2024-12-04 16:35:51','2024-12-04 16:35:51'),(2253,NULL,'DUMMY',2253,1,'2024-12-04 16:35:51','2024-12-04 16:35:51'),(2254,NULL,'DUMMY',2254,1,'2024-12-04 16:35:51','2024-12-04 16:35:51'),(2255,NULL,'DUMMY',2255,1,'2024-12-04 16:35:51','2024-12-04 16:35:51'),(2256,NULL,'DUMMY',2256,1,'2024-12-04 16:35:51','2024-12-04 16:35:51'),(2257,NULL,'DUMMY',2257,1,'2024-12-04 16:35:51','2024-12-04 16:35:51'),(2258,NULL,'DUMMY',2258,1,'2024-12-04 16:35:51','2024-12-04 16:35:51'),(2259,NULL,'DUMMY',2259,1,'2024-12-04 16:35:51','2024-12-04 16:35:51'),(2260,NULL,'DUMMY',2260,1,'2024-12-04 16:35:51','2024-12-04 16:35:51'),(2261,NULL,'DUMMY',2261,1,'2024-12-04 16:35:51','2024-12-04 16:35:51'),(2262,NULL,'DUMMY',2262,1,'2024-12-04 16:35:51','2024-12-04 16:35:51'),(2263,NULL,'DUMMY',2263,1,'2024-12-04 16:35:51','2024-12-04 16:35:51'),(2264,NULL,'DUMMY',2264,1,'2024-12-04 16:35:51','2024-12-04 16:35:51'),(2265,NULL,'DUMMY',2265,1,'2024-12-04 16:35:51','2024-12-04 16:35:51'),(2266,NULL,'DUMMY',2266,1,'2024-12-04 16:35:51','2024-12-04 16:35:51'),(2267,NULL,'DUMMY',2267,1,'2024-12-04 16:35:51','2024-12-04 16:35:51'),(2268,NULL,'DUMMY',2268,1,'2024-12-04 16:35:51','2024-12-04 16:35:51'),(2269,NULL,'DUMMY',2269,1,'2024-12-04 16:35:51','2024-12-04 16:35:51'),(2270,NULL,'DUMMY',2270,1,'2024-12-04 16:35:51','2024-12-04 16:35:51'),(2271,NULL,'DUMMY',2271,1,'2024-12-04 16:35:51','2024-12-04 16:35:51'),(2272,NULL,'DUMMY',2272,1,'2024-12-04 16:35:51','2024-12-04 16:35:51'),(2273,NULL,'DUMMY',2273,1,'2024-12-04 16:35:51','2024-12-04 16:35:51'),(2274,NULL,'DUMMY',2274,1,'2024-12-04 16:35:51','2024-12-04 16:35:51'),(2275,NULL,'DUMMY',2275,1,'2024-12-04 16:35:51','2024-12-04 16:35:51'),(2276,NULL,'DUMMY',2276,1,'2024-12-04 16:35:51','2024-12-04 16:35:51'),(2277,NULL,'DUMMY',2277,1,'2024-12-04 16:35:51','2024-12-04 16:35:51'),(2278,NULL,'DUMMY',2278,1,'2024-12-04 16:35:51','2024-12-04 16:35:51'),(2279,NULL,'DUMMY',2279,1,'2024-12-04 16:35:51','2024-12-04 16:35:51'),(2280,NULL,'DUMMY',2280,1,'2024-12-04 16:35:51','2024-12-04 16:35:51'),(2281,NULL,'DUMMY',2281,1,'2024-12-04 16:35:51','2024-12-04 16:35:51'),(2282,NULL,'DUMMY',2282,1,'2024-12-04 16:35:51','2024-12-04 16:35:51'),(2283,NULL,'DUMMY',2283,1,'2024-12-04 16:35:51','2024-12-04 16:35:51'),(2284,NULL,'DUMMY',2284,1,'2024-12-04 16:35:51','2024-12-04 16:35:51'),(2285,NULL,'DUMMY',2285,1,'2024-12-04 16:35:51','2024-12-04 16:35:51'),(2286,NULL,'DUMMY',2286,1,'2024-12-04 16:35:51','2024-12-04 16:35:51'),(2287,NULL,'DUMMY',2287,1,'2024-12-04 16:35:51','2024-12-04 16:35:51'),(2288,NULL,'DUMMY',2288,1,'2024-12-04 16:35:51','2024-12-04 16:35:51'),(2289,NULL,'DUMMY',2289,1,'2024-12-04 16:35:51','2024-12-04 16:35:51'),(2290,NULL,'DUMMY',2290,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2291,NULL,'DUMMY',2291,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2292,NULL,'DUMMY',2292,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2293,NULL,'DUMMY',2293,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2294,NULL,'DUMMY',2294,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2295,NULL,'DUMMY',2295,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2296,NULL,'DUMMY',2296,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2297,NULL,'DUMMY',2297,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2298,NULL,'DUMMY',2298,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2299,NULL,'DUMMY',2299,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2300,NULL,'DUMMY',2300,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2301,NULL,'DUMMY',2301,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2302,NULL,'DUMMY',2302,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2303,NULL,'DUMMY',2303,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2304,NULL,'DUMMY',2304,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2305,NULL,'DUMMY',2305,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2306,NULL,'DUMMY',2306,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2307,NULL,'DUMMY',2307,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2308,NULL,'DUMMY',2308,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2309,NULL,'DUMMY',2309,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2310,NULL,'DUMMY',2310,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2311,NULL,'DUMMY',2311,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2312,NULL,'DUMMY',2312,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2313,NULL,'DUMMY',2313,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2314,NULL,'DUMMY',2314,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2315,NULL,'DUMMY',2315,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2316,NULL,'DUMMY',2316,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2317,NULL,'DUMMY',2317,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2318,NULL,'DUMMY',2318,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2319,NULL,'DUMMY',2319,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2320,NULL,'DUMMY',2320,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2321,NULL,'DUMMY',2321,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2322,NULL,'DUMMY',2322,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2323,NULL,'DUMMY',2323,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2324,NULL,'DUMMY',2324,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2325,NULL,'DUMMY',2325,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2326,NULL,'DUMMY',2326,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2327,NULL,'DUMMY',2327,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2328,NULL,'DUMMY',2328,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2329,NULL,'DUMMY',2329,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2330,NULL,'DUMMY',2330,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2331,NULL,'DUMMY',2331,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2332,NULL,'DUMMY',2332,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2333,NULL,'DUMMY',2333,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2334,NULL,'DUMMY',2334,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2335,NULL,'DUMMY',2335,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2336,NULL,'DUMMY',2336,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2337,NULL,'DUMMY',2337,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2338,NULL,'DUMMY',2338,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2339,NULL,'DUMMY',2339,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2340,NULL,'DUMMY',2340,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2341,NULL,'DUMMY',2341,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2342,NULL,'DUMMY',2342,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2343,NULL,'DUMMY',2343,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2344,NULL,'DUMMY',2344,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2345,NULL,'DUMMY',2345,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2346,NULL,'DUMMY',2346,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2347,NULL,'DUMMY',2347,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2348,NULL,'DUMMY',2348,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2349,NULL,'DUMMY',2349,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2350,NULL,'DUMMY',2350,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2351,NULL,'DUMMY',2351,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2352,NULL,'DUMMY',2352,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2353,NULL,'DUMMY',2353,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2354,NULL,'DUMMY',2354,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2355,NULL,'DUMMY',2355,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2356,NULL,'DUMMY',2356,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2357,NULL,'DUMMY',2357,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2358,NULL,'DUMMY',2358,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2359,NULL,'DUMMY',2359,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2360,NULL,'DUMMY',2360,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2361,NULL,'DUMMY',2361,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2362,NULL,'DUMMY',2362,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2363,NULL,'DUMMY',2363,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2364,NULL,'DUMMY',2364,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2365,NULL,'DUMMY',2365,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2366,NULL,'DUMMY',2366,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2367,NULL,'DUMMY',2367,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2368,NULL,'DUMMY',2368,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2369,NULL,'DUMMY',2369,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2370,NULL,'DUMMY',2370,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2371,NULL,'DUMMY',2371,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2372,NULL,'DUMMY',2372,1,'2024-12-04 16:35:52','2024-12-04 16:35:52'),(2373,NULL,'DUMMY',2373,1,'2024-12-04 16:35:53','2024-12-04 16:35:53'),(2374,NULL,'DUMMY',2374,1,'2024-12-04 16:35:53','2024-12-04 16:35:53'),(2375,NULL,'DUMMY',2375,1,'2024-12-04 16:35:53','2024-12-04 16:35:53'),(2376,NULL,'DUMMY',2376,1,'2024-12-04 16:35:53','2024-12-04 16:35:53'),(2377,NULL,'DUMMY',2377,1,'2024-12-04 16:35:53','2024-12-04 16:35:53'),(2378,NULL,'DUMMY',2378,1,'2024-12-04 16:35:53','2024-12-04 16:35:53'),(2379,NULL,'DUMMY',2379,1,'2024-12-04 16:35:53','2024-12-04 16:35:53'),(2380,NULL,'DUMMY',2380,1,'2024-12-04 16:35:53','2024-12-04 16:35:53'),(2381,NULL,'DUMMY',2381,1,'2024-12-04 16:35:53','2024-12-04 16:35:53'),(2382,NULL,'DUMMY',2382,1,'2024-12-04 16:35:53','2024-12-04 16:35:53'),(2383,NULL,'DUMMY',2383,1,'2024-12-04 16:35:53','2024-12-04 16:35:53'),(2384,NULL,'DUMMY',2384,1,'2024-12-04 16:35:53','2024-12-04 16:35:53'),(2385,NULL,'DUMMY',2385,1,'2024-12-04 16:35:53','2024-12-04 16:35:53'),(2386,NULL,'DUMMY',2386,1,'2024-12-04 16:35:53','2024-12-04 16:35:53'),(2387,NULL,'DUMMY',2387,1,'2024-12-04 16:35:53','2024-12-04 16:35:53'),(2388,NULL,'DUMMY',2388,1,'2024-12-04 16:35:53','2024-12-04 16:35:53'),(2389,NULL,'DUMMY',2389,1,'2024-12-04 16:35:53','2024-12-04 16:35:53'),(2390,NULL,'DUMMY',2390,1,'2024-12-04 16:35:53','2024-12-04 16:35:53'),(2391,NULL,'DUMMY',2391,1,'2024-12-04 16:35:53','2024-12-04 16:35:53'),(2392,NULL,'DUMMY',2392,1,'2024-12-04 16:35:53','2024-12-04 16:35:53'),(2393,NULL,'DUMMY',2393,1,'2024-12-04 16:35:53','2024-12-04 16:35:53'),(2394,NULL,'DUMMY',2394,1,'2024-12-04 16:35:53','2024-12-04 16:35:53'),(2395,NULL,'DUMMY',2395,1,'2024-12-04 16:35:53','2024-12-04 16:35:53'),(2396,NULL,'DUMMY',2396,1,'2024-12-04 16:35:53','2024-12-04 16:35:53'),(2397,NULL,'DUMMY',2397,1,'2024-12-04 16:35:53','2024-12-04 16:35:53'),(2398,NULL,'DUMMY',2398,1,'2024-12-04 16:35:53','2024-12-04 16:35:53'),(2399,NULL,'DUMMY',2399,1,'2024-12-04 16:35:53','2024-12-04 16:35:53'),(2400,NULL,'DUMMY',2400,1,'2024-12-04 16:35:53','2024-12-04 16:35:53'),(2401,NULL,'DUMMY',2401,1,'2024-12-04 16:35:53','2024-12-04 16:35:53'),(2402,NULL,'DUMMY',2402,1,'2024-12-04 16:35:53','2024-12-04 16:35:53'),(2403,NULL,'DUMMY',2403,1,'2024-12-04 16:35:53','2024-12-04 16:35:53'),(2404,NULL,'DUMMY',2404,1,'2024-12-04 16:35:53','2024-12-04 16:35:53'),(2405,NULL,'DUMMY',2405,1,'2024-12-04 16:35:53','2024-12-04 16:35:53'),(2406,NULL,'DUMMY',2406,1,'2024-12-04 16:35:53','2024-12-04 16:35:53'),(2407,NULL,'DUMMY',2407,1,'2024-12-04 16:35:53','2024-12-04 16:35:53'),(2408,NULL,'DUMMY',2408,1,'2024-12-04 16:35:53','2024-12-04 16:35:53'),(2409,NULL,'DUMMY',2409,1,'2024-12-04 16:35:53','2024-12-04 16:35:53'),(2410,NULL,'DUMMY',2410,1,'2024-12-04 16:35:53','2024-12-04 16:35:53'),(2411,NULL,'DUMMY',2411,1,'2024-12-04 16:35:53','2024-12-04 16:35:53'),(2412,NULL,'DUMMY',2412,1,'2024-12-04 16:35:53','2024-12-04 16:35:53'),(2413,NULL,'DUMMY',2413,1,'2024-12-04 16:35:53','2024-12-04 16:35:53'),(2414,NULL,'DUMMY',2414,1,'2024-12-04 16:35:53','2024-12-04 16:35:53'),(2415,NULL,'DUMMY',2415,1,'2024-12-04 16:35:53','2024-12-04 16:35:53'),(2416,NULL,'DUMMY',2416,1,'2024-12-04 16:35:53','2024-12-04 16:35:53'),(2417,NULL,'DUMMY',2417,1,'2024-12-04 16:35:53','2024-12-04 16:35:53'),(2418,NULL,'DUMMY',2418,1,'2024-12-04 16:35:53','2024-12-04 16:35:53'),(2419,NULL,'DUMMY',2419,1,'2024-12-04 16:35:53','2024-12-04 16:35:53'),(2420,NULL,'DUMMY',2420,1,'2024-12-04 16:35:53','2024-12-04 16:35:53'),(2421,NULL,'DUMMY',2421,1,'2024-12-04 16:35:53','2024-12-04 16:35:53'),(2422,NULL,'DUMMY',2422,1,'2024-12-04 16:35:53','2024-12-04 16:35:53'),(2423,NULL,'DUMMY',2423,1,'2024-12-04 16:35:53','2024-12-04 16:35:53'),(2424,NULL,'DUMMY',2424,1,'2024-12-04 16:35:53','2024-12-04 16:35:53'),(2425,NULL,'DUMMY',2425,1,'2024-12-04 16:35:53','2024-12-04 16:35:53'),(2426,NULL,'DUMMY',2426,1,'2024-12-04 16:35:53','2024-12-04 16:35:53'),(2427,NULL,'DUMMY',2427,1,'2024-12-04 16:35:53','2024-12-04 16:35:53'),(2428,NULL,'DUMMY',2428,1,'2024-12-04 16:35:53','2024-12-04 16:35:53'),(2429,NULL,'DUMMY',2429,1,'2024-12-04 16:35:53','2024-12-04 16:35:53'),(2430,NULL,'DUMMY',2430,1,'2024-12-04 16:35:53','2024-12-04 16:35:53'),(2431,NULL,'DUMMY',2431,1,'2024-12-04 16:35:53','2024-12-04 16:35:53'),(2432,NULL,'DUMMY',2432,1,'2024-12-04 16:35:53','2024-12-04 16:35:53'),(2433,NULL,'DUMMY',2433,1,'2024-12-04 16:35:53','2024-12-04 16:35:53'),(2434,NULL,'DUMMY',2434,1,'2024-12-04 16:35:53','2024-12-04 16:35:53'),(2435,NULL,'DUMMY',2435,1,'2024-12-04 16:35:53','2024-12-04 16:35:53'),(2436,NULL,'DUMMY',2436,1,'2024-12-04 16:35:53','2024-12-04 16:35:53'),(2437,NULL,'DUMMY',2437,1,'2024-12-04 16:35:53','2024-12-04 16:35:53'),(2438,NULL,'DUMMY',2438,1,'2024-12-04 16:35:53','2024-12-04 16:35:53'),(2439,NULL,'DUMMY',2439,1,'2024-12-04 16:35:53','2024-12-04 16:35:53'),(2440,NULL,'DUMMY',2440,1,'2024-12-04 16:35:53','2024-12-04 16:35:53'),(2441,NULL,'DUMMY',2441,1,'2024-12-04 16:35:53','2024-12-04 16:35:53'),(2442,NULL,'DUMMY',2442,1,'2024-12-04 16:35:53','2024-12-04 16:35:53'),(2443,NULL,'DUMMY',2443,1,'2024-12-04 16:35:53','2024-12-04 16:35:53'),(2444,NULL,'DUMMY',2444,1,'2024-12-04 16:35:53','2024-12-04 16:35:53'),(2445,NULL,'DUMMY',2445,1,'2024-12-04 16:35:54','2024-12-04 16:35:54'),(2446,NULL,'DUMMY',2446,1,'2024-12-04 16:35:54','2024-12-04 16:35:54'),(2447,NULL,'DUMMY',2447,1,'2024-12-04 16:35:54','2024-12-04 16:35:54'),(2448,NULL,'DUMMY',2448,1,'2024-12-04 16:35:54','2024-12-04 16:35:54'),(2449,NULL,'DUMMY',2449,1,'2024-12-04 16:35:54','2024-12-04 16:35:54'),(2450,NULL,'DUMMY',2450,1,'2024-12-04 16:35:54','2024-12-04 16:35:54'),(2451,NULL,'DUMMY',2451,1,'2024-12-04 16:35:54','2024-12-04 16:35:54'),(2452,NULL,'DUMMY',2452,1,'2024-12-04 16:35:54','2024-12-04 16:35:54'),(2453,NULL,'DUMMY',2453,1,'2024-12-04 16:35:54','2024-12-04 16:35:54'),(2454,NULL,'DUMMY',2454,1,'2024-12-04 16:35:54','2024-12-04 16:35:54'),(2455,NULL,'DUMMY',2455,1,'2024-12-04 16:35:54','2024-12-04 16:35:54'),(2456,NULL,'DUMMY',2456,1,'2024-12-04 16:35:54','2024-12-04 16:35:54'),(2457,NULL,'DUMMY',2457,1,'2024-12-04 16:35:54','2024-12-04 16:35:54'),(2458,NULL,'DUMMY',2458,1,'2024-12-04 16:35:54','2024-12-04 16:35:54'),(2459,NULL,'DUMMY',2459,1,'2024-12-04 16:35:54','2024-12-04 16:35:54'),(2460,NULL,'DUMMY',2460,1,'2024-12-04 16:35:54','2024-12-04 16:35:54'),(2461,NULL,'DUMMY',2461,1,'2024-12-04 16:35:54','2024-12-04 16:35:54'),(2462,NULL,'DUMMY',2462,1,'2024-12-04 16:35:54','2024-12-04 16:35:54'),(2463,NULL,'DUMMY',2463,1,'2024-12-04 16:35:54','2024-12-04 16:35:54'),(2464,NULL,'DUMMY',2464,1,'2024-12-04 16:35:54','2024-12-04 16:35:54'),(2465,NULL,'DUMMY',2465,1,'2024-12-04 16:35:54','2024-12-04 16:35:54'),(2466,NULL,'DUMMY',2466,1,'2024-12-04 16:35:54','2024-12-04 16:35:54'),(2467,NULL,'DUMMY',2467,1,'2024-12-04 16:35:54','2024-12-04 16:35:54'),(2468,NULL,'DUMMY',2468,1,'2024-12-04 16:35:54','2024-12-04 16:35:54'),(2469,NULL,'DUMMY',2469,1,'2024-12-04 16:35:54','2024-12-04 16:35:54'),(2470,NULL,'DUMMY',2470,1,'2024-12-04 16:35:54','2024-12-04 16:35:54'),(2471,NULL,'DUMMY',2471,1,'2024-12-04 16:35:54','2024-12-04 16:35:54'),(2472,NULL,'DUMMY',2472,1,'2024-12-04 16:35:54','2024-12-04 16:35:54'),(2473,NULL,'DUMMY',2473,1,'2024-12-04 16:35:54','2024-12-04 16:35:54'),(2474,NULL,'DUMMY',2474,1,'2024-12-04 16:35:54','2024-12-04 16:35:54'),(2475,NULL,'DUMMY',2475,1,'2024-12-04 16:35:54','2024-12-04 16:35:54'),(2476,NULL,'DUMMY',2476,1,'2024-12-04 16:35:54','2024-12-04 16:35:54'),(2477,NULL,'DUMMY',2477,1,'2024-12-04 16:35:54','2024-12-04 16:35:54'),(2478,NULL,'DUMMY',2478,1,'2024-12-04 16:35:54','2024-12-04 16:35:54'),(2479,NULL,'DUMMY',2479,1,'2024-12-04 16:35:54','2024-12-04 16:35:54'),(2480,NULL,'DUMMY',2480,1,'2024-12-04 16:35:54','2024-12-04 16:35:54'),(2481,NULL,'DUMMY',2481,1,'2024-12-04 16:35:54','2024-12-04 16:35:54'),(2482,NULL,'DUMMY',2482,1,'2024-12-04 16:35:54','2024-12-04 16:35:54'),(2483,NULL,'DUMMY',2483,1,'2024-12-04 16:35:54','2024-12-04 16:35:54'),(2484,NULL,'DUMMY',2484,1,'2024-12-04 16:35:54','2024-12-04 16:35:54'),(2485,NULL,'DUMMY',2485,1,'2024-12-04 16:35:54','2024-12-04 16:35:54'),(2486,NULL,'DUMMY',2486,1,'2024-12-04 16:35:54','2024-12-04 16:35:54'),(2487,NULL,'DUMMY',2487,1,'2024-12-04 16:35:54','2024-12-04 16:35:54'),(2488,NULL,'DUMMY',2488,1,'2024-12-04 16:35:54','2024-12-04 16:35:54'),(2489,NULL,'DUMMY',2489,1,'2024-12-04 16:35:54','2024-12-04 16:35:54'),(2490,NULL,'DUMMY',2490,1,'2024-12-04 16:35:54','2024-12-04 16:35:54'),(2491,NULL,'DUMMY',2491,1,'2024-12-04 16:35:54','2024-12-04 16:35:54'),(2492,NULL,'DUMMY',2492,1,'2024-12-04 16:35:54','2024-12-04 16:35:54'),(2493,NULL,'DUMMY',2493,1,'2024-12-04 16:35:54','2024-12-04 16:35:54'),(2494,NULL,'DUMMY',2494,1,'2024-12-04 16:35:54','2024-12-04 16:35:54'),(2495,NULL,'DUMMY',2495,1,'2024-12-04 16:35:54','2024-12-04 16:35:54'),(2496,NULL,'DUMMY',2496,1,'2024-12-04 16:35:54','2024-12-04 16:35:54'),(2497,NULL,'DUMMY',2497,1,'2024-12-04 16:35:54','2024-12-04 16:35:54'),(2498,NULL,'DUMMY',2498,1,'2024-12-04 16:35:54','2024-12-04 16:35:54'),(2499,NULL,'DUMMY',2499,1,'2024-12-04 16:35:54','2024-12-04 16:35:54'),(2500,NULL,'DUMMY',2500,1,'2024-12-04 16:35:54','2024-12-04 16:35:54'),(2501,NULL,'DUMMY',2501,1,'2024-12-04 16:35:54','2024-12-04 16:35:54'),(2502,NULL,'DUMMY',2502,1,'2024-12-04 16:35:54','2024-12-04 16:35:54'),(2503,NULL,'DUMMY',2503,1,'2024-12-04 16:35:54','2024-12-04 16:35:54'),(2504,NULL,'DUMMY',2504,1,'2024-12-04 16:35:54','2024-12-04 16:35:54'),(2505,NULL,'DUMMY',2505,1,'2024-12-04 16:35:54','2024-12-04 16:35:54'),(2506,NULL,'DUMMY',2506,1,'2024-12-04 16:35:54','2024-12-04 16:35:54'),(2507,NULL,'DUMMY',2507,1,'2024-12-04 16:35:54','2024-12-04 16:35:54'),(2508,NULL,'DUMMY',2508,1,'2024-12-04 16:35:54','2024-12-04 16:35:54'),(2509,NULL,'DUMMY',2509,1,'2024-12-04 16:35:55','2024-12-04 16:35:55'),(2510,NULL,'DUMMY',2510,1,'2024-12-04 16:35:55','2024-12-04 16:35:55'),(2511,NULL,'DUMMY',2511,1,'2024-12-04 16:35:55','2024-12-04 16:35:55'),(2512,NULL,'DUMMY',2512,1,'2024-12-04 16:35:55','2024-12-04 16:35:55'),(2513,NULL,'DUMMY',2513,1,'2024-12-04 16:35:55','2024-12-04 16:35:55'),(2514,NULL,'DUMMY',2514,1,'2024-12-04 16:35:55','2024-12-04 16:35:55'),(2515,NULL,'DUMMY',2515,1,'2024-12-04 16:35:55','2024-12-04 16:35:55'),(2516,NULL,'DUMMY',2516,1,'2024-12-04 16:35:55','2024-12-04 16:35:55'),(2517,NULL,'DUMMY',2517,1,'2024-12-04 16:35:55','2024-12-04 16:35:55'),(2518,NULL,'DUMMY',2518,1,'2024-12-04 16:35:55','2024-12-04 16:35:55'),(2519,NULL,'DUMMY',2519,1,'2024-12-04 16:35:55','2024-12-04 16:35:55'),(2520,NULL,'DUMMY',2520,1,'2024-12-04 16:35:55','2024-12-04 16:35:55'),(2521,NULL,'DUMMY',2521,1,'2024-12-04 16:35:55','2024-12-04 16:35:55'),(2522,NULL,'DUMMY',2522,1,'2024-12-04 16:35:55','2024-12-04 16:35:55'),(2523,NULL,'DUMMY',2523,1,'2024-12-04 16:35:55','2024-12-04 16:35:55'),(2524,NULL,'DUMMY',2524,1,'2024-12-04 16:35:55','2024-12-04 16:35:55'),(2525,NULL,'DUMMY',2525,1,'2024-12-04 16:35:55','2024-12-04 16:35:55'),(2526,NULL,'DUMMY',2526,1,'2024-12-04 16:35:55','2024-12-04 16:35:55'),(2527,NULL,'DUMMY',2527,1,'2024-12-04 16:35:55','2024-12-04 16:35:55'),(2528,NULL,'DUMMY',2528,1,'2024-12-04 16:35:55','2024-12-04 16:35:55'),(2529,NULL,'DUMMY',2529,1,'2024-12-04 16:35:55','2024-12-04 16:35:55'),(2530,NULL,'DUMMY',2530,1,'2024-12-04 16:35:55','2024-12-04 16:35:55'),(2531,NULL,'DUMMY',2531,1,'2024-12-04 16:35:55','2024-12-04 16:35:55'),(2532,NULL,'DUMMY',2532,1,'2024-12-04 16:35:55','2024-12-04 16:35:55'),(2533,NULL,'DUMMY',2533,1,'2024-12-04 16:35:55','2024-12-04 16:35:55'),(2534,NULL,'DUMMY',2534,1,'2024-12-04 16:35:55','2024-12-04 16:35:55'),(2535,NULL,'DUMMY',2535,1,'2024-12-04 16:35:55','2024-12-04 16:35:55'),(2536,NULL,'DUMMY',2536,1,'2024-12-04 16:35:55','2024-12-04 16:35:55'),(2537,NULL,'DUMMY',2537,1,'2024-12-04 16:35:55','2024-12-04 16:35:55'),(2538,NULL,'DUMMY',2538,1,'2024-12-04 16:35:55','2024-12-04 16:35:55'),(2539,NULL,'DUMMY',2539,1,'2024-12-04 16:35:55','2024-12-04 16:35:55'),(2540,NULL,'DUMMY',2540,1,'2024-12-04 16:35:55','2024-12-04 16:35:55'),(2541,NULL,'DUMMY',2541,1,'2024-12-04 16:35:55','2024-12-04 16:35:55'),(2542,NULL,'DUMMY',2542,1,'2024-12-04 16:35:55','2024-12-04 16:35:55'),(2543,NULL,'DUMMY',2543,1,'2024-12-04 16:35:55','2024-12-04 16:35:55'),(2544,NULL,'DUMMY',2544,1,'2024-12-04 16:35:55','2024-12-04 16:35:55'),(2545,NULL,'DUMMY',2545,1,'2024-12-04 16:35:55','2024-12-04 16:35:55'),(2546,NULL,'DUMMY',2546,1,'2024-12-04 16:35:55','2024-12-04 16:35:55'),(2547,NULL,'DUMMY',2547,1,'2024-12-04 16:35:55','2024-12-04 16:35:55'),(2548,NULL,'DUMMY',2548,1,'2024-12-04 16:35:55','2024-12-04 16:35:55'),(2549,NULL,'DUMMY',2549,1,'2024-12-04 16:35:55','2024-12-04 16:35:55'),(2550,NULL,'DUMMY',2550,1,'2024-12-04 16:35:55','2024-12-04 16:35:55'),(2551,NULL,'DUMMY',2551,1,'2024-12-04 16:35:55','2024-12-04 16:35:55'),(2552,NULL,'DUMMY',2552,1,'2024-12-04 16:35:55','2024-12-04 16:35:55'),(2553,NULL,'DUMMY',2553,1,'2024-12-04 16:35:55','2024-12-04 16:35:55'),(2554,NULL,'DUMMY',2554,1,'2024-12-04 16:35:55','2024-12-04 16:35:55'),(2555,NULL,'DUMMY',2555,1,'2024-12-04 16:35:55','2024-12-04 16:35:55'),(2556,NULL,'DUMMY',2556,1,'2024-12-04 16:35:55','2024-12-04 16:35:55'),(2557,NULL,'DUMMY',2557,1,'2024-12-04 16:35:55','2024-12-04 16:35:55'),(2558,NULL,'DUMMY',2558,1,'2024-12-04 16:35:55','2024-12-04 16:35:55'),(2559,NULL,'DUMMY',2559,1,'2024-12-04 16:35:55','2024-12-04 16:35:55'),(2560,NULL,'DUMMY',2560,1,'2024-12-04 16:35:55','2024-12-04 16:35:55'),(2561,NULL,'DUMMY',2561,1,'2024-12-04 16:35:55','2024-12-04 16:35:55'),(2562,NULL,'DUMMY',2562,1,'2024-12-04 16:35:55','2024-12-04 16:35:55'),(2563,NULL,'DUMMY',2563,1,'2024-12-04 16:35:55','2024-12-04 16:35:55'),(2564,NULL,'DUMMY',2564,1,'2024-12-04 16:35:55','2024-12-04 16:35:55'),(2565,NULL,'DUMMY',2565,1,'2024-12-04 16:35:55','2024-12-04 16:35:55'),(2566,NULL,'DUMMY',2566,1,'2024-12-04 16:35:55','2024-12-04 16:35:55'),(2567,NULL,'DUMMY',2567,1,'2024-12-04 16:35:55','2024-12-04 16:35:55'),(2568,NULL,'DUMMY',2568,1,'2024-12-04 16:35:55','2024-12-04 16:35:55'),(2569,NULL,'DUMMY',2569,1,'2024-12-04 16:35:55','2024-12-04 16:35:55'),(2570,NULL,'DUMMY',2570,1,'2024-12-04 16:35:55','2024-12-04 16:35:55'),(2571,NULL,'DUMMY',2571,1,'2024-12-04 16:35:55','2024-12-04 16:35:55'),(2572,NULL,'DUMMY',2572,1,'2024-12-04 16:35:55','2024-12-04 16:35:55'),(2573,NULL,'DUMMY',2573,1,'2024-12-04 16:35:55','2024-12-04 16:35:55'),(2574,NULL,'DUMMY',2574,1,'2024-12-04 16:35:55','2024-12-04 16:35:55'),(2575,NULL,'DUMMY',2575,1,'2024-12-04 16:35:55','2024-12-04 16:35:55'),(2576,NULL,'DUMMY',2576,1,'2024-12-04 16:35:55','2024-12-04 16:35:55'),(2577,NULL,'DUMMY',2577,1,'2024-12-04 16:35:55','2024-12-04 16:35:55'),(2578,NULL,'DUMMY',2578,1,'2024-12-04 16:35:55','2024-12-04 16:35:55'),(2579,NULL,'DUMMY',2579,1,'2024-12-04 16:35:55','2024-12-04 16:35:55'),(2580,NULL,'DUMMY',2580,1,'2024-12-04 16:35:55','2024-12-04 16:35:55'),(2581,NULL,'DUMMY',2581,1,'2024-12-04 16:35:55','2024-12-04 16:35:55'),(2582,NULL,'DUMMY',2582,1,'2024-12-04 16:35:55','2024-12-04 16:35:55'),(2583,NULL,'DUMMY',2583,1,'2024-12-04 16:35:55','2024-12-04 16:35:55'),(2584,NULL,'DUMMY',2584,1,'2024-12-04 16:35:55','2024-12-04 16:35:55'),(2585,NULL,'DUMMY',2585,1,'2024-12-04 16:35:55','2024-12-04 16:35:55'),(2586,NULL,'DUMMY',2586,1,'2024-12-04 16:35:55','2024-12-04 16:35:55'),(2587,NULL,'DUMMY',2587,1,'2024-12-04 16:35:55','2024-12-04 16:35:55'),(2588,NULL,'DUMMY',2588,1,'2024-12-04 16:35:55','2024-12-04 16:35:55'),(2589,NULL,'DUMMY',2589,1,'2024-12-04 16:35:55','2024-12-04 16:35:55'),(2590,NULL,'DUMMY',2590,1,'2024-12-04 16:35:56','2024-12-04 16:35:56'),(2591,NULL,'DUMMY',2591,1,'2024-12-04 16:35:56','2024-12-04 16:35:56'),(2592,NULL,'DUMMY',2592,1,'2024-12-04 16:35:56','2024-12-04 16:35:56'),(2593,NULL,'DUMMY',2593,1,'2024-12-04 16:35:56','2024-12-04 16:35:56'),(2594,NULL,'DUMMY',2594,1,'2024-12-04 16:35:56','2024-12-04 16:35:56'),(2595,NULL,'DUMMY',2595,1,'2024-12-04 16:35:56','2024-12-04 16:35:56'),(2596,NULL,'DUMMY',2596,1,'2024-12-04 16:35:56','2024-12-04 16:35:56'),(2597,NULL,'DUMMY',2597,1,'2024-12-04 16:35:56','2024-12-04 16:35:56'),(2598,NULL,'DUMMY',2598,1,'2024-12-04 16:35:56','2024-12-04 16:35:56'),(2599,NULL,'DUMMY',2599,1,'2024-12-04 16:35:56','2024-12-04 16:35:56'),(2600,NULL,'DUMMY',2600,1,'2024-12-04 16:35:56','2024-12-04 16:35:56'),(2601,NULL,'DUMMY',2601,1,'2024-12-04 16:35:56','2024-12-04 16:35:56'),(2602,NULL,'DUMMY',2602,1,'2024-12-04 16:35:56','2024-12-04 16:35:56'),(2603,NULL,'DUMMY',2603,1,'2024-12-04 16:35:56','2024-12-04 16:35:56'),(2604,NULL,'DUMMY',2604,1,'2024-12-04 16:35:56','2024-12-04 16:35:56'),(2605,NULL,'DUMMY',2605,1,'2024-12-04 16:35:56','2024-12-04 16:35:56'),(2606,NULL,'DUMMY',2606,1,'2024-12-04 16:35:56','2024-12-04 16:35:56'),(2607,NULL,'DUMMY',2607,1,'2024-12-04 16:35:56','2024-12-04 16:35:56'),(2608,NULL,'DUMMY',2608,1,'2024-12-04 16:35:56','2024-12-04 16:35:56'),(2609,NULL,'DUMMY',2609,1,'2024-12-04 16:35:56','2024-12-04 16:35:56'),(2610,NULL,'DUMMY',2610,1,'2024-12-04 16:35:56','2024-12-04 16:35:56'),(2611,NULL,'DUMMY',2611,1,'2024-12-04 16:35:56','2024-12-04 16:35:56'),(2612,NULL,'DUMMY',2612,1,'2024-12-04 16:35:56','2024-12-04 16:35:56'),(2613,NULL,'DUMMY',2613,1,'2024-12-04 16:35:56','2024-12-04 16:35:56'),(2614,NULL,'DUMMY',2614,1,'2024-12-04 16:35:56','2024-12-04 16:35:56'),(2615,NULL,'DUMMY',2615,1,'2024-12-04 16:35:56','2024-12-04 16:35:56'),(2616,NULL,'DUMMY',2616,1,'2024-12-04 16:35:56','2024-12-04 16:35:56'),(2617,NULL,'DUMMY',2617,1,'2024-12-04 16:35:56','2024-12-04 16:35:56'),(2618,NULL,'DUMMY',2618,1,'2024-12-04 16:35:56','2024-12-04 16:35:56'),(2619,NULL,'DUMMY',2619,1,'2024-12-04 16:35:56','2024-12-04 16:35:56'),(2620,NULL,'DUMMY',2620,1,'2024-12-04 16:35:56','2024-12-04 16:35:56'),(2621,NULL,'DUMMY',2621,1,'2024-12-04 16:35:56','2024-12-04 16:35:56'),(2622,NULL,'DUMMY',2622,1,'2024-12-04 16:35:56','2024-12-04 16:35:56'),(2623,NULL,'DUMMY',2623,1,'2024-12-04 16:35:56','2024-12-04 16:35:56'),(2624,NULL,'DUMMY',2624,1,'2024-12-04 16:35:56','2024-12-04 16:35:56'),(2625,NULL,'DUMMY',2625,1,'2024-12-04 16:35:56','2024-12-04 16:35:56'),(2626,NULL,'DUMMY',2626,1,'2024-12-04 16:35:56','2024-12-04 16:35:56'),(2627,NULL,'DUMMY',2627,1,'2024-12-04 16:35:56','2024-12-04 16:35:56'),(2628,NULL,'DUMMY',2628,1,'2024-12-04 16:35:56','2024-12-04 16:35:56'),(2629,NULL,'DUMMY',2629,1,'2024-12-04 16:35:56','2024-12-04 16:35:56'),(2630,NULL,'DUMMY',2630,1,'2024-12-04 16:35:56','2024-12-04 16:35:56'),(2631,NULL,'DUMMY',2631,1,'2024-12-04 16:35:56','2024-12-04 16:35:56'),(2632,NULL,'DUMMY',2632,1,'2024-12-04 16:35:56','2024-12-04 16:35:56'),(2633,NULL,'DUMMY',2633,1,'2024-12-04 16:35:56','2024-12-04 16:35:56'),(2634,NULL,'DUMMY',2634,1,'2024-12-04 16:35:56','2024-12-04 16:35:56'),(2635,NULL,'DUMMY',2635,1,'2024-12-04 16:35:56','2024-12-04 16:35:56'),(2636,NULL,'DUMMY',2636,1,'2024-12-04 16:35:56','2024-12-04 16:35:56'),(2637,NULL,'DUMMY',2637,1,'2024-12-04 16:35:56','2024-12-04 16:35:56'),(2638,NULL,'DUMMY',2638,1,'2024-12-04 16:35:56','2024-12-04 16:35:56'),(2639,NULL,'DUMMY',2639,1,'2024-12-04 16:35:56','2024-12-04 16:35:56'),(2640,NULL,'DUMMY',2640,1,'2024-12-04 16:35:56','2024-12-04 16:35:56'),(2641,NULL,'DUMMY',2641,1,'2024-12-04 16:35:56','2024-12-04 16:35:56'),(2642,NULL,'DUMMY',2642,1,'2024-12-04 16:35:56','2024-12-04 16:35:56'),(2643,NULL,'DUMMY',2643,1,'2024-12-04 16:35:56','2024-12-04 16:35:56'),(2644,NULL,'DUMMY',2644,1,'2024-12-04 16:35:56','2024-12-04 16:35:56'),(2645,NULL,'DUMMY',2645,1,'2024-12-04 16:35:56','2024-12-04 16:35:56'),(2646,NULL,'DUMMY',2646,1,'2024-12-04 16:35:56','2024-12-04 16:35:56'),(2647,NULL,'DUMMY',2647,1,'2024-12-04 16:35:56','2024-12-04 16:35:56'),(2648,NULL,'DUMMY',2648,1,'2024-12-04 16:35:56','2024-12-04 16:35:56'),(2649,NULL,'DUMMY',2649,1,'2024-12-04 16:35:56','2024-12-04 16:35:56'),(2650,NULL,'DUMMY',2650,1,'2024-12-04 16:35:56','2024-12-04 16:35:56'),(2651,NULL,'DUMMY',2651,1,'2024-12-04 16:35:56','2024-12-04 16:35:56'),(2652,NULL,'DUMMY',2652,1,'2024-12-04 16:35:56','2024-12-04 16:35:56'),(2653,NULL,'DUMMY',2653,1,'2024-12-04 16:35:56','2024-12-04 16:35:56'),(2654,NULL,'DUMMY',2654,1,'2024-12-04 16:35:56','2024-12-04 16:35:56'),(2655,NULL,'DUMMY',2655,1,'2024-12-04 16:35:56','2024-12-04 16:35:56'),(2656,NULL,'DUMMY',2656,1,'2024-12-04 16:35:56','2024-12-04 16:35:56'),(2657,NULL,'DUMMY',2657,1,'2024-12-04 16:35:56','2024-12-04 16:35:56'),(2658,NULL,'DUMMY',2658,1,'2024-12-04 16:35:56','2024-12-04 16:35:56'),(2659,NULL,'DUMMY',2659,1,'2024-12-04 16:35:56','2024-12-04 16:35:56'),(2660,NULL,'DUMMY',2660,1,'2024-12-04 16:35:56','2024-12-04 16:35:56'),(2661,NULL,'DUMMY',2661,1,'2024-12-04 16:35:56','2024-12-04 16:35:56'),(2662,NULL,'DUMMY',2662,1,'2024-12-04 16:35:56','2024-12-04 16:35:56'),(2663,NULL,'DUMMY',2663,1,'2024-12-04 16:35:56','2024-12-04 16:35:56'),(2664,NULL,'DUMMY',2664,1,'2024-12-04 16:35:56','2024-12-04 16:35:56'),(2665,NULL,'DUMMY',2665,1,'2024-12-04 16:35:57','2024-12-04 16:35:57'),(2666,NULL,'DUMMY',2666,1,'2024-12-04 16:35:57','2024-12-04 16:35:57'),(2667,NULL,'DUMMY',2667,1,'2024-12-04 16:35:57','2024-12-04 16:35:57'),(2668,NULL,'DUMMY',2668,1,'2024-12-04 16:35:57','2024-12-04 16:35:57'),(2669,NULL,'DUMMY',2669,1,'2024-12-04 16:35:57','2024-12-04 16:35:57'),(2670,NULL,'DUMMY',2670,1,'2024-12-04 16:35:57','2024-12-04 16:35:57'),(2671,NULL,'DUMMY',2671,1,'2024-12-04 16:35:57','2024-12-04 16:35:57'),(2672,NULL,'DUMMY',2672,1,'2024-12-04 16:35:57','2024-12-04 16:35:57'),(2673,NULL,'DUMMY',2673,1,'2024-12-04 16:35:57','2024-12-04 16:35:57'),(2674,NULL,'DUMMY',2674,1,'2024-12-04 16:35:57','2024-12-04 16:35:57'),(2675,NULL,'DUMMY',2675,1,'2024-12-04 16:35:57','2024-12-04 16:35:57'),(2676,NULL,'DUMMY',2676,1,'2024-12-04 16:35:57','2024-12-04 16:35:57'),(2677,NULL,'DUMMY',2677,1,'2024-12-04 16:35:57','2024-12-04 16:35:57'),(2678,NULL,'DUMMY',2678,1,'2024-12-04 16:35:57','2024-12-04 16:35:57'),(2679,NULL,'DUMMY',2679,1,'2024-12-04 16:35:57','2024-12-04 16:35:57'),(2680,NULL,'DUMMY',2680,1,'2024-12-04 16:35:57','2024-12-04 16:35:57'),(2681,NULL,'DUMMY',2681,1,'2024-12-04 16:35:57','2024-12-04 16:35:57'),(2682,NULL,'DUMMY',2682,1,'2024-12-04 16:35:57','2024-12-04 16:35:57'),(2683,NULL,'DUMMY',2683,1,'2024-12-04 16:35:57','2024-12-04 16:35:57'),(2684,NULL,'DUMMY',2684,1,'2024-12-04 16:35:57','2024-12-04 16:35:57'),(2685,NULL,'DUMMY',2685,1,'2024-12-04 16:35:57','2024-12-04 16:35:57'),(2686,NULL,'DUMMY',2686,1,'2024-12-04 16:35:57','2024-12-04 16:35:57'),(2687,NULL,'DUMMY',2687,1,'2024-12-04 16:35:57','2024-12-04 16:35:57'),(2688,NULL,'DUMMY',2688,1,'2024-12-04 16:35:57','2024-12-04 16:35:57'),(2689,NULL,'DUMMY',2689,1,'2024-12-04 16:35:57','2024-12-04 16:35:57'),(2690,NULL,'DUMMY',2690,1,'2024-12-04 16:35:57','2024-12-04 16:35:57'),(2691,NULL,'DUMMY',2691,1,'2024-12-04 16:35:57','2024-12-04 16:35:57'),(2692,NULL,'DUMMY',2692,1,'2024-12-04 16:35:57','2024-12-04 16:35:57'),(2693,NULL,'DUMMY',2693,1,'2024-12-04 16:35:57','2024-12-04 16:35:57'),(2694,NULL,'DUMMY',2694,1,'2024-12-04 16:35:57','2024-12-04 16:35:57'),(2695,NULL,'DUMMY',2695,1,'2024-12-04 16:35:57','2024-12-04 16:35:57'),(2696,NULL,'DUMMY',2696,1,'2024-12-04 16:35:57','2024-12-04 16:35:57'),(2697,NULL,'DUMMY',2697,1,'2024-12-04 16:35:57','2024-12-04 16:35:57'),(2698,NULL,'DUMMY',2698,1,'2024-12-04 16:35:57','2024-12-04 16:35:57'),(2699,NULL,'DUMMY',2699,1,'2024-12-04 16:35:57','2024-12-04 16:35:57'),(2700,NULL,'DUMMY',2700,1,'2024-12-04 16:35:57','2024-12-04 16:35:57'),(2701,NULL,'DUMMY',2701,1,'2024-12-04 16:35:57','2024-12-04 16:35:57'),(2702,NULL,'DUMMY',2702,1,'2024-12-04 16:35:57','2024-12-04 16:35:57'),(2703,NULL,'DUMMY',2703,1,'2024-12-04 16:35:57','2024-12-04 16:35:57'),(2704,NULL,'DUMMY',2704,1,'2024-12-04 16:35:57','2024-12-04 16:35:57'),(2705,NULL,'DUMMY',2705,1,'2024-12-04 16:35:57','2024-12-04 16:35:57'),(2706,NULL,'DUMMY',2706,1,'2024-12-04 16:35:57','2024-12-04 16:35:57'),(2707,NULL,'DUMMY',2707,1,'2024-12-04 16:35:57','2024-12-04 16:35:57'),(2708,NULL,'DUMMY',2708,1,'2024-12-04 16:35:57','2024-12-04 16:35:57'),(2709,NULL,'DUMMY',2709,1,'2024-12-04 16:35:57','2024-12-04 16:35:57'),(2710,NULL,'DUMMY',2710,1,'2024-12-04 16:35:57','2024-12-04 16:35:57'),(2711,NULL,'DUMMY',2711,1,'2024-12-04 16:35:57','2024-12-04 16:35:57'),(2712,NULL,'DUMMY',2712,1,'2024-12-04 16:35:57','2024-12-04 16:35:57'),(2713,NULL,'DUMMY',2713,1,'2024-12-04 16:35:57','2024-12-04 16:35:57'),(2714,NULL,'DUMMY',2714,1,'2024-12-04 16:35:57','2024-12-04 16:35:57'),(2715,NULL,'DUMMY',2715,1,'2024-12-04 16:35:57','2024-12-04 16:35:57'),(2716,NULL,'DUMMY',2716,1,'2024-12-04 16:35:57','2024-12-04 16:35:57'),(2717,NULL,'DUMMY',2717,1,'2024-12-04 16:35:57','2024-12-04 16:35:57'),(2718,NULL,'DUMMY',2718,1,'2024-12-04 16:35:57','2024-12-04 16:35:57'),(2719,NULL,'DUMMY',2719,1,'2024-12-04 16:35:57','2024-12-04 16:35:57'),(2720,NULL,'DUMMY',2720,1,'2024-12-04 16:35:57','2024-12-04 16:35:57'),(2721,NULL,'DUMMY',2721,1,'2024-12-04 16:35:57','2024-12-04 16:35:57'),(2722,NULL,'DUMMY',2722,1,'2024-12-04 16:35:57','2024-12-04 16:35:57'),(2723,NULL,'DUMMY',2723,1,'2024-12-04 16:35:57','2024-12-04 16:35:57'),(2724,NULL,'DUMMY',2724,1,'2024-12-04 16:35:57','2024-12-04 16:35:57'),(2725,NULL,'DUMMY',2725,1,'2024-12-04 16:35:57','2024-12-04 16:35:57'),(2726,NULL,'DUMMY',2726,1,'2024-12-04 16:35:57','2024-12-04 16:35:57'),(2727,NULL,'DUMMY',2727,1,'2024-12-04 16:35:57','2024-12-04 16:35:57'),(2728,NULL,'DUMMY',2728,1,'2024-12-04 16:35:57','2024-12-04 16:35:57'),(2729,NULL,'DUMMY',2729,1,'2024-12-04 16:35:57','2024-12-04 16:35:57'),(2730,NULL,'DUMMY',2730,1,'2024-12-04 16:35:57','2024-12-04 16:35:57'),(2731,NULL,'DUMMY',2731,1,'2024-12-04 16:35:57','2024-12-04 16:35:57'),(2732,NULL,'DUMMY',2732,1,'2024-12-04 16:35:57','2024-12-04 16:35:57'),(2733,NULL,'DUMMY',2733,1,'2024-12-04 16:35:57','2024-12-04 16:35:57'),(2734,NULL,'DUMMY',2734,1,'2024-12-04 16:35:57','2024-12-04 16:35:57'),(2735,NULL,'DUMMY',2735,1,'2024-12-04 16:35:57','2024-12-04 16:35:57'),(2736,NULL,'DUMMY',2736,1,'2024-12-04 16:35:57','2024-12-04 16:35:57'),(2737,NULL,'DUMMY',2737,1,'2024-12-04 16:35:57','2024-12-04 16:35:57'),(2738,NULL,'DUMMY',2738,1,'2024-12-04 16:35:57','2024-12-04 16:35:57'),(2739,NULL,'DUMMY',2739,1,'2024-12-04 16:35:57','2024-12-04 16:35:57'),(2740,NULL,'DUMMY',2740,1,'2024-12-04 16:35:57','2024-12-04 16:35:57'),(2741,NULL,'DUMMY',2741,1,'2024-12-04 16:35:58','2024-12-04 16:35:58'),(2742,NULL,'DUMMY',2742,1,'2024-12-04 16:35:58','2024-12-04 16:35:58'),(2743,NULL,'DUMMY',2743,1,'2024-12-04 16:35:58','2024-12-04 16:35:58'),(2744,NULL,'DUMMY',2744,1,'2024-12-04 16:35:58','2024-12-04 16:35:58'),(2745,NULL,'DUMMY',2745,1,'2024-12-04 16:35:58','2024-12-04 16:35:58'),(2746,NULL,'DUMMY',2746,1,'2024-12-04 16:35:58','2024-12-04 16:35:58'),(2747,NULL,'DUMMY',2747,1,'2024-12-04 16:35:58','2024-12-04 16:35:58'),(2748,NULL,'DUMMY',2748,1,'2024-12-04 16:35:58','2024-12-04 16:35:58'),(2749,NULL,'DUMMY',2749,1,'2024-12-04 16:35:58','2024-12-04 16:35:58'),(2750,NULL,'DUMMY',2750,1,'2024-12-04 16:35:58','2024-12-04 16:35:58'),(2751,NULL,'DUMMY',2751,1,'2024-12-04 16:35:58','2024-12-04 16:35:58'),(2752,NULL,'DUMMY',2752,1,'2024-12-04 16:35:58','2024-12-04 16:35:58'),(2753,NULL,'DUMMY',2753,1,'2024-12-04 16:35:58','2024-12-04 16:35:58'),(2754,NULL,'DUMMY',2754,1,'2024-12-04 16:35:58','2024-12-04 16:35:58'),(2755,NULL,'DUMMY',2755,1,'2024-12-04 16:35:58','2024-12-04 16:35:58'),(2756,NULL,'DUMMY',2756,1,'2024-12-04 16:35:58','2024-12-04 16:35:58'),(2757,NULL,'DUMMY',2757,1,'2024-12-04 16:35:58','2024-12-04 16:35:58'),(2758,NULL,'DUMMY',2758,1,'2024-12-04 16:35:58','2024-12-04 16:35:58'),(2759,NULL,'DUMMY',2759,1,'2024-12-04 16:35:58','2024-12-04 16:35:58'),(2760,NULL,'DUMMY',2760,1,'2024-12-04 16:35:58','2024-12-04 16:35:58'),(2761,NULL,'DUMMY',2761,1,'2024-12-04 16:35:58','2024-12-04 16:35:58'),(2762,NULL,'DUMMY',2762,1,'2024-12-04 16:35:58','2024-12-04 16:35:58'),(2763,NULL,'DUMMY',2763,1,'2024-12-04 16:35:58','2024-12-04 16:35:58'),(2764,NULL,'DUMMY',2764,1,'2024-12-04 16:35:58','2024-12-04 16:35:58'),(2765,NULL,'DUMMY',2765,1,'2024-12-04 16:35:58','2024-12-04 16:35:58'),(2766,NULL,'DUMMY',2766,1,'2024-12-04 16:35:58','2024-12-04 16:35:58'),(2767,NULL,'DUMMY',2767,1,'2024-12-04 16:35:58','2024-12-04 16:35:58'),(2768,NULL,'DUMMY',2768,1,'2024-12-04 16:35:58','2024-12-04 16:35:58'),(2769,NULL,'DUMMY',2769,1,'2024-12-04 16:35:58','2024-12-04 16:35:58'),(2770,NULL,'DUMMY',2770,1,'2024-12-04 16:35:58','2024-12-04 16:35:58'),(2771,NULL,'DUMMY',2771,1,'2024-12-04 16:35:58','2024-12-04 16:35:58'),(2772,NULL,'DUMMY',2772,1,'2024-12-04 16:35:58','2024-12-04 16:35:58'),(2773,NULL,'DUMMY',2773,1,'2024-12-04 16:35:58','2024-12-04 16:35:58'),(2774,NULL,'DUMMY',2774,1,'2024-12-04 16:35:58','2024-12-04 16:35:58'),(2775,NULL,'DUMMY',2775,1,'2024-12-04 16:35:58','2024-12-04 16:35:58'),(2776,NULL,'DUMMY',2776,1,'2024-12-04 16:35:58','2024-12-04 16:35:58'),(2777,NULL,'DUMMY',2777,1,'2024-12-04 16:35:58','2024-12-04 16:35:58'),(2778,NULL,'DUMMY',2778,1,'2024-12-04 16:35:58','2024-12-04 16:35:58'),(2779,NULL,'DUMMY',2779,1,'2024-12-04 16:35:58','2024-12-04 16:35:58'),(2780,NULL,'DUMMY',2780,1,'2024-12-04 16:35:58','2024-12-04 16:35:58'),(2781,NULL,'DUMMY',2781,1,'2024-12-04 16:35:58','2024-12-04 16:35:58'),(2782,NULL,'DUMMY',2782,1,'2024-12-04 16:35:58','2024-12-04 16:35:58'),(2783,NULL,'DUMMY',2783,1,'2024-12-04 16:35:58','2024-12-04 16:35:58'),(2784,NULL,'DUMMY',2784,1,'2024-12-04 16:35:58','2024-12-04 16:35:58'),(2785,NULL,'DUMMY',2785,1,'2024-12-04 16:35:58','2024-12-04 16:35:58'),(2786,NULL,'DUMMY',2786,1,'2024-12-04 16:35:58','2024-12-04 16:35:58'),(2787,NULL,'DUMMY',2787,1,'2024-12-04 16:35:58','2024-12-04 16:35:58'),(2788,NULL,'DUMMY',2788,1,'2024-12-04 16:35:58','2024-12-04 16:35:58'),(2789,NULL,'DUMMY',2789,1,'2024-12-04 16:35:58','2024-12-04 16:35:58'),(2790,NULL,'DUMMY',2790,1,'2024-12-04 16:35:58','2024-12-04 16:35:58'),(2791,NULL,'DUMMY',2791,1,'2024-12-04 16:35:58','2024-12-04 16:35:58'),(2792,NULL,'DUMMY',2792,1,'2024-12-04 16:35:58','2024-12-04 16:35:58'),(2793,NULL,'DUMMY',2793,1,'2024-12-04 16:35:58','2024-12-04 16:35:58'),(2794,NULL,'DUMMY',2794,1,'2024-12-04 16:35:58','2024-12-04 16:35:58'),(2795,NULL,'DUMMY',2795,1,'2024-12-04 16:35:58','2024-12-04 16:35:58'),(2796,NULL,'DUMMY',2796,1,'2024-12-04 16:35:58','2024-12-04 16:35:58'),(2797,NULL,'DUMMY',2797,1,'2024-12-04 16:35:58','2024-12-04 16:35:58'),(2798,NULL,'DUMMY',2798,1,'2024-12-04 16:35:58','2024-12-04 16:35:58'),(2799,NULL,'DUMMY',2799,1,'2024-12-04 16:35:58','2024-12-04 16:35:58'),(2800,NULL,'DUMMY',2800,1,'2024-12-04 16:35:58','2024-12-04 16:35:58'),(2801,NULL,'DUMMY',2801,1,'2024-12-04 16:35:58','2024-12-04 16:35:58'),(2802,NULL,'DUMMY',2802,1,'2024-12-04 16:35:58','2024-12-04 16:35:58'),(2803,NULL,'DUMMY',2803,1,'2024-12-04 16:35:58','2024-12-04 16:35:58'),(2804,NULL,'DUMMY',2804,1,'2024-12-04 16:35:58','2024-12-04 16:35:58'),(2805,NULL,'DUMMY',2805,1,'2024-12-04 16:35:58','2024-12-04 16:35:58'),(2806,NULL,'DUMMY',2806,1,'2024-12-04 16:35:58','2024-12-04 16:35:58'),(2807,NULL,'DUMMY',2807,1,'2024-12-04 16:35:58','2024-12-04 16:35:58'),(2808,NULL,'DUMMY',2808,1,'2024-12-04 16:35:58','2024-12-04 16:35:58'),(2809,NULL,'DUMMY',2809,1,'2024-12-04 16:35:58','2024-12-04 16:35:58'),(2810,NULL,'DUMMY',2810,1,'2024-12-04 16:35:58','2024-12-04 16:35:58'),(2811,NULL,'DUMMY',2811,1,'2024-12-04 16:35:58','2024-12-04 16:35:58'),(2812,NULL,'DUMMY',2812,1,'2024-12-04 16:35:58','2024-12-04 16:35:58'),(2813,NULL,'DUMMY',2813,1,'2024-12-04 16:35:58','2024-12-04 16:35:58'),(2814,NULL,'DUMMY',2814,1,'2024-12-04 16:35:58','2024-12-04 16:35:58'),(2815,NULL,'DUMMY',2815,1,'2024-12-04 16:35:58','2024-12-04 16:35:58'),(2816,NULL,'DUMMY',2816,1,'2024-12-04 16:35:58','2024-12-04 16:35:58'),(2817,NULL,'DUMMY',2817,1,'2024-12-04 16:35:59','2024-12-04 16:35:59'),(2818,NULL,'DUMMY',2818,1,'2024-12-04 16:35:59','2024-12-04 16:35:59'),(2819,NULL,'DUMMY',2819,1,'2024-12-04 16:35:59','2024-12-04 16:35:59'),(2820,NULL,'DUMMY',2820,1,'2024-12-04 16:35:59','2024-12-04 16:35:59'),(2821,NULL,'DUMMY',2821,1,'2024-12-04 16:35:59','2024-12-04 16:35:59'),(2822,NULL,'DUMMY',2822,1,'2024-12-04 16:35:59','2024-12-04 16:35:59'),(2823,NULL,'DUMMY',2823,1,'2024-12-04 16:35:59','2024-12-04 16:35:59'),(2824,NULL,'DUMMY',2824,1,'2024-12-04 16:35:59','2024-12-04 16:35:59'),(2825,NULL,'DUMMY',2825,1,'2024-12-04 16:35:59','2024-12-04 16:35:59'),(2826,NULL,'DUMMY',2826,1,'2024-12-04 16:35:59','2024-12-04 16:35:59'),(2827,NULL,'DUMMY',2827,1,'2024-12-04 16:35:59','2024-12-04 16:35:59'),(2828,NULL,'DUMMY',2828,1,'2024-12-04 16:35:59','2024-12-04 16:35:59'),(2829,NULL,'DUMMY',2829,1,'2024-12-04 16:35:59','2024-12-04 16:35:59'),(2830,NULL,'DUMMY',2830,1,'2024-12-04 16:35:59','2024-12-04 16:35:59'),(2831,NULL,'DUMMY',2831,1,'2024-12-04 16:35:59','2024-12-04 16:35:59'),(2832,NULL,'DUMMY',2832,1,'2024-12-04 16:35:59','2024-12-04 16:35:59'),(2833,NULL,'DUMMY',2833,1,'2024-12-04 16:35:59','2024-12-04 16:35:59'),(2834,NULL,'DUMMY',2834,1,'2024-12-04 16:35:59','2024-12-04 16:35:59'),(2835,NULL,'DUMMY',2835,1,'2024-12-04 16:35:59','2024-12-04 16:35:59'),(2836,NULL,'DUMMY',2836,1,'2024-12-04 16:35:59','2024-12-04 16:35:59'),(2837,NULL,'DUMMY',2837,1,'2024-12-04 16:35:59','2024-12-04 16:35:59'),(2838,NULL,'DUMMY',2838,1,'2024-12-04 16:35:59','2024-12-04 16:35:59'),(2839,NULL,'DUMMY',2839,1,'2024-12-04 16:35:59','2024-12-04 16:35:59'),(2840,NULL,'DUMMY',2840,1,'2024-12-04 16:35:59','2024-12-04 16:35:59'),(2841,NULL,'DUMMY',2841,1,'2024-12-04 16:35:59','2024-12-04 16:35:59'),(2842,NULL,'DUMMY',2842,1,'2024-12-04 16:35:59','2024-12-04 16:35:59'),(2843,NULL,'DUMMY',2843,1,'2024-12-04 16:35:59','2024-12-04 16:35:59'),(2844,NULL,'DUMMY',2844,1,'2024-12-04 16:35:59','2024-12-04 16:35:59'),(2845,NULL,'DUMMY',2845,1,'2024-12-04 16:35:59','2024-12-04 16:35:59'),(2846,NULL,'DUMMY',2846,1,'2024-12-04 16:35:59','2024-12-04 16:35:59'),(2847,NULL,'DUMMY',2847,1,'2024-12-04 16:35:59','2024-12-04 16:35:59'),(2848,NULL,'DUMMY',2848,1,'2024-12-04 16:35:59','2024-12-04 16:35:59'),(2849,NULL,'DUMMY',2849,1,'2024-12-04 16:35:59','2024-12-04 16:35:59'),(2850,NULL,'DUMMY',2850,1,'2024-12-04 16:35:59','2024-12-04 16:35:59'),(2851,NULL,'DUMMY',2851,1,'2024-12-04 16:35:59','2024-12-04 16:35:59'),(2852,NULL,'DUMMY',2852,1,'2024-12-04 16:35:59','2024-12-04 16:35:59'),(2853,NULL,'DUMMY',2853,1,'2024-12-04 16:35:59','2024-12-04 16:35:59'),(2854,NULL,'DUMMY',2854,1,'2024-12-04 16:35:59','2024-12-04 16:35:59'),(2855,NULL,'DUMMY',2855,1,'2024-12-04 16:35:59','2024-12-04 16:35:59'),(2856,NULL,'DUMMY',2856,1,'2024-12-04 16:35:59','2024-12-04 16:35:59'),(2857,NULL,'DUMMY',2857,1,'2024-12-04 16:35:59','2024-12-04 16:35:59'),(2858,NULL,'DUMMY',2858,1,'2024-12-04 16:35:59','2024-12-04 16:35:59'),(2859,NULL,'DUMMY',2859,1,'2024-12-04 16:35:59','2024-12-04 16:35:59'),(2860,NULL,'DUMMY',2860,1,'2024-12-04 16:35:59','2024-12-04 16:35:59'),(2861,NULL,'DUMMY',2861,1,'2024-12-04 16:35:59','2024-12-04 16:35:59'),(2862,NULL,'DUMMY',2862,1,'2024-12-04 16:35:59','2024-12-04 16:35:59'),(2863,NULL,'DUMMY',2863,1,'2024-12-04 16:35:59','2024-12-04 16:35:59'),(2864,NULL,'DUMMY',2864,1,'2024-12-04 16:35:59','2024-12-04 16:35:59'),(2865,NULL,'DUMMY',2865,1,'2024-12-04 16:35:59','2024-12-04 16:35:59'),(2866,NULL,'DUMMY',2866,1,'2024-12-04 16:35:59','2024-12-04 16:35:59'),(2867,NULL,'DUMMY',2867,1,'2024-12-04 16:35:59','2024-12-04 16:35:59'),(2868,NULL,'DUMMY',2868,1,'2024-12-04 16:35:59','2024-12-04 16:35:59'),(2869,NULL,'DUMMY',2869,1,'2024-12-04 16:35:59','2024-12-04 16:35:59'),(2870,NULL,'DUMMY',2870,1,'2024-12-04 16:35:59','2024-12-04 16:35:59'),(2871,NULL,'DUMMY',2871,1,'2024-12-04 16:35:59','2024-12-04 16:35:59'),(2872,NULL,'DUMMY',2872,1,'2024-12-04 16:35:59','2024-12-04 16:35:59'),(2873,NULL,'DUMMY',2873,1,'2024-12-04 16:35:59','2024-12-04 16:35:59'),(2874,NULL,'DUMMY',2874,1,'2024-12-04 16:35:59','2024-12-04 16:35:59'),(2875,NULL,'DUMMY',2875,1,'2024-12-04 16:35:59','2024-12-04 16:35:59'),(2876,NULL,'DUMMY',2876,1,'2024-12-04 16:35:59','2024-12-04 16:35:59'),(2877,NULL,'DUMMY',2877,1,'2024-12-04 16:35:59','2024-12-04 16:35:59'),(2878,NULL,'DUMMY',2878,1,'2024-12-04 16:35:59','2024-12-04 16:35:59'),(2879,NULL,'DUMMY',2879,1,'2024-12-04 16:35:59','2024-12-04 16:35:59'),(2880,NULL,'DUMMY',2880,1,'2024-12-04 16:35:59','2024-12-04 16:35:59'),(2881,NULL,'DUMMY',2881,1,'2024-12-04 16:35:59','2024-12-04 16:35:59'),(2882,NULL,'DUMMY',2882,1,'2024-12-04 16:35:59','2024-12-04 16:35:59'),(2883,NULL,'DUMMY',2883,1,'2024-12-04 16:35:59','2024-12-04 16:35:59'),(2884,NULL,'DUMMY',2884,1,'2024-12-04 16:35:59','2024-12-04 16:35:59'),(2885,NULL,'DUMMY',2885,1,'2024-12-04 16:35:59','2024-12-04 16:35:59'),(2886,NULL,'DUMMY',2886,1,'2024-12-04 16:35:59','2024-12-04 16:35:59'),(2887,NULL,'DUMMY',2887,1,'2024-12-04 16:35:59','2024-12-04 16:35:59'),(2888,NULL,'DUMMY',2888,1,'2024-12-04 16:35:59','2024-12-04 16:35:59'),(2889,NULL,'DUMMY',2889,1,'2024-12-04 16:36:00','2024-12-04 16:36:00'),(2890,NULL,'DUMMY',2890,1,'2024-12-04 16:36:00','2024-12-04 16:36:00'),(2891,NULL,'DUMMY',2891,1,'2024-12-04 16:36:00','2024-12-04 16:36:00'),(2892,NULL,'DUMMY',2892,1,'2024-12-04 16:36:00','2024-12-04 16:36:00'),(2893,NULL,'DUMMY',2893,1,'2024-12-04 16:36:00','2024-12-04 16:36:00'),(2894,NULL,'DUMMY',2894,1,'2024-12-04 16:36:00','2024-12-04 16:36:00'),(2895,NULL,'DUMMY',2895,1,'2024-12-04 16:36:00','2024-12-04 16:36:00'),(2896,NULL,'DUMMY',2896,1,'2024-12-04 16:36:00','2024-12-04 16:36:00'),(2897,NULL,'DUMMY',2897,1,'2024-12-04 16:36:00','2024-12-04 16:36:00'),(2898,NULL,'DUMMY',2898,1,'2024-12-04 16:36:00','2024-12-04 16:36:00'),(2899,NULL,'DUMMY',2899,1,'2024-12-04 16:36:00','2024-12-04 16:36:00'),(2900,NULL,'DUMMY',2900,1,'2024-12-04 16:36:00','2024-12-04 16:36:00'),(2901,NULL,'DUMMY',2901,1,'2024-12-04 16:36:00','2024-12-04 16:36:00'),(2902,NULL,'DUMMY',2902,1,'2024-12-04 16:36:00','2024-12-04 16:36:00'),(2903,NULL,'DUMMY',2903,1,'2024-12-04 16:36:00','2024-12-04 16:36:00'),(2904,NULL,'DUMMY',2904,1,'2024-12-04 16:36:00','2024-12-04 16:36:00'),(2905,NULL,'DUMMY',2905,1,'2024-12-04 16:36:00','2024-12-04 16:36:00'),(2906,NULL,'DUMMY',2906,1,'2024-12-04 16:36:00','2024-12-04 16:36:00'),(2907,NULL,'DUMMY',2907,1,'2024-12-04 16:36:00','2024-12-04 16:36:00'),(2908,NULL,'DUMMY',2908,1,'2024-12-04 16:36:00','2024-12-04 16:36:00'),(2909,NULL,'DUMMY',2909,1,'2024-12-04 16:36:00','2024-12-04 16:36:00'),(2910,NULL,'DUMMY',2910,1,'2024-12-04 16:36:00','2024-12-04 16:36:00'),(2911,NULL,'DUMMY',2911,1,'2024-12-04 16:36:00','2024-12-04 16:36:00'),(2912,NULL,'DUMMY',2912,1,'2024-12-04 16:36:00','2024-12-04 16:36:00'),(2913,NULL,'DUMMY',2913,1,'2024-12-04 16:36:00','2024-12-04 16:36:00'),(2914,NULL,'DUMMY',2914,1,'2024-12-04 16:36:00','2024-12-04 16:36:00'),(2915,NULL,'DUMMY',2915,1,'2024-12-04 16:36:00','2024-12-04 16:36:00'),(2916,NULL,'DUMMY',2916,1,'2024-12-04 16:36:00','2024-12-04 16:36:00'),(2917,NULL,'DUMMY',2917,1,'2024-12-04 16:36:00','2024-12-04 16:36:00'),(2918,NULL,'DUMMY',2918,1,'2024-12-04 16:36:00','2024-12-04 16:36:00'),(2919,NULL,'DUMMY',2919,1,'2024-12-04 16:36:00','2024-12-04 16:36:00'),(2920,NULL,'DUMMY',2920,1,'2024-12-04 16:36:00','2024-12-04 16:36:00'),(2921,NULL,'DUMMY',2921,1,'2024-12-04 16:36:00','2024-12-04 16:36:00'),(2922,NULL,'DUMMY',2922,1,'2024-12-04 16:36:00','2024-12-04 16:36:00'),(2923,NULL,'DUMMY',2923,1,'2024-12-04 16:36:00','2024-12-04 16:36:00'),(2924,NULL,'DUMMY',2924,1,'2024-12-04 16:36:00','2024-12-04 16:36:00'),(2925,NULL,'DUMMY',2925,1,'2024-12-04 16:36:00','2024-12-04 16:36:00'),(2926,NULL,'DUMMY',2926,1,'2024-12-04 16:36:00','2024-12-04 16:36:00'),(2927,NULL,'DUMMY',2927,1,'2024-12-04 16:36:00','2024-12-04 16:36:00'),(2928,NULL,'DUMMY',2928,1,'2024-12-04 16:36:00','2024-12-04 16:36:00'),(2929,NULL,'DUMMY',2929,1,'2024-12-04 16:36:00','2024-12-04 16:36:00'),(2930,NULL,'DUMMY',2930,1,'2024-12-04 16:36:00','2024-12-04 16:36:00'),(2931,NULL,'DUMMY',2931,1,'2024-12-04 16:36:00','2024-12-04 16:36:00'),(2932,NULL,'DUMMY',2932,1,'2024-12-04 16:36:00','2024-12-04 16:36:00'),(2933,NULL,'DUMMY',2933,1,'2024-12-04 16:36:00','2024-12-04 16:36:00'),(2934,NULL,'DUMMY',2934,1,'2024-12-04 16:36:00','2024-12-04 16:36:00'),(2935,NULL,'DUMMY',2935,1,'2024-12-04 16:36:00','2024-12-04 16:36:00'),(2936,NULL,'DUMMY',2936,1,'2024-12-04 16:36:00','2024-12-04 16:36:00'),(2937,NULL,'DUMMY',2937,1,'2024-12-04 16:36:00','2024-12-04 16:36:00'),(2938,NULL,'DUMMY',2938,1,'2024-12-04 16:36:00','2024-12-04 16:36:00'),(2939,NULL,'DUMMY',2939,1,'2024-12-04 16:36:00','2024-12-04 16:36:00'),(2940,NULL,'DUMMY',2940,1,'2024-12-04 16:36:00','2024-12-04 16:36:00'),(2941,NULL,'DUMMY',2941,1,'2024-12-04 16:36:00','2024-12-04 16:36:00'),(2942,NULL,'DUMMY',2942,1,'2024-12-04 16:36:00','2024-12-04 16:36:00'),(2943,NULL,'DUMMY',2943,1,'2024-12-04 16:36:00','2024-12-04 16:36:00'),(2944,NULL,'DUMMY',2944,1,'2024-12-04 16:36:00','2024-12-04 16:36:00'),(2945,NULL,'DUMMY',2945,1,'2024-12-04 16:36:00','2024-12-04 16:36:00'),(2946,NULL,'DUMMY',2946,1,'2024-12-04 16:36:00','2024-12-04 16:36:00'),(2947,NULL,'DUMMY',2947,1,'2024-12-04 16:36:00','2024-12-04 16:36:00'),(2948,NULL,'DUMMY',2948,1,'2024-12-04 16:36:00','2024-12-04 16:36:00'),(2949,NULL,'DUMMY',2949,1,'2024-12-04 16:36:00','2024-12-04 16:36:00'),(2950,NULL,'DUMMY',2950,1,'2024-12-04 16:36:00','2024-12-04 16:36:00'),(2951,NULL,'DUMMY',2951,1,'2024-12-04 16:36:00','2024-12-04 16:36:00'),(2952,NULL,'DUMMY',2952,1,'2024-12-04 16:36:00','2024-12-04 16:36:00'),(2953,NULL,'DUMMY',2953,1,'2024-12-04 16:36:00','2024-12-04 16:36:00'),(2954,NULL,'DUMMY',2954,1,'2024-12-04 16:36:00','2024-12-04 16:36:00'),(2955,NULL,'DUMMY',2955,1,'2024-12-04 16:36:00','2024-12-04 16:36:00'),(2956,NULL,'DUMMY',2956,1,'2024-12-04 16:36:00','2024-12-04 16:36:00'),(2957,NULL,'DUMMY',2957,1,'2024-12-04 16:36:00','2024-12-04 16:36:00'),(2958,NULL,'DUMMY',2958,1,'2024-12-04 16:36:00','2024-12-04 16:36:00'),(2959,NULL,'DUMMY',2959,1,'2024-12-04 16:36:01','2024-12-04 16:36:01'),(2960,NULL,'DUMMY',2960,1,'2024-12-04 16:36:01','2024-12-04 16:36:01'),(2961,NULL,'DUMMY',2961,1,'2024-12-04 16:36:01','2024-12-04 16:36:01'),(2962,NULL,'DUMMY',2962,1,'2024-12-04 16:36:01','2024-12-04 16:36:01'),(2963,NULL,'DUMMY',2963,1,'2024-12-04 16:36:01','2024-12-04 16:36:01'),(2964,NULL,'DUMMY',2964,1,'2024-12-04 16:36:01','2024-12-04 16:36:01'),(2965,NULL,'DUMMY',2965,1,'2024-12-04 16:36:01','2024-12-04 16:36:01'),(2966,NULL,'DUMMY',2966,1,'2024-12-04 16:36:01','2024-12-04 16:36:01'),(2967,NULL,'DUMMY',2967,1,'2024-12-04 16:36:01','2024-12-04 16:36:01'),(2968,NULL,'DUMMY',2968,1,'2024-12-04 16:36:01','2024-12-04 16:36:01'),(2969,NULL,'DUMMY',2969,1,'2024-12-04 16:36:01','2024-12-04 16:36:01'),(2970,NULL,'DUMMY',2970,1,'2024-12-04 16:36:01','2024-12-04 16:36:01'),(2971,NULL,'DUMMY',2971,1,'2024-12-04 16:36:01','2024-12-04 16:36:01'),(2972,NULL,'DUMMY',2972,1,'2024-12-04 16:36:01','2024-12-04 16:36:01'),(2973,NULL,'DUMMY',2973,1,'2024-12-04 16:36:01','2024-12-04 16:36:01'),(2974,NULL,'DUMMY',2974,1,'2024-12-04 16:36:01','2024-12-04 16:36:01'),(2975,NULL,'DUMMY',2975,1,'2024-12-04 16:36:01','2024-12-04 16:36:01'),(2976,NULL,'DUMMY',2976,1,'2024-12-04 16:36:01','2024-12-04 16:36:01'),(2977,NULL,'DUMMY',2977,1,'2024-12-04 16:36:01','2024-12-04 16:36:01'),(2978,NULL,'DUMMY',2978,1,'2024-12-04 16:36:01','2024-12-04 16:36:01'),(2979,NULL,'DUMMY',2979,1,'2024-12-04 16:36:01','2024-12-04 16:36:01'),(2980,NULL,'DUMMY',2980,1,'2024-12-04 16:36:01','2024-12-04 16:36:01'),(2981,NULL,'DUMMY',2981,1,'2024-12-04 16:36:01','2024-12-04 16:36:01'),(2982,NULL,'DUMMY',2982,1,'2024-12-04 16:36:01','2024-12-04 16:36:01'),(2983,NULL,'DUMMY',2983,1,'2024-12-04 16:36:01','2024-12-04 16:36:01'),(2984,NULL,'DUMMY',2984,1,'2024-12-04 16:36:01','2024-12-04 16:36:01'),(2985,NULL,'DUMMY',2985,1,'2024-12-04 16:36:01','2024-12-04 16:36:01'),(2986,NULL,'DUMMY',2986,1,'2024-12-04 16:36:01','2024-12-04 16:36:01'),(2987,NULL,'DUMMY',2987,1,'2024-12-04 16:36:01','2024-12-04 16:36:01'),(2988,NULL,'DUMMY',2988,1,'2024-12-04 16:36:01','2024-12-04 16:36:01'),(2989,NULL,'DUMMY',2989,1,'2024-12-04 16:36:01','2024-12-04 16:36:01'),(2990,NULL,'DUMMY',2990,1,'2024-12-04 16:36:01','2024-12-04 16:36:01'),(2991,NULL,'DUMMY',2991,1,'2024-12-04 16:36:01','2024-12-04 16:36:01'),(2992,NULL,'DUMMY',2992,1,'2024-12-04 16:36:01','2024-12-04 16:36:01'),(2993,NULL,'DUMMY',2993,1,'2024-12-04 16:36:01','2024-12-04 16:36:01'),(2994,NULL,'DUMMY',2994,1,'2024-12-04 16:36:01','2024-12-04 16:36:01'),(2995,NULL,'DUMMY',2995,1,'2024-12-04 16:36:01','2024-12-04 16:36:01'),(2996,NULL,'DUMMY',2996,1,'2024-12-04 16:36:01','2024-12-04 16:36:01'),(2997,NULL,'DUMMY',2997,1,'2024-12-04 16:36:01','2024-12-04 16:36:01'),(2998,NULL,'DUMMY',2998,1,'2024-12-04 16:36:01','2024-12-04 16:36:01'),(2999,NULL,'DUMMY',2999,1,'2024-12-04 16:36:01','2024-12-04 16:36:01'),(3000,NULL,'DUMMY',3000,1,'2024-12-04 16:36:01','2024-12-04 16:36:01'),(3001,NULL,'DUMMY',3001,1,'2024-12-04 16:36:01','2024-12-04 16:36:01'),(3002,NULL,'DUMMY',3002,1,'2024-12-04 16:36:01','2024-12-04 16:36:01'),(3003,NULL,'DUMMY',3003,1,'2024-12-04 16:36:01','2024-12-04 16:36:01'),(3004,NULL,'DUMMY',3004,1,'2024-12-04 16:36:01','2024-12-04 16:36:01'),(3005,NULL,'DUMMY',3005,1,'2024-12-04 16:36:01','2024-12-04 16:36:01'),(3006,NULL,'DUMMY',3006,1,'2024-12-04 16:36:01','2024-12-04 16:36:01'),(3007,NULL,'DUMMY',3007,1,'2024-12-04 16:36:01','2024-12-04 16:36:01'),(3008,NULL,'DUMMY',3008,1,'2024-12-04 16:36:01','2024-12-04 16:36:01'),(3009,NULL,'DUMMY',3009,1,'2024-12-04 16:36:01','2024-12-04 16:36:01'),(3010,NULL,'DUMMY',3010,1,'2024-12-04 16:36:01','2024-12-04 16:36:01'),(3011,NULL,'DUMMY',3011,1,'2024-12-04 16:36:01','2024-12-04 16:36:01'),(3012,NULL,'DUMMY',3012,1,'2024-12-04 16:36:01','2024-12-04 16:36:01'),(3013,NULL,'DUMMY',3013,1,'2024-12-04 16:36:01','2024-12-04 16:36:01'),(3014,NULL,'DUMMY',3014,1,'2024-12-04 16:36:01','2024-12-04 16:36:01'),(3015,NULL,'DUMMY',3015,1,'2024-12-04 16:36:01','2024-12-04 16:36:01'),(3016,NULL,'DUMMY',3016,1,'2024-12-04 16:36:01','2024-12-04 16:36:01'),(3017,NULL,'DUMMY',3017,1,'2024-12-04 16:36:01','2024-12-04 16:36:01'),(3018,NULL,'DUMMY',3018,1,'2024-12-04 16:36:01','2024-12-04 16:36:01'),(3019,NULL,'DUMMY',3019,1,'2024-12-04 16:36:01','2024-12-04 16:36:01'),(3020,NULL,'DUMMY',3020,1,'2024-12-04 16:36:01','2024-12-04 16:36:01'),(3021,NULL,'DUMMY',3021,1,'2024-12-04 16:36:01','2024-12-04 16:36:01'),(3022,NULL,'DUMMY',3022,1,'2024-12-04 16:36:01','2024-12-04 16:36:01'),(3023,NULL,'DUMMY',3023,1,'2024-12-04 16:36:01','2024-12-04 16:36:01'),(3024,NULL,'DUMMY',3024,1,'2024-12-04 16:36:01','2024-12-04 16:36:01'),(3025,NULL,'DUMMY',3025,1,'2024-12-04 16:36:01','2024-12-04 16:36:01'),(3026,NULL,'DUMMY',3026,1,'2024-12-04 16:36:01','2024-12-04 16:36:01'),(3027,NULL,'DUMMY',3027,1,'2024-12-04 16:36:01','2024-12-04 16:36:01'),(3028,NULL,'DUMMY',3028,1,'2024-12-04 16:36:01','2024-12-04 16:36:01'),(3029,NULL,'DUMMY',3029,1,'2024-12-04 16:36:01','2024-12-04 16:36:01'),(3030,NULL,'DUMMY',3030,1,'2024-12-04 16:36:01','2024-12-04 16:36:01'),(3031,NULL,'DUMMY',3031,1,'2024-12-04 16:36:01','2024-12-04 16:36:01'),(3032,NULL,'DUMMY',3032,1,'2024-12-04 16:36:01','2024-12-04 16:36:01'),(3033,NULL,'DUMMY',3033,1,'2024-12-04 16:36:01','2024-12-04 16:36:01'),(3034,NULL,'DUMMY',3034,1,'2024-12-04 16:36:01','2024-12-04 16:36:01'),(3035,NULL,'DUMMY',3035,1,'2024-12-04 16:36:01','2024-12-04 16:36:01'),(3036,NULL,'DUMMY',3036,1,'2024-12-04 16:36:01','2024-12-04 16:36:01'),(3037,NULL,'DUMMY',3037,1,'2024-12-04 16:36:01','2024-12-04 16:36:01'),(3038,NULL,'DUMMY',3038,1,'2024-12-04 16:36:01','2024-12-04 16:36:01'),(3039,NULL,'DUMMY',3039,1,'2024-12-04 16:36:01','2024-12-04 16:36:01'),(3040,NULL,'DUMMY',3040,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3041,NULL,'DUMMY',3041,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3042,NULL,'DUMMY',3042,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3043,NULL,'DUMMY',3043,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3044,NULL,'DUMMY',3044,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3045,NULL,'DUMMY',3045,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3046,NULL,'DUMMY',3046,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3047,NULL,'DUMMY',3047,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3048,NULL,'DUMMY',3048,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3049,NULL,'DUMMY',3049,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3050,NULL,'DUMMY',3050,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3051,NULL,'DUMMY',3051,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3052,NULL,'DUMMY',3052,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3053,NULL,'DUMMY',3053,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3054,NULL,'DUMMY',3054,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3055,NULL,'DUMMY',3055,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3056,NULL,'DUMMY',3056,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3057,NULL,'DUMMY',3057,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3058,NULL,'DUMMY',3058,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3059,NULL,'DUMMY',3059,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3060,NULL,'DUMMY',3060,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3061,NULL,'DUMMY',3061,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3062,NULL,'DUMMY',3062,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3063,NULL,'DUMMY',3063,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3064,NULL,'DUMMY',3064,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3065,NULL,'DUMMY',3065,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3066,NULL,'DUMMY',3066,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3067,NULL,'DUMMY',3067,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3068,NULL,'DUMMY',3068,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3069,NULL,'DUMMY',3069,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3070,NULL,'DUMMY',3070,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3071,NULL,'DUMMY',3071,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3072,NULL,'DUMMY',3072,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3073,NULL,'DUMMY',3073,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3074,NULL,'DUMMY',3074,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3075,NULL,'DUMMY',3075,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3076,NULL,'DUMMY',3076,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3077,NULL,'DUMMY',3077,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3078,NULL,'DUMMY',3078,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3079,NULL,'DUMMY',3079,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3080,NULL,'DUMMY',3080,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3081,NULL,'DUMMY',3081,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3082,NULL,'DUMMY',3082,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3083,NULL,'DUMMY',3083,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3084,NULL,'DUMMY',3084,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3085,NULL,'DUMMY',3085,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3086,NULL,'DUMMY',3086,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3087,NULL,'DUMMY',3087,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3088,NULL,'DUMMY',3088,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3089,NULL,'DUMMY',3089,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3090,NULL,'DUMMY',3090,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3091,NULL,'DUMMY',3091,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3092,NULL,'DUMMY',3092,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3093,NULL,'DUMMY',3093,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3094,NULL,'DUMMY',3094,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3095,NULL,'DUMMY',3095,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3096,NULL,'DUMMY',3096,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3097,NULL,'DUMMY',3097,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3098,NULL,'DUMMY',3098,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3099,NULL,'DUMMY',3099,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3100,NULL,'DUMMY',3100,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3101,NULL,'DUMMY',3101,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3102,NULL,'DUMMY',3102,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3103,NULL,'DUMMY',3103,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3104,NULL,'DUMMY',3104,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3105,NULL,'DUMMY',3105,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3106,NULL,'DUMMY',3106,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3107,NULL,'DUMMY',3107,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3108,NULL,'DUMMY',3108,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3109,NULL,'DUMMY',3109,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3110,NULL,'DUMMY',3110,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3111,NULL,'DUMMY',3111,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3112,NULL,'DUMMY',3112,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3113,NULL,'DUMMY',3113,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3114,NULL,'DUMMY',3114,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3115,NULL,'DUMMY',3115,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3116,NULL,'DUMMY',3116,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3117,NULL,'DUMMY',3117,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3118,NULL,'DUMMY',3118,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3119,NULL,'DUMMY',3119,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3120,NULL,'DUMMY',3120,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3121,NULL,'DUMMY',3121,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3122,NULL,'DUMMY',3122,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3123,NULL,'DUMMY',3123,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3124,NULL,'DUMMY',3124,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3125,NULL,'DUMMY',3125,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3126,NULL,'DUMMY',3126,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3127,NULL,'DUMMY',3127,1,'2024-12-04 16:36:02','2024-12-04 16:36:02'),(3128,NULL,'DUMMY',3128,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3129,NULL,'DUMMY',3129,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3130,NULL,'DUMMY',3130,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3131,NULL,'DUMMY',3131,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3132,NULL,'DUMMY',3132,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3133,NULL,'DUMMY',3133,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3134,NULL,'DUMMY',3134,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3135,NULL,'DUMMY',3135,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3136,NULL,'DUMMY',3136,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3137,NULL,'DUMMY',3137,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3138,NULL,'DUMMY',3138,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3139,NULL,'DUMMY',3139,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3140,NULL,'DUMMY',3140,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3141,NULL,'DUMMY',3141,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3142,NULL,'DUMMY',3142,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3143,NULL,'DUMMY',3143,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3144,NULL,'DUMMY',3144,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3145,NULL,'DUMMY',3145,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3146,NULL,'DUMMY',3146,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3147,NULL,'DUMMY',3147,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3148,NULL,'DUMMY',3148,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3149,NULL,'DUMMY',3149,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3150,NULL,'DUMMY',3150,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3151,NULL,'DUMMY',3151,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3152,NULL,'DUMMY',3152,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3153,NULL,'DUMMY',3153,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3154,NULL,'DUMMY',3154,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3155,NULL,'DUMMY',3155,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3156,NULL,'DUMMY',3156,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3157,NULL,'DUMMY',3157,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3158,NULL,'DUMMY',3158,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3159,NULL,'DUMMY',3159,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3160,NULL,'DUMMY',3160,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3161,NULL,'DUMMY',3161,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3162,NULL,'DUMMY',3162,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3163,NULL,'DUMMY',3163,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3164,NULL,'DUMMY',3164,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3165,NULL,'DUMMY',3165,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3166,NULL,'DUMMY',3166,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3167,NULL,'DUMMY',3167,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3168,NULL,'DUMMY',3168,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3169,NULL,'DUMMY',3169,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3170,NULL,'DUMMY',3170,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3171,NULL,'DUMMY',3171,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3172,NULL,'DUMMY',3172,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3173,NULL,'DUMMY',3173,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3174,NULL,'DUMMY',3174,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3175,NULL,'DUMMY',3175,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3176,NULL,'DUMMY',3176,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3177,NULL,'DUMMY',3177,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3178,NULL,'DUMMY',3178,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3179,NULL,'DUMMY',3179,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3180,NULL,'DUMMY',3180,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3181,NULL,'DUMMY',3181,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3182,NULL,'DUMMY',3182,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3183,NULL,'DUMMY',3183,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3184,NULL,'DUMMY',3184,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3185,NULL,'DUMMY',3185,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3186,NULL,'DUMMY',3186,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3187,NULL,'DUMMY',3187,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3188,NULL,'DUMMY',3188,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3189,NULL,'DUMMY',3189,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3190,NULL,'DUMMY',3190,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3191,NULL,'DUMMY',3191,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3192,NULL,'DUMMY',3192,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3193,NULL,'DUMMY',3193,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3194,NULL,'DUMMY',3194,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3195,NULL,'DUMMY',3195,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3196,NULL,'DUMMY',3196,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3197,NULL,'DUMMY',3197,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3198,NULL,'DUMMY',3198,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3199,NULL,'DUMMY',3199,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3200,NULL,'DUMMY',3200,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3201,NULL,'DUMMY',3201,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3202,NULL,'DUMMY',3202,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3203,NULL,'DUMMY',3203,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3204,NULL,'DUMMY',3204,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3205,NULL,'DUMMY',3205,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3206,NULL,'DUMMY',3206,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3207,NULL,'DUMMY',3207,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3208,NULL,'DUMMY',3208,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3209,NULL,'DUMMY',3209,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3210,NULL,'DUMMY',3210,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3211,NULL,'DUMMY',3211,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3212,NULL,'DUMMY',3212,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3213,NULL,'DUMMY',3213,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3214,NULL,'DUMMY',3214,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3215,NULL,'DUMMY',3215,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3216,NULL,'DUMMY',3216,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3217,NULL,'DUMMY',3217,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3218,NULL,'DUMMY',3218,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3219,NULL,'DUMMY',3219,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3220,NULL,'DUMMY',3220,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3221,NULL,'DUMMY',3221,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3222,NULL,'DUMMY',3222,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3223,NULL,'DUMMY',3223,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3224,NULL,'DUMMY',3224,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3225,NULL,'DUMMY',3225,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3226,NULL,'DUMMY',3226,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3227,NULL,'DUMMY',3227,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3228,NULL,'DUMMY',3228,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3229,NULL,'DUMMY',3229,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3230,NULL,'DUMMY',3230,1,'2024-12-04 16:36:03','2024-12-04 16:36:03'),(3231,NULL,'DUMMY',3231,1,'2024-12-04 16:36:04','2024-12-04 16:36:04'),(3232,NULL,'DUMMY',3232,1,'2024-12-04 16:36:04','2024-12-04 16:36:04'),(3233,NULL,'DUMMY',3233,1,'2024-12-04 16:36:04','2024-12-04 16:36:04'),(3234,NULL,'DUMMY',3234,1,'2024-12-04 16:36:04','2024-12-04 16:36:04'),(3235,NULL,'DUMMY',3235,1,'2024-12-04 16:36:04','2024-12-04 16:36:04'),(3236,NULL,'DUMMY',3236,1,'2024-12-04 16:36:04','2024-12-04 16:36:04'),(3237,NULL,'DUMMY',3237,1,'2024-12-04 16:49:31','2024-12-04 16:49:31'),(3238,NULL,'DUMMY',3238,1,'2024-12-04 16:49:31','2024-12-04 16:49:31'),(3239,NULL,'DUMMY',3239,1,'2024-12-04 16:49:31','2024-12-04 16:49:31'),(3240,NULL,'DUMMY',3240,1,'2024-12-04 16:49:31','2024-12-04 16:49:31'),(3241,NULL,'DUMMY',3241,1,'2024-12-04 16:49:31','2024-12-04 16:49:31'),(3242,NULL,'DUMMY',3242,1,'2024-12-04 16:49:31','2024-12-04 16:49:31'),(3243,NULL,'DUMMY',3243,1,'2024-12-04 16:49:31','2024-12-04 16:49:31'),(3244,NULL,'DUMMY',3244,1,'2024-12-04 16:49:31','2024-12-04 16:49:31'),(3245,NULL,'DUMMY',3245,1,'2024-12-04 16:49:31','2024-12-04 16:49:31'),(3246,NULL,'DUMMY',3246,1,'2024-12-04 16:49:31','2024-12-04 16:49:31'),(3247,NULL,'DUMMY',3247,1,'2024-12-04 16:49:31','2024-12-04 16:49:31'),(3248,NULL,'DUMMY',3248,1,'2024-12-04 16:49:31','2024-12-04 16:49:31'),(3249,NULL,'DUMMY',3249,1,'2024-12-04 16:49:31','2024-12-04 16:49:31'),(3250,NULL,'DUMMY',3250,1,'2024-12-04 16:49:31','2024-12-04 16:49:31'),(3251,NULL,'DUMMY',3251,1,'2024-12-04 16:49:31','2024-12-04 16:49:31'),(3252,NULL,'DUMMY',3252,1,'2024-12-04 16:49:31','2024-12-04 16:49:31'),(3253,NULL,'DUMMY',3253,1,'2024-12-04 16:49:31','2024-12-04 16:49:31'),(3254,NULL,'DUMMY',3254,1,'2024-12-04 16:49:31','2024-12-04 16:49:31'),(3255,NULL,'DUMMY',3255,1,'2024-12-04 16:49:31','2024-12-04 16:49:31'),(3256,NULL,'DUMMY',3256,1,'2024-12-04 16:49:31','2024-12-04 16:49:31'),(3257,NULL,'DUMMY',3257,1,'2024-12-04 16:49:32','2024-12-04 16:49:32'),(3258,NULL,'DUMMY',3258,1,'2024-12-04 16:49:32','2024-12-04 16:49:32'),(3259,NULL,'DUMMY',3259,1,'2024-12-04 16:49:32','2024-12-04 16:49:32'),(3260,NULL,'DUMMY',3260,1,'2024-12-04 16:49:32','2024-12-04 16:49:32'),(3261,NULL,'DUMMY',3261,1,'2024-12-04 16:49:32','2024-12-04 16:49:32'),(3262,NULL,'DUMMY',3262,1,'2024-12-04 16:49:32','2024-12-04 16:49:32'),(3263,NULL,'DUMMY',3263,1,'2024-12-04 16:49:32','2024-12-04 16:49:32'),(3264,NULL,'DUMMY',3264,1,'2024-12-04 16:49:32','2024-12-04 16:49:32'),(3265,NULL,'DUMMY',3265,1,'2024-12-04 16:49:32','2024-12-04 16:49:32'),(3266,NULL,'DUMMY',3266,1,'2024-12-04 16:49:32','2024-12-04 16:49:32'),(3267,NULL,'DUMMY',3267,1,'2024-12-04 16:49:32','2024-12-04 16:49:32'),(3268,NULL,'DUMMY',3268,1,'2024-12-04 16:49:32','2024-12-04 16:49:32'),(3269,NULL,'DUMMY',3269,1,'2024-12-04 16:49:32','2024-12-04 16:49:32'),(3270,NULL,'DUMMY',3270,1,'2024-12-04 16:49:32','2024-12-04 16:49:32'),(3271,NULL,'DUMMY',3271,1,'2024-12-04 16:49:32','2024-12-04 16:49:32'),(3272,NULL,'DUMMY',3272,1,'2024-12-04 16:49:32','2024-12-04 16:49:32'),(3273,NULL,'DUMMY',3273,1,'2024-12-04 16:49:32','2024-12-04 16:49:32'),(3274,NULL,'DUMMY',3274,1,'2024-12-04 16:49:32','2024-12-04 16:49:32'),(3275,NULL,'DUMMY',3275,1,'2024-12-04 16:49:32','2024-12-04 16:49:32'),(3276,NULL,'DUMMY',3276,1,'2024-12-04 16:49:32','2024-12-04 16:49:32'),(3277,NULL,'DUMMY',3277,1,'2024-12-04 16:49:32','2024-12-04 16:49:32'),(3278,NULL,'DUMMY',3278,1,'2024-12-04 16:49:32','2024-12-04 16:49:32'),(3279,NULL,'DUMMY',3279,1,'2024-12-04 16:49:32','2024-12-04 16:49:32'),(3280,NULL,'DUMMY',3280,1,'2024-12-04 16:49:32','2024-12-04 16:49:32'),(3281,NULL,'DUMMY',3281,1,'2024-12-04 16:49:32','2024-12-04 16:49:32'),(3282,NULL,'DUMMY',3282,1,'2024-12-04 16:49:32','2024-12-04 16:49:32'),(3283,NULL,'DUMMY',3283,1,'2024-12-04 16:49:32','2024-12-04 16:49:32'),(3284,NULL,'DUMMY',3284,1,'2024-12-04 16:49:32','2024-12-04 16:49:32'),(3285,NULL,'DUMMY',3285,1,'2024-12-04 16:49:32','2024-12-04 16:49:32'),(3286,NULL,'DUMMY',3286,1,'2024-12-04 16:49:32','2024-12-04 16:49:32'),(3287,NULL,'DUMMY',3287,1,'2024-12-04 16:49:32','2024-12-04 16:49:32'),(3288,NULL,'DUMMY',3288,1,'2024-12-04 16:49:32','2024-12-04 16:49:32'),(3289,NULL,'DUMMY',3289,1,'2024-12-04 16:49:32','2024-12-04 16:49:32'),(3290,NULL,'DUMMY',3290,1,'2024-12-04 16:49:32','2024-12-04 16:49:32'),(3291,NULL,'DUMMY',3291,1,'2024-12-04 16:49:32','2024-12-04 16:49:32'),(3292,NULL,'DUMMY',3292,1,'2024-12-04 16:49:32','2024-12-04 16:49:32'),(3293,NULL,'DUMMY',3293,1,'2024-12-04 16:49:32','2024-12-04 16:49:32'),(3294,NULL,'DUMMY',3294,1,'2024-12-04 16:49:32','2024-12-04 16:49:32'),(3295,NULL,'DUMMY',3295,1,'2024-12-04 16:49:32','2024-12-04 16:49:32'),(3296,NULL,'DUMMY',3296,1,'2024-12-04 16:49:33','2024-12-04 16:49:33'),(3297,NULL,'DUMMY',3297,1,'2024-12-04 16:49:33','2024-12-04 16:49:33'),(3298,NULL,'DUMMY',3298,1,'2024-12-04 16:49:33','2024-12-04 16:49:33'),(3299,NULL,'DUMMY',3299,1,'2024-12-04 16:49:33','2024-12-04 16:49:33'),(3300,NULL,'DUMMY',3300,1,'2024-12-04 16:49:33','2024-12-04 16:49:33'),(3301,NULL,'DUMMY',3301,1,'2024-12-04 16:49:33','2024-12-04 16:49:33'),(3302,NULL,'DUMMY',3302,1,'2024-12-04 16:49:33','2024-12-04 16:49:33'),(3303,NULL,'DUMMY',3303,1,'2024-12-04 16:49:33','2024-12-04 16:49:33'),(3304,NULL,'DUMMY',3304,1,'2024-12-04 16:49:33','2024-12-04 16:49:33'),(3305,NULL,'DUMMY',3305,1,'2024-12-04 16:49:33','2024-12-04 16:49:33'),(3306,NULL,'DUMMY',3306,1,'2024-12-04 16:49:33','2024-12-04 16:49:33'),(3307,NULL,'DUMMY',3307,1,'2024-12-04 16:49:33','2024-12-04 16:49:33'),(3308,NULL,'DUMMY',3308,1,'2024-12-04 16:49:33','2024-12-04 16:49:33'),(3309,NULL,'DUMMY',3309,1,'2024-12-04 16:49:33','2024-12-04 16:49:33'),(3310,NULL,'DUMMY',3310,1,'2024-12-04 16:49:33','2024-12-04 16:49:33'),(3311,NULL,'DUMMY',3311,1,'2024-12-04 16:49:33','2024-12-04 16:49:33'),(3312,NULL,'DUMMY',3312,1,'2024-12-04 16:49:33','2024-12-04 16:49:33'),(3313,NULL,'DUMMY',3313,1,'2024-12-04 16:49:33','2024-12-04 16:49:33'),(3314,NULL,'DUMMY',3314,1,'2024-12-04 16:49:33','2024-12-04 16:49:33'),(3315,NULL,'DUMMY',3315,1,'2024-12-04 16:49:33','2024-12-04 16:49:33'),(3316,NULL,'DUMMY',3316,1,'2024-12-04 16:49:33','2024-12-04 16:49:33'),(3317,NULL,'DUMMY',3317,1,'2024-12-04 16:49:33','2024-12-04 16:49:33'),(3318,NULL,'DUMMY',3318,1,'2024-12-04 16:49:33','2024-12-04 16:49:33'),(3319,NULL,'DUMMY',3319,1,'2024-12-04 16:49:33','2024-12-04 16:49:33'),(3320,NULL,'DUMMY',3320,1,'2024-12-04 16:49:33','2024-12-04 16:49:33'),(3321,NULL,'DUMMY',3321,1,'2024-12-04 16:49:33','2024-12-04 16:49:33'),(3322,NULL,'DUMMY',3322,1,'2024-12-04 16:49:33','2024-12-04 16:49:33'),(3323,NULL,'DUMMY',3323,1,'2024-12-04 16:49:33','2024-12-04 16:49:33'),(3324,NULL,'DUMMY',3324,1,'2024-12-04 16:49:33','2024-12-04 16:49:33'),(3325,NULL,'DUMMY',3325,1,'2024-12-04 16:49:33','2024-12-04 16:49:33'),(3326,NULL,'DUMMY',3326,1,'2024-12-04 16:49:33','2024-12-04 16:49:33'),(3327,NULL,'DUMMY',3327,1,'2024-12-04 16:49:33','2024-12-04 16:49:33'),(3328,NULL,'DUMMY',3328,1,'2024-12-04 16:49:33','2024-12-04 16:49:33'),(3329,NULL,'DUMMY',3329,1,'2024-12-04 16:49:33','2024-12-04 16:49:33'),(3330,NULL,'DUMMY',3330,1,'2024-12-04 16:49:33','2024-12-04 16:49:33'),(3331,NULL,'DUMMY',3331,1,'2024-12-04 16:49:33','2024-12-04 16:49:33'),(3332,NULL,'DUMMY',3332,1,'2024-12-04 16:49:34','2024-12-04 16:49:34'),(3333,NULL,'DUMMY',3333,1,'2024-12-04 16:49:34','2024-12-04 16:49:34'),(3334,NULL,'DUMMY',3334,1,'2024-12-04 16:49:34','2024-12-04 16:49:34'),(3335,NULL,'DUMMY',3335,1,'2024-12-04 16:49:34','2024-12-04 16:49:34'),(3336,NULL,'DUMMY',3336,1,'2024-12-04 16:49:34','2024-12-04 16:49:34'),(3337,NULL,'DUMMY',3337,1,'2024-12-04 16:49:34','2024-12-04 16:49:34'),(3338,NULL,'DUMMY',3338,1,'2024-12-04 16:49:34','2024-12-04 16:49:34'),(3339,NULL,'DUMMY',3339,1,'2024-12-04 16:49:34','2024-12-04 16:49:34'),(3340,NULL,'DUMMY',3340,1,'2024-12-04 16:49:34','2024-12-04 16:49:34'),(3341,NULL,'DUMMY',3341,1,'2024-12-04 16:49:34','2024-12-04 16:49:34'),(3342,NULL,'DUMMY',3342,1,'2024-12-04 16:49:34','2024-12-04 16:49:34'),(3343,NULL,'DUMMY',3343,1,'2024-12-04 16:49:34','2024-12-04 16:49:34'),(3344,NULL,'DUMMY',3344,1,'2024-12-04 16:49:34','2024-12-04 16:49:34'),(3345,NULL,'DUMMY',3345,1,'2024-12-04 16:49:34','2024-12-04 16:49:34'),(3346,NULL,'DUMMY',3346,1,'2024-12-04 16:49:34','2024-12-04 16:49:34'),(3347,NULL,'DUMMY',3347,1,'2024-12-04 16:49:34','2024-12-04 16:49:34'),(3348,NULL,'DUMMY',3348,1,'2024-12-04 16:49:34','2024-12-04 16:49:34'),(3349,NULL,'DUMMY',3349,1,'2024-12-04 16:49:34','2024-12-04 16:49:34'),(3350,NULL,'DUMMY',3350,1,'2024-12-04 16:49:34','2024-12-04 16:49:34'),(3351,NULL,'DUMMY',3351,1,'2024-12-04 16:49:34','2024-12-04 16:49:34'),(3352,NULL,'DUMMY',3352,1,'2024-12-04 16:49:34','2024-12-04 16:49:34'),(3353,NULL,'DUMMY',3353,1,'2024-12-04 16:49:34','2024-12-04 16:49:34'),(3354,NULL,'DUMMY',3354,1,'2024-12-04 16:49:34','2024-12-04 16:49:34'),(3355,NULL,'DUMMY',3355,1,'2024-12-04 16:49:34','2024-12-04 16:49:34'),(3356,NULL,'DUMMY',3356,1,'2024-12-04 16:49:34','2024-12-04 16:49:34'),(3357,NULL,'DUMMY',3357,1,'2024-12-04 16:49:34','2024-12-04 16:49:34'),(3358,NULL,'DUMMY',3358,1,'2024-12-04 16:49:34','2024-12-04 16:49:34'),(3359,NULL,'DUMMY',3359,1,'2024-12-04 16:49:34','2024-12-04 16:49:34'),(3360,NULL,'DUMMY',3360,1,'2024-12-04 16:49:34','2024-12-04 16:49:34'),(3361,NULL,'DUMMY',3361,1,'2024-12-04 16:49:34','2024-12-04 16:49:34'),(3362,NULL,'DUMMY',3362,1,'2024-12-04 16:49:34','2024-12-04 16:49:34'),(3363,NULL,'DUMMY',3363,1,'2024-12-04 16:49:34','2024-12-04 16:49:34'),(3364,NULL,'DUMMY',3364,1,'2024-12-04 16:49:34','2024-12-04 16:49:34'),(3365,NULL,'DUMMY',3365,1,'2024-12-04 16:49:34','2024-12-04 16:49:34'),(3366,NULL,'DUMMY',3366,1,'2024-12-04 16:49:34','2024-12-04 16:49:34'),(3367,NULL,'DUMMY',3367,1,'2024-12-04 16:49:34','2024-12-04 16:49:34'),(3368,NULL,'DUMMY',3368,1,'2024-12-04 16:49:34','2024-12-04 16:49:34'),(3369,NULL,'DUMMY',3369,1,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(3370,NULL,'DUMMY',3370,1,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(3371,NULL,'DUMMY',3371,1,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(3372,NULL,'DUMMY',3372,1,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(3373,NULL,'DUMMY',3373,1,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(3374,NULL,'DUMMY',3374,1,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(3375,NULL,'DUMMY',3375,1,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(3376,NULL,'DUMMY',3376,1,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(3377,NULL,'DUMMY',3377,1,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(3378,NULL,'DUMMY',3378,1,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(3379,NULL,'DUMMY',3379,1,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(3380,NULL,'DUMMY',3380,1,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(3381,NULL,'DUMMY',3381,1,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(3382,NULL,'DUMMY',3382,1,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(3383,NULL,'DUMMY',3383,1,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(3384,NULL,'DUMMY',3384,1,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(3385,NULL,'DUMMY',3385,1,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(3386,NULL,'DUMMY',3386,1,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(3387,NULL,'DUMMY',3387,1,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(3388,NULL,'DUMMY',3388,1,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(3389,NULL,'DUMMY',3389,1,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(3390,NULL,'DUMMY',3390,1,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(3391,NULL,'DUMMY',3391,1,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(3392,NULL,'DUMMY',3392,1,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(3393,NULL,'DUMMY',3393,1,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(3394,NULL,'DUMMY',3394,1,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(3395,NULL,'DUMMY',3395,1,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(3396,NULL,'DUMMY',3396,1,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(3397,NULL,'DUMMY',3397,1,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(3398,NULL,'DUMMY',3398,1,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(3399,NULL,'DUMMY',3399,1,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(3400,NULL,'DUMMY',3400,1,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(3401,NULL,'DUMMY',3401,1,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(3402,NULL,'DUMMY',3402,1,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(3403,NULL,'DUMMY',3403,1,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(3404,NULL,'DUMMY',3404,1,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(3405,NULL,'DUMMY',3405,1,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(3406,NULL,'DUMMY',3406,1,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(3407,NULL,'DUMMY',3407,1,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(3408,NULL,'DUMMY',3408,1,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(3409,NULL,'DUMMY',3409,1,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(3410,NULL,'DUMMY',3410,1,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(3411,NULL,'DUMMY',3411,1,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(3412,NULL,'DUMMY',3412,1,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(3413,NULL,'DUMMY',3413,1,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(3414,NULL,'DUMMY',3414,1,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(3415,NULL,'DUMMY',3415,1,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(3416,NULL,'DUMMY',3416,1,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(3417,NULL,'DUMMY',3417,1,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(3418,NULL,'DUMMY',3418,1,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(3419,NULL,'DUMMY',3419,1,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(3420,NULL,'DUMMY',3420,1,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(3421,NULL,'DUMMY',3421,1,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(3422,NULL,'DUMMY',3422,1,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(3423,NULL,'DUMMY',3423,1,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(3424,NULL,'DUMMY',3424,1,'2024-12-04 16:49:35','2024-12-04 16:49:35'),(3425,NULL,'DUMMY',3425,1,'2024-12-04 16:49:36','2024-12-04 16:49:36'),(3426,NULL,'DUMMY',3426,1,'2024-12-04 16:49:36','2024-12-04 16:49:36'),(3427,NULL,'DUMMY',3427,1,'2024-12-04 16:49:36','2024-12-04 16:49:36'),(3428,NULL,'DUMMY',3428,1,'2024-12-04 16:49:36','2024-12-04 16:49:36'),(3429,NULL,'DUMMY',3429,1,'2024-12-04 16:49:36','2024-12-04 16:49:36'),(3430,NULL,'DUMMY',3430,1,'2024-12-04 16:49:36','2024-12-04 16:49:36'),(3431,NULL,'DUMMY',3431,1,'2024-12-04 16:49:36','2024-12-04 16:49:36'),(3432,NULL,'DUMMY',3432,1,'2024-12-04 16:49:36','2024-12-04 16:49:36'),(3433,NULL,'DUMMY',3433,1,'2024-12-04 16:49:36','2024-12-04 16:49:36'),(3434,NULL,'DUMMY',3434,1,'2024-12-04 16:49:36','2024-12-04 16:49:36'),(3435,NULL,'DUMMY',3435,1,'2024-12-04 16:49:36','2024-12-04 16:49:36'),(3436,NULL,'DUMMY',3436,1,'2024-12-04 16:49:36','2024-12-04 16:49:36'),(3437,NULL,'DUMMY',3437,1,'2024-12-04 16:49:36','2024-12-04 16:49:36'),(3438,NULL,'DUMMY',3438,1,'2024-12-04 16:49:36','2024-12-04 16:49:36'),(3439,NULL,'DUMMY',3439,1,'2024-12-04 16:49:36','2024-12-04 16:49:36'),(3440,NULL,'DUMMY',3440,1,'2024-12-04 16:49:36','2024-12-04 16:49:36'),(3441,NULL,'DUMMY',3441,1,'2024-12-04 16:49:36','2024-12-04 16:49:36'),(3442,NULL,'DUMMY',3442,1,'2024-12-04 16:49:36','2024-12-04 16:49:36'),(3443,NULL,'DUMMY',3443,1,'2024-12-04 16:49:36','2024-12-04 16:49:36'),(3444,NULL,'DUMMY',3444,1,'2024-12-04 16:49:36','2024-12-04 16:49:36'),(3445,NULL,'DUMMY',3445,1,'2024-12-04 16:49:36','2024-12-04 16:49:36'),(3446,NULL,'DUMMY',3446,1,'2024-12-04 16:49:36','2024-12-04 16:49:36'),(3447,NULL,'DUMMY',3447,1,'2024-12-04 16:49:36','2024-12-04 16:49:36'),(3448,NULL,'DUMMY',3448,1,'2024-12-04 16:49:36','2024-12-04 16:49:36'),(3449,NULL,'DUMMY',3449,1,'2024-12-04 16:49:36','2024-12-04 16:49:36'),(3450,NULL,'DUMMY',3450,1,'2024-12-04 16:49:36','2024-12-04 16:49:36'),(3451,NULL,'DUMMY',3451,1,'2024-12-04 16:49:36','2024-12-04 16:49:36'),(3452,NULL,'DUMMY',3452,1,'2024-12-04 16:49:36','2024-12-04 16:49:36'),(3453,NULL,'DUMMY',3453,1,'2024-12-04 16:49:36','2024-12-04 16:49:36'),(3454,NULL,'DUMMY',3454,1,'2024-12-04 16:49:36','2024-12-04 16:49:36'),(3455,NULL,'DUMMY',3455,1,'2024-12-04 16:49:36','2024-12-04 16:49:36'),(3456,NULL,'DUMMY',3456,1,'2024-12-04 16:49:36','2024-12-04 16:49:36'),(3457,NULL,'DUMMY',3457,1,'2024-12-04 16:49:36','2024-12-04 16:49:36'),(3458,NULL,'DUMMY',3458,1,'2024-12-04 16:49:36','2024-12-04 16:49:36'),(3459,NULL,'DUMMY',3459,1,'2024-12-04 17:08:12','2024-12-04 17:08:12'),(3460,NULL,'DUMMY',3460,1,'2024-12-04 17:42:40','2024-12-04 17:42:40'),(3461,NULL,'DUMMY',3461,1,'2024-12-04 17:47:36','2024-12-04 17:47:36'),(3462,NULL,'DUMMY',3462,1,'2024-12-05 09:19:30','2024-12-05 09:19:30'),(3463,NULL,'DUMMY',3463,1,'2024-12-05 09:22:44','2024-12-05 09:22:44'),(3464,NULL,'DUMMY',3464,1,'2024-12-05 09:25:57','2024-12-05 09:25:57'),(3465,NULL,'DUMMY',3465,1,'2024-12-05 09:29:17','2024-12-05 09:29:17'),(3466,NULL,'DUMMY',3466,1,'2024-12-05 09:33:45','2024-12-05 09:33:45'),(3467,NULL,'DUMMY',3467,1,'2024-12-05 09:37:42','2024-12-05 09:37:42'),(3468,NULL,'DUMMY',3468,1,'2024-12-05 09:41:00','2024-12-05 09:41:00'),(3469,NULL,'DUMMY',3469,1,'2024-12-05 09:46:37','2024-12-05 09:46:37'),(3470,NULL,'DUMMY',3470,1,'2024-12-05 09:48:55','2024-12-05 09:48:55'),(3471,NULL,'DUMMY',3471,1,'2024-12-05 10:25:34','2024-12-05 10:25:34'),(3472,NULL,'DUMMY',3472,1,'2024-12-05 10:28:40','2024-12-05 10:28:40'),(3473,NULL,'DUMMY',3473,1,'2024-12-05 10:31:24','2024-12-05 10:31:24'),(3474,NULL,'DUMMY',3474,1,'2024-12-05 10:34:55','2024-12-05 10:34:55'),(3475,NULL,'DUMMY',3475,1,'2024-12-05 10:40:25','2024-12-05 10:40:25'),(3476,NULL,'DUMMY',3476,1,'2024-12-05 10:46:57','2024-12-05 10:46:57'),(3477,NULL,'DUMMY',3477,1,'2024-12-05 10:52:29','2024-12-05 10:52:29'),(3478,NULL,'DUMMY',3478,1,'2024-12-05 10:57:11','2024-12-05 10:57:11'),(3479,NULL,'DUMMY',3479,1,'2024-12-05 10:59:27','2024-12-05 10:59:27'),(3480,NULL,'DUMMY',3480,1,'2024-12-05 11:06:35','2024-12-05 11:06:35'),(3481,NULL,'DUMMY',3481,1,'2024-12-05 11:10:12','2024-12-05 11:10:12'),(3482,NULL,'DUMMY',3482,1,'2024-12-05 11:17:02','2024-12-05 11:17:02'),(3483,NULL,'DUMMY',3483,1,'2024-12-05 11:21:03','2024-12-05 11:21:03'),(3484,NULL,'DUMMY',3484,1,'2024-12-05 11:46:32','2024-12-05 11:46:32'),(3485,NULL,'DUMMY',3485,1,'2024-12-05 11:52:33','2024-12-05 11:52:33'),(3486,NULL,'DUMMY',3486,1,'2024-12-05 11:56:49','2024-12-05 11:56:49'),(3487,NULL,'DUMMY',3487,1,'2024-12-05 11:59:48','2024-12-05 11:59:48'),(3488,NULL,'DUMMY',3488,1,'2024-12-05 12:19:56','2024-12-05 12:19:56'),(3489,NULL,'DUMMY',3489,1,'2024-12-05 12:27:47','2024-12-05 12:27:47'),(3490,NULL,'DUMMY',3490,1,'2024-12-05 12:32:10','2024-12-05 12:32:10'),(3491,NULL,'DUMMY',3491,1,'2024-12-05 12:34:07','2024-12-05 12:34:07'),(3492,NULL,'DUMMY',3492,1,'2024-12-05 12:36:51','2024-12-05 12:36:51'),(3494,NULL,'DUMMY',3494,1,'2024-12-07 09:06:36','2024-12-07 09:06:36'),(3495,NULL,'DUMMY',3495,1,'2024-12-07 09:16:52','2024-12-07 09:16:52'),(3498,NULL,'DUMMY',3498,1,'2024-12-18 19:53:30','2024-12-18 19:53:30'),(3499,NULL,'DUMMY',3499,1,'2024-12-20 14:38:35','2024-12-20 14:38:35'),(3500,NULL,'DUMMY',3500,1,'2024-12-20 14:48:42','2024-12-20 14:48:42');
/*!40000 ALTER TABLE `product_variations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `products` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `type` enum('single','variable','modifier','combo') DEFAULT NULL,
  `unit_id` int(10) unsigned DEFAULT NULL,
  `secondary_unit_id` int(11) DEFAULT NULL,
  `sub_unit_ids` text DEFAULT NULL,
  `brand_id` int(10) unsigned DEFAULT NULL,
  `category_id` int(10) unsigned DEFAULT NULL,
  `sub_category_id` int(10) unsigned DEFAULT NULL,
  `discount_id` int(10) unsigned DEFAULT NULL,
  `tax` int(10) unsigned DEFAULT NULL,
  `tax_type` enum('inclusive','exclusive') NOT NULL,
  `enable_stock` tinyint(1) NOT NULL DEFAULT 0,
  `alert_quantity` decimal(22,4) DEFAULT NULL,
  `sku` varchar(191) NOT NULL,
  `barcode_type` enum('C39','C128','EAN13','EAN8','UPCA','UPCE') DEFAULT 'C128',
  `expiry_period` decimal(4,2) DEFAULT NULL,
  `expiry_period_type` enum('days','months') DEFAULT NULL,
  `enable_sr_no` tinyint(1) NOT NULL DEFAULT 0,
  `enable_serial_number` tinyint(1) NOT NULL DEFAULT 0,
  `weight` varchar(191) DEFAULT NULL,
  `use_multi_unit` tinyint(1) NOT NULL DEFAULT 0,
  `first_conversion_unit_id` int(10) unsigned DEFAULT NULL,
  `first_conversion_unit_rate` decimal(20,4) DEFAULT NULL,
  `second_conversion_unit_id` int(10) unsigned DEFAULT NULL,
  `second_conversion_unit_rate` decimal(20,4) DEFAULT NULL,
  `product_custom_field1` varchar(191) DEFAULT NULL,
  `product_custom_field2` varchar(191) DEFAULT NULL,
  `product_custom_field3` varchar(191) DEFAULT NULL,
  `product_custom_field4` varchar(191) DEFAULT NULL,
  `product_custom_field5` varchar(191) DEFAULT NULL,
  `product_custom_field6` varchar(191) DEFAULT NULL,
  `product_custom_field7` varchar(191) DEFAULT NULL,
  `product_custom_field8` varchar(191) DEFAULT NULL,
  `product_custom_field9` varchar(191) DEFAULT NULL,
  `product_custom_field10` varchar(191) DEFAULT NULL,
  `product_custom_field11` varchar(191) DEFAULT NULL,
  `product_custom_field12` varchar(191) DEFAULT NULL,
  `product_custom_field13` varchar(191) DEFAULT NULL,
  `product_custom_field14` varchar(191) DEFAULT NULL,
  `product_custom_field15` varchar(191) DEFAULT NULL,
  `product_custom_field16` varchar(191) DEFAULT NULL,
  `product_custom_field17` varchar(191) DEFAULT NULL,
  `product_custom_field18` varchar(191) DEFAULT NULL,
  `product_custom_field19` varchar(191) DEFAULT NULL,
  `product_custom_field20` varchar(191) DEFAULT NULL,
  `image` varchar(191) DEFAULT NULL,
  `product_description` text DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `preparation_time_in_minutes` int(11) DEFAULT NULL,
  `warranty_id` int(11) DEFAULT NULL,
  `is_inactive` tinyint(1) NOT NULL DEFAULT 0,
  `not_for_selling` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `products_brand_id_foreign` (`brand_id`),
  KEY `products_category_id_foreign` (`category_id`),
  KEY `products_sub_category_id_foreign` (`sub_category_id`),
  KEY `products_tax_foreign` (`tax`),
  KEY `products_name_index` (`name`),
  KEY `products_business_id_index` (`business_id`),
  KEY `products_unit_id_index` (`unit_id`),
  KEY `products_created_by_index` (`created_by`),
  KEY `products_warranty_id_index` (`warranty_id`),
  KEY `products_type_index` (`type`),
  KEY `products_tax_type_index` (`tax_type`),
  KEY `products_barcode_type_index` (`barcode_type`),
  KEY `products_secondary_unit_id_index` (`secondary_unit_id`),
  CONSTRAINT `products_brand_id_foreign` FOREIGN KEY (`brand_id`) REFERENCES `brands` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `categories` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_sub_category_id_foreign` FOREIGN KEY (`sub_category_id`) REFERENCES `categories` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_tax_foreign` FOREIGN KEY (`tax`) REFERENCES `tax_rates` (`id`),
  CONSTRAINT `products_unit_id_foreign` FOREIGN KEY (`unit_id`) REFERENCES `units` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3501 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `products` WRITE;
/*!40000 ALTER TABLE `products` DISABLE KEYS */;
INSERT INTO `products` VALUES (1,'00110-03 مرسیڈیز فیرل کپ',1,'single',1,NULL,NULL,94,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.Display cabinet-235','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(2,'00110-06-r11  تین سوترسنگل تنگ سوراخ',1,'single',1,NULL,NULL,95,144,NULL,NULL,NULL,'inclusive',1,5.0000,'G11.on glass rack-64','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(3,'00110-06-r14  تین سوترسنگل  کھلا سوراخ',1,'single',1,NULL,NULL,95,144,NULL,NULL,NULL,'inclusive',1,5.0000,'G11.on glass rack-46','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(4,'00110-08-r15  آدھی سنگل کا کپ تنگ سوراخ',1,'single',1,NULL,NULL,95,144,NULL,NULL,NULL,'inclusive',1,5.0000,'G11.on glass rack-49','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(5,'00110-08-r18  آدھی سنگل کا کپ کھلا سوراخ',1,'single',1,NULL,NULL,95,144,NULL,NULL,NULL,'inclusive',1,5.0000,'G11.on glass rack-48','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(6,'00210-06-r11  تین سوتر ڈبل تنگ سوراخ',1,'single',1,NULL,NULL,95,144,NULL,NULL,NULL,'inclusive',1,5.0000,'G11.on glass rack-65','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(7,'00210-06-r11  تین سوتر ڈبل تنگ سوراخ',1,'single',1,NULL,NULL,94,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.Display cabinet-240','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(8,'00210-06-r14  تین سوتر ڈبل کھلا سوراخ',1,'single',1,NULL,NULL,95,144,NULL,NULL,NULL,'inclusive',1,5.0000,'G11.on glass rack-47','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(9,'00210-08-r15     ادھی ڈبل کپ تنگ سوراخ',1,'single',1,NULL,NULL,95,144,NULL,NULL,NULL,'inclusive',1,5.0000,'G11.on glass rack-66','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(10,'00210-08-r15     ادھی ڈبل کپ تنگ سوراخ',1,'single',1,NULL,NULL,94,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.Display cabinet-239','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(11,'00210-08-r18     ادھی ڈبل کپ کھلا سوراخ',1,'single',1,NULL,NULL,95,144,NULL,NULL,NULL,'inclusive',1,5.0000,'G11.on glass rack-50','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(12,'00210-12-r21 پونی ڈبل کا کپ',1,'single',1,NULL,NULL,95,144,NULL,NULL,NULL,'inclusive',1,5.0000,'G11.on glass rack-58','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(13,'00210-12-r21 پونی ڈبل کا کپ',1,'single',1,NULL,NULL,94,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.Display cabinet-233','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(14,'00210-16-r27 ایک انچ ڈبل کا کپ',1,'single',1,NULL,NULL,95,144,NULL,NULL,NULL,'inclusive',1,5.0000,'G11.on glass rack-68','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(15,'00210-20  سوا انچ ڈبل کا کپ',1,'single',1,NULL,NULL,95,144,NULL,NULL,NULL,'inclusive',1,5.0000,'G11.on glass rack-59','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(16,'00210-24 ڈیڈھ ڈبل کا کپ',1,'single',1,NULL,NULL,95,144,NULL,NULL,NULL,'inclusive',1,5.0000,'G11.on glass rack-60','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(17,'00210-24 ڈیڈھ ڈبل کا کپ',1,'single',1,NULL,NULL,95,144,NULL,NULL,NULL,'inclusive',1,5.0000,'G11.on glass rack-71','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(18,'00210-32  دو انچ ڈبل کا کپ',1,'single',1,NULL,NULL,95,144,NULL,NULL,NULL,'inclusive',1,5.0000,'G11.on glass rack-73','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(19,'00400-12-r21 پونی چارپلائی کا کپ',1,'single',1,NULL,NULL,95,144,NULL,NULL,NULL,'inclusive',1,5.0000,'G11.on glass rack-67','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(20,'00400-12-r21 پونی چارپلائی کا کپ',1,'single',1,NULL,NULL,94,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.Display cabinet-234','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(21,'00400-16 ایک انچ چار  جالی کا  کپ',1,'single',1,NULL,NULL,95,144,NULL,NULL,NULL,'inclusive',1,5.0000,'G11.on glass rack-69','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(22,'00400-20    سوا انچ  بورچارپلائی (جالی )کپ',1,'single',1,NULL,NULL,95,144,NULL,NULL,NULL,'inclusive',1,5.0000,'G11.on glass rack-70','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(23,'00400-24      ڈیڈھ انچ  بورچارپلائی (جالی )کپ',1,'single',1,NULL,NULL,95,144,NULL,NULL,NULL,'inclusive',1,5.0000,'G11.on glass rack-72','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(24,'00400-32      دوانچ  بورچارپلائی (جالی )کپ',1,'single',1,NULL,NULL,95,144,NULL,NULL,NULL,'inclusive',1,5.0000,'G11.on glass rack-61','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(25,'1 rz ac bend ون آر زیڈائیر کلینڈر پائپ گوڈا',1,'single',1,NULL,NULL,78,135,NULL,NULL,NULL,'inclusive',1,5.0000,'g1.70-2','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(26,'1 rz ac bend ون آر زیڈائیر کلینڈر پائپ گوڈا',1,'single',1,NULL,NULL,82,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.51-1','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(27,'1 s  pipe  white                ایک سوتر  پائپ سفید کینیڈا',1,'single',18,NULL,NULL,79,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.13/9-74','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(28,'1 s  pipe  white                ایک سوتر  پائپ سفید کینیڈا',1,'single',18,NULL,NULL,79,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.13/9-75','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(29,'1 s  pipe  white                ایک سوتر  پائپ سفید کینیڈا',1,'single',18,NULL,NULL,79,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.13/9-76','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(30,'1 s  pipe  white                ایک سوتر  پائپ سفید کینیڈا',1,'single',18,NULL,NULL,79,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.13/9-77','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(31,'1 s  pipe  white                ایک سوتر  پائپ سفید کینیڈا',1,'single',18,NULL,NULL,79,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.13/9-78','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(32,'1 s  pipe  white                ایک سوتر  پائپ سفید کینیڈا',1,'single',18,NULL,NULL,79,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.13/9-79','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(33,'1 s  pipe  white                ایک سوتر  پائپ سفید کینیڈا',1,'single',18,NULL,NULL,79,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.13/9-80','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(34,'1 s  pipe  white                ایک سوتر  پائپ سفید کینیڈا',1,'single',18,NULL,NULL,79,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.13/9-81','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(35,'1 s  pipe  white                ایک سوتر  پائپ سفید کینیڈا',1,'single',18,NULL,NULL,79,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.13/9-82','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(36,'1 s  pipe  white                ایک سوتر  پائپ سفید کینیڈا',1,'single',18,NULL,NULL,79,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.13/9-83','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(37,'1 s  pipe  white                ایک سوتر  پائپ سفید کینیڈا',1,'single',18,NULL,NULL,79,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.13/9-84','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(38,'1 s  pipe  white                ایک سوتر  پائپ سفید کینیڈا',1,'single',18,NULL,NULL,79,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.13/9-85','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(39,'1 s  pipe  white                ایک سوتر  پائپ سفید کینیڈا',1,'single',18,NULL,NULL,79,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.13/9-86','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(40,'1 s  pipe  white                ایک سوتر  پائپ سفید کینیڈا',1,'single',18,NULL,NULL,79,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.13/9-87','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(41,'1 s  pipe  white                ایک سوتر  پائپ سفید کینیڈا',1,'single',18,NULL,NULL,79,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.13/9-88','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(42,'1 s  pipe  white                ایک سوتر  پائپ سفید کینیڈا',1,'single',18,NULL,NULL,79,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.13/9-89','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(43,'1 s  pipe  white                ایک سوتر  پائپ سفید کینیڈا',1,'single',18,NULL,NULL,79,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.13/9-90','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(44,'1 s  pipe  white                ایک سوتر  پائپ سفید کینیڈا',1,'single',18,NULL,NULL,79,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.13/9-91','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(45,'1 s  pipe  white                ایک سوتر  پائپ سفید کینیڈا',1,'single',18,NULL,NULL,79,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.13/9-92','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:22','2024-12-04 16:35:22'),(46,'1 s  pipe  white                ایک سوتر  پائپ سفید کینیڈا',1,'single',18,NULL,NULL,79,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.13/9-93','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(47,'1 s  pipe  white                ایک سوتر  پائپ سفید کینیڈا',1,'single',18,NULL,NULL,79,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.13/9-94','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(48,'1 s  pipe  white                ایک سوتر  پائپ سفید کینیڈا',1,'single',18,NULL,NULL,79,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.13/9-95','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(49,'1 s  pipe  white                ایک سوتر  پائپ سفید کینیڈا',1,'single',18,NULL,NULL,79,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.13/9-96','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(50,'1 s  pipe  white                ایک سوتر  پائپ سفید کینیڈا',1,'single',18,NULL,NULL,79,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.13/9-97','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(51,'1 s  pipe  white                ایک سوتر  پائپ سفید کینیڈا',1,'single',18,NULL,NULL,79,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.13/9-98','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(52,'1 s  pipe  white                ایک سوتر  پائپ سفید کینیڈا',1,'single',18,NULL,NULL,79,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.13/9-99','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(53,'1 s  pipe  white                ایک سوتر  پائپ سفید کینیڈا',1,'single',18,NULL,NULL,79,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.13/9-100','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(54,'1 s  pipe  white                ایک سوتر  پائپ سفید کینیڈا',1,'single',18,NULL,NULL,79,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.13/9-101','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(55,'1 s  pipe  white                ایک سوتر  پائپ سفید کینیڈا',1,'single',18,NULL,NULL,79,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.13/9-102','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(56,'1 s  pipe  white                ایک سوتر  پائپ سفید کینیڈا',1,'single',18,NULL,NULL,79,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.13/9-103','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(57,'1 s  pipe  white                ایک سوتر  پائپ سفید کینیڈا',1,'single',18,NULL,NULL,79,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.13/9-104','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(58,'1 s  pipe  white                ایک سوتر  پائپ سفید کینیڈا',1,'single',18,NULL,NULL,79,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.13/9-106','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(59,'1 s  pipe  white                ایک سوتر  پائپ سفید کینیڈا',1,'single',18,NULL,NULL,79,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.13/9-107','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(60,'1 s  pipe  white                ایک سوتر  پائپ سفید کینیڈا',1,'single',18,NULL,NULL,79,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.13/9-108','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(61,'1 s  pipe  white                ایک سوتر  پائپ سفید کینیڈا',1,'single',18,NULL,NULL,79,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.13/9-109','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(62,'1 s  pipe  white                ایک سوتر  پائپ سفید کینیڈا',1,'single',18,NULL,NULL,79,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.13/9-110','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(63,'1 s  pipe  white                ایک سوتر  پائپ سفید کینیڈا',1,'single',18,NULL,NULL,79,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.13/9-111','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(64,'1 s  pipe  white                ایک سوتر  پائپ سفید کینیڈا',1,'single',18,NULL,NULL,79,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.13/9-112','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(65,'1 s  pipe  white                ایک سوتر  پائپ سفید کینیڈا',1,'single',18,NULL,NULL,79,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.13/9-114','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(66,'1 s  pipe  white                ایک سوتر  پائپ سفید کینیڈا',1,'single',18,NULL,NULL,79,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.13/9-115','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(67,'1 s  pipe  white                ایک سوتر  پائپ سفید کینیڈا',1,'single',18,NULL,NULL,79,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.13/9-116','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(68,'1 s  pipe  white                ایک سوتر  پائپ سفید کینیڈا',1,'single',18,NULL,NULL,79,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.13/9-117','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(69,'1 s  pipe  white                ایک سوتر  پائپ سفید کینیڈا',1,'single',18,NULL,NULL,79,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.13/9-118','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(70,'1 s  pipe  white                ایک سوتر  پائپ سفید کینیڈا',1,'single',18,NULL,NULL,79,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.13/9-119','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(71,'1 s  pipe  white                ایک سوتر  پائپ سفید کینیڈا',1,'single',18,NULL,NULL,79,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.13/9-120','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(72,'1 s  pipe  white                ایک سوتر  پائپ سفید کینیڈا',1,'single',18,NULL,NULL,79,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.13/9-121','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(73,'1 s  pipe  white                ایک سوتر  پائپ سفید کینیڈا',1,'single',18,NULL,NULL,79,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.13/9-122','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(74,'1 s  pipe  white                ایک سوتر  پائپ سفید کینیڈا',1,'single',18,NULL,NULL,79,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.13/9-123','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(75,'1 s  pipe  white                ایک سوتر  پائپ سفید کینیڈا',1,'single',18,NULL,NULL,79,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.13/9-124','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(76,'1 s  pipe  white                ایک سوتر  پائپ سفید کینیڈا',1,'single',18,NULL,NULL,79,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.13/9-125','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(77,'1 s  pipe  white                ایک سوتر  پائپ سفید کینیڈا',1,'single',18,NULL,NULL,79,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.13/9-126','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(78,'1 s  pipe  white                ایک سوتر  پائپ سفید کینیڈا',1,'single',18,NULL,NULL,79,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.13/9-127','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(79,'1 s  pipe  white                ایک سوتر  پائپ سفید کینیڈا',1,'single',18,NULL,NULL,79,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.13/9-128','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(80,'1 s  pipe  white                ایک سوتر  پائپ سفید کینیڈا',1,'single',18,NULL,NULL,79,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.13/9-129','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(81,'1 s  pipe  white                ایک سوتر  پائپ سفید کینیڈا',1,'single',18,NULL,NULL,79,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.13/9-130','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(82,'1 s  pipe  white                ایک سوتر  پائپ سفید کینیڈا',1,'single',18,NULL,NULL,79,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.13/9-131','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(83,'1 s  pipe  white                ایک سوتر  پائپ سفید کینیڈا',1,'single',18,NULL,NULL,79,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.13/9-132','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(84,'1 s  pipe  white                ایک سوتر  پائپ سفید کینیڈا',1,'single',18,NULL,NULL,79,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.13/9-133','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(85,'1 s  pipe  white                ایک سوتر  پائپ سفید کینیڈا',1,'single',18,NULL,NULL,79,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.13/9-134','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(86,'1 s  pipe  white                ایک سوتر  پائپ سفید کینیڈا',1,'single',18,NULL,NULL,79,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.13/9-135','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(87,'1 s  pipe  white                ایک سوتر  پائپ سفید کینیڈا',1,'single',18,NULL,NULL,79,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.13/9-136','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(88,'1 s  pipe  white                ایک سوتر  پائپ سفید کینیڈا',1,'single',18,NULL,NULL,79,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.13/9-137','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(89,'1 s  pipe  white                ایک سوتر  پائپ سفید کینیڈا',1,'single',18,NULL,NULL,79,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.13/9-139','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(90,'1 s  pipe  white                ایک سوتر  پائپ سفید کینیڈا',1,'single',18,NULL,NULL,79,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.13/9-140','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(91,'1 s  pipe  white                ایک سوتر  پائپ سفید کینیڈا',1,'single',18,NULL,NULL,79,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.13/9-142','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(92,'1 s  pipe  white               ایک سوتر  پائپ سفید کینیڈا',1,'single',18,NULL,NULL,79,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.13/9-105','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(93,'1 s  pipe  white               ایک سوتر  پائپ سفید کینیڈا',1,'single',18,NULL,NULL,79,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.13/9-113','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(94,'1 s  pipe  white               ایک سوتر  پائپ سفید کینیڈا',1,'single',18,NULL,NULL,79,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.13/9-138','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(95,'1 s  pipe  white               ایک سوتر  پائپ سفید کینیڈا',1,'single',18,NULL,NULL,79,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.13/9-141','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(96,'1 s  pipe  white               ایک سوتر  پائپ سفید کینیڈا',1,'single',18,NULL,NULL,79,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.13/9-143','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(97,'1 s  pipe black oper dhaga       ایک سوتر  پائپ کالا اوپر دھاگہ',1,'single',18,NULL,NULL,79,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.13/9-1FU2704--','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(98,'1 s  pipe black oper dhaga       ایک سوتر  پائپ کالا اوپر دھاگہ',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-2','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:23','2024-12-04 16:35:23'),(99,'1 s  pipe black oper dhaga       ایک سوتر  پائپ کالا اوپر دھاگہ',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-3','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(100,'1 s  pipe black oper dhaga       ایک سوتر  پائپ کالا اوپر دھاگہ',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-4','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(101,'1 s  pipe black oper dhaga       ایک سوتر  پائپ کالا اوپر دھاگہ',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-5','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(102,'1 s  pipe black oper dhaga       ایک سوتر  پائپ کالا اوپر دھاگہ',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-6','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(103,'1 s  pipe pu china grey              ایک سوتر  پائپ  پی یو چائنہ',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-7','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(104,'1 s black        ایک سوتر کالا ولائیتی',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-8','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(105,'1 s black        ایک سوتر کالا ولائیتی',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-9','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(106,'1 s black        ایک سوتر کالا ولائیتی',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-10','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(107,'1 s black       ایک سوتر کالا ولائیتی',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-11','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(108,'1 s brake pipe         ایک سوتربریک پائپ',1,'single',18,NULL,NULL,79,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.13/9-148','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(109,'1 s brake pipe         ایک سوتربریک پائپ',1,'single',18,NULL,NULL,79,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.13/9-149','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(110,'1 s brake pipe        ایک سوتربریک پائپ',1,'single',18,NULL,NULL,79,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.13/9-150','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(111,'1 s brake pipe       ایک سوتر بریک پائپ',1,'single',18,NULL,NULL,79,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.13/9-147','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(112,'1 s brake pipe       ایک سوتربریک پائپ',1,'single',18,NULL,NULL,79,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.13/9-145','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(113,'1 s brake pipe       ایک سوتربریک پائپ',1,'single',18,NULL,NULL,79,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.13/9-146','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(114,'1 s brake pipe     ایک سوتربریک پائپ',1,'single',18,NULL,NULL,79,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.13/9-144','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(115,'1 s pipe vacum pvc ایک سوتر ویکیوم پی  وی سی',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.OPEN-500','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(116,'1 s white canada        ایک سوترسفید ولائیتی',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-12','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(117,'1 s white canada        ایک سوترسفید ولائیتی',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-13','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(118,'1-1/2 s black            ڈیڈھ سوتر کالا فرانس',1,'single',18,NULL,NULL,97,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.9/13/16-199','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(119,'1-1/2 s black            ڈیڈھ سوتر کالا فرانس',1,'single',18,NULL,NULL,97,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.9/13/16-200','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(120,'1-1/2 s black            ڈیڈھ سوتر کالا فرانس',1,'single',18,NULL,NULL,97,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.9/13/16-201','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(121,'1-1/2 s black            ڈیڈھ سوتر کالا فرانس',1,'single',18,NULL,NULL,97,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.9/13/16-203','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(122,'1-1/2 s black            ڈیڈھ سوتر کالا فرانس',1,'single',18,NULL,NULL,97,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.9/13/16-204','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(123,'1-1/2 s black            ڈیڈھ سوتر کالا فرانس',1,'single',18,NULL,NULL,97,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.9/13/16-205','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(124,'1-1/2 s black            ڈیڈھ سوتر کالا فرانس',1,'single',18,NULL,NULL,97,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.9/13/16-206','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(125,'1-1/2 s black            ڈیڈھ سوتر کالا فرانس',1,'single',18,NULL,NULL,97,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.9/13/16-207','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(126,'1-1/2 s black            ڈیڈھ سوتر کالا فرانس',1,'single',18,NULL,NULL,97,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.9/13/16-208','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(127,'1-1/2 s black            ڈیڈھ سوتر کالا فرانس',1,'single',18,NULL,NULL,97,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.9/13/16-209','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(128,'1-1/2 s black            ڈیڈھ سوتر کالا فرانس',1,'single',18,NULL,NULL,97,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.9/13/16-212','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(129,'1-1/2 s black            ڈیڈھ سوتر کالا فرانس',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-16','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(130,'1-1/2 s black            ڈیڈھ سوتر کالا فرانس',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-17','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(131,'1-1/2 s black            ڈیڈھ سوتر کالا فرانس',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-18','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(132,'1-1/2 s black            ڈیڈھ سوتر کالا فرانس',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-19','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(133,'1-1/2 s black           ڈیڈھ سوتر کالا فرانس',1,'single',18,NULL,NULL,88,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.9/13/16-8','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(134,'1-1/2 s black           ڈیڈھ سوتر کالا فرانس',1,'single',18,NULL,NULL,97,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.9/13/16-202','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(135,'1-1/2 s black           ڈیڈھ سوتر کالا فرانس',1,'single',18,NULL,NULL,97,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.9/13/16-210','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(136,'1-1/2 s black           ڈیڈھ سوتر کالا فرانس',1,'single',18,NULL,NULL,97,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.9/13/16-211','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(137,'1-1/2 s black           ڈیڈھ سوتر کالا فرانس',1,'single',18,NULL,NULL,97,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.9/13/16-213','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(138,'1-1/2 s black           ڈیڈھ سوتر کالا فرانس',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-20','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(139,'1-1/2 s caben pipe pvc        ڈیڈھ سوتر کیبن پائپ پی وی سی',1,'single',18,NULL,NULL,98,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.9/10-9','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(140,'1-1/2 s line wala pvc   ڈیڈھ سوتر لائن والا',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'g10.open-501','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(141,'1-1/2\' leangth 3 s double  lock fitting aam fitting    ڈیڈھ فٹ لمبا تین سوتر ڈبل لا ک فٹنگ عام فٹنگ',1,'single',1,NULL,NULL,85,134,NULL,NULL,NULL,'inclusive',1,5.0000,'G3.8-18','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(142,'1-1/2\' leangth 3 s double jack pipe china fitting  ڈیدھ فٹ لمبا تین سوترڈبل جیک پائپ. چائینہ فتنگ',1,'single',1,NULL,NULL,69,134,NULL,NULL,NULL,'inclusive',1,5.0000,'G3.19-19','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(143,'1-1/2\' leangth 3 s double jack pipe ڈیڈھ فٹ لمبا تین سوتر سنگل جیک پائپ چائنہ فٹنگ',1,'single',1,NULL,NULL,99,144,NULL,NULL,NULL,'inclusive',1,5.0000,'G11.on a glass rack-188','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(144,'1-1/2\' leangth 3 s single jack pipe straight   ڈیڈھ فٹ لمباتین سوترسنگل جیک پائپ سیدھا عام  فتنگ',1,'single',1,NULL,NULL,70,134,NULL,NULL,NULL,'inclusive',1,5.0000,'G3.35-20','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(145,'1-1/2\' leangth 3 s single jack pipe straight oper jali   ڈیدھ فٹ لمبا تین سوترسنگل  جیک پائپ.  سیدھا اوپر جالی عام فتنگ',1,'single',1,NULL,NULL,86,134,NULL,NULL,NULL,'inclusive',1,5.0000,'G3.34-21','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(146,'1-1/2\' leangth 4 s double jack pipe straight   ڈیڈھ فٹ لمباچارسوترڈبل جیک پائپ سیدھا عام فتنگ',1,'single',1,NULL,NULL,73,134,NULL,NULL,NULL,'inclusive',1,5.0000,'G3.48-22','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(147,'1-1/2\' leangth 4 s single jack pipe straight  ڈیڈھ فٹ لمبا چار سوترسنگل جیک پائپ سیدھا عام فتنگ',1,'single',1,NULL,NULL,74,134,NULL,NULL,NULL,'inclusive',1,5.0000,'G3.18-23','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(148,'1-1/2\"  bore leangth pcs1    ڈیڈھ انچ بورلمبائی ٹکڑا',1,'single',18,NULL,NULL,80,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.21/25/29/33-216','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(149,'1-1/2\"  bore leangth pcs2    ڈیڈھ انچ بورلمبائی ٹکڑا',1,'single',18,NULL,NULL,80,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.21/25/29/33-219','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(150,'1-1/2\"  bore leangth piece    ڈیڈھ انچ بورلمبائی ٹکڑا',1,'single',18,NULL,NULL,80,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.21/25/29/33-10','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(151,'1-1/2\"  bore leangth piece    ڈیڈھ انچ بورلمبائی ٹکڑا',1,'single',18,NULL,NULL,80,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.21/25/29/33-214','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(152,'1-1/2\"  bore leangth piece    ڈیڈھ انچ بورلمبائی ٹکڑا',1,'single',18,NULL,NULL,80,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.21/25/29/33-215','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(153,'1-1/2\"  bore leangth piece    ڈیڈھ انچ بورلمبائی ٹکڑا',1,'single',18,NULL,NULL,80,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.21/25/29/33-218','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(154,'1-1/2\"  bore leangth piece pcs1    ڈیڈھ انچ بورلمبائی ٹکڑا',1,'single',18,NULL,NULL,80,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.21/25/29/33-217','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(155,'1-1/2\" bore   6\'\' leangth black           ڈیڈھ بور چھ انچ کالالمبا',1,'single',1,NULL,NULL,74,138,NULL,NULL,NULL,'inclusive',1,5.0000,'G5.18-2','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(156,'1-1/2\" bore   6\'\' leangth black           ڈیڈھ بور چھ انچ کالالمبا',1,'single',1,NULL,NULL,95,144,NULL,NULL,NULL,'inclusive',1,5.0000,'G11.on glass rack-2','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(157,'1-1/2\" bore  4\'\' leangth black           ڈیڈھ بور چار انچ کالالمبا',1,'single',1,NULL,NULL,74,138,NULL,NULL,NULL,'inclusive',1,5.0000,'G5.18-3','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(158,'1-1/2\" bore (8x14) L ڈیڈھ انچ بور 14*8 ایل btr',1,'single',1,NULL,NULL,100,145,NULL,NULL,NULL,'inclusive',1,5.0000,'G2.74-2','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(159,'1-1/2\" bore 1.5\' leangth  ڈیڈھ انچ بورڈیڈھ فٹ لمبی',1,'single',1,NULL,NULL,101,138,NULL,NULL,NULL,'inclusive',1,5.0000,'G5.49-4','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(160,'1-1/2\" bore 2\' leangth  ڈیڈھ انچ بوردو فٹ لمبی',1,'single',1,NULL,NULL,101,138,NULL,NULL,NULL,'inclusive',1,5.0000,'G5.49-5','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(161,'1-1/2\" bore 3\'  leangth   ڈیڈھ انچ بور تین فٹ لمبی لینتھ',1,'single',1,NULL,NULL,96,146,NULL,NULL,NULL,'inclusive',1,5.0000,'G12.open-6','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(162,'1-1/2\" bore 3\' leangth   ڈیڈھ انچ بور تین فٹ لمبی لینتھ',1,'single',1,NULL,NULL,96,144,NULL,NULL,NULL,'inclusive',1,5.0000,'G11.open-29','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(163,'1-1/2\" bore 3\' leangth   ڈیڈھ انچ بورتین فٹ لمبی',1,'single',1,NULL,NULL,101,138,NULL,NULL,NULL,'inclusive',1,5.0000,'G5.49-6','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(164,'1-1/2\" bore 3\' leangth  ڈیڈھ انچ بورتین فٹ لمبی لینتھ',1,'single',1,NULL,NULL,82,137,NULL,NULL,NULL,'inclusive',1,5.0000,'G4.51-2','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(165,'1-1/2\" bore 4x4 L     ڈیڈھ انچ بور 4*4 ایل',1,'single',1,NULL,NULL,102,137,NULL,NULL,NULL,'inclusive',1,5.0000,'G4.25-3','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(166,'1-1/2\" bore 6*4\" leangth L  لڈیڈھ انچ بور4*6 انچ لمبائی ایل',1,'single',1,NULL,NULL,103,137,NULL,NULL,NULL,'inclusive',1,5.0000,'G4.93-4','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(167,'1-1/2\" bore 6+4\" L   \" ڈیڈھ انچ بور ایل 4+6',1,'single',1,NULL,NULL,104,145,NULL,NULL,NULL,'inclusive',1,5.0000,'G2.151-3','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(168,'1-1/2\" bore bay small geniun     ڈیڈھ انچ بور ب چھوٹی جینین',1,'single',1,NULL,NULL,99,144,NULL,NULL,NULL,'inclusive',1,5.0000,'G11.on a glass rack-153','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(169,'1-1/2\" bore bay small hydrolic ڈیڈھ انچ بور ب چھوٹی ہیڈرالک',1,'single',1,NULL,NULL,105,145,NULL,NULL,NULL,'inclusive',1,5.0000,'G2.39-4','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(170,'1-1/2\" bore double bend ڈیڈھ انچ بور ڈپل بینڈ btr',1,'single',1,NULL,NULL,106,145,NULL,NULL,NULL,'inclusive',1,5.0000,'G2.114-5','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(171,'1-1/2\" bore double bend ڈیڈھ انچ بور ڈپل بینڈ urc',1,'single',1,NULL,NULL,106,145,NULL,NULL,NULL,'inclusive',1,5.0000,'G2.114-6','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(172,'1-1/2\" bore L (10x6)      ڈیڈھ انچ بور ایل6*10',1,'single',1,NULL,NULL,107,145,NULL,NULL,NULL,'inclusive',1,5.0000,'G2.64-7','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(173,'1-1/2\" bore s  pipe 1-1/2\"بور ایس پائپ',1,'single',1,NULL,NULL,108,145,NULL,NULL,NULL,'inclusive',1,5.0000,'G2.17-8','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:24','2024-12-04 16:35:24'),(174,'1-1/2\" bore small bay ڈیڈھ انچ بور چھوٹی ب',1,'single',1,NULL,NULL,105,138,NULL,NULL,NULL,'inclusive',1,5.0000,'G5.39-7','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(175,'1-1/2\" bore turbo piece          ڈیڈھ بور ٹربو ٹکڑا',1,'single',1,NULL,NULL,95,144,NULL,NULL,NULL,'inclusive',1,5.0000,'G11.on glass rack-3','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(176,'1-1/2+2 bore L  khula  tang  دو+ڈیڈھ بور ایل کھلا تنگ',1,'single',1,NULL,NULL,73,137,NULL,NULL,NULL,'inclusive',1,5.0000,'G4.48-5','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(177,'1-1/2s caben pipe marsedeez  pvc        ڈیڈھ سوتر کیبن پائپ مرسیڈیز پی وی سی',1,'single',18,NULL,NULL,96,146,NULL,NULL,NULL,'inclusive',1,5.0000,'G12.open-10','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(178,'1-1/2s caben pipe marsedeez  pvc        ڈیڈھ سوتر کیبن پائپ مرسیڈیز پی وی سی',1,'single',18,NULL,NULL,96,146,NULL,NULL,NULL,'inclusive',1,5.0000,'G12.open-11','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(179,'1-1/2s caben pipe marsedeez  pvc        ڈیڈھ سوتر کیبن پائپ مرسیڈیز پی وی سی',1,'single',18,NULL,NULL,96,146,NULL,NULL,NULL,'inclusive',1,5.0000,'G12.open-12','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(180,'1-1/2s caben pipe marsedeez  pvc        ڈیڈھ سوتر کیبن پائپ مرسیڈیز پی وی سی',1,'single',18,NULL,NULL,96,146,NULL,NULL,NULL,'inclusive',1,5.0000,'G12.open-13','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(181,'1-1/2s caben pipe marsedeez  pvc        ڈیڈھ سوتر کیبن پائپ مرسیڈیز پی وی سی',1,'single',18,NULL,NULL,96,146,NULL,NULL,NULL,'inclusive',1,5.0000,'G12.open-14','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(182,'1-1/2s caben pipe marsedeez  pvc        ڈیڈھ سوتر کیبن پائپ مرسیڈیز پی وی سی',1,'single',18,NULL,NULL,96,146,NULL,NULL,NULL,'inclusive',1,5.0000,'G12.open-15','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(183,'1-1/2s caben pipe marsedeez  pvc        ڈیڈھ سوتر کیبن پائپ مرسیڈیز پی وی سی',1,'single',18,NULL,NULL,96,146,NULL,NULL,NULL,'inclusive',1,5.0000,'G12.open-16','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(184,'1-1/2s caben pipe marsedeez  pvc        ڈیڈھ سوتر کیبن پائپ مرسیڈیز پی وی سی',1,'single',18,NULL,NULL,96,146,NULL,NULL,NULL,'inclusive',1,5.0000,'G12.open-17','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(185,'1-1/2s caben pipe marsedeez  pvc        ڈیڈھ سوتر کیبن پائپ مرسیڈیز پی وی سی',1,'single',18,NULL,NULL,96,146,NULL,NULL,NULL,'inclusive',1,5.0000,'G12.open-18','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(186,'1-1/2s caben pipe marsedeez  pvc        ڈیڈھ سوتر کیبن پائپ مرسیڈیز پی وی سی',1,'single',18,NULL,NULL,96,146,NULL,NULL,NULL,'inclusive',1,5.0000,'G12.open-19','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(187,'1-1/2s caben pipe marsedeez  pvc        ڈیڈھ سوتر کیبن پائپ مرسیڈیز پی وی سی',1,'single',18,NULL,NULL,96,146,NULL,NULL,NULL,'inclusive',1,5.0000,'G12.open-20','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(188,'1-1/2s caben pipe marsedeez  pvc        ڈیڈھ سوتر کیبن پائپ مرسیڈیز پی وی سی',1,'single',18,NULL,NULL,96,146,NULL,NULL,NULL,'inclusive',1,5.0000,'G12.open-21','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(189,'1-1/2s caben pipe marsedeez  pvc        ڈیڈھ سوتر کیبن پائپ مرسیڈیز پی وی سی',1,'single',18,NULL,NULL,96,146,NULL,NULL,NULL,'inclusive',1,5.0000,'G12.open-22','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(190,'1-1/2s caben pipe marsedeez  pvc        ڈیڈھ سوتر کیبن پائپ مرسیڈیز پی وی سی',1,'single',18,NULL,NULL,96,146,NULL,NULL,NULL,'inclusive',1,5.0000,'G12.open-23','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(191,'1-1/2s caben pipe marsedeez  pvc        ڈیڈھ سوتر کیبن پائپ مرسیڈیز پی وی سی',1,'single',18,NULL,NULL,96,146,NULL,NULL,NULL,'inclusive',1,5.0000,'G12.open-24','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(192,'1-1/2s caben pipe marsedeez  pvc        ڈیڈھ سوتر کیبن پائپ مرسیڈیز پی وی سی',1,'single',18,NULL,NULL,96,146,NULL,NULL,NULL,'inclusive',1,5.0000,'G12.open-25','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(193,'1-1/2s caben pipe marsedeez  pvc        ڈیڈھ سوتر کیبن پائپ مرسیڈیز پی وی سی',1,'single',18,NULL,NULL,96,146,NULL,NULL,NULL,'inclusive',1,5.0000,'G12.open-26','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(194,'1-1/2s caben pipe marsedeez  pvc        ڈیڈھ سوتر کیبن پائپ مرسیڈیز پی وی سی',1,'single',18,NULL,NULL,96,146,NULL,NULL,NULL,'inclusive',1,5.0000,'G12.open-27','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(195,'1-1/2s caben pipe marsedeez  pvc        ڈیڈھ سوتر کیبن پائپ مرسیڈیز پی وی سی',1,'single',18,NULL,NULL,96,146,NULL,NULL,NULL,'inclusive',1,5.0000,'G12.open-28','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(196,'1-1/2s caben pipe marsedeez  pvc        ڈیڈھ سوتر کیبن پائپ مرسیڈیز پی وی سی',1,'single',18,NULL,NULL,96,146,NULL,NULL,NULL,'inclusive',1,5.0000,'G12.open-29','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(197,'1-1/2s caben pipe marsedeez  pvc        ڈیڈھ سوتر کیبن پائپ مرسیڈیز پی وی سی',1,'single',18,NULL,NULL,96,146,NULL,NULL,NULL,'inclusive',1,5.0000,'G12.open-30','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(198,'1-1/2s caben pipe marsedeez  pvc        ڈیڈھ سوتر کیبن پائپ مرسیڈیز پی وی سی',1,'single',18,NULL,NULL,96,146,NULL,NULL,NULL,'inclusive',1,5.0000,'G12.open-31','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(199,'1-1/2s caben pipe marsedeez  pvc        ڈیڈھ سوتر کیبن پائپ مرسیڈیز پی وی سی',1,'single',18,NULL,NULL,96,146,NULL,NULL,NULL,'inclusive',1,5.0000,'G12.open-32','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(200,'1-1/2s caben pipe marsedeez  pvc        ڈیڈھ سوتر کیبن پائپ مرسیڈیز پی وی سی',1,'single',18,NULL,NULL,96,146,NULL,NULL,NULL,'inclusive',1,5.0000,'G12.open-33','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(201,'1-1/2s caben pipe marsedeez  pvc        ڈیڈھ سوتر کیبن پائپ مرسیڈیز پی وی سی',1,'single',18,NULL,NULL,96,146,NULL,NULL,NULL,'inclusive',1,5.0000,'G12.open-34','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(202,'1-1/2s caben pipe marsedeez  pvc        ڈیڈھ سوتر کیبن پائپ مرسیڈیز پی وی سی',1,'single',18,NULL,NULL,96,146,NULL,NULL,NULL,'inclusive',1,5.0000,'G12.open-35','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(203,'1-1/2s caben pipe marsedeez  pvc        ڈیڈھ سوتر کیبن پائپ مرسیڈیز پی وی سی',1,'single',18,NULL,NULL,96,146,NULL,NULL,NULL,'inclusive',1,5.0000,'G12.open-36','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(204,'1-1/2s caben pipe marsedeez  pvc        ڈیڈھ سوتر کیبن پائپ مرسیڈیز پی وی سی',1,'single',18,NULL,NULL,96,146,NULL,NULL,NULL,'inclusive',1,5.0000,'G12.open-37','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(205,'1-1/2s caben pipe marsedeez  pvc        ڈیڈھ سوتر کیبن پائپ مرسیڈیز پی وی سی',1,'single',18,NULL,NULL,96,146,NULL,NULL,NULL,'inclusive',1,5.0000,'G12.open-38','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(206,'1-1/2s caben pipe marsedeez  pvc        ڈیڈھ سوتر کیبن پائپ مرسیڈیز پی وی سی',1,'single',18,NULL,NULL,96,146,NULL,NULL,NULL,'inclusive',1,5.0000,'G12.open-39','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(207,'1-1/2s caben pipe marsedeez  pvc        ڈیڈھ سوتر کیبن پائپ مرسیڈیز پی وی سی',1,'single',18,NULL,NULL,96,146,NULL,NULL,NULL,'inclusive',1,5.0000,'G12.open-40','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(208,'1-1/2s caben pipe marsedeez  pvc        ڈیڈھ سوتر کیبن پائپ مرسیڈیز پی وی سی',1,'single',18,NULL,NULL,96,146,NULL,NULL,NULL,'inclusive',1,5.0000,'G12.open-41','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(209,'1-1/2s caben pipe marsedeez  pvc        ڈیڈھ سوتر کیبن پائپ مرسیڈیز پی وی سی',1,'single',18,NULL,NULL,96,146,NULL,NULL,NULL,'inclusive',1,5.0000,'G12.open-42','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(210,'1-1/2s caben pipe marsedeez  pvc        ڈیڈھ سوتر کیبن پائپ مرسیڈیز پی وی سی',1,'single',18,NULL,NULL,96,146,NULL,NULL,NULL,'inclusive',1,5.0000,'G12.open-43','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(211,'1-1/2x2\"  bore 6\" leangth     ڈیڈھ+دو  بور چھ انچ لمبا',1,'single',1,NULL,NULL,109,138,NULL,NULL,NULL,'inclusive',1,5.0000,'G5.5-8','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(212,'1-1/2x2\",4\" bore leangth          ڈیڈھ+ دو بور چار انچ لمبا',1,'single',1,NULL,NULL,109,138,NULL,NULL,NULL,'inclusive',1,5.0000,'G5.5-9','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(213,'1-1/4\"  bore iron wire  leangth piece    سوا انچ بورلمبائی لوہا تارٹکڑا',1,'single',18,NULL,NULL,80,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.21/25/29/33-11','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(214,'1-1/4\"  bore leangth pcs1    سوا انچ بورلمبائی ٹکڑا',1,'single',18,NULL,NULL,80,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.21/25/29/33-222','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(215,'1-1/4\"  bore leangth pcs1    سوا انچ بورلمبائی ٹکڑا',1,'single',18,NULL,NULL,80,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.21/25/29/33-224','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(216,'1-1/4\"  bore leangth pcs2    سوا انچ بورلمبائی ٹکڑا',1,'single',18,NULL,NULL,80,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.21/25/29/33-225','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(217,'1-1/4\"  bore leangth pcs2    سوا انچ بورلمبائی ٹکڑا',1,'single',18,NULL,NULL,80,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.21/25/29/33-228','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(218,'1-1/4\"  bore leangth pcs3    سوا انچ بورلمبائی ٹکڑا',1,'single',18,NULL,NULL,80,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.21/25/29/33-226','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(219,'1-1/4\"  bore leangth pcs4    سوا انچ بورلمبائی ٹکڑا',1,'single',18,NULL,NULL,80,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.21/25/29/33-227','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(220,'1-1/4\"  bore leangth piece    سوا انچ بورلمبائی ٹکڑا',1,'single',18,NULL,NULL,80,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.21/25/29/33-12','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(221,'1-1/4\"  bore leangth piece    سوا انچ بورلمبائی ٹکڑا',1,'single',18,NULL,NULL,80,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.21/25/29/33-220','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(222,'1-1/4\"  bore leangth piece    سوا انچ بورلمبائی ٹکڑا',1,'single',18,NULL,NULL,80,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.21/25/29/33-221','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(223,'1-1/4\"  bore leangth piece    سوا انچ بورلمبائی ٹکڑا',1,'single',18,NULL,NULL,80,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.21/25/29/33-223','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(224,'1-1/4\" bore 3\'  leangth   سوا انچ بور تین فٹ لمبی لینتھ',1,'single',1,NULL,NULL,96,146,NULL,NULL,NULL,'inclusive',1,5.0000,'G12.open-7','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(225,'1-1/4\" bore 3\' leangth   سوا انچ بور تین فٹ لمبی لینتھ',1,'single',1,NULL,NULL,96,144,NULL,NULL,NULL,'inclusive',1,5.0000,'G11.open-30','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(226,'1-1/4\" bore 3\' leangth   سوا دو انچ بور تین فٹ لمبی',1,'single',1,NULL,NULL,101,138,NULL,NULL,NULL,'inclusive',1,5.0000,'G5.49-10','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(227,'1-1/4\"x1-3/4\" piece سوا  انچ +پونے دو ٹکڑا',1,'single',1,NULL,NULL,95,144,NULL,NULL,NULL,'inclusive',1,5.0000,'G11.on glass rack-14','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(228,'1-3/4 bore same as corola 86 diesel lower کرولا 86 ڈیزل لوئر کی طرح پونے دو بور',1,'single',1,NULL,NULL,110,145,NULL,NULL,NULL,'inclusive',1,5.0000,'G2.140-9','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(229,'1-3/4 bore same as corola 86 diesel upper کرولا 86 ڈیزل اپر کی طرح پونے دو بور',1,'single',1,NULL,NULL,110,145,NULL,NULL,NULL,'inclusive',1,5.0000,'G2.140-10','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(230,'1-3/4 L same as mazda 3500 upper پونے دو بور ایل مزدا 3500  اپر کی طرح',1,'single',1,NULL,NULL,111,145,NULL,NULL,NULL,'inclusive',1,5.0000,'G2.60-11','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(231,'1-3/4\" bore  leangth      پونے دو انچ بور مکمل لینتھ 21فٹ پرلینتھ',1,'single',18,NULL,NULL,96,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.open-315','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(232,'1-3/4\" bore  leangth      پونے دو انچ بور مکمل لینتھ 65فٹ پرلینتھ',1,'single',18,NULL,NULL,96,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.open-316','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(233,'1-3/4\" bore 3\' leangth    پونے دو بورتین فٹ لمبی لینتھ',1,'single',1,NULL,NULL,82,137,NULL,NULL,NULL,'inclusive',1,5.0000,'G4.51-7','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(234,'1-3/4\" bore complete leangth        پونے دو انچ بور مکمل لینتھ 65فٹ پرلینتھ pcs1',1,'single',18,NULL,NULL,96,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.open-317','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(235,'1-3/4\" bore complete leangth        پونے دو انچ بور مکمل لینتھ 65فٹ پرلینتھ pcs2',1,'single',18,NULL,NULL,96,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.open-318','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(236,'1-3/4\" bore hydrolic same as khaber  tanki pipe خیبر ٹینکی پائپ کی طرح پونے دو بور ہیڈرالک',1,'single',1,NULL,NULL,112,145,NULL,NULL,NULL,'inclusive',1,5.0000,'G2.127-12','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(237,'1-3/4\" bore s same as 2d upper پونے دو بور ایس ٹو ڈی اپر کی  طرح',1,'single',1,NULL,NULL,113,145,NULL,NULL,NULL,'inclusive',1,5.0000,'G2.83-13','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(238,'1-3/4\" lower  6x4 L',1,'single',1,NULL,NULL,74,137,NULL,NULL,NULL,'inclusive',1,5.0000,'G4.18-8','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(239,'1-3/4+2-1/2 khuli tang botal پونے دو +اڑھائی کھلی تنگ بوتل',1,'single',1,NULL,NULL,114,145,NULL,NULL,NULL,'inclusive',1,5.0000,'G2.24-14','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(240,'1-3/4x2-1/4\" bore 4\" leangth       سوا دو+پونے دو بور  چار انچ لمبا',1,'single',1,NULL,NULL,109,138,NULL,NULL,NULL,'inclusive',1,5.0000,'G5.5-13','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(241,'1-3/4x2-1/4\" bore 6\" leangth       سوا دو+پونے دو بور  چھ انچ لمبا',1,'single',1,NULL,NULL,115,138,NULL,NULL,NULL,'inclusive',1,5.0000,'G5.47-14','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(242,'1-3/4x2\" bore 4\'\' leangth          دو+پونے تین بور چار انچ لمبا',1,'single',1,NULL,NULL,109,138,NULL,NULL,NULL,'inclusive',1,5.0000,'G5.5-11','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(243,'1-3/4x2\" bore 6\'\' leangth           دو+پونے دو بور  چھ انچ لمبا',1,'single',1,NULL,NULL,109,138,NULL,NULL,NULL,'inclusive',1,5.0000,'G5.5-12','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(244,'1.5\'  leangth boster pipe both side kunda   ڈیڈھ فٹ لمبا بوسٹر پائپ دونوں طرف کنڈاچائنہ فٹنگ',1,'single',1,NULL,NULL,77,134,NULL,NULL,NULL,'inclusive',1,5.0000,'G3.40-12','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(245,'1.5\'  leangth boster pipe both side kunda   ڈیڈھ فٹ لمبا بوسٹر پائپ دونوں طرف کنڈاچائنہ فٹنگ',1,'single',1,NULL,NULL,99,144,NULL,NULL,NULL,'inclusive',1,5.0000,'G11.on a glass rack-182','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:25','2024-12-04 16:35:25'),(246,'1\' leangth 3 s double jack pipe   ایک فٹ لمبا تین سوترڈبل جیک پائپ. چائینہ فتنگ',1,'single',1,NULL,NULL,69,134,NULL,NULL,NULL,'inclusive',1,5.0000,'G3.19-1','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(247,'1\' leangth 3 s single jack pipe straight   ایک فٹ لمباتین سوترسنگل جیک پائپ سیدھا عام  فتنگ',1,'single',1,NULL,NULL,70,134,NULL,NULL,NULL,'inclusive',1,5.0000,'G3.35-2','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(248,'1\' leangth 3 s single marsadeez satairing pipe one side bahir chore & other side bend 18x1.5 ایک فت  لمبا 3سوتر سنگل مرسڈیز سٹیرنگ پائپ ایک طرف  باہر چوڑی اور دوسری  طرف  بینڈ    1.5*18',1,'single',1,NULL,NULL,71,134,NULL,NULL,NULL,'inclusive',1,5.0000,'G3.23-3','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(249,'1\' leangth 4 s double 375 unit hoki wala ایک فٹ لمبا4سوتر ڈبل 375 یونٹ ہکی والا',1,'single',1,NULL,NULL,72,134,NULL,NULL,NULL,'inclusive',1,5.0000,'G3.3-4','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(250,'1\' leangth 4 s double 375 unit straight ایک فٹ لمبا4سوتر ڈبل 375 یونٹ سیدھا',1,'single',1,NULL,NULL,72,134,NULL,NULL,NULL,'inclusive',1,5.0000,'G3.3-5','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(251,'1\' leangth 4 s double jack pipe straight   ایک فٹ لمباچارسوترڈبل جیک پائپ سیدھا عام فتنگ',1,'single',1,NULL,NULL,73,134,NULL,NULL,NULL,'inclusive',1,5.0000,'G3.48-6','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(252,'1\' leangth 4 s single jack pipe   ایک فٹ لمبا چار سوترسنگل جیک پائپ. عام فتنگ',1,'single',1,NULL,NULL,74,134,NULL,NULL,NULL,'inclusive',1,5.0000,'G3.18-7','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(253,'1\' leangth 7 s hydrolic pipe with out fitting   ایک فٹ لمبا سات سوتر ہیڈرالک پائپ بغیر فتنگ',1,'single',1,NULL,NULL,75,134,NULL,NULL,NULL,'inclusive',1,5.0000,'G3.14-8','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(254,'1\' leangth boster pipe both side t  ایک فٹ لمبا بوسٹر پائپ دونوں  طرف ٹی',1,'single',1,NULL,NULL,76,134,NULL,NULL,NULL,'inclusive',1,5.0000,'G3.53-9','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(255,'1\' leangth boster/ brake pipe both sides andar kunda    ایک فٹ لمبابوسٹر /بریک پائپ دونو ں طرف اندر کنڈا چائنہ  فتنگ',1,'single',1,NULL,NULL,77,134,NULL,NULL,NULL,'inclusive',1,5.0000,'G3.40-10','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(256,'1\' leangth jecko straight ایک فٹ لمبا جیکو سیدھا',1,'single',1,NULL,NULL,99,144,NULL,NULL,NULL,'inclusive',1,5.0000,'G11.on a glass rack-212','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(257,'1\' leangth mazda brake pipe ایک فٹ لمبا مزدا بریک پائپ',1,'single',1,NULL,NULL,76,134,NULL,NULL,NULL,'inclusive',1,5.0000,'G3.53-11','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(258,'1\"  bore iron wire leangth piece    ایک انچ بورلمبائی لوہا تار ٹکڑا',1,'single',18,NULL,NULL,80,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.21/25/29/33-3','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(259,'1\" bore 2.5\' leangth pieces            ایک  انچ بوراڑھائی فٹ ٹکڑے فرانس',1,'single',1,NULL,NULL,81,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.19/23-4','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(260,'1\" bore 3\' leangth    ایک انچ بورتین فٹ  لمبی لینتھ',1,'single',1,NULL,NULL,82,137,NULL,NULL,NULL,'inclusive',1,5.0000,'G4.51-1','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(261,'1\" bore 3\' leangth    ایک انچ بورتین فٹ  لمبی لینتھ',1,'single',1,NULL,NULL,116,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.80-200','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(262,'1\" bore 3\' leangth pieces            ایک  انچ بورتین فٹ ٹکڑے فرانس',1,'single',1,NULL,NULL,81,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.19/23-5','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(263,'1\" bore 4\' leangth    ایک انچ بورچار فٹ  لمبی لینتھ',1,'single',1,NULL,NULL,116,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.80-201','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(264,'1\" bore black   ایک انچ بور کالا فرانس',1,'single',18,NULL,NULL,69,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.19-152','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(265,'1\" bore black   ایک انچ بور کالا فرانس',1,'single',18,NULL,NULL,69,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.19-154','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(266,'1\" bore black   ایک انچ بور کالا فرانس',1,'single',18,NULL,NULL,69,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.19-155','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(267,'1\" bore black  ایک انچ بور کالا فرانس',1,'single',18,NULL,NULL,69,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.19-151','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(268,'1\" bore black  ایک انچ بور کالا فرانس',1,'single',18,NULL,NULL,69,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.19-153','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(269,'1\" bore colour            ایک  انچ بوررنگین فرانس',1,'single',18,NULL,NULL,81,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.19/23-157','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(270,'1\" bore colour           ایک  انچ بوررنگین فرانس',1,'single',18,NULL,NULL,81,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.19/23-156','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(271,'1\" bore colour           ایک  انچ بوررنگین فرانس',1,'single',18,NULL,NULL,81,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.19/23-158','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(272,'1\" bore colour          ایک  انچ بوررنگین فرانس',1,'single',18,NULL,NULL,81,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.19/23-159','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(273,'1\" bore colour         ایک  انچ بوررنگین فرانس',1,'single',18,NULL,NULL,81,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.19/23-160','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(274,'1\" bore double black            ایک  انچ بورڈبل کالا فرانس',1,'single',18,NULL,NULL,81,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.19/23-163','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(275,'1\" bore double black            ایک  انچ بورڈبل کالا فرانس',1,'single',18,NULL,NULL,81,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.19/23-164','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(276,'1\" bore double black            ایک  انچ بورڈبل کالا فرانس',1,'single',18,NULL,NULL,81,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.19/23-165','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(277,'1\" bore double black            ایک  انچ بورڈبل کالا فرانس',1,'single',18,NULL,NULL,81,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.19/23-166','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(278,'1\" bore double black            ایک  انچ بورڈبل کالا فرانس',1,'single',18,NULL,NULL,81,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.19/23-167','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(279,'1\" bore double black            ایک  انچ بورڈبل کالا فرانس',1,'single',18,NULL,NULL,81,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.19/23-168','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(280,'1\" bore double black            ایک  انچ بورڈبل کالا فرانس',1,'single',18,NULL,NULL,81,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.19/23-169','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(281,'1\" bore double black            ایک  انچ بورڈبل کالا فرانس',1,'single',18,NULL,NULL,81,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.19/23-171','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(282,'1\" bore double black            ایک  انچ بورڈبل کالا فرانس',1,'single',18,NULL,NULL,81,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.19/23-172','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(283,'1\" bore double black            ایک  انچ بورڈبل کالا فرانس',1,'single',18,NULL,NULL,81,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.19/23-173','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(284,'1\" bore double black            ایک  انچ بورڈبل کالا فرانس',1,'single',18,NULL,NULL,81,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.19/23-175','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(285,'1\" bore double black            ایک  انچ بورڈبل کالا فرانس',1,'single',18,NULL,NULL,81,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.19/23-177','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(286,'1\" bore double black            ایک  انچ بورڈبل کالا فرانس',1,'single',18,NULL,NULL,81,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.19/23-178','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(287,'1\" bore double black           ایک  انچ بورڈبل کالا فرانس',1,'single',18,NULL,NULL,81,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.19/23-162','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(288,'1\" bore double black           ایک  انچ بورڈبل کالا فرانس',1,'single',18,NULL,NULL,81,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.19/23-170','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(289,'1\" bore double black           ایک  انچ بورڈبل کالا فرانس',1,'single',18,NULL,NULL,81,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.19/23-174','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(290,'1\" bore double black           ایک  انچ بورڈبل کالا فرانس',1,'single',18,NULL,NULL,81,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.19/23-176','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(291,'1\" bore double black         ایک  انچ بورڈبل کالا فرانس',1,'single',18,NULL,NULL,81,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.19/23-161','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(292,'1\" bore mix  leangth pieces            ایک  انچ بورمکس لمبائی ٹکڑے فرانس',1,'single',1,NULL,NULL,81,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.19/23-6','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(293,'1\" bore mix pieces            ایک  انچ بورمکس ٹکڑے فرانس',1,'single',1,NULL,NULL,81,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.19/23-7','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(294,'1\" bore single black            ایک  انچ بورسنگل کالا فرانس',1,'single',18,NULL,NULL,81,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.19/23-180','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(295,'1\" bore single black            ایک  انچ بورسنگل کالا فرانس',1,'single',18,NULL,NULL,81,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.19/23-181','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(296,'1\" bore single black            ایک  انچ بورسنگل کالا فرانس',1,'single',18,NULL,NULL,81,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.19/23-182','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(297,'1\" bore single black            ایک  انچ بورسنگل کالا فرانس',1,'single',18,NULL,NULL,81,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.19/23-183','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(298,'1\" bore single black            ایک  انچ بورسنگل کالا فرانس',1,'single',18,NULL,NULL,81,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.19/23-184','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(299,'1\" bore single black            ایک  انچ بورسنگل کالا فرانس',1,'single',18,NULL,NULL,81,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.19/23-185','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(300,'1\" bore single black            ایک  انچ بورسنگل کالا فرانس',1,'single',18,NULL,NULL,81,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.19/23-186','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(301,'1\" bore single black            ایک  انچ بورسنگل کالا فرانس',1,'single',18,NULL,NULL,81,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.19/23-187','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(302,'1\" bore single black            ایک  انچ بورسنگل کالا فرانس',1,'single',18,NULL,NULL,81,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.19/23-188','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(303,'1\" bore single black            ایک  انچ بورسنگل کالا فرانس',1,'single',18,NULL,NULL,81,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.19/23-189','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(304,'1\" bore single black            ایک  انچ بورسنگل کالا فرانس',1,'single',18,NULL,NULL,81,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.19/23-191','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(305,'1\" bore single black            ایک  انچ بورسنگل کالا فرانس',1,'single',18,NULL,NULL,81,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.19/23-192','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(306,'1\" bore single black            ایک  انچ بورسنگل کالا فرانس',1,'single',18,NULL,NULL,81,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.19/23-193','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(307,'1\" bore single black            ایک  انچ بورسنگل کالا فرانس',1,'single',18,NULL,NULL,81,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.19/23-197','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(308,'1\" bore single black            ایک  انچ بورسنگل کالا فرانس',1,'single',18,NULL,NULL,81,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.19/23-198','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(309,'1\" bore single black            ایک  انچ بورسنگل کالا فرانس',1,'single',18,NULL,NULL,96,148,NULL,NULL,NULL,'inclusive',1,5.0000,'G14.open-18','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(310,'1\" bore single black            ایک  انچ بورسنگل کالا فرانس',1,'single',18,NULL,NULL,96,148,NULL,NULL,NULL,'inclusive',1,5.0000,'G14.open-231','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(311,'1\" bore single black            ایک  انچ بورسنگل کالا فرانس',1,'single',18,NULL,NULL,96,148,NULL,NULL,NULL,'inclusive',1,5.0000,'G14.open-232','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(312,'1\" bore single black            ایک  انچ بورسنگل کالا فرانس',1,'single',18,NULL,NULL,96,148,NULL,NULL,NULL,'inclusive',1,5.0000,'G14.open-233','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(313,'1\" bore single black            ایک  انچ بورسنگل کالا فرانس',1,'single',18,NULL,NULL,96,148,NULL,NULL,NULL,'inclusive',1,5.0000,'G14.open-234','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(314,'1\" bore single black            ایک  انچ بورسنگل کالا فرانس',1,'single',18,NULL,NULL,96,148,NULL,NULL,NULL,'inclusive',1,5.0000,'G14.open-235','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(315,'1\" bore single black            ایک  انچ بورسنگل کالا فرانس',1,'single',18,NULL,NULL,96,148,NULL,NULL,NULL,'inclusive',1,5.0000,'G14.open-236','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(316,'1\" bore single black            ایک  انچ بورسنگل کالا فرانس',1,'single',18,NULL,NULL,96,148,NULL,NULL,NULL,'inclusive',1,5.0000,'G14.open-237','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(317,'1\" bore single black            ایک  انچ بورسنگل کالا فرانس',1,'single',18,NULL,NULL,96,148,NULL,NULL,NULL,'inclusive',1,5.0000,'G14.open-238','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(318,'1\" bore single black            ایک  انچ بورسنگل کالا فرانس',1,'single',18,NULL,NULL,96,148,NULL,NULL,NULL,'inclusive',1,5.0000,'G14.open-239','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(319,'1\" bore single black            ایک  انچ بورسنگل کالا فرانس',1,'single',18,NULL,NULL,96,148,NULL,NULL,NULL,'inclusive',1,5.0000,'G14.open-240','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(320,'1\" bore single black            ایک  انچ بورسنگل کالا فرانس',1,'single',18,NULL,NULL,96,148,NULL,NULL,NULL,'inclusive',1,5.0000,'G14.open-241','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:26','2024-12-04 16:35:26'),(321,'1\" bore single black            ایک  انچ بورسنگل کالا فرانس',1,'single',18,NULL,NULL,96,148,NULL,NULL,NULL,'inclusive',1,5.0000,'G14.open-242','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(322,'1\" bore single black            ایک  انچ بورسنگل کالا فرانس',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-14','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(323,'1\" bore single black           ایک  انچ بورسنگل کالا فرانس',1,'single',18,NULL,NULL,81,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.19/23-190','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(324,'1\" bore single black           ایک  انچ بورسنگل کالا فرانس',1,'single',18,NULL,NULL,81,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.19/23-194','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(325,'1\" bore single black           ایک  انچ بورسنگل کالا فرانس',1,'single',18,NULL,NULL,81,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.19/23-195','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(326,'1\" bore single black           ایک  انچ بورسنگل کالا فرانس',1,'single',18,NULL,NULL,81,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.19/23-196','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(327,'1\" bore single black          ایک  انچ بورسنگل کالا فرانس',1,'single',18,NULL,NULL,81,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.19/23-179','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(328,'1\" bore single black        31ft    ایک  انچ بورسنگل کالا فرانس',1,'single',18,NULL,NULL,117,144,NULL,NULL,NULL,'inclusive',1,5.0000,'G11.Under glasses rack-109','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(329,'1\" bore single mix pieces           ایک  انچ بورسنگل کالا فرانس',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-15','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(330,'1/2-20*1.5c (1/2*20t)   جیکو 20 کی ٹی',1,'single',1,NULL,NULL,95,144,NULL,NULL,NULL,'inclusive',1,5.0000,'G11.on glass rack-36','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(331,'1/2-20*1.5c (1/2*20t)   جیکو 20 کی ٹی',1,'single',1,NULL,NULL,94,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.Display cabinet-229','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(332,'1/2*1.20*1.5d   ( آدھی مکمل فٹنگ (چار سوتر پائپ فٹنگ',1,'single',1,NULL,NULL,95,144,NULL,NULL,NULL,'inclusive',1,5.0000,'G11.on glass rack-87','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(333,'1/2*1.20*1.5d   ( آدھی مکمل فٹنگ (چار سوتر پائپ فٹنگ',1,'single',1,NULL,NULL,94,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.Display cabinet-237','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(334,'1/2*1/2 bsp  جیکو آڈپٹر',1,'single',1,NULL,NULL,95,144,NULL,NULL,NULL,'inclusive',1,5.0000,'G11.on glass rack-44','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(335,'1/2*1/2t 1/2 bsp   ( جیکو برابر (جیکو جمع جیکو',1,'single',1,NULL,NULL,95,144,NULL,NULL,NULL,'inclusive',1,5.0000,'G11.on glass rack-37','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(336,'1/2x1/2 bsp  جیکو آڈپٹر',1,'single',1,NULL,NULL,95,144,NULL,NULL,NULL,'inclusive',1,5.0000,'G11.on glass rack-91','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(337,'1/4*12.50       (فیرل بمہ نٹ  نوزل 2سوتر۔5/32 (12.5',1,'single',1,NULL,NULL,95,144,NULL,NULL,NULL,'inclusive',1,5.0000,'G11.on glass rack-40','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(338,'10 cylender L دس سلنڈر ایل',1,'single',1,NULL,NULL,71,138,NULL,NULL,NULL,'inclusive',1,5.0000,'G5.23-1','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(339,'10\' leangth 3 s double jack pipe   دس فٹ لمبا تین سوترڈبل جیک پائپ. چائینہ فتنگ',1,'single',1,NULL,NULL,69,134,NULL,NULL,NULL,'inclusive',1,5.0000,'G3.19-13','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(340,'10\' leangth 4 s double دس فٹ لمبا چار سوتر ڈبل چائنہ فٹنگ',1,'single',1,NULL,NULL,75,134,NULL,NULL,NULL,'inclusive',1,5.0000,'G3.14-14','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(341,'10\" leangth boster pipe both side t    دس انچ لمبا بوسٹر پائپ دونوں  طرف ٹی',1,'single',1,NULL,NULL,76,134,NULL,NULL,NULL,'inclusive',1,5.0000,'G3.53-15','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(342,'10*1*20*1.5   ( 3/8چوڑی والی فٹنگ (تین سوتر مکمل فٹنگ',1,'single',1,NULL,NULL,95,144,NULL,NULL,NULL,'inclusive',1,5.0000,'G11.on glass rack-42','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(343,'10*16mm  سولہ ملی کھلا کنڈا واپسی',1,'single',1,NULL,NULL,95,144,NULL,NULL,NULL,'inclusive',1,5.0000,'G11.on glass rack-85','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(344,'10*18*1.5 مرسیڈیز والی باہر چوڑی',1,'single',1,NULL,NULL,95,144,NULL,NULL,NULL,'inclusive',1,5.0000,'G11.on glass rack-43','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(345,'11\" leangth 3 s single marsadeez satairing  pipe both side bahir chore oper jali      18x1.5 گیارہ انچ لمبا تین سوتر سنگل مرسیڈیز سٹیرنگ پائپ دونوں طرف باہر چوڑی اوپر جالی',1,'single',1,NULL,NULL,83,134,NULL,NULL,NULL,'inclusive',1,5.0000,'G3.26-16','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(346,'11\" leangth 3 s single marsadeez satairing  pipe both side bahir chore oper jali      18x1.5 گیارہ انچ لمبا تین سوتر سنگل مرسیڈیز سٹیرنگ پائپ دونوں طرف باہر چوڑی اوپر جالی',1,'single',1,NULL,NULL,99,144,NULL,NULL,NULL,'inclusive',1,5.0000,'G11.on a glass rack-179','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(347,'11\" leangth 3 s single marsedeez stairing pipe both sides  chori oper jali china fitting 18*1.5      تیرہ  انچ لمبا تین سوتر سنگل  مرسڈیز سٹیرنگ پائپ دونوں طرف باہر چوڑی 1.5*18 اوپر  جالی',1,'single',1,NULL,NULL,84,134,NULL,NULL,NULL,'inclusive',1,5.0000,'G3.4-17','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(348,'1122 same as bay  ب کی طرح 1122',1,'single',1,NULL,NULL,118,137,NULL,NULL,NULL,'inclusive',1,5.0000,'G4.91-6','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(349,'12 wall ac pipe daee aam wala  12وال ائر  پائپ  ڈائی عام والا',1,'single',1,NULL,NULL,113,135,NULL,NULL,NULL,'inclusive',1,5.0000,'g1.83-3','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(350,'12\' leangth marsadeez bend    بارہ فٹ لمبا مرسیڈیز بینڈ والا',1,'single',1,NULL,NULL,99,144,NULL,NULL,NULL,'inclusive',1,5.0000,'G11.on a glass rack-197','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(351,'12\" leangth 1-1/4 ac  12لمبا سوا بور سوان ائر کلینڈر پائپ کپڑے والا\"',1,'single',1,NULL,NULL,119,135,NULL,NULL,NULL,'inclusive',1,5.0000,'g1.55-5','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(352,'12\" leangth 2-1/2 +3 ac aam 12لمبا اڑھائی+تین بورائر کلینڈر پائپ عام والا\"',1,'single',1,NULL,NULL,108,135,NULL,NULL,NULL,'inclusive',1,5.0000,'g1.17-6','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(353,'12\" leangth 2-1/2 ac aam  12لمبا اڑھائی بور عام ائر کلینڈر پائپ  \"',1,'single',1,NULL,NULL,100,135,NULL,NULL,NULL,'inclusive',1,5.0000,'g1.74-7','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(354,'12\" leangth 2-1/2 ac swan 12لمبا اڑھائی بور سوان ائر کلینڈر پائپ کپڑے والا\"',1,'single',1,NULL,NULL,120,135,NULL,NULL,NULL,'inclusive',1,5.0000,'g1.13-8','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(355,'12\" leangth 2-1/2 parashoot ac 12لمبااڑھائی بور پیراشوٹ  ائر کلینڈر پائپ\"',1,'single',1,NULL,NULL,121,135,NULL,NULL,NULL,'inclusive',1,5.0000,'g1.38-9','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(356,'12\" leangth 2-1/4 3y ac pipe 12لمباسوا دو بور 3وائے پی وی سی ائر کلینڈر پائپ\"',1,'single',1,NULL,NULL,106,135,NULL,NULL,NULL,'inclusive',1,5.0000,'g1.114-10','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(357,'12\" leangth 2-1/4 3y ac pipe 12لمباسوا دو بور 3وائے پی وی سی ائر کلینڈر پائپ\"',1,'single',1,NULL,NULL,122,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.3&4-21','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(358,'12\" leangth 2-1/4 parashoot  ac 12لمباسوا دو بور پیراشوٹ ائر کلینڈر پائپ\"',1,'single',1,NULL,NULL,86,135,NULL,NULL,NULL,'inclusive',1,5.0000,'g1.34-11','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(359,'12\" leangth 2-3/4 soft ac red 12لمبا پونے تین بورنرم ائر کلینڈر پائپ لال\"',1,'single',1,NULL,NULL,123,135,NULL,NULL,NULL,'inclusive',1,5.0000,'g1.59-12','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(360,'12\" leangth 3\" ac pipe بارہ  انچ لمبا تین انچ ائر کلینڈر پائپ',1,'single',1,NULL,NULL,82,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.51-22','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(361,'12\" leangth 5 ac aam     12لمبا پانچ بورعام ایٹر کلینڈر پائپ\"',1,'single',1,NULL,NULL,124,135,NULL,NULL,NULL,'inclusive',1,5.0000,'g1.65-13','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(362,'12\" leangth khula tang chamber ac pipe بارہ انچ لمبا کھلا تنگ چیمبر ائر کلینڈر پائپ',1,'single',1,NULL,NULL,125,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.12&13-23','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(363,'13\" leangth 4 s double marsedeez stairing pipe  bahir chori   22*1.5     تیرہ  انچ لمبا چار سوتر ڈبل مرسڈیز سٹیرنگ پائپ  باہر چوڑی 1.5*22',1,'single',1,NULL,NULL,126,134,NULL,NULL,NULL,'inclusive',1,5.0000,'G3.10-24','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(364,'13\" leangth 4 s single marsedeez stairing pipe both sides  chori oper jali  22*1.5      تیرہ  انچ لمبا چار سوتر سنگل  مرسڈیز سٹیرنگ پائپ دونوں طرف باہر چوڑی 1.5*22 اوپر  جالی',1,'single',1,NULL,NULL,84,134,NULL,NULL,NULL,'inclusive',1,5.0000,'G3.4-25','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(365,'14\" leangth 3 s single marsadeez satairing  pipe bahir chore 18x1.5    چودہ  انچ لمبا تین سوتر سنگل مرسیڈیز سٹیرنگ پائپ باہر چوڑی 1.5*18',1,'single',1,NULL,NULL,83,134,NULL,NULL,NULL,'inclusive',1,5.0000,'G3.26-26','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(366,'14\" leangth 3 s single marsadeez satairing  pipe bahir chore oper jali 18x1.5  چودہ  انچ لمبا تین سوتر سنگل مرسیڈیز سٹیرنگ پائپ باہر چوڑی اوپر جالی 1.5*18',1,'single',1,NULL,NULL,83,134,NULL,NULL,NULL,'inclusive',1,5.0000,'G3.26-27','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(367,'14*20t     14/20کی ٹی',1,'single',1,NULL,NULL,94,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.Display cabinet-230','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(368,'15\" leangth 1-1/2 ac  15لمبا ڈیڈھ بورسوان ایٹر کلینڈر پائپ\"',1,'single',1,NULL,NULL,107,135,NULL,NULL,NULL,'inclusive',1,5.0000,'g1.64-14','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(369,'15\" leangth 1-1/2 soft ac red 15لمبا ڈیڈھ بورنرم ائر کلینڈر پائپ لال\"',1,'single',1,NULL,NULL,123,135,NULL,NULL,NULL,'inclusive',1,5.0000,'g1.59-15','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(370,'15\" leangth 1-1/4 ac  15لمبا سوا بور سوان ائر کلینڈر پائپ کپڑے والا\"',1,'single',1,NULL,NULL,119,135,NULL,NULL,NULL,'inclusive',1,5.0000,'g1.55-16','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(371,'15\" leangth 1-3/4 ac 15لمباپونےدو بور سوان ائر کلینڈر پائپ کپڑے والا\"',1,'single',1,NULL,NULL,127,135,NULL,NULL,NULL,'inclusive',1,5.0000,'g1.50-17','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(372,'15\" leangth 2 parashoot ac radiator pipe 15لمبا دو بور پیراشوٹ ائر کلینڈر ریڈی ایٹر پائپ\"',1,'single',1,NULL,NULL,128,135,NULL,NULL,NULL,'inclusive',1,5.0000,'g1.16-18','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(373,'15\" leangth 2 radiator ac amm  15لمبا دو بور ریڈی ایٹر ائر کلینڈر پائپ\"',1,'single',1,NULL,NULL,129,135,NULL,NULL,NULL,'inclusive',1,5.0000,'g1.43-20','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(374,'15\" leangth 2 radiator ac swan  15لمبا دو بور  ریڈی ائر کلینڈر پائپ\"',1,'single',1,NULL,NULL,99,144,NULL,NULL,NULL,'inclusive',1,5.0000,'G11.on a glass rack-218','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(375,'15\" leangth 2-1/2 ac 15لمبا اڑھائی بور سوان ائر کلینڈر پائپ کپڑے والا\"',1,'single',1,NULL,NULL,130,135,NULL,NULL,NULL,'inclusive',1,5.0000,'g1.11-21','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(376,'15\" leangth 2-1/4 ac aam 15لمبا اڑھائی بورائر کلینڈر پائپ عام والا\"',1,'single',1,NULL,NULL,131,135,NULL,NULL,NULL,'inclusive',1,5.0000,'g1.109-22','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(377,'15\" leangth 2-1/4 ac swan 15لمبا سوا دو بور سوان ائر کلینڈر پائپ کپڑے والا\"',1,'single',1,NULL,NULL,132,135,NULL,NULL,NULL,'inclusive',1,5.0000,'g1.9-23','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(378,'15\" leangth 2-1/4 parashoot ac btr 15لمباسوا دو بور پیراشوٹ ائر کلینڈر پائپ\"',1,'single',1,NULL,NULL,133,135,NULL,NULL,NULL,'inclusive',1,5.0000,'g1.32-24','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(379,'15\" leangth 3\" ac pipe aam 15لمبا تین بور ائر کلینڈر پائپ عام والا\"',1,'single',1,NULL,NULL,134,135,NULL,NULL,NULL,'inclusive',1,5.0000,'g1.104-26','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(380,'15\" leangth 3\" ac swan15لمبا تین بور سوان ائر کلینڈر پائپ کپڑے والا\"',1,'single',1,NULL,NULL,135,135,NULL,NULL,NULL,'inclusive',1,5.0000,'g1.30-25','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(381,'15\" leangth 4 s single marsedeez stairing pipe both sides  chori oper jali  22*1.5      پندرہ انچ لمبا چار سوتر سنگل  مرسڈیز سٹیرنگ پائپ دونوں طرف باہر چوڑی 1.5*22',1,'single',1,NULL,NULL,84,134,NULL,NULL,NULL,'inclusive',1,5.0000,'G3.4-28','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(382,'15\" leangth 4\" ac aam wala 15لمبا چار بورائر کلینڈر پائپ عام والا\"',1,'single',1,NULL,NULL,136,135,NULL,NULL,NULL,'inclusive',1,5.0000,'g1.103-28','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(383,'15\" leangth 4\" ac swan  15لمبا چار بورسوان ایٹر کلینڈر پائپ\"',1,'single',1,NULL,NULL,137,135,NULL,NULL,NULL,'inclusive',1,5.0000,'g1.115-27','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(384,'15\" leangth 5\" ac pipe aam  5لمبا پانچ بور ائر کلینڈر پائپ عام والا\"',1,'single',1,NULL,NULL,138,135,NULL,NULL,NULL,'inclusive',1,5.0000,'g1.94-30','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(385,'15\" leangth 5\" ac swan  15لمبا پانچ بور سوان ائر کلینڈر پائپ کپڑے والا\"',1,'single',1,NULL,NULL,139,135,NULL,NULL,NULL,'inclusive',1,5.0000,'g1.57-29','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(386,'15\" leangth hilux both side bahir chore پندرہ انچ لمبا ہائی لکس دونوں طرف باہر چوڑی عام فٹنگ',1,'single',1,NULL,NULL,76,134,NULL,NULL,NULL,'inclusive',1,5.0000,'G3.53-29','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(387,'16 wall ac pipe geniun daee aam wala  16وال ائر  پائپ  جینون ڈائی عام والا',1,'single',1,NULL,NULL,140,135,NULL,NULL,NULL,'inclusive',1,5.0000,'g1.82-31','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(388,'16\" leangth 2-1/4',1,'single',1,NULL,NULL,141,145,NULL,NULL,NULL,'inclusive',1,5.0000,'G2.7-15','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(389,'16\" leangth 3 s single marsadeez satairing  pipe bahir chore oper jali 18x1.5  سولہ  انچ لمبا تین سوتر سنگل مرسیڈیز سٹیرنگ پائپ باہر چوڑی اوپر جالی 1.5*18',1,'single',1,NULL,NULL,99,144,NULL,NULL,NULL,'inclusive',1,5.0000,'G11.on a glass rack-152','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(390,'16\" leangth boster pipe both side t  سولہ  انچ لمبا بوسٹر پائپ دونوں  طرف ٹی',1,'single',1,NULL,NULL,76,134,NULL,NULL,NULL,'inclusive',1,5.0000,'G3.53-30','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(391,'17\" leangth 4 s single marsedeez stairing pipe both sides bahir chori   22*1.5                             سترہ  انچ لمبا چار سوتر سنگل  مرسڈیز سٹیرنگ پائپ دونو ں طرف  باہر چوڑی 1.5*22',1,'single',1,NULL,NULL,126,134,NULL,NULL,NULL,'inclusive',1,5.0000,'G3.10-31','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(392,'17\" leangth 4 s single marsedeez stairing pipe one side nut & other side nozel   22*1.5                     سترہ  انچ لمبا چار سوتر سنگل  مرسڈیز سٹیرنگ پائپ باہر چوڑی 1.5*22',1,'single',1,NULL,NULL,126,134,NULL,NULL,NULL,'inclusive',1,5.0000,'G3.10-32','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(393,'18\" leangth 1-1/2 ac 18لمبا ڈیڈھ بور سوان ائر کلینڈر پائپ کپڑے والا\"',1,'single',1,NULL,NULL,142,135,NULL,NULL,NULL,'inclusive',1,5.0000,'g1.58-32','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:27','2024-12-04 16:35:27'),(394,'18\" leangth 1-1/4 ac  18لمبا سوا بور سوان ائر کلینڈر پائپ کپڑے والا\"',1,'single',1,NULL,NULL,119,135,NULL,NULL,NULL,'inclusive',1,5.0000,'g1.55-33','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(395,'18\" leangth 1-3/4 ac 18لمباپونےدو بور سوان ائر کلینڈر پائپ کپڑے والا\"',1,'single',1,NULL,NULL,143,135,NULL,NULL,NULL,'inclusive',1,5.0000,'g1.54-35','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(396,'18\" leangth 2  s russian jeep tanki pipe both  sides  free nut              روسی جیپ ٹینکی کا دو سوتر اٹھارہ انچ پائپ دونوں طرف فری نٹ عام فتنگ',1,'single',1,NULL,NULL,99,144,NULL,NULL,NULL,'inclusive',1,5.0000,'G11.on a glass rack-228','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(397,'18\" leangth 2 ac 18لمبا دو بور سوان ائر کلینڈر پائپ کپڑے والا\"',1,'single',1,NULL,NULL,105,135,NULL,NULL,NULL,'inclusive',1,5.0000,'g1.39-36','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(398,'18\" leangth 2-1/2 ac swan   18لمبا اڑھائی بور سوان ائر کلینڈر پائپ کپڑے والا\"',1,'single',1,NULL,NULL,85,135,NULL,NULL,NULL,'inclusive',1,5.0000,'g1.8-38','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(399,'18\" leangth 2-1/2+3 ac  18لمبا اڑھائی+تین بورائر کلینڈر پائپ\"',1,'single',1,NULL,NULL,71,135,NULL,NULL,NULL,'inclusive',1,5.0000,'g1.23-39','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(400,'18\" leangth 2-1/4',1,'single',1,NULL,NULL,141,145,NULL,NULL,NULL,'inclusive',1,5.0000,'G2.7-16','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(401,'18\" leangth 2-1/4 ac aam 18لمبا اڑھائی بور عام ائر کلینڈر پائپ \"',1,'single',1,NULL,NULL,144,135,NULL,NULL,NULL,'inclusive',1,5.0000,'g1.120-37','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(402,'18\" leangth 2-1/4 ac swan 18لمبا سوا دو بور سوان ائر کلینڈر پائپ کپڑے والا\"',1,'single',1,NULL,NULL,145,135,NULL,NULL,NULL,'inclusive',1,5.0000,'g1.129-40','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(403,'18\" leangth 2-1/4 parashoot ac btr 18لمباسوا دو بور پیراشوٹ ائر کلینڈر پائپ\"',1,'single',1,NULL,NULL,146,135,NULL,NULL,NULL,'inclusive',1,5.0000,'g1.33-41','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(404,'18\" leangth 3 ac 18لمبا تین بور سوان ائر کلینڈر پائپ کپڑے والا\"',1,'single',1,NULL,NULL,147,135,NULL,NULL,NULL,'inclusive',1,5.0000,'g1.29-42','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(405,'18\" leangth 3-1/2 ac aam wala 18لمبا ساڑھے تین بورائر کلینڈر پائپ عام والا\"',1,'single',1,NULL,NULL,136,135,NULL,NULL,NULL,'inclusive',1,5.0000,'g1.103-43','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(406,'18\" leangth 4\" ac aam wala 18لمبا چار بورائر کلینڈر پائپ عام والا\"',1,'single',1,NULL,NULL,136,135,NULL,NULL,NULL,'inclusive',1,5.0000,'g1.103-44','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(407,'18\" leangth 5\" ac pipe aam wala 18لمباپانچ بور ائر کلینڈر پائپ عام والا\"',1,'single',1,NULL,NULL,148,135,NULL,NULL,NULL,'inclusive',1,5.0000,'g1.113-45','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(408,'1c ac pipe geniun daee aam wala ون سی ائر  پائپ  جینون ڈائی عام والا',1,'single',1,NULL,NULL,116,135,NULL,NULL,NULL,'inclusive',1,5.0000,'g1.80-46','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(409,'1c geniun lower btr ون سی جینین لوئر',1,'single',1,NULL,NULL,149,145,NULL,NULL,NULL,'inclusive',1,5.0000,'G2.92-17','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(410,'1c geniun lower urc ون سی جینین لوئر',1,'single',1,NULL,NULL,150,145,NULL,NULL,NULL,'inclusive',1,5.0000,'G2.85-18','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(411,'1c lower  1سی لوئر',1,'single',1,NULL,NULL,124,137,NULL,NULL,NULL,'inclusive',1,5.0000,'G4.65-9','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(412,'1c lower btr ون سی لوئر',1,'single',1,NULL,NULL,123,149,NULL,NULL,NULL,'inclusive',1,5.0000,'G8.59-1','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(413,'1x1-1/2\" bore khula tang L bend  ایک*ڈیڈھ بور کھلا  تنگ ایل خم والاہیڈرالک',1,'single',1,NULL,NULL,99,144,NULL,NULL,NULL,'inclusive',1,5.0000,'G11.on a glass rack-156','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(414,'1x1-1/2\" bore khula tang L bend btr ایک*ڈیڈھ بور کھلا  تنگ ایل خم والا',1,'single',1,NULL,NULL,85,138,NULL,NULL,NULL,'inclusive',1,5.0000,'G5.8-15','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(415,'1x1-1/2\" bore khula tang L bend hydrolic ایک*ڈیڈھ بور کھلا  تنگ ایل خم والا',1,'single',1,NULL,NULL,120,138,NULL,NULL,NULL,'inclusive',1,5.0000,'G5.13-16','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(416,'2 meter caben pipe             دو میٹر کیبن پائپ عام فٹنگ',1,'single',1,NULL,NULL,111,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.60-3','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(417,'2 s   black ander mohar           دوسوتر کالا اندر موہر فرانس',1,'single',18,NULL,NULL,151,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1-13','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(418,'2 s   black ander mohar           دوسوتر کالا اندر موہر فرانس',1,'single',18,NULL,NULL,151,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1-230','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(419,'2 s   black ander mohar           دوسوتر کالا اندر موہر فرانس',1,'single',18,NULL,NULL,151,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1-234','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(420,'2 s   black ander mohar           دوسوتر کالا اندر موہر فرانس',1,'single',18,NULL,NULL,151,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1-235','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(421,'2 s   black ander mohar           دوسوتر کالا اندر موہر فرانس',1,'single',18,NULL,NULL,151,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1-236','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(422,'2 s   black ander mohar           دوسوتر کالا اندر موہر فرانس',1,'single',18,NULL,NULL,151,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1-237','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(423,'2 s   black ander mohar           دوسوتر کالا اندر موہر فرانس',1,'single',18,NULL,NULL,151,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1-238','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(424,'2 s   black ander mohar           دوسوتر کالا اندر موہر فرانس',1,'single',18,NULL,NULL,151,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1-239','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(425,'2 s   black ander mohar           دوسوتر کالا اندر موہر فرانس',1,'single',18,NULL,NULL,151,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1-240','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(426,'2 s   black ander mohar          دوسوتر کالا اندر موہر فرانس',1,'single',18,NULL,NULL,151,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1-229','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(427,'2 s   black ander mohar          دوسوتر کالا اندر موہر فرانس',1,'single',18,NULL,NULL,151,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1-231','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(428,'2 s   black ander mohar          دوسوتر کالا اندر موہر فرانس',1,'single',18,NULL,NULL,151,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1-232','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(429,'2 s   black ander mohar          دوسوتر کالا اندر موہر فرانس',1,'single',18,NULL,NULL,151,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1-233','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(430,'2 s  pipe   black             دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,96,148,NULL,NULL,NULL,'inclusive',1,5.0000,'G14.open-38','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(431,'2 s  pipe   black             دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,96,148,NULL,NULL,NULL,'inclusive',1,5.0000,'G14.open-51','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(432,'2 s  pipe   black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,96,148,NULL,NULL,NULL,'inclusive',1,5.0000,'G14.open-23','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(433,'2 s  pipe   black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,96,148,NULL,NULL,NULL,'inclusive',1,5.0000,'G14.open-24','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(434,'2 s  pipe   black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,96,148,NULL,NULL,NULL,'inclusive',1,5.0000,'G14.open-25','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(435,'2 s  pipe   black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,96,148,NULL,NULL,NULL,'inclusive',1,5.0000,'G14.open-26','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(436,'2 s  pipe   black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,96,148,NULL,NULL,NULL,'inclusive',1,5.0000,'G14.open-27','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(437,'2 s  pipe   black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,96,148,NULL,NULL,NULL,'inclusive',1,5.0000,'G14.open-28','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(438,'2 s  pipe   black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,96,148,NULL,NULL,NULL,'inclusive',1,5.0000,'G14.open-29','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(439,'2 s  pipe   black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,96,148,NULL,NULL,NULL,'inclusive',1,5.0000,'G14.open-30','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(440,'2 s  pipe   black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,96,148,NULL,NULL,NULL,'inclusive',1,5.0000,'G14.open-31','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(441,'2 s  pipe   black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,96,148,NULL,NULL,NULL,'inclusive',1,5.0000,'G14.open-32','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(442,'2 s  pipe   black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,96,148,NULL,NULL,NULL,'inclusive',1,5.0000,'G14.open-33','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(443,'2 s  pipe   black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,96,148,NULL,NULL,NULL,'inclusive',1,5.0000,'G14.open-34','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(444,'2 s  pipe   black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,96,148,NULL,NULL,NULL,'inclusive',1,5.0000,'G14.open-35','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(445,'2 s  pipe   black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,96,148,NULL,NULL,NULL,'inclusive',1,5.0000,'G14.open-36','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(446,'2 s  pipe   black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,96,148,NULL,NULL,NULL,'inclusive',1,5.0000,'G14.open-37','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(447,'2 s  pipe   black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,96,148,NULL,NULL,NULL,'inclusive',1,5.0000,'G14.open-39','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(448,'2 s  pipe   black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,96,148,NULL,NULL,NULL,'inclusive',1,5.0000,'G14.open-40','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(449,'2 s  pipe   black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,96,148,NULL,NULL,NULL,'inclusive',1,5.0000,'G14.open-41','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(450,'2 s  pipe   black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,96,148,NULL,NULL,NULL,'inclusive',1,5.0000,'G14.open-42','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(451,'2 s  pipe   black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,96,148,NULL,NULL,NULL,'inclusive',1,5.0000,'G14.open-43','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(452,'2 s  pipe   black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,96,148,NULL,NULL,NULL,'inclusive',1,5.0000,'G14.open-44','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(453,'2 s  pipe   black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,96,148,NULL,NULL,NULL,'inclusive',1,5.0000,'G14.open-45','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(454,'2 s  pipe   black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,96,148,NULL,NULL,NULL,'inclusive',1,5.0000,'G14.open-46','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(455,'2 s  pipe   black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,96,148,NULL,NULL,NULL,'inclusive',1,5.0000,'G14.open-47','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(456,'2 s  pipe   black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,96,148,NULL,NULL,NULL,'inclusive',1,5.0000,'G14.open-48','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(457,'2 s  pipe   black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,96,148,NULL,NULL,NULL,'inclusive',1,5.0000,'G14.open-49','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(458,'2 s  pipe   black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,96,148,NULL,NULL,NULL,'inclusive',1,5.0000,'G14.open-50','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(459,'2 s  pipe   black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,96,148,NULL,NULL,NULL,'inclusive',1,5.0000,'G14.open-52','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(460,'2 s  pipe   black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,96,148,NULL,NULL,NULL,'inclusive',1,5.0000,'G14.open-53','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(461,'2 s  pipe   black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,96,148,NULL,NULL,NULL,'inclusive',1,5.0000,'G14.open-54','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(462,'2 s  pipe   black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,96,148,NULL,NULL,NULL,'inclusive',1,5.0000,'G14.open-55','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(463,'2 s  pipe   black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,96,148,NULL,NULL,NULL,'inclusive',1,5.0000,'G14.open-56','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(464,'2 s  pipe   black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,96,148,NULL,NULL,NULL,'inclusive',1,5.0000,'G14.open-57','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(465,'2 s  pipe   black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,96,148,NULL,NULL,NULL,'inclusive',1,5.0000,'G14.open-58','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(466,'2 s  pipe   black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,96,148,NULL,NULL,NULL,'inclusive',1,5.0000,'G14.open-59','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(467,'2 s  pipe   black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,96,148,NULL,NULL,NULL,'inclusive',1,5.0000,'G14.open-60','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(468,'2 s  pipe   black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,96,148,NULL,NULL,NULL,'inclusive',1,5.0000,'G14.open-61','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(469,'2 s  pipe   black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,96,148,NULL,NULL,NULL,'inclusive',1,5.0000,'G14.open-62','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(470,'2 s  pipe   black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,96,148,NULL,NULL,NULL,'inclusive',1,5.0000,'G14.open-63','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(471,'2 s  pipe   black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,96,148,NULL,NULL,NULL,'inclusive',1,5.0000,'G14.open-64','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(472,'2 s  pipe   black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,96,148,NULL,NULL,NULL,'inclusive',1,5.0000,'G14.open-66','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(473,'2 s  pipe   black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,96,148,NULL,NULL,NULL,'inclusive',1,5.0000,'G14.open-67','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:28','2024-12-04 16:35:28'),(474,'2 s  pipe   black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,96,148,NULL,NULL,NULL,'inclusive',1,5.0000,'G14.open-68','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(475,'2 s  pipe   black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,96,148,NULL,NULL,NULL,'inclusive',1,5.0000,'G14.open-69','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(476,'2 s  pipe   black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,96,148,NULL,NULL,NULL,'inclusive',1,5.0000,'G14.open-70','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(477,'2 s  pipe   black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,96,148,NULL,NULL,NULL,'inclusive',1,5.0000,'G14.open-71','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(478,'2 s  pipe   black           دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,96,148,NULL,NULL,NULL,'inclusive',1,5.0000,'G14.open-65','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(479,'2 s  pipe   black narrow bore             دوسوتر پائپ کالا تنگ سوراخ',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-243','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(480,'2 s  pipe   black narrow bore             دوسوتر پائپ کالا تنگ سوراخ',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-244','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(481,'2 s  pipe   black narrow bore             دوسوتر پائپ کالا تنگ سوراخ',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-245','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(482,'2 s  pipe   black narrow bore             دوسوتر پائپ کالا تنگ سوراخ',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-247','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(483,'2 s  pipe   black narrow bore             دوسوتر پائپ کالا تنگ سوراخ',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-254','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(484,'2 s  pipe   black narrow bore             دوسوتر پائپ کالا تنگ سوراخ    pcs2',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-249','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(485,'2 s  pipe   black narrow bore             دوسوتر پائپ کالا تنگ سوراخ pcs1',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-248','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(486,'2 s  pipe   black narrow bore            دوسوتر پائپ کالا تنگ سوراخ',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-246','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(487,'2 s  pipe   black narrow bore            دوسوتر پائپ کالا تنگ سوراخ',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-250','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(488,'2 s  pipe   black narrow bore            دوسوتر پائپ کالا تنگ سوراخ',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-251','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(489,'2 s  pipe   black narrow bore            دوسوتر پائپ کالا تنگ سوراخ',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-252','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(490,'2 s  pipe   black narrow bore            دوسوتر پائپ کالا تنگ سوراخ',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-253','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(491,'2 s  pipe   black narrow bore           دوسوتر پائپ کالا تنگ سوراخ',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-15','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(492,'2 s  pipe   green            دوسوتر پائپ سبز فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-17','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(493,'2 s  pipe   green           دوسوتر پائپ سبز فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-16','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(494,'2 s  pipe   white france             دوسوتر پائپ سفید فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-255','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(495,'2 s  pipe   white france            دوسوتر پائپ سفید فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-18','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(496,'2 s  pipe   white france            دوسوتر پائپ سفید فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-256','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(497,'2 s  pipe  black             دوسوتر پائپ کالا ولائیتی',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-24','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(498,'2 s  pipe  black             دوسوتر پائپ کالا ولائیتی',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-25','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(499,'2 s  pipe  black             دوسوتر پائپ کالا ولائیتی',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-26','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(500,'2 s  pipe  black             دوسوتر پائپ کالا ولائیتی',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-27','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(501,'2 s  pipe  black             دوسوتر پائپ کالا ولائیتی',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-28','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(502,'2 s  pipe  black             دوسوتر پائپ کالا ولائیتی',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-29','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(503,'2 s  pipe  black             دوسوتر پائپ کالا ولائیتی',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-30','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(504,'2 s  pipe  black             دوسوتر پائپ کالا ولائیتی',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-31','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(505,'2 s  pipe  black             دوسوتر پائپ کالا ولائیتی',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-32','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(506,'2 s  pipe  black             دوسوتر پائپ کالا ولائیتی',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-33','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(507,'2 s  pipe  black             دوسوتر پائپ کالا ولائیتی',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-34','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(508,'2 s  pipe  black             دوسوتر پائپ کالا ولائیتی',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-35','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(509,'2 s  pipe  black             دوسوتر پائپ کالا ولائیتی',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-36','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(510,'2 s  pipe  black             دوسوتر پائپ کالا ولائیتی',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-37','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(511,'2 s  pipe  black             دوسوتر پائپ کالا ولائیتی',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-38','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(512,'2 s  pipe  black             دوسوتر پائپ کالا ولائیتی',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-39','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(513,'2 s  pipe  black             دوسوتر پائپ کالا ولائیتی',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-40','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(514,'2 s  pipe  black             دوسوتر پائپ کالا ولائیتی',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-41','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(515,'2 s  pipe  black             دوسوتر پائپ کالا ولائیتی',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-42','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(516,'2 s  pipe  black             دوسوتر پائپ کالا ولائیتی',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-43','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(517,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-19','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(518,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-258','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(519,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-259','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(520,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-261','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(521,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-262','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(522,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-263','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(523,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-266','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(524,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-267','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(525,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-269','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(526,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-270','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(527,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-276','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(528,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-279','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(529,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-281','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(530,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-282','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(531,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-283','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(532,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-284','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(533,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-286','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(534,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-288','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(535,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-289','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(536,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-290','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(537,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-294','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(538,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-295','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(539,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-296','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(540,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-299','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(541,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-301','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(542,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-302','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(543,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-304','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(544,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-306','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(545,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-307','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(546,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-308','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(547,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-309','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(548,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-310','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(549,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-312','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(550,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-313','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(551,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-314','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(552,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-315','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(553,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-316','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:29','2024-12-04 16:35:29'),(554,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-318','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(555,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-319','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(556,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-320','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(557,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-321','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(558,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-322','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(559,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-324','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(560,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-325','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(561,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-326','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(562,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-327','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(563,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-328','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(564,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-329','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(565,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-330','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(566,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-331','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(567,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-332','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(568,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-334','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(569,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-336','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(570,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-337','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(571,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-339','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(572,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-340','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(573,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-345','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(574,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-347','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(575,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-348','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(576,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-350','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(577,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-351','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(578,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-352','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(579,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-353','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(580,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-354','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(581,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-355','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(582,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-357','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(583,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-358','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(584,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-359','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(585,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-362','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(586,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-363','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(587,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-364','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(588,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-365','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(589,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-366','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(590,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-367','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(591,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-368','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(592,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-370','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(593,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-371','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(594,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-372','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(595,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-373','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(596,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-374','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(597,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-375','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(598,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-377','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(599,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-378','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(600,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-379','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(601,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-380','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(602,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-381','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(603,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-382','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(604,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-383','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(605,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,151,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1-384','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(606,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,151,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1-385','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(607,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-386','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(608,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-387','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(609,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-388','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(610,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-389','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(611,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-390','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(612,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,151,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1-391','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(613,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-393','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(614,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-394','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(615,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-396','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(616,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-397','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(617,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-398','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(618,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-399','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(619,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,151,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1-400','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(620,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-401','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(621,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-402','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(622,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-403','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:30','2024-12-04 16:35:30'),(623,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-406','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(624,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-407','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(625,'2 s  pipe  black            دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-416','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(626,'2 s  pipe  black           دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-257','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(627,'2 s  pipe  black           دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-260','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(628,'2 s  pipe  black           دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-264','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(629,'2 s  pipe  black           دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-265','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(630,'2 s  pipe  black           دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-268','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(631,'2 s  pipe  black           دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-271','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(632,'2 s  pipe  black           دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-272','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(633,'2 s  pipe  black           دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-274','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(634,'2 s  pipe  black           دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,151,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1-275','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(635,'2 s  pipe  black           دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-277','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(636,'2 s  pipe  black           دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-280','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(637,'2 s  pipe  black           دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-285','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(638,'2 s  pipe  black           دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-287','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(639,'2 s  pipe  black           دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-291','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(640,'2 s  pipe  black           دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-292','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(641,'2 s  pipe  black           دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-293','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(642,'2 s  pipe  black           دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-297','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(643,'2 s  pipe  black           دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-298','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(644,'2 s  pipe  black           دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-300','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(645,'2 s  pipe  black           دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-303','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(646,'2 s  pipe  black           دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-311','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(647,'2 s  pipe  black           دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,151,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1-317','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(648,'2 s  pipe  black           دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-323','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(649,'2 s  pipe  black           دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-333','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(650,'2 s  pipe  black           دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-335','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(651,'2 s  pipe  black           دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-338','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(652,'2 s  pipe  black           دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-341','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(653,'2 s  pipe  black           دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-343','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(654,'2 s  pipe  black           دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-344','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(655,'2 s  pipe  black           دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-346','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(656,'2 s  pipe  black           دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-356','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(657,'2 s  pipe  black           دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-360','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(658,'2 s  pipe  black           دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-361','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(659,'2 s  pipe  black           دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-369','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(660,'2 s  pipe  black           دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-376','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(661,'2 s  pipe  black           دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-392','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(662,'2 s  pipe  black           دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-395','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(663,'2 s  pipe  black           دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-404','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(664,'2 s  pipe  black           دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-405','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(665,'2 s  pipe  black           دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-408','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(666,'2 s  pipe  black           دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-409','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(667,'2 s  pipe  black           دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-410','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(668,'2 s  pipe  black           دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-411','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(669,'2 s  pipe  black           دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-412','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(670,'2 s  pipe  black           دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-413','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(671,'2 s  pipe  black           دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-414','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(672,'2 s  pipe  black           دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-417','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(673,'2 s  pipe  black          دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-273','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(674,'2 s  pipe  black          دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-278','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(675,'2 s  pipe  black          دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-305','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(676,'2 s  pipe  black          دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-342','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(677,'2 s  pipe  black          دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-349','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(678,'2 s  pipe  black          دوسوتر پائپ کالا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-415','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(679,'2 s  pipe  black white patti             دوسوتر پائپ کالا سفید پٹی فرانس',1,'single',18,NULL,NULL,153,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1.26-20','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(680,'2 s  pipe  black white patti             دوسوتر پائپ کالا سفید پٹی فرانس',1,'single',18,NULL,NULL,153,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/26-418','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(681,'2 s  pipe  black white patti             دوسوتر پائپ کالا سفید پٹی فرانس',1,'single',18,NULL,NULL,153,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/26-419','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(682,'2 s  pipe  black white patti             دوسوتر پائپ کالا سفید پٹی فرانس',1,'single',18,NULL,NULL,153,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/26-420','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(683,'2 s  pipe  black white patti             دوسوتر پائپ کالا سفید پٹی فرانس',1,'single',18,NULL,NULL,153,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/26-421','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(684,'2 s  pipe  black white patti             دوسوتر پائپ کالا سفید پٹی فرانس',1,'single',18,NULL,NULL,153,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/26-422','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(685,'2 s  pipe  black white patti             دوسوتر پائپ کالا سفید پٹی فرانس',1,'single',18,NULL,NULL,153,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/26-423','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(686,'2 s  pipe  black white patti             دوسوتر پائپ کالا سفید پٹی فرانس',1,'single',18,NULL,NULL,153,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/26-424','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(687,'2 s  pipe  black white patti             دوسوتر پائپ کالا سفید پٹی فرانس',1,'single',18,NULL,NULL,153,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/26-425','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(688,'2 s  pipe  black white patti             دوسوتر پائپ کالا سفید پٹی فرانس',1,'single',18,NULL,NULL,153,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/26-426','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(689,'2 s  pipe  black white patti             دوسوتر پائپ کالا سفید پٹی فرانس',1,'single',18,NULL,NULL,153,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/26-428','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(690,'2 s  pipe  black white patti             دوسوتر پائپ کالا سفید پٹی فرانس',1,'single',18,NULL,NULL,153,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/26-429','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(691,'2 s  pipe  black white patti             دوسوتر پائپ کالا سفید پٹی فرانس',1,'single',18,NULL,NULL,153,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/26-430','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:31','2024-12-04 16:35:31'),(692,'2 s  pipe  black white patti             دوسوتر پائپ کالا سفید پٹی فرانس',1,'single',18,NULL,NULL,153,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/26-431','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(693,'2 s  pipe  black white patti             دوسوتر پائپ کالا سفید پٹی فرانس',1,'single',18,NULL,NULL,153,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/26-432','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(694,'2 s  pipe  black white patti             دوسوتر پائپ کالا سفید پٹی فرانس',1,'single',18,NULL,NULL,153,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/26-433','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(695,'2 s  pipe  black white patti             دوسوتر پائپ کالا سفید پٹی فرانس',1,'single',18,NULL,NULL,153,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/26-434','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(696,'2 s  pipe  black white patti             دوسوتر پائپ کالا سفید پٹی فرانس',1,'single',18,NULL,NULL,153,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/26-435','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(697,'2 s  pipe  black white patti             دوسوتر پائپ کالا سفید پٹی فرانس',1,'single',18,NULL,NULL,153,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/26-436','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(698,'2 s  pipe  black white patti             دوسوتر پائپ کالا سفید پٹی فرانس',1,'single',18,NULL,NULL,153,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/26-438','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(699,'2 s  pipe  black white patti             دوسوتر پائپ کالا سفید پٹی فرانس',1,'single',18,NULL,NULL,153,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/26-440','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(700,'2 s  pipe  black white patti             دوسوتر پائپ کالا سفید پٹی فرانس',1,'single',18,NULL,NULL,153,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/26-441','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(701,'2 s  pipe  black white patti             دوسوتر پائپ کالا سفید پٹی فرانس',1,'single',18,NULL,NULL,153,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/26-442','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(702,'2 s  pipe  black white patti             دوسوتر پائپ کالا سفید پٹی فرانس',1,'single',18,NULL,NULL,153,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/26-443','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(703,'2 s  pipe  black white patti             دوسوتر پائپ کالا سفید پٹی فرانس',1,'single',18,NULL,NULL,153,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/26-444','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(704,'2 s  pipe  black white patti             دوسوتر پائپ کالا سفید پٹی فرانس',1,'single',18,NULL,NULL,153,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/26-445','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(705,'2 s  pipe  black white patti             دوسوتر پائپ کالا سفید پٹی فرانس',1,'single',18,NULL,NULL,153,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/26-446','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(706,'2 s  pipe  black white patti             دوسوتر پائپ کالا سفید پٹی فرانس',1,'single',18,NULL,NULL,153,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/26-450','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(707,'2 s  pipe  black white patti             دوسوتر پائپ کالا سفید پٹی فرانس',1,'single',18,NULL,NULL,153,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/26-451','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(708,'2 s  pipe  black white patti             دوسوتر پائپ کالا سفید پٹی فرانس',1,'single',18,NULL,NULL,153,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/26-452','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(709,'2 s  pipe  black white patti             دوسوتر پائپ کالا سفید پٹی فرانس',1,'single',18,NULL,NULL,153,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/26-453','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(710,'2 s  pipe  black white patti             دوسوتر پائپ کالا سفید پٹی فرانس',1,'single',18,NULL,NULL,153,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/26-454','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(711,'2 s  pipe  black white patti             دوسوتر پائپ کالا سفید پٹی فرانس',1,'single',18,NULL,NULL,153,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/26-455','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(712,'2 s  pipe  black white patti             دوسوتر پائپ کالا سفید پٹی فرانس',1,'single',18,NULL,NULL,153,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/26-456','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(713,'2 s  pipe  black white patti             دوسوتر پائپ کالا سفید پٹی فرانس',1,'single',18,NULL,NULL,153,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/26-457','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(714,'2 s  pipe  black white patti             دوسوتر پائپ کالا سفید پٹی فرانس',1,'single',18,NULL,NULL,153,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/26-458','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(715,'2 s  pipe  black white patti             دوسوتر پائپ کالا سفید پٹی فرانس',1,'single',18,NULL,NULL,153,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/26-459','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(716,'2 s  pipe  black white patti             دوسوتر پائپ کالا سفید پٹی فرانس',1,'single',18,NULL,NULL,153,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/26-460','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(717,'2 s  pipe  black white patti             دوسوتر پائپ کالا سفید پٹی فرانس',1,'single',18,NULL,NULL,153,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/26-461','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(718,'2 s  pipe  black white patti             دوسوتر پائپ کالا سفید پٹی فرانس',1,'single',18,NULL,NULL,153,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/26-462','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(719,'2 s  pipe  black white patti             دوسوتر پائپ کالا سفید پٹی فرانس',1,'single',18,NULL,NULL,153,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/26-463','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(720,'2 s  pipe  black white patti             دوسوتر پائپ کالا سفید پٹی فرانس',1,'single',18,NULL,NULL,153,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/26-464','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(721,'2 s  pipe  black white patti             دوسوتر پائپ کالا سفید پٹی فرانس',1,'single',18,NULL,NULL,153,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/26-466','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(722,'2 s  pipe  black white patti             دوسوتر پائپ کالا سفید پٹی فرانس',1,'single',18,NULL,NULL,153,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/26-468','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(723,'2 s  pipe  black white patti             دوسوتر پائپ کالا سفید پٹی فرانس',1,'single',18,NULL,NULL,153,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/26-469','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(724,'2 s  pipe  black white patti             دوسوتر پائپ کالا سفید پٹی فرانس',1,'single',18,NULL,NULL,153,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/26-470','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(725,'2 s  pipe  black white patti            دوسوتر پائپ کالا سفید پٹی فرانس',1,'single',18,NULL,NULL,153,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/26-437','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(726,'2 s  pipe  black white patti            دوسوتر پائپ کالا سفید پٹی فرانس',1,'single',18,NULL,NULL,153,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/26-439','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(727,'2 s  pipe  black white patti            دوسوتر پائپ کالا سفید پٹی فرانس',1,'single',18,NULL,NULL,153,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/26-447','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(728,'2 s  pipe  black white patti            دوسوتر پائپ کالا سفید پٹی فرانس',1,'single',18,NULL,NULL,153,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/26-448','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(729,'2 s  pipe  black white patti            دوسوتر پائپ کالا سفید پٹی فرانس',1,'single',18,NULL,NULL,153,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/26-449','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(730,'2 s  pipe  black white patti            دوسوتر پائپ کالا سفید پٹی فرانس',1,'single',18,NULL,NULL,153,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/26-465','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(731,'2 s  pipe  black white patti            دوسوتر پائپ کالا سفید پٹی فرانس',1,'single',18,NULL,NULL,153,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/26-467','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(732,'2 s  pipe  black white patti           دوسوتر پائپ کالا سفید پٹی فرانس',1,'single',18,NULL,NULL,153,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/26-427','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(733,'2 s  pipe  blue               دوسوتر پائپ نیلا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-21','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(734,'2 s  pipe  blue              دوسوتر پائپ نیلا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-475','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(735,'2 s  pipe  blue              دوسوتر پائپ نیلا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-477','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(736,'2 s  pipe  blue              دوسوتر پائپ نیلا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-479','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(737,'2 s  pipe  blue              دوسوتر پائپ نیلا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-480','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(738,'2 s  pipe  blue              دوسوتر پائپ نیلا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-481','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(739,'2 s  pipe  blue              دوسوتر پائپ نیلا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-482','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(740,'2 s  pipe  blue              دوسوتر پائپ نیلا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-483','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(741,'2 s  pipe  blue             دوسوتر پائپ نیلا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-471','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(742,'2 s  pipe  blue             دوسوتر پائپ نیلا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-472','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(743,'2 s  pipe  blue             دوسوتر پائپ نیلا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-473','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(744,'2 s  pipe  blue             دوسوتر پائپ نیلا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-474','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(745,'2 s  pipe  blue             دوسوتر پائپ نیلا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-476','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(746,'2 s  pipe  blue             دوسوتر پائپ نیلا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-478','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(747,'2 s  pipe  blue             دوسوتر پائپ نیلا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-484','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(748,'2 s  pipe  blue            دوسوتر پائپ نیلا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-485','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(749,'2 s  pipe  coloured              دوسوتر پائپ رنگین ولائیتی',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-44','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(750,'2 s  pipe  coloured            دوسوتر پائپ رنگین ولائیتی',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-45','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(751,'2 s  pipe  coloured            دوسوتر پائپ رنگین ولائیتی',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-46','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(752,'2 s  pipe  coloured            دوسوتر پائپ رنگین ولائیتی',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-47','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(753,'2 s  pipe  coloured            دوسوتر پائپ رنگین ولائیتی',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-48','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(754,'2 s  pipe  coloured            دوسوتر پائپ رنگین ولائیتی',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-49','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(755,'2 s  pipe  grey              دوسوتر پائپ گرے فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-488','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(756,'2 s  pipe  grey              دوسوتر پائپ گرے فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-489','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(757,'2 s  pipe  grey              دوسوتر پائپ گرے فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-490','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(758,'2 s  pipe  grey              دوسوتر پائپ گرے فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-491','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(759,'2 s  pipe  grey              دوسوتر پائپ گرے فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-492','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(760,'2 s  pipe  grey              دوسوتر پائپ گرے فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-493','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(761,'2 s  pipe  grey              دوسوتر پائپ گرے فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-494','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(762,'2 s  pipe  grey              دوسوتر پائپ گرے فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-495','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(763,'2 s  pipe  grey              دوسوتر پائپ گرے فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-496','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(764,'2 s  pipe  grey              دوسوتر پائپ گرے فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-497','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(765,'2 s  pipe  grey              دوسوتر پائپ گرے فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-498','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(766,'2 s  pipe  grey              دوسوتر پائپ گرے فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-499','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(767,'2 s  pipe  grey              دوسوتر پائپ گرے فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-500','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(768,'2 s  pipe  grey              دوسوتر پائپ گرے فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-501','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(769,'2 s  pipe  grey              دوسوتر پائپ گرے فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-502','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(770,'2 s  pipe  grey              دوسوتر پائپ گرے فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-504','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(771,'2 s  pipe  grey              دوسوتر پائپ گرے فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-505','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:32','2024-12-04 16:35:32'),(772,'2 s  pipe  grey              دوسوتر پائپ گرے فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-506','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(773,'2 s  pipe  grey              دوسوتر پائپ گرے فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-507','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(774,'2 s  pipe  grey              دوسوتر پائپ گرے فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-508','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(775,'2 s  pipe  grey              دوسوتر پائپ گرے فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-510','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(776,'2 s  pipe  grey             دوسوتر پائپ گرے فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-22','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(777,'2 s  pipe  grey             دوسوتر پائپ گرے فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-487','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(778,'2 s  pipe  grey             دوسوتر پائپ گرے فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-503','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(779,'2 s  pipe  grey             دوسوتر پائپ گرے فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-509','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(780,'2 s  pipe  grey            دوسوتر پائپ گرے فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-486','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(781,'2 s  pipe  orange            دوسوتر پائپ مالٹا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-23','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(782,'2 s  pipe  orange            دوسوتر پائپ مالٹا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-511','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(783,'2 s  pipe  orange            دوسوتر پائپ مالٹا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-512','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(784,'2 s  pipe  orange            دوسوتر پائپ مالٹا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-515','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(785,'2 s  pipe  orange            دوسوتر پائپ مالٹا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-516','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(786,'2 s  pipe  orange            دوسوتر پائپ مالٹا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-519','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(787,'2 s  pipe  orange            دوسوتر پائپ مالٹا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-522','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(788,'2 s  pipe  orange            دوسوتر پائپ مالٹا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-530','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(789,'2 s  pipe  orange            دوسوتر پائپ مالٹا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-535','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(790,'2 s  pipe  orange            دوسوتر پائپ مالٹا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-536','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(791,'2 s  pipe  orange            دوسوتر پائپ مالٹا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-537','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(792,'2 s  pipe  orange            دوسوتر پائپ مالٹا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-541','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(793,'2 s  pipe  orange            دوسوتر پائپ مالٹا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-542','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(794,'2 s  pipe  orange            دوسوتر پائپ مالٹا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-544','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(795,'2 s  pipe  orange            دوسوتر پائپ مالٹا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-546','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(796,'2 s  pipe  orange            دوسوتر پائپ مالٹا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-549','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(797,'2 s  pipe  orange            دوسوتر پائپ مالٹا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-550','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(798,'2 s  pipe  orange           دوسوتر پائپ مالٹا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-513','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(799,'2 s  pipe  orange           دوسوتر پائپ مالٹا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-514','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(800,'2 s  pipe  orange           دوسوتر پائپ مالٹا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-517','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(801,'2 s  pipe  orange           دوسوتر پائپ مالٹا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-518','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(802,'2 s  pipe  orange           دوسوتر پائپ مالٹا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-520','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(803,'2 s  pipe  orange           دوسوتر پائپ مالٹا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-521','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(804,'2 s  pipe  orange           دوسوتر پائپ مالٹا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-523','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(805,'2 s  pipe  orange           دوسوتر پائپ مالٹا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-524','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(806,'2 s  pipe  orange           دوسوتر پائپ مالٹا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-525','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(807,'2 s  pipe  orange           دوسوتر پائپ مالٹا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-526','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(808,'2 s  pipe  orange           دوسوتر پائپ مالٹا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-527','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(809,'2 s  pipe  orange           دوسوتر پائپ مالٹا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-531','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(810,'2 s  pipe  orange           دوسوتر پائپ مالٹا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-532','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(811,'2 s  pipe  orange           دوسوتر پائپ مالٹا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-533','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(812,'2 s  pipe  orange           دوسوتر پائپ مالٹا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-534','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(813,'2 s  pipe  orange           دوسوتر پائپ مالٹا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-538','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(814,'2 s  pipe  orange           دوسوتر پائپ مالٹا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-539','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(815,'2 s  pipe  orange           دوسوتر پائپ مالٹا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-540','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(816,'2 s  pipe  orange           دوسوتر پائپ مالٹا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-545','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(817,'2 s  pipe  orange          دوسوتر پائپ مالٹا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-528','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(818,'2 s  pipe  orange          دوسوتر پائپ مالٹا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-543','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(819,'2 s  pipe  orange          دوسوتر پائپ مالٹا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-547','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(820,'2 s  pipe  orange          دوسوتر پائپ مالٹا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-548','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(821,'2 s  pipe  orange         دوسوتر پائپ مالٹا فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-529','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(822,'2 s  pipe  orange   40ft         دوسوتر پائپ کالا سفید پٹی فرانس',1,'single',18,NULL,NULL,117,144,NULL,NULL,NULL,'inclusive',1,5.0000,'G11.Under glasses rack-105','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(823,'2 s  pipe  red              دوسوتر پائپ لال فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-24','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(824,'2 s  pipe  red              دوسوتر پائپ لال فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-551','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(825,'2 s  pipe  red              دوسوتر پائپ لال فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-552','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(826,'2 s  pipe  red              دوسوتر پائپ لال فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-558','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(827,'2 s  pipe  red              دوسوتر پائپ لال فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-559','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(828,'2 s  pipe  red              دوسوتر پائپ لال فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-561','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(829,'2 s  pipe  red              دوسوتر پائپ لال فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-562','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(830,'2 s  pipe  red              دوسوتر پائپ لال فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-565','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(831,'2 s  pipe  red              دوسوتر پائپ لال فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-566','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(832,'2 s  pipe  red              دوسوتر پائپ لال فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-568','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(833,'2 s  pipe  red             دوسوتر پائپ لال فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-553','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(834,'2 s  pipe  red             دوسوتر پائپ لال فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-556','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(835,'2 s  pipe  red             دوسوتر پائپ لال فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-557','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(836,'2 s  pipe  red             دوسوتر پائپ لال فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-560','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(837,'2 s  pipe  red             دوسوتر پائپ لال فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-563','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(838,'2 s  pipe  red             دوسوتر پائپ لال فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-564','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(839,'2 s  pipe  red             دوسوتر پائپ لال فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-567','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(840,'2 s  pipe  red             دوسوتر پائپ لال فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-569','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(841,'2 s  pipe  red             دوسوتر پائپ لال فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-570','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(842,'2 s  pipe  red            دوسوتر پائپ لال فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-554','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(843,'2 s  pipe  red            دوسوتر پائپ لال فرانس',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-555','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(844,'2 s  pipe black korea             دوسوتر پائپ کالا کوریا',1,'single',18,NULL,NULL,151,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1-241','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(845,'2 s  pipe black korea           دوسوتر پائپ کالا کوریا',1,'single',18,NULL,NULL,151,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1-242','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:33','2024-12-04 16:35:33'),(846,'2 s  pipe black korea          دوسوتر پائپ کالا کوریا',1,'single',18,NULL,NULL,151,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1-14','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(847,'2 s  pipe mix  colour pieces              دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-25','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(848,'2 s  pipe mix  colour pieces             دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-571','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(849,'2 s  pipe mix  colour pieces             دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-573','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(850,'2 s  pipe mix  colour pieces             دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-574','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(851,'2 s  pipe mix  colour pieces             دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-575','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(852,'2 s  pipe mix  colour pieces             دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-576','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(853,'2 s  pipe mix  colour pieces             دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-577','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(854,'2 s  pipe mix  colour pieces             دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-578','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(855,'2 s  pipe mix  colour pieces             دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-579','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(856,'2 s  pipe mix  colour pieces             دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-580','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(857,'2 s  pipe mix  colour pieces             دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-581','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(858,'2 s  pipe mix  colour pieces             دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-582','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(859,'2 s  pipe mix  colour pieces             دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-585','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(860,'2 s  pipe mix  colour pieces             دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-586','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(861,'2 s  pipe mix  colour pieces             دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-587','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(862,'2 s  pipe mix  colour pieces             دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-588','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(863,'2 s  pipe mix  colour pieces             دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-589','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(864,'2 s  pipe mix  colour pieces             دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-590','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(865,'2 s  pipe mix  colour pieces             دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-591','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(866,'2 s  pipe mix  colour pieces             دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-592','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(867,'2 s  pipe mix  colour pieces             دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-594','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(868,'2 s  pipe mix  colour pieces             دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-596','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(869,'2 s  pipe mix  colour pieces             دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-598','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(870,'2 s  pipe mix  colour pieces             دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-599','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(871,'2 s  pipe mix  colour pieces             دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-601','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(872,'2 s  pipe mix  colour pieces             دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-602','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(873,'2 s  pipe mix  colour pieces             دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-603','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(874,'2 s  pipe mix  colour pieces             دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-605','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(875,'2 s  pipe mix  colour pieces             دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-608','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(876,'2 s  pipe mix  colour pieces             دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-609','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(877,'2 s  pipe mix  colour pieces             دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-610','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(878,'2 s  pipe mix  colour pieces             دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-611','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(879,'2 s  pipe mix  colour pieces             دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-612','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(880,'2 s  pipe mix  colour pieces             دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-613','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(881,'2 s  pipe mix  colour pieces             دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-614','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(882,'2 s  pipe mix  colour pieces             دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-615','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(883,'2 s  pipe mix  colour pieces             دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-616','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(884,'2 s  pipe mix  colour pieces             دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-617','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(885,'2 s  pipe mix  colour pieces             دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-618','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(886,'2 s  pipe mix  colour pieces             دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-619','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(887,'2 s  pipe mix  colour pieces             دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-620','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(888,'2 s  pipe mix  colour pieces             دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-621','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(889,'2 s  pipe mix  colour pieces             دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-622','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(890,'2 s  pipe mix  colour pieces             دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-623','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(891,'2 s  pipe mix  colour pieces             دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-626','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(892,'2 s  pipe mix  colour pieces             دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-627','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(893,'2 s  pipe mix  colour pieces             دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-632','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(894,'2 s  pipe mix  colour pieces             دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-633','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(895,'2 s  pipe mix  colour pieces             دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-635','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(896,'2 s  pipe mix  colour pieces             دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-636','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(897,'2 s  pipe mix  colour pieces             دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-638','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(898,'2 s  pipe mix  colour pieces             دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-639','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(899,'2 s  pipe mix  colour pieces             دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-640','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(900,'2 s  pipe mix  colour pieces             دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-641','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(901,'2 s  pipe mix  colour pieces             دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-642','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(902,'2 s  pipe mix  colour pieces             دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-643','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(903,'2 s  pipe mix  colour pieces             دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-645','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(904,'2 s  pipe mix  colour pieces             دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-647','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(905,'2 s  pipe mix  colour pieces             دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-650','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(906,'2 s  pipe mix  colour pieces             دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-652','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(907,'2 s  pipe mix  colour pieces             دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-654','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(908,'2 s  pipe mix  colour pieces             دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-656','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(909,'2 s  pipe mix  colour pieces             دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-657','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(910,'2 s  pipe mix  colour pieces             دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-658','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(911,'2 s  pipe mix  colour pieces             دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-659','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(912,'2 s  pipe mix  colour pieces             دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-660','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(913,'2 s  pipe mix  colour pieces             دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-661','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(914,'2 s  pipe mix  colour pieces            دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-572','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(915,'2 s  pipe mix  colour pieces            دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-583','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(916,'2 s  pipe mix  colour pieces            دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-584','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(917,'2 s  pipe mix  colour pieces            دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-593','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(918,'2 s  pipe mix  colour pieces            دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-595','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(919,'2 s  pipe mix  colour pieces            دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-597','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(920,'2 s  pipe mix  colour pieces            دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-600','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(921,'2 s  pipe mix  colour pieces            دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-604','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(922,'2 s  pipe mix  colour pieces            دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-606','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(923,'2 s  pipe mix  colour pieces            دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-607','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:34','2024-12-04 16:35:34'),(924,'2 s  pipe mix  colour pieces            دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-624','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(925,'2 s  pipe mix  colour pieces            دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-625','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(926,'2 s  pipe mix  colour pieces            دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-628','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(927,'2 s  pipe mix  colour pieces            دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-629','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(928,'2 s  pipe mix  colour pieces            دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-630','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(929,'2 s  pipe mix  colour pieces            دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-631','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(930,'2 s  pipe mix  colour pieces            دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-634','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(931,'2 s  pipe mix  colour pieces            دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-637','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(932,'2 s  pipe mix  colour pieces            دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-644','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(933,'2 s  pipe mix  colour pieces            دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-646','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(934,'2 s  pipe mix  colour pieces            دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-648','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(935,'2 s  pipe mix  colour pieces            دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-649','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(936,'2 s  pipe mix  colour pieces            دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-651','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(937,'2 s  pipe mix  colour pieces            دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-653','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(938,'2 s  pipe mix  colour pieces           دوسوتر پائپ مکس رنگین ٹکڑے',1,'single',18,NULL,NULL,152,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.1/22/26/30-655','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(939,'2 s black china 1/4        1/4 دو سوتر کالا چائنہ',1,'single',18,NULL,NULL,117,144,NULL,NULL,NULL,'inclusive',1,5.0000,'G11.Under glasses rack-98','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(940,'2 s black china 1/4       1/4 دو سوتر کالا چائنہ',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-50','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(941,'2 s black china 1/4       1/4 دو سوتر کالا چائنہ',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-51','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(942,'2 s blue china 1/4          1/4 دو سوتر نیلا چائنہ',1,'single',18,NULL,NULL,117,144,NULL,NULL,NULL,'inclusive',1,5.0000,'G11.Under glasses rack-220','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(943,'2 s double parker  hydrolic  دو سوترڈبل پارکر ہیڈرالک',1,'single',18,NULL,NULL,96,137,NULL,NULL,NULL,'inclusive',1,5.0000,'G4.open-10','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(944,'2 s double parker  hydrolic  دو سوترڈبل پارکر ہیڈرالک',1,'single',18,NULL,NULL,96,137,NULL,NULL,NULL,'inclusive',1,5.0000,'G4.open-11','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(945,'2 s double parker  hydrolic  دو سوترڈبل پارکر ہیڈرالک',1,'single',18,NULL,NULL,96,137,NULL,NULL,NULL,'inclusive',1,5.0000,'G4.open-12','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(946,'2 s horen pipe  دو سوتر ہارن پائپ',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-52','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(947,'2 s mix pices  دو سوتر  مکس ٹکڑے',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-53','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(948,'2 s pipe white pati            دوسوتر سفید پٹی ولائیتی',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-54','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(949,'2 s pipe white pati            دوسوتر سفید پٹی ولائیتی',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-55','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(950,'2 s pvc korea   دو سوتر  پی وی سی کوریا',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-56','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(951,'2 s pvc korea  دو سوتر  پی وی سی کوریا',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-57','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(952,'2 s pvc korea  دو سوتر  پی وی سی کوریا',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-58','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(953,'2 s pvc korea  دو سوتر  پی وی سی کوریا',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-59','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(954,'2 s pvc korea  دو سوتر  پی وی سی کوریا',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-60','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(955,'2 s pvc korea  دو سوتر  پی وی سی کوریا',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-61','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(956,'2 s pvc korea  دو سوتر  پی وی سی کوریا',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-62','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(957,'2 s pvc korea  دو سوتر  پی وی سی کوریا',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-63','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(958,'2 s pvc korea  دو سوتر  پی وی سی کوریا',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-64','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(959,'2 s pvc korea  دو سوتر  پی وی سی کوریا',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-65','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(960,'2 s pvc korea  دو سوتر  پی وی سی کوریا',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-66','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(961,'2 s pvc korea  دو سوتر  پی وی سی کوریا',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-67','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(962,'2 s pvc korea  دو سوتر  پی وی سی کوریا',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-68','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(963,'2 s pvc korea  دو سوتر  پی وی سی کوریا',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-69','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(964,'2 s single hp  hydrolic pieces  دو سوترسنگل ایچ پی ہیڈرالک ٹکڑے',1,'single',18,NULL,NULL,96,137,NULL,NULL,NULL,'inclusive',1,5.0000,'G4.open-13','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(965,'2 s single hp  hydrolic pieces  دو سوترسنگل ایچ پی ہیڈرالک ٹکڑےpcs1',1,'single',18,NULL,NULL,96,137,NULL,NULL,NULL,'inclusive',1,5.0000,'G4.open-14','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(966,'2 s single hp  hydrolic pieces  دو سوترسنگل ایچ پی ہیڈرالک ٹکڑےpcs2',1,'single',18,NULL,NULL,96,137,NULL,NULL,NULL,'inclusive',1,5.0000,'G4.open-15','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(967,'2 s single/double mix piece        دو سوتر سنگل /ڈبل مکس ٹکڑے',1,'single',18,NULL,NULL,154,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.68-12','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(968,'2 s single/double mix piece       دو سوتر سنگل /ڈبل مکس ٹکڑے',1,'single',18,NULL,NULL,155,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.67-10','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(969,'2 s thick white pvc    دوسوتر موٹا سفید پی وی سی',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'g10.open-504','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(970,'2 s white   pvc           دوسوتر سفید ولائیتی',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-70','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(971,'2 s white   pvc           دوسوتر سفید ولائیتی',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-71','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(972,'2 s white pvc            دوسوتر سفید ولائیتی',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-72','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(973,'2 stock upper ٹو سٹوک اپر',1,'single',1,NULL,NULL,102,137,NULL,NULL,NULL,'inclusive',1,5.0000,'G4.25-16','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(974,'2-1/2 s black    5/16             5/16 اڑھائی سوترکالا ولائیتی',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-76','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(975,'2-1/2 s black    5/16           5/16 اڑھائی سوترکالا ولائیتی',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-77','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(976,'2-1/2 s black    5/16           5/16 اڑھائی سوترکالا ولائیتی',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-78','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(977,'2-1/2 s black    5/16           5/16 اڑھائی سوترکالا ولائیتی',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-79','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(978,'2-1/2 s black    5/16           5/16 اڑھائی سوترکالا ولائیتی',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-80','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(979,'2-1/2 s black    5/16           5/16 اڑھائی سوترکالا ولائیتی',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-81','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(980,'2-1/2 s black    5/16           5/16 اڑھائی سوترکالا ولائیتی',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-82','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(981,'2-1/2 s black    5/16           5/16 اڑھائی سوترکالا ولائیتی',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-83','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(982,'2-1/2 s black    5/16           5/16 اڑھائی سوترکالا ولائیتی',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-84','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(983,'2-1/2 s black    5/16           5/16 اڑھائی سوترکالا ولائیتی',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-85','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(984,'2-1/2 s black    5/16           5/16 اڑھائی سوترکالا ولائیتی',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-86','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(985,'2-1/2 s black    5/16           5/16 اڑھائی سوترکالا ولائیتی',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-87','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(986,'2-1/2 s black    5/16           5/16 اڑھائی سوترکالا ولائیتی',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-88','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(987,'2-1/2 s black    5/16           5/16 اڑھائی سوترکالا ولائیتی',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-89','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(988,'2-1/2 s black    5/16           5/16 اڑھائی سوترکالا ولائیتی',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-90','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(989,'2-1/2 s black  france  5/16            5/16 اڑھائی سوترکالا فرانس pcs3',1,'single',18,NULL,NULL,156,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.71-19','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(990,'2-1/2 s black  france  5/16           5/16 اڑھائی سوترکالا فرانس pcs2',1,'single',18,NULL,NULL,157,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.72-22','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(991,'2-1/2 s black  france  5/16          5/16 اڑھائی سوترکالا فرانس',1,'single',18,NULL,NULL,156,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.71-20','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(992,'2-1/2 s black  france  5/16          5/16 اڑھائی سوترکالا فرانس',1,'single',18,NULL,NULL,157,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.72-23','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(993,'2-1/2 s black  france  5/16          5/16 اڑھائی سوترکالا فرانس',1,'single',18,NULL,NULL,157,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.72-24','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(994,'2-1/2 s black  france  5/16         5/16 اڑھائی سوترکالا فرانس pcs1',1,'single',18,NULL,NULL,156,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.71-21','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(995,'2-1/2 s black  france  5/16         5/16 اڑھائی سوترکالا فرانس pcs1',1,'single',18,NULL,NULL,158,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.76-25','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(996,'2-1/2 s black  france  5/16        5/16 اڑھائی سوترکالا فرانس pcs2',1,'single',18,NULL,NULL,158,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.76-26','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(997,'2-1/2 s black  france  5/16  mix pieces                اڑھائی سوترکالا فرانس مکس ٹکڑے 5/16',1,'single',18,NULL,NULL,159,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.77-27','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(998,'2-1/2 s black  france  5/16  mix pieces               اڑھائی سوترکالا فرانس مکس ٹکڑے5/16',1,'single',18,NULL,NULL,159,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.77-28','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(999,'2-1/2 s black  france  5/16  mix pieces               اڑھائی سوترکالا فرانس مکس ٹکڑے5/16',1,'single',18,NULL,NULL,159,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.77-29','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(1000,'2-1/2 s black  france  5/16  mix pieces               اڑھائی سوترکالا فرانس مکس ٹکڑے5/16',1,'single',18,NULL,NULL,159,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.77-30','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(1001,'2-1/2 s black  france  5/16  mix pieces               اڑھائی سوترکالا فرانس مکس ٹکڑے5/16',1,'single',18,NULL,NULL,159,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.77-31','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(1002,'2-1/2 s black  france  5/16  mix pieces              اڑھائی سوترکالا فرانس مکس ٹکڑے5/16',1,'single',18,NULL,NULL,159,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.77-32','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(1003,'2-1/2 s black  france  5/16  mix pieces              اڑھائی سوترکالا فرانس مکس ٹکڑے5/16',1,'single',18,NULL,NULL,159,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.77-33','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(1004,'2-1/2 s black  france  5/16  mix pieces              اڑھائی سوترکالا فرانس مکس ٹکڑے5/16',1,'single',18,NULL,NULL,159,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.77-34','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(1005,'2-1/2 s black  france  5/16  mix pieces              اڑھائی سوترکالا فرانس مکس ٹکڑے5/16',1,'single',18,NULL,NULL,159,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.77-35','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(1006,'2-1/2 s black  france  5/16  mix pieces              اڑھائی سوترکالا فرانس مکس ٹکڑے5/16',1,'single',18,NULL,NULL,159,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.77-36','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(1007,'2-1/2 s black  france  5/16  mix pieces             اڑھائی سوترکالا فرانس مکس ٹکڑے5/16',1,'single',18,NULL,NULL,159,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.77-37','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(1008,'2-1/2 s black  france  5/16  mix pieces             اڑھائی سوترکالا فرانس مکس ٹکڑے5/16',1,'single',18,NULL,NULL,159,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.77-38','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(1009,'2-1/2 s black  france  5/16  mix pieces            اڑھائی سوترکالا فرانس مکس ٹکڑے5/16',1,'single',18,NULL,NULL,159,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.77-39','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(1010,'2-1/2 s black  france  5/16  mix pieces           اڑھائی سوترکالا فرانس مکس ٹکڑے5/16',1,'single',18,NULL,NULL,159,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.77-40','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(1011,'2-1/2 s black  france  5/16  mix pieces         اڑھائی سوترکالا فرانس مکس ٹکڑے5/16',1,'single',18,NULL,NULL,159,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.77-41','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(1012,'2-1/2 s black  france  5/16  mix pieces     اڑھائی سوترکالا فرانس مکس ٹکڑے 5/16',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-91','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(1013,'2-1/2 s black  france  5/16  oper dhaga             اڑھائی سوترکالا فرانس اوپر دھاگہ5/16',1,'single',18,NULL,NULL,159,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.77-42','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(1014,'2-1/2 s black  france  5/16  oper dhaga          اڑھائی سوترکالا فرانس اوپر دھاگہ5/16',1,'single',18,NULL,NULL,159,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.77-43','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(1015,'2-1/2 s black  france  5/16  oper dhaga         اڑھائی سوترکالا فرانس اوپر دھاگہ5/16',1,'single',18,NULL,NULL,159,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.77-44','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(1016,'2-1/2 s black  france  5/16  pati wala                      اڑھائی سوترکالا فرانس پٹی والا5/16',1,'single',18,NULL,NULL,159,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.77-45','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(1017,'2-1/2 s black  france different pieces  5/16                 اڑھائی سوترکالا فرانس مختلف ٹکڑے 5/16pcs5',1,'single',18,NULL,NULL,160,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.78-46','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(1018,'2-1/2 s black  france different pieces  5/16                اڑھائی سوترکالا فرانس مختلف ٹکڑے 5/16',1,'single',18,NULL,NULL,160,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.78-47','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(1019,'2-1/2 s black  france different pieces  5/16                اڑھائی سوترکالا فرانس مختلف ٹکڑے 5/16pcs1',1,'single',18,NULL,NULL,160,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.78-48','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(1020,'2-1/2 s black  france different pieces  5/16                اڑھائی سوترکالا فرانس مختلف ٹکڑے 5/16pcs1',1,'single',18,NULL,NULL,160,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.78-49','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(1021,'2-1/2 s black  france different pieces  5/16                اڑھائی سوترکالا فرانس مختلف ٹکڑے 5/16pcs1',1,'single',18,NULL,NULL,160,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.78-50','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(1022,'2-1/2 s black  france different pieces  5/16                اڑھائی سوترکالا فرانس مختلف ٹکڑے 5/16pcs1',1,'single',18,NULL,NULL,160,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.78-51','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(1023,'2-1/2 s black  france different pieces  5/16                اڑھائی سوترکالا فرانس مختلف ٹکڑے 5/16pcs1',1,'single',18,NULL,NULL,160,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.78-52','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(1024,'2-1/2 s black  france different pieces  5/16                اڑھائی سوترکالا فرانس مختلف ٹکڑے 5/16pcs1',1,'single',18,NULL,NULL,160,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.78-53','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(1025,'2-1/2 s black  france different pieces  5/16                اڑھائی سوترکالا فرانس مختلف ٹکڑے 5/16pcs1',1,'single',18,NULL,NULL,160,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.78-54','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(1026,'2-1/2 s black  france different pieces  5/16                اڑھائی سوترکالا فرانس مختلف ٹکڑے 5/16pcs2',1,'single',18,NULL,NULL,160,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.78-55','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:35','2024-12-04 16:35:35'),(1027,'2-1/2 s black  france different pieces  5/16                اڑھائی سوترکالا فرانس مختلف ٹکڑے 5/16pcs2',1,'single',18,NULL,NULL,160,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.78-56','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1028,'2-1/2 s black  france different pieces  5/16                اڑھائی سوترکالا فرانس مختلف ٹکڑے 5/16pcs2',1,'single',18,NULL,NULL,160,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.78-57','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1029,'2-1/2 s black  france different pieces  5/16                اڑھائی سوترکالا فرانس مختلف ٹکڑے 5/16pcs2',1,'single',18,NULL,NULL,160,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.78-58','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1030,'2-1/2 s black  france different pieces  5/16                اڑھائی سوترکالا فرانس مختلف ٹکڑے 5/16pcs2',1,'single',18,NULL,NULL,160,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.78-59','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1031,'2-1/2 s black  france different pieces  5/16                اڑھائی سوترکالا فرانس مختلف ٹکڑے 5/16pcs2',1,'single',18,NULL,NULL,160,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.78-60','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1032,'2-1/2 s black  france different pieces  5/16                اڑھائی سوترکالا فرانس مختلف ٹکڑے 5/16pcs3',1,'single',18,NULL,NULL,160,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.78-61','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1033,'2-1/2 s black  france different pieces  5/16                اڑھائی سوترکالا فرانس مختلف ٹکڑے 5/16pcs3',1,'single',18,NULL,NULL,160,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.78-62','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1034,'2-1/2 s black  france different pieces  5/16                اڑھائی سوترکالا فرانس مختلف ٹکڑے 5/16pcs4',1,'single',18,NULL,NULL,160,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.78-63','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1035,'2-1/2 s black  france different pieces  5/16                اڑھائی سوترکالا فرانس مختلف ٹکڑے 5/16pcs4',1,'single',18,NULL,NULL,160,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.78-64','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1036,'2-1/2 s black  france different pieces  5/16                اڑھائی سوترکالا فرانس مختلف ٹکڑے 5/16pcs4',1,'single',18,NULL,NULL,160,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.78-65','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1037,'2-1/2 s black  france different pieces  5/16                اڑھائی سوترکالا فرانس مختلف ٹکڑے 5/16pcs4',1,'single',18,NULL,NULL,160,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.78-66','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1038,'2-1/2 s black  france different pieces  5/16                اڑھائی سوترکالا فرانس مختلف ٹکڑے 5/16pcs5',1,'single',18,NULL,NULL,160,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.78-67','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1039,'2-1/2 s black  france different pieces  5/16                اڑھائی سوترکالا فرانس مختلف ٹکڑے 5/16pcs5',1,'single',18,NULL,NULL,160,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.78-68','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1040,'2-1/2 s black  france different pieces  5/16                اڑھائی سوترکالا فرانس مختلف ٹکڑے 5/16pcs6',1,'single',18,NULL,NULL,160,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.78-69','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1041,'2-1/2 s black  france different pieces  5/16                اڑھائی سوترکالا فرانس مختلف ٹکڑے 5/16pcs6',1,'single',18,NULL,NULL,160,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.78-70','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1042,'2-1/2 s black  france different pieces  5/16                اڑھائی سوترکالا فرانس مختلف ٹکڑے 5/16pcs7',1,'single',18,NULL,NULL,160,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.78-71','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1043,'2-1/2 s black  france different pieces  5/16                اڑھائی سوترکالا فرانس مختلف ٹکڑے 5/16pcs8',1,'single',18,NULL,NULL,160,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.78-72','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1044,'2-1/2 s black  france different pieces  5/16                اڑھائی سوترکالا فرانس مختلف ٹکڑے 5/16pcs8',1,'single',18,NULL,NULL,160,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.78-73','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1045,'2-1/2 s black  france different pieces  5/16                اڑھائی سوترکالا فرانس مختلف ٹکڑے 5/16pcs9',1,'single',18,NULL,NULL,160,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.78-74','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1046,'2-1/2 s black  france different pieces  5/16               اڑھائی سوترکالا فرانس مختلف ٹکڑے 5/16',1,'single',18,NULL,NULL,160,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.78-75','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1047,'2-1/2 s black  france different pieces  5/16               اڑھائی سوترکالا فرانس مختلف ٹکڑے 5/16',1,'single',18,NULL,NULL,160,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.78-76','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1048,'2-1/2 s black  france different pieces  5/16               اڑھائی سوترکالا فرانس مختلف ٹکڑے 5/16',1,'single',18,NULL,NULL,160,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.78-77','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1049,'2-1/2 s black  france different pieces  5/16               اڑھائی سوترکالا فرانس مختلف ٹکڑے 5/16',1,'single',18,NULL,NULL,160,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.78-78','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1050,'2-1/2 s black  france different pieces  5/16               اڑھائی سوترکالا فرانس مختلف ٹکڑے 5/16',1,'single',18,NULL,NULL,160,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.78-79','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1051,'2-1/2 s black  france different pieces  5/16               اڑھائی سوترکالا فرانس مختلف ٹکڑے 5/16pcs1',1,'single',18,NULL,NULL,160,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.78-80','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1052,'2-1/2 s black  france different pieces  5/16               اڑھائی سوترکالا فرانس مختلف ٹکڑے 5/16pcs1',1,'single',18,NULL,NULL,160,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.78-81','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1053,'2-1/2 s black  france different pieces  5/16               اڑھائی سوترکالا فرانس مختلف ٹکڑے 5/16pcs1',1,'single',18,NULL,NULL,160,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.78-82','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1054,'2-1/2 s black  france different pieces  5/16               اڑھائی سوترکالا فرانس مختلف ٹکڑے 5/16pcs1',1,'single',18,NULL,NULL,160,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.78-83','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1055,'2-1/2 s black  france different pieces  5/16               اڑھائی سوترکالا فرانس مختلف ٹکڑے 5/16pcs10',1,'single',18,NULL,NULL,160,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.78-84','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1056,'2-1/2 s black  france different pieces  5/16               اڑھائی سوترکالا فرانس مختلف ٹکڑے 5/16pcs2',1,'single',18,NULL,NULL,160,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.78-85','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1057,'2-1/2 s black  france different pieces  5/16               اڑھائی سوترکالا فرانس مختلف ٹکڑے 5/16pcs2',1,'single',18,NULL,NULL,160,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.78-86','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1058,'2-1/2 s black  france different pieces  5/16               اڑھائی سوترکالا فرانس مختلف ٹکڑے 5/16pcs2',1,'single',18,NULL,NULL,160,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.78-87','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1059,'2-1/2 s black  france different pieces  5/16               اڑھائی سوترکالا فرانس مختلف ٹکڑے 5/16pcs2',1,'single',18,NULL,NULL,160,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.78-88','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1060,'2-1/2 s black  france different pieces  5/16               اڑھائی سوترکالا فرانس مختلف ٹکڑے 5/16pcs3',1,'single',18,NULL,NULL,160,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.78-89','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1061,'2-1/2 s black  france different pieces  5/16               اڑھائی سوترکالا فرانس مختلف ٹکڑے 5/16pcs3',1,'single',18,NULL,NULL,160,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.78-90','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1062,'2-1/2 s black  france different pieces  5/16               اڑھائی سوترکالا فرانس مختلف ٹکڑے 5/16pcs3',1,'single',18,NULL,NULL,160,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.78-91','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1063,'2-1/2 s black  france different pieces  5/16               اڑھائی سوترکالا فرانس مختلف ٹکڑے 5/16pcs3',1,'single',18,NULL,NULL,160,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.78-92','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1064,'2-1/2 s black  france different pieces  5/16               اڑھائی سوترکالا فرانس مختلف ٹکڑے 5/16pcs3',1,'single',18,NULL,NULL,160,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.78-93','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1065,'2-1/2 s black  france different pieces  5/16               اڑھائی سوترکالا فرانس مختلف ٹکڑے 5/16pcs3',1,'single',18,NULL,NULL,160,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.78-94','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1066,'2-1/2 s black  france different pieces  5/16               اڑھائی سوترکالا فرانس مختلف ٹکڑے 5/16pcs4',1,'single',18,NULL,NULL,160,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.78-95','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1067,'2-1/2 s black  france different pieces  5/16               اڑھائی سوترکالا فرانس مختلف ٹکڑے 5/16pcs5',1,'single',18,NULL,NULL,160,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.78-96','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1068,'2-1/2 s black  france different pieces  5/16               اڑھائی سوترکالا فرانس مختلف ٹکڑے 5/16pcs7',1,'single',18,NULL,NULL,160,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.78-97','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1069,'2-1/2 s black  france different pieces  5/16               اڑھائی سوترکالا فرانس مختلف ٹکڑے 5/16pcs7',1,'single',18,NULL,NULL,160,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.78-98','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1070,'2-1/2 s black  france different pieces  5/16               اڑھائی سوترکالا فرانس مختلف ٹکڑے 5/16pcs9',1,'single',18,NULL,NULL,160,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.78-99','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1071,'2-1/2 s black  france different pieces  5/16              اڑھائی سوترکالا فرانس مختلف ٹکڑے 5/16',1,'single',18,NULL,NULL,160,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.78-100','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1072,'2-1/2 s black  france different pieces  5/16              اڑھائی سوترکالا فرانس مختلف ٹکڑے 5/16pcs1',1,'single',18,NULL,NULL,160,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.78-101','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1073,'2-1/2 s black  france different pieces  5/16              اڑھائی سوترکالا فرانس مختلف ٹکڑے 5/16pcs1',1,'single',18,NULL,NULL,160,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.78-102','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1074,'2-1/2 s black  france different pieces  5/16              اڑھائی سوترکالا فرانس مختلف ٹکڑے 5/16pcs2',1,'single',18,NULL,NULL,160,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.78-103','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1075,'2-1/2 s black  france different pieces  5/16              اڑھائی سوترکالا فرانس مختلف ٹکڑے 5/16pcs2',1,'single',18,NULL,NULL,160,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.78-104','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1076,'2-1/2 s black  france different pieces  5/16              اڑھائی سوترکالا فرانس مختلف ٹکڑے 5/16pcs2',1,'single',18,NULL,NULL,160,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.78-105','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1077,'2-1/2 s black  france different pieces  5/16              اڑھائی سوترکالا فرانس مختلف ٹکڑے 5/16pcs3',1,'single',18,NULL,NULL,160,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.78-106','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1078,'2-1/2 s black  france different pieces  5/16              اڑھائی سوترکالا فرانس مختلف ٹکڑے 5/16pcs3',1,'single',18,NULL,NULL,160,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.78-107','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1079,'2-1/2 s black  france different pieces  5/16              اڑھائی سوترکالا فرانس مختلف ٹکڑے 5/16pcs4',1,'single',18,NULL,NULL,160,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.78-108','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1080,'2-1/2 s black  france different pieces  5/16              اڑھائی سوترکالا فرانس مختلف ٹکڑے 5/16pcs4',1,'single',18,NULL,NULL,160,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.78-109','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1081,'2-1/2 s black  france different pieces  5/16              اڑھائی سوترکالا فرانس مختلف ٹکڑے 5/16pcs5',1,'single',18,NULL,NULL,160,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.78-110','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1082,'2-1/2 s black  france different pieces  5/16              اڑھائی سوترکالا فرانس مختلف ٹکڑے 5/16pcs6',1,'single',18,NULL,NULL,160,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.78-111','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1083,'2-1/2 s black  france different pieces  5/16              اڑھائی سوترکالا فرانس مختلف ٹکڑے 5/16pcs6',1,'single',18,NULL,NULL,160,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.78-112','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1084,'2-1/2 s black  france different pieces  5/16              اڑھائی سوترکالا فرانس مختلف ٹکڑے 5/16pcs7',1,'single',18,NULL,NULL,160,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.78-113','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1085,'2-1/2 s black  france different pieces  5/16             اڑھائی سوترکالا فرانس مختلف ٹکڑے 5/16pcs1',1,'single',18,NULL,NULL,160,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.78-114','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1086,'2-1/2 s black  france different pieces  5/16             اڑھائی سوترکالا فرانس مختلف ٹکڑے 5/16pcs2',1,'single',18,NULL,NULL,160,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.78-115','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1087,'2-1/2 s black  france different pieces  5/16             اڑھائی سوترکالا فرانس مختلف ٹکڑے 5/16pcs4',1,'single',18,NULL,NULL,160,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.78-116','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1088,'2-1/2 s black  france different pieces  5/16             اڑھائی سوترکالا فرانس مختلف ٹکڑے 5/16pcs5',1,'single',18,NULL,NULL,160,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.78-117','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1089,'2-1/2 s black  korea  5/16             5/16 اڑھائی سوترکالا کوریا',1,'single',18,NULL,NULL,150,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.85-251','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1090,'2-1/2 s black  korea  5/16             5/16 اڑھائی سوترکالا کوریا',1,'single',18,NULL,NULL,150,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.85-252','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1091,'2-1/2 s black  korea  5/16             5/16 اڑھائی سوترکالا کوریا',1,'single',18,NULL,NULL,150,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.85-253','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1092,'2-1/2 s black  korea  5/16             5/16 اڑھائی سوترکالا کوریا',1,'single',18,NULL,NULL,150,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.85-254','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1093,'2-1/2 s black  korea  5/16             5/16 اڑھائی سوترکالا کوریا',1,'single',18,NULL,NULL,150,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.85-255','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1094,'2-1/2 s black  korea  5/16             5/16 اڑھائی سوترکالا کوریا',1,'single',18,NULL,NULL,150,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.85-256','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1095,'2-1/2 s black  korea  5/16             5/16 اڑھائی سوترکالا کوریا pcs1',1,'single',18,NULL,NULL,150,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.85-257','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1096,'2-1/2 s black  korea  5/16            5/16 اڑھائی سوترکالا کوریا pcs2',1,'single',18,NULL,NULL,150,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.85-258','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1097,'2-1/2 s black  korea  5/16           5/16 اڑھائی سوترکالا کوریا',1,'single',18,NULL,NULL,150,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.85-259','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1098,'2-1/2 s black 5/16           5/16 اڑھائی سوترکالا فرانس',1,'single',18,NULL,NULL,161,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.90-282','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1099,'2-1/2 s black 5/16           5/16 اڑھائی سوترکالا فرانس',1,'single',18,NULL,NULL,161,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.90-283','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1100,'2-1/2 s black 5/16        5/16 اڑھائی سوترکالا فرانس',1,'single',18,NULL,NULL,161,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.90-284','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1101,'2-1/2 s black china 5/16      5/16 اڑھائی سوترکالا چائنہ',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-92','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1102,'2-1/2 s black china 5/16      5/16 اڑھائی سوترکالا چائنہ',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-93','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1103,'2-1/2 s black china 5/16     5/16 اڑھائی سوترکالا چائنہ',1,'single',18,NULL,NULL,117,144,NULL,NULL,NULL,'inclusive',1,5.0000,'G11.Under glasses rack-221','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1104,'2-1/2 s black china 5/16     5/16 اڑھائی سوترکالا چائنہ',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-94','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1105,'2-1/2 s black china 5/16     5/16 اڑھائی سوترکالا چائنہ',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-95','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1106,'2-1/2 s black china 5/16     5/16 اڑھائی سوترکالا چائنہ',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-96','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1107,'2-1/2 s black china 5/16     5/16 اڑھائی سوترکالا چائنہ',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-97','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1108,'2-1/2 s black china 5/16     5/16 اڑھائی سوترکالا چائنہ',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-98','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1109,'2-1/2 s black china 5/16     5/16 اڑھائی سوترکالا چائنہ',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-99','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1110,'2-1/2 s black inside blue spacial  china 5/16         5/16 اڑھائی سوترکالا اندر نیلا اسپیشل چائنہ',1,'single',18,NULL,NULL,117,144,NULL,NULL,NULL,'inclusive',1,5.0000,'G11.Under glasses rack-99','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1111,'2-1/2 s black inside blue spacial  china 5/16         5/16 اڑھائی سوترکالا اندر نیلا اسپیشل چائنہ',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-100','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1112,'2-1/2 s black inside blue spacial  china 5/16       5/16 اڑھائی سوترکالا اندر نیلا اسپیشل چائنہ',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-101','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1113,'2-1/2 s black inside blue spacial  china 5/16       5/16 اڑھائی سوترکالا اندر نیلا اسپیشل چائنہ',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-102','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1114,'2-1/2 s blue  5/16        5/16 اڑھائی سوترنیلافرانس',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-103','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1115,'2-1/2 s blue  5/16        5/16 اڑھائی سوترنیلافرانس',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-104','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1116,'2-1/2 s blue 5/16   164ft     5/16 اڑھائی سوترنیلافرانس',1,'single',18,NULL,NULL,117,144,NULL,NULL,NULL,'inclusive',1,5.0000,'G11.Under glasses rack-107','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1117,'2-1/2 s blue china 5/16         5/16 اڑھائی سوتراسپیشل نیلا چائنہ',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-105','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:36','2024-12-04 16:35:36'),(1118,'2-1/2 s blue china 5/16         5/16 اڑھائی سوتراسپیشل نیلا چائنہ',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-106','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1119,'2-1/2 s blue china 5/16         5/16 اڑھائی سوتراسپیشل نیلا چائنہ',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-107','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1120,'2-1/2 s blue itly  5/16        5/16 اڑھائی سوترنیلا اٹلی',1,'single',18,NULL,NULL,162,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.81-202','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1121,'2-1/2 s blue itly  5/16        5/16 اڑھائی سوترنیلا اٹلی',1,'single',18,NULL,NULL,162,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.81-203','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1122,'2-1/2 s blue itly  5/16        5/16 اڑھائی سوترنیلا اٹلی',1,'single',18,NULL,NULL,162,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.81-204','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1123,'2-1/2 s blue itly  5/16        5/16 اڑھائی سوترنیلا اٹلی',1,'single',18,NULL,NULL,162,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.81-205','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1124,'2-1/2 s blue itly  5/16        5/16 اڑھائی سوترنیلا اٹلی',1,'single',18,NULL,NULL,162,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.81-206','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1125,'2-1/2 s blue itly  5/16        5/16 اڑھائی سوترنیلا اٹلی',1,'single',18,NULL,NULL,162,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.81-207','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1126,'2-1/2 s blue itly  5/16        5/16 اڑھائی سوترنیلا اٹلی',1,'single',18,NULL,NULL,162,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.81-208','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1127,'2-1/2 s blue itly  5/16        5/16 اڑھائی سوترنیلا اٹلی',1,'single',18,NULL,NULL,162,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.81-209','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1128,'2-1/2 s blue itly  5/16        5/16 اڑھائی سوترنیلا اٹلی',1,'single',18,NULL,NULL,162,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.81-210','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1129,'2-1/2 s blue itly  5/16        5/16 اڑھائی سوترنیلا اٹلی pcs1',1,'single',18,NULL,NULL,162,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.81-211','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1130,'2-1/2 s blue itly  5/16        5/16 اڑھائی سوترنیلا اٹلی pcs1',1,'single',18,NULL,NULL,162,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.81-212','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1131,'2-1/2 s blue itly  5/16        5/16 اڑھائی سوترنیلا اٹلی pcs2',1,'single',18,NULL,NULL,162,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.81-213','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1132,'2-1/2 s blue itly  5/16       5/16 اڑھائی سوترنیلا اٹلی',1,'single',18,NULL,NULL,162,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.81-214','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1133,'2-1/2 s blue itly  5/16       5/16 اڑھائی سوترنیلا اٹلی',1,'single',18,NULL,NULL,162,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.81-215','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1134,'2-1/2 s blue itly  5/16       5/16 اڑھائی سوترنیلا اٹلی',1,'single',18,NULL,NULL,162,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.81-216','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1135,'2-1/2 s blue itly  5/16       5/16 اڑھائی سوترنیلا اٹلی',1,'single',18,NULL,NULL,162,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.81-217','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1136,'2-1/2 s blue itly  5/16       5/16 اڑھائی سوترنیلا اٹلی',1,'single',18,NULL,NULL,162,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.81-218','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1137,'2-1/2 s blue itly  5/16       5/16 اڑھائی سوترنیلا اٹلی pcs1',1,'single',18,NULL,NULL,162,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.81-219','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1138,'2-1/2 s blue itly  5/16       5/16 اڑھائی سوترنیلا اٹلی pcs1',1,'single',18,NULL,NULL,162,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.81-220','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1139,'2-1/2 s blue itly  5/16       5/16 اڑھائی سوترنیلا اٹلی pcs2',1,'single',18,NULL,NULL,162,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.81-221','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1140,'2-1/2 s blue itly  5/16       5/16 اڑھائی سوترنیلا اٹلی pcs2',1,'single',18,NULL,NULL,162,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.81-222','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1141,'2-1/2 s blue itly  5/16       5/16 اڑھائی سوترنیلا اٹلی pcs3',1,'single',18,NULL,NULL,162,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.81-223','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1142,'2-1/2 s blue itly  5/16      5/16 اڑھائی سوترنیلا اٹلی',1,'single',18,NULL,NULL,162,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.81-224','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1143,'2-1/2 s blue itly  5/16      5/16 اڑھائی سوترنیلا اٹلی',1,'single',18,NULL,NULL,162,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.81-225','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1144,'2-1/2 s blue itly  5/16      5/16 اڑھائی سوترنیلا اٹلی',1,'single',18,NULL,NULL,162,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.81-226','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1145,'2-1/2 s blue itly  5/16      5/16 اڑھائی سوترنیلا اٹلی pcs2',1,'single',18,NULL,NULL,162,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.81-227','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1146,'2-1/2 s green  itly   5/16        5/16 اڑھائی سوترسبز ولائیتی',1,'single',18,NULL,NULL,163,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.84-248','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1147,'2-1/2 s green  itly   5/16        5/16 اڑھائی سوترسبز ولائیتی',1,'single',18,NULL,NULL,163,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.84-249','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1148,'2-1/2 s green  itly   5/16       5/16 اڑھائی سوترسبز ولائیتی',1,'single',18,NULL,NULL,163,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.84-250','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1149,'2-1/2 s orange  itly  5/16            5/16 اڑھائی سوترمالٹا اٹلی',1,'single',18,NULL,NULL,140,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.82-228','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1150,'2-1/2 s orange  itly  5/16            5/16 اڑھائی سوترمالٹا اٹلی',1,'single',18,NULL,NULL,140,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.82-229','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1151,'2-1/2 s orange  itly  5/16            5/16 اڑھائی سوترمالٹا اٹلی',1,'single',18,NULL,NULL,140,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.82-230','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1152,'2-1/2 s orange  itly  5/16            5/16 اڑھائی سوترمالٹا اٹلی',1,'single',18,NULL,NULL,140,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.82-231','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1153,'2-1/2 s orange  itly  5/16            5/16 اڑھائی سوترمالٹا اٹلی',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-108','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1154,'2-1/2 s orange  itly  5/16            5/16 اڑھائی سوترمالٹا اٹلی pcs1',1,'single',18,NULL,NULL,140,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.82-232','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1155,'2-1/2 s orange  itly  5/16            5/16 اڑھائی سوترمالٹا اٹلی pcs2',1,'single',18,NULL,NULL,140,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.82-233','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1156,'2-1/2 s orange  itly  5/16         5/16 اڑھائی سوترمالٹا اٹلی',1,'single',18,NULL,NULL,140,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.82-234','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1157,'2-1/2 s orange  itly  5/16        5/16 اڑھائی سوترمالٹا اٹلی',1,'single',18,NULL,NULL,140,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.82-235','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1158,'2-1/2 s orange  itly  5/16      5/16 اڑھائی سوترمالٹا اٹلی',1,'single',18,NULL,NULL,140,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.82-236','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1159,'2-1/2 s orange inside wire  5/16             5/16 اڑھائی سوترمالٹا اندر تار کوریا',1,'single',18,NULL,NULL,164,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.87-260','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1160,'2-1/2 s orange inside wire  5/16             5/16 اڑھائی سوترمالٹا اندر تار کوریا',1,'single',18,NULL,NULL,164,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.87-261','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1161,'2-1/2 s orange inside wire  5/16             5/16 اڑھائی سوترمالٹا اندر تار کوریا',1,'single',18,NULL,NULL,164,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.87-262','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1162,'2-1/2 s orange inside wire  5/16            5/16 اڑھائی سوترمالٹا اندر تار کوریا',1,'single',18,NULL,NULL,164,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.87-263','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1163,'2-1/2 s orange inside wire  5/16            5/16 اڑھائی سوترمالٹا اندر تار کوریا',1,'single',18,NULL,NULL,164,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.87-264','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1164,'2-1/2 s red  5/16        5/16 اڑھائی سوترلال ولائیتی',1,'single',18,NULL,NULL,113,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.83-237','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1165,'2-1/2 s red  5/16        5/16 اڑھائی سوترلال ولائیتی pcs1',1,'single',18,NULL,NULL,113,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.83-238','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1166,'2-1/2 s red  5/16        5/16 اڑھائی سوترلال ولائیتی pcs2',1,'single',18,NULL,NULL,113,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.83-239','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1167,'2-1/2 s red  5/16       5/16 اڑھائی سوترلال ولائیتی',1,'single',18,NULL,NULL,113,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.83-240','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1168,'2-1/2 s red  5/16       5/16 اڑھائی سوترلال ولائیتی',1,'single',18,NULL,NULL,113,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.83-241','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1169,'2-1/2 s red  5/16       5/16 اڑھائی سوترلال ولائیتی',1,'single',18,NULL,NULL,113,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.83-242','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1170,'2-1/2 s red  5/16       5/16 اڑھائی سوترلال ولائیتی',1,'single',18,NULL,NULL,113,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.83-243','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1171,'2-1/2 s red  5/16       5/16 اڑھائی سوترلال ولائیتی',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-109','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1172,'2-1/2 s red  5/16       5/16 اڑھائی سوترلال ولائیتی pcs1',1,'single',18,NULL,NULL,113,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.83-244','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1173,'2-1/2 s red  5/16       5/16 اڑھائی سوترلال ولائیتی pcs2',1,'single',18,NULL,NULL,113,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.83-245','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1174,'2-1/2 s red  5/16      5/16 اڑھائی سوترلال ولائیتی',1,'single',18,NULL,NULL,113,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.83-246','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1175,'2-1/2 s red  5/16      5/16 اڑھائی سوترلال ولائیتی',1,'single',18,NULL,NULL,113,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.83-247','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1176,'2-1/2 s single       اڑھائی سوتر سنگل ہیڈرالک',1,'single',18,NULL,NULL,96,137,NULL,NULL,NULL,'inclusive',1,5.0000,'G4.open-20','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1177,'2-1/2 s single       اڑھائی سوتر سنگل ہیڈرالک',1,'single',18,NULL,NULL,96,137,NULL,NULL,NULL,'inclusive',1,5.0000,'G4.open-21','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1178,'2-1/2 s single+double mix pieces       اڑھائی سوتر سنگل+ڈبل مکس ٹکڑے ہیڈرالک',1,'single',18,NULL,NULL,96,137,NULL,NULL,NULL,'inclusive',1,5.0000,'G4.open-22','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1179,'2-1/2 s single+double mix pieces       اڑھائی سوتر سنگل+ڈبل مکس ٹکڑے ہیڈرالک',1,'single',18,NULL,NULL,96,137,NULL,NULL,NULL,'inclusive',1,5.0000,'G4.open-23','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1180,'2-1/2 s single+double mix pieces       اڑھائی سوتر سنگل+ڈبل مکس ٹکڑے ہیڈرالک',1,'single',18,NULL,NULL,96,137,NULL,NULL,NULL,'inclusive',1,5.0000,'G4.open-24','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1181,'2-1/2 s thick white pipe اڑھائی سوتر موٹا سفید پائپ',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'g10.open-505','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1182,'2-1/2 s white pvc    اڑھائی سوتر سفید پی وی سی',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-110','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1183,'2-1/2 s white pvc    اڑھائی سوتر سفید پی وی سی',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-111','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1184,'2-1/2 s white pvc    اڑھائی سوتر سفید پی وی سی',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-112','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1185,'2-1/2 s white pvc    اڑھائی سوتر سفید پی وی سی',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-113','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1186,'2-1/2 s white pvc    اڑھائی سوتر سفید پی وی سی',1,'single',18,NULL,NULL,96,143,NULL,NULL,NULL,'inclusive',1,5.0000,'G10.open-114','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1187,'2-1/2\' leangth 3 s double  lock fitting     اڑھائی  فٹ لمبا تین سوتر ڈبل لا ک فٹنگ عام فتنگ',1,'single',1,NULL,NULL,85,134,NULL,NULL,NULL,'inclusive',1,5.0000,'G3.8-50','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1188,'2-1/2\' leangth 3 s double jack pipe   اڑھائی فٹ لمبا تین سوترڈبل جیک پائپ. چائینہ فتنگ',1,'single',1,NULL,NULL,69,134,NULL,NULL,NULL,'inclusive',1,5.0000,'G3.19-51','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1189,'2-1/2\' leangth 3 s double jack pipe straight   اڑھائی  فٹ لمباتین سوترڈبل جیک پائپ سیدھا عام فتنگ',1,'single',1,NULL,NULL,73,134,NULL,NULL,NULL,'inclusive',1,5.0000,'G3.48-52','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1190,'2-1/2\' leangth 3 s single ,375 7\' ka bend     اڑھائی فٹ لمبا تین سوتر سنگل 375 کا 7 فٹ کا بینڈ عام بینڈ',1,'single',1,NULL,NULL,108,134,NULL,NULL,NULL,'inclusive',1,5.0000,'G3.17-53','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1191,'2-1/2\' leangth 3 s single ,375 7\' ka bend one side under & other side bahir chore اڑھائی فٹ لمبا تین سوتر سنگل 375 کا 7 فٹ سیدھا ایک طرف اندراور دوسری طرف باہر چوڑی چائنہ فتنگ',1,'single',1,NULL,NULL,108,134,NULL,NULL,NULL,'inclusive',1,5.0000,'G3.17-54','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1192,'2-1/2\' leangth 3 s single ,375 7\' ka straight aam fitting  اڑھائی فٹ لمبا تین سوتر سنگل 375 کا 7 فٹ کا سیدھا عام فتنگ',1,'single',1,NULL,NULL,108,134,NULL,NULL,NULL,'inclusive',1,5.0000,'G3.17-55','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1193,'2-1/2\' leangth 3 s single ,375 7\' ka straight china fitting   اڑھائی فٹ لمبا تین سوتر سنگل 375 کا 7 فٹ کا سیدھا چائنہ فٹنگ',1,'single',1,NULL,NULL,108,134,NULL,NULL,NULL,'inclusive',1,5.0000,'G3.17-56','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:37','2024-12-04 16:35:37'),(1194,'2-1/2\' leangth 3 s single ,375 7\' ka straight china fitting   اڑھائی فٹ لمبا تین سوتر سنگل 375 کا 7 فٹ کا سیدھا چائنہ فٹنگ',1,'single',1,NULL,NULL,99,144,NULL,NULL,NULL,'inclusive',1,5.0000,'G11.on a glass rack-194','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1195,'2-1/2\' leangth 3 s single ,375 7\' one side andar  chore & other side bahir chori amm fitting   اڑھائی فٹ لمبا تین سوتر سنگل 375 کا 7 فٹ کاایک طرف اندر دوسری طرف باہر چوڑی عام فتنگ',1,'single',1,NULL,NULL,108,134,NULL,NULL,NULL,'inclusive',1,5.0000,'G3.17-57','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1196,'2-1/2\' leangth 3 s single ,375 7\' one side andar  chore & other side bahir chori china fitting   اڑھائی فٹ لمبا تین سوتر سنگل 375 کا 7 فٹ کاایک طرف اندر دوسری طرف باہر چوڑی چائنہ فتنگ',1,'single',1,NULL,NULL,108,134,NULL,NULL,NULL,'inclusive',1,5.0000,'G3.17-58','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1197,'2-1/2\' leangth 3 s single jack pipe straight   اڑھائی فٹ لمباتین سوترسنگل جیک پائپ سیدھا عام  فتنگ',1,'single',1,NULL,NULL,70,134,NULL,NULL,NULL,'inclusive',1,5.0000,'G3.35-59','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1198,'2-1/2\' leangth 4 s double jack pipe straight   اڑھائی فٹ لمباچارسوترڈبل جیک پائپ سیدھا عام فتنگ',1,'single',1,NULL,NULL,73,134,NULL,NULL,NULL,'inclusive',1,5.0000,'G3.48-60','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1199,'2-1/2\' leangth 4 s single jack pipe  اڑھائی فٹ لمباچارسوترسنگل  پائپ چائنہ فتنگ',1,'single',1,NULL,NULL,114,134,NULL,NULL,NULL,'inclusive',1,5.0000,'G3.24-61','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1200,'2-1/2\' leangth 4 s single jack pipe bend   اڑھائی فٹ لمباچارسوترسنگل جیک پائپ بینڈ عام فتنگ',1,'single',1,NULL,NULL,165,134,NULL,NULL,NULL,'inclusive',1,5.0000,'G3.20-62','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1201,'2-1/2\' leangth 4 s single jack pipe giko bend   اڑھائی فٹ لمباچارسوترسنگل جیک پائپ جیکو بینڈ عام فتنگ',1,'single',1,NULL,NULL,166,134,NULL,NULL,NULL,'inclusive',1,5.0000,'G3.21-63','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1202,'2-1/2\' leangth 4 s single jack pipe giko straight   اڑھائی فٹ چارسوترسنگل جیک پائپ جیکو سیدھا عام فتنگ',1,'single',1,NULL,NULL,166,134,NULL,NULL,NULL,'inclusive',1,5.0000,'G3.21-64','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1203,'2-1/2\' leangth 4 s single jack pipe straight   اڑھائی فٹ لمبا چار سوتر سنگل جیک پائپ سیدھا عام فٹنگ',1,'single',1,NULL,NULL,167,134,NULL,NULL,NULL,'inclusive',1,5.0000,'G3.2-65','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1204,'2-1/2\' leangth jecko bend اڑھائی فٹ جیکو بینڈ چائنہ فٹنگ',1,'single',1,NULL,NULL,99,144,NULL,NULL,NULL,'inclusive',1,5.0000,'G11.on a glass rack-210','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1205,'2-1/2\" bore 27\" leangth z اڑھائی انچ بور \"27لمبا زیڈ',1,'single',1,NULL,NULL,113,145,NULL,NULL,NULL,'inclusive',1,5.0000,'G2.83-22','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1206,'2-1/2\" bore 3\' leangth   اڑھائی انچ بور تین فٹ لمبی لینتھ',1,'single',1,NULL,NULL,96,144,NULL,NULL,NULL,'inclusive',1,5.0000,'G11.open-27','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1207,'2-1/2\" bore 3\' leangth   اڑھائی انچ بورتین فٹ لمبی',1,'single',1,NULL,NULL,101,138,NULL,NULL,NULL,'inclusive',1,5.0000,'G5.49-21','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1208,'2-1/2\" bore 7\" leangth perken pipe straight piece lower اڑھائی انچ بور7 انچ لمبا پرکن پائپ سیدھا ٹکڑا لوئر',1,'single',1,NULL,NULL,121,138,NULL,NULL,NULL,'inclusive',1,5.0000,'G5.38-22','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1209,'2-1/2\" bore bend اڑھائی انچ بور گوڈا',1,'single',1,NULL,NULL,95,144,NULL,NULL,NULL,'inclusive',1,5.0000,'G11.on glass rack-15','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1210,'2-1/2\" bore complete leangth    اڑھائی انچ دو بور مکمل لینتھ 35فٹ پرلینتھ',1,'single',18,NULL,NULL,96,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.open-319','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1211,'2-1/2\" bore L (10x6)      اڑھائی بور ایل6*10',1,'single',1,NULL,NULL,168,145,NULL,NULL,NULL,'inclusive',1,5.0000,'G2.66-23','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1212,'2-1/2\" bore L (16x16)      اڑھائی بور ایل16*16',1,'single',1,NULL,NULL,169,145,NULL,NULL,NULL,'inclusive',1,5.0000,'G2.79-24','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1213,'2-1/2\" bore leangth piece      اڑھائی انچ بورلمبائی ٹکڑا',1,'single',18,NULL,NULL,80,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.21/25/29/33-29','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1214,'2-1/2\" bore leangth piece    اڑھائی انچ بورلمبائی ٹکڑا',1,'single',18,NULL,NULL,80,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.21/25/29/33-677','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1215,'2-1/2\" bore leangth piece    اڑھائی انچ بورلمبائی ٹکڑا',1,'single',18,NULL,NULL,80,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.21/25/29/33-678','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1216,'2-1/2\" bore piper same as swaliya اڑھائی  انچ بور سوالیہ  کی طرح',1,'single',1,NULL,NULL,170,145,NULL,NULL,NULL,'inclusive',1,5.0000,'G2.159-25','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1217,'2-1/2\" bore same as moon type اڑھائی انچ بور چن ٹائپ',1,'single',1,NULL,NULL,171,145,NULL,NULL,NULL,'inclusive',1,5.0000,'G2.124-26','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1218,'2-1/2\" bore12\" leangth 10 cylinder straight piece lower اڑھائی انچ بور12 انچ لمبا  10سلنڈر سیدھا ٹکڑا لوئر',1,'single',1,NULL,NULL,172,138,NULL,NULL,NULL,'inclusive',1,5.0000,'G5.37-23','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1219,'2-1/2\" bore6\" leangth black       اڑھائی بور  چھ انچ لمبا کالا',1,'single',1,NULL,NULL,173,138,NULL,NULL,NULL,'inclusive',1,5.0000,'G5.15-24','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1220,'2-1/2x2-1/4\" bore4\" leangth      اڑھائی+سوا دوبور  چار انچ لمبا',1,'single',1,NULL,NULL,109,138,NULL,NULL,NULL,'inclusive',1,5.0000,'G5.5-25','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1221,'2-1/2x3\"  bore 6\" leangth         تین +اڑھائی بورچھ انچ لمبا',1,'single',1,NULL,NULL,109,138,NULL,NULL,NULL,'inclusive',1,5.0000,'G5.5-26','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1222,'2-1/2x3\" bore 4\" leangth          اڑھائی+تین بور چار انچ لمبا',1,'single',1,NULL,NULL,109,138,NULL,NULL,NULL,'inclusive',1,5.0000,'G5.5-27','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1223,'2-1/4 bore swaliya سوا دو بور سوالیہ',1,'single',1,NULL,NULL,174,145,NULL,NULL,NULL,'inclusive',1,5.0000,'G2.62-27','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1224,'2-1/4\" big bend  سوا دو بڑا بینڈ',1,'single',1,NULL,NULL,72,138,NULL,NULL,NULL,'inclusive',1,5.0000,'G5.3-28','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1225,'2-1/4\" bore 16\'\' leangth  سوا دو بورسولہ انچ لمبی لینتھ',1,'single',1,NULL,NULL,82,137,NULL,NULL,NULL,'inclusive',1,5.0000,'G4.51-25','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1226,'2-1/4\" bore 2\' leangth   سوا دو انچ بوردو فٹ لمبی',1,'single',1,NULL,NULL,101,138,NULL,NULL,NULL,'inclusive',1,5.0000,'G5.49-29','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1227,'2-1/4\" bore 22\'\' leangth  سوا دو بوربائیس انچ لمبی لینتھ',1,'single',1,NULL,NULL,82,137,NULL,NULL,NULL,'inclusive',1,5.0000,'G4.51-26','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1228,'2-1/4\" bore 29\'\' leangth  سوا دو بورانتیس انچ لمبی لینتھ',1,'single',1,NULL,NULL,82,137,NULL,NULL,NULL,'inclusive',1,5.0000,'G4.51-27','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1229,'2-1/4\" bore 3\'  leangth   سوا دو انچ بور تین فٹ لمبی لینتھ',1,'single',1,NULL,NULL,96,146,NULL,NULL,NULL,'inclusive',1,5.0000,'G12.open-5','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1230,'2-1/4\" bore 3\' leangth     سوا دو بورتین فٹ لمبی لینتھ',1,'single',1,NULL,NULL,82,137,NULL,NULL,NULL,'inclusive',1,5.0000,'G4.51-28','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1231,'2-1/4\" bore 3\' leangth   سوا دو انچ بور تین فٹ لمبی لینتھ',1,'single',1,NULL,NULL,96,144,NULL,NULL,NULL,'inclusive',1,5.0000,'G11.open-28','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1232,'2-1/4\" bore 3\' leangth  سوا دو انچ بور تین فٹ لمبی',1,'single',1,NULL,NULL,101,138,NULL,NULL,NULL,'inclusive',1,5.0000,'G5.49-30','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1233,'2-1/4\" bore 4\" leangth   سوا دوبور  چار  انچ لمبا',1,'single',1,NULL,NULL,74,138,NULL,NULL,NULL,'inclusive',1,5.0000,'G5.18-31','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1234,'2-1/4\" bore 6x4 L  سوا دو انچ بور 4*6 ایل',1,'single',1,NULL,NULL,102,137,NULL,NULL,NULL,'inclusive',1,5.0000,'G4.25-29','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1235,'2-1/4\" bore 7\" leangth piece        سوا دوبور سات انچ لمبا ٹکڑا',1,'single',1,NULL,NULL,130,138,NULL,NULL,NULL,'inclusive',1,5.0000,'G5.11-32','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1236,'2-1/4\" bore 7\" leangth piece        سوا دوبور سات انچ لمبا ٹکڑا',1,'single',1,NULL,NULL,95,144,NULL,NULL,NULL,'inclusive',1,5.0000,'G11.on glass rack-19','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1237,'2-1/4\" bore 7\" leangth piece        سوا دوبور سات انچ لمبا ٹکڑا',1,'single',1,NULL,NULL,96,146,NULL,NULL,NULL,'inclusive',1,5.0000,'G12.open-1','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1238,'2-1/4\" bore 9\" leangth swan ac pipe   سوا دو بور نو انچ لمبا سوان ائر کلینڈر پائپ',1,'single',1,NULL,NULL,99,144,NULL,NULL,NULL,'inclusive',1,5.0000,'G11.on a glass rack-167','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1239,'2-1/4\" bore bend                        سوا دو  بور بینڈ',1,'single',1,NULL,NULL,109,138,NULL,NULL,NULL,'inclusive',1,5.0000,'G5.5-33','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1240,'2-1/4\" bore bend                        سوا دو  بور بینڈ',1,'single',1,NULL,NULL,95,144,NULL,NULL,NULL,'inclusive',1,5.0000,'G11.on glass rack-20','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1241,'2-1/4\" bore bend (6x6) btr  سوادو بور گوڈا6*6',1,'single',1,NULL,NULL,124,145,NULL,NULL,NULL,'inclusive',1,5.0000,'G2.65-28','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1242,'2-1/4\" bore bend (6x6) urc   سوادو بور گوڈا6*6',1,'single',1,NULL,NULL,107,145,NULL,NULL,NULL,'inclusive',1,5.0000,'G2.64-29','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1243,'2-1/4\" bore bend (7x7)   سوادو بورگوڈا7*7',1,'single',1,NULL,NULL,124,145,NULL,NULL,NULL,'inclusive',1,5.0000,'G2.65-30','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1244,'2-1/4\" bore iron wire leangth piece    سوا دو انچ بورلمبائی لوہا تار ٹکڑا',1,'single',18,NULL,NULL,80,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.21/25/29/33-30','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1245,'2-1/4\" bore iron wire leangth piece    سوا دو انچ بورلمبائی لوہا تار ٹکڑا',1,'single',18,NULL,NULL,80,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.21/25/29/33-679','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1246,'2-1/4\" bore L  (12x8)     سوادو بور ایل8*12',1,'single',1,NULL,NULL,162,145,NULL,NULL,NULL,'inclusive',1,5.0000,'G2.81-31','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1247,'2-1/4\" bore L  (16x16)     سوادو بور ایل16*16',1,'single',1,NULL,NULL,169,145,NULL,NULL,NULL,'inclusive',1,5.0000,'G2.79-32','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1248,'2-1/4\" bore L (10x6)      سوادو بور ایل6*10',1,'single',1,NULL,NULL,124,145,NULL,NULL,NULL,'inclusive',1,5.0000,'G2.65-33','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1249,'2-1/4\" bore L (9x9)        سوادو بور ایل9*9',1,'single',1,NULL,NULL,168,145,NULL,NULL,NULL,'inclusive',1,5.0000,'G2.66-34','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1250,'2-1/4\" bore leangth piece    سوا دو انچ بورلمبائی ٹکڑا',1,'single',18,NULL,NULL,80,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.21/25/29/33-31','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1251,'2-1/4\" bore leangth piece    سوا دو انچ بورلمبائی ٹکڑا',1,'single',18,NULL,NULL,80,136,NULL,NULL,NULL,'inclusive',1,5.0000,'G7.21/25/29/33-680','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1252,'2-1/4\" bore S pipe 13\" leangth سوا دو بور13 انچ لمبا ایس  پائپ',1,'single',1,NULL,NULL,77,138,NULL,NULL,NULL,'inclusive',1,5.0000,'G5.40-34','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1253,'2-1/4\" leangth 1-1/4 bore piece سوا دو+ سواانچ  بور ٹکڑا',1,'single',1,NULL,NULL,114,145,NULL,NULL,NULL,'inclusive',1,5.0000,'G2.24-35','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1254,'2-1/4\" leangth 1-1/4 bore piece سوا دو+ سواانچ  بور ٹکڑا',1,'single',1,NULL,NULL,95,144,NULL,NULL,NULL,'inclusive',1,5.0000,'G11.on glass rack-8','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1255,'2-1/4\" leangth 2-1/2 bore piece btr  2-1/4لمبائی 2-1/2  بور ٹکڑا\"',1,'single',1,NULL,NULL,114,145,NULL,NULL,NULL,'inclusive',1,5.0000,'G2.24-36','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1256,'2-1/4\" leangth 2-1/2 bore piece urc  2-1/4لمبا 2/14  بور ٹکڑا\"',1,'single',1,NULL,NULL,114,145,NULL,NULL,NULL,'inclusive',1,5.0000,'G2.24-37','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1257,'2-1/4\" small bend   سوا دو چھوٹا بینڈ',1,'single',1,NULL,NULL,72,138,NULL,NULL,NULL,'inclusive',1,5.0000,'G5.3-35','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1258,'2-1/4\"bore  4\" leangth piece سوا دو بور انچ لمبا ٹکڑا',1,'single',1,NULL,NULL,96,146,NULL,NULL,NULL,'inclusive',1,5.0000,'G12.open-3','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1259,'2-1/4x1-1/2\" bore   6\'\' leangth    ڈیڈھ+سوا دو  بور چھ انچ لمبا',1,'single',1,NULL,NULL,109,138,NULL,NULL,NULL,'inclusive',1,5.0000,'G5.5-36','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1260,'2-1/4x1-3/4\" bore   4\'\' leangth  پونے تین+سوا دو بور چار انچ لمبا',1,'single',1,NULL,NULL,109,138,NULL,NULL,NULL,'inclusive',1,5.0000,'G5.5-37','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:38','2024-12-04 16:35:38'),(1261,'2-1/4x1-3/4\" bore   6\'\' leangth     سوا دو+پونے دو بور  چھ انچ لمبا',1,'single',1,NULL,NULL,109,138,NULL,NULL,NULL,'inclusive',1,5.0000,'G5.5-38','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1262,'2-1/4x2-1/2 L 12+12\" leangth   سوادو*اڑھائی ایل لمبا ئی \"12+12',1,'single',1,NULL,NULL,175,145,NULL,NULL,NULL,'inclusive',1,5.0000,'G2.130-38','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1263,'2-1/4x2-3/4\"  bore 4\" leangth          سوادو+پونےتین بور  چار انچ لمبا',1,'single',1,NULL,NULL,165,138,NULL,NULL,NULL,'inclusive',1,5.0000,'G5.20-40','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1264,'2-1/4x2-3/4\"  bore 6\" leangth          سوادو+پونےتین بور  چار انچ لمبا',1,'single',1,NULL,NULL,82,138,NULL,NULL,NULL,'inclusive',1,5.0000,'G5.51-41','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1265,'2-1/4x2-3/4\"  bore 6\" leangth          سوادو+پونےتین بور  چار انچ لمبا',1,'single',1,NULL,NULL,95,144,NULL,NULL,NULL,'inclusive',1,5.0000,'G11.on glass rack-23','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1266,'2-1/4x2\" bore4\" leangth            دو+سوا دوبور  چار انچ لمبا',1,'single',1,NULL,NULL,109,138,NULL,NULL,NULL,'inclusive',1,5.0000,'G5.5-39','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1267,'2-3/4 pice  geniun                  پونے دو ٹکڑا ولائتی',1,'single',1,NULL,NULL,107,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.64-8','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1268,'2-3/4 s blue   پونے تین سوتر نیلا  ولائیتی',1,'single',18,NULL,NULL,176,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.89-266','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1269,'2-3/4 s blue   پونے تین سوتر نیلا  ولائیتی',1,'single',18,NULL,NULL,176,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.89-267','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1270,'2-3/4 s blue   پونے تین سوتر نیلا  ولائیتی',1,'single',18,NULL,NULL,176,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.89-268','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1271,'2-3/4 s blue   پونے تین سوتر نیلا  ولائیتی',1,'single',18,NULL,NULL,176,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.89-269','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1272,'2-3/4 s blue   پونے تین سوتر نیلا  ولائیتی',1,'single',18,NULL,NULL,176,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.89-270','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1273,'2-3/4 s blue   پونے تین سوتر نیلا  ولائیتی',1,'single',18,NULL,NULL,176,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.89-271','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1274,'2-3/4 s blue   پونے تین سوتر نیلا  ولائیتی',1,'single',18,NULL,NULL,176,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.89-272','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1275,'2-3/4 s blue   پونے تین سوتر نیلا  ولائیتی',1,'single',18,NULL,NULL,176,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.89-273','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1276,'2-3/4 s blue   پونے تین سوتر نیلا  ولائیتی',1,'single',18,NULL,NULL,176,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.89-274','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1277,'2-3/4 s blue   پونے تین سوتر نیلا  ولائیتی',1,'single',18,NULL,NULL,176,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.89-275','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1278,'2-3/4 s blue   پونے تین سوتر نیلا  ولائیتی',1,'single',18,NULL,NULL,176,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.89-276','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1279,'2-3/4 s blue   پونے تین سوتر نیلا  ولائیتی pcs1',1,'single',18,NULL,NULL,176,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.89-277','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1280,'2-3/4 s blue   پونے تین سوتر نیلا  ولائیتی pcs1',1,'single',18,NULL,NULL,103,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.93-285','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1281,'2-3/4 s blue   پونے تین سوتر نیلا  ولائیتی pcs2',1,'single',18,NULL,NULL,176,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.89-278','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1282,'2-3/4 s blue   پونے تین سوتر نیلا  ولائیتی pcs2',1,'single',18,NULL,NULL,176,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.89-279','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1283,'2-3/4 s blue  پونے تین سوتر نیلا  ولائیتی',1,'single',18,NULL,NULL,176,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.89-280','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1284,'2-3/4 s blue  پونے تین سوتر نیلا  ولائیتی',1,'single',18,NULL,NULL,103,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.93-286','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1285,'2-3/4 s blue  پونے تین سوتر نیلا  ولائیتی',1,'single',18,NULL,NULL,103,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.93-287','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1286,'2-3/4 s blue  پونے تین سوتر نیلا  ولائیتی',1,'single',18,NULL,NULL,103,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.93-288','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1287,'2-3/4 s blue  پونے تین سوتر نیلا  ولائیتی',1,'single',18,NULL,NULL,103,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.93-289','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2024-12-04 16:35:39','2024-12-04 16:35:39'),(1288,'2-3/4 s blue  پونے تین سوتر نیلا  ولائیتی',1,'single',18,NULL,NULL,103,147,NULL,NULL,NULL,'inclusive',1,5.0000,'G6.93-290','C128',NULL,NULL,0,0,'',0,NULL,NULL,NULL,NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,