<?php

namespace Modules\Exchange\Http\Controllers;

use Illuminate\Routing\Controller;
use App\Utils\ModuleUtil;
use Menu;

class DataController extends Controller
{
    /**
     * Defines module as a superadmin package.
     * @return Array
     */
    public function superadmin_package()
    {
        return [
            [
                'name' => 'Exchange',
                'label' => __('Exchange::Exchange.Exchange_module'),
                'default' => false
            ]
        ];
    }

    /**
     * Defines user permissions for the module.
     * @return array
     */
    public function user_permissions()
    {
        return [
            [
                'value' => 'Exchange.view',
                'label' => __('Exchange::app.view'),
                'default' => false
            ],
        ];
    }



    public function modifyAdminMenu()
    {
        $business_id = session()->get('user.business_id');
        $module_util = new ModuleUtil();
        $is_Clients_enabled = (bool)$module_util->hasThePermissionInSubscription($business_id, 'Clients_module', 'superadmin_package');

        if ($is_Clients_enabled && (auth()->user()->can('superadmin') || auth()->user()->can('sell.view'))) {
            $menuparent = Menu::instance('admin-sidebar-menu');

            $menuparent->url(
                action([\Modules\Exchange\Http\Controllers\ExchangeController::class, 'index']),
                __('exchange::lang.exchange'),
                [
                    'icon' => 'fa fas fa-exchange-alt',
                    'active' => request()->segment(1) == 'exchange',
                    // 'style' => 'background-color:rgb(255, 117, 200) !important;'
                ]
            )->order(31);
        }
    }
}
