<style>
	.text-limit {
		display: -webkit-box;
		/* Enables the flex container for multiline ellipsis */
		-webkit-line-clamp: 2;
		/* Limits the text to 2 lines */
		-webkit-box-orient: vertical;
		/* Specifies the box orientation */
		overflow: hidden;
		/* Hides overflowing content */
		text-overflow: ellipsis;
		/* Adds ellipsis at the end of truncated text */
		word-wrap: break-word;
		/* Prevents text from overflowing */
	}
</style>
<div id="cardView" class="product-view" style="display: block">
	@forelse($products as $product)
	<div class="col-md-4 col-xs-4 product_list no-print card">
		<div class="product_box hover:tw-shadow-lg hover:tw-animate-pulse" data-variation_id="{{$product->id}}"
			title="{{$product->name}} @if($product->type == 'variable')- {{$product->variation}} @endif {{ '(' . $product->sub_sku . ')'}} @if(!empty($show_prices)) @lang('lang_v1.default') - @format_currency($product->selling_price) @foreach($product->group_prices as $group_price) @if(array_key_exists($group_price->price_group_id, $allowed_group_prices)) {{$allowed_group_prices[$group_price->price_group_id]}} - @format_currency($group_price->price_inc_tax) @endif @endforeach @endif">

			<div class="image-container" style="background-image: url(
							@if(count($product->media) > 0)
								{{$product->media->first()->display_url}}
							@elseif(!empty($product->product_image))
								{{asset('/uploads/img/' . rawurlencode($product->product_image))}}
							@else
								{{asset('/img/default.png')}}
							@endif
						);
					background-repeat: no-repeat; background-position: center;
					background-size: contain;">

			</div>

			<div class="text_div" style="line-height: 1; margin: 0; padding: 0;">
				<small class="nameref text-limit" style="margin: 0; padding: 0;">
					{{$product->name}}
					@if($product->type == 'variable')
					- {{$product->variation}}
					@endif
				</small>
				<small class="text-muted" style="margin: 0; padding: 0;">
					({{$product->sub_sku}})
				</small><br>
				<small class="text-muted">
					@if($product->enable_stock)
					@php
					$qty_alert = $product->alert_quantity ?? 0;
					@endphp
					<!-- {{ @num_format($product->qty_available) }} {{$product->unit}} @lang('lang_v1.in_stock') -->
					@if ($product->qty_available > $qty_alert ) {{-- there is available stock greeen --}}
					<small class="product-label text-muted" style="background: green;color:#fff; font-size=:10px">
						@if ($product->type == "single")
						{{-- {{$product->sub_sku}}: --}}
						{{-- @lang('lang_v1.stock_pos'): --}}
						@else
						{{$product->variation}}: {{--Variable--}}
						@endif
						{{number_format($product->qty_available)}} {{$product->unit}}
					</small>
					@elseif ($product->qty_available == $qty_alert ) {{-- there is available stock low orange --}}
					<small class="product-label text-muted" style="background: orange;color:#fff; font-size=:10px">

						@if ($product->type == "single")
						{{-- {{$product->sub_sku}}: --}}
						{{-- @lang('lang_v1.stock_pos'): --}}
						@else
						{{$product->variation}}: {{--Variable--}}
						@endif
						{{number_format($product->qty_available)}} {{$product->unit}}
					</small>
					@else
					<small class="product-label text-muted" style="background: red;color:#fff; font-size=:10px">

						@if ($product->type == "single")
						{{-- {{$product->sub_sku}}: --}}
						{{-- @lang('lang_v1.stock_pos'): --}}
						@else
						{{$product->variation}}: {{--Variable--}}
						@endif
						{{number_format($product->qty_available)}} {{$product->unit}}
					</small>

					@endif



					@else
					--
					@endif
				</small>
				<span class="text-muted price">
					@format_currency($product->selling_price)
				</span>
				<span class="sku hidden">{{$product->sub_sku}}
				</span>
			</div>

		</div>
	</div>
	@empty
	<input type="hidden" id="no_products_found">
	<div class="col-md-12">
		<h4 class="text-center">
			@lang('lang_v1.no_products_to_display')
		</h4>
	</div>
	@endforelse
</div>

<!-- Table View -->
<div id="tableView" class="product-view" style="display: none">
    <div class="table-container" style="max-height: 500px; overflow-y: none;">
        <table class="table table-bordered table-striped" id="product_search_result_table" style="width: 100%; background-color: #fff;">
            <thead class="text-uppercase no-print text-white p-4" style="background-color: #0376A8; position: sticky; top: 0; z-index: 2;">
                <tr>
                    <th style="width: 10%;">@lang('lang_v1.image')</th>
                    <th style="width: 40%;">@lang('sale.product')</th>
                    <th style="width: 20%;">@lang('sale.unit_price')</th>
                    <th style="width: 10%;">@lang('sale.qty')</th>
                    <th style="width: 12%;">@lang('messages.action')</th>
                </tr>
            </thead>
            <tbody>
                @foreach($products as $product)
                @php
                $qty_alert = $product->alert_quantity ?? 0;
                $bg_qty_alert = $product->qty_available > $qty_alert ? '#D2EAE3' : ($product->qty_available == $qty_alert ? '#f4ead5' : '#fae1e3');
                $color_qty_alert = $product->qty_available > $qty_alert ? '#4ec8a4' : ($product->qty_available == $qty_alert ? '#FFA500' : '#dd3848');
                @endphp
                <tr>
                    <td style="display: flex; justify-content: center; align-items: center;">
                        <img src="{{ count($product->media) > 0 ? $product->media->first()->display_url : (!empty($product->product_image) ? asset('/uploads/img/' . rawurlencode($product->product_image)) : asset('/img/default.png')) }}" alt="Product image" style="max-width: 40px; max-height: 40px;">
                    </td>
                    <td class="nameref">{{$product->name}} {{ $product->type == 'variable' ? '- '.$product->variation : '' }} {{$product->sub_sku ? '('.$product->sub_sku.')' : ''}}<br>
						<small class="text-muted p-1">
							@if($product->enable_stock)
							{{ @num_format($product->qty_available) }} {{$product->unit}} @lang('lang_v1.in_stock')
				
							@endif
						</small>
					</td>
					</td>
                    <td style="text-align: right;">@format_currency($product->selling_price)</td>
                    <td>
                        <input style="text-align: center" type="number" min="1" class="form-control input-sm input_number quantity_input" value="1">
                    </td>
                    <td>
                        <button type="button" class="btn btn-primary btn-sm add-to-cart" style="background-color: {{ $bg_qty_alert }}; color: {{ $color_qty_alert }}; border: 1px solid {{ $color_qty_alert }};" data-variation-id="{{ $product->id }}">
                            @lang('messages.add')
                        </button>
                    </td>
                    <td class="sku hidden" style="display: none;">{{ $product->sub_sku }}</td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>


<style>
.product-view {
    display: none; /* Default state is hidden */
}

#cardView {
    display: block; /* Card view is visible by default */
}

.table-container {
    max-height: 500px;
    overflow-y: auto;
}

.table-container::-webkit-scrollbar {
    display: none; /* Hide scrollbars in table view */
}

.table-container {
    scrollbar-width: none; /* Firefox-specific scrollbar hiding */
}


</style>

<style>


	.product-label {
		margin-bottom: 0px;
		display: inline-block;
		padding: 4px 3px;
		border-radius: 9px 0 11px 0;
		/* font-weight: var(--text-font-bolder-weight); */
		/* font-size: calc(var(--base-text-font-size) -(var(--default-text-font-size) - 13px)); */
		line-height: 1;
		vertical-align: top;
		width: -webkit-fill-available;
		height: 20px;
		position: absolute;
		max-width: 90%;
		top: 0px;
		left: 3px;
		z-index: 2;
		box-shadow: 0px 1px 2px #333;
		font-family: sans-serif;
		font-weight: 700;
		font-size: 12px;
		color: #ffffff !important;
	}

	span.nameref.text.text-muted {
		display: inline-block;
		position: absolute;
		/* bottom: -18px; */
		font-size: 12px;
		/* font-weight: 700 !important; */
		font-family: sans-serif;
		color: #016a6a !important;
		right: 0px;
		background: #ffffff;
		z-index: 0;
		text-align: center;
		padding-block: 0px !important;
		float: left;
		vertical-align: middle !important;
		min-height: 35px !important;
		margin-right: 12px;
		margin-top: 0px;
		width: -webkit-fill-available;
		border-radius: 0 0 10px 12px;
		margin-bottom: 6px;
	}

	.eq-height-col {
		display: flex;
	}

	.product_box .text {
		width: 100%;
		overflow: hidden;
		text-overflow: ellipsis;
		display: -webkit-box;
		-webkit-box-orient: vertical;
		-webkit-line-clamp: 1;
		/* number of lines to show */
		line-height: 14px;
		/* fallback */
		max-height: 14px;
		/* fallback */
	}

	.product_box {
		width: 100%;
		margin-bottom: 2px;
		box-shadow: 1px 2px 2px #919191;

		text-align: center;
		cursor: pointer;
		border: 1px solid white;
		font-weight: 600;
		background-color: #fff;
		border-radius: 10px;
		padding-top: 10px;
		height: 170px;
	}

	.product_box .image-container {
		width: 99%;
		height: 85px;
		object-fit: cover;
		display: block;
		margin-top: -2px;
		padding: 0 !important;
		box-shadow: inset 0px 0 8px 3px #fffbfb;
		border-radius: 5px !important;
	}

	.product_box .image-container img {
		height: 45px;
		/*width: 45px*/
	}

	.product_box:hover {
		/* transform: scale(1.01); */
		box-shadow: 0 0 5px 0 #3c73fede;

		/* box-shadow: -4px -2px 5px 1px rgb(16 255 178 / 44%), 5px 5px 8px 0px rgb(184 255 221 / 86%), 0px 2px 9px 0px rgb(141 215 217 / 41%), 0px 7px 17px #5eeb2fde, -1px 8px 13px 2px #00ffa0, 0px 9px 10px 1px #83f3b7e0 !important; */
	}

	.product_box:active {
		transform: scale(0.94);
		/* Slightly reduces the size when clicked */
	}

	.small-box.bg-gray:hover {
		color: #000;
		text-decoration: none;
	}

	span.text-muted.price {
		background: #e8ff72;
		/* Soft green background for a box-like appearance */
		color: red !important;
		/* Ensure the text color is red */
		text-shadow: 0 0 3px white;
		/* Slight glow effect */
		font-family: 'Lato', sans-serif;
		font-weight: 700;
		border: 2px solid #ffffff;
		/* White border for contrast */
		box-shadow: 0px 2px 6px rgba(0, 0, 0, 0.3);
		/* Subtle shadow for depth */
		font-size: 13px !important;
		/* Fixed font size */
		border-radius: 10px;
		/* Rounded corners */
		position: absolute;
		/* Positioning within a container */
		width: 80%;
		/* Width set to occupy 80% of its container */
		padding: 5px;
		/* Added padding for spacing inside the box */
		bottom: 5px;
		/* Positioned slightly above the container bottom */
		left: 50%;
		/* Center horizontally */
		transform: translateX(-50%);
		/* Align precisely in the center */
		display: flex;
		/* Flexbox for centering content */
		align-items: center;
		/* Center items vertically */
		justify-content: center;
		/* Center items horizontally */
		z-index: 10;
		/* Ensure it appears above other elements */
	}

	.card {
		/* width: 100px; */
		/* Set a fixed width for the cards */
		margin-bottom: 10px;
		/* Adjust this value to set the desired space between cards */

		/* Add other styles as needed */
		transition: width 0.3s ease;
		/* Optional: smooth transition */
	}

	/* 
		.product_box .image-container img{
			height: 75px;
			width: 60px
		} */
</style>



<script type="text/javascript">
    $(document).off('click', '#toggleView').on('click', '#toggleView', function () {
    var cardView = $('#cardView');
    var tableView = $('#tableView');
    var viewIcon = $('#viewIcon');

    // console.log("Toggle button clicked");
    // console.log("Card View Visible:", cardView.is(':visible'));
    // console.log("Table View Visible:", tableView.is(':visible'));

    if (cardView.is(':visible')) {
        // console.log("Switching to Table View");
        cardView.css({ display: 'none', opacity: '0' });
        tableView.css({ display: 'block', opacity: '1' });
        viewIcon.attr('class', 'fa fa-table');
    } else {
        // console.log("Switching to Card View");
        cardView.css({ display: 'block', opacity: '1' });
        tableView.css({ display: 'none', opacity: '0' });
        viewIcon.attr('class', 'fa fa-th');
    }
});
function showView(view) {
    const cardView = document.getElementById("cardView");
    const tableView = document.getElementById("tableView");

    if (view === "card") {
        cardView.style.display = "block";
        tableView.style.display = "none";
        document.body.style.overflow = ""; // Allow body scrollbars
    } else if (view === "table") {
        cardView.style.display = "none";
        tableView.style.display = "block";
        document.body.style.overflow = "hidden"; // Hide body scrollbars
    }
}

</script>



<script type="text/javascript">
	$(document).ready(function() {
				// Event listener for the search input
				$('#product_search').on('input', function() {
					var searchValue = $(this).val().toLowerCase(); // Get the search value and convert it to lowercase
		
					// Filter for card view
					
					$('.product_list').each(function() {
						var productName = $(this).find('.nameref').text().toLowerCase(); // Get the product name
						var productSku = $(this).find('.sku').text().toLowerCase(); // Get the SKU
		
						// Show/hide product card based on the search value
						if (productName.indexOf(searchValue) !== -1 || productSku.indexOf(searchValue) !== -1) {
							$(this).show(); // Show the product card
						} else {
							$(this).hide(); // Hide the product card
						}
					});
		
					// Filter for table view
					$('#tableView tbody tr').each(function() {
						var productName = $(this).find('.nameref').text().toLowerCase(); // Get the product name
						var productSku = $(this).find('.sku').text().toLowerCase(); // Get the SKU
		
						// Show/hide table row based on the search value
						if (productName.indexOf(searchValue) !== -1 || productSku.indexOf(searchValue) !== -1) {
							$(this).show(); // Show the table row
						} else {
							$(this).hide(); // Hide the table row
						}
					});
				});
			});


			
</script>

