/**
* FIXED: Retrieves details of given register id else currently opened register
* Now properly handles exchange transactions for accurate cash register reporting
*
* @param $register_id default null
* @return object
*/
public function getRegisterDetails($register_id = null)
{
$query = CashRegister::leftjoin(
'cash_register_transactions as ct',
'ct.cash_register_id',
'=',
'cash_registers.id'
)
->join(
'users as u',
'u.id',
'=',
'cash_registers.user_id'
)
->leftJoin(
'business_locations as bl',
'bl.id',
'=',
'cash_registers.location_id'
);
if (empty($register_id)) {
$user_id = auth()->user()->id;
$query->where('user_id', $user_id)
->where('cash_registers.status', 'open');
} else {
$query->where('cash_registers.id', $register_id);
}

$register_details = $query->select(
'cash_registers.created_at as open_time',
'cash_registers.closed_at as closed_at',
'cash_registers.user_id',
'cash_registers.closing_note',
'cash_registers.location_id',
'cash_registers.denominations',

// Initial cash in hand
DB::raw("SUM(IF(ct.transaction_type='initial', ct.amount, 0)) as cash_in_hand"),

// FIXED: Total sales - includes regular sales AND exchange sales
// This will capture both normal sales and exchange sales properly
DB::raw("SUM(IF(ct.type='credit' AND ct.transaction_type='sell', ct.amount, 0)) as total_sale"),

// FIXED: Total expenses
DB::raw("SUM(IF(ct.transaction_type='expense', ct.amount, 0)) as total_expense"),

// FIXED: Cash payments - net amount (credits minus debits)
DB::raw("SUM(IF(ct.pay_method='cash' AND ct.transaction_type='sell', IF(ct.type='credit', ct.amount, 0), 0)) as total_cash"),
DB::raw("SUM(IF(ct.pay_method='cash' AND ct.transaction_type='expense', ct.amount, 0)) as total_cash_expense"),

// FIXED: Cheque payments
DB::raw("SUM(IF(ct.pay_method='cheque' AND ct.transaction_type='sell', IF(ct.type='credit', ct.amount, 0), 0)) as total_cheque"),
DB::raw("SUM(IF(ct.pay_method='cheque' AND ct.transaction_type='expense', ct.amount, 0)) as total_cheque_expense"),

// FIXED: Card payments
DB::raw("SUM(IF(ct.pay_method='card' AND ct.transaction_type='sell', IF(ct.type='credit', ct.amount, 0), 0)) as total_card"),
DB::raw("SUM(IF(ct.pay_method='card' AND ct.transaction_type='expense', ct.amount, 0)) as total_card_expense"),

// FIXED: Bank transfer payments
DB::raw("SUM(IF(ct.pay_method='bank_transfer' AND ct.transaction_type='sell', IF(ct.type='credit', ct.amount, 0), 0)) as total_bank_transfer"),
DB::raw("SUM(IF(ct.pay_method='bank_transfer' AND ct.transaction_type='expense', ct.amount, 0)) as total_bank_transfer_expense"),

// FIXED: Other payment methods
DB::raw("SUM(IF(ct.pay_method='other' AND ct.transaction_type='sell', IF(ct.type='credit', ct.amount, 0), 0)) as total_other"),
DB::raw("SUM(IF(ct.pay_method='other' AND ct.transaction_type='expense', ct.amount, 0)) as total_other_expense"),

// Advance payments
DB::raw("SUM(IF(ct.pay_method='advance' AND ct.transaction_type='sell', IF(ct.type='credit', ct.amount, 0), 0)) as total_advance"),
DB::raw("SUM(IF(ct.pay_method='advance' AND ct.transaction_type='expense', ct.amount, 0)) as total_advance_expense"),

// Custom payment methods
DB::raw("SUM(IF(ct.pay_method='custom_pay_1' AND ct.transaction_type='sell', IF(ct.type='credit', ct.amount, 0), 0)) as total_custom_pay_1"),
DB::raw("SUM(IF(ct.pay_method='custom_pay_2' AND ct.transaction_type='sell', IF(ct.type='credit', ct.amount, 0), 0)) as total_custom_pay_2"),
DB::raw("SUM(IF(ct.pay_method='custom_pay_3' AND ct.transaction_type='sell', IF(ct.type='credit', ct.amount, 0), 0)) as total_custom_pay_3"),
DB::raw("SUM(IF(ct.pay_method='custom_pay_4' AND ct.transaction_type='sell', IF(ct.type='credit', ct.amount, 0), 0)) as total_custom_pay_4"),
DB::raw("SUM(IF(ct.pay_method='custom_pay_5' AND ct.transaction_type='sell', IF(ct.type='credit', ct.amount, 0), 0)) as total_custom_pay_5"),
DB::raw("SUM(IF(ct.pay_method='custom_pay_6' AND ct.transaction_type='sell', IF(ct.type='credit', ct.amount, 0), 0)) as total_custom_pay_6"),
DB::raw("SUM(IF(ct.pay_method='custom_pay_7' AND ct.transaction_type='sell', IF(ct.type='credit', ct.amount, 0), 0)) as total_custom_pay_7"),

// Custom payment method expenses
DB::raw("SUM(IF(ct.pay_method='custom_pay_1' AND ct.transaction_type='expense', ct.amount, 0)) as total_custom_pay_1_expense"),
DB::raw("SUM(IF(ct.pay_method='custom_pay_2' AND ct.transaction_type='expense', ct.amount, 0)) as total_custom_pay_2_expense"),
DB::raw("SUM(IF(ct.pay_method='custom_pay_3' AND ct.transaction_type='expense', ct.amount, 0)) as total_custom_pay_3_expense"),
DB::raw("SUM(IF(ct.pay_method='custom_pay_4' AND ct.transaction_type='expense', ct.amount, 0)) as total_custom_pay_4_expense"),
DB::raw("SUM(IF(ct.pay_method='custom_pay_5' AND ct.transaction_type='expense', ct.amount, 0)) as total_custom_pay_5_expense"),
DB::raw("SUM(IF(ct.pay_method='custom_pay_6' AND ct.transaction_type='expense', ct.amount, 0)) as total_custom_pay_6_expense"),
DB::raw("SUM(IF(ct.pay_method='custom_pay_7' AND ct.transaction_type='expense', ct.amount, 0)) as total_custom_pay_7_expense"),

// FIXED: Total refunds - includes both regular refunds AND exchange refunds
DB::raw("SUM(IF(ct.type='debit' AND ct.transaction_type='refund', ct.amount, 0)) as total_refund"),

// FIXED: Refund totals by payment method
DB::raw("SUM(IF(ct.type='debit' AND ct.transaction_type='refund' AND ct.pay_method='cash', ct.amount, 0)) as total_cash_refund"),
DB::raw("SUM(IF(ct.type='debit' AND ct.transaction_type='refund' AND ct.pay_method='cheque', ct.amount, 0)) as total_cheque_refund"),
DB::raw("SUM(IF(ct.type='debit' AND ct.transaction_type='refund' AND ct.pay_method='card', ct.amount, 0)) as total_card_refund"),
DB::raw("SUM(IF(ct.type='debit' AND ct.transaction_type='refund' AND ct.pay_method='bank_transfer', ct.amount, 0)) as total_bank_transfer_refund"),
DB::raw("SUM(IF(ct.type='debit' AND ct.transaction_type='refund' AND ct.pay_method='other', ct.amount, 0)) as total_other_refund"),
DB::raw("SUM(IF(ct.type='debit' AND ct.transaction_type='refund' AND ct.pay_method='advance', ct.amount, 0)) as total_advance_refund"),
DB::raw("SUM(IF(ct.type='debit' AND ct.transaction_type='refund' AND ct.pay_method='custom_pay_1', ct.amount, 0)) as total_custom_pay_1_refund"),
DB::raw("SUM(IF(ct.type='debit' AND ct.transaction_type='refund' AND ct.pay_method='custom_pay_2', ct.amount, 0)) as total_custom_pay_2_refund"),
DB::raw("SUM(IF(ct.type='debit' AND ct.transaction_type='refund' AND ct.pay_method='custom_pay_3', ct.amount, 0)) as total_custom_pay_3_refund"),
DB::raw("SUM(IF(ct.type='debit' AND ct.transaction_type='refund' AND ct.pay_method='custom_pay_4', ct.amount, 0)) as total_custom_pay_4_refund"),
DB::raw("SUM(IF(ct.type='debit' AND ct.transaction_type='refund' AND ct.pay_method='custom_pay_5', ct.amount, 0)) as total_custom_pay_5_refund"),
DB::raw("SUM(IF(ct.type='debit' AND ct.transaction_type='refund' AND ct.pay_method='custom_pay_6', ct.amount, 0)) as total_custom_pay_6_refund"),
DB::raw("SUM(IF(ct.type='debit' AND ct.transaction_type='refund' AND ct.pay_method='custom_pay_7', ct.amount, 0)) as total_custom_pay_7_refund"),

// Count totals
DB::raw("SUM(IF(ct.pay_method='cheque', 1, 0)) as total_cheques"),
DB::raw("SUM(IF(ct.pay_method='card', 1, 0)) as total_card_slips"),

// User and location info
DB::raw("CONCAT(COALESCE(u.surname, ''), ' ', COALESCE(u.first_name, ''), ' ', COALESCE(u.last_name, '')) as user_name"),
'u.email',
'bl.name as location_name'
)->first();

return $register_details;
}