<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('customer_awards', function (Blueprint $table) {
            // Drop the foreign key constraint
            $table->dropForeign(['catalog_item_id']);
            
            // Keep the column but remove the constraint
            // Now catalog_item_id can store product variation IDs instead of catalog IDs
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('customer_awards', function (Blueprint $table) {
            // Re-add the foreign key constraint (only if award_catalogs table exists)
            if (Schema::hasTable('award_catalogs')) {
                $table->foreign('catalog_item_id')->references('id')->on('award_catalogs')->onDelete('set null');
            }
        });
    }
};
