<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('customer_awards', function (Blueprint $table) {
            $table->integer('award_quantity')->default(1)->after('catalog_item_id')
                  ->comment('Quantity of items awarded (for catalog awards)');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('customer_awards', function (Blueprint $table) {
            $table->dropColumn('award_quantity');
        });
    }
};
