<?php

return [
    // Module
    'advanced_reports_module' => 'وحدة التقارير المتقدمة',
    'advanced_reports' => 'التقارير المتقدمة',
    'manage_advanced_reports' => 'إدارة التقارير المتقدمة',
    'service_staff_not_enabled' => 'وحدة موظفي الخدمة غير مفعلة. يرجى تفعيل وحدة موظفي الخدمة في إعدادات الأعمال لاستخدام تقارير تقدير الموظفين.',

    // Permissions
    'view_reports' => 'عرض التقارير',
    'export_reports' => 'تصدير التقارير',

    // Stock Report
    'stock_report' => 'تقرير المخزون',
    'manage_stock_report' => 'إدارة تقرير المخزون',
    'current_stock' => 'المخزون الحالي',
    'stock_value_purchase' => 'قيمة المخزون (الشراء)',
    'stock_value_sale' => 'قيمة المخزون (البيع)',
    'potential_profit' => 'الربح المحتمل',
    'total_sold' => 'إجمالي المبيع',
    'selling_price' => 'سعر البيع',
    'total_products' => 'إجمالي المنتجات',
    'total_stock_quantity' => 'إجمالي كمية المخزون',
    'show_zero_stock' => 'إظهار المخزون الصفر',
    'out_of_stock' => 'نفد المخزون',
    'low_stock' => 'مخزون منخفض',
    'total_stock_value' => 'إجمالي قيمة المخزون',
    'product_info' => 'معلومات المنتج',
    'active' => 'نشط',
    'inactive' => 'غير نشط',
    'lot_number' => 'رقم اللوت',

    // Sales Report
    'sales_report' => 'تقرير المبيعات',
    'manage_sales_report' => 'إدارة تقرير المبيعات',
    'invoice_no' => 'رقم الفاتورة',
    'transaction_date' => 'تاريخ المعاملة',
    'customer_name' => 'اسم العميل',
    'payment_status' => 'حالة الدفع',
    'total_before_tax' => 'الإجمالي قبل الضريبة',
    'tax_amount' => 'مبلغ الضريبة',
    'final_total' => 'الإجمالي النهائي',
    'total_paid' => 'إجمالي المدفوع',
    'balance_due' => 'الرصيد المستحق',
    'total_sales' => 'إجمالي المبيعات',
    'average_sale' => 'متوسط البيع',
    'total_due' => 'إجمالي المستحق',

    // Product Report
    'product_report' => 'تقرير مبيعات المنتجات',

    // Pricing Optimization
    'pricing_optimization' => 'تحسين التسعير',
    'pricing_analytics_dashboard' => 'لوحة تحليل التسعير',
    'price_elasticity_analysis' => 'تحليل مرونة السعر',
    'competitor_price_analysis' => 'تحليل أسعار المنافسين',
    'discount_impact_analysis' => 'تحليل تأثير الخصم',
    'dynamic_pricing_suggestions' => 'اقتراحات التسعير الديناميكي',
    'revenue_optimization' => 'تحسين الإيرادات',
    'average_margin' => 'متوسط الهامش',
    'average_selling_price' => 'متوسط سعر البيع',
    'current_price' => 'السعر الحالي',
    'cost_price' => 'سعر التكلفة',
    'suggested_price' => 'السعر المقترح',
    'quantity_sold' => 'الكمية المبيعة',
    'velocity' => 'السرعة',
    'elasticity_type' => 'نوع المرونة',
    'recommendation' => 'التوصية',
    'our_price' => 'سعرنا',
    'market_average' => 'متوسط السوق',
    'market_position' => 'موقع السوق',
    'price_difference' => 'فرق السعر',
    'competitiveness' => 'القدرة التنافسية',
    'discount_frequency' => 'تكرار الخصم',
    'avg_discount_percent' => 'متوسط نسبة الخصم%',
    'discounted_sales' => 'المبيعات المخفضة',
    'regular_sales' => 'المبيعات العادية',
    'effectiveness_score' => 'درجة الفعالية',
    'price_change' => 'تغيير السعر',
    'confidence' => 'الثقة',
    'reasoning' => 'التبرير',
    'revenue_impact' => 'تأثير الإيرادات',
    'products' => 'المنتجات',
    'optimization_score' => 'درجة التحسين',

    // ABC Analysis
    'abc_analysis' => 'تحليل ABC',
    'abc_analysis_description' => 'تصنيف المنتجات حسب القيمة وتحسين تخصيص الموارد',
    'abc_analysis_dashboard' => 'لوحة تحليل ABC',
    'analysis_type' => 'نوع التحليل',
    'inventory_value' => 'قيمة المخزون',
    'sales_revenue' => 'إيرادات المبيعات',
    'hybrid_analysis' => 'التحليل المدمج',
    'analyze' => 'تحليل',
    'a_grade_items' => 'عناصر الفئة أ',
    'b_grade_items' => 'عناصر الفئة ب',
    'c_grade_items' => 'عناصر الفئة ج',
    'total_analysis_value' => 'إجمالي قيمة التحليل',
    'abc_distribution_chart' => 'مخطط توزيع ABC',
    'pareto_analysis' => 'تحليل باريتو',
    'revenue_contribution_analysis' => 'تحليل مساهمة الإيرادات',
    'abc_grade' => 'درجة ABC',
    'item_count' => 'عدد العناصر',
    'turnover_ratio' => 'نسبة الدوران',
    'focus_strategy' => 'استراتيجية التركيز',
    'management_approach' => 'نهج الإدارة',
    'resource_allocation_recommendations' => 'توصيات تخصيص الموارد',
    'detailed_product_classification' => 'تصنيف المنتجات المفصل',
    'rank' => 'الترتيب',
    'variant_title' => 'عنوان المتغير',
    'variant_sku' => 'رمز المتغير',
    'ending_quantity' => 'الكمية النهائية',
    'total_cost_value' => 'إجمالي قيمة التكلفة',
    'total_selling_value' => 'إجمالي قيمة البيع',
    'cumulative_percent' => 'النسبة التراكمية%',
    'manage_product_report' => 'إدارة تقرير مبيعات المنتجات',
    'total_quantity_sold' => 'إجمالي الكمية المبيعة',
    'total_amount_sold' => 'إجمالي المبلغ المبيع',
    'profit_margin' => 'هامش الربح',
    'top_selling_products' => 'المنتجات الأكثر مبيعاً',
    'slow_moving_products' => 'المنتجات بطيئة الحركة',

    // Price List
    'price_list' => 'قائمة الأسعار',
    'manage_price_list' => 'إدارة قائمة الأسعار',
    'purchase_price' => 'سعر الشراء',
    'margin_percentage' => 'نسبة الهامش%',
    'update_price' => 'تحديث السعر',
    'bulk_update_prices' => 'تحديث الأسعار المجمع',

    // Common
    'filters' => 'المرشحات',
    'date_range' => 'نطاق التاريخ',
    'location' => 'الموقع',
    'category' => 'الفئة',
    'customer' => 'العميل',
    'from_date' => 'من تاريخ',
    'to_date' => 'إلى تاريخ',
    'apply_filter' => 'تطبيق المرشح',
    'clear_filter' => 'مسح المرشح',
    'export' => 'تصدير',
    'export_to_excel' => 'تصدير إلى Excel',
    'export_to_pdf' => 'تصدير إلى PDF',
    'export_to_csv' => 'تصدير إلى CSV',
    'print' => 'طباعة',
    'refresh' => 'تحديث',
    'search' => 'بحث',
    'no_data_found' => 'لم يتم العثور على بيانات',
    'loading' => 'جارٍ التحميل...',

    // Summary
    'summary' => 'الملخص',
    'grand_total' => 'الإجمالي العام',
    'totals' => 'الإجماليات',
    'count' => 'العدد',

    // Messages
    'report_generated_successfully' => 'تم إنشاء التقرير بنجاح',
    'export_completed_successfully' => 'تم التصدير بنجاح',
    'no_records_found' => 'لم يتم العثور على سجلات للمعايير المحددة',
    'please_select_date_range' => 'يرجى تحديد نطاق تاريخ',
    'invalid_date_range' => 'نطاق تاريخ غير صالح',
    'export_in_progress' => 'التصدير قيد التقدم، يرجى الانتظار...',
    'max_export_limit_exceeded' => 'تم تجاوز الحد الأقصى للتصدير. يرجى تحسين المرشحات.',

    // Errors
    'error_generating_report' => 'خطأ في إنشاء التقرير',
    'error_exporting_data' => 'خطأ في تصدير البيانات',
    'permission_denied' => 'تم رفض الإذن',
    'invalid_request' => 'طلب غير صالح',

    // Installation
    'install_success' => 'تم تثبيت وحدة التقارير المتقدمة بنجاح',
    'update_success' => 'تم تحديث وحدة التقارير المتقدمة بنجاح',
    'uninstall_success' => 'تم إلغاء تثبيت وحدة التقارير المتقدمة بنجاح',

    // Charts
    'sales_trend' => 'اتجاه المبيعات',
    'top_products' => 'أفضل المنتجات',
    'sales_by_location' => 'المبيعات حسب الموقع',
    'sales_by_category' => 'المبيعات حسب الفئة',
    'profit_analysis' => 'تحليل الأرباح',

    // Advanced Features
    'schedule_report' => 'جدولة التقرير',
    'email_report' => 'إرسال التقرير بالبريد الإلكتروني',
    'save_filter' => 'حفظ المرشح',
    'load_saved_filter' => 'تحميل المرشح المحفوظ',
    'custom_columns' => 'أعمدة مخصصة',
    'group_by' => 'تجميع حسب',
    'sort_by' => 'ترتيب حسب',
    'chart_view' => 'عرض الرسم البياني',
    'table_view' => 'عرض الجدول',

    // Time Periods
    'today' => 'اليوم',
    'yesterday' => 'أمس',
    'this_week' => 'هذا الأسبوع',
    'last_week' => 'الأسبوع الماضي',
    'this_month' => 'هذا الشهر',
    'last_month' => 'الشهر الماضي',
    'this_quarter' => 'هذا الربع',
    'last_quarter' => 'الربع الماضي',
    'this_year' => 'هذا العام',
    'last_year' => 'العام الماضي',
    'last_30_days' => 'آخر 30 يوماً',
    'custom_range' => 'نطاق مخصص',

    'applying' => 'تطبيق',
    'apply_filters' => 'تطبيق المرشحات',

    // Dashboard
    'dashboard' => 'لوحة القيادة',
    'key_metrics' => 'المقاييس الرئيسية',
    'recent_reports' => 'التقارير الأخيرة',
    'quick_actions' => 'الإجراءات السريعة',
    'generate_report' => 'إنشاء تقرير',
    'view_all_reports' => 'عرض جميع التقارير',
    'report_center' => 'مركز التقارير',

    'all_categories' => 'جميع الفئات',
    'filter' => 'مرشح',

    // Sales Report entries
    'manage_sales_report' => 'إدارة معاملات المبيعات وتحليل الأداء',
    'sales_details' => 'تفاصيل المبيعات',
    'total_transactions' => 'إجمالي المعاملات',
    'total_customers' => 'إجمالي العملاء',
    'customers' => 'العملاء',
    'product' => 'المنتج',
    'total_customers_count' => 'عدد إجمالي العملاء',
    'total_products_count' => 'عدد إجمالي المنتجات',
    'total_sales_amount' => 'إجمالي مبلغ المبيعات',
    'total_tax_amount' => 'إجمالي مبلغ الضريبة',
    'total_discount' => 'إجمالي الخصم',
    'paid_transactions' => 'المبلغ المدفوع',
    'paid_transactions_count' => 'عدد المعاملات المدفوعة',
    'total_paid_amount' => 'إجمالي المبلغ المدفوع',
    'due_transactions' => 'المبلغ المستحق',
    'due_transactions_count' => 'عدد المعاملات المستحقة',
    'total_due_amount' => 'إجمالي المبلغ المستحق',
    'invoice' => 'الفاتورة',
    'invoices' => 'الفواتير',
    'partial_transactions' => 'المعاملات الجزئية',
    'paid_amount' => 'المبلغ المدفوع',
    'due_amount' => 'المبلغ المستحق',
    'transaction_info' => 'معلومات المعاملة',
    'created_by' => 'تم الإنشاء بواسطة',
    'view_full_invoice' => 'عرض الفاتورة الكاملة',

    // Additional entries
    'sales_summary' => 'ملخص المبيعات',
    'payment_summary' => 'ملخص الدفعات',
    'customer_info' => 'معلومات العميل',
    'sales_performance' => 'أداء المبيعات',
    'daily_sales' => 'المبيعات اليومية',
    'monthly_sales' => 'المبيعات الشهرية',
    'yearly_sales' => 'المبيعات السنوية',
    'top_customers' => 'أفضل العملاء',
    'sales_by_payment_method' => 'المبيعات حسب طريقة الدفع',
    'average_transaction_value' => 'متوسط قيمة المعاملة',
    'total_transactions_today' => 'إجمالي المعاملات اليوم',
    'sales_growth' => 'نمو المبيعات',
    'revenue_analysis' => 'تحليل الإيرادات',

    // Filter related
    'filter_by_date' => 'ترشيح حسب التاريخ',
    'filter_by_customer' => 'ترشيح حسب العميل',
    'filter_by_location' => 'ترشيح حسب الموقع',
    'filter_by_payment_status' => 'ترشيح حسب حالة الدفع',
    'filter_by_payment_method' => 'ترشيح حسب طريقة الدفع',
    'select_date_range' => 'تحديد نطاق التاريخ',
    'all_customers' => 'جميع العملاء',
    'all_locations' => 'جميع المواقع',
    'all_payment_methods' => 'جميع طرق الدفع',
    'all_statuses' => 'جميع الحالات',

    // Export related
    'export_sales_report' => 'تصدير تقرير المبيعات',
    'sales_report_exported' => 'تم تصدير تقرير المبيعات بنجاح',
    'export_failed' => 'فشل التصدير. يرجى المحاولة مرة أخرى.',

    // Status messages
    'no_sales_found' => 'لم يتم العثور على مبيعات للمعايير المحددة',
    'loading_sales_data' => 'جارٍ تحميل بيانات المبيعات...',
    'sales_data_loaded' => 'تم تحميل بيانات المبيعات بنجاح',
    'error_loading_sales' => 'خطأ في تحميل بيانات المبيعات',

    // Validation messages
    'invalid_date_range' => 'يرجى تحديد نطاق تاريخ صالح',
    'date_range_too_large' => 'نطاق التاريخ كبير جداً. يرجى تحديد نطاق أصغر.',
    'no_data_available' => 'لا توجد بيانات متاحة للمرشحات المحددة',

    // Performance metrics
    'growth_rate' => 'معدل النمو',
    'conversion_rate' => 'معدل التحويل',
    'repeat_customers' => 'العملاء المتكررون',
    'new_customers' => 'عملاء جدد',
    'average_order_value' => 'متوسط قيمة الطلب',
    'total_orders' => 'إجمالي الطلبات',
    'orders_per_customer' => 'الطلبات لكل عميل',

    // Additional useful phrases
    'view_details' => 'عرض التفاصيل',
    'hide_details' => 'إخفاء التفاصيل',
    'expand_all' => 'توسيع الكل',
    'collapse_all' => 'طي الكل',
    'refresh_data' => 'تحديث البيانات',
    'last_updated' => 'آخر تحديث',
    'auto_refresh' => 'التحديث التلقائي',
    'manual_refresh' => 'التحديث اليدوي',
    'data_as_of' => 'البيانات اعتباراً من',
    'real_time_data' => 'بيانات في الوقت الفعلي',

    // Chart/Graph related
    'bar_chart' => 'مخطط بياني عمودي',
    'line_chart' => 'مخطط بياني خطي',
    'pie_chart' => 'مخطط بياني دائري',
    'show_chart' => 'إظهار المخطط البياني',
    'hide_chart' => 'إخفاء المخطط البياني',

    // Comparison related
    'compare_periods' => 'مقارنة الفترات',
    'previous_period' => 'الفترة السابقة',
    'same_period_last_year' => 'نفس الفترة العام الماضي',
    'percentage_change' => 'نسبة التغيير',
    'absolute_change' => 'التغيير المطلق',
    'trend_analysis' => 'تحليل الاتجاه',

    // Due Collections Analysis
    'due_collections_analysis' => 'تحليل تحصيل المستحقات',
    'collected_today' => 'تم التحصيل اليوم',
    'pending_due_today' => 'المستحق المعلق اليوم',
    'overdue_amounts' => 'المبالغ المتأخرة',
    'due_payments_received' => 'المدفوعات المستحقة المستلمة اليوم',
    'todays_unpaid_sales' => 'مبيعات اليوم غير المدفوعة',
    'previous_days_unpaid' => 'الأيام السابقة غير المدفوعة',
    'cash_collected_today' => 'النقد المحصل اليوم',
    'due_collection_cash' => 'نقد تحصيل المستحقات',
    'total_due_collected' => 'إجمالي المستحق المحصل',
    'total_pending_due' => 'إجمالي المستحق المعلق',
    'total_overdue' => 'إجمالي المتأخر',
    'due_collection_summary' => 'ملخص تحصيل المستحقات',
    'payment_collection_status' => 'حالة تحصيل المدفوعات',
    'outstanding_receivables' => 'المستحقات المتميزة',
    'receivables_aging' => 'عمر المستحقات',
    'collection_efficiency' => 'كفاءة التحصيل',
    'overdue_analysis' => 'تحليل المتأخرات',
    'aging_report' => 'تقرير العمر',
    'collection_report' => 'تقرير التحصيل',
    'cash_flow_analysis' => 'تحليل التدفق النقدي',
    'payment_trends' => 'اتجاهات الدفع',
    'due_follow_up' => 'متابعة المستحقات',
    'collection_alerts' => 'تنبيهات التحصيل',
    'payment_reminders' => 'تذكيرات الدفع',
    'credit_management' => 'إدارة الائتمان',
    'customer_payment_history' => 'تاريخ دفع العميل',
    'payment_performance' => 'أداء الدفع',

    // sales_detail_report
    'sales_detail_report' => 'تقرير تفاصيل المبيعات',

    'gst_sales_report' => 'تقرير مبيعات ضريبة السلع والخدمات',
    'gst_purchase_report' => 'تقرير مشتريات ضريبة السلع والخدمات',
    'operations_summary_report' => 'تقرير ملخص العمليات',
    'daily_summary_report' => 'تقرير الملخص اليومي',
    'daily_report' => 'التقرير اليومي',
    'manage_gst_sales_report' => 'إدارة تقرير مبيعات ضريبة السلع والخدمات',
    'total_tax' => 'إجمالي الضريبة',
    'taxable_amount' => 'المبلغ الخاضع للضريبة',
    'avg_tax_rate' => 'متوسط معدل الضريبة',
    'taxable_value' => 'القيمة الخاضعة للضريبة',
    'today_sales' => 'مبيعات اليوم',
    'today_purchases' => 'مشتريات اليوم',
    'today_expenses' => 'مصروفات اليوم',
    'net_profit' => 'صافي الربح',
    'cash_in_hand' => 'النقد في اليد',
    'purchase_summary' => 'ملخص المشتريات',
    'expense_summary' => 'ملخص المصروفات',
    'payment_methods_summary' => 'ملخص طرق الدفع',
    'payment_method' => 'طريقة الدفع',
    'transaction_count' => 'عدد المعاملات',
    'total_amount' => 'إجمالي المبلغ',
    'manage_daily_summary' => 'إدارة الملخص اليومي',
    'total_purchases' => 'إجمالي المشتريات',
    'total_expenses' => 'إجمالي المصروفات',
    'avg_daily_sales' => 'متوسط المبيعات اليومية',
    'profitable_days' => 'الأيام المربحة',
    'day' => 'اليوم',
    'sales_count' => 'عدد المبيعات',
    'purchase_count' => 'عدد المشتريات',
    'expense_count' => 'عدد المصروفات',
    'cash_received' => 'النقد المستلم',
    'card_received' => 'البطاقة المستلمة',

    'comprehensive_daily_overview' => 'نظرة عامة يومية شاملة',
    'today_profit' => 'ربح اليوم',
    'bank_balance' => 'رصيد البنك',
    'customer_due' => 'مستحقات العملاء',
    'supplier_due' => 'مستحقات الموردين',
    'today_collections' => 'تحصيلات اليوم',
    'net_worth' => 'صافي القيمة',
    'todays_activity' => 'نشاط اليوم',
    'financial_snapshot' => 'لقطة مالية',
    'avg_transaction_value' => 'متوسط قيمة المعاملة',
    'gross_profit_margin' => 'هامش الربح الإجمالي',
    'opening_balance' => 'الرصيد الافتتاحي',
    'closing_balance' => 'الرصيد الختامي',
    'cash_flow' => 'التدفق النقدي',
    'liquidity_ratio' => 'نسبة السيولة',
    'detailed_breakdown' => 'التفصيل المفصل',
    'loading' => 'جارٍ التحميل',
    'manage_operations_summary' => 'إدارة ملخص العمليات',
    'report_date' => 'تاريخ التقرير',

    'gst_sales_by_products' => 'مبيعات ضريبة السلع والخدمات حسب المنتجات',
    'gst_sales_by_invoice' => 'مبيعات ضريبة السلع والخدمات حسب الفاتورة',

    // Stock report specific translations
    'total_stock_purchase_value' => 'إجمالي قيمة شراء المخزون',
    'total_stock_sales_value' => 'إجمالي قيمة بيع المخزون',

    // General UI translations for Advanced Reports module
    'stock_need_only' => 'حاجة المخزون فقط',
    'stock_need' => 'حاجة المخزون',
    'expected_stock' => 'المخزون المتوقع',
    'expired_stock' => 'المخزون المنتهي الصلاحية',
    'critical_items' => 'العناصر الحرجة',
    'total_current_stock' => 'إجمالي المخزون الحالي',
    'total_stock_needed' => 'إجمالي المخزون المطلوب',
    'coverage_ratio' => 'نسبة التغطية',
    'processing' => 'قيد المعالجة',
    'table_not_found' => 'الجدول غير موجود',
    'no_data_available' => 'لا توجد بيانات متاحة',
    'no_data_available_print' => 'لا توجد بيانات متاحة للطباعة',
    'popup_blocked' => 'تم حظر النافذة المنبثقة بواسطة المتصفح. يرجى السماح بالنوافذ المنبثقة لهذا الموقع.',
    'generated_on' => 'تم الإنشاء في',
    'at' => 'في',
    'printed_on' => 'تمت الطباعة في',
    'generated_by' => 'تم الإنشاء بواسطة',
    'system_generated_report' => 'هذا تقرير تم إنشاؤه بواسطة النظام',
    'select_date' => 'تحديد التاريخ',
    'select_location' => 'تحديد الموقع',

    // Expiry report translations
    'expiry_report' => 'تقرير انتهاء الصلاحية',
    'expiry_filters' => 'مرشحات انتهاء الصلاحية',
    'expiry_status' => 'حالة انتهاء الصلاحية',
    'all' => 'الكل',
    'expired' => 'منتهي الصلاحية',
    'expiring_in_7_days' => 'ينتهي خلال 7 أيام',
    'expiring_in_30_days' => 'ينتهي خلال 30 يوماً',
    'expiring_in_90_days' => 'ينتهي خلال 90 يوماً',
    'expired_products' => 'المنتجات منتهية الصلاحية',
    'total_expiry_value' => 'إجمالي قيمة انتهاء الصلاحية',
    'stock_expiry_report' => 'تقرير انتهاء صلاحية المخزون',
    'days_to_expire' => 'أيام حتى انتهاء الصلاحية',
    'stock_value' => 'قيمة المخزون',
    'days_expired' => 'يوماً منتهي الصلاحية',
    'days_left' => 'يوماً متبقياً',
    'critical' => 'حرج',
    'warning' => 'تحذير',
    'good' => 'جيد',
    'remove_from_stock' => 'إزالة من المخزون',

    // Enhanced expiry alert translations
    'expiring_soon' => 'ينتهي قريباً',
    'total_items' => 'إجمالي العناصر',
    'alert_value' => 'قيمة التنبيه',
    'days_ahead' => 'أيام مسبقاً',
    'next_7_days' => 'الأيام السبعة القادمة',
    'next_15_days' => 'الأيام الخمسة عشر القادمة',
    'next_30_days' => 'الأيام الثلاثين القادمة',
    'next_60_days' => 'الأيام الستين القادمة',
    'next_90_days' => 'الأيام التسعين القادمة',
    'days_overdue' => 'يوماً متأخراً',
    'expires_today' => 'ينتهي اليوم',
    'status' => 'الحالة',
    'expiry_date' => 'تاريخ انتهاء الصلاحية',

    'invoice_subtotal' => 'المجموع الفرعي للفاتورة',
    'line_discount' => 'خصم الخط',
    'invoice_discount' => 'خصم الفاتورة',

    // Customer Monthly Sales Report
    'customer_monthly_sales_report' => 'تقرير مبيعات العملاء الشهرية',
    'manage_customer_monthly_sales' => 'إدارة مبيعات العملاء الشهرية',
    'customer_monthly_analysis' => 'تحليل العملاء الشهري',
    'monthly_breakdown' => 'التفصيل الشهري',
    'gross_profit_amount' => 'مبلغ الربح الإجمالي ($)',
    'gross_profit_percentage' => 'نسبة الربح الإجمالي (%)',
    'avg_per_customer' => 'متوسط لكل عميل',
    'customer_details' => 'تفاصيل العميل',
    'customer_information' => 'معلومات العميل',
    'recent_transactions' => 'المعاملات الأخيرة',
    'monthly_sales_analysis' => 'تحليل المبيعات الشهرية',
    'year_summary' => 'ملخص العام',
    'search_by_name' => 'البحث بالاسم...',
    'staff' => 'الموظفين',

    'gross_profit' => 'الربح الإجمالي',

    // Months (if not already present)
    'january' => 'يناير',
    'february' => 'فبراير',
    'march' => 'مارس',
    'april' => 'أبريل',
    'may' => 'مايو',
    'june' => 'يونيو',
    'july' => 'يوليو',
    'august' => 'أغسطس',
    'september' => 'سبتمبر',
    'october' => 'أكتوبر',
    'november' => 'نوفمبر',
    'december' => 'ديسمبر',

    // Short months
    'jan' => 'يناير',
    'feb' => 'فبراير',
    'mar' => 'مارس',
    'apr' => 'أبريل',
    'jun' => 'يونيو',
    'jul' => 'يوليو',
    'aug' => 'أغسطس',
    'sep' => 'سبتمبر',
    'oct' => 'أكتوبر',
    'nov' => 'نوفمبر',
    'dec' => 'ديسمبر',

    'product_performance_report' => 'تقرير أداء المنتجات',
    'manage_product_performance' => 'إدارة أداء المنتجات',
    'product_performance_analysis' => 'تحليل أداء المنتجات',
    'product_details' => 'تفاصيل المنتج',
    'product_information' => 'معلومات المنتج',

    // Date & Time
    'start_date' => 'تاريخ البداية',
    'end_date' => 'تاريخ النهاية',
    'week' => 'الأسبوع',
    'week_number' => 'رقم الأسبوع',
    'day_number' => 'رقم اليوم',
    'sales_date' => 'تاريخ البيع',

    // Week Options
    'all_weeks' => 'جميع الأسابيع',
    'week_1' => 'الأسبوع 1',
    'week_2' => 'الأسبوع 2',
    'week_3' => 'الأسبوع 3',
    'week_4' => 'الأسبوع 4',
    'week_5' => 'الأسبوع 5',
    'weekly_totals' => 'الإجماليات الأسبوعية',

    // Filter Options (Additional)
    'all_groups' => 'جميع المجموعات',
    'all_brands' => 'جميع العلامات التجارية',
    'all_units' => 'جميع الوحدات',
    'all_users' => 'جميع المستخدمين',
    'all_staff' => 'جميع الموظفين',
    'all_methods' => 'جميع الطرق',

    // Report Sections
    'top_performing_products' => 'أفضل المنتجات أداءً',
    'weekly_sales_summary_report' => 'تقرير ملخص المبيعات الأسبوعية',
    'staff_performance_analysis' => 'تحليل أداء الموظفين',
    'stock_valuation' => 'تقييم المخزون',

    // Sales Detail Columns
    'sales_unit' => 'وحدة البيع',
    'qty_sold' => 'الكمية المبيعة',
    'total_sales_amt' => 'إجمالي مبلغ المبيعات',
    'total_purchase_amt' => 'إجمالي مبلغ الشراء',
    'profit_earned' => 'الربح المحقق',
    'margin_percent' => 'نسبة الهامش%',
    'total_purchase' => 'إجمالي الشراء',
    'total_profit' => 'إجمالي الربح',

    // Messages & Status
    'loading_sales_data' => 'جارٍ تحميل بيانات المبيعات...',
    'no_sales_data_found' => 'لم يتم العثور على بيانات مبيعات للمعايير المحددة.',
    'error_loading_sales_data' => 'خطأ في تحميل بيانات المبيعات. يرجى المحاولة مرة أخرى.',
    'report_refreshed_successfully' => 'تم تحديث التقرير بنجاح',
    'sales_detail_report_loaded' => 'تم تحميل تقرير تفاصيل المبيعات بنجاح',
    'auto_refresh_5_min' => 'التحديث التلقائي (5 دقائق)',
    'clearing' => 'جارٍ المسح...',
    'clear' => 'مسح',
    'search_by_brand_name' => 'البحث باسم العلامة التجارية...',
    'brand_monthly_sales_report' => 'تقرير مبيعات العلامة التجارية الشهرية',
    'view_brand_sales_by_months_with_profit_analysis' => 'عرض مبيعات العلامة التجارية بالشهور مع تحليل الأرباح',

    'total_qty' => 'إجمالي الكمية',
    'advanced_filters' => 'مرشحات متقدمة',
    'min_amount' => 'الحد الأدنى للمبلغ',
    'max_amount' => 'الحد الأقصى للمبلغ',

    'itemwise_sales_report' => 'تقرير مبيعات حسب الصنف',
    'itemwise_sales_subtitle' => 'تحليل مبيعات مفصل حسب أصناف المنتجات',
    'itemwise_sales_filters' => 'مرشحات تقرير المبيعات حسب الصنف',
    'product_name_sku' => 'اسم المنتج/رمز المنتج',
    'customer_name_mobile' => 'اسم العميل/الجوال',
    'clear_all_filters' => 'مسح جميع المرشحات',
    'quick_date_filters' => 'مرشحات التاريخ السريعة:',
    'clear_date' => 'مسح التاريخ',
    'unique_customers' => 'عملاء فريدون',
    'products_sold' => 'المنتجات المبيعة',
    'total_qty_sold' => 'إجمالي الكمية المبيعة',
    'detailed_view' => 'العرض المفصل',
    'applied_filters' => 'المرشحات المطبقة',
    'date_range_label' => 'نطاق التاريخ:',
    'location_label' => 'الموقع:',
    'customer_label' => 'العميل:',
    'category_label' => 'الفئة:',
    'brand_label' => 'العلامة التجارية:',
    'report_summary' => 'ملخص التقرير',
    'date' => 'التاريخ',
    'brand' => 'العلامة التجارية',
    'qty' => 'الكمية',
    'unit_price' => 'سعر الوحدة',
    'tax_percent' => 'نسبة الضريبة%',
    'subtotal' => 'المجموع الفرعي',
    'total' => 'الإجمالي',
    'totals' => 'الإجماليات:',
    'report_details' => 'تفاصيل التقرير:',
    'total_records' => 'إجمالي السجلات:',
    'report_period' => 'فترة التقرير:',
    'business_information' => 'معلومات الأعمال:',
    'tax_number' => 'الرقم الضريبي:',
    'printed_by' => 'طبع بواسطة:',
    'print_report' => 'طباعة التقرير',
    'close' => 'إغلاق',
    'all_dates' => 'جميع التواريخ',
    'purchase_cost' => 'تكلفة الشراء',

    'weekly_sales_summary_report' => 'تقرير ملخص المبيعات الأسبوعية',
    'weekly_monthly_yearly_customer_awards' => 'جوائز وتقدير العملاء الأسبوعية/الشهرية/السنوية',
    'customer_recognition_system' => 'نظام تقدير العملاء',
    'recognition_filters_controls' => 'مرشحات وضوابط التقدير',
    'period_type' => 'نوع الفترة',
    'winner_count' => 'عدد الفائزين',
    'refresh_data' => 'تحديث البيانات',
    'finalize_period' => 'إنهاء الفترة',
    'record_engagement' => 'تسجيل التفاعل',
    'current_period_winners' => 'فائزي الفترة الحالية',
    'weekly_winner' => 'الفائز الأسبوعي',
    'monthly_winner' => 'الفائز الشهري',
    'yearly_winner' => 'الفائز السنوي',
    'total_participants' => 'إجمالي المشاركين',
    'engagement_points' => 'نقاط التفاعل',
    'average_score' => 'متوسط النقاط',
    'top_score' => 'أعلى نقاط',
    'avg_transaction' => 'متوسط المعاملة',
    'customer_rankings' => 'ترتيب وتقدير العملاء',
    'sales_total' => 'إجمالي المبيعات',
    'transactions' => 'المعاملات',
    'final_score' =>  'النتيجة النهائية',
    'customer_recognition_details' => 'تفاصيل تقدير العملاء',
    'loading_customer_details' => 'جارٍ تحميل تفاصيل العملاء...',
    'award_customer' => 'تكريم العميل',
    'award_type' => 'نوع الجائزة',
    'select_award_type' => 'اختيار نوع الجائزة',
    'manual_entry' => 'إدخال يدوي',
    'from_catalog' => 'من الكتالوج',
    'gift_description' => 'وصف الهدية',
    'select_gift_from_catalog' => 'اختيار هدية من الكتالوج',
    'loading_catalog' => 'جارٍ تحميل الكتالوج...',
    'additional_notes_about_award' => 'ملاحظات إضافية حول هذه الجائزة...',
    'record_customer_engagement' => 'تسجيل تفاعل العميل',
    'engagement_type' => 'نوع التفاعل',
    'select_type' => 'اختيار النوع',
    'youtube_follow' => 'متابعة/اشتراك يوتيوب',
    'facebook_follow' => 'متابعة/إعجاب فيسبوك',
    'instagram_follow' => 'متابعة إنستغرام',
    'twitter_follow' => 'متابعة تويتر',
    'content_share' => 'مشاركة المحتوى',
    'review_testimonial' => 'مراجعة/شهادة',
    'google_review' => 'مراجعة جوجل',
    'customer_referral' => 'إحالة عميل',
    'points' => 'النقاط',
    'platform' => 'المنصة',
    'reference_url' => 'رابط المرجع',
    'verification_notes' => 'ملاحظات التحقق',
    'describe_verification_notes' => 'وصف كيفية التحقق من هذا التفاعل...',
    'finalize_period_rankings' => 'إنهاء ترتيب الفترة',
    'message_warning_finalized1' => 'بمجرد الإنهاء، لا يمكن تغيير ترتيب هذه الفترة.',
    'message_warning_finalized2' => 'سيؤدي هذا إلى تثبيت الفائزين الحاليين والسماح لك بتكريمهم.',
    'period' => 'الفترة',
    'winners_count' => 'عدد الفائزين',
    'quantity' => 'الكمية',
    'customer_engagements' => 'تفاعلات العملاء',
    'recorded_by' => 'سجل بواسطة',
    'recorded_date' => 'تاريخ التسجيل',
    'no_customer_engagements_found' => 'لم يتم العثور على تفاعلات عملاء',

    // Service Staff Recognition
    'service_staff_recognition_system' => 'نظام تقدير طاقم الخدمة',
    'weekly_monthly_yearly_staff_awards' => 'جوائز وتقدير الموظفين الأسبوعية/الشهرية/السنوية',
    'staff_rankings' => 'ترتيب وتقدير الموظفين',
    'staff_name' => 'اسم الموظف',
    'performance_points' => 'نقاط الأداء',
    'performance_activities' => 'أنشطة الأداء',
    'activity_type' => 'نوع النشاط',
    'description' => 'الوصف',
    'total_staff' => 'إجمالي الموظفين',
    'top_performer' => 'أفضل موظف',
    'average_performance' => 'متوسط الأداء',
    'total_activities' => 'إجمالي الأنشطة',
    'award_staff' => 'تكريم الموظف',
    'record_performance_activity' => 'تسجيل نشاط الأداء',
    'record_activity' => 'تسجيل النشاط',
    'staff_member' => 'عضو الطاقم',
    'punctuality' => 'الالتزام بالمواعيد',
    'customer_service_excellence' => 'التميز في خدمة العملاء',
    'upselling_success' => 'نجاح البيع التصاعدي',
    'teamwork' => 'العمل الجماعي',
    'training_completion' => 'إكمال التدريب',
    'cleanliness_organization' => 'النظافة والتنظيم',
    'other' => 'أخرى',
    'no_performance_activities_found' => 'لم يتم العثور على أنشطة أداء',

    'weekly' => 'أسبوعي',
    'monthly' => 'شهري',
    'yearly' => 'سنوي',

    'weekly_top_performer' => 'أفضل موظف أسبوعياً',
    'monthly_top_performer' => 'أفضل موظف شهرياً',
    'yearly_top_performer' => 'أفضل موظف سنوياً',

    'current_period_top_performers' => 'أفضل الموظفين في الفترة الحالية',
    'current_period_top_performer' => 'أفضل موظف في الفترة الحالية',
    'top_performer_score' => 'نقاط أفضل موظف',
    'demand_forecasting' => 'توقع الطلب',
    'demand_forecasting_report' => 'تقرير توقع الطلب',
    'historical_period' => 'الفترة التاريخية',
    'forecast_period' => 'فترة التوقع',
    '3_months' => '3 أشهر',
    '6_months' => '6 أشهر',
    '12_months' => '12 شهراً',
    'sales_prediction_subtitle' => 'توقع المبيعات والأنماط الموسمية ومنع نفاد المخزون',
    'forecasted_demand' => 'الطلب المتوقع',
    'historical_demand' => 'الطلب التاريخي',
    'forecasted_period' => 'الفترة المتوقعة',
    'generate_forecast' => 'إنشاء توقع',
    'products_analyzed' => 'المنتجات المحللة',
    'stockout_alerts' => 'تنبيهات نفاد المخزون',
    'reorder_required' => 'إعادة الطلب مطلوبة',
    'all_alerts' => 'جميع التنبيهات',
    'high' => 'عالي',
    'medium' => 'متوسط',
    'low' => 'منخفض',
    'current_stock' => 'المخزون الحالي',
    'daily_demand' => 'الطلب اليومي',
    'days_of_supply' => 'أيام التوريد',
    'alert_level' => 'مستوى التنبيه',
    'estimated_stockout' => 'نفاد المخزون المقدر',
    'recommended_action' => 'الإجراء الموصى به',
    'select_product' => 'اختيار المنتج',
    'historical' => 'تاريخي',
    'forecast' => 'توقع',
    'combined' => 'مدمج',
    'all_products' => 'جميع المنتجات',
    'reorder_now' => 'أعد الطلب الآن',
    'monitor_closely' => 'راقب عن كثب',
    'overstocked' => 'مخزون زائد',
    'optimal' => 'مثالي',
    'reorder_point' => 'نقطة إعادة الطلب',
    'eoq' => 'الكمية الاقتصادية للطلب',
    'priority' => 'الأولوية',
    'trend' => 'الاتجاه',
    'volatility' => 'التقلب',

    // Section titles
    'critical_stockout_alerts' => 'تنبيهات نفاد المخزون الحرجة',
    'demand_forecast_visualization' => 'تصور توقع الطلب',
    'seasonal_patterns' => 'الأنماط الموسمية',
    'forecasting_methods_comparison' => 'مقارنة طرق التوقع',
    'demand_confidence_levels' => 'مستويات ثقة الطلب',
    'reorder_point_optimization' => 'تحسين نقطة إعادة الطلب',
    'highest_forecasted_demand' => 'أعلى طلب متوقع',
    'most_volatile_demand' => 'أكثر طلب تقلباً',

    // Table headers
    'forecasting_methods' => 'طرق التوقع',

    // Messages and labels
    'no_critical_alerts_found' => 'لم يتم العثور على تنبيهات حرجة',
    'next_months' => 'الشهور القادمة',
    'months' => 'أشهر',
    'select_product_option' => 'اختيار المنتج',
    'forecasting_methods_labels' => 'متوسط بسيط، اتجاه خطي، أسي، موسمي، مدمج',
    'forecasting_methods_comparison_title' => 'مقارنة طرق التوقع',
    'forecast_confidence_distribution_title' => 'توزيع ثقة التوقع',
    'export_image' => 'تصدير كصورة',

    // Waste & Loss Analysis
    'waste_loss_analysis_report' => 'تقرير تحليل الفاقد والخسارة',
    'waste_loss_subtitle' => 'المنتجات منتهية الصلاحية والسلع التالفة والسرقة ومنع الخسائر',
    'analysis_period' => 'فترة التحليل',
    'analyze_waste_loss' => 'تحليل الفاقد والخسارة',
    'damaged_goods' => 'السلع التالفة',
    'theft_shrinkage' => 'السرقة والانكماش',
    'total_loss' => 'إجمالي الخسارة',
    'loss_trends' => 'اتجاهات الخسارة',
    'loss_breakdown' => 'تفصيل الخسارة',
    'expired_products_analysis' => 'تحليل المنتجات منتهية الصلاحية',
    'damaged_goods_analysis' => 'تحليل السلع التالفة',
    'theft_shrinkage_analysis' => 'تحليل السرقة والانكماش',
    'loss_prevention_insights' => 'رؤى منع الخسائر',
    'expiry_categories' => 'فئات انتهاء الصلاحية',
    'upcoming_expirations' => 'انتهاءات الصلاحية القادمة',
    'expired_today' => 'منتهي الصلاحية اليوم',
    'expired_this_week' => 'منتهي الصلاحية هذا الأسبوع',
    'expired_this_month' => 'منتهي الصلاحية هذا الشهر',
    'all_expired' => 'جميع منتهية الصلاحية',
    'days_remaining' => 'الأيام المتبقية',
    'loss_value' => 'قيمة الخسارة',
    'damage_date' => 'تاريخ التلف',
    'reason' => 'السبب',
    'damage_summary' => 'ملخص التلف',
    'physical_damage' => 'تلف مادي',
    'spoilage' => 'فساد',
    'shrinkage_rate' => 'معدل الانكماش',
    'high_risk_products' => 'منتجات عالية المخاطر',
    'incidents' => 'الحوادث',
    'quantity_lost' => 'الكمية المفقودة',
    'value_lost' => 'القيمة المفقودة',
    'top_loss_categories' => 'أكثر فئات الخسارة',
    'loss_by_location' => 'الخسارة حسب الموقع',
    'recommendations' => 'التوصيات',
    'total_loss_value' => 'إجمالي قيمة الخسارة',
    'incident_count' => 'عدد الحوادث',
    'supplier' => 'المورد',
    'last_3_months' => 'آخر 3 أشهر',
    'last_6_months' => 'آخر 6 أشهر',
    'no_expired_products' => 'لم يتم العثور على منتجات منتهية الصلاحية',
    'no_upcoming_expirations' => 'لا توجد انتهاءات صلاحية قادمة',
    'no_damaged_goods' => 'لم يتم العثور على سلع تالفة',
    'no_high_risk_products' => 'لم يتم تحديد منتجات عالية المخاطر',
    'no_recommendations' => 'لا توجد توصيات متاحة',
    'no_chart_available' => 'لا يوجد مخطط بياني متاح للتصدير',

    'value' => 'القيمة',

    // Location Performance Report
    'location_performance_report' => 'تقرير أداء المتجر/الموقع',
    'manage_location_performance' => 'إدارة أداء المتجر/الموقع',
    'location_performance_analytics' => 'تحليلات أداء الموقع',
    'multi_location_analysis' => 'تحليل متعدد المواقع',
    'location_sales_comparison' => 'مقارنة مبيعات المواقع',
    'performance_benchmarks' => 'معايير الأداء',
    'regional_sales_analysis' => 'تحليل المبيعات الإقليمية',
    'location_profitability' => 'ربحية الموقع',
    'location_comparison' => 'مقارنة المواقع',
    'benchmarking_analysis' => 'تحليل المعايير',
    'profitability_analysis' => 'تحليل الربحية',
    'performance_trends' => 'اتجاهات الأداء',
    'staff_performance' => 'أداء الموظفين',
    'performance_score' => 'نقاط الأداء',
    'revenue_per_location' => 'الإيرادات لكل موقع',
    'transactions_per_location' => 'المعاملات لكل موقع',
    'profit_per_location' => 'الربح لكل موقع',
    'top_performing_locations' => 'أفضل المواقع أداءً',
    'underperforming_locations' => 'المواقع ضعيفة الأداء',
    'location_efficiency' => 'كفاءة الموقع',
    'regional_market_share' => 'الحصة السوقية الإقليمية',
    'location_roi' => 'العائد على الاستثمار للموقع',
    'operating_expenses' => 'المصروفات التشغيلية',
    'net_profit_margin' => 'هامش صافي الربح',
    'performance_indicators' => 'مؤشرات الأداء',
    'location_overview' => 'نظرة عامة على الموقع',
    'compare_period' => 'مقارنة الفترة',
    'benchmark_metrics' => 'مقاييس المعايير',
    'revenue_growth' => 'نمو الإيرادات',
    'profit_growth' => 'نمو الأرباح',
    'efficiency_score' => 'نقاط الكفاءة',
    'top_performers' => 'أفضل الموظفين',
    'bottom_performers' => 'أضعف الموظفين',
    'location_ranking' => 'ترتيب المواقع',
    'performance_rating' => 'تقييم الأداء',
    'excellent' => 'ممتاز',
    'average' => 'متوسط',
    'poor' => 'ضعيف',
    'staff_productivity' => 'إنتاجية الموظفين',
    'sales_per_staff' => 'المبيعات لكل موظف',
    'avg_transaction_per_staff' => 'متوسط المعاملات لكل موظف',
    'staff_efficiency' => 'كفاءة الموظفين',
    'location_insights' => 'رؤى الموقع',
    'performance_summary' => 'ملخص الأداء',
    'kpi_dashboard' => 'لوحة المؤشرات الرئيسية',
    'operational_metrics' => 'المقاييس التشغيلية',

    'locations' => 'المواقع',
    'compare_with' => 'مقارنة مع',
    'compare' => 'مقارنة',

    // Additional Location Performance translations
    'transaction_growth' => 'نمو المعاملات',
    'customer_growth' => 'نمو العملاء',
    'avg_transaction_growth' => 'نمو متوسط المعاملات',
    'profit_margin_change' => 'تغيير هامش الربح',
    'current_period' => 'الفترة الحالية',
    'benchmark_period' => 'فترة المعيار',
    'regional_summary' => 'الملخص الإقليمي',
    'top_regions' => 'أفضل المناطق',
    'market_share' => 'الحصة السوقية',
    'regional_trends' => 'الاتجاهات الإقليمية',
    'location_count' => 'عدد المواقع',
    'regional_sales' => 'المبيعات الإقليمية',
    'regional_transactions' => 'المعاملات الإقليمية',
    'regional_customers' => 'العملاء الإقليميون',
    'avg_per_location' => 'متوسط لكل موقع',
    'region' => 'المنطقة',
    'profitability_ranking' => 'ترتيب الربحية',
    'average_metrics' => 'المقاييس المتوسطة',
    'avg_gross_profit_margin' => 'متوسط هامش الربح الإجمالي',
    'avg_net_profit_margin' => 'متوسط هامش صافي الربح',
    'avg_roi' => 'متوسط العائد على الاستثمار',
    'cogs' => 'تكلفة البضاعة المباعة',
    'expenses' => 'المصروفات',
    'revenue' => 'الإيرادات',
    'customers_served' => 'العملاء المخدومون',
    'avg_sale_value' => 'متوسط قيمة البيع',
    'staff_id' => 'معرف الموظف',
    'trends' => 'الاتجاهات',
    'comparison_type' => 'نوع المقارنة',
    'period_info' => 'معلومات الفترة',
    'benchmarks' => 'المعايير',
    'location_profitability_analysis' => 'تحليل ربحية الموقع',
    'staff_performance_by_location' => 'أداء الموظفين حسب الموقع',
    'performance_trends_analysis' => 'تحليل اتجاهات الأداء',
    'regional_market_analysis' => 'تحليل السوق الإقليمي',
    'benchmark_analysis' => 'تحليل المعايير',
    'select_locations' => 'اختيار المواقع',
    'date_range_required' => 'نطاق التاريخ مطلوب',
    'loading_analytics' => 'جارٍ تحميل التحليلات...',
    'analytics_loaded' => 'تم تحميل التحليلات بنجاح',
    'error_loading_analytics' => 'خطأ في تحميل التحليلات',
    'no_data_available_for_period' => 'لا توجد بيانات متاحة للفترة المحددة',
    'performance_data' => 'بيانات الأداء',
    'comparison_data' => 'بيانات المقارنة',
    'benchmark_data' => 'بيانات المعيار',
    'trend_data' => 'بيانات الاتجاه',
    'profitability_data' => 'بيانات الربحية',
    'staff_data' => 'بيانات الموظفين',
    'regional_data' => 'البيانات الإقليمية',

    'toggle_view' => 'تبديل العرض',
    'benchmark_scores' => 'نقاط المعايير',
    'sales' => 'المبيعات',
    'share' => 'الحصة',
    'city' => 'المدينة',
    'amount' => 'المبلغ',
    'detailed_location_performance' => 'أداء الموقع المفصل',
    'total_locations' => 'إجمالي المواقع',
    'avg_profit_margin' => 'متوسط هامش الربح',

    // Hardcoded text translations for Location Performance Report
    'active_locations' => 'مواقع نشطة',
    'growth' => 'نمو',
    'average_performance' => 'متوسط الأداء',
    'margin' => 'الهامش',
    'chart_view_toggled_to' => 'تم تبديل عرض المخطط إلى',
    'chart' => 'مخطط بياني',
    'staff_view_switched_to_card_layout' => 'تم تبديل عرض الموظفين إلى تخطيط البطاقات',
    'staff_view_switched_to_table_layout' => 'تم تبديل عرض الموظفين إلى تخطيط الجدول',
    'staff_performance_container_not_found' => 'لم يتم العثور على حاوية أداء الموظفين',
    'regional_sales_analysis_report' => 'تقرير تحليل المبيعات الإقليمية',
    'regional_analysis_data_not_available_for_printing' => 'بيانات التحليل الإقليمي غير متاحة للطباعة',
    'location_performance_data_exported_successfully' => 'تم تصدير بيانات أداء الموقع بنجاح',
    'error_exporting_location_data' => 'خطأ في تصدير بيانات الموقع',
    'csv_header' => 'معرف الموقع,اسم الموقع,المدينة,الولاية,إجمالي المبيعات,المعاملات,متوسط المعاملة,العملاء,إجمالي الربح,هامش الربح',
    'line' => 'خط',
    'bar' => 'عمود',
    'card' => 'بطاقة',
    'table' => 'جدول',

    // Staff Productivity Report
    'staff_productivity_report' => 'تقرير إنتاجية الموظفين',
    'sales_performance_and_efficiency' => 'تحليل أداء المبيعات والكفاءة',
    'staff_members' => 'أعضاء الطاقم',
    'active_staff' => 'موظفين نشطين',
    'total_commissions' => 'إجمالي العمولات',
    'avg_per_staff' => 'متوسط لكل موظف',
    'avg_commission' => 'متوسط العمولة',
    'avg_efficiency' => 'متوسط الكفاءة',
    'efficiency_tracking' => 'تتبع الكفاءة',
    'staff_sales_performance' => 'أداء مبيعات الموظفين',
    'working_hours_efficiency' => 'كفاءة ساعات العمل',
    'productivity_trends' => 'اتجاهات الإنتاجية',
    'commission_tracking' => 'تتبع العمولة',
    'improvement_suggestions' => 'اقتراحات تحسين الأداء',
    'detailed_staff_performance' => 'أداء الموظفين المفصل',
    'staff_comparison_analysis' => 'تحليل مقارنة الموظفين',
    'commission' => 'العمولة',
    'commission_amount' => 'مبلغ العمولة',
    'current' => 'الحالي',
    'target' => 'الهدف',
    'no_suggestions_available' => 'لا توجد اقتراحات تحسين متاحة',
    'staff_csv_header' => 'اسم الموظف,الموقع,المبيعات,المعاملات,نقاط الكفاءة,العمولة,تقييم الأداء',
    'staff_data_exported_successfully' => 'تم تصدير بيانات إنتاجية الموظفين بنجاح',
    'error_exporting_staff_data' => 'خطأ في تصدير بيانات إنتاجية الموظفين',
    'radar' => 'رادار',
    'comparison_view_switched_to_card_layout' => 'تم تبديل عرض المقارنة إلى تخطيط البطاقات',
    'comparison_view_switched_to_table_layout' => 'تم تبديل عرض المقارنة إلى تخطيط الجدول',
    'comparison_container_not_found' => 'لم يتم العثور على حاوية المقارنة',

    // Product Category Performance translations
    'product_category_performance' => 'أداء فئة المنتجات',
    'category_contribution_and_growth' => 'تحليل مساهمة الفئة واتجاهات النمو',
    'category_contribution' => 'مساهمة الفئة',
    'cross_selling_opportunities' => 'فرص البيع المتقاطع',
    'margin_analysis' => 'تحليل الهامش',
    'detailed_category_performance' => 'أداء الفئة المفصل',
    'contribution' => 'المساهمة',
    'avg_price' => 'متوسط السعر',
    'units_sold' => 'الوحدات المبيعة',
    'total_categories' => 'إجمالي الفئات',
    'sales_contribution' => 'مساهمة المبيعات',
    'profit_contribution' => 'مساهمة الأرباح',
    'days_to_sell' => 'أيام البيع',
    'stock_velocity' => 'سرعة المخزون',
    'co_occurrences' => 'التكرارات المشتركة',
    'avg_value' => 'متوسط القيمة',
    'sales_pattern' => 'نمط المبيعات',
    'view_toggled' => 'تم تبديل العرض بنجاح',
    'unique_products' => 'منتجات فريدة',
    'units' => 'الوحدات',

    // Additional translations for Product Category Report
    'error_loading_analytics_data' => 'خطأ في تحميل بيانات التحليلات. يرجى المحاولة مرة أخرى.',
    'margin_percentage' => 'نسبة الهامش%',
    'growth_rate_percentage' => 'نسبة معدل النمو%',
    'confidence_label' => 'الثقة:',
    'transactions_label' => 'المعاملات:',
    'analytics_data_received' => 'تم استلام بيانات التحليلات:',
    'loading_data' => 'جارٍ تحميل البيانات...',
    'filter_controls' => 'ضوابط المرشح',
    'business_location' => 'موقع الأعمال',
    'brands' => 'العلامات التجارية',
    'export_data' => 'تصدير البيانات',
    'last_7_days' => 'آخر 7 أيام',
    'top_performing_categories' => 'أفضل الفئات أداءً',

    'categories' => 'الفئات',
    'total_revenue' => 'إجمالي الإيرادات',

    // Seasonal Trends Report
    'seasonal_trends_report' => 'تقرير الاتجاهات الموسمية',
    'seasonal_trends_description' => 'تحليل الأنماط الموسمية وأداء العطلات وفعالية العروض الترويجية',

    // Audit Trail Report
    'audit_trail_report' => 'تقرير سجل التدقيق',
    'audit_trail_description' => 'تتبع شامل للامتثال وإدارة المخاطر',
    'audit_activities' => 'أنشطة التدقيق',
    'transaction_modifications' => 'تعديلات المعاملات',
    'high_risk_activities' => 'الأنشطة عالية المخاطر',
    'active_users' => 'المستخدمون النشطون',
    'activities_by_type' => 'الأنشطة حسب النوع',
    'risk_level_distribution' => 'توزيع مستوى المخاطر',
    'daily_activity_trend' => 'اتجاه النشاط اليومي',
    'top_active_users' => 'أكثر المستخدمين نشاطاً',
    'audit_trail_filters' => 'مرشحات سجل التدقيق',
    'detailed_audit_trail' => 'سجل التدقيق المفصل',
    'risk_level' => 'مستوى المخاطر',
    'compliance_status' => 'حالة الامتثال',
    'transaction_details' => 'تفاصيل المعاملة',
    'user_info' => 'معلومات المستخدم',
    'medium_risk' => 'مخاطر متوسطة',
    'compliant' => 'متوافق',
    'requires_review' => 'يتطلب مراجعة',
    'non_compliant' => 'غير متوافق',
    'compliance_risk_management' => 'الامتثال وإدارة المخاطر',

    // Tax Compliance Report
    'tax_compliance_report' => 'تقرير الامتثال الضريبي',
    'tax_compliance_description' => 'دعم الولايات الضريبية المتعددة ورؤى التحسين',
    
    // Multi-Channel Sales Report
    'multi_channel_sales_report' => 'تقرير المبيعات متعددة القنوات',
    'multi_channel_description' => 'تحليلات أداء عبر الإنترنت مقابل غير متصل وتحسين',
    'online_revenue' => 'الإيرادات عبر الإنترنت',
    'offline_revenue' => 'الإيرادات غير المتصلة',
    'cross_channel_customers' => 'عملاء متعددي القنوات',
    'channel_efficiency' => 'كفاءة القناة',
    'channel_profitability' => 'ربحية القناة',
    'customer_channel_preferences' => 'تفضيلات قناة العملاء',
    'peak_hours_by_channel' => 'ساعات الذروة حسب القناة',
    'channel_optimization_insights' => 'رؤى تحسين القناة',
    'total_tax_collected' => 'إجمالي الضريبة المحصلة',
    'net_tax_liability' => 'صافي الالتزام الضريبي',
    'compliance_score' => 'نقاط الامتثال',
    'potential_savings' => 'التوفيرات المحتملة',
    'monthly_tax_liability_trend' => 'اتجاه الالتزام الضريبي الشهري',
    'tax_by_jurisdiction' => 'الضريبة حسب الولاية القضائية',
    'tax_audit_risk_assessment' => 'تقييم مخاطر التدقيق الضريبي',
    'risk_score' => 'نقاط المخاطر',
    'tax_optimization_insights' => 'رؤى تحسين الضرائب',
    'upcoming_filing_deadlines' => 'مواعيد الإيداع القادمة',
    'filing_deadline' => 'موعد الإيداع',
    'generate_report' => 'إنشاء تقرير',
    'tax_liability_details' => 'تفاصيل الالتزام الضريبي',
    'tax_name' => 'اسم الضريبة',
    'tax_rate' => 'معدل الضريبة (%)',
    'output_tax' => 'الضريبة المخرجة',
    'input_tax_credit' => 'ائتمان الضريبة المدخلة',
    'net_liability' => 'صافي الالتزام',
    'sales_trans' => 'معاملات المبيعات',
    'purchase_trans' => 'معاملات المشتريات',
    'jurisdiction' => 'الولاية القضائية',
    'filing_period' => 'فترة الإيداع',
    'report_type' => 'نوع التقرير',
    'export_report' => 'تصدير التقرير',
    'export_excel' => 'تصدير Excel',
    'tax_liability' => 'الالتزام الضريبي',
    'filing_assistance' => 'مساعدة الإيداع',
    'optimization' => 'التحسين',
    'quarterly' => 'ربع سنوي',
    'semi_annual' => 'نصف سنوي',
    'annual' => 'سنوي',
    'pending' => 'قيد المراجعة',
    'overdue' => 'متأخر',
    'exempted' => 'معفى',
    'urgent' => 'عاجل',
    'upcoming' => 'قادم',
    'federal' => 'فيدرالي',
    'state_local' => 'ولاية/محلي',
    'gross_sales' => 'إجمالي المبيعات',
    'taxable_sales' => 'المبيعات الخاضعة للضريبة',
    'tax_collected' => 'الضريبة المحصلة',
    'tax_paid_on_purchases' => 'الضريبة المدفوعة على المشتريات',
    'filing_status' => 'حالة الإيداع',
    'tax_rate_efficiency_analysis' => 'تحليل كفاءة معدل الضريبة',
    'seasonal_tax_optimization' => 'تحسين الضريبة الموسمية',
    'input_tax_credit_opportunities' => 'فرص ائتمان الضريبة المدخلة',
    'multi_tax_jurisdiction_support' => 'دعم الولاية الضريبية المتعددة والتحسين',
    'monthly_trends' => 'الاتجاهات الشهرية',
    'yearly_trends' => 'الاتجاهات السنوية',
    'holiday_season_performance' => 'أداء موسم العطلات',
    'promotional_effectiveness' => 'فعالية العروض الترويجية',
    'weather_impact_analysis' => 'تحليل تأثير الطقس',
    'peak_performance_analysis' => 'تحليل أداء الذروة',
    'current_year_performance' => 'أداء العام الحالي',
    'year_over_year_growth' => 'النمو مقارنة بالعام السابق',
    'best_performing_season' => 'أفضل موسم أداءً',
    'best_performing_month' => 'أفضل شهر أداءً',
    'best_performing_months' => 'أفضل الشهور أداءً',
    'day_of_week_performance' => 'أداء يوم الأسبوع',
    'last_1_year' => 'العام الماضي',
    'last_2_years' => 'آخر سنتين',
    'last_3_years' => 'آخر 3 سنوات',
    'last_5_years' => 'آخر 5 سنوات',
    'gross_revenue' => 'إجمالي الإيرادات',
    'promotion_type' => 'نوع العرض الترويجي',
    'avg_discount' => 'متوسط الخصم',
    'discount_percentage' => 'نسبة الخصم',
    'weather_analysis_coming_soon' => 'تحليل الطقس قريباً',
    'weather_analysis_description' => 'التكامل مع واجهات برمجة تطبيقات الطقس لتحليل تأثير الظروف الجوية على أداء المبيعات',
    'holiday_performance' => 'أداء العطلات',
    'daily_average' => 'المتوسط اليومي',
    'duration_days' => 'المدة (أيام)',
    'growth_direction' => 'اتجاه النمو',

    // Supplier Performance Report
    'supplier_performance_report' => 'تقرير أداء الموردين',
    'supplier_performance_description' => 'أداء التسليم وتقييم الجودة والامتثال للدفع وتحليل المخاطر',
    'delivery_performance' => 'أداء التسليم',
    'quality_assessment' => 'تقييم الجودة',
    'payment_compliance' => 'امتثال الدفع',
    'supplier_risk_analysis' => 'تحليل مخاطر المورد',
    'on_time_delivery' => 'التسليم في الوقت المحدد',
    'average_delivery_days' => 'متوسط أيام التسليم',
    'supplier_reliability' => 'موثوقية المورد',
    'quality_rating' => 'تقييم الجودة',
    'defect_rate' => 'معدل العيوب',
    'payment_terms_compliance' => 'امتثال شروط الدفع',
    'supplier_rankings' => 'ترتيب الموردين',
    'underperformers' => 'ضعيفي الأداء',
    'delivery_insights' => 'رؤى التسليم',
    'quality_insights' => 'رؤى الجودة',
    'payment_insights' => 'رؤى الدفع',
    'risk_insights' => 'رؤى المخاطر',
    'total_suppliers' => 'إجمالي الموردين',
    'total_spend' => 'إجمالي الإنفاق',
    'avg_delivery_time' => 'متوسط وقت التسليم',
    'overall_compliance' => 'الامتثال الإجمالي',
    'delivery_reliability' => 'موثوقية التسليم',
    'supplier_name' => 'اسم المورد',
    'orders_count' => 'عدد الطلبات',
    'avg_delivery_days' => 'متوسط أيام التسليم',
    'quality_score' => 'نقاط الجودة',
    'payment_score' => 'نقاط الدفع',
    'overall_score' => 'النقاط الإجمالية',
    'supplier_details' => 'تفاصيل المورد',
    'performance_metrics' => 'مقاييس الأداء',

    // Warranty & Service Report
    'warranty_service_report' => 'تقرير الضمان والخدمة',
    'warranty_service_description' => 'تتبع ضمان المنتج وتحليل طلبات الخدمة ومقاييس دعم العملاء',
    'warranty_tracking' => 'تتبع الضمان',
    'service_requests_analysis' => 'تحليل طلبات الخدمة',
    'customer_support_metrics' => 'مقاييس دعم العملاء',
    'post_sale_service_performance' => 'أداء خدمة ما بعد البيع',
    'warranty_claims_analysis' => 'تحليل مطالبات الضمان',
    'product_warranty_tracking' => 'تتبع ضمان المنتج',
    'service_request_analysis' => 'تحليل طلب الخدمة',
    'warranty_status_distribution' => 'توزيع حالة الضمان',
    'service_request_trends' => 'اتجاهات طلبات الخدمة',
    'total_products_sold' => 'إجمالي المنتجات المبيعة',
    'warranty_coverage' => 'تغطية الضمان',
    'service_requests' => 'طلبات الخدمة',
    'resolution_rate' => 'معدل الحل',
    'warranty_status' => 'حالة الضمان',
    'warranty_end_date' => 'تاريخ انتهاء الضمان',
    'product_value' => 'قيمة المنتج',
    'request_id' => 'معرف الطلب',
    'resolution_days' => 'أيام الحل',
    'warranties_expiring_soon' => 'الضمانات المنتهية قريباً',
    'service_recommendations' => 'توصيات الخدمة',
    'performance_insights' => 'رؤى الأداء',
    'key_insights' => 'الرؤى الرئيسية',
    'comprehensive_report' => 'تقرير شامل',
    'warranty_claims' => 'مطالبات الضمان',
    'avg_response_time' => 'متوسط وقت الاستجابة',
    'avg_resolution_time' => 'متوسط وقت الحل',
    'customer_satisfaction' => 'رضا العملاء',
    'first_response_sla' => 'اتفاقية مستوى الخدمة للاستجابة الأولى',
    'resolution_sla' => 'اتفاقية مستوى خدمة الحل',
    'warranty_claim_rate' => 'معدل مطالبة الضمان',
    'service_cost_ratio' => 'نسبة تكلفة الخدمة',
    'response_time_metrics' => 'مقاييس وقت الاستجابة',
    'warranty_expiring_alert' => 'الضمانات المنتهية خلال 30 يوماً القادمة',
    'high_priority_requests' => 'طلبات عالية الأولوية',
    'pending_resolutions' => 'الحلول المعلقة',
    'warranty_type' => 'نوع الضمان',
    'claim_amount' => 'مبلغ المطالبة',
    'claim_reason' => 'سبب المطالبة',
    'service_type' => 'نوع الخدمة',
    'assigned_staff' => 'الموظف المعين',
    'request_priority' => 'أولوية الطلب',
    'service_cost' => 'تكلفة الخدمة',
    'resolution_time' => 'وقت الحل',
    'customer_feedback' => 'تعليقات العملاء',
    'satisfaction_rating' => 'تقييم الرضا',
    'service_quality' => 'جودة الخدمة',
    'warranty_utilization' => 'استخدام الضمان',
    'post_sale_performance' => 'أداء ما بعد البيع',

    // Customer Group Report
    'customer_group_report' => 'تقرير مجموعة العملاء',
    'customer_group_analytics' => 'تحليلات مجموعة العملاء',
    'customer_group_description' => 'تحليل الأداء حسب مجموعات العملاء مع التفصيل لمندوبي المبيعات',
    'group_leaderboard' => 'لوحة صدارة المجموعة',
    'salesperson_performance' => 'أداء مندوب المبيعات',
    'customer_drill_down' => 'التفصيل للعملاء',
    'invoice_drill_down' => 'التفصيل للفواتير',
    'aging_analysis' => 'تحليل العمر',
    'net_sales' => 'صافي المبيعات',
    'customer_count' => 'العملاء',
    'invoice_count' => 'الفواتير',
    'avg_invoice_value' => 'متوسط الفاتورة',
    'top_performing_group' => 'أفضل مجموعة أداءً',
    'top_salesperson' => 'أفضل مندوب مبيعات',
    'outstanding_due' => 'المستحقات المتميزة',
    'aging_buckets' => 'دلاء العمر',
    'vip_customers' => 'عملاء VIP',
    'regular_customers' => 'عملاء عاديون',
    'new_customers' => 'عملاء جدد',
    'unassigned_customers' => 'غير مخصص',
    'drill_down_analysis' => 'تحليل التفصيل',

    // Menu Navigation Translations
    'sales_revenue_analysis' => 'تحليل المبيعات والإيرادات',
    'sales_analytics' => 'تحليلات المبيعات',
    'transaction_details' => 'تفاصيل المعاملة', 
    'customer_performance' => 'أداء العملاء',
    'product_sales_analysis' => 'تحليل مبيعات المنتجات',
    'daily_operations' => 'العمليات اليومية',
    'daily_dashboard' => 'لوحة القيادة اليومية',
    'inventory_product_management' => 'إدارة المخزون والمنتجات',
    'inventory_turnover_report' => 'تقرير دوران المخزون',
    'demand_forecasting_report' => 'تقرير توقع الطلب',
    'waste_loss_analysis_report' => 'تقرير تحليل الفاقد والخسارة',
    'location_performance_report' => 'تقرير أداء الموقع',
    'staff_productivity_report' => 'تقرير إنتاجية الموظفين',
    'stock_management' => 'إدارة المخزون',
    'product_performance' => 'أداء المنتج',
    'brand_analytics' => 'تحليلات العلامة التجارية',
    'brand_comparison' => 'مقارنة العلامة التجارية',
    'supplier_performance' => 'أداء المورد',
    'supplier_analysis' => 'تحليل المورد',
    'supplier_profitability' => 'ربحية المورد',
    'financial_compliance' => 'الامتثال المالي',
    'profit_loss_analysis' => 'تحليل الأرباح والخسائر',
    'purchase_analysis' => 'تحليل المشتريات',
    'customer_lifetime_value' => 'قيمة العميل مدى الحياة',
    'customer_behavior_analytics' => 'تحليلات سلوك العملاء',
    'customer_segmentation_report' => 'تقرير تقسيم العملاء',
    'gst_sales_compliance' => 'امتثال مبيعات ضريبة السلع والخدمات',
    'gst_purchase_compliance' => 'امتثال مشتريات ضريبة السلع والخدمات',
    'monthly_expenses' => 'المصروفات الشهرية',
    'business_operations_summary' => 'ملخص عمليات الأعمال',
    'customer_staff_engagement' => 'تفاعل العملاء والموظفين',
    'customer_loyalty_program' => 'برنامج ولاء العملاء',
    'staff_performance_management' => 'إدارة أداء الموظفين',
    
    // Product search
    'type_to_search_product' => 'اكتب للبحث عن المنتج',
    'searching' => 'جاري البحث...',
    'no_products_found' => 'لم يتم العثور على منتجات',

];