<?php

return [
    // Module
    'advanced_reports_module' => 'Advanced Reports Module',
    'advanced_reports' => 'Advanced Reports',
    'manage_advanced_reports' => 'Manage Advanced Reports',
    'service_staff_not_enabled' => 'Service Staff module is not enabled. Please enable Service Staff module in Business Settings to use Staff Recognition reports.',

    // Permissions
    'view_reports' => 'View Reports',
    'export_reports' => 'Export Reports',

    // Stock Report
    'stock_report' => 'Stock Report',
    'manage_stock_report' => 'Manage Stock Report',
    'current_stock' => 'Current Stock',
    'stock_value_purchase' => 'Stock Value (Purchase)',
    'stock_value_sale' => 'Stock Value (Sale)',
    'potential_profit' => 'Potential Profit',
    'total_sold' => 'Total Sold',
    'selling_price' => 'Selling Price',
    'total_products' => 'Total Products',
    'total_stock_quantity' => 'Total Stock Quantity',
    'show_zero_stock' => 'Show Zero Stock',
    'out_of_stock' => 'Out of Stock',
    'low_stock' => 'Low Stock',
    'total_stock_value' => 'Total Stock Value',
    'product_info' => 'Product Info',
    'active' => 'Active',
    'inactive' => 'Inactive',
    'lot_number' => 'Lot Number',

    // Sales Report
    'sales_report' => 'Sales Report',
    'manage_sales_report' => 'Manage Sales Report',
    'invoice_no' => 'Invoice No',
    'transaction_date' => 'Transaction Date',
    'customer_name' => 'Customer Name',
    'payment_status' => 'Payment Status',
    'total_before_tax' => 'Total Before Tax',
    'tax_amount' => 'Tax Amount',
    'final_total' => 'Final Total',
    'total_paid' => 'Total Paid',
    'balance_due' => 'Balance Due',
    'total_sales' => 'Total Sales',
    'average_sale' => 'Average Sale',
    'total_due' => 'Total Due',

    // Product Report
    'product_report' => 'Product Sales Report',

    // Pricing Optimization
    'pricing_optimization' => 'Pricing Optimization',
    'pricing_analytics_dashboard' => 'Pricing Analytics Dashboard',
    'price_elasticity_analysis' => 'Price Elasticity Analysis',
    'competitor_price_analysis' => 'Competitor Price Analysis',
    'discount_impact_analysis' => 'Discount Impact Analysis',
    'dynamic_pricing_suggestions' => 'Dynamic Pricing Suggestions',
    'revenue_optimization' => 'Revenue Optimization',
    'average_margin' => 'Average Margin',
    'average_selling_price' => 'Average Selling Price',
    'current_price' => 'Current Price',
    'cost_price' => 'Cost Price',
    'suggested_price' => 'Suggested Price',
    'quantity_sold' => 'Quantity Sold',
    'velocity' => 'Velocity',
    'elasticity_type' => 'Elasticity Type',
    'recommendation' => 'Recommendation',
    'our_price' => 'Our Price',
    'market_average' => 'Market Average',
    'market_position' => 'Market Position',
    'price_difference' => 'Price Difference',
    'competitiveness' => 'Competitiveness',
    'discount_frequency' => 'Discount Frequency',
    'avg_discount_percent' => 'Avg Discount %',
    'discounted_sales' => 'Discounted Sales',
    'regular_sales' => 'Regular Sales',
    'effectiveness_score' => 'Effectiveness Score',
    'price_change' => 'Price Change',
    'confidence' => 'Confidence',
    'reasoning' => 'Reasoning',
    'revenue_impact' => 'Revenue Impact',
    'products' => 'Products',
    'optimization_score' => 'Optimization Score',

    // ABC Analysis
    'abc_analysis' => 'ABC Analysis',
    'abc_analysis_description' => 'Classify products by value and optimize resource allocation',
    'abc_analysis_dashboard' => 'ABC Analysis Dashboard',
    'analysis_type' => 'Analysis Type',
    'inventory_value' => 'Inventory Value',
    'sales_revenue' => 'Sales Revenue',
    'hybrid_analysis' => 'Hybrid Analysis',
    'analyze' => 'Analyze',
    'a_grade_items' => 'A-Grade Items',
    'b_grade_items' => 'B-Grade Items',
    'c_grade_items' => 'C-Grade Items',
    'total_analysis_value' => 'Total Analysis Value',
    'abc_distribution_chart' => 'ABC Distribution Chart',
    'pareto_analysis' => 'Pareto Analysis',
    'revenue_contribution_analysis' => 'Revenue Contribution Analysis',
    'abc_grade' => 'ABC Grade',
    'item_count' => 'Item Count',
    'inventory_value' => 'Inventory Value',
    'turnover_ratio' => 'Turnover Ratio',
    'focus_strategy' => 'Focus Strategy',
    'management_approach' => 'Management Approach',
    'resource_allocation_recommendations' => 'Resource Allocation Recommendations',
    'detailed_product_classification' => 'Detailed Product Classification',
    'rank' => 'Rank',
    'variant_title' => 'Variant Title',
    'variant_sku' => 'Variant SKU',
    'ending_quantity' => 'Ending Quantity',
    'total_cost_value' => 'Total Cost Value',
    'total_selling_value' => 'Total Selling Value',
    'cumulative_percent' => 'Cumulative %',
    'manage_product_report' => 'Manage Product Sales Report',
    'total_quantity_sold' => 'Total Quantity Sold',
    'total_amount_sold' => 'Total Amount Sold',
    'profit_margin' => 'Profit Margin',
    'top_selling_products' => 'Top Selling Products',
    'slow_moving_products' => 'Slow Moving Products',

    'quantity_sold' => 'Quantity Sold',

    // Price List
    'price_list' => 'Price List',
    'manage_price_list' => 'Manage Price List',
    'purchase_price' => 'Purchase Price',
    'margin_percentage' => 'Margin %',
    'update_price' => 'Update Price',
    'bulk_update_prices' => 'Bulk Update Prices',

    // Common
    'filters' => 'Filters',
    'date_range' => 'Date Range',
    'location' => 'Location',
    'category' => 'Category',
    'customer' => 'Customer',
    'from_date' => 'From Date',
    'to_date' => 'To Date',
    'apply_filter' => 'Apply Filter',
    'clear_filter' => 'Clear Filter',
    'export' => 'Export',
    'export_to_excel' => 'Export to Excel',
    'export_to_pdf' => 'Export to PDF',
    'export_to_csv' => 'Export to CSV',
    'print' => 'Print',
    'refresh' => 'Refresh',
    'search' => 'Search',
    'no_data_found' => 'No data found',
    'loading' => 'Loading...',

    // Summary
    'summary' => 'Summary',
    'grand_total' => 'Grand Total',
    'totals' => 'Totals',
    'count' => 'Count',

    // Messages
    'report_generated_successfully' => 'Report generated successfully',
    'export_completed_successfully' => 'Export completed successfully',
    'no_records_found' => 'No records found for the selected criteria',
    'please_select_date_range' => 'Please select a date range',
    'invalid_date_range' => 'Invalid date range selected',
    'export_in_progress' => 'Export is in progress, please wait...',
    'max_export_limit_exceeded' => 'Maximum export limit exceeded. Please refine your filters.',

    // Errors
    'error_generating_report' => 'Error generating report',
    'error_exporting_data' => 'Error exporting data',
    'permission_denied' => 'Permission denied',
    'invalid_request' => 'Invalid request',

    // Installation
    'install_success' => 'Advanced Reports module installed successfully',
    'update_success' => 'Advanced Reports module updated successfully',
    'uninstall_success' => 'Advanced Reports module uninstalled successfully',

    // Charts
    'sales_trend' => 'Sales Trend',
    'top_products' => 'Top Products',
    'sales_by_location' => 'Sales by Location',
    'sales_by_category' => 'Sales by Category',
    'profit_analysis' => 'Profit Analysis',

    // Advanced Features
    'schedule_report' => 'Schedule Report',
    'email_report' => 'Email Report',
    'save_filter' => 'Save Filter',
    'load_saved_filter' => 'Load Saved Filter',
    'custom_columns' => 'Custom Columns',
    'group_by' => 'Group By',
    'sort_by' => 'Sort By',
    'chart_view' => 'Chart View',
    'table_view' => 'Table View',

    // Time Periods
    'today' => 'Today',
    'yesterday' => 'Yesterday',
    'this_week' => 'This Week',
    'last_week' => 'Last Week',
    'this_month' => 'This Month',
    'last_month' => 'Last Month',
    'this_quarter' => 'This Quarter',
    'last_quarter' => 'Last Quarter',
    'this_year' => 'This Year',
    'last_year' => 'Last Year',
    'last_30_days' => 'Last 30 Days',
    'custom_range' => 'Custom Range',

    'applying' => 'Applying',
    'apply_filters' => 'Apply Filters',

    // Dashboard
    'dashboard' => 'Dashboard',
    'key_metrics' => 'Key Metrics',
    'recent_reports' => 'Recent Reports',
    'quick_actions' => 'Quick Actions',
    'generate_report' => 'Generate Report',
    'view_all_reports' => 'View All Reports',
    'report_center' => 'Report Center',

    'all_categories' => 'All Categories',
    'filter' => 'Filter',

    // Sales Report entries
    'sales_report' => 'Sales Report',
    'manage_sales_report' => 'Manage sales transactions and analyze performance',
    'sales_details' => 'Sales Details',
    'total_transactions' => 'Total Transactions',
    'total_customers' => 'Total Customers',
    'total_products' => 'Total Products',
    'customer' => 'Customer',
    'customers' => 'Customers',
    'product' => 'Product',
    'products' => 'Products',
    'total_customers_count' => 'Total Customers Count',
    'total_products_count' => 'Total Products Count',
    'total_sales_amount' => 'Total Sales Amount',
    'total_tax_amount' => 'Total Tax Amount',
    'total_discount' => 'Total Discount',
    'paid_transactions' => 'Paid Amount',
    'paid_transactions_count' => 'Paid Transactions Count',
    'total_paid_amount' => 'Total Paid Amount',
    'due_transactions' => 'Due Amount',
    'due_transactions_count' => 'Due Transactions Count',
    'total_due_amount' => 'Total Due Amount',
    'invoice' => 'Invoice',
    'invoices' => 'Invoices',
    'partial_transactions' => 'Partial Transactions',
    'paid_amount' => 'Paid Amount',
    'due_amount' => 'Due Amount',
    'balance_due' => 'Balance Due',
    'total_paid' => 'Total Paid',
    'transaction_info' => 'Transaction Information',
    'created_by' => 'Created By',
    'view_full_invoice' => 'View Full Invoice',

    // Additional entries that might be useful
    'sales_summary' => 'Sales Summary',
    'payment_summary' => 'Payment Summary',
    'customer_info' => 'Customer Information',
    'sales_performance' => 'Sales Performance',
    'daily_sales' => 'Daily Sales',
    'monthly_sales' => 'Monthly Sales',
    'yearly_sales' => 'Yearly Sales',
    'top_customers' => 'Top Customers',
    'sales_by_location' => 'Sales by Location',
    'sales_by_payment_method' => 'Sales by Payment Method',
    'average_transaction_value' => 'Average Transaction Value',
    'total_transactions_today' => 'Total Transactions Today',
    'sales_growth' => 'Sales Growth',
    'revenue_analysis' => 'Revenue Analysis',

    // Filter related
    'filter_by_date' => 'Filter by Date',
    'filter_by_customer' => 'Filter by Customer',
    'filter_by_location' => 'Filter by Location',
    'filter_by_payment_status' => 'Filter by Payment Status',
    'filter_by_payment_method' => 'Filter by Payment Method',
    'date_range' => 'Date Range',
    'select_date_range' => 'Select Date Range',
    'all_customers' => 'All Customers',
    'all_locations' => 'All Locations',
    'all_payment_methods' => 'All Payment Methods',
    'all_statuses' => 'All Statuses',

    // Export related
    'export_sales_report' => 'Export Sales Report',
    'sales_report_exported' => 'Sales report has been exported successfully',
    'export_failed' => 'Export failed. Please try again.',

    // Status messages
    'no_sales_found' => 'No sales found for the selected criteria',
    'loading_sales_data' => 'Loading sales data...',
    'sales_data_loaded' => 'Sales data loaded successfully',
    'error_loading_sales' => 'Error loading sales data',

    // Validation messages
    'invalid_date_range' => 'Please select a valid date range',
    'date_range_too_large' => 'Date range is too large. Please select a smaller range.',
    'no_data_available' => 'No data available for the selected filters',

    // Performance metrics
    'sales_trend' => 'Sales Trend',
    'growth_rate' => 'Growth Rate',
    'conversion_rate' => 'Conversion Rate',
    'repeat_customers' => 'Repeat Customers',
    'new_customers' => 'New Customers',
    'average_order_value' => 'Average Order Value',
    'total_orders' => 'Total Orders',
    'orders_per_customer' => 'Orders per Customer',

    // Time periods
    'today' => 'Today',
    'yesterday' => 'Yesterday',
    'this_week' => 'This Week',
    'last_week' => 'Last Week',
    'this_month' => 'This Month',
    'last_month' => 'Last Month',
    'this_year' => 'This Year',
    'last_year' => 'Last Year',
    'custom_range' => 'Custom Range',

    // Additional useful phrases
    'view_details' => 'View Details',
    'hide_details' => 'Hide Details',
    'expand_all' => 'Expand All',
    'collapse_all' => 'Collapse All',
    'refresh_data' => 'Refresh Data',
    'last_updated' => 'Last Updated',
    'auto_refresh' => 'Auto Refresh',
    'manual_refresh' => 'Manual Refresh',
    'data_as_of' => 'Data as of',
    'real_time_data' => 'Real-time Data',

    // Chart/Graph related
    'chart_view' => 'Chart View',
    'table_view' => 'Table View',
    'bar_chart' => 'Bar Chart',
    'line_chart' => 'Line Chart',
    'pie_chart' => 'Pie Chart',
    'show_chart' => 'Show Chart',
    'hide_chart' => 'Hide Chart',

    // Comparison related
    'compare_periods' => 'Compare Periods',
    'previous_period' => 'Previous Period',
    'same_period_last_year' => 'Same Period Last Year',
    'percentage_change' => 'Percentage Change',
    'absolute_change' => 'Absolute Change',
    'trend_analysis' => 'Trend Analysis',

    // Due Collections Analysis
    'due_collections_analysis' => 'Due Collections Analysis',
    'collected_today' => 'Collected Today',
    'pending_due_today' => 'Pending Due Today',
    'overdue_amounts' => 'Overdue Amounts',
    'due_payments_received' => 'Due payments received today',
    'todays_unpaid_sales' => 'Today\'s unpaid sales',
    'previous_days_unpaid' => 'Previous days unpaid',
    'cash_collected_today' => 'Cash Collected Today',
    'due_collection_cash' => 'Due Collection Cash',
    'total_due_collected' => 'Total Due Collected',
    'total_pending_due' => 'Total Pending Due',
    'total_overdue' => 'Total Overdue',
    'due_collection_summary' => 'Due Collection Summary',
    'payment_collection_status' => 'Payment Collection Status',
    'outstanding_receivables' => 'Outstanding Receivables',
    'receivables_aging' => 'Receivables Aging',
    'collection_efficiency' => 'Collection Efficiency',
    'overdue_analysis' => 'Overdue Analysis',
    'aging_report' => 'Aging Report',
    'collection_report' => 'Collection Report',
    'cash_flow_analysis' => 'Cash Flow Analysis',
    'payment_trends' => 'Payment Trends',
    'due_follow_up' => 'Due Follow-up',
    'collection_alerts' => 'Collection Alerts',
    'payment_reminders' => 'Payment Reminders',
    'credit_management' => 'Credit Management',
    'customer_payment_history' => 'Customer Payment History',
    'payment_performance' => 'Payment Performance',


    // sales_detail_report
    'sales_detail_report' => 'Sales Detail Report',

    'sales_detail_report' => 'Sales Detail Report',
    'gst_sales_report' => 'GST Sales Report',
    'gst_purchase_report' => 'GST Purchase Report',
    'operations_summary_report' => 'Operations Summary Report',
    'daily_summary_report' => 'Daily Summary Report',
    'daily_report' => 'Daily Report',
    'manage_gst_sales_report' => 'Manage GST Sales Report',
    'total_tax' => 'Total Tax',
    'taxable_amount' => 'Taxable Amount',
    'avg_tax_rate' => 'Average Tax Rate',
    'taxable_value' => 'Taxable Value',
    'today_sales' => 'Today Sales',
    'today_purchases' => 'Today Purchases',
    'today_expenses' => 'Today Expenses',
    'net_profit' => 'Net Profit',
    'cash_in_hand' => 'Cash in Hand',
    'purchase_summary' => 'Purchase Summary',
    'expense_summary' => 'Expense Summary',
    'payment_methods_summary' => 'Payment Methods Summary',
    'payment_method' => 'Payment Method',
    'transaction_count' => 'Transaction Count',
    'total_amount' => 'Total Amount',
    'manage_daily_summary' => 'Manage Daily Summary',
    'total_purchases' => 'Total Purchases',
    'total_expenses' => 'Total Expenses',
    'avg_daily_sales' => 'Average Daily Sales',
    'profitable_days' => 'Profitable Days',
    'day' => 'Day',
    'sales_count' => 'Sales Count',
    'purchase_count' => 'Purchase Count',
    'expense_count' => 'Expense Count',
    'cash_received' => 'Cash Received',
    'card_received' => 'Card Received',

    'comprehensive_daily_overview' => 'Comprehensive Daily Overview',
    'today_profit' => 'Today Profit',
    'bank_balance' => 'Bank Balance',
    'customer_due' => 'Customer Due',
    'supplier_due' => 'Supplier Due',
    'today_collections' => 'Today Collections',
    'net_worth' => 'Net Worth',
    'todays_activity' => 'Today\'s Activity',
    'financial_snapshot' => 'Financial Snapshot',
    'avg_transaction_value' => 'Average Transaction Value',
    'gross_profit_margin' => 'Gross Profit Margin',
    'opening_balance' => 'Opening Balance',
    'closing_balance' => 'Closing Balance',
    'cash_flow' => 'Cash Flow',
    'liquidity_ratio' => 'Liquidity Ratio',
    'detailed_breakdown' => 'Detailed Breakdown',
    'loading' => 'loading',
    'manage_operations_summary' => 'Manage Operations Summary',
    'report_date' => 'Report Date',

    'gst_sales_by_products' => 'GST Sales by Products',
    'gst_sales_by_invoice' => 'GST Sales by Invoice',
    'total_products' => 'Total Products',

    // Stock report specific translations
    'total_stock_purchase_value' => 'Total Stock Purchase Value',
    'total_stock_sales_value' => 'Total Stock Sales Value',
    'stock_value_purchase' => 'Stock Value (Purchase)',
    'stock_value_sale' => 'Stock Value (Sale)',

    // Stock report specific translations
    'total_stock_purchase_value' => 'Total Stock Purchase Value',
    'total_stock_sales_value' => 'Total Stock Sales Value',
    'stock_value_purchase' => 'Stock Value (Purchase)',
    'stock_value_sale' => 'Stock Value (Sale)',

    // General UI translations for Advanced Reports module
    'stock_need_only' => 'Stock Need Only',
    'stock_need' => 'Stock Need',
    'expected_stock' => 'Expected Stock',
    'expired_stock' => 'Expired Stock',
    'critical_items' => 'Critical Items',
    'total_current_stock' => 'Total Current Stock',
    'total_stock_needed' => 'Total Stock Needed',
    'total_products' => 'Total Products',
    'coverage_ratio' => 'Coverage Ratio',
    'processing' => 'Processing',
    'table_not_found' => 'Table not found',
    'no_data_available' => 'No data available',
    'no_data_available_print' => 'No data available to print',
    'popup_blocked' => 'Popup blocked by browser. Please allow popups for this site.',
    'generated_on' => 'Generated on',
    'at' => 'at',
    'printed_on' => 'Printed on',
    'generated_by' => 'Generated by',
    'system_generated_report' => 'This is a system generated report',
    'select_date' => 'Select Date',
    'select_location' => 'Select Location',
    'all_locations' => 'All Locations',

    // Expiry report translations
    'expiry_report' => 'Expiry Report',
    'expiry_filters' => 'Expiry Filters',
    'expiry_status' => 'Expiry Status',
    'all' => 'All',
    'expired' => 'Expired',
    'expiring_in_7_days' => 'Expiring in 7 Days',
    'expiring_in_30_days' => 'Expiring in 30 Days',
    'expiring_in_90_days' => 'Expiring in 90 Days',
    'expired_products' => 'Expired Products',
    'total_expiry_value' => 'Total Expiry Value',
    'stock_expiry_report' => 'Stock Expiry Report',
    'days_to_expire' => 'Days to Expire',
    'purchase_price' => 'Purchase Price',
    'stock_value' => 'Stock Value',
    'days_expired' => 'days expired',
    'days_left' => 'days left',
    'critical' => 'Critical',
    'warning' => 'Warning',
    'good' => 'Good',
    'remove_from_stock' => 'Remove from Stock',

    // Enhanced expiry alert translations
    'expiring_soon' => 'Expiring Soon',
    'total_items' => 'Total Items',
    'alert_value' => 'Alert Value',
    'days_ahead' => 'Days Ahead',
    'next_7_days' => 'Next 7 Days',
    'next_15_days' => 'Next 15 Days',
    'next_30_days' => 'Next 30 Days',
    'next_60_days' => 'Next 60 Days',
    'next_90_days' => 'Next 90 Days',
    'refresh' => 'Refresh',
    'days_overdue' => 'days overdue',
    'expires_today' => 'Expires Today',
    'status' => 'Status',
    'expiry_date' => 'Expiry Date',

    'invoice_subtotal' => 'Invoice Subtotal',
    'line_discount' => 'Line Discount',
    'invoice_discount' => 'Invoice Discount',
    'total_discount' => 'Total Discount',


    // Customer Monthly Sales Report
    'customer_monthly_sales_report' => 'Customer Monthly Sales Report',
    'manage_customer_monthly_sales' => 'Manage Customer Monthly Sales',
    'customer_monthly_analysis' => 'Customer Monthly Analysis',
    'monthly_breakdown' => 'Monthly Breakdown',
    'gross_profit_amount' => 'Gross Profit ($)',
    'gross_profit_percentage' => 'Gross Profit (%)',
    'avg_per_customer' => 'Average per Customer',
    'customer_details' => 'Customer Details',
    'customer_information' => 'Customer Information',
    'recent_transactions' => 'Recent Transactions',
    'monthly_sales_analysis' => 'Monthly Sales Analysis',
    'year_summary' => 'Year Summary',
    'search_by_name' => 'Search by name...',
    'staff' => 'Staff',

    'gross_profit' => 'Gross Profit',

    // Months (if not already present)
    'january' => 'January',
    'february' => 'February',
    'march' => 'March',
    'april' => 'April',
    'may' => 'May',
    'june' => 'June',
    'july' => 'July',
    'august' => 'August',
    'september' => 'September',
    'october' => 'October',
    'november' => 'November',
    'december' => 'December',

    // Short months
    'jan' => 'Jan',
    'feb' => 'Feb',
    'mar' => 'Mar',
    'apr' => 'Apr',
    'may' => 'May',
    'jun' => 'Jun',
    'jul' => 'Jul',
    'aug' => 'Aug',
    'sep' => 'Sep',
    'oct' => 'Oct',
    'nov' => 'Nov',
    'dec' => 'Dec',


    'product_performance_report' => 'Product Performance Report',
    'manage_product_performance' => 'Manage Product Performance',
    'product_performance_analysis' => 'Product Performance Analysis',
    'product_details' => 'Product Details',
    'product_information' => 'Product Information',
    'recent_transactions' => 'Recent Transactions',
    'product_performance_analysis' => 'Product Performance Analysis',
    'year_summary' => 'Year Summary',
    'search_by_name' => 'Search by name...',


    // ======================================
    // ADDITIONAL KEYS FOR PRODUCT PERFORMANCE & SALES DETAIL REPORTS
    // Add these to your existing lang file
    // ======================================

    // Date & Time
    'start_date' => 'Start Date',
    'end_date' => 'End Date',
    'week' => 'Week',
    'week_number' => 'Week Number',
    'day_number' => 'Day Number',
    'sales_date' => 'Sales Date',

    // Week Options
    'all_weeks' => 'All Weeks',
    'week_1' => 'Week 1',
    'week_2' => 'Week 2',
    'week_3' => 'Week 3',
    'week_4' => 'Week 4',
    'week_5' => 'Week 5',
    'weekly_totals' => 'WEEKLY TOTALS',

    // Filter Options (Additional)
    'all_groups' => 'All Groups',
    'all_brands' => 'All Brands',
    'all_units' => 'All Units',
    'all_users' => 'All Users',
    'all_staff' => 'All Staff',
    'all_methods' => 'All Methods',

    // Report Sections
    'top_performing_products' => 'Top Performing Products',
    'weekly_sales_summary_report' => 'Weekly Sales Summary Report',
    'staff_performance_analysis' => 'Staff Performance Analysis',
    'stock_valuation' => 'Stock Valuation',
    'product_details' => 'Product Details',

    // Sales Detail Columns
    'sales_unit' => 'Sales Unit',
    'qty_sold' => 'Qty Sold',
    'total_sales_amt' => 'Total Sales Amount',
    'total_purchase_amt' => 'Total Purchase Amount',
    'profit_earned' => 'Profit Earned',
    'margin_percent' => '% Margin',
    'total_purchase' => 'Total Purchase',
    'total_profit' => 'Total Profit',

    // Messages & Status
    'loading_sales_data' => 'Loading sales data...',
    'no_sales_data_found' => 'No sales data found for the selected criteria.',
    'error_loading_sales_data' => 'Error loading sales data. Please try again.',
    'report_refreshed_successfully' => 'Report refreshed successfully',
    'sales_detail_report_loaded' => 'Sales Detail Report loaded successfully',
    'auto_refresh_5_min' => 'Auto-refresh (5 min)',
    'clearing' => 'Clearing...',
    'clear' => 'Clear',
    'search_by_brand_name' => 'Search by brand name...',
    'brand_monthly_sales_report' => 'Brand Monthly Sales Report',
    'view_brand_sales_by_months_with_profit_analysis' => 'View brand sales by months with profit analysis',

    'total_qty' => 'Total Qty',
    'advanced_filters' => 'Advanced Filters',
    'min_amount' => 'Min Amount',
    'max_amount' => 'Max Amount',
    'search_by_name' => 'Search by name...',


    'itemwise_sales_report' => 'Itemwise Sales Report',
    'itemwise_sales_subtitle' => 'Detailed sales analysis by product items',
    'itemwise_sales_filters' => 'Itemwise Sales Report Filters',
    'product_name_sku' => 'Product Name/SKU',
    'customer_name_mobile' => 'Customer Name/Mobile',
    'clear_all_filters' => 'Clear All Filters',
    'refresh' => 'Refresh',
    'quick_date_filters' => 'Quick Date Filters:',
    'today' => 'Today',
    'yesterday' => 'Yesterday',
    'this_week' => 'This Week',
    'last_week' => 'Last Week',
    'this_month' => 'This Month',
    'last_month' => 'Last Month',
    'this_quarter' => 'This Quarter',
    'this_year' => 'This Year',
    'clear_date' => 'Clear Date',
    'total_transactions' => 'Total Transactions',
    'unique_customers' => 'Unique Customers',
    'products_sold' => 'Products Sold',
    'total_qty_sold' => 'Total Qty Sold',
    'total_tax_amount' => 'Total Tax Amount',
    'customers' => 'Customers',
    'products' => 'Products',
    'qty_sold' => 'Qty Sold',
    'total_sales' => 'Total Sales',
    'detailed_view' => 'Detailed View',
    'applied_filters' => 'Applied Filters',
    'date_range_label' => 'Date Range:',
    'location_label' => 'Location:',
    'customer_label' => 'Customer:',
    'category_label' => 'Category:',
    'brand_label' => 'Brand:',
    'report_summary' => 'Report Summary',
    'invoice_no' => 'Invoice No',
    'date' => 'Date',
    'customer' => 'Customer',
    'product' => 'Product',
    'category' => 'Category',
    'brand' => 'Brand',
    'qty' => 'Qty',
    'unit_price' => 'Unit Price',
    'tax_percent' => 'Tax %',
    'tax_amount' => 'Tax Amount',
    'subtotal' => 'Subtotal',
    'total' => 'Total',
    'totals' => 'TOTALS:',
    'report_details' => 'Report Details:',
    'generated_on' => 'Generated on:',
    'total_records' => 'Total Records:',
    'report_period' => 'Report Period:',
    'business_information' => 'Business Information:',
    'tax_number' => 'Tax Number:',
    'printed_by' => 'Printed by:',
    'print_report' => 'Print Report',
    'close' => 'Close',
    'all_dates' => 'All Dates',
    'purchase_cost' => 'Purchase Cost',

    'weekly_sales_summary_report' => 'WEEKLY SALES SUMMARY REPORT',
    'weekly_monthly_yearly_customer_awards' => 'Weekly / Monthly / Yearly Customer Awards & Recognition',
    'customer_recognition_system' => 'Customer Recognition System',
    'recognition_filters_controls' => 'Recognition Filters & Controls',
    'period_type' => 'Period Type',
    'winner_count' => 'Winner Count',
    'refresh_data' => 'Refresh Data',
    'finalize_period' => 'Finalize Period',
    'record_engagement' => 'Record Engagement',
    'current_period_winners' => 'Current Period Winners',
    'weekly_winner' => 'Weekly Winner',
    'monthly_winner' => 'Monthly Winner',
    'yearly_winner' => 'Yearly Winner',
    'total_participants' => 'Total Participants',
    'engagement_points' => 'Engagement Points',
    'average_score' => 'Average Score',
    'top_score' => 'Top Score',
    'avg_transaction' => 'Avg Transaction',
    'customer_rankings' => 'Customer Rankings & Recognition',
    'rank' => 'Rank',
    'sales_total' => 'Sales Total',
    'transactions' => 'Transactions',
    'engagement_points' => 'Engagement Pts',
    'final_score' =>  'Final Score',
    'customer_recognition_details' => 'Customer Recognition Details',
    'loading_customer_details' => 'Loading customer details...',
    'award_customer' => 'Award Customer',
    'award_type' => 'Award Type',
    'select_award_type' => 'Select Award Type',
    'manual_entry' => 'Manual Entry',
    'from_catalog' => 'From Catalog',
    'gift_description' => 'Gift Description',
    'select_gift_from_catalog' => 'Select Gift from Catalog',
    'loading_catalog' => 'Loading catalog...',
    'additional_notes_about_award' => 'Additional notes about this award...',
    'record_customer_engagement' => 'Record Customer Engagement',
    'engagement_type' => 'Engagement Type',
    'select_type' => 'Select Type',
    'youtube_follow' => 'YouTube Follow/Subscribe',
    'facebook_follow' => 'Facebook Follow/Like',
    'instagram_follow' => 'Instagram Follow',
    'twitter_follow' => 'Twitter Follow',
    'content_share' => 'Content Share',
    'review_testimonial' => 'Review/Testimonial',
    'google_review' => 'Google Review',
    'customer_referral' => 'Customer Referral',
    'points' => 'Points',
    'platform' => 'Platform',
    'reference_url' => 'Reference URL',
    'verification_notes' => 'Verification Notes',
    'describe_verification_notes' => 'Describe how this engagement was verified...',
    'finalize_period_rankings' => 'Finalize Period Rankings',
    'warning' => 'Warning',
    'message_warning_finalized1' => 'Once finalized, the rankings for this period cannot be changed.',
    'message_warning_finalized2' => 'This will lock in the current winners and allow you to award them.',
    'period' => 'Period',
    'winners_count' => 'Winners Count',
    'quantity' => 'Quantity',
    'customer_engagements' => 'Customer Engagements',
    'recorded_by' => 'Recorded By',
    'recorded_date' => 'Recorded Date',
    'no_customer_engagements_found' => 'No customer engagements found',

    // Service Staff Recognition
    'service_staff_recognition_system' => 'Service Staff Recognition System',
    'weekly_monthly_yearly_staff_awards' => 'Weekly / Monthly / Yearly Staff Awards & Recognition',
    'staff_rankings' => 'Staff Rankings & Recognition',
    'staff_name' => 'Staff Name',
    'performance_points' => 'Performance Points',
    'performance_activities' => 'Perf. Activities',
    'activity_type' => 'Activity Type',
    'description' => 'Description',
    'total_staff' => 'Total Staff',
    'top_performer' => 'Top Performer',
    'average_performance' => 'Average Performance',
    'total_activities' => 'Total Activities',
    'award_staff' => 'Award Staff',
    'record_performance_activity' => 'Record Performance Activity',
    'record_activity' => 'Record Activity',
    'staff_member' => 'Staff Member',
    'punctuality' => 'Punctuality',
    'customer_service_excellence' => 'Customer Service Excellence',
    'upselling_success' => 'Upselling Success',
    'teamwork' => 'Teamwork',
    'training_completion' => 'Training Completion',
    'cleanliness_organization' => 'Cleanliness & Organization',
    'other' => 'Other',
    'no_performance_activities_found' => 'No performance activities found',

    'weekly' => 'Weekly',
    'monthly' => 'Monthly',
    'yearly' => 'Yearly',

    'weekly_top_performer' => 'Weekly Top Performer',
    'monthly_top_performer' => 'Monthly Top Performer',
    'yearly_top_performer' => 'Yearly Top Performer',

    'current_period_top_performers' => 'Current Period Top Performers',
    'current_period_top_performer' => 'Current Period Top Performer',
    'top_performer_score' => 'Top Performer Score',
    'end_date' => 'End Date',
    'demand_forecasting' => 'Demand Forecasting',
    'demand_forecasting_report' => 'Demand Forecasting Report',
    'historical_period' => 'Historical Period',
    'forecast_period' => 'Forecast Period',
    '3_months' => '3 Months',
    '6_months' => '6 Months',
    '12_months' => '12 Months',
    'sales_prediction_subtitle' => 'Sales Prediction, Seasonal Patterns & Stock-out Prevention',
    'forecasted_demand' => 'Forecasted Demand',
    'historical_demand' => 'Historical Demand',
    'forecasted_period' => 'Forecasted Period',
    'generate_forecast' => 'Generate Forecast',
    'products_analyzed' => 'Products Analyzed',
    'stockout_alerts' => 'Stock-out Alerts',
    'reorder_required' => 'Reorder Required',
    'filters' => 'Filters',
    'select_date_range' => 'Select Date Range',
    'all_alerts' => 'All Alerts',
    'critical' => 'Critical',
    'high' => 'High',
    'medium' => 'Medium',
    'low' => 'Low',
    'product' => 'Product',
    'current_stock' => 'Current Stock',
    'daily_demand' => 'Daily Demand',
    'days_of_supply' => 'Days of Supply',
    'alert_level' => 'Alert Level',
    'estimated_stockout' => 'Estimated Stock-out',
    'recommended_action' => 'Recommended Action',
    'select_product' => 'Select Product',
    'historical' => 'Historical',
    'forecast' => 'Forecast',
    'combined' => 'Combined',
    'all_products' => 'All Products',
    'reorder_now' => 'Reorder Now',
    'monitor_closely' => 'Monitor Closely',
    'overstocked' => 'Overstocked',
    'optimal' => 'Optimal',
    'products' => 'Products',
    'reorder_point' => 'Reorder Point',
    'eoq' => 'EOQ',
    'recommendation' => 'Recommendation',
    'priority' => 'Priority',
    'confidence' => 'Confidence',
    'trend' => 'Trend',
    'volatility' => 'Volatility',

    // Section titles
    'critical_stockout_alerts' => 'Critical Stock-out Alerts',
    'demand_forecast_visualization' => 'Demand Forecast Visualization',
    'seasonal_patterns' => 'Seasonal Patterns',
    'forecasting_methods_comparison' => 'Forecasting Methods Comparison',
    'demand_confidence_levels' => 'Demand Confidence Levels',
    'reorder_point_optimization' => 'Reorder Point Optimization',
    'highest_forecasted_demand' => 'Highest Forecasted Demand',
    'most_volatile_demand' => 'Most Volatile Demand',

    // Table headers
    'estimated_stockout' => 'Estimated Stock-out',
    'forecasting_methods' => 'Forecasting Methods',
    'historical_demand' => 'Historical Demand',
    'forecasted_demand' => 'Forecasted Demand',

    // Messages and labels
    'no_critical_alerts_found' => 'No critical alerts found',
    'next_months' => 'Next',
    'months' => 'months',
    'select_product_option' => 'Select Product',
    'last_year' => 'Last Year',
    'this_year' => 'This Year',
    'forecasting_methods_labels' => 'Simple MA, Linear Trend, Exponential, Seasonal, Combined',
    'forecasting_methods_comparison_title' => 'Forecasting Methods Comparison',
    'forecast_confidence_distribution_title' => 'Forecast Confidence Distribution',
    'print' => 'Print',
    'export_image' => 'Export as Image',

    // Waste & Loss Analysis
    'waste_loss_analysis_report' => 'Waste & Loss Analysis Report',
    'waste_loss_subtitle' => 'Expired Products, Damaged Goods, Theft & Loss Prevention',
    'analysis_period' => 'Analysis Period',
    'analyze_waste_loss' => 'Analyze Waste & Loss',
    'expired_products' => 'Expired Products',
    'damaged_goods' => 'Damaged Goods',
    'theft_shrinkage' => 'Theft & Shrinkage',
    'total_loss' => 'Total Loss',
    'loss_trends' => 'Loss Trends',
    'loss_breakdown' => 'Loss Breakdown',
    'expired_products_analysis' => 'Expired Products Analysis',
    'damaged_goods_analysis' => 'Damaged Goods Analysis',
    'theft_shrinkage_analysis' => 'Theft & Shrinkage Analysis',
    'loss_prevention_insights' => 'Loss Prevention Insights',
    'expiry_categories' => 'Expiry Categories',
    'upcoming_expirations' => 'Upcoming Expirations',
    'expired_today' => 'Expired Today',
    'expired_this_week' => 'Expired This Week',
    'expired_this_month' => 'Expired This Month',
    'all_expired' => 'All Expired',
    'expiry_date' => 'Expiry Date',
    'days_expired' => 'Days Expired',
    'days_remaining' => 'Days Remaining',
    'loss_value' => 'Loss Value',
    'damage_date' => 'Damage Date',
    'reason' => 'Reason',
    'damage_summary' => 'Damage Summary',
    'physical_damage' => 'Physical Damage',
    'spoilage' => 'Spoilage',
    'shrinkage_rate' => 'Shrinkage Rate',
    'high_risk_products' => 'High Risk Products',
    'incidents' => 'Incidents',
    'quantity_lost' => 'Quantity Lost',
    'value_lost' => 'Value Lost',
    'top_loss_categories' => 'Top Loss Categories',
    'loss_by_location' => 'Loss by Location',
    'recommendations' => 'Recommendations',
    'total_loss_value' => 'Total Loss Value',
    'incident_count' => 'Incident Count',
    'supplier' => 'Supplier',
    'last_month' => 'Last Month',
    'last_3_months' => 'Last 3 Months',
    'last_6_months' => 'Last 6 Months',
    'pie_chart' => 'Pie Chart',
    'bar_chart' => 'Bar Chart',
    'no_expired_products' => 'No expired products found',
    'no_upcoming_expirations' => 'No upcoming expirations',
    'no_damaged_goods' => 'No damaged goods found',
    'no_high_risk_products' => 'No high risk products identified',
    'no_recommendations' => 'No recommendations available',
    'no_chart_available' => 'No chart available to export',

    'value' => 'Value',

    // Location Performance Report
    'location_performance_report' => 'Store/Location Performance Report',
    'manage_location_performance' => 'Manage Store/Location Performance',
    'location_performance_analytics' => 'Location Performance Analytics',
    'multi_location_analysis' => 'Multi-Location Analysis',
    'location_sales_comparison' => 'Location Sales Comparison',
    'performance_benchmarks' => 'Performance Benchmarks',
    'regional_sales_analysis' => 'Regional Sales Analysis',
    'location_profitability' => 'Location Profitability',
    'location_comparison' => 'Location Comparison',
    'benchmarking_analysis' => 'Benchmarking Analysis',
    'profitability_analysis' => 'Profitability Analysis',
    'performance_trends' => 'Performance Trends',
    'staff_performance' => 'Staff Performance',
    'performance_score' => 'Performance Score',
    'revenue_per_location' => 'Revenue per Location',
    'transactions_per_location' => 'Transactions per Location',
    'profit_per_location' => 'Profit per Location',
    'top_performing_locations' => 'Top Performing Locations',
    'underperforming_locations' => 'Underperforming Locations',
    'location_efficiency' => 'Location Efficiency',
    'regional_market_share' => 'Regional Market Share',
    'location_roi' => 'Location ROI',
    'operating_expenses' => 'Operating Expenses',
    'net_profit_margin' => 'Net Profit Margin',
    'compare_periods' => 'Compare Periods',
    'performance_indicators' => 'Performance Indicators',
    'location_overview' => 'Location Overview',
    'compare_period' => 'Compare Period',
    'benchmark_metrics' => 'Benchmark Metrics',
    'revenue_growth' => 'Revenue Growth',
    'profit_growth' => 'Profit Growth',
    'efficiency_score' => 'Efficiency Score',
    'top_performers' => 'Top Performers',
    'bottom_performers' => 'Bottom Performers',
    'location_ranking' => 'Location Ranking',
    'performance_rating' => 'Performance Rating',
    'excellent' => 'Excellent',
    'good' => 'Good',
    'average' => 'Average',
    'poor' => 'Poor',
    'staff_productivity' => 'Staff Productivity',
    'sales_per_staff' => 'Sales per Staff',
    'avg_transaction_per_staff' => 'Avg Transaction per Staff',
    'staff_efficiency' => 'Staff Efficiency',
    'location_insights' => 'Location Insights',
    'performance_summary' => 'Performance Summary',
    'kpi_dashboard' => 'KPI Dashboard',
    'operational_metrics' => 'Operational Metrics',

    'locations' => 'Locations',
    'compare_with' => 'Compare With',
    'compare' => 'Compare',

    // Additional Location Performance translations
    'location_overview' => 'Location Overview',
    'sales_growth' => 'Sales Growth',
    'transaction_growth' => 'Transaction Growth',
    'customer_growth' => 'Customer Growth',
    'avg_transaction_growth' => 'Avg Transaction Growth',
    'profit_margin_change' => 'Profit Margin Change',
    'current_period' => 'Current Period',
    'benchmark_period' => 'Benchmark Period',
    'previous_period' => 'Previous Period',
    'same_period_last_year' => 'Same Period Last Year',
    'regional_summary' => 'Regional Summary',
    'top_regions' => 'Top Regions',
    'market_share' => 'Market Share',
    'regional_trends' => 'Regional Trends',
    'location_count' => 'Location Count',
    'regional_sales' => 'Regional Sales',
    'regional_transactions' => 'Regional Transactions',
    'regional_customers' => 'Regional Customers',
    'avg_per_location' => 'Average per Location',
    'region' => 'Region',
    'profitability_ranking' => 'Profitability Ranking',
    'average_metrics' => 'Average Metrics',
    'avg_gross_profit_margin' => 'Avg Gross Profit Margin',
    'avg_net_profit_margin' => 'Avg Net Profit Margin',
    'avg_roi' => 'Average ROI',
    'cogs' => 'COGS',
    'expenses' => 'Expenses',
    'revenue' => 'Revenue',
    'customers_served' => 'Customers Served',
    'avg_sale_value' => 'Avg Sale Value',
    'staff_member' => 'Staff Member',
    'staff_id' => 'Staff ID',
    'staff_name' => 'Staff Name',
    'total_amount' => 'Total Amount',
    'period' => 'Period',
    'trends' => 'Trends',
    'comparison_type' => 'Comparison Type',
    'period_info' => 'Period Info',
    'benchmarks' => 'Benchmarks',
    'performance_score' => 'Performance Score',
    'location_profitability_analysis' => 'Location Profitability Analysis',
    'staff_performance_by_location' => 'Staff Performance by Location',
    'performance_trends_analysis' => 'Performance Trends Analysis',
    'regional_market_analysis' => 'Regional Market Analysis',
    'benchmark_analysis' => 'Benchmark Analysis',
    'select_locations' => 'Select Locations',
    'all_locations' => 'All Locations',
    'date_range_required' => 'Date range is required',
    'loading_analytics' => 'Loading analytics...',
    'analytics_loaded' => 'Analytics loaded successfully',
    'error_loading_analytics' => 'Error loading analytics',
    'no_data_available_for_period' => 'No data available for the selected period',
    'performance_data' => 'Performance Data',
    'comparison_data' => 'Comparison Data',
    'benchmark_data' => 'Benchmark Data',
    'trend_data' => 'Trend Data',
    'profitability_data' => 'Profitability Data',
    'staff_data' => 'Staff Data',
    'regional_data' => 'Regional Data',

    'toggle_view' => 'Toggle View',
    'benchmark_scores' => 'Benchmark Scores',
    'sales' => 'Sales',
    'share' => 'Share',
    'city' => 'City',
    'amount' => 'Amount',
    'detailed_location_performance' => 'Detailed Location Performance',
    'total_locations' => 'Total Locations',
    'total_sales' => 'Total Sales',
    'total_customers' => 'Total Customers',
    'avg_profit_margin' => 'Avg Profit Margin',

    // Hardcoded text translations for Location Performance Report
    'active_locations' => 'active locations',
    'growth' => 'growth',
    'average_performance' => 'Average performance',
    'margin' => 'margin',
    'chart_view_toggled_to' => 'Chart view toggled to',
    'chart' => 'chart',
    'staff_view_switched_to_card_layout' => 'Staff view switched to card layout',
    'staff_view_switched_to_table_layout' => 'Staff view switched to table layout',
    'staff_performance_container_not_found' => 'Staff performance container not found',
    'regional_sales_analysis_report' => 'Regional Sales Analysis Report',
    'generated_on' => 'Generated on',
    'at' => 'at',
    'regional_analysis_data_not_available_for_printing' => 'Regional analysis data not available for printing',
    'location_performance_data_exported_successfully' => 'Location performance data exported successfully',
    'error_exporting_location_data' => 'Error exporting location data',
    'csv_header' => 'Location ID,Location Name,City,State,Total Sales,Transactions,Avg Transaction,Customers,Gross Profit,Profit Margin',
    'line' => 'line',
    'bar' => 'bar',
    'card' => 'card',
    'table' => 'table',

    // Staff Productivity Report
    'staff_productivity_report' => 'Staff Productivity Report',
    'sales_performance_and_efficiency' => 'Sales Performance and Efficiency Analysis',
    'staff_members' => 'Staff Members',
    'all_staff' => 'All Staff',
    'total_staff' => 'Total Staff',
    'active_staff' => 'active staff',
    'total_commissions' => 'Total Commissions',
    'avg_per_staff' => 'avg per staff',
    'avg_commission' => 'avg commission',
    'avg_efficiency' => 'Avg Efficiency',
    'efficiency_tracking' => 'Efficiency Tracking',
    'staff_sales_performance' => 'Staff Sales Performance',
    'working_hours_efficiency' => 'Working Hours Efficiency',
    'productivity_trends' => 'Productivity Trends',
    'commission_tracking' => 'Commission Tracking',
    'improvement_suggestions' => 'Performance Improvement Suggestions',
    'detailed_staff_performance' => 'Detailed Staff Performance',
    'staff_comparison_analysis' => 'Staff Comparison Analysis',
    'efficiency_score' => 'Efficiency Score',
    'commission' => 'Commission',
    'commission_amount' => 'Commission Amount',
    'performance_rating' => 'Performance Rating',
    'current' => 'Current',
    'target' => 'Target',
    'no_suggestions_available' => 'No improvement suggestions available',
    'staff_csv_header' => 'Staff Name,Location,Sales,Transactions,Efficiency Score,Commission,Performance Rating',
    'staff_data_exported_successfully' => 'Staff productivity data exported successfully',
    'error_exporting_staff_data' => 'Error exporting staff productivity data',
    'radar' => 'radar',
    'comparison_view_switched_to_card_layout' => 'Comparison view switched to card layout',
    'comparison_view_switched_to_table_layout' => 'Comparison view switched to table layout',
    'comparison_container_not_found' => 'Comparison container not found',

    // Product Category Performance translations
    'product_category_performance' => 'Product Category Performance',
    'category_contribution_and_growth' => 'Category Contribution Analysis & Growth Trends',
    'category_contribution' => 'Category Contribution',
    'cross_selling_opportunities' => 'Cross-Selling Opportunities',
    'margin_analysis' => 'Margin Analysis',
    'growth_trends' => 'Growth Trends',
    'seasonal_patterns' => 'Seasonal Patterns',
    'inventory_turnover' => 'Inventory Turnover',
    'detailed_category_performance' => 'Detailed Category Performance',
    'top_performers' => 'Top Performers',
    'category' => 'Category',
    'revenue' => 'Revenue',
    'profit' => 'Profit',
    'margin' => 'Margin',
    'contribution' => 'Contribution',
    'customers' => 'Customers',
    'avg_price' => 'Avg Price',
    'units_sold' => 'Units Sold',
    'total_categories' => 'Total Categories',
    'total_profit' => 'Total Profit',
    'gross_profit' => 'Gross Profit',
    'profit_margin' => 'Profit Margin',
    'sales_contribution' => 'Sales Contribution',
    'profit_contribution' => 'Profit Contribution',
    'turnover_ratio' => 'Turnover Ratio',
    'days_to_sell' => 'Days to Sell',
    'stock_velocity' => 'Stock Velocity',
    'co_occurrences' => 'Co-occurrences',
    'confidence' => 'Confidence',
    'avg_value' => 'Avg Value',
    'sales_pattern' => 'Sales Pattern',
    'view_toggled' => 'View toggled successfully',
    'avg_transaction_value' => 'Average Transaction Value',
    'unique_products' => 'Unique Products',
    'units' => 'Units',
    'transactions' => 'Transactions',

    // Additional translations for Product Category Report
    'error_loading_analytics_data' => 'Error loading analytics data. Please try again.',
    'margin_percentage' => 'Margin %',
    'growth_rate_percentage' => 'Growth Rate %',
    'confidence_label' => 'Confidence:',
    'transactions_label' => 'Transactions:',
    'analytics_data_received' => 'Analytics data received:',
    'loading_data' => 'Loading data...',
    'filter_controls' => 'Filter Controls',
    'business_location' => 'Business Location',
    'brands' => 'Brands',
    'export_data' => 'Export Data',
    'average_margin' => 'Average Margin',
    'last_7_days' => 'Last 7 Days',
    'last_30_days' => 'Last 30 Days',
    'top_performing_categories' => 'Top Performing Categories',

    'categories' => 'Categories',
    'total_revenue' => 'Total Revenue',

    // Seasonal Trends Report
    'seasonal_trends_report' => 'Seasonal Trends Report',
    'seasonal_trends_description' => 'Analyze seasonal patterns, holiday performance, and promotional effectiveness',

    // Audit Trail Report
    'audit_trail_report' => 'Audit Trail Report',
    'audit_trail_description' => 'Comprehensive compliance and risk management tracking',
    'audit_activities' => 'Audit Activities',
    'transaction_modifications' => 'Transaction Modifications',
    'high_risk_activities' => 'High Risk Activities',
    'active_users' => 'Active Users',
    'activities_by_type' => 'Activities by Type',
    'risk_level_distribution' => 'Risk Level Distribution',
    'daily_activity_trend' => 'Daily Activity Trend',
    'top_active_users' => 'Top Active Users',
    'audit_trail_filters' => 'Audit Trail Filters',
    'detailed_audit_trail' => 'Detailed Audit Trail',
    'risk_level' => 'Risk Level',
    'compliance_status' => 'Compliance Status',
    'transaction_details' => 'Transaction Details',
    'user_info' => 'User Info',
    'high_risk' => 'High Risk',
    'medium_risk' => 'Medium Risk',
    'low_risk' => 'Low Risk',
    'compliant' => 'Compliant',
    'requires_review' => 'Requires Review',
    'non_compliant' => 'Non Compliant',
    'compliance_risk_management' => 'Compliance & Risk Management',

    // Tax Compliance Report
    'tax_compliance_report' => 'Tax Compliance Report',
    'tax_compliance_description' => 'Multi-tax jurisdiction support and optimization insights',

    // Multi-Channel Sales Report
    'multi_channel_sales_report' => 'Multi-Channel Sales Report',
    'multi_channel_description' => 'Online vs offline performance analytics and optimization',
    'online_revenue' => 'Online Revenue',
    'offline_revenue' => 'Offline Revenue',
    'cross_channel_customers' => 'Cross-Channel Customers',
    'channel_efficiency' => 'Channel Efficiency',
    'channel_profitability' => 'Channel Profitability',
    'customer_channel_preferences' => 'Customer Channel Preferences',
    'peak_hours_by_channel' => 'Peak Hours by Channel',
    'channel_optimization_insights' => 'Channel Optimization Insights',
    'total_tax_collected' => 'Total Tax Collected',
    'net_tax_liability' => 'Net Tax Liability',
    'compliance_score' => 'Compliance Score',
    'potential_savings' => 'Potential Savings',
    'monthly_tax_liability_trend' => 'Monthly Tax Liability Trend',
    'tax_by_jurisdiction' => 'Tax by Jurisdiction',
    'tax_audit_risk_assessment' => 'Tax Audit Risk Assessment',
    'risk_level' => 'Risk Level',
    'risk_score' => 'Risk Score',
    'tax_optimization_insights' => 'Tax Optimization Insights',
    'upcoming_filing_deadlines' => 'Upcoming Filing Deadlines',
    'filing_deadline' => 'Filing Deadline',
    'days_remaining' => 'Days Remaining',
    'generate_report' => 'Generate Report',
    'tax_liability_details' => 'Tax Liability Details',
    'tax_name' => 'Tax Name',
    'tax_rate' => 'Tax Rate (%)',
    'output_tax' => 'Output Tax',
    'input_tax_credit' => 'Input Tax Credit',
    'net_liability' => 'Net Liability',
    'sales_trans' => 'Sales Transactions',
    'purchase_trans' => 'Purchase Transactions',
    'jurisdiction' => 'Jurisdiction',
    'filing_period' => 'Filing Period',
    'report_type' => 'Report Type',
    'export_report' => 'Export Report',
    'refresh' => 'Refresh',
    'export_excel' => 'Export Excel',
    'tax_liability' => 'Tax Liability',
    'filing_assistance' => 'Filing Assistance',
    'optimization' => 'Optimization',
    'monthly' => 'Monthly',
    'quarterly' => 'Quarterly',
    'semi_annual' => 'Semi-Annual',
    'annual' => 'Annual',
    'compliant' => 'Compliant',
    'pending' => 'Pending Review',
    'overdue' => 'Overdue',
    'exempted' => 'Exempted',
    'urgent' => 'Urgent',
    'upcoming' => 'Upcoming',
    'federal' => 'Federal',
    'state_local' => 'State/Local',
    'other' => 'Other',
    'period' => 'Period',
    'gross_sales' => 'Gross Sales',
    'taxable_sales' => 'Taxable Sales',
    'tax_collected' => 'Tax Collected',
    'tax_paid_on_purchases' => 'Tax Paid on Purchases',
    'filing_status' => 'Filing Status',
    'tax_rate_efficiency_analysis' => 'Tax Rate Efficiency Analysis',
    'seasonal_tax_optimization' => 'Seasonal Tax Optimization',
    'input_tax_credit_opportunities' => 'Input Tax Credit Opportunities',
    'multi_tax_jurisdiction_support' => 'Multi-Tax Jurisdiction Support & Optimization',
    'monthly_trends' => 'Monthly Trends',
    'yearly_trends' => 'Yearly Trends',
    'seasonal_patterns' => 'Seasonal Patterns',
    'holiday_season_performance' => 'Holiday Season Performance',
    'promotional_effectiveness' => 'Promotional Effectiveness',
    'weather_impact_analysis' => 'Weather Impact Analysis',
    'peak_performance_analysis' => 'Peak Performance Analysis',
    'current_year_performance' => 'Current Year Performance',
    'year_over_year_growth' => 'Year-over-Year Growth',
    'best_performing_season' => 'Best Performing Season',
    'best_performing_month' => 'Best Performing Month',
    'best_performing_months' => 'Best Performing Months',
    'day_of_week_performance' => 'Day of Week Performance',
    'analysis_period' => 'Analysis Period',
    'last_1_year' => 'Last 1 Year',
    'last_2_years' => 'Last 2 Years',
    'last_3_years' => 'Last 3 Years',
    'last_5_years' => 'Last 5 Years',
    'revenue' => 'Revenue',
    'gross_revenue' => 'Gross Revenue',
    'quantity_sold' => 'Quantity Sold',
    'promotion_type' => 'Promotion Type',
    'avg_discount' => 'Average Discount',
    'discount_percentage' => 'Discount Percentage',
    'weather_analysis_coming_soon' => 'Weather Analysis Coming Soon',
    'weather_analysis_description' => 'Integrate with weather APIs to analyze the impact of weather conditions on sales performance',
    'holiday_performance' => 'Holiday Performance',
    'daily_average' => 'Daily Average',
    'duration_days' => 'Duration (Days)',
    'growth_direction' => 'Growth Direction',
    'select_locations' => 'Select Locations',

    // Supplier Performance Report
    'supplier_performance_report' => 'Supplier Performance Report',
    'supplier_performance_description' => 'Delivery performance, quality assessment, payment compliance & risk analysis',
    'delivery_performance' => 'Delivery Performance',
    'quality_assessment' => 'Quality Assessment',
    'payment_compliance' => 'Payment Compliance',
    'supplier_risk_analysis' => 'Supplier Risk Analysis',
    'on_time_delivery' => 'On-Time Delivery',
    'average_delivery_days' => 'Average Delivery Days',
    'supplier_reliability' => 'Supplier Reliability',
    'quality_rating' => 'Quality Rating',
    'defect_rate' => 'Defect Rate',
    'payment_terms_compliance' => 'Payment Terms Compliance',
    'risk_score' => 'Risk Score',
    'performance_score' => 'Performance Score',
    'supplier_rankings' => 'Supplier Rankings',
    'top_performers' => 'Top Performers',
    'underperformers' => 'Underperformers',
    'delivery_insights' => 'Delivery Insights',
    'quality_insights' => 'Quality Insights',
    'payment_insights' => 'Payment Insights',
    'risk_insights' => 'Risk Insights',
    'total_suppliers' => 'Total Suppliers',
    'total_spend' => 'Total Spend',
    'avg_delivery_time' => 'Average Delivery Time',
    'overall_compliance' => 'Overall Compliance',
    'delivery_reliability' => 'Delivery Reliability',
    'supplier_name' => 'Supplier Name',
    'orders_count' => 'Orders Count',
    'avg_delivery_days' => 'Avg Delivery Days',
    'quality_score' => 'Quality Score',
    'payment_score' => 'Payment Score',
    'overall_score' => 'Overall Score',
    'supplier_details' => 'Supplier Details',
    'performance_metrics' => 'Performance Metrics',

    // Warranty & Service Report
    'warranty_service_report' => 'Warranty & Service Report',
    'warranty_service_description' => 'Product warranty tracking, service request analysis & customer support metrics',
    'warranty_tracking' => 'Warranty Tracking',
    'service_requests_analysis' => 'Service Requests Analysis',
    'customer_support_metrics' => 'Customer Support Metrics',
    'post_sale_service_performance' => 'Post-Sale Service Performance',
    'warranty_claims_analysis' => 'Warranty Claims Analysis',
    'product_warranty_tracking' => 'Product Warranty Tracking',
    'service_request_analysis' => 'Service Request Analysis',
    'warranty_status_distribution' => 'Warranty Status Distribution',
    'service_request_trends' => 'Service Request Trends',
    'total_products_sold' => 'Total Products Sold',
    'warranty_coverage' => 'Warranty Coverage',
    'service_requests' => 'Service Requests',
    'resolution_rate' => 'Resolution Rate',
    'warranty_status' => 'Warranty Status',
    'warranty_end_date' => 'Warranty End Date',
    'days_remaining' => 'Days Remaining',
    'product_value' => 'Product Value',
    'request_id' => 'Request ID',
    'resolution_days' => 'Resolution Days',
    'warranties_expiring_soon' => 'Warranties Expiring Soon',
    'service_recommendations' => 'Service Recommendations',
    'performance_insights' => 'Performance Insights',
    'key_insights' => 'Key Insights',
    'comprehensive_report' => 'Comprehensive Report',
    'warranty_claims' => 'Warranty Claims',
    'avg_response_time' => 'Average Response Time',
    'avg_resolution_time' => 'Average Resolution Time',
    'customer_satisfaction' => 'Customer Satisfaction',
    'first_response_sla' => 'First Response SLA',
    'resolution_sla' => 'Resolution SLA',
    'warranty_claim_rate' => 'Warranty Claim Rate',
    'service_cost_ratio' => 'Service Cost Ratio',
    'staff_performance' => 'Staff Performance',
    'response_time_metrics' => 'Response Time Metrics',
    'warranty_expiring_alert' => 'Warranties expiring in next 30 days',
    'high_priority_requests' => 'High Priority Requests',
    'pending_resolutions' => 'Pending Resolutions',
    'warranty_type' => 'Warranty Type',
    'claim_amount' => 'Claim Amount',
    'claim_reason' => 'Claim Reason',
    'service_type' => 'Service Type',
    'assigned_staff' => 'Assigned Staff',
    'request_priority' => 'Request Priority',
    'service_cost' => 'Service Cost',
    'resolution_time' => 'Resolution Time',
    'customer_feedback' => 'Customer Feedback',
    'satisfaction_rating' => 'Satisfaction Rating',
    'service_quality' => 'Service Quality',
    'warranty_utilization' => 'Warranty Utilization',
    'post_sale_performance' => 'Post-Sale Performance',

    // Customer Group Report
    'customer_group_report' => 'Customer Group Report',
    'customer_group_analytics' => 'Customer Group Analytics',
    'customer_group_description' => 'Analyze performance by customer groups with salesperson drill-down',
    'group_leaderboard' => 'Group Leaderboard',
    'salesperson_performance' => 'Salesperson Performance',
    'customer_drill_down' => 'Customer Drill-down',
    'invoice_drill_down' => 'Invoice Drill-down',
    'aging_analysis' => 'Aging Analysis',
    'collection_efficiency' => 'Collection Efficiency',
    'net_sales' => 'Net Sales',
    'gross_profit' => 'Gross Profit',
    'margin_percentage' => 'Margin %',
    'customer_count' => 'Customers',
    'invoice_count' => 'Invoices',
    'avg_invoice_value' => 'Avg Invoice',
    'top_performing_group' => 'Top Performing Group',
    'top_salesperson' => 'Top Salesperson',
    'outstanding_due' => 'Outstanding Due',
    'aging_buckets' => 'Aging Buckets',
    'risk_analysis' => 'Risk Analysis',
    'high_risk' => 'High Risk',
    'medium_risk' => 'Medium Risk',
    'low_risk' => 'Low Risk',
    'include_returns' => 'Include Returns',
    'include_drafts' => 'Include Drafts',
    'exclude_returns' => 'Exclude Returns',
    'exclude_drafts' => 'Exclude Drafts',
    'dynamic_grouping' => 'Dynamic Grouping',
    'vip_customers' => 'VIP Customers',
    'regular_customers' => 'Regular Customers',
    'new_customers' => 'New Customers',
    'unassigned_customers' => 'Unassigned',
    'customer_group_performance' => 'Customer Group Performance',
    'drill_down_analysis' => 'Drill-down Analysis',

    // Menu Navigation Translations
    'dashboard' => 'Dashboard',
    'sales_revenue_analysis' => 'Sales & Revenue Analysis',
    'sales_analytics' => 'Sales Analytics',
    'transaction_details' => 'Transaction Details',
    'customer_performance' => 'Customer Performance',
    'product_sales_analysis' => 'Product Sales Analysis',
    'daily_operations' => 'Daily Operations',
    'daily_dashboard' => 'Daily Dashboard',
    'inventory_product_management' => 'Inventory & Product Management',
    'inventory_turnover_report' => 'Inventory Turnover Report',
    'demand_forecasting_report' => 'Demand Forecasting Report',
    'waste_loss_analysis_report' => 'Waste & Loss Analysis Report',
    'location_performance_report' => 'Location Performance Report',
    'staff_productivity_report' => 'Staff Productivity Report',
    'product_category_performance' => 'Product Category Performance',
    'stock_management' => 'Stock Management',
    'product_performance' => 'Product Performance',
    'brand_analytics' => 'Brand Analytics',
    'brand_comparison' => 'Brand Comparison',
    'supplier_performance' => 'Supplier Performance',
    'supplier_analysis' => 'Supplier Analysis',
    'supplier_profitability' => 'Supplier Profitability',
    'financial_compliance' => 'Financial & Compliance',
    'profit_loss_analysis' => 'Profit & Loss Analysis',
    'cash_flow_analysis' => 'Cash Flow Analysis',
    'purchase_analysis' => 'Purchase Analysis',
    'customer_lifetime_value' => 'Customer Lifetime Value',
    'customer_behavior_analytics' => 'Customer Behavior Analytics',
    'customer_segmentation_report' => 'Customer Segmentation Report',
    'gst_sales_compliance' => 'GST Sales Compliance',
    'gst_purchase_compliance' => 'GST Purchase Compliance',
    'monthly_expenses' => 'Monthly Expenses',
    'business_operations_summary' => 'Business Operations Summary',
    'customer_staff_engagement' => 'Customer & Staff Engagement',
    'customer_loyalty_program' => 'Customer Loyalty Program',
    'staff_performance_management' => 'Staff Performance Management',
    'awarded' => 'Awarded',
    'not_awarded' => 'Not Awarded',

    // Product search
    'type_to_search_product' => 'Type to search product',
    'searching' => 'Searching...',
    'no_products_found' => 'No products found',

    // Module notifications
    'module_not_enabled' => 'Module Not Enabled',
    'alert' => 'Alert',
    'module_required' => 'Module Required',
    'enable_module_instruction' => 'Please enable the required module in Business Settings to use this feature.',
    'go_to_settings' => 'Go to Settings',
    'go_to_home' => 'Go to Home',

    // Reward Points Report
    'reward_points_report' => 'Reward Points Tracking & Liability',
    'reward_points_description' => 'Track customer reward points, redemption history, and financial liability analysis',
    'outstanding_liability_points' => 'Outstanding Liability (Points)',
    'liability_amount' => 'Liability Amount (BDT)',
    'active_customers_with_points' => 'Active Customers with Points',
    'redemption_rate' => 'Redemption Rate',
    'total_points_issued' => 'Total Points Issued',
    'total_points_redeemed' => 'Total Points Redeemed',
    'points_redeemed_this_month' => 'Points Redeemed This Month',
    'avg_points_per_customer' => 'Avg Points per Customer',
    'top_point_earners' => 'Top Point Earners',
    'top_point_redeemers' => 'Top Point Redeemers',
    'customer_points_summary' => 'Customer Points Summary',
    'export_table' => 'Export Table',
    'points_earned' => 'Points Earned',
    'points_redeemed' => 'Points Redeemed',
    'current_balance' => 'Current Balance',
    'liability_bdt' => 'Liability (BDT)',
    'total_transactions' => 'Total Transactions',
    'redemption_count' => 'Redemption Count',
    'last_activity' => 'Last Activity',
    'invoice_amount' => 'Invoice Amount',
    'points_value' => 'Points Value',
    'final_payable' => 'Final Payable',
    'customer_summary' => 'Customer Summary',
    'transaction_details' => 'Transaction Details',
    'view_type' => 'View Type',
    'select_customer' => 'Select Customer',
    'type_2_chars_to_search' => 'Type 2 characters to search',
    'loading_reward_points_data' => 'Loading reward points data...',
    'no_reward_points_data' => 'No reward points data available',
    'loading_transaction_details' => 'Loading transaction details...',
    'no_transaction_data' => 'No transaction data available',
    'no_matching_transactions' => 'No matching transactions found',
    'period' => 'Period',
    'generated_on' => 'Generated on',
    'no_result' => 'No result',
    'all_customers' => 'All Customers',
    'apply_filter' => 'Apply Filter',
    'export' => 'Export',
    'refresh' => 'Refresh',
    'searching' => 'Searching',
    'type_to_search' => 'Type to search',
    'reward_points_not_enabled' => 'Reward Points module is not enabled for your business.',
    'enable_reward_points_instruction' => 'Please enable the Reward Points feature in Business Settings to use this report.',

];