<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (Schema::hasTable('mosque_licenses')) {
            return;
        }

        Schema::create('mosque_licenses', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedInteger('business_id')->unique();
            $table->longText('username_encrypted');
            $table->longText('license_encrypted');
            $table->timestamp('activated_at')->nullable();
            $table->unsignedInteger('created_by')->nullable();
            $table->timestamps();

            $table->index(['business_id']);
        });
    }

    public function down(): void
    {
        // Keep non-destructive: do not drop table on rollback.
    }
};

