<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (! Schema::hasTable('mosque_members')) {
            Schema::create('mosque_members', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->unsignedInteger('business_id')->index();
                $table->unsignedInteger('location_id')->nullable()->index();
                $table->string('name');
                $table->string('phone')->nullable()->index();
                $table->string('email')->nullable()->index();
                $table->text('address')->nullable();
                $table->enum('status', ['Active', 'Inactive', 'Deceased', 'Migrated'])->default('Active')->index();
                $table->string('photo_path')->nullable();
                $table->text('notes')->nullable();
                $table->timestamps();
                $table->softDeletes();

                $table->index(['business_id', 'status']);
            });
        }

        if (! Schema::hasTable('mosque_families')) {
            Schema::create('mosque_families', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->unsignedInteger('business_id')->index();
                $table->unsignedBigInteger('head_member_id')->nullable()->index();
                $table->string('family_code')->nullable()->index();
                $table->text('address')->nullable();
                $table->text('notes')->nullable();
                $table->timestamps();
                $table->softDeletes();

                $table->index(['business_id', 'family_code']);
            });
        }

        if (! Schema::hasTable('mosque_family_members')) {
            Schema::create('mosque_family_members', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->unsignedInteger('business_id')->index();
                $table->unsignedBigInteger('family_id')->index();
                $table->unsignedBigInteger('member_id')->index();
                $table->string('relation')->nullable();
                $table->timestamps();

                $table->unique(['business_id', 'family_id', 'member_id'], 'mosque_family_members_unique');
            });
        }
    }

    public function down(): void
    {
        // Non-destructive: do not drop tables.
    }
};

