<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (! Schema::hasTable('mosque_membership_plans')) {
            Schema::create('mosque_membership_plans', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->unsignedInteger('business_id')->index();
                $table->string('name');
                $table->enum('type', ['monthly', 'yearly'])->index();
                $table->decimal('amount', 15, 4)->default(0);
                $table->boolean('active')->default(true)->index();
                $table->timestamps();

                $table->index(['business_id', 'active']);
            });
        }

        if (! Schema::hasTable('mosque_member_fees')) {
            Schema::create('mosque_member_fees', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->unsignedInteger('business_id')->index();
                $table->unsignedBigInteger('member_id')->index();
                $table->unsignedBigInteger('plan_id')->index();
                $table->string('period_ym', 7)->index(); // YYYY-MM
                $table->decimal('due_amount', 15, 4)->default(0);
                $table->decimal('paid_amount', 15, 4)->default(0);
                $table->enum('status', ['pending', 'partial', 'paid'])->default('pending')->index();
                $table->timestamps();

                $table->unique(['business_id', 'member_id', 'plan_id', 'period_ym'], 'mosque_member_fees_unique');
            });
        }

        if (! Schema::hasTable('mosque_member_payments')) {
            Schema::create('mosque_member_payments', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->unsignedInteger('business_id')->index();
                $table->unsignedBigInteger('member_fee_id')->index();
                $table->date('paid_on')->index();
                $table->decimal('amount', 15, 4)->default(0);
                $table->string('method')->nullable();
                $table->string('ref_no')->nullable()->index();
                $table->text('note')->nullable();
                $table->timestamps();
            });
        }
    }

    public function down(): void
    {
        // Non-destructive: do not drop tables.
    }
};

