<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (! Schema::hasTable('mosque_donor_profiles')) {
            Schema::create('mosque_donor_profiles', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->unsignedInteger('business_id')->index();
                $table->string('name');
                $table->string('phone')->nullable()->index();
                $table->string('email')->nullable()->index();
                $table->text('address')->nullable();
                $table->string('tax_id')->nullable()->index();
                $table->text('notes')->nullable();
                $table->timestamps();
                $table->softDeletes();

                $table->index(['business_id', 'name']);
            });
        }

        if (! Schema::hasTable('mosque_donations')) {
            Schema::create('mosque_donations', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->unsignedInteger('business_id')->index();
                $table->unsignedBigInteger('donor_id')->nullable()->index();
                $table->enum('type', ['zakat', 'sadaqah', 'fitrah', 'general', 'event', 'waqf'])->index();
                $table->enum('channel', ['cash', 'bank', 'card', 'online'])->index();
                $table->decimal('amount', 15, 4)->default(0);
                $table->date('date')->index();
                $table->boolean('anonymous')->default(false)->index();
                $table->string('fund_tag')->nullable()->index();
                $table->string('receipt_no')->nullable()->index();
                $table->text('notes')->nullable();
                $table->timestamps();
                $table->softDeletes();

                $table->index(['business_id', 'date']);
            });
        }
    }

    public function down(): void
    {
        // Non-destructive: do not drop tables.
    }
};

