<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (! Schema::hasTable('mosque_finance_categories')) {
            Schema::create('mosque_finance_categories', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->unsignedInteger('business_id')->index();
                $table->enum('type', ['income', 'expense'])->index();
                $table->string('name')->index();
                $table->boolean('active')->default(true)->index();
                $table->integer('sort_order')->default(0);
                $table->timestamps();

                $table->unique(['business_id', 'type', 'name'], 'mosque_finance_categories_unique');
            });
        }

        if (! Schema::hasTable('mosque_finance_entries')) {
            Schema::create('mosque_finance_entries', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->unsignedInteger('business_id')->index();
                $table->unsignedInteger('location_id')->nullable()->index();
                $table->enum('type', ['income', 'expense'])->index();
                $table->unsignedBigInteger('category_id')->index();
                $table->decimal('amount', 15, 4)->default(0);
                $table->date('entry_date')->index();
                $table->string('ref_module')->nullable()->index(); // donation|membership|event|custom
                $table->unsignedBigInteger('ref_id')->nullable()->index();
                $table->string('fund_tag')->nullable()->index(); // e.g. zakat
                $table->text('note')->nullable();
                $table->unsignedInteger('created_by')->nullable()->index();
                $table->timestamps();
                $table->softDeletes();

                $table->index(['business_id', 'entry_date', 'type']);
            });
        }
    }

    public function down(): void
    {
        // Non-destructive: do not drop tables.
    }
};

