<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        // Committee
        if (! Schema::hasTable('mosque_committees')) {
            Schema::create('mosque_committees', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->unsignedInteger('business_id')->index();
                $table->string('name');
                $table->date('term_start')->nullable()->index();
                $table->date('term_end')->nullable()->index();
                $table->text('notes')->nullable();
                $table->timestamps();
                $table->softDeletes();
            });
        }

        if (! Schema::hasTable('mosque_committee_members')) {
            Schema::create('mosque_committee_members', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->unsignedInteger('business_id')->index();
                $table->unsignedBigInteger('committee_id')->index();
                $table->string('member_name')->index();
                $table->string('role_title')->nullable()->index();
                $table->string('photo_path')->nullable();
                $table->string('e_sign_path')->nullable();
                $table->string('phone')->nullable()->index();
                $table->string('email')->nullable()->index();
                $table->timestamps();
                $table->softDeletes();
            });
        }

        if (! Schema::hasTable('mosque_minutes')) {
            Schema::create('mosque_minutes', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->unsignedInteger('business_id')->index();
                $table->unsignedBigInteger('committee_id')->index();
                $table->string('minute_no')->nullable()->index();
                $table->date('date')->index();
                $table->longText('decisions')->nullable();
                $table->json('attachments')->nullable();
                $table->timestamps();
                $table->softDeletes();
            });
        }

        // Staff (HR-lite)
        if (! Schema::hasTable('mosque_staff')) {
            Schema::create('mosque_staff', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->unsignedInteger('business_id')->index();
                $table->string('name')->index();
                $table->string('designation')->nullable()->index();
                $table->string('phone')->nullable()->index();
                $table->string('email')->nullable()->index();
                $table->decimal('salary', 15, 4)->nullable();
                $table->string('status')->nullable()->index();
                $table->timestamps();
                $table->softDeletes();
            });
        }

        if (! Schema::hasTable('mosque_attendance')) {
            Schema::create('mosque_attendance', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->unsignedInteger('business_id')->index();
                $table->unsignedBigInteger('staff_id')->index();
                $table->timestamp('in_at')->index();
                $table->timestamp('out_at')->nullable()->index();
                $table->enum('source', ['manual', 'qr'])->default('manual')->index();
                $table->string('ip')->nullable()->index();
                $table->json('geo')->nullable();
                $table->timestamps();
            });
        }

        if (! Schema::hasTable('mosque_payslips')) {
            Schema::create('mosque_payslips', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->unsignedInteger('business_id')->index();
                $table->unsignedBigInteger('staff_id')->index();
                $table->string('period_ym', 7)->index();
                $table->decimal('gross', 15, 4)->default(0);
                $table->decimal('net', 15, 4)->default(0);
                $table->date('paid_on')->nullable()->index();
                $table->text('note')->nullable();
                $table->timestamps();
                $table->softDeletes();
            });
        }

        // Marriage & Death
        if (! Schema::hasTable('mosque_marriages')) {
            Schema::create('mosque_marriages', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->unsignedInteger('business_id')->index();
                $table->string('bride')->index();
                $table->string('groom')->index();
                $table->string('wali')->nullable();
                $table->json('witnesses')->nullable();
                $table->string('mahr')->nullable();
                $table->date('date')->index();
                $table->string('certificate_no')->nullable()->index();
                $table->text('notes')->nullable();
                $table->timestamps();
                $table->softDeletes();
            });
        }

        if (! Schema::hasTable('mosque_deaths')) {
            Schema::create('mosque_deaths', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->unsignedInteger('business_id')->index();
                $table->unsignedBigInteger('member_id')->nullable()->index();
                $table->string('name')->index();
                $table->date('date')->index();
                $table->string('burial_place')->nullable();
                $table->string('certificate_no')->nullable()->index();
                $table->unsignedBigInteger('family_id')->nullable()->index();
                $table->text('notes')->nullable();
                $table->timestamps();
                $table->softDeletes();
            });
        }

        // Assets / Properties / Events
        if (! Schema::hasTable('mosque_assets')) {
            Schema::create('mosque_assets', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->unsignedInteger('business_id')->index();
                $table->string('name')->index();
                $table->string('tag_no')->nullable()->index();
                $table->date('acquired_on')->nullable()->index();
                $table->decimal('value', 15, 4)->nullable();
                $table->string('status')->nullable()->index();
                $table->text('notes')->nullable();
                $table->timestamps();
                $table->softDeletes();
            });
        }

        if (! Schema::hasTable('mosque_asset_maintenance')) {
            Schema::create('mosque_asset_maintenance', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->unsignedInteger('business_id')->index();
                $table->unsignedBigInteger('asset_id')->index();
                $table->date('date')->index();
                $table->decimal('cost', 15, 4)->default(0);
                $table->text('remark')->nullable();
                $table->timestamps();
                $table->softDeletes();
            });
        }

        if (! Schema::hasTable('mosque_properties')) {
            Schema::create('mosque_properties', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->unsignedInteger('business_id')->index();
                $table->string('name')->index();
                $table->text('address')->nullable();
                $table->boolean('rentable')->default(false)->index();
                $table->text('notes')->nullable();
                $table->timestamps();
                $table->softDeletes();
            });
        }

        if (! Schema::hasTable('mosque_rentals')) {
            Schema::create('mosque_rentals', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->unsignedInteger('business_id')->index();
                $table->unsignedBigInteger('property_id')->index();
                $table->string('tenant_name')->index();
                $table->date('from_date')->index();
                $table->date('to_date')->nullable()->index();
                $table->decimal('rent_amount', 15, 4)->default(0);
                $table->decimal('paid_amount', 15, 4)->default(0);
                $table->string('status')->nullable()->index();
                $table->timestamps();
                $table->softDeletes();
            });
        }

        if (! Schema::hasTable('mosque_events')) {
            Schema::create('mosque_events', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->unsignedInteger('business_id')->index();
                $table->string('name')->index();
                $table->string('type')->nullable()->index();
                $table->date('start_date')->nullable()->index();
                $table->date('end_date')->nullable()->index();
                $table->text('notes')->nullable();
                $table->timestamps();
                $table->softDeletes();
            });
        }

        if (! Schema::hasTable('mosque_event_entries')) {
            Schema::create('mosque_event_entries', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->unsignedInteger('business_id')->index();
                $table->unsignedBigInteger('event_id')->index();
                $table->enum('type', ['income', 'expense'])->index();
                $table->decimal('amount', 15, 4)->default(0);
                $table->date('date')->index();
                $table->text('note')->nullable();
                $table->timestamps();
                $table->softDeletes();
            });
        }

        // Audit log
        if (! Schema::hasTable('mosque_audit_logs')) {
            Schema::create('mosque_audit_logs', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->unsignedInteger('business_id')->index();
                $table->unsignedInteger('actor_id')->nullable()->index();
                $table->string('action')->index();
                $table->string('entity')->index();
                $table->unsignedBigInteger('entity_id')->nullable()->index();
                $table->json('diff')->nullable();
                $table->string('ip')->nullable()->index();
                $table->text('ua')->nullable();
                $table->timestamp('created_at')->useCurrent()->index();
            });
        }
    }

    public function down(): void
    {
        // Non-destructive: do not drop tables.
    }
};

