<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (Schema::hasTable('mosque_qr_tokens')) {
            return;
        }

        Schema::create('mosque_qr_tokens', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedInteger('business_id')->unique();
            $table->string('token', 80)->unique();
            $table->string('primary_color', 20)->nullable();
            $table->string('title')->nullable();
            $table->boolean('location_tracking')->default(true);
            $table->timestamps();

            $table->index(['business_id']);
        });
    }

    public function down(): void
    {
        // Non-destructive: do not drop table.
    }
};

