<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (Schema::hasTable('mosque_profiles')) {
            return;
        }

        Schema::create('mosque_profiles', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedInteger('business_id')->unique();
            $table->string('name')->nullable();
            $table->text('address')->nullable();
            $table->string('reg_no')->nullable()->index();
            $table->string('country')->nullable()->index();
            $table->string('timezone')->nullable()->index();
            $table->string('logo')->nullable();
            $table->text('header_text')->nullable();
            $table->unsignedInteger('created_by')->nullable()->index();
            $table->unsignedInteger('updated_by')->nullable()->index();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        // Non-destructive: do not drop table.
    }
};

