<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (Schema::hasTable('mosque_donation_links')) {
            return;
        }

        Schema::create('mosque_donation_links', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedInteger('business_id')->unique();
            $table->string('token', 80)->unique();
            $table->string('title')->nullable();
            $table->string('primary_color', 20)->nullable();
            $table->boolean('enabled')->default(true)->index();
            $table->unsignedInteger('created_by')->nullable()->index();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        // Non-destructive: do not drop table.
    }
};

