<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (! Schema::hasTable('mosque_staff')) {
            return;
        }

        Schema::table('mosque_staff', function (Blueprint $table) {
            if (! Schema::hasColumn('mosque_staff', 'photo_path')) {
                $table->string('photo_path')->nullable()->after('designation');
            }
            if (! Schema::hasColumn('mosque_staff', 'country_iso2')) {
                $table->string('country_iso2', 2)->nullable()->index()->after('photo_path');
            }
            if (! Schema::hasColumn('mosque_staff', 'dial_code')) {
                $table->string('dial_code', 10)->nullable()->index()->after('country_iso2'); // e.g. +880
            }
            if (! Schema::hasColumn('mosque_staff', 'phone_national')) {
                $table->string('phone_national', 30)->nullable()->after('dial_code'); // e.g. 01725177585
            }
            if (! Schema::hasColumn('mosque_staff', 'whatsapp_number')) {
                $table->string('whatsapp_number', 30)->nullable()->index()->after('phone_national'); // full number with country code
            }
            if (! Schema::hasColumn('mosque_staff', 'whatsapp_same_as_phone')) {
                $table->boolean('whatsapp_same_as_phone')->default(true)->index()->after('whatsapp_number');
            }
        });
    }

    public function down(): void
    {
        // Non-destructive: do not drop columns.
    }
};

