<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (! Schema::hasTable('mosque_payslips')) {
            return;
        }

        Schema::table('mosque_payslips', function (Blueprint $table) {
            if (! Schema::hasColumn('mosque_payslips', 'bonus_amount')) {
                $table->decimal('bonus_amount', 15, 4)->default(0)->after('gross');
            }
            if (! Schema::hasColumn('mosque_payslips', 'bonus_reason')) {
                $table->string('bonus_reason')->nullable()->after('bonus_amount');
            }
            if (! Schema::hasColumn('mosque_payslips', 'deduction_amount')) {
                $table->decimal('deduction_amount', 15, 4)->default(0)->after('bonus_reason');
            }
            if (! Schema::hasColumn('mosque_payslips', 'paid_amount')) {
                $table->decimal('paid_amount', 15, 4)->default(0)->after('net');
            }
            if (! Schema::hasColumn('mosque_payslips', 'payment_method')) {
                $table->string('payment_method', 50)->nullable()->index()->after('paid_amount');
            }
            if (! Schema::hasColumn('mosque_payslips', 'payment_ref_no')) {
                $table->string('payment_ref_no')->nullable()->after('payment_method');
            }
            if (! Schema::hasColumn('mosque_payslips', 'payment_note')) {
                $table->text('payment_note')->nullable()->after('payment_ref_no');
            }
        });
    }
};

