<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (! Schema::hasTable('mosque_payslips')) {
            return;
        }

        Schema::table('mosque_payslips', function (Blueprint $table) {
            if (! Schema::hasColumn('mosque_payslips', 'bonus_lines')) {
                $table->json('bonus_lines')->nullable()->after('bonus_reason');
            }
            if (! Schema::hasColumn('mosque_payslips', 'deduction_lines')) {
                $table->json('deduction_lines')->nullable()->after('deduction_amount');
            }
        });
    }
};

