<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (! Schema::hasTable('mosque_profiles')) {
            return;
        }

        Schema::table('mosque_profiles', function (Blueprint $table) {
            if (! Schema::hasColumn('mosque_profiles', 'phone')) {
                $table->string('phone')->nullable()->after('timezone');
            }
            if (! Schema::hasColumn('mosque_profiles', 'email')) {
                $table->string('email')->nullable()->after('phone');
            }
        });
    }

    public function down(): void
    {
        // Non-destructive: do not drop columns.
    }
};

