<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (! Schema::hasTable('mosque_staff_advances')) {
            Schema::create('mosque_staff_advances', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->unsignedInteger('business_id')->index();
                $table->unsignedBigInteger('staff_id')->index();
                $table->date('paid_on')->index();
                $table->decimal('amount', 15, 4)->default(0);
                $table->decimal('adjusted_amount', 15, 4)->default(0);
                $table->string('payment_method')->nullable()->index();
                $table->string('payment_ref_no')->nullable()->index();
                $table->text('note')->nullable();
                $table->unsignedInteger('created_by')->nullable()->index();
                $table->unsignedInteger('updated_by')->nullable()->index();
                $table->timestamps();
                $table->softDeletes();
            });
        } else {
            Schema::table('mosque_staff_advances', function (Blueprint $table) {
                if (! Schema::hasColumn('mosque_staff_advances', 'adjusted_amount')) {
                    $table->decimal('adjusted_amount', 15, 4)->default(0)->after('amount');
                }
                if (! Schema::hasColumn('mosque_staff_advances', 'payment_method')) {
                    $table->string('payment_method')->nullable()->index()->after('adjusted_amount');
                }
                if (! Schema::hasColumn('mosque_staff_advances', 'payment_ref_no')) {
                    $table->string('payment_ref_no')->nullable()->index()->after('payment_method');
                }
                if (! Schema::hasColumn('mosque_staff_advances', 'note')) {
                    $table->text('note')->nullable()->after('payment_ref_no');
                }
                if (! Schema::hasColumn('mosque_staff_advances', 'created_by')) {
                    $table->unsignedInteger('created_by')->nullable()->index()->after('note');
                }
                if (! Schema::hasColumn('mosque_staff_advances', 'updated_by')) {
                    $table->unsignedInteger('updated_by')->nullable()->index()->after('created_by');
                }
                if (! Schema::hasColumn('mosque_staff_advances', 'deleted_at')) {
                    $table->softDeletes();
                }
            });
        }

        if (! Schema::hasTable('mosque_staff_advance_adjustments')) {
            Schema::create('mosque_staff_advance_adjustments', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->unsignedInteger('business_id')->index();
                $table->unsignedBigInteger('advance_id')->index();
                $table->unsignedBigInteger('payslip_id')->index();
                $table->date('adjusted_on')->index();
                $table->decimal('amount', 15, 4)->default(0);
                $table->unsignedInteger('created_by')->nullable()->index();
                $table->timestamps();
            });
        }
    }

    public function down(): void
    {
        // Non-destructive: do not drop tables.
    }
};

