<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (!Schema::hasTable('mosque_leave_types')) {
            Schema::create('mosque_leave_types', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->integer('business_id')->index();
                $table->string('name');
                $table->boolean('is_paid')->default(true);
                $table->boolean('active')->default(true);
                $table->integer('created_by')->nullable();
                $table->timestamps();
                $table->softDeletes();

                $table->index(['business_id', 'active']);
            });
        }

        if (!Schema::hasTable('mosque_staff_leaves')) {
            Schema::create('mosque_staff_leaves', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->integer('business_id')->index();
                $table->unsignedBigInteger('staff_id')->index();
                $table->unsignedBigInteger('leave_type_id')->nullable()->index();
                $table->date('start_date')->index();
                $table->date('end_date')->index();
                $table->enum('status', ['pending', 'approved', 'rejected'])->default('pending')->index();
                $table->text('reason')->nullable();
                $table->integer('approved_by')->nullable();
                $table->timestamp('approved_at')->nullable();
                $table->integer('created_by')->nullable();
                $table->timestamps();
                $table->softDeletes();

                $table->index(['business_id', 'staff_id', 'status']);
                $table->index(['business_id', 'start_date', 'end_date']);
            });
        }
    }

    public function down(): void
    {
        // Non-destructive rule: do not drop tables.
    }
};

