<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (! Schema::hasTable('mosque_members')) {
            return;
        }

        Schema::table('mosque_members', function (Blueprint $table) {
            if (! Schema::hasColumn('mosque_members', 'whatsapp_number')) {
                $table->string('whatsapp_number')->nullable()->after('phone');
                $table->index(['business_id', 'whatsapp_number'], 'mosque_members_business_whatsapp_idx');
            }

            if (! Schema::hasColumn('mosque_members', 'whatsapp_same_as_phone')) {
                $table->boolean('whatsapp_same_as_phone')->default(true)->after('whatsapp_number');
            }
        });
    }

    public function down(): void
    {
        // Non-destructive: do not drop columns.
    }
};

