<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (Schema::hasTable('mosque_family_codes')) {
            return;
        }

        Schema::create('mosque_family_codes', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedInteger('business_id')->index();
            $table->string('code')->index();
            $table->boolean('active')->default(true)->index();
            $table->text('description')->nullable();
            $table->unsignedInteger('created_by')->nullable()->index();
            $table->timestamps();
            $table->softDeletes();

            $table->unique(['business_id', 'code'], 'mosque_family_codes_business_code_unique');
        });
    }

    public function down(): void
    {
        // Non-destructive: do not drop tables.
    }
};

