<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (Schema::hasTable('mosque_member_plan_assignments')) {
            return;
        }

        Schema::create('mosque_member_plan_assignments', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedBigInteger('business_id')->index();
            $table->unsignedBigInteger('member_id')->index();
            $table->unsignedBigInteger('plan_id')->index();
            $table->string('start_ym', 7)->nullable()->index(); // YYYY-MM
            $table->boolean('active')->default(true)->index();
            $table->unsignedBigInteger('created_by')->nullable();
            $table->unsignedBigInteger('updated_by')->nullable();
            $table->timestamps();

            $table->unique(['business_id', 'member_id'], 'mosque_member_plan_assignments_business_member_unique');
        });
    }

    public function down(): void
    {
        // Non-destructive: keep table if present.
    }
};

