<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (! Schema::hasTable('mosq_donation_goods')) {
            Schema::create('mosq_donation_goods', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->unsignedInteger('business_id')->index();
                $table->string('name');
                $table->string('unit')->nullable();
                $table->decimal('default_est_value', 20, 2)->nullable();
                $table->boolean('is_active')->default(true)->index();
                $table->timestamps();

                $table->index(['business_id', 'is_active']);
            });
        }

        if (! Schema::hasTable('mosq_pledges')) {
            Schema::create('mosq_pledges', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->unsignedInteger('business_id')->index();
                $table->unsignedInteger('location_id')->nullable()->index();
                $table->string('pledge_code', 50)->index();
                $table->unsignedBigInteger('donor_contact_id')->nullable()->index();
                $table->string('donor_name')->nullable();
                $table->string('donor_phone')->nullable()->index();
                $table->string('donor_email')->nullable();
                $table->enum('type', ['zakat', 'sadaqah', 'fitrah', 'general', 'event', 'waqf'])->index();
                $table->date('due_date')->nullable()->index();
                $table->enum('recurrence', ['oneoff', 'monthly', 'yearly'])->default('oneoff')->index();
                $table->decimal('est_total_value', 20, 2)->default(0);
                $table->char('currency', 3)->nullable()->index();
                $table->enum('status', ['draft', 'active', 'due_soon', 'overdue', 'partially_fulfilled', 'fulfilled', 'cancelled'])->default('draft')->index();
                $table->text('notes')->nullable();
                $table->unsignedInteger('created_by')->nullable()->index();
                $table->timestamps();

                $table->unique(['business_id', 'pledge_code'], 'mosq_pledges_business_code_unique');
                $table->index(['business_id', 'type', 'status']);
            });
        }

        if (! Schema::hasTable('mosq_pledge_items')) {
            Schema::create('mosq_pledge_items', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->unsignedBigInteger('pledge_id')->index();
                $table->enum('kind', ['cash', 'goods'])->index();
                $table->unsignedBigInteger('goods_id')->nullable()->index();
                $table->string('goods_name')->nullable();
                $table->string('unit')->nullable();
                $table->decimal('qty', 20, 3)->nullable();
                $table->decimal('est_unit_value', 20, 2)->nullable();
                $table->decimal('est_line_value', 20, 2)->nullable();
                $table->timestamps();

                $table->index(['pledge_id', 'kind']);
            });
        }

        if (! Schema::hasTable('mosq_pledge_fulfillments')) {
            Schema::create('mosq_pledge_fulfillments', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->unsignedBigInteger('pledge_id')->index();
                $table->date('date')->index();
                $table->enum('channel', ['cash', 'bank', 'card', 'online', 'mfs', 'in_kind'])->index();
                $table->decimal('amount_cash', 20, 2)->nullable();
                $table->string('goods_name')->nullable();
                $table->string('unit')->nullable();
                $table->decimal('qty', 20, 3)->nullable();
                $table->decimal('est_value', 20, 2)->nullable();
                $table->text('remarks')->nullable();
                $table->unsignedInteger('created_by')->nullable()->index();
                $table->timestamps();

                $table->index(['pledge_id', 'date']);
            });
        }
    }

    public function down(): void
    {
        // Non-destructive: do not drop tables.
    }
};

