<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (! Schema::hasTable('mosq_pledges')) {
            return;
        }

        if (! Schema::hasColumn('mosq_pledges', 'commitment_date')) {
            Schema::table('mosq_pledges', function (Blueprint $table) {
                $table->date('commitment_date')->nullable()->index()->after('type');
            });
        }
    }

    public function down(): void
    {
        // Non-destructive: do not drop columns.
    }
};

