<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (! Schema::hasTable('mosque_member_payments')) {
            return;
        }

        Schema::table('mosque_member_payments', function (Blueprint $table) {
            if (! Schema::hasColumn('mosque_member_payments', 'voided_at')) {
                $table->dateTime('voided_at')->nullable()->index();
            }
            if (! Schema::hasColumn('mosque_member_payments', 'voided_by')) {
                $table->unsignedBigInteger('voided_by')->nullable()->index();
            }
        });
    }

    public function down(): void
    {
        // Non-destructive: do not drop columns.
    }
};

