<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (Schema::hasTable('mosque_donor_profiles')) {
            Schema::table('mosque_donor_profiles', function (Blueprint $table) {
                if (! Schema::hasColumn('mosque_donor_profiles', 'whatsapp_number')) {
                    $table->string('whatsapp_number', 30)->nullable()->index()->after('phone');
                }
                if (! Schema::hasColumn('mosque_donor_profiles', 'whatsapp_same_as_phone')) {
                    $table->boolean('whatsapp_same_as_phone')->default(true)->index()->after('whatsapp_number');
                }
            });
        }
    }

    public function down(): void
    {
        // Non-destructive: do not drop columns.
    }
};

