<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (Schema::hasTable('mosque_donation_qr_requests')) {
            return;
        }

        Schema::create('mosque_donation_qr_requests', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedInteger('business_id')->index();

            $table->string('type', 20)->index();
            $table->string('channel', 20)->index();
            $table->decimal('amount', 22, 4);

            $table->boolean('anonymous')->default(false)->index();
            $table->string('donor_name')->nullable();
            $table->string('donor_email')->nullable();
            $table->string('donor_phone', 50)->nullable();
            $table->text('donor_address')->nullable();

            $table->string('transaction_ref', 120)->nullable()->index();
            $table->string('transaction_image_path')->nullable();
            $table->text('notes')->nullable();

            $table->string('status', 20)->default('pending')->index(); // pending|approved|rejected
            $table->unsignedBigInteger('approved_by')->nullable()->index();
            $table->dateTime('approved_at')->nullable()->index();
            $table->unsignedBigInteger('rejected_by')->nullable()->index();
            $table->dateTime('rejected_at')->nullable()->index();
            $table->text('reject_reason')->nullable();

            $table->unsignedBigInteger('donation_id')->nullable()->index();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        // Non-destructive: do not drop table.
    }
};

