<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (! Schema::hasTable('mosque_donation_links')) {
            return;
        }

        Schema::table('mosque_donation_links', function (Blueprint $table) {
            if (! Schema::hasColumn('mosque_donation_links', 'regenerate_count')) {
                $table->unsignedInteger('regenerate_count')->default(0)->after('enabled');
            }
            if (! Schema::hasColumn('mosque_donation_links', 'regenerated_at')) {
                $table->dateTime('regenerated_at')->nullable()->after('regenerate_count');
            }
        });
    }

    public function down(): void
    {
        // Non-destructive: do not drop columns.
    }
};

