<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (Schema::hasTable('mosque_bank_accounts')) {
            return;
        }

        Schema::create('mosque_bank_accounts', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedInteger('business_id')->index();
            $table->string('bank_name')->index();
            $table->string('account_no')->index();
            $table->string('account_holder')->nullable()->index();
            $table->text('notes')->nullable();
            $table->boolean('is_active')->default(true)->index();
            $table->unsignedInteger('created_by')->nullable()->index();
            $table->timestamps();
            $table->softDeletes();

            $table->index(['business_id', 'bank_name']);
        });
    }

    public function down(): void
    {
        // Non-destructive: do not drop table.
    }
};

