<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (Schema::hasTable('mosque_bank_wallet_transactions')) {
            return;
        }

        Schema::create('mosque_bank_wallet_transactions', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedInteger('business_id')->index();
            $table->unsignedBigInteger('bank_account_id')->index();
            $table->enum('direction', ['credit', 'debit'])->index();
            $table->decimal('amount', 15, 4)->default(0);
            $table->date('txn_date')->index();
            $table->string('ref_module')->nullable()->index();
            $table->unsignedBigInteger('ref_id')->nullable()->index();
            $table->text('note')->nullable();
            $table->unsignedInteger('created_by')->nullable()->index();
            $table->timestamps();

            $table->index(['business_id', 'bank_account_id', 'txn_date'], 'mbwt_biz_bank_date_idx');
        });
    }

    public function down(): void
    {
        // Non-destructive: do not drop table.
    }
};
