<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (Schema::hasTable('mosque_net_bank_transfers')) {
            return;
        }

        Schema::create('mosque_net_bank_transfers', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedInteger('business_id')->index();
            $table->unsignedBigInteger('bank_account_id')->index();
            $table->decimal('amount', 15, 4)->default(0);
            $table->date('transfer_date')->index();
            $table->text('note')->nullable();
            $table->enum('status', ['completed', 'voided'])->default('completed')->index();
            $table->unsignedInteger('created_by')->nullable()->index();
            $table->unsignedInteger('voided_by')->nullable()->index();
            $table->dateTime('voided_at')->nullable()->index();
            $table->timestamps();

            $table->index(['business_id', 'transfer_date'], 'mnbt_biz_date_idx');
        });
    }

    public function down(): void
    {
        // Non-destructive: do not drop table.
    }
};
