<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (Schema::hasTable('mosque_bank_cashout_requests')) {
            return;
        }

        Schema::create('mosque_bank_cashout_requests', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedInteger('business_id')->index();
            $table->unsignedBigInteger('bank_account_id')->index();
            $table->string('request_no', 64)->nullable()->index();
            $table->decimal('amount', 15, 4)->default(0);
            $table->date('request_date')->index();
            $table->text('reason')->nullable();
            $table->string('attachment_path')->nullable();
            $table->enum('status', ['pending', 'approved', 'rejected', 'cancelled'])->default('pending')->index();

            $table->unsignedInteger('requested_by')->nullable()->index();
            $table->dateTime('requested_at')->nullable()->index();

            $table->unsignedInteger('approved_by')->nullable()->index();
            $table->dateTime('approved_at')->nullable()->index();

            $table->unsignedInteger('rejected_by')->nullable()->index();
            $table->dateTime('rejected_at')->nullable()->index();
            $table->text('reject_reason')->nullable();

            $table->unsignedBigInteger('finance_entry_id')->nullable()->index();
            $table->timestamps();
            $table->softDeletes();

            $table->index(['business_id', 'bank_account_id', 'status'], 'mbcr_biz_bank_status_idx');
        });
    }

    public function down(): void
    {
        // Non-destructive: do not drop table.
    }
};
