<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (! Schema::hasTable('mosque_bank_wallet_transactions')) {
            return;
        }

        $existing = [];
        try {
            $rows = DB::select("SHOW INDEX FROM mosque_bank_wallet_transactions");
            foreach ($rows as $r) {
                if (isset($r->Key_name)) {
                    $existing[(string) $r->Key_name] = true;
                }
            }
        } catch (\Throwable $e) {
            $existing = [];
        }

        if (! isset($existing['mbwt_biz_bank_date_idx'])) {
            Schema::table('mosque_bank_wallet_transactions', function (Blueprint $table) {
                $table->index(['business_id', 'bank_account_id', 'txn_date'], 'mbwt_biz_bank_date_idx');
            });
        }
    }

    public function down(): void
    {
        // Non-destructive: do not drop indexes.
    }
};

