<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (! Schema::hasTable('mosque_committee_members')) {
            return;
        }

        if (! Schema::hasColumn('mosque_committee_members', 'role_id')) {
            Schema::table('mosque_committee_members', function (Blueprint $table) {
                $table->unsignedBigInteger('role_id')->nullable()->index()->after('role_title');
            });
        }
    }

    public function down(): void
    {
        // Non-destructive: do not drop column.
    }
};

