<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (! Schema::hasTable('mosque_committee_members')) {
            return;
        }

        Schema::table('mosque_committee_members', function (Blueprint $table) {
            if (! Schema::hasColumn('mosque_committee_members', 'id_doc_type')) {
                $table->string('id_doc_type', 32)->nullable()->index()->after('role_id');
            }
            if (! Schema::hasColumn('mosque_committee_members', 'id_doc_no')) {
                $table->string('id_doc_no', 64)->nullable()->index()->after('id_doc_type');
            }
            if (! Schema::hasColumn('mosque_committee_members', 'id_doc_path')) {
                $table->string('id_doc_path')->nullable()->after('id_doc_no');
            }
            if (! Schema::hasColumn('mosque_committee_members', 'card_no')) {
                $table->string('card_no', 64)->nullable()->index()->after('id_doc_path');
            }
        });
    }

    public function down(): void
    {
        // Non-destructive: do not drop columns.
    }
};

